/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processtest.api.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.godaxe.processtest.api.VariableApiService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ConfiguredInstanceVariableQueryDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ProcessListDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.ProcessInstModel;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.TestVariable;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.ProcessBetaService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.VariableService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.vo.AllVariablesConfiguredInProcessVo;
import com.jxdinfo.hussar.workflow.manage.bpm.flowchart.FlowChartCommonDto;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VariableWorkflowTestApiService
implements VariableApiService {
    @Autowired
    VariableService variableService;
    @Autowired
    ProcessBetaService processBetaService;

    public ApiResponse<AllVariablesConfiguredInProcessVo> getAllVariablesConfiguredInMainProcess(String processKey, String processVersion, String organId) {
        return this.variableService.getAllVariablesConfiguredInMainProcess(processKey, processVersion, organId);
    }

    public ApiResponse<JSONObject> getAllVariablesConfiguredInSubProcessAndBindingInfo(ConfiguredInstanceVariableQueryDto configuredInstanceVariableQuery) {
        return this.variableService.getAllVariablesConfiguredInSubProcessAndBindingInfo(configuredInstanceVariableQuery);
    }

    public ApiResponse<IPage<ProcessInstModel>> getProcessBetaList(Page<ProcessInstModel> page, ProcessListDto processListDto) {
        return ApiResponse.success((Object)this.processBetaService.getProcessBetaList(page, processListDto));
    }

    public ApiResponse<Map<String, Object>> list(FlowChartCommonDto flowChartCommonDto) {
        return ApiResponse.success((Object)this.processBetaService.list(flowChartCommonDto.getProcessInsId(), flowChartCommonDto.getBusinessId(), flowChartCommonDto.getSubProcessKey(), flowChartCommonDto.getCycleCount()));
    }

    public ApiResponse<JSONObject> getProcessInfoForProcessTesting(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        return this.processBetaService.getProcessInfoForProcessTesting(processInsId, businessId, subProcessKey, cycleCount);
    }

    public ApiResponse<JSONObject> getProcessInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        return ApiResponse.success((Object)this.processBetaService.getProcessInfo(processInsId, businessId, subProcessKey, cycleCount));
    }

    public ApiResponse<JSONArray> getProcessCompleteInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        return ApiResponse.success((Object)this.processBetaService.getProcessCompleteInfo(processInsId, businessId, subProcessKey, cycleCount));
    }

    public ApiResponse<JSONObject> getSubProcessRunningInfoForProcessTesting(String processInsId, String businessId) {
        return this.processBetaService.getSubProcessRunningInfoForProcessTesting(processInsId, businessId);
    }

    public ApiResponse<JSONObject> getSubProcessRunningInfo(String processInsId, String businessId) {
        return ApiResponse.success((Object)this.processBetaService.getSubProcessRunningInfo(processInsId, businessId));
    }

    public ApiResponse<Map<String, Object>> subProcessList(String supProcessInsId, String businessId, String taskDefinitionKey, Integer page, Integer size) {
        return ApiResponse.success((Object)this.processBetaService.subProcessList(supProcessInsId, businessId, taskDefinitionKey, page, size));
    }

    public ApiResponse<String> deleteFinishedProcessInstance(String processInstCode) {
        return this.processBetaService.deleteFinishedProcessInstance(processInstCode);
    }

    public ApiResponse<String> deleteProcessInstance(List<String> processInsId) {
        return this.processBetaService.deleteProcessInstance(processInsId);
    }

    public ApiResponse<AllVariablesConfiguredInProcessVo> findVariableById(String processInsId) {
        TestVariable variable = (TestVariable)this.variableService.getById((Serializable)Long.valueOf(processInsId));
        AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcessVo = new AllVariablesConfiguredInProcessVo();
        if (variable != null && HussarUtils.isNotEmpty((Object)variable.getVariable())) {
            allVariablesConfiguredInProcessVo = (AllVariablesConfiguredInProcessVo)JSONObject.parseObject((String)variable.getVariable(), AllVariablesConfiguredInProcessVo.class);
        }
        return ApiResponse.success((Object)allVariablesConfiguredInProcessVo);
    }
}

