/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.msg.contact.dto.MsgContactIdAndTypeDto;
import com.jxdinfo.hussar.msg.push.dto.AppServiceDto;
import com.jxdinfo.hussar.msg.push.service.PushMsgService;
import com.jxdinfo.hussar.msg.qingtui.dto.QingTuiSendDto;
import com.jxdinfo.hussar.msg.qingtui.model.MsgQingTuiTemplate;
import com.jxdinfo.hussar.msg.qingtui.service.QtTemplate4WorkFlowService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.push.config.BpmMsgProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class BpmMsgPushServiceImpl
implements BpmMsgPushService {
    private static final Logger logger = LoggerFactory.getLogger(BpmMsgPushServiceImpl.class);
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private BpmMsgProperties bpmMsgProperties;
    @Autowired(required=false)
    private PushMsgService pushMsgService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Lazy
    @Autowired
    private ModelService modelService;
    @Autowired(required=false)
    private QtTemplate4WorkFlowService qtTemplate4WorkFlowService;
    private static final String USER_SEND_ID = "userSendId";
    private static final String MSG_WEB_URL = "msgWebUrl";
    private static final String MSG_MOBILE_URL = "msgMobileUrl";
    private static final String MODEL_TYPE = "modelType";
    private static final String ZNX = "station_message";
    private static final String OPEN_WAY = "openWay";
    private static final String USER_IDS = "userIds";
    public static final List<String> PUSH_WITH_CONTACT_TYPE = new ArrayList<String>();
    public static final List<String> PUSH_WITHOUT_CONTACT_TYPE = new ArrayList<String>();

    public void pushMessage(List<BpmActMsgDetail> bpmActMsgDetailList) {
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(bpmActMsgDetailList, BpmActMsgDetail.class).translate(BpmActMsgDetail::getProcessNameTranslateKey, BpmActMsgDetail::setProcessName).translate(BpmActMsgDetail::getNodeNameTranslateKey, BpmActMsgDetail::setTaskDefName).isDefaultLang().execute();
        if (!this.lcdpBpmProperties.isEnableMessageService()) {
            return;
        }
        this.setAppIdAndAppSecret(bpmActMsgDetailList);
        for (BpmActMsgDetail bpmActMsgDetail : bpmActMsgDetailList) {
            if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getChannelType())) {
                this.setChannelType(bpmActMsgDetail);
                if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getChannelType())) break;
            }
            if (!this.verifyInputMessage(bpmActMsgDetail)) break;
            this.setMessageData(bpmActMsgDetail);
            this.setUserMsg(bpmActMsgDetail);
            String tenantCode = HussarContextHolder.getHussarTenant().getTenantCode();
            MsgUnitySendDto msgUnitySendDto = new MsgUnitySendDto();
            msgUnitySendDto.setTenantCode(tenantCode);
            msgUnitySendDto.setSceneCode(bpmActMsgDetail.getSceneCode());
            ArrayList<MsgContactIdAndTypeDto> list = new ArrayList<MsgContactIdAndTypeDto>();
            for (String userId : bpmActMsgDetail.getReceive()) {
                MsgContactIdAndTypeDto msgContactIdAndTypeDto = new MsgContactIdAndTypeDto();
                msgContactIdAndTypeDto.setContactId(userId);
                msgContactIdAndTypeDto.setContactType("user");
                list.add(msgContactIdAndTypeDto);
            }
            msgUnitySendDto.setContacts(list);
            String[] channelTypes = bpmActMsgDetail.getChannelType().split(",");
            ArrayList<String> sendTypeList = new ArrayList<String>(Arrays.asList(channelTypes));
            if (sendTypeList.contains("qingTui")) {
                QingTuiSendDto qingTuiSendDto = new QingTuiSendDto();
                List receive = bpmActMsgDetail.getReceive();
                for (int i = 0; i < bpmActMsgDetail.getReceive().size(); i += 10) {
                    BpmActMsgDetail qtBpmActMsgDetail = bpmActMsgDetail.clone();
                    if (qtBpmActMsgDetail == null) continue;
                    ArrayList receiveChild = new ArrayList();
                    for (int j = i; j < i + 10 && j < bpmActMsgDetail.getReceive().size(); ++j) {
                        receiveChild.add(receive.get(j));
                    }
                    qtBpmActMsgDetail.setReceive(receiveChild);
                    this.setQtAttr(qtBpmActMsgDetail, qingTuiSendDto);
                    this.pushMsgService.sendQingTuiMsg(qingTuiSendDto);
                }
                sendTypeList.remove("qingTui");
            }
            msgUnitySendDto.setSendTypes(sendTypeList);
            msgUnitySendDto.setTemplateParams(bpmActMsgDetail.getMessageData());
            String modelType = this.modelService.getProcessModelType(bpmActMsgDetail.getProcessKey());
            HashMap<String, Object> incompleteTemplateParams = new HashMap<String, Object>();
            incompleteTemplateParams.put(USER_SEND_ID, bpmActMsgDetail.getSendUserId() == null ? null : Long.valueOf(bpmActMsgDetail.getSendUserId()));
            incompleteTemplateParams.put(MSG_WEB_URL, bpmActMsgDetail.getWebFinalUrl() == null ? "" : bpmActMsgDetail.getWebFinalUrl());
            incompleteTemplateParams.put(MSG_MOBILE_URL, bpmActMsgDetail.getMobileFinalUrl() == null ? "" : bpmActMsgDetail.getMobileFinalUrl());
            incompleteTemplateParams.put(MODEL_TYPE, modelType == null ? "1" : modelType);
            ArrayList<String> otherSendTypeList = new ArrayList<String>(sendTypeList);
            otherSendTypeList.retainAll(PUSH_WITHOUT_CONTACT_TYPE);
            if (!otherSendTypeList.isEmpty()) {
                sendTypeList.removeAll(PUSH_WITHOUT_CONTACT_TYPE);
                MsgUnitySendDto otherMsgUnitySendDto = new MsgUnitySendDto();
                otherMsgUnitySendDto.setTenantCode(tenantCode);
                otherMsgUnitySendDto.setSceneCode(bpmActMsgDetail.getSceneCode());
                otherMsgUnitySendDto.setSendTypes(otherSendTypeList);
                HashMap<String, String> otherReceiveAddress = new HashMap<String, String>();
                otherMsgUnitySendDto.setReceiveAddress(otherReceiveAddress);
                otherMsgUnitySendDto.setTemplateParams(bpmActMsgDetail.getMessageData());
                for (String pushType : otherSendTypeList) {
                    otherMsgUnitySendDto.putExtendParams(pushType, incompleteTemplateParams);
                    if (!"sms".equals(pushType) && !"mail".equals(pushType)) {
                        otherReceiveAddress.put(pushType, String.join((CharSequence)",", bpmActMsgDetail.getReceive()));
                    }
                    if (!ZNX.equals(pushType)) continue;
                    Map stationParam = (Map)otherMsgUnitySendDto.getExtendParams(ZNX);
                    String stationOpenWay = this.lcdpBpmProperties.getStationOpenWay();
                    stationParam.put(OPEN_WAY, stationOpenWay);
                    if (!"2".equals(stationOpenWay) || !"0".equals(modelType)) continue;
                    StringBuilder dialogMsgWebUrl = new StringBuilder();
                    String webFinalUrl = bpmActMsgDetail.getWebFinalUrl();
                    if (HussarUtils.isNotEmpty((Object)webFinalUrl)) {
                        String[] webUrlList = webFinalUrl.split("#");
                        dialogMsgWebUrl.append(this.lcdpBpmProperties.getFrontIp()).append(webUrlList[0]).append("&noFrame=1&isDialog=1").append("#").append(webUrlList[1]).append("&containInfo={'size':{'width':1440,'height':756},'title':'").append(bpmActMsgDetail.getProcessName()).append("'}");
                    }
                    stationParam.put(MSG_WEB_URL, dialogMsgWebUrl.toString());
                }
                ArrayList smsList = new ArrayList();
                ArrayList mailList = new ArrayList();
                ArrayList<String> mailUserIdList = new ArrayList<String>();
                for (String receiver : bpmActMsgDetail.getReceive()) {
                    Map receiverMsg = (Map)bpmActMsgDetail.getUserMsg().get(receiver);
                    if (receiverMsg == null) continue;
                    if (otherSendTypeList.contains("sms") && HussarUtils.isNotEmpty(receiverMsg.get("mobile"))) {
                        smsList.add(receiverMsg.get("mobile"));
                    }
                    if (!otherSendTypeList.contains("mail") || !HussarUtils.isNotEmpty(receiverMsg.get("email"))) continue;
                    mailUserIdList.add(receiver);
                    mailList.add(receiverMsg.get("email"));
                }
                if (HussarUtils.isNotEmpty(mailUserIdList)) {
                    Map mailParam = (Map)otherMsgUnitySendDto.getExtendParams("mail");
                    mailParam.put(USER_IDS, String.join((CharSequence)",", mailUserIdList));
                }
                if (!smsList.isEmpty()) {
                    otherReceiveAddress.put("sms", String.join((CharSequence)",", smsList));
                }
                if (!mailList.isEmpty()) {
                    otherReceiveAddress.put("mail", String.join((CharSequence)",", mailList));
                }
                if (!otherReceiveAddress.isEmpty()) {
                    logger.info("\u5de5\u4f5c\u6d41\u5f00\u59cb\u63a8\u9001\u77ed\u4fe1/\u90ae\u4ef6/\u7ad9\u5185\u4fe1\uff0c\u6b64\u6b21\u63a8\u9001\u7684\u6d88\u606f\u7c7b\u578b: {}", (Object)JSON.toJSONString(otherSendTypeList));
                    this.pushMsgService.unitySendMessage(otherMsgUnitySendDto);
                }
            }
            if (sendTypeList.size() <= 0) continue;
            for (String pushType : sendTypeList) {
                msgUnitySendDto.putExtendParams(pushType, incompleteTemplateParams);
            }
            logger.info("\u5de5\u4f5c\u6d41\u5f00\u59cb\u63a8\u9001APP\u901a\u77e5/\u4f01\u5fae/\u9489\u9489/IM\uff0c\u6b64\u6b21\u63a8\u9001\u7684\u6d88\u606f\u7c7b\u578b: {}", (Object)JSON.toJSONString(sendTypeList));
            this.pushMsgService.unitySendMessage(msgUnitySendDto);
        }
    }

    private void setQtAttr(BpmActMsgDetail bpmActMsgDetail, QingTuiSendDto sendDto) {
        sendDto.setSceneCode(bpmActMsgDetail.getSceneCode());
        sendDto.setReceiver(bpmActMsgDetail.getReceive());
        sendDto.setAppId(bpmActMsgDetail.getAppId());
        sendDto.setAppSecret(bpmActMsgDetail.getAppSecret());
        sendDto.setTaskId(bpmActMsgDetail.getTaskId());
        String sceneCode = bpmActMsgDetail.getSceneCode();
        MsgQingTuiTemplate msgQingTuiTemplate = this.qtTemplate4WorkFlowService.find4WorkFlow(sceneCode, "qingTui");
        sendDto.setData(this.convertRegex(msgQingTuiTemplate.getContent(), bpmActMsgDetail.getMessageData()));
        sendDto.setMsgType(msgQingTuiTemplate.getMsgType());
    }

    private String convertRegex(String source, Map<String, String> data) {
        String target = source;
        if (HussarUtils.isNotEmpty(data)) {
            for (String key : data.keySet()) {
                target = target.replaceAll("\\#\\{" + key + "\\}", HussarUtils.isNotEmpty((Object)data.get(key)) ? data.get(key) : "");
            }
        }
        return target;
    }

    private void setAppIdAndAppSecret(List<BpmActMsgDetail> bpmActMsgDetailList) {
        if (HussarUtils.isNotEmpty(bpmActMsgDetailList)) {
            String appId = this.bpmMsgProperties.getAppId();
            String appSecret = this.bpmMsgProperties.getAppSecret();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (BpmActMsgDetail bpmActMsgDetail : bpmActMsgDetailList) {
                bpmActMsgDetail.setAppId(appId);
                bpmActMsgDetail.setAppSecret(appSecret);
                bpmActMsgDetail.setCurrentTime(sdf.format(new Date()));
            }
        }
    }

    private boolean verifyInputMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getSceneCode())) {
            logger.error("\u7f3a\u5c11\u573a\u666f\u7c7b\u578b\uff01");
            return false;
        }
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getProcessKey())) {
            logger.error("\u7f3a\u5c11\u6d41\u7a0b\u6807\u8bc6\uff01");
            return false;
        }
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getReceive())) {
            logger.error("\u6d41\u7a0b[{}],{},\u7f3a\u5c11\u7528\u6237id\uff01", (Object)bpmActMsgDetail.getProcessKey(), (Object)bpmActMsgDetail.getSceneCode());
            return false;
        }
        return true;
    }

    private void setUserMsg(BpmActMsgDetail bpmActMsgDetail) {
        List bpmUserInfoVos = this.iAssigneeChooseService.getUserMsgByUserIds(bpmActMsgDetail.getReceive());
        logger.info("\u83b7\u53d6\u6d88\u606f\u53d1\u9001\u4eba\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)bpmUserInfoVos));
        HashMap<String, Object> userMsg = new HashMap<String, Object>();
        for (BpmUserInfoVo bpmUserInfoVo : bpmUserInfoVos) {
            userMsg.put(bpmUserInfoVo.getId(), JSON.parseObject((String)JSON.toJSONString((Object)bpmUserInfoVo), Map.class));
        }
        bpmActMsgDetail.setUserMsg(userMsg);
    }

    private void setMessageData(BpmActMsgDetail bpmActMsgDetail) {
        Map<Object, Object> messageData = new HashMap();
        switch (bpmActMsgDetail.getSceneCode()) {
            case "todo": {
                bpmActMsgDetail.setMessage("\u60a8\u4e8e#{currentTime}\u6536\u5230#{processName}\u6d41\u7a0b\u7684\u5f85\u529e\u4efb\u52a1\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u5f85\u529e\u63d0\u9192");
                messageData = this.assembleMessageData(bpmActMsgDetail);
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getTodoSceneCode());
                break;
            }
            case "reject": {
                bpmActMsgDetail.setMessage("\u60a8\u4e8e#{currentTime}\u6536\u5230#{processName}\u6d41\u7a0b\u7684\u9a73\u56de\u4efb\u52a1\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u9a73\u56de\u63d0\u9192");
                messageData = this.assembleMessageData(bpmActMsgDetail);
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getRejectSceneCode());
                break;
            }
            case "reminders": {
                bpmActMsgDetail.setMessage("\u60a8\u4e8e#{currentTime}\u6536\u5230#{processName}\u6d41\u7a0b\uff0c#{taskName}\u4efb\u52a1\u7684\u50ac\u529e\u6d88\u606f\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u50ac\u529e\u63d0\u9192");
                messageData = this.assembleMessageData(bpmActMsgDetail);
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getRemindersSceneCode());
                break;
            }
            case "entrust": {
                Map msgData = bpmActMsgDetail.getMessageData();
                msgData.put("currentTime", bpmActMsgDetail.getCurrentTime());
                bpmActMsgDetail.setMessageData(msgData);
                bpmActMsgDetail.setMessage("\u60a8\u4e8e#{currentTime}\u6536\u5230#{processName}\u6d41\u7a0b\u7684\u59d4\u6258\uff0c\u59d4\u6258\u65f6\u95f4#{startTime}\u81f3#{endTime}\uff0c\u540e\u7eed\u76f8\u5173\u4efb\u52a1\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u59d4\u6258\u63d0\u9192");
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getEntrustSceneCode());
                break;
            }
            case "complete": {
                bpmActMsgDetail.setMessage("\u60a8\u63d0\u4ea4\u7684#{processName}\u6d41\u7a0b\u5df2\u4e8e#{currentTime}\u5ba1\u6279\u5b8c\u6210\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\u6d41\u7a0b\u7ed3\u679c\u3002");
                bpmActMsgDetail.setMessageType("\u6d41\u7a0b\u5b8c\u6210\u63d0\u9192");
                messageData = this.assembleMessageData(bpmActMsgDetail);
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getCompleteSceneCode());
                break;
            }
            case "terminated": {
                bpmActMsgDetail.setMessage("\u60a8\u63d0\u4ea4\u7684#{processName}\u6d41\u7a0b\u5df2\u4e8e#{currentTime}\u7ec8\u6b62\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\u6d41\u7a0b\u7ed3\u679c\u3002");
                bpmActMsgDetail.setMessageType("\u6d41\u7a0b\u7ec8\u6b62\u63d0\u9192");
                messageData = this.assembleMessageData(bpmActMsgDetail);
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getTerminatedSceneCode());
                break;
            }
            case "exception": {
                bpmActMsgDetail.setMessage("#{processName} \u6d41\u7a0b\u5728\u8fd0\u884c\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u7c7b\u578b\uff1a#{expType}\uff0c\u6d41\u7a0b\u6807\u8bc6\uff1a#{processKey}\uff0c\u8282\u70b9\u6807\u8bc6\uff1a#{taskKey}\uff0c \u8282\u70b9\u540d\uff1a#{taskName}\uff0c\u8bf7\u53ca\u65f6\u6392\u67e5\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u6d41\u7a0b\u5f02\u5e38\u63d0\u9192");
                messageData = this.assembleMessageData(bpmActMsgDetail);
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getExceptionSceneCode());
                break;
            }
            case "timeout": {
                bpmActMsgDetail.setMessage("\u60a8\u6709\u4e00\u6761#{processName} \u6d41\u7a0b\u5df2\u4e8e#{duedate}\u8d85\u65f6\uff0c\u8d85\u65f6\u5904\u7406\u65b9\u5f0f\uff1a#{timeOutType}\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u6d41\u7a0b\u8d85\u65f6\u63d0\u9192");
                messageData = this.assembleMessageData(bpmActMsgDetail);
                bpmActMsgDetail.setMessageData(messageData);
                String timeOutSceneCode = this.bpmMsgProperties.getTimeOutSceneCode();
                bpmActMsgDetail.setSceneCode(timeOutSceneCode);
                break;
            }
            case "timeout_warning": {
                bpmActMsgDetail.setMessage("\u60a8\u6709\u4e00\u6761#{processName} \u6d41\u7a0b\u5c06\u4e8e#{duedate}\u8d85\u65f6\uff0c\u8d85\u65f6\u5904\u7406\u65b9\u5f0f\uff1a#{timeOutType}\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u6d41\u7a0b\u8d85\u65f6\u9884\u8b66\u63d0\u9192");
                messageData = this.assembleMessageData(bpmActMsgDetail);
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getTimeOutWarningSceneCode());
                break;
            }
        }
    }

    public Map<String, String> assembleMessageData(BpmActMsgDetail bpmActMsgDetail) {
        HashMap<String, String> messageData = new HashMap<String, String>();
        messageData.put("processName", bpmActMsgDetail.getProcessName() == null ? "" : bpmActMsgDetail.getProcessName());
        messageData.put("title", bpmActMsgDetail.getProcessTitle() == null ? "" : bpmActMsgDetail.getProcessTitle());
        messageData.put("subTitle", bpmActMsgDetail.getDataDetail() == null ? "" : bpmActMsgDetail.getDataDetail());
        messageData.put("webFormAddress", bpmActMsgDetail.getWebFormAddress() == null ? "" : bpmActMsgDetail.getWebFormAddress());
        messageData.put("mobileFormAddress", bpmActMsgDetail.getMobileFormAddress() == null ? "" : bpmActMsgDetail.getMobileFormAddress());
        messageData.put("webFromDetailAddress", bpmActMsgDetail.getWebFormDetailAddress() == null ? "" : bpmActMsgDetail.getWebFormDetailAddress());
        messageData.put("mobileFormDetailAddress", bpmActMsgDetail.getMobileFormDetailAddress() == null ? "" : bpmActMsgDetail.getMobileFormDetailAddress());
        messageData.put("businessId", bpmActMsgDetail.getBusinessId() == null ? "" : bpmActMsgDetail.getBusinessId());
        messageData.put("taskId", bpmActMsgDetail.getTaskId() == null ? "" : bpmActMsgDetail.getTaskId());
        messageData.put("processDefinitionKey", bpmActMsgDetail.getProcessKey() == null ? "" : bpmActMsgDetail.getProcessKey());
        messageData.put("processKey", bpmActMsgDetail.getProcessKey() == null ? "" : bpmActMsgDetail.getProcessKey());
        messageData.put("taskDefinitionKey", bpmActMsgDetail.getTaskDefKey() == null ? "" : bpmActMsgDetail.getTaskDefKey());
        messageData.put("taskKey", bpmActMsgDetail.getTaskDefKey() == null ? "" : bpmActMsgDetail.getTaskDefKey());
        messageData.put("portalAppId", bpmActMsgDetail.getPortalAppId() == null ? "" : bpmActMsgDetail.getPortalAppId());
        messageData.put("formId", bpmActMsgDetail.getFormId() == null ? "" : bpmActMsgDetail.getFormId());
        messageData.put("processInstanceId", bpmActMsgDetail.getProcessInstanceId() == null ? "" : bpmActMsgDetail.getProcessInstanceId());
        messageData.put("tabType", bpmActMsgDetail.getTabType() == null ? "" : bpmActMsgDetail.getTabType());
        messageData.put("taskName", bpmActMsgDetail.getTaskDefName() == null ? "" : bpmActMsgDetail.getTaskDefName());
        messageData.put("currentTime", bpmActMsgDetail.getCurrentTime() == null ? "" : bpmActMsgDetail.getCurrentTime());
        messageData.put("expType", bpmActMsgDetail.getExceptionMsg() == null ? "" : bpmActMsgDetail.getExceptionMsg());
        messageData.put("expMsg", bpmActMsgDetail.getExceptionMsg() == null ? "" : bpmActMsgDetail.getExceptionMsg());
        messageData.put("sendUserId", bpmActMsgDetail.getSendUserId() == null ? "" : bpmActMsgDetail.getSendUserId());
        messageData.put("sendUserName", bpmActMsgDetail.getSendUserName() == null ? "" : bpmActMsgDetail.getSendUserName());
        messageData.put("startUserId", bpmActMsgDetail.getStartUserId() == null ? "" : bpmActMsgDetail.getStartUserId());
        messageData.put("startUserName", bpmActMsgDetail.getStartUserName() == null ? "" : bpmActMsgDetail.getStartUserName());
        messageData.put("todoConfiguration", bpmActMsgDetail.getTodoConfiguration() == null ? "" : bpmActMsgDetail.getTodoConfiguration());
        messageData.put("dueDate", bpmActMsgDetail.getDueDate() == null ? "" : bpmActMsgDetail.getDueDate());
        messageData.put("timeOutType", bpmActMsgDetail.getTimeOutType() == null ? "" : bpmActMsgDetail.getTimeOutType());
        messageData.put("processMode", bpmActMsgDetail.getTimeOutMessage() == null ? "" : bpmActMsgDetail.getTimeOutMessage());
        return messageData;
    }

    private void setChannelType(BpmActMsgDetail bpmActMsgDetail) {
        SysActAssignee sysActAssignee;
        int version = Integer.parseInt(bpmActMsgDetail.getProcessDefinitionId().split(":")[1]);
        List sysActAssignees = this.sysActAssigneeService.getAssignee(bpmActMsgDetail.getProcessKey(), bpmActMsgDetail.getTaskDefKey(), 4, version);
        SysActAssignee sysActAssignee2 = sysActAssignee = HussarUtils.isNotEmpty((Object)sysActAssignees) ? (SysActAssignee)sysActAssignees.get(0) : null;
        if (HussarUtils.isNotEmpty((Object)sysActAssignee)) {
            bpmActMsgDetail.setChannelType(sysActAssignee.getMessageType());
        } else {
            bpmActMsgDetail.setChannelType(null);
        }
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getChannelType())) {
            if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getProcessDefinitionId())) {
                logger.error("\u6d88\u606f\u63a8\u9001\uff0c\u7f3a\u5c11\u6d41\u7a0b\u5b9a\u4e49id\uff01");
                return;
            }
            RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getBean(RepositoryService.class);
            BpmnModel bm = repositoryService.getBpmnModel(bpmActMsgDetail.getProcessDefinitionId());
            if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getTaskDefKey())) {
                String target = "";
                for (FlowElement flowElement : ((Process)bm.getProcesses().get(0)).getFlowElements()) {
                    if (!(flowElement instanceof StartEvent)) continue;
                    target = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
                    break;
                }
                for (FlowElement flowElement : ((Process)bm.getProcesses().get(0)).getFlowElements()) {
                    if (!flowElement.getId().equals(target) || flowElement.getExtensionElements().get("messageType") == null) continue;
                    List list = (List)((ExtensionElement)((List)flowElement.getExtensionElements().get("messageType")).get(0)).getAttributes().get("messageType");
                    bpmActMsgDetail.setChannelType(HussarUtils.isNotEmpty((Object)list) ? ((ExtensionAttribute)list.get(0)).getValue() : null);
                    break;
                }
            } else {
                Map extensionElementsNode = bm.getFlowElement(bpmActMsgDetail.getTaskDefKey()).getExtensionElements();
                if (extensionElementsNode.get("messageType") != null) {
                    List list = (List)((ExtensionElement)((List)extensionElementsNode.get("messageType")).get(0)).getAttributes().get("messageType");
                    bpmActMsgDetail.setChannelType(HussarUtils.isNotEmpty((Object)list) ? ((ExtensionAttribute)list.get(0)).getValue() : null);
                }
            }
        }
    }

    public BpmResponseResult getBpmActChannel(String sceneCategory) {
        if (HussarUtils.isEmpty((Object)this.pushMsgService) || !this.lcdpBpmProperties.isEnableMessageService()) {
            return InstallResult.success();
        }
        AppServiceDto appServiceDto = new AppServiceDto();
        appServiceDto.setAppId(this.bpmMsgProperties.getAppId());
        appServiceDto.setAppSecret(this.bpmMsgProperties.getAppSecret());
        appServiceDto.setSceneCategory(sceneCategory);
        try {
            return InstallResult.success((JSONArray)JSON.parseArray((String)JSON.toJSONString((Object)this.pushMsgService.getAppService(appServiceDto))));
        }
        catch (HussarException e) {
            return InstallResult.fail((String)(this.bpmConstantProperties.getErrorGetMessageChannel() + e.getMessage()));
        }
    }

    static {
        PUSH_WITHOUT_CONTACT_TYPE.add("sms");
        PUSH_WITHOUT_CONTACT_TYPE.add("mail");
        PUSH_WITHOUT_CONTACT_TYPE.add(ZNX);
        PUSH_WITH_CONTACT_TYPE.add("app_push");
        PUSH_WITH_CONTACT_TYPE.add("app_im");
        PUSH_WITH_CONTACT_TYPE.add("cp");
        PUSH_WITH_CONTACT_TYPE.add("dingTalk");
    }
}

