/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.util.BpmMsgDetailBuildUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessCancleListener
implements ActivitiEventListener {
    private static Logger logger = LogManager.getLogger(ProcessCancleListener.class);
    @Autowired
    private BpmMsgPushService msgPushService;
    @Autowired
    private DataPushService dataPushService;

    public void onEvent(ActivitiEvent event) {
        ExecutionEntity entity = Context.getCommandContext().getExecutionEntityManager().findExecutionById(event.getProcessInstanceId());
        HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(event.getProcessInstanceId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCompleteEnd");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("completeTime", simpleDateFormat.format(new Date()));
        map.put("processInsId", entity.getId());
        map.put("processDefinitionId", entity.getProcessDefinitionId());
        map.put("processDefinitionName", entity.getProcessDefinition().getName());
        map.put("businessId", entity.getBusinessKey());
        map.put("processTitle", historicProcessInstance.getProcessTitle());
        map.put("dataDetail", historicProcessInstance.getDataDetail());
        map.put("taskName", entity.getCurrentActivityName());
        map.put("starter", historicProcessInstance.getStartUserId());
        CommonCodeUtil.triggerEventHandleClass(map);
        if (historicProcessInstance.getSuperProcessInstanceId() == null) {
            String sceneCode = "endProcess".equals(BpmAttribute.getTaskSourceFlag((ActivityExecution)entity)) ? "terminated" : "complete";
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            BpmActMsgDetail bpmActMsgDetail = BpmMsgDetailBuildUtil.executionMsgDetail((ExecutionEntity)entity, (String)sceneCode);
            bpmActMsgDetailList.add(bpmActMsgDetail);
            this.msgPushService.pushMessage(bpmActMsgDetailList);
        }
        new ProcessActionCmd(historicProcessInstance.getId(), historicProcessInstance.getProcessDefinitionId(), 1).execute(Context.getCommandContext());
        new ProcessNodeCmd(historicProcessInstance.getId(), historicProcessInstance.getProcessDefinitionId(), 1).execute(Context.getCommandContext());
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(entity.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setProcessInsId(entity.getId());
            dataPush.setBusinessKey(entity.getBusinessKey());
            dataPush.setProcessKey(entity.getProcessDefinitionKey());
            dataPush.setProcessEndTime(new Date());
            if ("endProcess".equals(BpmAttribute.getTaskSourceFlag((ActivityExecution)entity))) {
                dataPush.setProcessState("endProcess");
            } else if ("revokeProcess".equals(BpmAttribute.getTaskSourceFlag((ActivityExecution)entity))) {
                dataPush.setProcessState("revokeProcess");
            } else {
                dataPush.setProcessState("completeProcess");
            }
            dataPush.setProcessDefinitionId(entity.getProcessDefinitionId());
            dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
            dataPush.setDueDate(historicProcessInstance.getDueDate());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setStartOrganId(historicProcessInstance.getOrganId());
            this.dataPushService.changeProcessStateDataPush(dataPush);
            DataPush otherDataPush = new DataPush();
            otherDataPush.setBusinessKey(entity.getBusinessKey());
            otherDataPush.setProcessInsId(entity.getId());
            otherDataPush.setProcessEndTime(new Date());
            otherDataPush.setProcessKey(entity.getProcessDefinitionKey());
            this.dataPushService.updateStartProcess(otherDataPush);
        }
    }

    public boolean isFailOnException() {
        logger.error("\u6d41\u7a0b\u5220\u9664\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }
}

