/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendCommonConverterUtil;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.activiti.editor.language.json.converter.StartEventJsonConverter;
import org.apache.commons.lang3.StringUtils;

public class ExtendStartEventJsonConverter
extends StartEventJsonConverter {
    protected String getStencilId(BaseElement baseElement) {
        StartEvent event = (StartEvent)baseElement;
        if (event.getEventDefinitions().size() > 0) {
            EventDefinition eventDefinition = (EventDefinition)event.getEventDefinitions().get(0);
            if (eventDefinition instanceof TimerEventDefinition) {
                return "StartTimerEvent";
            }
            if (eventDefinition instanceof ErrorEventDefinition) {
                return "StartErrorEvent";
            }
            if (eventDefinition instanceof MessageEventDefinition) {
                return "StartMessageEvent";
            }
            if (eventDefinition instanceof SignalEventDefinition) {
                return "StartSignalEvent";
            }
        }
        return "StartNoneEvent";
    }

    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        List callMethodElement;
        Map elementsListMap;
        List eventSignElement;
        ExtendCommonConverterUtil.commonConvertElementToJson(propertiesNode, baseElement);
        StartEvent startEvent = (StartEvent)baseElement;
        if (StringUtils.isNotEmpty((CharSequence)startEvent.getInitiator())) {
            propertiesNode.put("initiator", startEvent.getInitiator());
        }
        if (StringUtils.isNotEmpty((CharSequence)startEvent.getFormKey())) {
            propertiesNode.put("formkeydefinition", startEvent.getFormKey());
        }
        if ((eventSignElement = (List)(elementsListMap = startEvent.getExtensionElements()).get("eventSign")) != null && !eventSignElement.isEmpty()) {
            List eventSignList;
            String eventSign = "";
            Map eventSignMap = ((ExtensionElement)eventSignElement.get(0)).getAttributes();
            if (eventSignMap != null && (eventSignList = (List)eventSignMap.get("eventSign")) != null && !eventSignList.isEmpty()) {
                eventSign = ((ExtensionAttribute)eventSignList.get(0)).getValue();
            }
            propertiesNode.put("eventSign", eventSign);
        }
        JSONObject eventConfigurationObject = new JSONObject();
        List implementationElement = (List)elementsListMap.get("implementation");
        if (implementationElement != null && !implementationElement.isEmpty()) {
            List implementationList;
            String implementation = "";
            Map implementationElementMap = ((ExtensionElement)implementationElement.get(0)).getAttributes();
            if (implementationElementMap != null && (implementationList = (List)implementationElementMap.get("implementation")) != null && !implementationList.isEmpty()) {
                implementation = ((ExtensionAttribute)implementationList.get(0)).getValue();
            }
            eventConfigurationObject.put("implementation", (Object)implementation);
        }
        if ((callMethodElement = (List)elementsListMap.get("callMethod")) != null && !callMethodElement.isEmpty()) {
            List callMethodList;
            String callMethod = "";
            Map callMethodMap = ((ExtensionElement)callMethodElement.get(0)).getAttributes();
            if (callMethodMap != null && (callMethodList = (List)callMethodMap.get("callMethod")) != null && !callMethodList.isEmpty()) {
                callMethod = ((ExtensionAttribute)callMethodList.get(0)).getValue();
            }
            eventConfigurationObject.put("callMethod", (Object)callMethod);
        }
        propertiesNode.put("eventConfiguration", eventConfigurationObject.toString());
        this.addFormProperties(startEvent.getFormProperties(), propertiesNode);
        this.addEventProperties((Event)startEvent, propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        StartEvent startEvent = new StartEvent();
        ExtendCommonConverterUtil.commonConvertJsonToElement((FlowElement)startEvent, elementNode);
        startEvent.setInitiator(this.getPropertyValueAsString("initiator", elementNode));
        String stencilId = BpmnJsonConverterUtil.getStencilId((JsonNode)elementNode);
        if ("StartNoneEvent".equals(stencilId)) {
            String formKey = this.getPropertyValueAsString("formkeydefinition", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)formKey)) {
                startEvent.setFormKey(formKey);
            }
            this.convertJsonToFormProperties(elementNode, (BaseElement)startEvent);
        } else if ("StartTimerEvent".equals(stencilId)) {
            this.convertJsonToTimerDefinition(elementNode, (Event)startEvent);
        } else if ("StartErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, (Event)startEvent);
        } else if ("StartMessageEvent".equals(stencilId)) {
            this.convertJsonToMessageDefinition(elementNode, (Event)startEvent);
        } else if ("StartSignalEvent".equals(stencilId)) {
            this.convertJsonToSignalDefinition(elementNode, (Event)startEvent);
        }
        String eventSign = this.getPropertyValueAsString("eventSign", elementNode);
        ExtensionElement eventSignElement = new ExtensionElement();
        ExtensionAttribute eventSignAttribute = new ExtensionAttribute();
        eventSignElement.setName("eventSign");
        eventSignElement.setNamespacePrefix("extend");
        eventSignElement.setNamespace("http://activiti.org/bpmn");
        eventSignAttribute.setName("eventSign");
        eventSignAttribute.setValue(eventSign);
        eventSignElement.addAttribute(eventSignAttribute);
        startEvent.addExtensionElement(eventSignElement);
        String eventConfiguration = this.getPropertyValueAsString("eventConfiguration", elementNode);
        if (HussarUtils.isNotEmpty((Object)eventConfiguration)) {
            String callMethod;
            Map eventConfigurationMap = (Map)JSONObject.parseObject((String)eventConfiguration, Map.class);
            String implementation = String.valueOf(eventConfigurationMap.get("implementation"));
            if (HussarUtils.isNotEmpty((Object)implementation)) {
                ExtensionElement implementationElement = new ExtensionElement();
                ExtensionAttribute implementationAttribute = new ExtensionAttribute();
                implementationElement.setName("implementation");
                implementationElement.setNamespacePrefix("extend");
                implementationElement.setNamespace("http://activiti.org/bpmn");
                implementationAttribute.setName("implementation");
                implementationAttribute.setValue(implementation);
                implementationElement.addAttribute(implementationAttribute);
                startEvent.addExtensionElement(implementationElement);
            }
            if (HussarUtils.isNotEmpty((Object)(callMethod = String.valueOf(eventConfigurationMap.get("callMethod"))))) {
                ExtensionElement callMethodElement = new ExtensionElement();
                ExtensionAttribute callMethodAttribute = new ExtensionAttribute();
                callMethodElement.setName("callMethod");
                callMethodElement.setNamespacePrefix("extend");
                callMethodElement.setNamespace("http://activiti.org/bpmn");
                callMethodAttribute.setName("callMethod");
                callMethodAttribute.setValue(callMethod);
                callMethodElement.addAttribute(callMethodAttribute);
                startEvent.addExtensionElement(callMethodElement);
            }
        }
        return startEvent;
    }
}

