/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.bpmn.behavior.IntermediateCatchEventActivityBehavior;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendIntermediateCatchSignalEventActivityBehavior
extends IntermediateCatchEventActivityBehavior {
    private static final Logger logger = LoggerFactory.getLogger(ExtendIntermediateCatchSignalEventActivityBehavior.class);
    private static RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getSpringContext().getBean(RepositoryService.class);
    private static ISysCalendarRefService sysCalendarRefService = (ISysCalendarRefService)BpmSpringContextHolder.getSpringContext().getBean(ISysCalendarRefService.class);
    private static ActivityRedisTimerService activityRedisTimer = (ActivityRedisTimerService)BpmSpringContextHolder.getSpringContext().getBean(ActivityRedisTimerService.class);
    private static SysActAssigneeService sysActAssigneeService = (SysActAssigneeService)BpmSpringContextHolder.getSpringContext().getBean(SysActAssigneeService.class);
    private static IAssigneeChooseService assigneeChooseService = (IAssigneeChooseService)BpmSpringContextHolder.getSpringContext().getBean(IAssigneeChooseService.class);

    public void execute(ActivityExecution execution) throws Exception {
        Object prevNodeEventSign;
        String processDefinitionId = execution.getProcessDefinitionId();
        String processKey = processDefinitionId.split(":")[0];
        String version = processDefinitionId.split(":")[1];
        String currentActivityId = execution.getCurrentActivityId();
        BpmnModel bm = repositoryService.getBpmnModel(processDefinitionId);
        FlowElement flowElement = bm.getFlowElement(currentActivityId);
        String eventSign = ((EventSubscriptionEntity)((ExecutionEntity)execution).getEventSubscriptions().get(0)).getEventName();
        String eventSkip = "";
        List skipExtensionElements = (List)flowElement.getExtensionElements().get("eventSkip");
        if (HussarUtils.isNotEmpty((Object)skipExtensionElements)) {
            eventSkip = ((ExtensionAttribute)((List)((ExtensionElement)skipExtensionElements.get(0)).getAttributes().get("eventSkip")).get(0)).getValue();
        }
        if (HussarUtils.isNotEmpty((Object)eventSkip) && "1".equals(eventSkip) && HussarUtils.isNotEmpty((Object)(prevNodeEventSign = Context.getCommandContext().getAttribute("eventSign"))) && eventSign.equals(prevNodeEventSign)) {
            this.signal(execution, eventSign, null);
            return;
        }
        Date createDate = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date createTime = null;
        try {
            createTime = formatter.parse(formatter.format(createDate));
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String dueDate = null;
        List dueDateElement = (List)flowElement.getExtensionElements().get("eventDueDate");
        if (HussarUtils.isNotEmpty((Object)dueDateElement) && HussarUtils.isNotEmpty((Object)((ExtensionElement)dueDateElement.get(0)).getAttributes())) {
            dueDate = ((ExtensionAttribute)((List)((ExtensionElement)dueDateElement.get(0)).getAttributes().get("eventDueDate")).get(0)).getValue();
        }
        Date eventDueDate = null;
        TimeOutConfig timeOutConfig = TimeOutConfig.build(flowElement);
        String chosenDay = timeOutConfig.getChosenDay();
        if ("workingDay".equals(chosenDay)) {
            Date date = new Date();
            Instant instant = date.toInstant();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            LocalDateTime dueTime = sysCalendarRefService.getDueDateDefult(localDateTime, String.valueOf(dueDate), true);
            ZonedDateTime zonedDateTime = dueTime.atZone(ZoneId.systemDefault());
            Instant instant2 = zonedDateTime.toInstant();
            eventDueDate = Date.from(instant2);
        } else if (dueDate != null) {
            if (dueDate instanceof Date) {
                eventDueDate = (Date)((Object)dueDate);
            } else if (dueDate instanceof String) {
                BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar("eventDueDate");
                eventDueDate = businessCalendar.resolveDuedate(dueDate);
            }
        }
        Date warningDate = null;
        String warningDateConfig = timeOutConfig.getWarningDate();
        if (HussarUtils.isNotEmpty((Object)warningDateConfig) && HussarUtils.isNotEmpty((Object)eventDueDate)) {
            String warningDateType = timeOutConfig.getWarningDateType();
            if ("workingDay".equals(warningDateType)) {
                Date date = eventDueDate;
                Instant instant = date.toInstant();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                LocalDateTime dueTime = sysCalendarRefService.getBeginDateDefult(localDateTime, warningDateConfig, true);
                ZonedDateTime zonedDateTime = dueTime.atZone(ZoneId.systemDefault());
                Instant instant2 = zonedDateTime.toInstant();
                warningDate = Date.from(instant2);
            } else {
                warningDate = TimeOutConfig.getWarningDate(execution, warningDateConfig, eventDueDate);
            }
        }
        if (HussarUtils.isNotEmpty((Object)eventDueDate)) {
            String extendParam;
            List<TimeOutModel> timeOutModels;
            HistoricActivityInstanceEntity historicActivityInstance = Context.getCommandContext().getHistoryManager().findActivityInstance((ExecutionEntity)execution);
            historicActivityInstance.setDueDate(eventDueDate);
            ArrayList<String> receiverList = new ArrayList<String>();
            SysActAssignee sysActAssignee = sysActAssigneeService.queryEventTimeOutReceiver(processKey, version, currentActivityId);
            if (HussarUtils.isNotEmpty((Object)sysActAssignee)) {
                String timeOutReceiverCondition = sysActAssignee.getContent() == null ? "" : new String(sysActAssignee.getContent(), StandardCharsets.UTF_8);
                List<Object> list = receiverList = HussarUtils.isEmpty((Object)timeOutReceiverCondition) ? new ArrayList() : assigneeChooseService.getCandidateUser(timeOutReceiverCondition, processKey, null, new HashMap());
            }
            if (HussarUtils.isNotEmpty(timeOutModels = timeOutConfig.buildTimeOutModel(execution, receiverList, createTime, eventDueDate, warningDate, extendParam = this.getExtendParam(execution, eventSign, eventDueDate)))) {
                activityRedisTimer.addTimeOutModels(timeOutModels);
            }
        }
    }

    public void signal(ActivityExecution execution, String signalName, Object data) throws Exception {
        Map subBusinessData = (Map)Context.getCommandContext().getAttribute("subBusinessFlowData");
        String assignee = String.valueOf(subBusinessData.get("assignee"));
        HistoricActivityInstanceEntity historicActivityInstance = Context.getCommandContext().getHistoryManager().findActivityInstance((ExecutionEntity)execution);
        historicActivityInstance.setAssignee(assignee);
        String eventSign = ((EventSubscriptionEntity)((ExecutionEntity)execution).getEventSubscriptions().get(0)).getEventName();
        Context.getCommandContext().addAttribute("eventSign", (Object)eventSign);
        this.leave(execution);
        activityRedisTimer.delTimeOutModel(execution.getId());
    }

    public String getExtendParam(ActivityExecution execution, String signalName, Date dueDate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", ((ExecutionEntity)execution).getName());
        map.put("processInsId", execution.getProcessInstanceId());
        map.put("processDefinitionId", execution.getProcessDefinitionId());
        map.put("executionId", execution.getId());
        map.put("businessId", execution.getProcessBusinessKey());
        map.put("processName", ((ExecutionEntity)execution).getProcessDefinition().getName());
        map.put("sendUser", execution.getVariableLocal("sendUser"));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("dueDate", format.format(dueDate));
        map.put("signalName", signalName);
        Map subBusinessData = (Map)Context.getCommandContext().getAttribute("subBusinessFlowData");
        map.put("assignee", subBusinessData.get("assignee"));
        String subProcessKey = execution.getSubProcessKey();
        if (HussarUtils.isNotEmpty((Object)subProcessKey)) {
            String subBusinessId = subProcessKey.split(":")[1];
            map.put("subBusinessId", subBusinessId);
        }
        return JSON.toJSONString(map);
    }
}

