/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.activiti.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendBoundaryEventActivityBehavior
extends BoundaryEventActivityBehavior {
    protected boolean interrupting;
    protected String activityId;
    private static ActivityRedisTimerService activityRedisTimer = (ActivityRedisTimerService)BpmSpringContextHolder.getSpringContext().getBean(ActivityRedisTimerService.class);
    private static final Logger logger = LoggerFactory.getLogger(ExtendBoundaryEventActivityBehavior.class);

    public ExtendBoundaryEventActivityBehavior() {
    }

    public ExtendBoundaryEventActivityBehavior(boolean interrupting, String activityId) {
        super(interrupting, activityId);
        this.interrupting = interrupting;
        this.activityId = activityId;
    }

    private void setVariable(ActivityExecution execution) {
        Object appointAssignee;
        Object nextNode;
        CommandContext commandContext = Context.getCommandContext();
        Object sendUser = commandContext.getAttribute("sendUser");
        if (HussarUtils.isNotEmpty((Object)sendUser)) {
            execution.setVariableLocal("sendUser", sendUser);
        }
        if (HussarUtils.isNotEmpty((Object)(nextNode = commandContext.getAttribute("bpm_next_node")))) {
            execution.setVariableLocal("bpm_next_node", nextNode);
        }
        if (HussarUtils.isNotEmpty((Object)(appointAssignee = execution.getTempVariable("appoint_assignee")))) {
            execution.setVariableLocal("appoint_assignee", appointAssignee);
        }
    }

    public void execute(ActivityExecution execution) throws Exception {
        List eventSubscriptions = ((ExecutionEntity)execution).getEventSubscriptions();
        Optional<EventSubscriptionEntity> entityImpl = eventSubscriptions.stream().filter(eventSubscriptionEntity -> this.activityId.equals(eventSubscriptionEntity.getActivityId())).findFirst();
        if (HussarUtils.isNotEmpty(entityImpl)) {
            EventSubscriptionEntity entity = entityImpl.get();
            Context.getCommandContext().addAttribute("eventSign", (Object)entity.getEventName());
        }
        this.setVariable(execution);
        if (this.interrupting) {
            String executionId = execution.getParentId();
            List childExecutionList = Context.getCommandContext().getExecutionEntityManager().findChildExecutionsByParentExecutionId(executionId);
            if (HussarUtils.isNotEmpty((Object)childExecutionList)) {
                for (int i = 0; i < childExecutionList.size(); ++i) {
                    ExecutionEntity entity = (ExecutionEntity)childExecutionList.get(i);
                    childExecutionList.addAll(Context.getCommandContext().getExecutionEntityManager().findChildExecutionsByParentExecutionId(entity.getId()));
                }
                List allExecutionIdList = childExecutionList.stream().map(executionEntity -> executionEntity.getId()).collect(Collectors.toList());
                activityRedisTimer.delTimeOutModel(String.join((CharSequence)",", allExecutionIdList));
            }
        }
        Map subBusinessData = (Map)Context.getCommandContext().getAttribute("subBusinessFlowData");
        String assignee = String.valueOf(subBusinessData.get("assignee"));
        HistoricActivityInstanceEntity historicActivityInstance = Context.getCommandContext().getHistoryManager().findActivityInstance((ExecutionEntity)execution);
        historicActivityInstance.setAssignee(assignee);
        super.execute(execution);
    }

    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        super.leave(execution);
    }
}

