/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.event;

import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.event.annotation.HussarEventListener;
import com.jxdinfo.hussar.support.lock.annotation.HussarLockGuarded;
import com.jxdinfo.hussar.workflow.engine.bpm.event.model.BusinessEvent;
import com.jxdinfo.hussar.workflow.engine.bpm.event.model.BusinessEventData;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class BusinessFlowEvent {
    @Resource
    private RuntimeService runtimeService;
    @Autowired
    private SeqBuilder seqBuilder;
    private static final Logger logger = LoggerFactory.getLogger(BusinessFlowEvent.class);

    @Async
    @HussarEventListener
    @HussarLockGuarded(key="#{#event.data.businessId}_#{#event.data.customLock}")
    public void handleEvent(BusinessEvent event) {
        String subBusinessId = ((BusinessEventData)event.getData()).getBusinessId();
        String mainBusinessId = ((BusinessEventData)event.getData()).getMainBusinessId();
        Map subBusinessData = ((BusinessEventData)event.getData()).getSubBusinessData();
        String userId = ((BusinessEventData)event.getData()).getUserId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)subBusinessId)) {
            map.put("subBusinessId", subBusinessId + ":" + (HussarUtils.isNotEmpty((Object)mainBusinessId) ? mainBusinessId : this.generateId()));
        }
        map.put("subBusinessData", subBusinessData);
        if (HussarUtils.isNotEmpty((Object)userId)) {
            map.put("assignee", userId);
        }
        this.runtimeService.signalEventReceived(((BusinessEventData)event.getData()).getSignName(), map);
    }

    private String generateId() {
        Sequence sequence = this.seqBuilder.build();
        return String.valueOf(sequence.nextValue());
    }
}

