/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ExtendDataDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.FireEvent;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpNodeLeaveAddCcTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpToTargetNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extenddata.service.WorkflowExtendDataService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.history.HistoryManager;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CcTaskEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.impl.persistence.entity.VariableScopeImpl;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelJumpTaskEndBatchCmd
extends AddAttributeCmd<Void> {
    private TaskService taskService = (TaskService)BpmSpringContextHolder.getSpringContext().getBean(TaskService.class);
    private String taskId;
    protected String userId;
    private String executionId;
    protected String comment;
    private String subProcessKey;
    private JumpModel jumpModel;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private String processEventType;
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    private String mandator;
    private TaskRejectModel taskRejectModel;
    private final Logger logger = LoggerFactory.getLogger(ParallelJumpTaskEndBatchCmd.class);
    private DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getSpringContext().getBean(DataPushService.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)BpmSpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ProcessEngine processEngine = (ProcessEngine)BpmSpringContextHolder.getSpringContext().getBean(ProcessEngine.class);
    private FireEvent fireEvent = (FireEvent)BpmSpringContextHolder.getBean(FireEvent.class);
    private WorkflowExtendDataService workflowExtendDataService = (WorkflowExtendDataService)BpmSpringContextHolder.getBean(WorkflowExtendDataService.class);
    private static final String DELETE_REASON = "ParallelJumpTaskCmd-Completed";

    public ParallelJumpTaskEndBatchCmd(String userId, String mandator, String executionId, JumpModel jumpModel, String comment, String subProcessKey, Map<String, Object> paramvar, ActivityImpl currentActivity, TaskRejectModel taskRejectModel) {
        this.userId = userId;
        this.executionId = executionId;
        this.jumpModel = jumpModel;
        this.comment = comment;
        this.subProcessKey = subProcessKey;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.mandator = mandator;
        this.taskRejectModel = taskRejectModel;
        this.taskId = taskRejectModel.getTaskId();
    }

    public ParallelJumpTaskEndBatchCmd(String taskId, String userId, String mandator, String executionId, JumpModel jumpModel, String comment, String subProcessKey, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.taskId = taskId;
        this.userId = userId;
        this.executionId = executionId;
        this.jumpModel = jumpModel;
        this.comment = comment;
        this.subProcessKey = subProcessKey;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.mandator = mandator;
    }

    public ParallelJumpTaskEndBatchCmd(String taskId, String userId, String mandator, String executionId, JumpModel jumpModel, String comment, Map<String, Object> paramMap, String subProcessKey, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.taskId = taskId;
        this.userId = userId;
        this.executionId = executionId;
        this.jumpModel = jumpModel;
        this.comment = comment;
        this.subProcessKey = subProcessKey;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.mandator = mandator;
        if (HussarUtils.isNotEmpty(paramMap)) {
            this.paramMap = paramMap;
        }
    }

    public ParallelJumpTaskEndBatchCmd(String userId, String mandator, String executionId, JumpModel jumpModel, String comment, Map<String, Object> paramMap, String subProcessKey, Map<String, Object> paramvar, ActivityImpl currentActivity, TaskRejectModel taskRejectModel) {
        this.userId = userId;
        this.executionId = executionId;
        this.jumpModel = jumpModel;
        this.comment = comment;
        this.subProcessKey = subProcessKey;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.mandator = mandator;
        this.taskRejectModel = taskRejectModel;
        this.taskId = taskRejectModel.getTaskId();
        if (HussarUtils.isNotEmpty(paramMap)) {
            this.paramMap = paramMap;
        }
    }

    public ParallelJumpTaskEndBatchCmd setProcessEventType(String processEventType) {
        this.processEventType = processEventType;
        return this;
    }

    public ParallelJumpTaskEndBatchCmd addParam(String str, Object obj) {
        this.paramMap.put(str, obj);
        return this;
    }

    public Void execute(CommandContext commandContext) {
        this.addAttribute(commandContext);
        HistoryManager historyManager = commandContext.getHistoryManager();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        ExecutionEntity execution = executionEntityManager.findExecutionById(this.executionId);
        this.addExecutionAttribute(execution);
        String type = BpmAttribute.getTaskSourceFlag((ActivityExecution)execution);
        ParamModel paramModel = this.getParamModel(execution, this.taskRejectModel, type);
        commandContext.addAttribute("listenerParam", (Object)paramModel);
        this.fireEvent.fireEvent(execution, this.processEventType, (String)this.paramMap.get("sub_process"));
        List list = commandContext.getDbSqlSession().findInCache(ExecutionEntity.class);
        list.removeIf(e -> !execution.getProcessInstanceId().equals(e.getProcessInstanceId()));
        ExecutionEntity executionEntity = null;
        for (ExecutionEntity entity : list) {
            if ((this.subProcessKey == null || !this.subProcessKey.equals(entity.getSubProcessKey())) && (this.subProcessKey != null || entity.getParentId() != null)) continue;
            executionEntity = entity;
            break;
        }
        ArrayList<TaskEntity> taskEntities = new ArrayList<TaskEntity>();
        ArrayList<ExecutionEntity> executionEntities = new ArrayList<ExecutionEntity>();
        this.getExecutionAndTask(executionEntity, taskEntities, executionEntities);
        this.taskHandle(taskEntities, commandContext, type);
        for (int i = 1; i < executionEntities.size(); ++i) {
            ExecutionEntity ee = (ExecutionEntity)executionEntities.get(i);
            while (HussarUtils.isNotEmpty((Object)ee.getExecutions())) {
                this.executionHandle((ExecutionEntity)ee.getExecutions().get(0), historyManager, commandContext);
            }
            ExecutionEntity eeParent = ee.getParent();
            while (eeParent != null && eeParent.getExecutions().size() == 1) {
                ee.remove();
                if (ee.getActivityId() != null) {
                    new JumpNodeLeaveAddCcTaskCmd(ee).execute(commandContext);
                    historyManager.recordActivityEnd(ee);
                }
                ee = eeParent;
                eeParent = ee.getParent();
            }
            ee.remove();
            if (ee.getActivityId() == null) continue;
            this.fireExecutionListener(ee);
            historyManager.recordActivityEnd(ee);
        }
        ExecutionEntity ee = (ExecutionEntity)executionEntities.get(0);
        while (HussarUtils.isNotEmpty((Object)ee.getExecutions())) {
            this.executionHandle((ExecutionEntity)ee.getExecutions().get(0), historyManager, commandContext);
        }
        ExecutionEntity eeParent = ee.getParent();
        while (eeParent != null && eeParent.getExecutions().size() == 1 && !ee.getId().equals(executionEntity.getId())) {
            ee.remove();
            if (ee.getActivityId() != null) {
                this.fireExecutionListener(ee);
                historyManager.recordActivityEnd(ee);
            }
            ee = eeParent;
            eeParent = ee.getParent();
        }
        if (ee.getActivityId() != null) {
            this.fireExecutionListener(ee);
            historyManager.recordActivityEnd(ee);
        }
        if (!ee.getId().equals(executionEntity.getId())) {
            ee.remove();
        }
        this.processEngine.getManagementService().executeCommand((Command)new JumpToTargetNodeCmd(executionEntity, this.comment, this.jumpModel, this.userId, type, this.taskRejectModel != null && this.taskRejectModel.isSubmit(), this.paramvar));
        return null;
    }

    private void getExecutionAndTask(ExecutionEntity executionEntity, List<TaskEntity> taskEntities, List<ExecutionEntity> executionEntities) {
        block6: {
            block5: {
                Collection affectedTasks = this.jumpModel.getAffectedTasks();
                if (affectedTasks != null && executionEntities != null && (executionEntity.getCurrentActivityId() == null || !affectedTasks.contains(executionEntity.getCurrentActivityId()))) break block5;
                if (executionEntity.getTasks() != null) {
                    taskEntities.addAll(executionEntity.getTasks());
                }
                if (executionEntities != null) {
                    executionEntities.add(executionEntity);
                }
                if (executionEntity.getExecutions() == null) break block6;
                for (ExecutionEntity entity : executionEntity.getExecutions()) {
                    this.getExecutionAndTask(entity, taskEntities, null);
                }
                break block6;
            }
            if (executionEntity.getExecutions() != null) {
                for (ExecutionEntity entity : executionEntity.getExecutions()) {
                    this.getExecutionAndTask(entity, taskEntities, executionEntities);
                }
            }
        }
    }

    private void taskHandle(List<TaskEntity> taskEntities, CommandContext commandContext, String type) {
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        boolean needDelTask = TaskSourceFlag.isRejectOrRevoke((String)type) || TaskSourceFlag.isFreeJump((String)type) || TaskSourceFlag.isEndProcess((String)type);
        ArrayList<String> allTimeOutTaskIds = new ArrayList<String>();
        ArrayList<String> delTaskIds = new ArrayList<String>();
        String processKey = null;
        String processDefinitionId = null;
        List<Object> taskIds = new ArrayList();
        if (HussarUtils.isEmpty((Object)this.taskId)) {
            taskIds = taskEntities.stream().filter(CommonCodeUtil.distinctPredict(TaskEntity::getTaskDefinitionKey)).map(VariableScopeImpl::getId).collect(Collectors.toList());
        }
        for (TaskEntity taskEntity : taskEntities) {
            ExtendDataDto extendDataDto;
            ParamModel paramModel;
            boolean flag;
            if (taskEntity.isDeleted()) continue;
            List taskEntityList = commandContext.getDbSqlSession().findAliveEntityInCache(TaskEntity.class);
            if ((taskEntityList = taskEntityList.stream().filter(task -> taskEntity.getId().equals(task.getParentTaskId())).collect(Collectors.toList())) != null) {
                for (Task task2 : taskEntityList) {
                    ((TaskEntity)task2).getExecution().removeTask((TaskEntity)task2);
                    Context.getCommandContext().getTaskEntityManager().deleteTask((TaskEntity)task2, null, true);
                }
            }
            if (taskEntity.getDueDate() != null) {
                allTimeOutTaskIds.add(taskEntity.getId());
            }
            boolean bl = flag = HussarUtils.isNotEmpty(taskIds) && taskIds.contains(taskEntity.getId()) && TaskSourceFlag.isEndProcess((String)type);
            if (this.taskId != null && this.taskId.equals(taskEntity.getId()) || flag) {
                paramModel = (ParamModel)commandContext.getAttribute("listenerParam");
                paramModel.setDeleteType(null);
                commandContext.addAttribute("listenerParam", (Object)paramModel);
                taskEntity.fireEvent("complete");
                if (HussarUtils.isNotEmpty((Object)this.comment)) {
                    this.taskService.addComment(taskEntity.getId(), null, "complete", this.comment);
                }
                if (HussarUtils.isNotEmpty(this.paramMap) && this.workflowExtendDataService != null) {
                    extendDataDto = new ExtendDataDto();
                    extendDataDto.setTaskId(taskEntity.getId());
                    extendDataDto.setExtendData(this.paramMap);
                    extendDataDto.setProcessKey(taskEntity.getProcessKey());
                    extendDataDto.setProcessInsId(taskEntity.getProcessInstanceId());
                    this.workflowExtendDataService.addExtendData(extendDataDto);
                }
                taskEntity.setAssignee(this.userId);
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
                taskEntityManager.deleteTask(taskEntity, DELETE_REASON, false, this.mandator);
                continue;
            }
            if (needDelTask) {
                paramModel = (ParamModel)commandContext.getAttribute("listenerParam");
                paramModel.mappingToDeleteType(type);
                commandContext.addAttribute("listenerParam", (Object)paramModel);
                taskEntity.fireEvent("complete");
                processDefinitionId = taskEntity.getProcessDefinitionId();
                processKey = processDefinitionId.split(":")[0];
                delTaskIds.add(taskEntity.getId());
                CcTaskEntity ccTaskEntity = new CcTaskEntity();
                ccTaskEntity.setTaskId(Long.valueOf(taskEntity.getId()));
                ccTaskEntity.deleteCcTask();
                taskEntityManager.deleteTask(taskEntity, DELETE_REASON, true, this.mandator);
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
                continue;
            }
            paramModel = (ParamModel)commandContext.getAttribute("listenerParam");
            paramModel.setDeleteType(null);
            commandContext.addAttribute("listenerParam", (Object)paramModel);
            taskEntity.fireEvent("complete");
            if (HussarUtils.isNotEmpty((Object)this.comment)) {
                this.taskService.addComment(taskEntity.getId(), null, "complete", this.comment);
            }
            if (HussarUtils.isNotEmpty(this.paramMap) && this.workflowExtendDataService != null) {
                extendDataDto = new ExtendDataDto();
                extendDataDto.setTaskId(taskEntity.getId());
                extendDataDto.setExtendData(this.paramMap);
                extendDataDto.setProcessKey(processKey);
                extendDataDto.setProcessInsId(taskEntity.getProcessInstanceId());
                this.workflowExtendDataService.addExtendData(extendDataDto);
            }
            taskEntity.setAssignee(this.userId);
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
            taskEntityManager.deleteTask(taskEntity, DELETE_REASON, false, this.mandator);
        }
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(processDefinitionId);
        if (delTaskIds.size() > 0 && this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setProcessKey(processKey);
            dataPush.setProcessDefinitionId(processDefinitionId);
            dataPush.setTaskIds(delTaskIds);
            dataPush.setProcessInsId(taskEntities.get(0).getProcessInstanceId());
            this.dataPushService.deleteMultiTask(dataPush);
        }
        if (HussarUtils.isNotEmpty(allTimeOutTaskIds)) {
            this.activityRedisTimerService.delTimeOutModel(String.join((CharSequence)",", allTimeOutTaskIds));
        }
    }

    private void executionHandle(ExecutionEntity executionEntity, HistoryManager historyManager, CommandContext commandContext) {
        while (HussarUtils.isNotEmpty((Object)executionEntity.getExecutions())) {
            this.executionHandle((ExecutionEntity)executionEntity.getExecutions().get(0), historyManager, commandContext);
        }
        executionEntity.remove();
        if (executionEntity.getActivityId() != null) {
            this.fireExecutionListener(executionEntity);
            historyManager.recordActivityEnd(executionEntity);
        }
    }

    private static String joinStr(List<String> list) {
        return list == null ? null : String.join((CharSequence)",", list);
    }

    public ParamModel getParamModel(ExecutionEntity executionEntity, TaskRejectModel taskRejectModel, String type) {
        ParamModel paramModel = new ParamModel();
        if (HussarUtils.isNotEmpty((Object)this.processEventType) && "process_restart".equals(this.processEventType)) {
            paramModel.setCreateReason("reStartCreate");
            paramModel.setStarter(this.userId);
            return paramModel;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        paramModel.setFrom(ParallelJumpTaskEndBatchCmd.joinStr(this.jumpModel.getJumpFrom()));
        paramModel.setTo(ParallelJumpTaskEndBatchCmd.joinStr(this.jumpModel.getJumpTo()));
        if ("endProcess".equals(type) || "revokeProcess".equals(type) || TaskSourceFlag.isComplete((String)type)) {
            paramModel.mappingCompleteType(type);
            paramModel.setFrom(this.currentActivity.getId());
            paramModel.setHandler(this.userId);
            if (TaskSourceFlag.isComplete((String)type)) {
                paramModel.setSendUser(this.userId);
                paramModel.mappingToCreateReason(type);
                paramModel.setLastNodeId(this.currentActivity.getId());
                paramModel.setLastTaskId(this.taskId);
                paramModel.mappingLastCompleteType(type);
                paramModel.setLastNodeHandler(this.userId);
            }
            return paramModel;
        }
        paramModel.mappingCompleteType(type);
        if (HussarUtils.isNotEmpty((Object)taskRejectModel)) {
            Map targetAssigneeMap = (Map)BpmAttribute.getExecutionAttribute((ActivityExecution)executionEntity, "appoint_assignee");
            paramModel.setTargetAssignee(targetAssigneeMap);
            paramModel.setFrom(ParallelJumpTaskEndBatchCmd.joinStr(this.jumpModel.getJumpFrom()));
            String affectedTaskIds = null;
            affectedTaskIds = this.jumpModel.getAffectedTasks() != null ? String.join((CharSequence)",", this.jumpModel.getAffectedTasks()) : taskRejectModel.getAllAffectedTaskIds();
            paramModel.setAffectedNodeId(affectedTaskIds);
            paramModel.setHandler(taskRejectModel.getUserId());
            paramModel.setSendUser(taskRejectModel.getUserId());
            paramModel.mappingToCreateReason(type);
            if (taskRejectModel.getTask() != null) {
                paramModel.setLastNodeId(taskRejectModel.getTask().getTaskDefinitionKey());
                paramModel.setLastNodeName(taskRejectModel.getTask().getName());
            }
            paramModel.mappingLastCompleteType(type);
            paramModel.setLastNodeHandler(taskRejectModel.getUserId());
        } else {
            paramModel.mappingCompleteType(type);
            paramModel.setHandler(this.userId);
        }
        return paramModel;
    }

    public void fireExecutionListener(ExecutionEntity execution) {
        execution.setEventName("end");
        List executionListeners = execution.getActivity().getExecutionListeners("end");
        for (ExecutionListener executionListener : executionListeners) {
            try {
                executionListener.notify((DelegateExecution)execution);
            }
            catch (Exception e) {
                this.logger.error(BpmExceptionCodeEnum.LISTENER_EXECUTION_ERROR.getMessage(), (Throwable)e);
                throw new BpmException(BpmExceptionCodeEnum.LISTENER_EXECUTION_ERROR.getMessage());
            }
        }
    }
}

