/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.service.WorkflowCommonCacheService;
import com.jxdinfo.hussar.workflow.engine.bpm.listener.WorkflowListenerUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.apache.commons.lang3.StringUtils;

public class GetVariableCmd
implements Command<Map<String, Object>> {
    private static WorkflowCommonCacheService workflowCommonCacheService = (WorkflowCommonCacheService)BpmSpringContextHolder.getBean(WorkflowCommonCacheService.class);
    private static ModelService modelService = (ModelService)BpmSpringContextHolder.getBean(ModelService.class);
    private static RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getBean(RepositoryService.class);
    protected String nodeId;
    protected String businessId;
    protected String procDefId;
    protected String userId;
    protected BpmnModel bm;

    public GetVariableCmd(String nodeId, String businessId, String procDefId, String userId, BpmnModel bm) {
        this.nodeId = nodeId;
        this.businessId = businessId;
        this.procDefId = procDefId;
        this.userId = userId;
        this.bm = bm;
    }

    private <T> T getTempVar(DelegateExecution execution, String varName) {
        return (T)((ExecutionEntity)execution).getLocalTempVariable(varName);
    }

    public Map<String, Object> execute(CommandContext commandContext) {
        Map<String, Object> variableResult = null;
        BpmnModel bpmnModel = null;
        bpmnModel = HussarUtils.isNotEmpty((Object)this.bm) ? this.bm : repositoryService.getBpmnModel(this.procDefId);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Process process = (Process)bpmnModel.getProcesses().get(0);
        ActivitiListener activitiListener = null;
        List executionListeners = process.getExecutionListeners();
        for (ActivitiListener executionListener : executionListeners) {
            if (!"getProcessVariables".equals(executionListener.getEvent())) continue;
            activitiListener = executionListener;
        }
        if (HussarUtils.isEmpty(activitiListener)) {
            return new HashMap<String, Object>();
        }
        String beanId = activitiListener.getImplementation();
        List fieldExtensions = activitiListener.getFieldExtensions();
        Map<String, String> fieldMap = fieldExtensions.stream().collect(Collectors.toMap(FieldExtension::getFieldName, FieldExtension::getStringValue));
        String listenerModel = fieldMap.get("listenerModel");
        String requestMethod = fieldMap.get("requestMethod");
        String isAsyn = fieldMap.get("isAsyn");
        String processDefinitionId = this.procDefId;
        String processDefinitionKey = processDefinitionId.split(":")[0];
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nodeId", this.nodeId);
        Collection flowElements = process.getFlowElements();
        Map flowElementMap = flowElements.stream().collect(Collectors.toMap(BaseElement::getId, Function.identity()));
        FlowElement flowElement = (FlowElement)flowElementMap.get(this.nodeId);
        String nodeName = flowElement.getName();
        map.put("nodeName", nodeName);
        map.put("businessId", this.businessId);
        map.put("processInsId", process.getId());
        map.put("processDefinitionId", processDefinitionId);
        map.put("processKey", processDefinitionKey);
        map.put("appId", modelService.getAppId(processDefinitionKey));
        String[] split = flowElement.getClass().toString().split("\\.");
        map.put("activityType", StringUtils.uncapitalize((String)split[split.length - 1]));
        map.put("starter", this.userId);
        map.put("processName", process.getName());
        map.put("createTime", simpleDateFormat.format(new Date()));
        map.put("lastNodeId", null);
        map.put("lastNodeName", null);
        map.put("lastNodeAssignee", null);
        map.put("createType", null);
        String serviceName = String.valueOf(workflowCommonCacheService.getServiceName(processDefinitionKey));
        try {
            variableResult = WorkflowListenerUtils.executionProcessVariableListener(listenerModel, requestMethod, beanId, map, serviceName);
        }
        catch (Exception e) {
            if ("true".equals(isAsyn)) {
                e.printStackTrace();
                variableResult = new HashMap<String, Object>();
            }
            throw e;
        }
        return variableResult;
    }
}

