/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.util.ActivitiTranslateUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.task.TaskInfo;

public class AddHistoryTaskCmd
implements Command<TaskEntity> {
    protected String comment;
    protected Date startTime;
    protected Date endTime;
    protected String userId;
    protected TaskEntity task;
    protected String taskSourceFlag;
    protected String deleteReason;
    private static final Map<String, String> HISTORY_MAP = new HashMap<String, String>();
    protected DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getSpringContext().getBean(DataPushService.class);

    public TaskEntity execute(CommandContext commandContext) {
        TaskEntity task = this.getTask();
        ExecutionEntity execution = task.getExecution();
        if (BpmAttribute.getTaskSourceFlag((ActivityExecution)execution) == null) {
            execution.addTempVariable("taskSourceFlag", (Object)this.taskSourceFlag);
        }
        TaskEntity taskEntity = this.initTask(commandContext, task, execution);
        taskEntity.insert(taskEntity.getExecution());
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)taskEntity));
        }
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(this.userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(taskEntity.getId());
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        if (this.dataPushService.isDataPush(taskEntity.getProcessDefinitionId())) {
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(taskEntity.getId());
            dataPush.setTaskDefinitionName(taskEntity.getName());
            dataPush.setTaskDefinitionNameTranslateKey(taskEntity.getNameTranslateKey());
            dataPush.setUserId(this.userId);
            dataPush.setBusinessKey(taskEntity.getProcessInstance().getBusinessKey());
            dataPush.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
            dataPush.setProcessKey(taskEntity.getProcessDefinitionId().split(":")[0]);
            dataPush.setSendUser(this.userId);
            dataPush.setStartDate(this.startTime);
            dataPush.setEndDate(new Date());
            dataPush.setUrl(taskEntity.getFormKey());
            dataPush.setDescription(task.getTodoConfiguration());
            dataPush.setProcessName(execution.getProcessDefinitionName());
            dataPush.setProcessNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)taskEntity.getProcessDefinitionId(), (String)taskEntity.getTaskDefinitionKey()));
            if (HussarUtils.isNotEmpty((Object)this.comment)) {
                dataPush.setComment(this.comment);
            }
            dataPush.setProcessInsId(taskEntity.getProcessInstanceId());
            this.dataPush(dataPush);
        }
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
        ParamModel paramModel = this.getParamModel(task);
        Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
        task.fireEvent("complete");
        if (this.deleteReason == null) {
            this.deleteReason = HISTORY_MAP.get(this.taskSourceFlag);
        }
        if (this.deleteReason == null) {
            this.deleteReason = this.taskSourceFlag + "History";
        }
        Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, HISTORY_MAP.get(this.taskSourceFlag), false, this.endTime);
        return taskEntity;
    }

    protected TaskEntity getTask() {
        return this.task;
    }

    protected TaskEntity initTask(CommandContext commandContext, TaskEntity task, ExecutionEntity execution) {
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        IdGenerator idGenerator = pec.getIdGenerator();
        TaskEntity taskEntity = new TaskEntity();
        taskEntity.setNewTask(true);
        taskEntity.copyTaskPropertyAsHistory((TaskInfo)task);
        taskEntity.setNameTranslateKey(task.getNameTranslateKey());
        taskEntity.setTaskDefinition(task.getTaskDefinition());
        taskEntity.setCreateTime(this.startTime);
        taskEntity.setProcessInstanceId(execution.getProcessInstanceId());
        taskEntity.setExecutionId(execution.getId());
        String taskId = idGenerator.getNextId();
        taskEntity.setId(taskId);
        taskEntity.setExecution(execution);
        taskEntity.setAssignee(this.userId);
        taskEntity.setSendUser(this.userId);
        taskEntity.setCompleteType(this.taskSourceFlag);
        taskEntity.setTaskSourceFlag(this.taskSourceFlag);
        taskEntity.setFormId(task.getFormId());
        return taskEntity;
    }

    protected void dataPush(DataPush dataPush) {
        this.dataPushService.completeDataPush(dataPush);
    }

    public AddHistoryTaskCmd(TaskEntity task, String comment, String userId, String taskSourceFlag) {
        this.task = task;
        this.comment = comment;
        this.startTime = new Date();
        this.userId = userId;
        this.taskSourceFlag = taskSourceFlag;
    }

    private ParamModel getParamModel(TaskEntity task) {
        ParamModel paramModel = new ParamModel();
        paramModel.setCompleteType("transfer");
        String sendUser = task.getSendUser();
        paramModel.setSendUser(sendUser);
        paramModel.setLastNodeId(task.getAllPrevNode());
        paramModel.setActivityType("userTask");
        return paramModel;
    }
}

