/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActHiProcinst;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActHiProcinstService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.service.WorkflowCommonCacheService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmSecurityUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.util.BpmMsgDetailBuildUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.vo.SysActUrgeTaskVo;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import com.jxdinfo.hussar.workflow.util.ActivitiTranslateUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class SysActUrgeTaskServiceImpl
extends HussarServiceImpl<SysActUrgeTaskMapper, SysActUrgeTask>
implements ISysActUrgeTaskService {
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private TaskService taskService;
    @Autowired
    private ITaskEngineService taskEngineService;
    @Autowired
    private DataPushService dataPushService;
    @Resource
    private HistoryService historyService;
    @Resource
    private IFlowTaskService flowTaskService;
    private static final Logger logger = LoggerFactory.getLogger(SysActUrgeTaskServiceImpl.class);
    @Autowired
    private BpmMsgPushService msgPushService;
    @Autowired
    private WorkflowCommonCacheService workflowCommonCacheService;
    @Autowired
    private IBpmActHiProcinstService bpmActHiProcinstService;

    public ApiResponse<Page<SysActUrgeTaskVo>> query(Page<SysActUrgeTaskVo> pages, String userId, String processKey, String sendUser, String startTime, String endTime, String todoConfiguration) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            Date date = end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
            if (HussarUtils.isNotEmpty((Object)end)) {
                end = new Date(end.getTime() + 999L);
            }
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List<SysActUrgeTaskVo> sysActUrgeTasksVo = this.sysActUrgeTaskMapper.query(pages, userId, processKey, sendUser, start, end, todoConfiguration);
        if (sysActUrgeTasksVo != null && !sysActUrgeTasksVo.isEmpty()) {
            ArrayList users = new ArrayList();
            sysActUrgeTasksVo.forEach(sysActUrgeTask -> {
                users.add(sysActUrgeTask.getSendUser());
                if (HussarUtils.isNotEmpty((Object)sysActUrgeTask.getOwner())) {
                    users.add(sysActUrgeTask.getOwner());
                }
            });
            Map map = this.iAssigneeChooseService.getUserListByUserId(users);
            for (SysActUrgeTaskVo sysActUrgeTaskVo : sysActUrgeTasksVo) {
                String modelType;
                String appId;
                String userName = (String)map.get(sysActUrgeTaskVo.getSendUser());
                sysActUrgeTaskVo.setSendUserName(userName);
                String formKey = sysActUrgeTaskVo.getFormKey();
                if (HussarUtils.isNotEmpty((Object)sysActUrgeTaskVo.getOwner())) {
                    sysActUrgeTaskVo.setTaskId(sysActUrgeTaskVo.getTaskId() + ":" + sysActUrgeTaskVo.getOwner());
                    sysActUrgeTaskVo.setTaskName(sysActUrgeTaskVo.getTaskName() + "(" + (String)map.get(sysActUrgeTaskVo.getOwner()) + ")");
                }
                if (HussarUtils.isNotEmpty((Object)formKey)) {
                    JSONObject object = JSON.parseObject((String)formKey);
                    sysActUrgeTaskVo.setWeb(object.getString("web"));
                    sysActUrgeTaskVo.setMobile(object.getString("mobile"));
                }
                if (HussarUtils.isNotEmpty((Object)(appId = this.flowTaskService.getProcessAppId(sysActUrgeTaskVo.getProcDefKey())))) {
                    sysActUrgeTaskVo.setAppId(appId);
                }
                if ("0".equals(modelType = this.workflowCommonCacheService.getProcessModelType(sysActUrgeTaskVo.getProcDefKey()))) {
                    sysActUrgeTaskVo.setProcessType("0");
                } else {
                    sysActUrgeTaskVo.setProcessType("1");
                }
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.eq(BpmActHiProcinst::getProcInstId, (Object)sysActUrgeTaskVo.getProcessInsId());
                BpmActHiProcinst bpmActHiProcinst = (BpmActHiProcinst)this.bpmActHiProcinstService.getOne((Wrapper)lambdaQueryWrapper);
                sysActUrgeTaskVo.setProcessTitle(bpmActHiProcinst.getProcessTitle());
                sysActUrgeTaskVo.setSecurityLevel(BpmSecurityUtil.getSecurityLevelLabel(bpmActHiProcinst.getSecurityLevel()));
            }
        }
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(sysActUrgeTasksVo, SysActUrgeTaskVo.class).translate(SysActUrgeTaskVo::getTaskNameTranslateKey, SysActUrgeTaskVo::setTaskName).translate(SysActUrgeTaskVo::getProcNameTranslateKey, SysActUrgeTaskVo::setProcName).execute();
        pages.setRecords(sysActUrgeTasksVo);
        return ApiResponse.success(pages);
    }

    public String urgeTask(String processInsId, String businessId, String taskId, String userId) {
        ProcessInstance processInstance = null;
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).taskId(taskId)).singleResult();
            if (historicTaskInstance == null) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND.getMessage());
            }
            if (TaskType.isAssistHistory((String)historicTaskInstance.getTaskType())) {
                String processInstanceId = historicTaskInstance.getProcessInstanceId();
                processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
                if (processInstance == null) {
                    throw new BpmException(BpmExceptionCodeEnum.NOT_PROCESS_INSTANCE.getMessage());
                }
                this.urgeTodoTask(processInstance, processInstanceId, taskId, userId);
            }
            return BpmExceptionCodeEnum.URGE_SUCCESS.getMessage();
        }
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        } else if (HussarUtils.isNotEmpty((Object)businessId)) {
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        } else {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL.getMessage());
        }
        if (processInstance == null) {
            throw new BpmException(BpmExceptionCodeEnum.PROCESS_END.getMessage());
        }
        if (processInstance.isSuspended()) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_URGE_WITH_SUSPENSION);
        }
        this.urgeTodoTask(processInstance, processInstance.getProcessInstanceId(), null, userId);
        this.recursiveUrgeSubProcess(processInstance.getProcessInstanceId(), userId);
        return BpmExceptionCodeEnum.URGE_SUCCESS.getMessage();
    }

    private void recursiveUrgeSubProcess(String processInsId, String userId) {
        if (HussarUtils.isEmpty((Object)processInsId)) {
            return;
        }
        List executionList = this.runtimeService.createExecutionQuery().processInstanceId(processInsId).list();
        List superExecutionIds = executionList.stream().map(Execution::getId).collect(Collectors.toList());
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInsId).superExecutionIds(superExecutionIds).list();
        for (ProcessInstance processInstance : processInstanceList) {
            this.urgeTodoTask(processInstance, processInstance.getProcessInstanceId(), null, userId);
            this.recursiveUrgeSubProcess(processInstance.getProcessInstanceId(), userId);
        }
    }

    private void urgeTodoTask(ProcessInstance processInstance, String processInsId, String taskId, String userId) {
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).taskId(taskId)).singleResult();
            if (historicTaskInstance == null) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND.getMessage());
            }
            if (TaskType.isAssist((String)historicTaskInstance.getTaskType())) {
                throw new BpmException(BpmExceptionCodeEnum.ASSIST_TASK_FORBID_URGE.getMessage());
            }
        }
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().queryChildTask()).processInstanceId(processInsId)).list();
        ArrayList<SysActUrgeTask> list = new ArrayList<SysActUrgeTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        int urgeTaskNum = 0;
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (Task task : tasks) {
            if (HussarUtils.isNotEmpty((Object)taskId) && !taskId.equals(task.getCreateHistoryTaskId()) || HussarUtils.isEmpty((Object)taskId) && task.getCreateHistoryTaskId() != null) continue;
            taskIds.add(Long.valueOf(task.getId()));
            ++urgeTaskNum;
            Collection<IdentityLink> identityLinks = this.getAssigneeByTaskId(task.getId());
            if (identityLinks.isEmpty()) continue;
            for (IdentityLink identityLink : identityLinks) {
                SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
                sysActUrgeTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                sysActUrgeTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
                sysActUrgeTask.setProcName(processInstance.getProcessDefinitionName());
                sysActUrgeTask.setProcNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)task.getProcessDefinitionId(), null));
                sysActUrgeTask.setTaskName(task.getName());
                sysActUrgeTask.setTaskNameTranslateKey(task.getNameTranslateKey());
                sysActUrgeTask.setSendUser(userId);
                sysActUrgeTask.setReceiveUser(identityLink.getUserId());
                sysActUrgeTask.setSendTime(ts);
                sysActUrgeTask.setFormKey(task.getFormKey());
                sysActUrgeTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActUrgeTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActUrgeTask.setBusinessId(processInstance.getBusinessKey());
                sysActUrgeTask.setTaskState(identityLink.getTaskState());
                sysActUrgeTask.setOwner(identityLink.getMandator());
                sysActUrgeTask.setToDoConfig(task.getTodoConfiguration());
                list.add(sysActUrgeTask);
            }
        }
        if (HussarUtils.isNotEmpty((Object)taskId) && urgeTaskNum == 0) {
            throw new BpmException(BpmExceptionCodeEnum.URGE_FINISH_ASSIST_TASK);
        }
        if (!list.isEmpty()) {
            this.saveBatch(list);
            this.sysActUrgeTaskMapper.updateRuTaskUrgeState(taskIds);
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            for (Task task : tasks) {
                Set users = this.getAssigneeByTaskId(task.getId()).stream().map(IdentityLink::getUserId).collect(Collectors.toSet());
                BpmActMsgDetail bpmActMsgDetail = BpmMsgDetailBuildUtil.taskMsgDetail((TaskEntity)((TaskEntity)task), new ArrayList(users), (String)"reminders");
                bpmActMsgDetailList.add(bpmActMsgDetail);
                HashSet<String> processDefinitionIdList = new HashSet<String>();
                processDefinitionIdList.add(task.getProcessDefinitionId());
                if (users.isEmpty() || !this.dataPushService.isDataPush(processDefinitionIdList)) continue;
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(task.getId());
                dataPush.setTaskDefinitionName(task.getName());
                dataPush.setTaskDefinitionNameTranslateKey(task.getNameTranslateKey());
                dataPush.setUserId(String.join((CharSequence)",", users));
                dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
                dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
                dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
                dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
                dataPush.setSendUser(userId);
                dataPush.setStartDate(task.getCreateTime());
                dataPush.setEndDate(new Date());
                dataPush.setUrl(task.getFormKey());
                dataPush.setDescription(task.getTodoConfiguration());
                dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
                dataPush.setProcessNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)task.getProcessDefinitionId(), (String)task.getTaskDefinitionKey()));
                dataPush.setProcessInsId(task.getProcessInstanceId());
                dataPush.setUrgeUserId(userId);
                dataPush.setUrgeTime(new Date());
                this.dataPushService.addUrgeTask(dataPush);
            }
            this.msgPushService.pushMessage(bpmActMsgDetailList);
        }
    }

    public String urgeTaskByTaskId(String taskId, String userId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        Task task = this.taskEngineService.getTask(taskId, "1");
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(Long.parseLong(taskId));
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        ArrayList<SysActUrgeTask> list = new ArrayList<SysActUrgeTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        Collection<IdentityLink> identityLinks = this.getAssigneeByTaskId(task.getId());
        if (!identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
                sysActUrgeTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                sysActUrgeTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
                sysActUrgeTask.setProcName(processInstance.getProcessDefinitionName());
                sysActUrgeTask.setProcNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)task.getProcessDefinitionId(), null));
                sysActUrgeTask.setTaskName(task.getName());
                sysActUrgeTask.setTaskNameTranslateKey(task.getNameTranslateKey());
                sysActUrgeTask.setSendUser(userId);
                sysActUrgeTask.setReceiveUser(identityLink.getUserId());
                sysActUrgeTask.setSendTime(ts);
                sysActUrgeTask.setFormKey(task.getFormKey());
                sysActUrgeTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActUrgeTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActUrgeTask.setBusinessId(processInstance.getBusinessKey());
                sysActUrgeTask.setTaskState(identityLink.getTaskState());
                sysActUrgeTask.setOwner(identityLink.getMandator());
                sysActUrgeTask.setToDoConfig(task.getTodoConfiguration());
                list.add(sysActUrgeTask);
            }
        }
        if (!list.isEmpty()) {
            this.saveBatch(list);
            this.sysActUrgeTaskMapper.updateRuTaskUrgeState(taskIds);
            HistoricProcessInstance hisProcInst = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            Set users = this.getAssigneeByTaskId(task.getId()).stream().map(IdentityLink::getUserId).collect(Collectors.toSet());
            BpmActMsgDetail bpmActMsgDetail = BpmMsgDetailBuildUtil.taskMsgDetail((TaskEntity)((TaskEntity)task), new ArrayList(users), (String)"reminders");
            bpmActMsgDetailList.add(bpmActMsgDetail);
            this.msgPushService.pushMessage(bpmActMsgDetailList);
            HashSet<String> processDefinitionIdList = new HashSet<String>();
            processDefinitionIdList.add(task.getProcessDefinitionId());
            if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(task.getId());
                dataPush.setTaskDefinitionName(task.getName());
                dataPush.setTaskDefinitionNameTranslateKey(task.getNameTranslateKey());
                dataPush.setUserId(String.join((CharSequence)",", identityLinks.stream().map(IdentityLink::getUserId).collect(Collectors.toSet())));
                dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
                dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
                dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
                dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
                dataPush.setSendUser(userId);
                dataPush.setStartDate(task.getCreateTime());
                dataPush.setEndDate(new Date());
                dataPush.setUrl(task.getFormKey());
                dataPush.setDescription(task.getTodoConfiguration());
                dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
                dataPush.setProcessNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)task.getProcessDefinitionId(), (String)task.getTaskDefinitionKey()));
                dataPush.setProcessInsId(task.getProcessInstanceId());
                dataPush.setUrgeUserId(userId);
                dataPush.setUrgeTime(new Date());
                dataPush.setStartUserId(historicProcessInstance.getStartUserId());
                this.dataPushService.addUrgeTask(dataPush);
            }
        }
        return BpmExceptionCodeEnum.URGE_SUCCESS.getMessage();
    }

    private Collection<IdentityLink> getAssigneeByTaskId(String taskId) {
        return this.taskService.getIdentityLinksType(taskId);
    }
}

