/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processtest.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActHiProcinstMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActHiActinst;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActHiProcinst;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActHiActinstService;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActHiProcinstService;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRejectDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processtest.VariableHandler;
import com.jxdinfo.hussar.workflow.engine.bpm.processtest.dao.ProcessTestMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processtest.service.AsyncDSCompleteTask;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowElements;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ConfiguredInstanceVariableDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ConfiguredVariableDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.NodeDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ProcessTestTaskInfoDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ProcessTestingParamDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ReceiveTaskReleaseDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.TestStartProcessInsDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.TestTaskCompleteDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.SysActTestDetail;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.SysActTestLog;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.NodeService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.ProcessTestingService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.TestLogDetailService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.TestLogService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.VariableService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.vo.AllVariablesConfiguredInProcessVo;
import com.jxdinfo.hussar.workflow.godaxe.processtest.vo.NodeVo;
import com.jxdinfo.hussar.workflow.manage.bpm.constant.CallActivityInfo;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@Scope(value="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class ProcessTestingServiceImpl
implements ProcessTestingService,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ProcessTestingServiceImpl.class);
    private List<NodeVo> processNodes;
    private Map<String, Map<String, List<NodeDto>>> mappingFromProcessOnlyIdToNodeMapping;
    private Map<String, List<String>> mappingFromNodeOnlyIdToAssignee;
    private Map<String, List<NodeDto>> mappingFromProcessOnlyIdToNodes;
    private Map<String, List<String>> visitedAssigneeMap = new HashMap<String, List<String>>();
    private static final Map<String, String> TASK_SOURCE_FLAG = new HashMap<String, String>();
    private static final String NO_START_NODE = "\u672a\u627e\u5230\u5f00\u59cb\u8282\u70b9";
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private SeqBuilder seqBuilder;
    @Resource
    private HistoryService historyService;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private BpmActHiProcinstMapper bpmActHiProcinstMapper;
    @Autowired
    private VariableHandler variableHandler;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private AsyncDSCompleteTask asyncDSCompleteTask;
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;
    @Resource
    private ProcessTestMapper processTestMapper;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    @Autowired
    private TestLogDetailService testLogDetailService;
    @Autowired
    private TestLogService testLogService;
    @Autowired
    private VariableService variableService;
    @Autowired
    private IBpmActHiActinstService bpmActHiActinstService;
    @Autowired
    private IBpmActHiProcinstService bpmActHiProcinstService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Resource
    private ProcessEngine processEngine;
    @Resource
    private RuntimeService runtimeService;

    public ApiResponse<JSONObject> testProcess(ProcessTestingParamDto processTestingParam) {
        ApiResponse apiResponse = ApiResponse.success();
        try {
            List<NodeVo> processNodes = processTestingParam.getNodes().stream().map(n -> (NodeVo)n.get(0)).collect(Collectors.toList());
            AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess = processTestingParam.getAllVariablesConfiguredInProcess();
            String processVersion = processTestingParam.getProcessVersion();
            String processDefinitionId = allVariablesConfiguredInProcess.getProcessDefinitionId();
            boolean loopProcess = this.adjustLoop(processDefinitionId);
            this.variableHandler.clearBind();
            this.variableHandler.clearVisitedNodeOnlyIdWithCompleteTask();
            this.variableHandler.clearVisitedNodeOnlyIdWithGenerateToDoTask();
            this.variableHandler.clearVisitedProcessOnlyId();
            this.variableHandler.setAllVariablesConfiguredInProcess(allVariablesConfiguredInProcess);
            this.variableHandler.setNodeMapping(processNodes);
            this.variableHandler.setMappingFromProcessOnlyIdToProcessKey(processNodes);
            this.neatenNodes(processNodes);
            this.generateNodeAndAssigneeMapping(allVariablesConfiguredInProcess);
            HashMap<String, Object> initVariable = new HashMap<String, Object>();
            List configuredInstanceVariables = allVariablesConfiguredInProcess.getConfiguredInstanceVariables();
            for (ConfiguredInstanceVariableDto configuredInstanceVariableDto : configuredInstanceVariables) {
                if (!BpmNodeTypeUtil.isAnnotation((String)configuredInstanceVariableDto.getType())) continue;
                List ConfiguredVariableList = configuredInstanceVariableDto.getConfiguredVariables();
                for (ConfiguredVariableDto configuredVariable : ConfiguredVariableList) {
                    initVariable.put(configuredVariable.getName(), configuredVariable.getValue());
                }
            }
            JSONArray startTask = null;
            String mainProcessBusinessKey = null;
            String mainProcessKey = allVariablesConfiguredInProcess.getProcessKey();
            String mainProcessOnlyId = allVariablesConfiguredInProcess.getOnlyId();
            mainProcessBusinessKey = this.generateBusinessKey();
            String starter = allVariablesConfiguredInProcess.getStarter();
            ArrayList<AllVariablesConfiguredInProcessVo> list = new ArrayList<AllVariablesConfiguredInProcessVo>();
            list.add(allVariablesConfiguredInProcess);
            this.clearAllCallActivityInfo(list);
            if (HussarUtils.isNotEmpty((Object)allVariablesConfiguredInProcess.getAllVariablesConfiguredInExternalSubProcesses())) {
                this.addCallActivityInfoBeforeStart(allVariablesConfiguredInProcess);
            }
            startTask = this.startTestProcessInstance(mainProcessOnlyId, mainProcessKey, processVersion, mainProcessBusinessKey, starter, processDefinitionId, initVariable);
            String tcode = HussarContextHolder.getHussarTenant().getTenantCode();
            String dataSourceName = this.dynamicDatasourceService.getCurrentDatasourceName();
            ServletRequestAttributes newServletRequestAttributes = HussarContextHolder.getNewServletRequestAttributes((String)tcode);
            List taskInfoDtoList = (List)this.getTodoList(mainProcessBusinessKey, ((JSONObject)startTask.get(0)).getString("processInsId")).getData();
            if (HussarUtils.isNotEmpty((Object)taskInfoDtoList)) {
                startTask = JSONArray.parseArray((String)JSON.toJSONString((Object)taskInfoDtoList));
            }
            this.asyncDSCompleteTask.circularlyCompleteTask(allVariablesConfiguredInProcess, startTask, starter, this.mappingFromProcessOnlyIdToNodeMapping, this.mappingFromNodeOnlyIdToAssignee, mainProcessBusinessKey, tcode, dataSourceName, newServletRequestAttributes);
            String mainProcessProcessInstanceId = (String)((JSONObject)startTask.get(0)).get((Object)"processInsId");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("mainProcessInstanceId", (Object)mainProcessProcessInstanceId);
            jsonObject.put("mainProcessBusinessId", (Object)mainProcessBusinessKey);
            apiResponse = ApiResponse.success((Object)jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    private void generateNodeAndAssigneeMapping(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        List<String> processOnlyIds = this.findProcessOnlyIds();
        this.mappingFromProcessOnlyIdToNodeMapping = new HashMap<String, Map<String, List<NodeDto>>>();
        this.mappingFromNodeOnlyIdToAssignee = new HashMap<String, List<String>>();
        for (String processOnlyId : processOnlyIds) {
            this.generateNodeMapping(processOnlyId);
            this.generateAssigneeMapping(allVariablesConfiguredInProcess, processOnlyId);
        }
    }

    private List<String> findProcessOnlyIds() {
        ArrayList<String> processOnlyIds = new ArrayList<String>();
        this.processNodes.forEach(processNode -> processOnlyIds.add(processNode.getOnlyId()));
        return processOnlyIds;
    }

    private void generateNodeMapping(String processOnlyId) {
        List<NodeDto> nodes = this.mappingFromProcessOnlyIdToNodes.get(processOnlyId);
        Map mappingFromNodeKeyToNodes = this.nodeService.groupNodeByKey(nodes);
        this.mappingFromProcessOnlyIdToNodeMapping.put(processOnlyId, mappingFromNodeKeyToNodes);
    }

    private void generateAssigneeMapping(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess, String processOnlyId) {
        List<NodeDto> nodes = this.mappingFromProcessOnlyIdToNodes.get(processOnlyId);
        this.mappingFromNodeOnlyIdToAssignee.putAll(this.nodeService.groupAssigneeByNodeOnlyId(allVariablesConfiguredInProcess, nodes));
    }

    private Map<String, List<String>> groupOnlyIdByProcessKey() {
        return this.processNodes.stream().collect(Collectors.groupingBy(processNode -> processNode.getProcessKey(), Collectors.mapping(processNode -> processNode.getOnlyId(), Collectors.toList())));
    }

    private void neatenNodes(List<NodeVo> processNodes) {
        this.processNodes = processNodes;
        this.mappingFromProcessOnlyIdToNodes = this.nodeService.parse(processNodes);
    }

    private JSONArray startTestProcessInstance(String mainProcessOnlyId, String processKey, String processVersion, String businessKey, String processStarter, String processDefinitionId, Map<String, Object> initVariable) throws BpmException {
        NodeDto startNode = this.findStartNode(mainProcessOnlyId);
        this.variableHandler.clearBind();
        this.variableHandler.clearVisitedNodeOnlyIdWithCompleteTask();
        this.variableHandler.clearVisitedNodeOnlyIdWithGenerateToDoTask();
        this.variableHandler.clearVisitedProcessOnlyId();
        if (processDefinitionId == null || !processDefinitionId.contains(":")) {
            processDefinitionId = HussarUtils.isNotEmpty((Object)processVersion) ? this.processDefinitionsService.getStartProcessDefinitionId(processKey, processVersion) : this.processDefinitionsService.getLastProcessDefinitionId(processKey);
        }
        this.variableHandler.setCompletingNode(startNode);
        Map<String, Object> variable = this.variableHandler.findNodeVariableBy(startNode, processKey, mainProcessOnlyId);
        variable.putAll(this.variableHandler.findPathVariableBy(startNode.getKey(), processKey, mainProcessOnlyId));
        variable.putAll(initVariable);
        this.variableHandler.bindProcessOnlyIdToBusinessId(businessKey, mainProcessOnlyId);
        variable.put("isEmulation", "1");
        BpmResponseResult startResult = InstanceEngineService.startProcessInstanceById((String)processDefinitionId, (String)processStarter, (String)businessKey, variable);
        if ("1".equals(startResult.getCode())) {
            return startResult.getResult();
        }
        throw new BpmException(startResult.getMsg());
    }

    private String generateBusinessKey() {
        Sequence sequence = this.seqBuilder.build();
        return String.valueOf(sequence.nextValue());
    }

    private NodeDto findStartNode(String mainProcessOnlyId) {
        if (HussarUtils.isNotEmpty(this.mappingFromProcessOnlyIdToNodes)) {
            List<NodeDto> processNodes = this.mappingFromProcessOnlyIdToNodes.get(mainProcessOnlyId);
            return processNodes.get(0);
        }
        throw new BpmException(NO_START_NODE);
    }

    private List<String> findIdsFrom(List<BpmTreeModel> bpmTreeModels) {
        ArrayList<String> Ids = new ArrayList<String>();
        for (BpmTreeModel bpmTreeModel : bpmTreeModels) {
            Ids.add(bpmTreeModel.getId());
        }
        return Ids;
    }

    private String getBusinessIdBy(String processInstanceId) {
        return ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()).getBusinessKey();
    }

    private JSONObject findTask(List<JSONObject> tasks, String assigneeId, String processOnlyId, String nodeKey) throws BpmException {
        NodeDto currentNode = this.mappingFromProcessOnlyIdToNodeMapping.get(processOnlyId).get(nodeKey).get(0);
        for (JSONObject task : tasks) {
            if (!nodeKey.equals(task.get((Object)"taskDefinitionKey"))) continue;
            HashSet userIds = new HashSet();
            if (HussarUtils.isNotEmpty((Object)task.get((Object)"assignee"))) {
                userIds.add(String.valueOf(task.get((Object)"assignee")));
            } else {
                userIds = (HashSet)task.get((Object)"userId");
            }
            if (userIds == null || !userIds.contains(assigneeId)) continue;
            return task;
        }
        if (assigneeId == null && !currentNode.isCountersign()) {
            throw new BpmException(String.format(this.bpmConstantProperties.getNoNodeAssignee(), currentNode.getName()));
        }
        if (assigneeId == null && currentNode.isCountersign()) {
            throw new BpmException(String.format(this.bpmConstantProperties.getInsufficientNumberOfMultiNodeAssignee(), currentNode.getName()));
        }
        throw new BpmException(String.format(this.bpmConstantProperties.getNodeNoAuthority(), currentNode.getName()));
    }

    public Map<String, Object> findNodeVariable(JSONObject currentTask, String processOnlyId) {
        String subProcessKey = null;
        if (HussarUtils.isEmpty((Object)currentTask.get((Object)"subProcessKey")) && HussarUtils.isEmpty((Object)currentTask.get((Object)"process_key"))) {
            String currentTaskId = (String)currentTask.get((Object)"taskId");
            ((HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(currentTaskId)).singleResult()).getSubProcessKey();
        } else {
            subProcessKey = (String)currentTask.get((Object)"subProcessKey");
        }
        if (HussarUtils.isNotEmpty((Object)subProcessKey)) {
            String separateVariable = subProcessKey.split(":")[1].trim();
            Map<Object, Object> variables = new HashMap();
            variables = this.findInternalSubProcessNodeVariable(currentTask, separateVariable, processOnlyId);
            variables.putAll(this.findMainProcessNodeVariable(currentTask, processOnlyId));
            return variables;
        }
        return this.findMainProcessNodeVariable(currentTask, processOnlyId);
    }

    private Map<String, Object> findPathVariable(JSONObject currentTask, String processOnlyId) {
        String currentNodeKey = (String)currentTask.get((Object)"taskDefinitionKey");
        String currentTaskId = (String)currentTask.get((Object)"taskId");
        String processKey = this.findProcessKeyBy(currentTaskId);
        return this.variableHandler.findPathVariableBy(currentNodeKey, processKey, processOnlyId);
    }

    private Map<String, Object> findInternalSubProcessNodeVariable(JSONObject currentTask, String separateVariable, String processOnlyId) {
        String processKey;
        String currentNodeKey = (String)currentTask.get((Object)"taskDefinitionKey");
        String string = processKey = currentTask.get((Object)"process_key") == null ? null : String.valueOf(currentTask.get((Object)"process_key"));
        if (HussarUtils.isEmpty((Object)processKey)) {
            String currentTaskId = (String)currentTask.get((Object)"taskId");
            processKey = this.findProcessKeyBy(currentTaskId);
        }
        List<NodeDto> currentNodes = this.variableHandler.listNodesBy(processOnlyId, currentNodeKey);
        for (NodeDto currentNode : currentNodes) {
            if (!separateVariable.equals(currentNode.getSeparateVariable())) continue;
            this.variableHandler.setCompletingNode(currentNode);
            return this.variableHandler.findNodeVariableBy(currentNode, processKey, processOnlyId);
        }
        return new HashMap<String, Object>();
    }

    private Map<String, Object> findMainProcessNodeVariable(JSONObject currentTask, String processOnlyId) {
        String currentNodeKey = (String)currentTask.get((Object)"taskDefinitionKey");
        String processInstanceId = (String)currentTask.get((Object)"processInsId");
        String businessId = this.getBusinessIdBy(processInstanceId);
        String currentTaskId = (String)currentTask.get((Object)"taskId");
        String processKey = this.findProcessKeyBy(currentTaskId);
        NodeDto currentNode = this.variableHandler.listNodesBy(processOnlyId, currentNodeKey).get(0);
        this.variableHandler.setCompletingNode(currentNode);
        Map<String, Object> variable = this.variableHandler.findNodeVariableBy(currentNode, processKey, processOnlyId);
        variable.putAll(this.findNextNodeVariableIfNextNodeIsExternalOrInternalSubProcessNode(currentNode, processOnlyId, businessId));
        return variable;
    }

    private String findProcessKeyBy(String taskId) {
        HistoricTaskInstance taskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        String processDefinitionId = taskInstance.getProcessDefinitionId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        return processDefinition.getKey();
    }

    private Map<String, Object> findNextNodeVariableIfNextNodeIsExternalOrInternalSubProcessNode(NodeDto node, String processOnlyId, String businessId) {
        HashMap<String, Object> variable = new HashMap<String, Object>();
        List nextNodeKeys = node.getNextNodeKey();
        ArrayList<CallActivityInfo> mappingFromNodeIdToCallActivityInfos = new ArrayList<CallActivityInfo>();
        for (String nextNodeKey : nextNodeKeys) {
            NodeDto nextNode = this.mappingFromProcessOnlyIdToNodeMapping.get(processOnlyId).get(nextNodeKey).get(0);
            if (!BpmNodeTypeUtil.isCallActivity((String)nextNode.getType())) continue;
            mappingFromNodeIdToCallActivityInfos.addAll(this.variableHandler.findExternalSubProcessNodeVariable(nextNode));
        }
        return variable;
    }

    private String findAssigneeIdBy(JSONObject currentTask, String processOnlyId) {
        return this.findMainAndInternalSubProcessAssigneeIdBy(currentTask, processOnlyId);
    }

    private String findMainAndInternalSubProcessAssigneeIdBy(JSONObject currentTask, String processOnlyId) {
        String assigneeId = null;
        String currentNodeKey = (String)currentTask.get((Object)"taskDefinitionKey");
        String currentTaskId = (String)currentTask.get((Object)"taskId");
        String processInstanceId = (String)currentTask.get((Object)"processInsId");
        String businessId = this.getBusinessIdBy(processInstanceId);
        String subProcessKey = ((HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(currentTaskId)).singleResult()).getSubProcessKey();
        if (HussarUtils.isNotEmpty((Object)subProcessKey)) {
            String separateVariable = subProcessKey.split(":")[1].trim();
            assigneeId = this.findInternalSubProcessAssigneeIdBy(currentNodeKey, separateVariable, processOnlyId, businessId);
        } else {
            assigneeId = this.findMainProcessAssigneeIdBy(currentNodeKey, processOnlyId, businessId);
        }
        this.updateStarter(currentTask, assigneeId);
        return assigneeId;
    }

    private String findInternalSubProcessAssigneeIdBy(String currentNodeKey, String separateVariable, String processOnlyId, String businessId) {
        String assigneeId = null;
        List<NodeDto> internalSubProcessNodes = this.mappingFromProcessOnlyIdToNodeMapping.get(processOnlyId).get(currentNodeKey);
        if (internalSubProcessNodes.size() == 1) {
            NodeDto internalSubProcessNode = internalSubProcessNodes.get(0);
            String currentNodeOnlyId = internalSubProcessNode.getOnlyId();
            assigneeId = this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId) == null || this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId).size() == 0 ? null : this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId).get(0);
        } else {
            for (NodeDto internalSubProcessNode : internalSubProcessNodes) {
                if (!separateVariable.equals(internalSubProcessNode.getSeparateVariable())) continue;
                String currentNodeOnlyId = internalSubProcessNode.getOnlyId();
                assigneeId = this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId) == null || this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId).size() == 0 ? null : this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId).get(0);
            }
        }
        return assigneeId;
    }

    private String findMainProcessAssigneeIdBy(String currentNodeKey, String processOnlyId, String businessId) {
        NodeDto currentNode = this.mappingFromProcessOnlyIdToNodeMapping.get(processOnlyId).get(currentNodeKey).get(0);
        String currentNodeOnlyId = currentNode.getOnlyId();
        String assigneeId = null;
        if (HussarUtils.isNotEmpty(this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId))) {
            List<Object> visitedAssigneeIds = null;
            String businessAndNodeTag = businessId + ":" + currentNodeOnlyId;
            visitedAssigneeIds = HussarUtils.isNotEmpty(this.visitedAssigneeMap.get(businessAndNodeTag)) ? this.visitedAssigneeMap.get(businessAndNodeTag) : new ArrayList();
            List<String> assigneeIds = this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId);
            for (String assId : assigneeIds) {
                if (visitedAssigneeIds.contains(assId)) continue;
                assigneeId = assId;
                break;
            }
        }
        return assigneeId;
    }

    private void updateStarter(JSONObject currentTask, String assigneeId) {
        String processInstanceId = (String)currentTask.get((Object)"processInsId");
        String startUserId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()).getStartUserId();
        if (HussarUtils.isEmpty((Object)startUserId)) {
            BpmActHiProcinst bpmActHiProcinst = (BpmActHiProcinst)this.bpmActHiProcinstMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BpmActHiProcinst::getId, (Object)Long.valueOf(processInstanceId)));
            bpmActHiProcinst.setStartUserId(assigneeId);
            this.bpmActHiProcinstMapper.updateById(bpmActHiProcinst);
        }
    }

    private BpmResponseResult completeTask(String currentTaskId, String assigneeId, Map<String, Object> variable) throws BpmException {
        BpmResponseResult bpmResponseResult = TaskEngineService.completeTask((String)currentTaskId, (String)assigneeId, new HashMap(), null, (String)"", variable);
        return bpmResponseResult;
    }

    private void addAssigneeToVisitedMap(JSONObject currentTask, String processOnlyId, String businessId, String assigneeId) {
        String currentNodeKey = (String)currentTask.get((Object)"taskDefinitionKey");
        NodeDto currentNode = this.mappingFromProcessOnlyIdToNodeMapping.get(processOnlyId).get(currentNodeKey).get(0);
        String currentNodeOnlyId = currentNode.getOnlyId();
        List<String> visitedAssigneeIds = null;
        String businessAndNodeTag = businessId + ":" + currentNodeOnlyId;
        visitedAssigneeIds = HussarUtils.isNotEmpty(this.visitedAssigneeMap.get(businessAndNodeTag)) ? this.visitedAssigneeMap.get(businessAndNodeTag) : new ArrayList<String>();
        visitedAssigneeIds.add(assigneeId);
        this.visitedAssigneeMap.put(businessAndNodeTag, visitedAssigneeIds);
    }

    private JSONObject assembleResult(String processInstanceId, String businessId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("mainProcessInstanceId", (Object)processInstanceId);
        jsonObject.put("mainProcessBusinessId", (Object)businessId);
        return jsonObject;
    }

    private boolean adjustLoop(String processDefinitionId) {
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessDefId(processDefinitionId, null, null);
        FlowModel flowModel = (FlowModel)JSONObject.parseObject((String)workFlow.getData(), FlowModel.class);
        FlowElements slots = flowModel.getSlots();
        FlowObject startFlowNode = new FlowObject();
        List elementsInProcess = slots.getElement();
        List flowSequence = slots.getPath();
        ArrayList<List<FlowObject>> flowNode = new ArrayList<List<FlowObject>>();
        for (FlowObject element : elementsInProcess) {
            String nodeKey = element.getInstanceKey();
            String nodeType = element.getName();
            if (!BpmNodeTypeUtil.isStart((String)nodeType)) continue;
            ArrayList<FlowObject> node = new ArrayList<FlowObject>();
            startFlowNode = element;
            node.add(element);
            flowNode.add(node);
            break;
        }
        return this.getAllNextNode(flowNode, elementsInProcess, flowSequence);
    }

    private boolean getAllNextNode(List<List<FlowObject>> node, List<FlowObject> elementsInProcess, List<FlowSequence> flowSequence) {
        if (HussarUtils.isNotEmpty(node)) {
            for (List<FlowObject> list : node) {
                FlowObject flowObject = list.get(list.size() - 1);
                List goOutPath = flowObject.getGoOutPathes();
                for (String path : goOutPath) {
                    String nextNodeId = this.getNextNodeIdByPath(path, flowSequence);
                    for (FlowObject object : list) {
                        if (!HussarUtils.isNotEmpty((Object)nextNodeId) || !nextNodeId.equals(object.getNodeId())) continue;
                        return false;
                    }
                    FlowObject nextNode = this.getNodeObjectByNodeId(nextNodeId, elementsInProcess);
                    list.add(nextNode);
                    if (!BpmNodeTypeUtil.isEnd((String)nextNode.getType())) {
                        this.getAllNextNode(node, elementsInProcess, flowSequence);
                        continue;
                    }
                    node.remove(list);
                }
            }
            return true;
        }
        return false;
    }

    private String getNextNodeIdByPath(String path, List<FlowSequence> flowSequence) {
        for (FlowSequence sequence : flowSequence) {
            if (!path.equals(sequence.getId())) continue;
            return sequence.getEnd().getKey();
        }
        return null;
    }

    private FlowObject getNodeObjectByNodeId(String nodeId, List<FlowObject> flowObjects) {
        for (FlowObject flowObject : flowObjects) {
            if (!flowObject.getId().equals(nodeId)) continue;
            return flowObject;
        }
        return new FlowObject();
    }

    public ApiResponse<List<ProcessTestTaskInfoDto>> getTodoList(String businessId, String procInsId) {
        if (HussarUtils.isNotEmpty((Object)procInsId)) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(BpmActHiProcinst::getProcInstId, (Object)Long.valueOf(procInsId));
            BpmActHiProcinst bpmActHiProcinst = (BpmActHiProcinst)this.bpmActHiProcinstService.getOne((Wrapper)lambdaQueryWrapper);
            ArrayList<String> procInsIds = new ArrayList<String>();
            procInsIds.add(procInsId);
            List<Long> allProcInsId = this.getAllProcInsId(procInsIds);
            List<ProcessTestTaskInfoDto> list = this.processTestMapper.getAllTodoList(allProcInsId);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(BpmActHiActinst::getProcInstId, allProcInsId);
            queryWrapper.eq(BpmActHiActinst::getActType, (Object)"receiveTask");
            queryWrapper.isNull(BpmActHiActinst::getEndTime);
            List bpmActHiActinsts = this.bpmActHiActinstService.list((Wrapper)queryWrapper);
            for (Object bpmActHiActinst : bpmActHiActinsts) {
                ProcessTestTaskInfoDto processTestTaskInfoDto = new ProcessTestTaskInfoDto();
                String procDefId = bpmActHiActinst.getProcDefId();
                BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procDefId);
                String processName = ((Process)bpmnModel.getProcesses().get(0)).getName();
                processTestTaskInfoDto.setProcessInsId(String.valueOf(bpmActHiActinst.getProcInstId()));
                processTestTaskInfoDto.setProcessName(processName);
                processTestTaskInfoDto.setExecutionId(bpmActHiActinst.getExecutionId());
                processTestTaskInfoDto.setStartTime(bpmActHiActinst.getStartTime());
                processTestTaskInfoDto.setProcessKey(bpmActHiActinst.getProcDefId().split(":")[0]);
                processTestTaskInfoDto.setTaskDefinitionKey(bpmActHiActinst.getActId());
                processTestTaskInfoDto.setTaskDefinitionName(bpmActHiActinst.getActName());
                list.add(processTestTaskInfoDto);
            }
            List assigneeList = list.stream().map(ProcessTestTaskInfoDto::getAssignee).collect(Collectors.toList());
            for (ProcessTestTaskInfoDto processTestTaskInfoDto : list) {
                if (!HussarUtils.isNotEmpty((Object)processTestTaskInfoDto.getMandator())) continue;
                assigneeList.add(processTestTaskInfoDto.getMandator());
            }
            Map assigneeIdToNameMap = this.assigneeChooseService.getUserListByUserId(assigneeList);
            list.forEach(dto -> dto.setAssigneeName((String)assigneeIdToNameMap.get(dto.getAssignee())));
            list.forEach(dto -> dto.setOperationType(ProcessTestingServiceImpl.getStrTaskSourceFlag(dto.getOperationType())));
            for (ProcessTestTaskInfoDto processTestTaskInfoDto : list) {
                if (!HussarUtils.isNotEmpty((Object)processTestTaskInfoDto.getMandator())) continue;
                String manadatorName = (String)assigneeIdToNameMap.get(processTestTaskInfoDto.getMandator());
                processTestTaskInfoDto.setAssigneeName(processTestTaskInfoDto.getAssigneeName() + "(" + manadatorName + ")");
            }
            return ApiResponse.success(list);
        }
        return ApiResponse.success(new ArrayList());
    }

    public ApiResponse<List<ProcessTestTaskInfoDto>> getDoneList(String businessId, String procInsId) {
        ArrayList<String> procInsIds = new ArrayList<String>();
        procInsIds.add(procInsId);
        List<Long> allProcInsId = this.getAllProcInsId(procInsIds);
        List<ProcessTestTaskInfoDto> list = this.processTestMapper.getAllDoneList(allProcInsId);
        List userList = list.stream().map(ProcessTestTaskInfoDto::getUserId).collect(Collectors.toList());
        Map userIdToNameMap = this.assigneeChooseService.getUserListByUserId(userList);
        list.forEach(e -> e.setUserName((String)userIdToNameMap.get(e.getUserId())));
        list.forEach(e -> e.setOperationType(ProcessTestingServiceImpl.getStrTaskSourceFlag(e.getOperationType())));
        return ApiResponse.success(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpmResponseResult completeTask(TestTaskCompleteDto testTaskCompleteDto) {
        List<NodeVo> nodes = testTaskCompleteDto.getProcessNodes().stream().map(n -> (NodeVo)n.get(0)).collect(Collectors.toList());
        String userId = testTaskCompleteDto.getUserId();
        String taskId = testTaskCompleteDto.getTaskId();
        List taskInfoDtoList = (List)this.getTodoList(null, testTaskCompleteDto.getProcessInsId()).getData();
        JSONObject currentTask = new JSONObject();
        Long parentId = testTaskCompleteDto.getLogId();
        for (ProcessTestTaskInfoDto object : taskInfoDtoList) {
            if (!taskId.equals(object.getTaskId())) continue;
            currentTask = JSONObject.parseObject((String)JSON.toJSONString((Object)object));
            break;
        }
        BpmResponseResult bpmResponseResult = new BpmResponseResult();
        if (HussarUtils.isEmpty((Object)currentTask)) {
            return InstallResult.fail((String)this.bpmConstantProperties.getTaskNotFound());
        }
        String businessId = this.getBusinessIdBy(String.valueOf(currentTask.get((Object)"processInsId")));
        this.variableHandler.setAllVariablesConfiguredInProcess(testTaskCompleteDto.getAllVariablesConfiguredInProcessVo());
        this.variableHandler.setNodeMapping(nodes);
        this.variableHandler.setMappingFromProcessOnlyIdToProcessKey(nodes);
        this.neatenNodes(nodes);
        this.generateNodeAndAssigneeMapping(testTaskCompleteDto.getAllVariablesConfiguredInProcessVo());
        Date currentTime = new Date();
        try {
            String processOnlyId = this.variableHandler.getProcessOnlyIdBy(businessId);
            if (processOnlyId == null) {
                String finalProcessInstanceId = String.valueOf(currentTask.get((Object)"processInsId"));
                List superProcessMessageList = (List)this.processEngine.getManagementService().executeCommand(commandContext -> {
                    HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = commandContext.getHistoricProcessInstanceEntityManager();
                    HistoricProcessInstanceEntity processInstanceEntity = historicProcessInstanceEntityManager.findHistoricProcessInstance(finalProcessInstanceId);
                    ArrayList superProcessInstanceMessageList = new ArrayList();
                    String superProcessInstanceId = processInstanceEntity.getSuperProcessInstanceId();
                    if (superProcessInstanceId != null) {
                        String callProcessKey = processInstanceEntity.getProcessDefinitionKey();
                        String mainActId = processInstanceEntity.getMainActId();
                        processInstanceEntity = historicProcessInstanceEntityManager.findHistoricProcessInstance(superProcessInstanceId);
                        superProcessInstanceId = processInstanceEntity.getSuperProcessInstanceId();
                        HashMap<String, String> superProcessInstanceMessage = new HashMap<String, String>();
                        superProcessInstanceMessage.put("mainActId", mainActId);
                        superProcessInstanceMessage.put("businessKey", processInstanceEntity.getBusinessKey());
                        superProcessInstanceMessage.put("callProcessKey", callProcessKey);
                        superProcessInstanceMessageList.add(superProcessInstanceMessage);
                    }
                    return superProcessInstanceMessageList;
                });
                processOnlyId = this.variableHandler.resetBusinessIdOnlyIdMap(businessId, superProcessMessageList);
            }
            Map<String, Object> variable = this.findNodeVariable(currentTask, processOnlyId);
            Map callActivityInfo = new HashMap();
            if (HussarUtils.isNotEmpty((Object)testTaskCompleteDto.getAllVariablesConfiguredInProcessVo().getCallActivityInfo())) {
                callActivityInfo = (Map)testTaskCompleteDto.getAllVariablesConfiguredInProcessVo().getCallActivityInfo().get(processOnlyId);
            }
            variable.putAll(callActivityInfo == null ? new HashMap() : callActivityInfo);
            variable.putAll(this.findPathVariable(currentTask, processOnlyId));
            bpmResponseResult = this.completeTask(taskId, userId, variable);
            this.saveLog(bpmResponseResult, currentTask, currentTask.getString("processInsId"), businessId, null, null, parentId, currentTime);
        }
        catch (Exception e) {
            this.saveLog(null, currentTask, currentTask.getString("processInsId"), businessId, "0", e.getMessage(), parentId, currentTime);
            BpmResponseResult bpmResponseResult2 = bpmResponseResult = InstallResult.fail((String)e.getMessage());
            return bpmResponseResult2;
        }
        finally {
            this.saveVariable(testTaskCompleteDto.getAllVariablesConfiguredInProcessVo(), currentTask.getString("processInsId"));
        }
        return bpmResponseResult;
    }

    private void saveVariable(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess, String mainProcessProcessInstanceId) {
        this.variableService.saveVariable(allVariablesConfiguredInProcess, mainProcessProcessInstanceId);
    }

    private List<Long> getAllProcInsId(List<String> procInsId) {
        List<Long> subProcessInsId;
        List<Long> parentProcessInsId = new ArrayList<Long>();
        ArrayList<Long> longProcInsId = new ArrayList<Long>();
        for (String insId : procInsId) {
            longProcInsId.add(Long.valueOf(insId));
        }
        parentProcessInsId.addAll(longProcInsId);
        while (HussarUtils.isNotEmpty(subProcessInsId = this.processTestMapper.getSubProcInsId(parentProcessInsId))) {
            longProcInsId.addAll(subProcessInsId);
            parentProcessInsId = subProcessInsId;
        }
        return longProcInsId;
    }

    private boolean saveLog(BpmResponseResult bpmResponseResult, JSONObject jsonObject, String processInstId, String businessId, String exceptionState, String message, Long parentLogId, Date currentTime) {
        String testContent;
        SysActTestDetail sysActTestDetail = new SysActTestDetail();
        JSONObject map = InstanceEngineService.queryProcessInstance((String)processInstId, (String)businessId).getResult().getJSONObject(0);
        sysActTestDetail.setProcInstId(Long.valueOf(processInstId));
        sysActTestDetail.setLogId(parentLogId);
        sysActTestDetail.setBusinessId(businessId);
        sysActTestDetail.setProcessName(String.valueOf(map.get("processDefinitionName")));
        sysActTestDetail.setOperationType(ProcessTestingServiceImpl.getStrTaskSourceFlag("complete"));
        String nodeId = "";
        if (HussarUtils.isNotEmpty((Object)jsonObject)) {
            Object[] nodeTypeStr;
            sysActTestDetail.setTaskDefName(jsonObject.getString("taskDefinitionName"));
            nodeId = jsonObject.getString("taskDefinitionKey");
            sysActTestDetail.setTaskId(jsonObject.getString("taskId"));
            if (HussarUtils.isNotEmpty((Object)jsonObject.getString("subProcessKey"))) {
                sysActTestDetail.setSubProcessKey(jsonObject.getString("subProcessKey"));
            }
            sysActTestDetail.setTaskDefId(nodeId);
            if (HussarUtils.isNotEmpty((Object)jsonObject.getString("assignee"))) {
                sysActTestDetail.setUserId(jsonObject.getString("assignee"));
                String userId = sysActTestDetail.getUserId();
                ArrayList<String> list = new ArrayList<String>();
                list.add(userId);
                sysActTestDetail.setUserName((String)this.assigneeChooseService.getUserListByUserId(list).get(userId));
            }
            FlowModel flowModel = this.getTestFlowModel(String.valueOf(map.get("processDefinitionId")));
            String nodeType = "";
            List taskList = JSONArray.parseArray((String)InstanceEngineService.getAllProcessTrace((String)processInstId).getResult().toJSONString(), JSONObject.class);
            JSONObject currentTask = new JSONObject();
            List<JSONObject> allTaskList = this.getAllProcessTask(taskList);
            for (JSONObject taskInfo : allTaskList) {
                if (!jsonObject.getString("taskId").equals(taskInfo.getString("taskId"))) continue;
                currentTask = taskInfo;
                break;
            }
            sysActTestDetail.setProcDefId(String.valueOf(currentTask.get((Object)"processDefinitionId")));
            Map taskMap = new HashMap();
            if (HussarUtils.isNotEmpty((Object)currentTask)) {
                taskMap = currentTask.getInnerMap();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                if (HussarUtils.isNotEmpty(taskMap.get("executionId"))) {
                    if (HussarUtils.isNotEmpty(taskMap.get("startTime"))) {
                        sysActTestDetail.setCreateTime(new Date((Long)taskMap.get("startTime")));
                    }
                } else if (HussarUtils.isNotEmpty(taskMap.get("startTime"))) {
                    String startTime = String.valueOf(taskMap.get("startTime"));
                    sysActTestDetail.setCreateTime(sdf.parse(startTime));
                }
                sysActTestDetail.setEndTime(currentTime);
            }
            catch (Exception e) {
                throw new BpmException(e.getMessage());
            }
            List flowObjectList = flowModel.getSlots().getElement();
            List<FlowObject> allFlowObjectList = this.getAllProcessNodeInMainProcess(flowObjectList);
            for (FlowObject flowObject : allFlowObjectList) {
                if (!nodeId.equals(flowObject.getInstanceKey())) continue;
                nodeType = flowObject.getName();
                break;
            }
            if (HussarUtils.isNotEmpty((Object[])(nodeTypeStr = nodeType.split("\\.")))) {
                sysActTestDetail.setTaskDefType((String)nodeTypeStr[nodeTypeStr.length - 1]);
            }
        }
        String parentNodeId = "";
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BpmActHiActinst::getCallProcInstId, (Object)Long.valueOf(processInstId));
        List bpmActHiActinsts = this.bpmActHiActinstService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)bpmActHiActinsts)) {
            parentNodeId = ((BpmActHiActinst)bpmActHiActinsts.get(0)).getActId();
        }
        SysActTestLog sysActTestLog = new SysActTestLog();
        sysActTestLog.setLogId(parentLogId);
        sysActTestLog.setTaskDefId(nodeId);
        sysActTestLog.setParentNodeId(parentNodeId);
        sysActTestLog.setProcInstId(Long.valueOf(processInstId));
        sysActTestLog.setConfigDetail(message);
        if ("0".equals(exceptionState)) {
            sysActTestDetail.setTestContent(message);
            sysActTestDetail.setTestResult("0");
            sysActTestLog.setTestResult("0");
            this.testLogService.updateState(sysActTestLog);
        } else if ("1".equals(bpmResponseResult.getCode())) {
            if (HussarUtils.isNotEmpty((Object)bpmResponseResult.getResult())) {
                testContent = bpmResponseResult.getResult().getString(0);
                if (HussarUtils.isNotEmpty((Object)testContent)) {
                    testContent = testContent.length() > 1024 ? null : testContent;
                }
                sysActTestDetail.setTestContent(testContent);
            }
            sysActTestDetail.setTestResult("1");
            sysActTestLog.setTestResult("1");
            this.testLogService.updateState(sysActTestLog);
        } else {
            testContent = bpmResponseResult.getResult().getString(0);
            if (HussarUtils.isNotEmpty((Object)testContent)) {
                testContent = testContent.length() > 1024 ? null : testContent;
            }
            sysActTestDetail.setTestContent(testContent);
            sysActTestDetail.setTestResult("0");
            sysActTestLog.setTestResult("0");
            this.testLogService.updateState(sysActTestLog);
        }
        return this.testLogDetailService.save((Object)sysActTestDetail);
    }

    private FlowModel getTestFlowModel(String processDefinitionId) throws BpmException {
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessDefId(processDefinitionId, null, null);
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        flowModel.setFlowIdentity(workFlow.getIdentity());
        return flowModel;
    }

    public BpmResponseResult startProcessInstance(TestStartProcessInsDto testStartProcessInsDto) {
        AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess = testStartProcessInsDto.getAllVariablesConfiguredInProcessVo();
        List processNodes = testStartProcessInsDto.getProcessNodes();
        List<NodeVo> nodes = processNodes.stream().map(n -> (NodeVo)n.get(0)).collect(Collectors.toList());
        String processDefinitionId = allVariablesConfiguredInProcess.getProcessDefinitionId();
        this.variableHandler.setAllVariablesConfiguredInProcess(allVariablesConfiguredInProcess);
        this.variableHandler.setNodeMapping(nodes);
        this.variableHandler.setMappingFromProcessOnlyIdToProcessKey(nodes);
        this.neatenNodes(nodes);
        this.generateNodeAndAssigneeMapping(allVariablesConfiguredInProcess);
        HashMap<String, Object> initVariable = new HashMap<String, Object>();
        List configuredInstanceVariables = allVariablesConfiguredInProcess.getConfiguredInstanceVariables();
        for (ConfiguredInstanceVariableDto configuredInstanceVariableDto : configuredInstanceVariables) {
            if (!BpmNodeTypeUtil.isAnnotation((String)configuredInstanceVariableDto.getType())) continue;
            List ConfiguredVariableList = configuredInstanceVariableDto.getConfiguredVariables();
            for (ConfiguredVariableDto configuredVariable : ConfiguredVariableList) {
                initVariable.put(configuredVariable.getName(), configuredVariable.getValue());
            }
        }
        JSONArray startTask = null;
        String mainProcessBusinessKey = null;
        String mainProcessKey = allVariablesConfiguredInProcess.getProcessKey();
        String mainProcessOnlyId = allVariablesConfiguredInProcess.getOnlyId();
        mainProcessBusinessKey = this.generateBusinessKey();
        String starter = allVariablesConfiguredInProcess.getStarter();
        ArrayList<AllVariablesConfiguredInProcessVo> list = new ArrayList<AllVariablesConfiguredInProcessVo>();
        list.add(allVariablesConfiguredInProcess);
        this.clearAllCallActivityInfo(list);
        if (HussarUtils.isNotEmpty((Object)allVariablesConfiguredInProcess.getAllVariablesConfiguredInExternalSubProcesses())) {
            this.addCallActivityInfoBeforeStart(allVariablesConfiguredInProcess);
        }
        startTask = this.startTestProcessInstance(mainProcessOnlyId, mainProcessKey, testStartProcessInsDto.getProcessVersion(), mainProcessBusinessKey, starter, processDefinitionId, initVariable);
        String processInsId = (String)((JSONObject)startTask.get(0)).get((Object)"processInsId");
        this.saveVariable(allVariablesConfiguredInProcess, processInsId);
        Long parentLogId = Long.valueOf(this.generateBusinessKey());
        Map instance = (Map)InstanceEngineService.queryProcessInstance((String)String.valueOf(((JSONObject)startTask.get(0)).get((Object)"processInsId")), null).getResult().get(0);
        SysActTestLog sysActTestLog = new SysActTestLog();
        sysActTestLog.setLogId(parentLogId);
        sysActTestLog.setProcDefId(allVariablesConfiguredInProcess.getProcessDefinitionId());
        sysActTestLog.setCreateTime((Date)instance.get("startTime"));
        sysActTestLog.setProcInstId(Long.valueOf(String.valueOf(instance.get("processInsId"))));
        sysActTestLog.setBusinessId(mainProcessBusinessKey);
        sysActTestLog.setUserName((String)((Map)((List)((Map)((List)instance.get("todo")).get(0)).get("assignee")).get(0)).get("userName"));
        sysActTestLog.setUserId((String)((Map)((List)((Map)((List)instance.get("todo")).get(0)).get("assignee")).get(0)).get("userId"));
        sysActTestLog.setProcessName(String.valueOf(instance.get("processDefinitionName")));
        sysActTestLog.setTestResult("1");
        sysActTestLog.setTestType("0");
        this.testLogService.save((Object)sysActTestLog);
        ((JSONObject)startTask.get(0)).put("logId", (Object)parentLogId);
        startTask.add((Object)allVariablesConfiguredInProcess);
        return InstallResult.success((JSONArray)startTask);
    }

    public BpmResponseResult rejectToFirstTask(TaskRejectDto taskRejectDto) {
        BpmResponseResult bpmResponseResult;
        taskRejectDto.setIsSubmit(true);
        if (HussarUtils.isEmpty((Object)taskRejectDto.getUserId())) {
            bpmResponseResult = InstallResult.fail((String)this.bpmConstantProperties.getNullComplete());
        } else {
            taskRejectDto.setIsSubProcessFirst(true);
            bpmResponseResult = TaskEngineService.rejectToFirstTask((TaskRejectDto)taskRejectDto);
        }
        String testResult = "1";
        if (!bpmResponseResult.isSuccess()) {
            testResult = "0";
        }
        this.saveLogByTaskId(taskRejectDto.getTaskId(), testResult, ProcessTestingServiceImpl.getStrTaskSourceFlag("reject"), taskRejectDto.getUserId());
        return bpmResponseResult;
    }

    public BpmResponseResult rejectToLastTask(TaskRejectDto taskRejectDto) {
        taskRejectDto.setIsSubmit(true);
        BpmResponseResult bpmResponseResult = HussarUtils.isEmpty((Object)taskRejectDto.getUserId()) ? InstallResult.fail((String)this.bpmConstantProperties.getNullComplete()) : TaskEngineService.rejectToLastTask((TaskRejectDto)taskRejectDto);
        String testResult = "1";
        if (!bpmResponseResult.isSuccess()) {
            testResult = "0";
        }
        this.saveLogByTaskId(taskRejectDto.getTaskId(), testResult, ProcessTestingServiceImpl.getStrTaskSourceFlag("reject"), taskRejectDto.getUserId());
        return bpmResponseResult;
    }

    public BpmResponseResult rejectToAnyTask(TaskRejectDto taskRejectDto) {
        taskRejectDto.setIsSubmit(true);
        BpmResponseResult bpmResponseResult = HussarUtils.isEmpty((Object)taskRejectDto.getUserId()) ? InstallResult.fail((String)this.bpmConstantProperties.getNullComplete()) : TaskEngineService.rejectToAnyTask((TaskRejectDto)taskRejectDto);
        String testResult = "1";
        if (!bpmResponseResult.isSuccess()) {
            testResult = "0";
        }
        this.saveLogByTaskId(taskRejectDto.getTaskId(), testResult, ProcessTestingServiceImpl.getStrTaskSourceFlag("reject"), taskRejectDto.getUserId());
        return bpmResponseResult;
    }

    public BpmResponseResult revokeTask(TaskRevokeDto taskRevokeDto) {
        BpmResponseResult withdrawResult = TaskEngineService.withdrawState((String)taskRevokeDto.getHistoricTaskId());
        String testResult = "1";
        if (!withdrawResult.isSuccess()) {
            testResult = "0";
            this.saveLogByTaskId(taskRevokeDto.getHistoricTaskId(), testResult, ProcessTestingServiceImpl.getStrTaskSourceFlag("revoke"), taskRevokeDto.getUserId());
            return withdrawResult;
        }
        if (!withdrawResult.getResult().getBoolean(0).booleanValue()) {
            return InstallResult.fail((String)withdrawResult.getResult().getString(1));
        }
        BpmResponseResult bpmResponseResult = HussarUtils.isEmpty((Object)taskRevokeDto.getUserId()) ? InstallResult.fail((String)this.bpmConstantProperties.getNullComplete()) : TaskEngineService.revokeTask((String)taskRevokeDto.getHistoricTaskId(), (String)taskRevokeDto.getUserId(), (String)taskRevokeDto.getComment(), (boolean)true, (Map)taskRevokeDto.getMap());
        if (!bpmResponseResult.isSuccess()) {
            testResult = "0";
        }
        this.saveLogByTaskId(taskRevokeDto.getHistoricTaskId(), testResult, ProcessTestingServiceImpl.getStrTaskSourceFlag("revoke"), taskRevokeDto.getUserId());
        return bpmResponseResult;
    }

    public BpmResponseResult entrustTask(TaskEntrustDto taskEntrustDto) {
        BpmResponseResult bpmResponseResult = HussarUtils.isEmpty((Object)taskEntrustDto.getUserId()) ? InstallResult.fail((String)this.bpmConstantProperties.getNullComplete()) : TaskEngineService.entrustTask((TaskEntrustDto)taskEntrustDto);
        String testResult = "1";
        if (!bpmResponseResult.isSuccess()) {
            testResult = "0";
        }
        this.saveLogByTaskId(taskEntrustDto.getTaskId(), testResult, ProcessTestingServiceImpl.getStrTaskSourceFlag("transfer"), taskEntrustDto.getUserId());
        return bpmResponseResult;
    }

    private void saveLogByTaskId(String taskId, String testResult, String operationType, String userId) {
        Map taskObject = (Map)TaskEngineService.queryProcessTask((String)taskId).getResult().get(0);
        String businessId = String.valueOf(taskObject.get("businessId"));
        String processInsId = String.valueOf(taskObject.get("processInsId"));
        JSONObject instanceMap = InstanceEngineService.queryProcessInstance((String)processInsId, (String)businessId).getResult().getJSONObject(0);
        String processName = String.valueOf(instanceMap.get("processDefinitionName"));
        List parentLog = (List)this.testLogService.getWorkflowLog(processInsId, businessId).getData();
        SysActTestDetail sysActTestDetail = new SysActTestDetail();
        sysActTestDetail.setTaskDefId(String.valueOf(taskObject.get("taskDefinitionKey")));
        sysActTestDetail.setLogId(((SysActTestLog)parentLog.get(0)).getLogId());
        sysActTestDetail.setCreateTime((Date)taskObject.get("startTime"));
        sysActTestDetail.setEndTime(new Date());
        sysActTestDetail.setTestResult(testResult);
        sysActTestDetail.setBusinessId(businessId);
        sysActTestDetail.setProcInstId(Long.valueOf(processInsId));
        sysActTestDetail.setProcessName(processName);
        sysActTestDetail.setSubProcessKey(String.valueOf(taskObject.get("subProcessKey")));
        if (HussarUtils.isNotEmpty((Object)userId)) {
            sysActTestDetail.setUserId(userId);
            ArrayList<String> list = new ArrayList<String>();
            list.add(userId);
            sysActTestDetail.setUserName((String)this.assigneeChooseService.getUserListByUserId(list).get(userId));
        } else {
            sysActTestDetail.setUserName(String.valueOf(taskObject.get("sendUserName")));
            sysActTestDetail.setUserId(String.valueOf(taskObject.get("sendUser")));
        }
        sysActTestDetail.setOperationType(operationType);
        sysActTestDetail.setTaskDefName(String.valueOf(taskObject.get("name")));
        this.testLogDetailService.save((Object)sysActTestDetail);
        String parentNodeId = "";
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BpmActHiActinst::getCallProcInstId, (Object)Long.valueOf(processInsId));
        List bpmActHiActinsts = this.bpmActHiActinstService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)bpmActHiActinsts)) {
            parentNodeId = ((BpmActHiActinst)bpmActHiActinsts.get(0)).getActId();
        }
        SysActTestLog sysActTestLog = new SysActTestLog();
        sysActTestLog.setLogId(((SysActTestLog)parentLog.get(0)).getLogId());
        sysActTestLog.setTaskDefId(sysActTestDetail.getTaskDefId());
        sysActTestLog.setParentNodeId(parentNodeId);
        sysActTestLog.setProcInstId(sysActTestDetail.getProcInstId());
        sysActTestLog.setConfigDetail(sysActTestDetail.getTestContent());
        sysActTestLog.setTestResult(testResult);
        this.testLogService.updateState(sysActTestLog);
    }

    public BpmResponseResult checkProcessPublished(String processKey, String organId) {
        String modelId = this.modelService.getIdByIdentity(processKey, organId);
        if (HussarUtils.isEmpty((Object)modelId)) {
            return InstallResult.fail((String)this.bpmConstantProperties.getNotPublishError());
        }
        return InstallResult.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpmResponseResult receiveTaskSignal(ReceiveTaskReleaseDto receiveTaskReleaseDto) {
        List<NodeVo> nodes = receiveTaskReleaseDto.getNodeList().stream().map(n -> (NodeVo)n.get(0)).collect(Collectors.toList());
        this.variableHandler.setAllVariablesConfiguredInProcess(receiveTaskReleaseDto.getAllVariablesConfiguredInProcessVo());
        this.variableHandler.setNodeMapping(nodes);
        this.variableHandler.setMappingFromProcessOnlyIdToProcessKey(nodes);
        this.neatenNodes(nodes);
        this.generateNodeAndAssigneeMapping(receiveTaskReleaseDto.getAllVariablesConfiguredInProcessVo());
        String businessId = this.getBusinessIdBy(receiveTaskReleaseDto.getProcessInsId());
        String processOnlyId = this.variableHandler.getProcessOnlyIdBy(businessId);
        HashMap variable = new HashMap();
        Map callActivityInfo = (Map)receiveTaskReleaseDto.getAllVariablesConfiguredInProcessVo().getCallActivityInfo().get(processOnlyId);
        variable.putAll(callActivityInfo == null ? new HashMap() : callActivityInfo);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BpmActHiActinst::getExecutionId, (Object)Long.valueOf(receiveTaskReleaseDto.getExecutionId()));
        queryWrapper.isNull(BpmActHiActinst::getEndTime);
        BpmActHiActinst bpmActHiActinst = (BpmActHiActinst)this.bpmActHiActinstService.getOne((Wrapper)queryWrapper);
        BpmResponseResult instanceInfo = InstanceEngineService.queryProcessInstance((String)String.valueOf(bpmActHiActinst.getProcInstId()), null);
        String processDefinitionName = ((JSONObject)JSONObject.parseObject((String)JSON.toJSONString((Object)instanceInfo.getResult().get(0)), JSONObject.class)).getString("processDefinitionName");
        BpmResponseResult bpmResponseResult = new BpmResponseResult();
        try {
            bpmResponseResult = TaskEngineService.receiveTaskSignal((String)receiveTaskReleaseDto.getExecutionId(), variable);
        }
        catch (Exception e) {
            try {
                bpmResponseResult = InstallResult.fail((String)e.getMessage());
            }
            catch (Throwable throwable) {
                String nodeId = bpmActHiActinst.getActId();
                String testResult = bpmResponseResult.isSuccess() ? "1" : "0";
                List parentLog = (List)this.testLogService.getWorkflowLog(receiveTaskReleaseDto.getProcessInsId(), businessId).getData();
                SysActTestDetail sysActTestDetail = new SysActTestDetail();
                sysActTestDetail.setProcInstId(Long.valueOf(receiveTaskReleaseDto.getProcessInsId()));
                sysActTestDetail.setProcessName(processDefinitionName);
                sysActTestDetail.setBusinessId(businessId);
                sysActTestDetail.setOperationType(ProcessTestingServiceImpl.getStrTaskSourceFlag("receive_signal"));
                sysActTestDetail.setLogId(((SysActTestLog)parentLog.get(0)).getLogId());
                sysActTestDetail.setCreateTime(bpmActHiActinst.getStartTime());
                sysActTestDetail.setEndTime(new Date());
                sysActTestDetail.setTaskDefId(nodeId);
                sysActTestDetail.setTestResult(testResult);
                sysActTestDetail.setTaskDefType(bpmActHiActinst.getActType());
                sysActTestDetail.setTaskDefName(bpmActHiActinst.getActName());
                if (!bpmResponseResult.isSuccess()) {
                    sysActTestDetail.setTestContent(bpmResponseResult.getMsg());
                }
                this.testLogDetailService.save((Object)sysActTestDetail);
                String parentNodeId = "";
                LambdaQueryWrapper parentQueryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(BpmActHiActinst::getCallProcInstId, (Object)Long.valueOf(receiveTaskReleaseDto.getProcessInsId()));
                List bpmActHiActinsts = this.bpmActHiActinstService.list((Wrapper)queryWrapper);
                if (HussarUtils.isNotEmpty((Object)bpmActHiActinsts)) {
                    parentNodeId = ((BpmActHiActinst)bpmActHiActinsts.get(0)).getActId();
                }
                SysActTestLog sysActTestLog = new SysActTestLog();
                sysActTestLog.setLogId(((SysActTestLog)parentLog.get(0)).getLogId());
                sysActTestLog.setTaskDefId(sysActTestDetail.getTaskDefId());
                sysActTestLog.setParentNodeId(parentNodeId);
                sysActTestLog.setProcInstId(sysActTestDetail.getProcInstId());
                sysActTestLog.setConfigDetail(sysActTestDetail.getTestContent());
                sysActTestLog.setTestResult(testResult);
                this.testLogService.updateState(sysActTestLog);
                throw throwable;
            }
            String nodeId = bpmActHiActinst.getActId();
            String testResult = bpmResponseResult.isSuccess() ? "1" : "0";
            List parentLog = (List)this.testLogService.getWorkflowLog(receiveTaskReleaseDto.getProcessInsId(), businessId).getData();
            SysActTestDetail sysActTestDetail = new SysActTestDetail();
            sysActTestDetail.setProcInstId(Long.valueOf(receiveTaskReleaseDto.getProcessInsId()));
            sysActTestDetail.setProcessName(processDefinitionName);
            sysActTestDetail.setBusinessId(businessId);
            sysActTestDetail.setOperationType(ProcessTestingServiceImpl.getStrTaskSourceFlag("receive_signal"));
            sysActTestDetail.setLogId(((SysActTestLog)parentLog.get(0)).getLogId());
            sysActTestDetail.setCreateTime(bpmActHiActinst.getStartTime());
            sysActTestDetail.setEndTime(new Date());
            sysActTestDetail.setTaskDefId(nodeId);
            sysActTestDetail.setTestResult(testResult);
            sysActTestDetail.setTaskDefType(bpmActHiActinst.getActType());
            sysActTestDetail.setTaskDefName(bpmActHiActinst.getActName());
            if (!bpmResponseResult.isSuccess()) {
                sysActTestDetail.setTestContent(bpmResponseResult.getMsg());
            }
            this.testLogDetailService.save((Object)sysActTestDetail);
            String parentNodeId = "";
            LambdaQueryWrapper parentQueryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BpmActHiActinst::getCallProcInstId, (Object)Long.valueOf(receiveTaskReleaseDto.getProcessInsId()));
            List bpmActHiActinsts = this.bpmActHiActinstService.list((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)bpmActHiActinsts)) {
                parentNodeId = ((BpmActHiActinst)bpmActHiActinsts.get(0)).getActId();
            }
            SysActTestLog sysActTestLog = new SysActTestLog();
            sysActTestLog.setLogId(((SysActTestLog)parentLog.get(0)).getLogId());
            sysActTestLog.setTaskDefId(sysActTestDetail.getTaskDefId());
            sysActTestLog.setParentNodeId(parentNodeId);
            sysActTestLog.setProcInstId(sysActTestDetail.getProcInstId());
            sysActTestLog.setConfigDetail(sysActTestDetail.getTestContent());
            sysActTestLog.setTestResult(testResult);
            this.testLogService.updateState(sysActTestLog);
        }
        String nodeId = bpmActHiActinst.getActId();
        String testResult = bpmResponseResult.isSuccess() ? "1" : "0";
        List parentLog = (List)this.testLogService.getWorkflowLog(receiveTaskReleaseDto.getProcessInsId(), businessId).getData();
        SysActTestDetail sysActTestDetail = new SysActTestDetail();
        sysActTestDetail.setProcInstId(Long.valueOf(receiveTaskReleaseDto.getProcessInsId()));
        sysActTestDetail.setProcessName(processDefinitionName);
        sysActTestDetail.setBusinessId(businessId);
        sysActTestDetail.setOperationType(ProcessTestingServiceImpl.getStrTaskSourceFlag("receive_signal"));
        sysActTestDetail.setLogId(((SysActTestLog)parentLog.get(0)).getLogId());
        sysActTestDetail.setCreateTime(bpmActHiActinst.getStartTime());
        sysActTestDetail.setEndTime(new Date());
        sysActTestDetail.setTaskDefId(nodeId);
        sysActTestDetail.setTestResult(testResult);
        sysActTestDetail.setTaskDefType(bpmActHiActinst.getActType());
        sysActTestDetail.setTaskDefName(bpmActHiActinst.getActName());
        if (!bpmResponseResult.isSuccess()) {
            sysActTestDetail.setTestContent(bpmResponseResult.getMsg());
        }
        this.testLogDetailService.save((Object)sysActTestDetail);
        String parentNodeId = "";
        LambdaQueryWrapper parentQueryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BpmActHiActinst::getCallProcInstId, (Object)Long.valueOf(receiveTaskReleaseDto.getProcessInsId()));
        List bpmActHiActinsts = this.bpmActHiActinstService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)bpmActHiActinsts)) {
            parentNodeId = ((BpmActHiActinst)bpmActHiActinsts.get(0)).getActId();
        }
        SysActTestLog sysActTestLog = new SysActTestLog();
        sysActTestLog.setLogId(((SysActTestLog)parentLog.get(0)).getLogId());
        sysActTestLog.setTaskDefId(sysActTestDetail.getTaskDefId());
        sysActTestLog.setParentNodeId(parentNodeId);
        sysActTestLog.setProcInstId(sysActTestDetail.getProcInstId());
        sysActTestLog.setConfigDetail(sysActTestDetail.getTestContent());
        sysActTestLog.setTestResult(testResult);
        this.testLogService.updateState(sysActTestLog);
        return bpmResponseResult;
    }

    private List<JSONObject> getAllProcessTask(List<JSONObject> taskList) {
        ArrayList<JSONObject> allTaskList = new ArrayList<JSONObject>();
        allTaskList.addAll(taskList);
        for (JSONObject jsonObject : taskList) {
            JSONArray taskArray = new JSONArray();
            if (jsonObject.getJSONArray("subProcess") != null) {
                taskArray.addAll((Collection)jsonObject.getJSONArray("subProcess"));
            }
            if (jsonObject.getJSONArray("subProcessTask") != null) {
                taskArray.addAll((Collection)jsonObject.getJSONArray("subProcessTask"));
            }
            List subProcessTaskList = JSONArray.parseArray((String)taskArray.toJSONString(), JSONObject.class);
            List<JSONObject> subProcessAllTaskList = this.getAllProcessTask(subProcessTaskList);
            allTaskList.addAll(subProcessAllTaskList);
        }
        return allTaskList;
    }

    private List<FlowObject> getAllProcessNodeInMainProcess(List<FlowObject> flowObjectList) {
        ArrayList<FlowObject> allFlowObjectList = new ArrayList<FlowObject>();
        allFlowObjectList.addAll(flowObjectList);
        for (FlowObject flowObject : flowObjectList) {
            if (!BpmNodeTypeUtil.isSubProcess((String)flowObject.getName())) continue;
            List subProcessFlowObjectList = flowObject.getSlots().getElement();
            List<FlowObject> subProcessAllFlowObjectList = this.getAllProcessNodeInMainProcess(subProcessFlowObjectList);
            allFlowObjectList.addAll(subProcessAllFlowObjectList);
        }
        return allFlowObjectList;
    }

    private void addCallActivityInfoBeforeStart(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        ArrayList allVariablesConfiguredInProcessVoList = new ArrayList();
        ArrayList<AllVariablesConfiguredInProcessVo> subProcessVariablesConfiguredVo = new ArrayList<AllVariablesConfiguredInProcessVo>();
        subProcessVariablesConfiguredVo.add(allVariablesConfiguredInProcess);
        HashMap<String, Map<String, List<CallActivityInfo>>> callActivityInfo = new HashMap<String, Map<String, List<CallActivityInfo>>>();
        while (HussarUtils.isNotEmpty(subProcessVariablesConfiguredVo)) {
            ArrayList subProcess = new ArrayList();
            for (AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcessVo : subProcessVariablesConfiguredVo) {
                if (!HussarUtils.isNotEmpty((Object)allVariablesConfiguredInProcessVo.getAllVariablesConfiguredInExternalSubProcesses())) continue;
                String onlyId = allVariablesConfiguredInProcessVo.getOnlyId();
                FlowModel flowModel = this.getTestFlowModel(allVariablesConfiguredInProcessVo.getProcessDefinitionId());
                List flowObject = flowModel.getSlots().getElement();
                for (FlowObject object : flowObject) {
                    List<NodeDto> nodeDtoList;
                    if (HussarUtils.isNotEmpty(this.mappingFromProcessOnlyIdToNodeMapping.get(onlyId)) && HussarUtils.isNotEmpty(nodeDtoList = this.mappingFromProcessOnlyIdToNodeMapping.get(onlyId).get(object.getInstanceKey())) && BpmNodeTypeUtil.isCallActivity((String)object.getName())) {
                        NodeDto node = this.mappingFromProcessOnlyIdToNodeMapping.get(onlyId).get(object.getInstanceKey()).get(0);
                        List<CallActivityInfo> infoList = this.variableHandler.findExternalSubProcessNodeVariable(node);
                        HashMap<String, List<CallActivityInfo>> nodeInfoList = new HashMap<String, List<CallActivityInfo>>();
                        nodeInfoList.put(object.getInstanceKey(), infoList);
                        Map allNodeMap = (Map)callActivityInfo.get(onlyId);
                        if (HussarUtils.isNotEmpty((Object)allNodeMap)) {
                            allNodeMap.putAll(nodeInfoList);
                            callActivityInfo.put(onlyId, allNodeMap);
                        } else {
                            callActivityInfo.put(onlyId, nodeInfoList);
                        }
                    }
                    subProcess.addAll(allVariablesConfiguredInProcessVo.getAllVariablesConfiguredInExternalSubProcesses() == null ? new ArrayList() : allVariablesConfiguredInProcessVo.getAllVariablesConfiguredInExternalSubProcesses());
                }
            }
            subProcessVariablesConfiguredVo = subProcess;
        }
        ArrayList<AllVariablesConfiguredInProcessVo> variablVoList = new ArrayList<AllVariablesConfiguredInProcessVo>();
        variablVoList.add(allVariablesConfiguredInProcess);
        if (HussarUtils.isNotEmpty(callActivityInfo)) {
            this.addAllCallActivityInfo(variablVoList, callActivityInfo);
        }
        this.variableHandler.clearBind();
        this.variableHandler.clearVisitedNodeOnlyIdWithCompleteTask();
        this.variableHandler.clearVisitedNodeOnlyIdWithGenerateToDoTask();
        this.variableHandler.clearVisitedProcessOnlyId();
    }

    private List<AllVariablesConfiguredInProcessVo> addAllCallActivityInfo(List<AllVariablesConfiguredInProcessVo> allVariablesConfiguredInProcess, Map<String, Map<String, List<CallActivityInfo>>> callActivityMap) {
        HashMap<String, HashedMap> newMap = new HashMap<String, HashedMap>();
        Set<String> onlyIdList = callActivityMap.keySet();
        for (String onlyId : onlyIdList) {
            Map<String, List<CallActivityInfo>> nodeCallActivityInfoList = callActivityMap.get(onlyId);
            Set<String> processDefKeyList = nodeCallActivityInfoList.keySet();
            HashedMap newNodeList = new HashedMap();
            for (String processDefKey : processDefKeyList) {
                ArrayList callActivityInfoList = new ArrayList(nodeCallActivityInfoList.get(processDefKey));
                newNodeList.put(processDefKey, callActivityInfoList);
            }
            newMap.put(onlyId, newNodeList);
        }
        for (AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcessVo : allVariablesConfiguredInProcess) {
            allVariablesConfiguredInProcessVo.setCallActivityInfo(newMap);
            if (!HussarUtils.isNotEmpty((Object)allVariablesConfiguredInProcessVo.getAllVariablesConfiguredInExternalSubProcesses())) continue;
            allVariablesConfiguredInProcessVo.setAllVariablesConfiguredInExternalSubProcesses(this.addAllCallActivityInfo(allVariablesConfiguredInProcessVo.getAllVariablesConfiguredInExternalSubProcesses(), callActivityMap));
        }
        return allVariablesConfiguredInProcess;
    }

    private List<AllVariablesConfiguredInProcessVo> clearAllCallActivityInfo(List<AllVariablesConfiguredInProcessVo> allVariablesConfiguredInProcess) {
        for (AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcessVo : allVariablesConfiguredInProcess) {
            allVariablesConfiguredInProcessVo.setCallActivityInfo(null);
            if (!HussarUtils.isNotEmpty((Object)allVariablesConfiguredInProcessVo.getAllVariablesConfiguredInExternalSubProcesses())) continue;
            allVariablesConfiguredInProcessVo.setAllVariablesConfiguredInExternalSubProcesses(this.clearAllCallActivityInfo(allVariablesConfiguredInProcessVo.getAllVariablesConfiguredInExternalSubProcesses()));
        }
        return allVariablesConfiguredInProcess;
    }

    public void afterPropertiesSet() {
        TASK_SOURCE_FLAG.put("complete", "\u529e\u7406");
        TASK_SOURCE_FLAG.put("revoke", "\u64a4\u56de");
        TASK_SOURCE_FLAG.put("reject_revoke", "\u64a4\u56de");
        TASK_SOURCE_FLAG.put("skip", "\u8df3\u8fc7");
        TASK_SOURCE_FLAG.put("reject", "\u9a73\u56de");
        TASK_SOURCE_FLAG.put("freejump", "\u81ea\u7531\u8df3\u8f6c");
        TASK_SOURCE_FLAG.put("endProcess", "\u7ec8\u6b62");
        TASK_SOURCE_FLAG.put("complete_leap", "\u529e\u7406");
        TASK_SOURCE_FLAG.put("revokeProcess", "\u6d41\u7a0b\u64a4\u529e");
        TASK_SOURCE_FLAG.put("transfer", "\u8f6c\u529e");
        TASK_SOURCE_FLAG.put("multiTransfer", "\u79fb\u4ea4");
        TASK_SOURCE_FLAG.put("assist_complete", "\u529e\u7406\u534f\u529e");
        TASK_SOURCE_FLAG.put("assist_add", "\u53d1\u8d77\u534f\u529e");
        TASK_SOURCE_FLAG.put("assist", "\u53d1\u8d77\u534f\u529e");
        TASK_SOURCE_FLAG.put("ccTask", "\u4f20\u9605");
        TASK_SOURCE_FLAG.put("receive_signal", "\u91ca\u653e\u4efb\u52a1");
        if (this.bpmConstantProperties != null && HussarUtils.isNotEmpty((Object)this.bpmConstantProperties.getTaskSourceFlag())) {
            TASK_SOURCE_FLAG.putAll(this.bpmConstantProperties.getTaskSourceFlag());
        }
    }

    private static String getStrTaskSourceFlag(String taskSourceFlag) {
        if (taskSourceFlag == null) {
            return "";
        }
        String s = TASK_SOURCE_FLAG.get(TaskSourceFlag.mappingToSimple((String)taskSourceFlag));
        return s == null ? "" : s;
    }
}

