/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.form.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl.AssigneeChooseServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.godaxe.form.GodAxeFormService;
import com.jxdinfo.hussar.workflow.godaxe.service.GodAxeFormApiService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.outside.form.service.GodAxeFormOutSideService;
import dm.jdbc.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class GodAxeFormWorkflowApiServiceImpl
implements GodAxeFormApiService {
    @Value(value="${hussar-remote-server.hussar.web.name:hussar-web}")
    private String SERVICE_NAME_HUSSAR_WEB;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private GodAxeFormService godAxeFormService;
    @Resource
    private ModelMapper modelMapper;
    @Autowired(required=false)
    private SysActProcessFileService sysActProcessFileService;
    private static final Logger logger = LogManager.getLogger(AssigneeChooseServiceImpl.class);
    private static final String GET_LOW_FORM = "/godAxe/form/getLowForm";
    private static final String GET_LOW_FORM_INFO = "/godAxe/form/getLowFormInfo";
    private static final String GET_NO_CODE_FORM = "/godAxe/form/getNoCodeForm";
    private static final String GET_NO_CODE_FORM_INFO = "/godAxe/form/getNoCodeFormInfo";
    private static final String GET_THEME_CONFIG_RULE = "/godAxe/form/getThemeConfigRule";
    private static final String GET_CURRENT_APPLICATION_THEME = "/godAxe/form/getCurrentApplicationTheme";

    public ApiResponse<List<JSONObject>> getLowForm(String processKey) {
        String deploymentModel = this.lcdpBpmProperties.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    String url = this.lcdpBpmProperties.getTenantCallAddress() + GET_LOW_FORM;
                    HashMap map = new HashMap();
                    String result2 = HttpClient.doGet((String)url, map);
                    if (StringUtil.isEmpty((String)result2)) {
                        return ApiResponse.success();
                    }
                    return ApiResponse.success((Object)JSONArray.parseArray((String)result2, JSONObject.class));
                }
                case "micro": {
                    WorkFlow workFlow;
                    GodAxeFormOutSideService godAxeFormOutSideService = (GodAxeFormOutSideService)BpmSpringContextHolder.getSpringContext().getBean(GodAxeFormOutSideService.class);
                    String serviceName = this.modelMapper.getServiceName(processKey);
                    if (HussarUtils.isEmpty((Object)serviceName) && HussarUtils.isNotEmpty((Object)(workFlow = this.sysActProcessFileService.getFileByProcessKey(processKey, null)))) {
                        serviceName = workFlow.getCategory();
                    }
                    return godAxeFormOutSideService.getLowForm(serviceName);
                }
            }
            return this.godAxeFormService.getLowForm();
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_FORM.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_FORM);
        }
    }

    public ApiResponse<JSONObject> getLowFormInfo(String processKey, String appId, String formId) {
        String deploymentModel = this.lcdpBpmProperties.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    String url = this.lcdpBpmProperties.getTenantCallAddress() + GET_LOW_FORM_INFO;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("appId", appId);
                    map.put("formId", formId);
                    String result2 = HttpClient.doGet((String)url, map);
                    if (StringUtil.isEmpty((String)result2)) {
                        return ApiResponse.success();
                    }
                    return ApiResponse.success((Object)JSONObject.parseObject((String)result2));
                }
                case "micro": {
                    WorkFlow workFlow;
                    GodAxeFormOutSideService godAxeFormOutSideService = (GodAxeFormOutSideService)BpmSpringContextHolder.getSpringContext().getBean(GodAxeFormOutSideService.class);
                    String serviceName = this.modelMapper.getServiceName(processKey);
                    if (HussarUtils.isEmpty((Object)serviceName) && HussarUtils.isNotEmpty((Object)(workFlow = this.sysActProcessFileService.getFileByProcessKey(processKey, null)))) {
                        serviceName = workFlow.getCategory();
                    }
                    return godAxeFormOutSideService.getLowFormInfo(appId, formId, serviceName);
                }
            }
            return this.godAxeFormService.getLowFormInfo(appId, formId);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_FORM_INFO.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_FORM_INFO);
        }
    }

    public ApiResponse<String> getThemeConfigRule() {
        String deploymentModel = this.lcdpBpmProperties.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    String url = this.lcdpBpmProperties.getTenantCallAddress() + GET_THEME_CONFIG_RULE;
                    HashMap map = new HashMap();
                    String result = HttpClient.doGet((String)url, map);
                    if (StringUtil.isEmpty((String)result)) {
                        return ApiResponse.success();
                    }
                    return ApiResponse.success((String)result);
                }
                case "micro": {
                    GodAxeFormOutSideService godAxeFormOutSideService = (GodAxeFormOutSideService)BpmSpringContextHolder.getSpringContext().getBean(GodAxeFormOutSideService.class);
                    return godAxeFormOutSideService.getThemeConfigRule(this.SERVICE_NAME_HUSSAR_WEB);
                }
            }
            return this.godAxeFormService.getThemeConfigRule();
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_FORM.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_THEME_CONFIG);
        }
    }

    public ApiResponse<JSONObject> getCurrentApplicationTheme() {
        String deploymentModel = this.lcdpBpmProperties.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    String url = this.lcdpBpmProperties.getTenantCallAddress() + GET_CURRENT_APPLICATION_THEME;
                    HashMap map = new HashMap();
                    String result = HttpClient.doGet((String)url, map);
                    if (StringUtil.isEmpty((String)result)) {
                        return ApiResponse.success();
                    }
                    return ApiResponse.success((String)result);
                }
                case "micro": {
                    GodAxeFormOutSideService godAxeFormOutSideService = (GodAxeFormOutSideService)BpmSpringContextHolder.getSpringContext().getBean(GodAxeFormOutSideService.class);
                    return godAxeFormOutSideService.getCurrentApplicationTheme(this.SERVICE_NAME_HUSSAR_WEB);
                }
            }
            return this.godAxeFormService.getCurrentApplicationTheme();
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_FORM.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_APPLICATION_THEME);
        }
    }
}

