/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.form.FormComponentsQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.form.FormComponentsQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.form.FormListQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.form.FormListQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.form.service.IFormEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.form.form.FormEngineService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.outside.form.service.WorkflowFormEngineService;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class FormEngineServiceImpl
implements IFormEngineService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    private ModelMapper modelMapper;
    @Autowired(required=false)
    FormEngineService formEngineService;

    public List<FormListQueryVo> queryFormList(FormListQueryDto formListQueryDto) {
        String deploymentModel;
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "workflow-platform": {
                String url = this.lcdpBpmProperties.getTenantCallAddress() + "/hussarBpm/form/queryFormList";
                String result2 = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)formListQueryDto));
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<FormListQueryVo>();
                }
                return JSONArray.parseArray((String)result2, FormListQueryVo.class);
            }
            case "micro": {
                WorkflowFormEngineService remoteWorkflowFormEngineService = (WorkflowFormEngineService)BpmSpringContextHolder.getSpringContext().getBean(WorkflowFormEngineService.class);
                return remoteWorkflowFormEngineService.queryFormList(formListQueryDto, this.modelMapper.getServiceName(formListQueryDto.getProcessKey()));
            }
        }
        if (this.formEngineService == null) {
            return new ArrayList<FormListQueryVo>();
        }
        return this.formEngineService.queryFormList(formListQueryDto);
    }

    public List<FormComponentsQueryVo> queryFormComponents(FormComponentsQueryDto formComponentsQueryDto) {
        String deploymentModel;
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "workflow-platform": {
                String url = this.lcdpBpmProperties.getTenantCallAddress() + "/hussarBpm/form/queryFormComponents";
                String result2 = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)formComponentsQueryDto));
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<FormComponentsQueryVo>();
                }
                return JSONArray.parseArray((String)result2, FormComponentsQueryVo.class);
            }
            case "micro": {
                WorkflowFormEngineService remoteWorkflowFormEngineService = (WorkflowFormEngineService)BpmSpringContextHolder.getSpringContext().getBean(WorkflowFormEngineService.class);
                return remoteWorkflowFormEngineService.queryFormComponents(formComponentsQueryDto, this.modelMapper.getServiceName(formComponentsQueryDto.getProcessKey()));
            }
        }
        if (this.formEngineService == null) {
            return new ArrayList<FormComponentsQueryVo>();
        }
        return this.formEngineService.queryFormComponents(formComponentsQueryDto);
    }
}

