/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.model.CandidateUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.service.ICandidateUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.model.ConfigUser;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowBpmUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.GetVariableCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.util.BpmMsgDetailBuildUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.Annotation;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.BpmHistoryTask;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowPageMsg;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.util.ActivitiTranslateUtil;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.CcTaskEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.repository.Model;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendUserTaskActivityBehavior
extends UserTaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_MSG = "Expression did not resolve to a string or collection of strings";
    private static ProcessEngine processEngine = (ProcessEngine)BpmSpringContextHolder.getBean(ProcessEngine.class);
    private static final String LISTENER = "listener";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendUserTaskActivityBehavior.class);
    private static ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)BpmSpringContextHolder.getSpringContext().getBean(ISysActCcTaskService.class);
    private static RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getSpringContext().getBean(RepositoryService.class);
    private static HistoryService historyService = (HistoryService)BpmSpringContextHolder.getSpringContext().getBean(HistoryService.class);
    private static ActivityRedisTimerService activityRedisTimer = (ActivityRedisTimerService)BpmSpringContextHolder.getSpringContext().getBean(ActivityRedisTimerService.class);
    private static ICandidateUserService candidateUserService = (ICandidateUserService)BpmSpringContextHolder.getSpringContext().getBean(ICandidateUserService.class);
    private static DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getSpringContext().getBean(DataPushService.class);
    private static BpmMsgPushService msgPushService = (BpmMsgPushService)BpmSpringContextHolder.getSpringContext().getBean(BpmMsgPushService.class);
    private static SysActProcessFileService sysActProcessFileService = (SysActProcessFileService)BpmSpringContextHolder.getSpringContext().getBean(SysActProcessFileService.class);
    private static ISysCalendarRefService sysCalendarRefService = (ISysCalendarRefService)BpmSpringContextHolder.getSpringContext().getBean(ISysCalendarRefService.class);
    private static IFlowTaskService flowTaskService = (IFlowTaskService)BpmSpringContextHolder.getBean(IFlowTaskService.class);
    private static LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)BpmSpringContextHolder.getBean(LcdpBpmProperties.class);

    public ExtendUserTaskActivityBehavior(String userTaskId, TaskDefinition taskDefinition) {
        super(userTaskId, taskDefinition);
    }

    public void execute(ActivityExecution execution) throws Exception {
        Object wfdFile;
        WorkFlow workFlow;
        FlowModel flowModel;
        String warningDateConfig;
        Object formKey;
        Object category;
        Object priority;
        Set<Expression> activeCandidateGroupExpressions;
        Set<Expression> activeCandidateUserExpressions;
        Expression activeOwnerExpression;
        Expression activeAssigneeExpression;
        Expression activeFormKeyExpression;
        Expression activeCategoryExpression;
        Expression activePriorityExpression;
        Expression activeDueDateExpression;
        Expression activeDescriptionExpression;
        Expression activeNameExpression;
        HistoricTaskInstance lastComplete;
        TaskEntity task = TaskEntity.create((Date)new Date());
        task.setNewTask(true);
        task.setProcessCycleCount(((ExecutionEntity)execution).getProcessCycleCount());
        task.setSuspensionState(((ExecutionEntity)execution).getProcessInstance().getSuspensionState());
        task.setId(Context.getProcessEngineConfiguration().getIdGenerator().getNextId());
        task.setBpmExecution((DelegateExecution)execution);
        task.setCompleteType(BpmAttribute.getTaskSourceFlag(task));
        String allPrevNode = TaskSourceFlag.isRejectOrRevoke((String)BpmAttribute.getTaskSourceFlag(execution)) ? ((lastComplete = BpmHistoryTask.getLastComplete(execution.getProcessInstanceId(), execution.getSubProcessKey(), execution.getCurrentActivityId())) == null ? null : lastComplete.getAllPrevNode()) : ((ExecutionEntity)execution).getAllPrevNode();
        task.setAllPrevNode(allPrevNode);
        JumpInfo jumpInfo = (JumpInfo)BpmAttribute.getContextAttribute("jump_info");
        if (jumpInfo != null && jumpInfo.isJumpExecution() && HussarUtils.isNotEmpty((Object)jumpInfo.getJumpFromExecutionInfo())) {
            task.setVariableLocal("jump_execution_info", (Object)jumpInfo.getJumpFromExecutionInfo());
        }
        task.setJumpInfo(JumpInfo.toJsonString((JumpInfo)jumpInfo));
        HashMap<String, Object> variable = (HashMap<String, Object>)execution.getProcessInstance().getTempVariable("processVariables");
        if (variable == null) {
            variable = new HashMap<String, Object>();
        }
        variable.putAll(execution.getProcessInstance().getVariables());
        task.setTodoConfiguration(AnalyticalModelUtil.getTodo(variable, AnalyticalModelUtil.getToDoConfiguration(execution.getProcessDefinitionId(), execution.getCurrentActivityId())));
        Object submitToRejectNode = Context.getCommandContext().getAttribute("submitToRejectNode");
        if (HussarUtils.isNotEmpty((Object)submitToRejectNode)) {
            task.setSubmitToRejectNode(submitToRejectNode.toString());
        }
        task.insert((ExecutionEntity)execution);
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = Context.getBpmnOverrideElementProperties((String)this.userTaskId, (String)execution.getProcessDefinitionId());
            activeNameExpression = this.getActiveValue(this.taskDefinition.getNameExpression(), "userTaskName", taskElementProperties);
            this.taskDefinition.setNameExpression(activeNameExpression);
            activeDescriptionExpression = this.getActiveValue(this.taskDefinition.getDescriptionExpression(), "userTaskDescription", taskElementProperties);
            this.taskDefinition.setDescriptionExpression(activeDescriptionExpression);
            activeDueDateExpression = this.getActiveValue(this.taskDefinition.getDueDateExpression(), "userTaskDueDate", taskElementProperties);
            this.taskDefinition.setDueDateExpression(activeDueDateExpression);
            activePriorityExpression = this.getActiveValue(this.taskDefinition.getPriorityExpression(), "userTaskPriority", taskElementProperties);
            this.taskDefinition.setPriorityExpression(activePriorityExpression);
            activeCategoryExpression = this.getActiveValue(this.taskDefinition.getCategoryExpression(), "userTaskCategory", taskElementProperties);
            this.taskDefinition.setCategoryExpression(activeCategoryExpression);
            activeFormKeyExpression = this.getActiveValue(this.taskDefinition.getFormKeyExpression(), "userTaskFormKey", taskElementProperties);
            this.taskDefinition.setFormKeyExpression(activeFormKeyExpression);
            Expression activeSkipExpression = this.getActiveValue(this.taskDefinition.getSkipExpression(), "taskSkipExpression", taskElementProperties);
            this.taskDefinition.setSkipExpression(activeSkipExpression);
            activeAssigneeExpression = this.getActiveValue(this.taskDefinition.getAssigneeExpression(), "userTaskAssignee", taskElementProperties);
            this.taskDefinition.setAssigneeExpression(activeAssigneeExpression);
            activeOwnerExpression = this.getActiveValue(this.taskDefinition.getOwnerExpression(), "userTaskOwner", taskElementProperties);
            this.taskDefinition.setOwnerExpression(activeOwnerExpression);
            activeCandidateUserExpressions = this.getActiveValueSet(this.taskDefinition.getCandidateUserIdExpressions(), "userTaskCandidateUsers", taskElementProperties);
            this.taskDefinition.setCandidateUserIdExpressions(activeCandidateUserExpressions);
            activeCandidateGroupExpressions = this.getActiveValueSet(this.taskDefinition.getCandidateGroupIdExpressions(), "userTaskCandidateGroups", taskElementProperties);
            this.taskDefinition.setCandidateGroupIdExpressions(activeCandidateGroupExpressions);
        } else {
            activeNameExpression = this.taskDefinition.getNameExpression();
            activeDescriptionExpression = this.taskDefinition.getDescriptionExpression();
            activeDueDateExpression = this.taskDefinition.getDueDateExpression();
            activePriorityExpression = this.taskDefinition.getPriorityExpression();
            activeCategoryExpression = this.taskDefinition.getCategoryExpression();
            activeFormKeyExpression = this.taskDefinition.getFormKeyExpression();
            activeAssigneeExpression = this.taskDefinition.getAssigneeExpression();
            activeOwnerExpression = this.taskDefinition.getOwnerExpression();
            activeCandidateUserExpressions = this.taskDefinition.getCandidateUserIdExpressions();
            activeCandidateGroupExpressions = this.taskDefinition.getCandidateGroupIdExpressions();
        }
        task.setTaskDefinition(this.taskDefinition);
        if (activeNameExpression != null) {
            String name;
            try {
                name = (String)activeNameExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                name = activeNameExpression.getExpressionText();
                LOGGER.warn("property not found in task name expression {}", (Object)e.getMessage());
            }
            task.setName(name);
            task.setNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)task.getProcessDefinitionId(), (String)task.getTaskDefinitionKey()));
        }
        if (activeDescriptionExpression != null) {
            String description;
            try {
                description = (String)activeDescriptionExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                description = activeDescriptionExpression.getExpressionText();
                LOGGER.warn("property not found in task description expression {}", (Object)e.getMessage());
            }
            task.setDescription(description);
        }
        BpmnModel bm = repositoryService.getBpmnModel(task.getProcessDefinitionId());
        FlowElement element = bm.getFlowElement(execution.getActivity().getId());
        TimeOutConfig timeOutConfig = TimeOutConfig.build(element);
        if (activeDueDateExpression != null) {
            String chosenDay = timeOutConfig.getChosenDay();
            if ("workingDay".equals(chosenDay)) {
                Date date = new Date();
                Instant instant = date.toInstant();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                LocalDateTime dueTime = sysCalendarRefService.getDueDateDefult(localDateTime, String.valueOf(activeDueDateExpression), true);
                ZonedDateTime zonedDateTime = dueTime.atZone(ZoneId.systemDefault());
                Instant instant2 = zonedDateTime.toInstant();
                Date dueDate = Date.from(instant2);
                task.setDueDate(dueDate);
            } else {
                Object dueDate = activeDueDateExpression.getValue((VariableScope)execution);
                if (dueDate != null) {
                    if (dueDate instanceof Date) {
                        task.setDueDate((Date)dueDate);
                    } else if (dueDate instanceof String) {
                        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.taskDefinition.getBusinessCalendarNameExpression().getValue((VariableScope)execution).toString());
                        task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
                    } else {
                        throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeDueDateExpression.getExpressionText());
                    }
                }
            }
        }
        if (activePriorityExpression != null && (priority = activePriorityExpression.getValue((VariableScope)execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.valueOf((String)priority).intValue());
                }
                catch (NumberFormatException e) {
                    throw new ActivitiIllegalArgumentException("Priority does not resolve to a number: " + priority, (Throwable)e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new ActivitiIllegalArgumentException("Priority expression does not resolve to a number: " + activePriorityExpression.getExpressionText());
            }
        }
        if (activeCategoryExpression != null && (category = activeCategoryExpression.getValue((VariableScope)execution)) != null) {
            if (category instanceof String) {
                task.setCategory((String)category);
            } else {
                throw new ActivitiIllegalArgumentException("Category expression does not resolve to a string: " + activeCategoryExpression.getExpressionText());
            }
        }
        if (activeFormKeyExpression != null && (formKey = activeFormKeyExpression.getValue((VariableScope)execution)) != null) {
            if (formKey instanceof String) {
                task.setFormKey((String)formKey);
            } else {
                throw new ActivitiIllegalArgumentException("FormKey expression does not resolve to a string: " + activeFormKeyExpression.getExpressionText());
            }
        }
        if (HussarUtils.isNotEmpty((Object)(warningDateConfig = timeOutConfig.getWarningDate())) && HussarUtils.isNotEmpty((Object)task.getDueDate())) {
            String warningDateType = timeOutConfig.getWarningDateType();
            if ("workingDay".equals(warningDateType)) {
                Date date = task.getDueDate();
                Instant instant = date.toInstant();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                LocalDateTime dueTime = sysCalendarRefService.getBeginDateDefult(localDateTime, warningDateConfig, true);
                ZonedDateTime zonedDateTime = dueTime.atZone(ZoneId.systemDefault());
                Instant instant2 = zonedDateTime.toInstant();
                Date warningDate = Date.from(instant2);
                task.setWarningDate(warningDate);
            } else {
                Date warningDate = TimeOutConfig.getWarningDate(execution, warningDateConfig, task.getDueDate());
                task.setWarningDate(warningDate);
            }
        }
        String processKey = task.getProcessDefinitionId().split(":")[0];
        if (Context.getCommandContext() != null) {
            flowModel = (FlowModel)Context.getCommandContext().getAttribute("FlowModel_" + task.getProcessDefinitionId());
            if (flowModel == null) {
                workFlow = sysActProcessFileService.getFileByProcessDefId(task.getProcessDefinitionId());
                wfdFile = workFlow.getData();
                flowModel = (FlowModel)JSONObject.parseObject((String)wfdFile, FlowModel.class);
                Context.getCommandContext().addAttribute("FlowModel_" + task.getProcessDefinitionId(), (Object)flowModel);
            }
        } else {
            workFlow = sysActProcessFileService.getFileByProcessDefId(task.getProcessDefinitionId());
            wfdFile = workFlow.getData();
            flowModel = (FlowModel)JSONObject.parseObject((String)wfdFile, FlowModel.class);
        }
        List list = flowModel.getSlots().getElement();
        for (FlowObject flowObject : list) {
            if (!task.getTaskDefinitionKey().equals(flowObject.getInstanceKey())) continue;
            Map flowPageMsgMap = flowObject.getProps().getFormDetailAddress();
            if (flowPageMsgMap == null) break;
            task.setFormId(((FlowPageMsg)flowPageMsgMap.get("web")).getId());
            break;
        }
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<String> messageType = new ArrayList<String>();
        boolean skipUserTask = this.setAssignments(activeAssigneeExpression, activeOwnerExpression, activeCandidateUserExpressions, activeCandidateGroupExpressions, task, execution, users, messageType, timeOutConfig);
        task.fireEvent("create");
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)task));
        }
        if (skipUserTask) {
            ArrayList allUserList = HussarUtils.isEmpty((Object)task.getCandidates()) ? new ArrayList() : task.getCandidates().stream().map(IdentityLinkEntity::getUserId).collect(Collectors.toList());
            task.setSendUser(task.getAssignee());
            task.setTaskSourceFlag("skip");
            task.complete(null, false);
            HashSet<String> processDefinitionIdList = new HashSet<String>();
            processDefinitionIdList.add(task.getProcessDefinitionId());
            if (dataPushService.isDataPush(processDefinitionIdList)) {
                DataPush dataPush = new DataPush();
                dataPush.setBusinessKey(task.getProcessInstance().getBusinessKey());
                dataPush.setProcessKey(task.getProcessInstance().getProcessDefinitionKey());
                dataPush.setProcessInsId(task.getProcessInstanceId());
                dataPush.setTaskId(task.getId());
                dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
                dataPush.setTaskDefinitionName(task.getName());
                dataPush.setTaskDefinitionNameTranslateKey(task.getNameTranslateKey());
                dataPush.setUrl(task.getFormKey());
                dataPush.setStartDate(task.getCreateTime());
                dataPush.setUserId(task.getAssignee());
                dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
                dataPush.setEndDate(new Date());
                dataPush.setAllUserIdList(allUserList);
                dataPushService.completeDataPush(dataPush);
            }
        }
        if (!(TaskSourceFlag.isRevoke((String)BpmAttribute.getTaskSourceFlag(execution)) || skipUserTask || "main_process_start".equals(BpmAttribute.getTaskSourceFlag(execution)))) {
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            BpmActMsgDetail bpmActMsgDetail = BpmMsgDetailBuildUtil.taskMsgDetail((TaskEntity)task, users, (String)(TaskSourceFlag.isReject((String)BpmAttribute.getTaskSourceFlag(execution)) ? "reject" : "todo"));
            bpmActMsgDetail.setChannelType(HussarUtils.isNotEmpty(messageType) ? (String)messageType.get(0) : null);
            bpmActMsgDetailList.add(bpmActMsgDetail);
            msgPushService.pushMessage(bpmActMsgDetailList);
        }
        task.fireEvent("start");
    }

    private boolean setAssignments(Expression assigneeExpression, Expression ownerExpression, Set<Expression> candidateUserExpressions, Set<Expression> candidateGroupExpressions, TaskEntity task, ActivityExecution execution, List<String> userList, List<String> messageType, TimeOutConfig timeOutConfig) {
        Object value;
        Map identityLinks;
        Boolean notNeedCheckAssignee;
        Map extensionElementsNode;
        String skipRepetition;
        Map<String, Object> ccUsersMessage;
        List historicTaskInstances;
        if ("callActivity".equals(execution.getActivity().getProperty("type")) && "parallel".equals(execution.getActivity().getProperty("multiInstance"))) {
            return false;
        }
        BpmnModel bm = repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (assigneeExpression != null) {
            Object assigneeExpressionValue = assigneeExpression.getValue((VariableScope)execution);
            String assigneeValue = null;
            if (assigneeExpressionValue != null) {
                assigneeValue = assigneeExpressionValue.toString();
            }
            task.setAssignee(assigneeValue, true, false);
        }
        if (ownerExpression != null) {
            Iterator<Expression> ownerExpressionValue = ownerExpression.getValue((VariableScope)execution);
            String ownerValue = null;
            if (ownerExpressionValue != null) {
                ownerValue = ownerExpressionValue.toString();
            }
            task.setOwner(ownerValue);
        }
        if (candidateGroupExpressions != null && !candidateGroupExpressions.isEmpty()) {
            for (Expression groupIdExpr : candidateGroupExpressions) {
                Object value2 = groupIdExpr.getValue((VariableScope)execution);
                if (value2 instanceof String) {
                    List<String> candidates = this.extractCandidates((String)value2);
                    task.addCandidateGroups(candidates);
                    continue;
                }
                if (value2 instanceof Collection) {
                    task.addCandidateGroups((Collection)value2);
                    continue;
                }
                throw new ActivitiIllegalArgumentException(ERROR_MSG);
            }
        }
        HashSet<String> users = new HashSet<String>();
        Map<String, Object> annotationVariableMap = (HashMap<String, Object>)execution.getTempVariable("processVariables");
        if (LISTENER.equals(lcdpBpmProperties.visitorGenerateType()) && HussarUtils.isEmpty((Object)annotationVariableMap) && this.isGetVariable(task.getProcessDefinitionId(), task.getTaskDefinitionKey())) {
            annotationVariableMap = (Map)processEngine.getManagementService().executeCommand((Command)new GetVariableCmd(CommonCodeUtil.getVisitorNodeId(task.getTaskDefinitionKey(), bm), task.getBusinessKey(), task.getProcessDefinitionId(), null, bm));
        }
        if (annotationVariableMap == null) {
            annotationVariableMap = new HashMap<String, Object>();
        }
        annotationVariableMap.putAll(execution.getVariables());
        List<Annotation> annotations = AnalyticalModelUtil.getAnnotationContent(annotationVariableMap, task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        task.setVariable("extentAnnotation", annotations);
        List<ConfigUser> candidateUserList = AnalyticalModelUtil.getEntrustCandidateUser(bm, task.getTaskDefinitionKey(), execution, false, users, messageType);
        task.setAppointAssignee(ConfigUser.getAppointAssignee(candidateUserList));
        if (HussarUtils.isEmpty(users) && (TaskSourceFlag.isRejectOrRevoke((String)task.getCompleteType()) || TaskSourceFlag.isFreeJump((String)task.getCompleteType())) && execution.getProcessInstance().getSuperExecutionId() == null && HussarUtils.isNotEmpty((Object)(historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(execution.getProcessInstanceId())).orderByTaskCreateTime()).asc()).listPage(0, 1))) && execution.getCurrentActivityId().equals(((HistoricTaskInstance)historicTaskInstances.get(0)).getTaskDefinitionKey())) {
            users.add(((HistoricTaskInstance)historicTaskInstances.get(0)).getAssignee());
            candidateUserList = ConfigUser.buildConfigUser(Collections.singletonList(((HistoricTaskInstance)historicTaskInstances.get(0)).getAssignee()), null);
        }
        userList.addAll(users);
        Model model = (Model)repositoryService.createModelQuery().modelKey(task.getProcessDefinitionId().split(":")[0]).singleResult();
        List<TimeOutModel> timeOutModels = timeOutConfig.buildTimeOutModel(task, users, model.getAppId());
        activityRedisTimer.addTimeOutModels(timeOutModels);
        if (!TaskSourceFlag.isRevoke((String)BpmAttribute.getTaskSourceFlag(execution)) && HussarUtils.isNotEmpty(ccUsersMessage = AnalyticalModelUtil.getCcUser(bm, execution))) {
            List ccUsers = (List)ccUsersMessage.get("ccUser");
            String sendUserId = (String)ccUsersMessage.get("ccSendUser");
            if (HussarUtils.isNotEmpty((Object)ccUsers) && HussarUtils.isNotEmpty((Object)sendUserId)) {
                this.ccTask((Task)task, (List<String>)ccUsers, sendUserId, execution, bm);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(skipRepetition = ((ExtensionAttribute)((List)((ExtensionElement)((List)(extensionElementsNode = bm.getFlowElement(task.getTaskDefinitionKey()).getExtensionElements()).get("skiprepetition")).get(0)).getAttributes().get("skiprepetition")).get(0)).getValue()))) {
            boolean isStartAndComplete = Context.getCommandContext().getAttribute("ACTIVITI_START_AND_COMPLETE_TAG") != null;
            boolean isNotStart = false;
            if (isStartAndComplete) {
                List hisTaskList = Context.getCommandContext().getDbSqlSession().findInCache(HistoricTaskInstanceEntity.class);
                HistoricTaskInstanceEntity startTask = (HistoricTaskInstanceEntity)hisTaskList.stream().filter(e -> "main_process_start".equals(e.getCompleteType())).collect(Collectors.toList()).get(0);
                isNotStart = !startTask.getTaskDefinitionKey().equals(task.getTaskDefinitionKey());
            } else {
                boolean bl = isNotStart = ((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).count() > 0L;
            }
            if (isNotStart) {
                List<String> skipList = Arrays.asList(skipRepetition.split(","));
                String taskSourceFlag = BpmAttribute.getTaskSourceFlag(execution);
                if (taskSourceFlag == null || TaskSourceFlag.isComplete((String)taskSourceFlag)) {
                    if (skipList.contains("1") && users.isEmpty()) {
                        if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
                            activityRedisTimer.delTimeOutModel(task.getId());
                        }
                        return true;
                    }
                    ArrayList<Object> lastNodeAssignees = new ArrayList<Object>();
                    if (HussarUtils.isNotEmpty(users)) {
                        Object lastActivityId;
                        if (skipList.contains("3")) {
                            List historicTaskInstances2;
                            if (isStartAndComplete) {
                                List historicTaskInstances22 = Context.getCommandContext().getDbSqlSession().findAliveEntityInCache(HistoricTaskInstanceEntity.class);
                                historicTaskInstances22.removeIf(historicTaskInstance -> {
                                    if (!task.getProcessInstanceId().equals(historicTaskInstance.getProcessInstanceId())) {
                                        return true;
                                    }
                                    if (task.getSubProcessKey() == null) {
                                        return historicTaskInstance.getSubProcessKey() != null;
                                    }
                                    return !task.getSubProcessKey().equals(historicTaskInstance.getSubProcessKey());
                                });
                            } else {
                                historicTaskInstances2 = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).subProcessKey(task.getSubProcessKey())).list();
                            }
                            historicTaskInstances2.removeIf(historicTaskInstance -> historicTaskInstance.getEndTime() == null);
                            historicTaskInstances2.sort(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed());
                            Map<String, List<HistoricTaskInstance>> map = WorkflowBpmUtil.getListMap(historicTaskInstances2, TaskInfo::getTaskDefinitionKey, null);
                            map.remove(execution.getCurrentActivityId());
                            ArrayList<HistoricTaskInstance> lastTask = new ArrayList<HistoricTaskInstance>();
                            for (List<HistoricTaskInstance> list : map.values()) {
                                if (HussarUtils.isNotEmpty(list) && list.get(0).getSubProcessKey() != null) {
                                    Map<String, List<HistoricTaskInstance>> subProcessHistoricTaskInstancesMap = WorkflowBpmUtil.getListMap(list, HistoricTaskInstance::getSubProcessKey, null);
                                    for (List<HistoricTaskInstance> subProcessHistoricTaskInstancesList : subProcessHistoricTaskInstancesMap.values()) {
                                        CommonCodeUtil.getLastTaskCompleted(subProcessHistoricTaskInstancesList, lastTask);
                                    }
                                    continue;
                                }
                                CommonCodeUtil.getLastTaskCompleted(list, lastTask);
                            }
                            if (HussarUtils.isNotEmpty(lastTask)) {
                                lastTask.sort(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed());
                                for (HistoricTaskInstance historicTaskInstance2 : lastTask) {
                                    String assignee = historicTaskInstance2.getOriginalAssignee();
                                    if (!HussarUtils.isNotEmpty((Object)assignee)) continue;
                                    lastNodeAssignees.add(assignee);
                                }
                            }
                        } else if (skipList.contains("2") && HussarUtils.isNotEmpty((Object)(lastActivityId = task.getAllPrevNode()))) {
                            List historicTaskInstances3;
                            List<String> list = Arrays.asList(((String)lastActivityId).split(","));
                            if (isStartAndComplete) {
                                List historicTaskInstances32 = Context.getCommandContext().getDbSqlSession().findAliveEntityInCache(HistoricTaskInstanceEntity.class);
                                historicTaskInstances32.removeIf(historicTaskInstance -> {
                                    if (!task.getProcessInstanceId().equals(historicTaskInstance.getProcessInstanceId())) {
                                        return true;
                                    }
                                    if (!lastTaskDefinitionKeyList.contains(historicTaskInstance.getTaskDefinitionKey())) {
                                        return true;
                                    }
                                    if (task.getSubProcessKey() == null) {
                                        return historicTaskInstance.getSubProcessKey() != null;
                                    }
                                    return !task.getSubProcessKey().equals(historicTaskInstance.getSubProcessKey());
                                });
                            } else {
                                HistoricTaskInstanceQuery historicTaskInstanceQuery = (HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).subProcessKey(task.getSubProcessKey());
                                if (list.size() > 1) {
                                    historicTaskInstanceQuery.taskDefinitionKeys(list);
                                } else {
                                    historicTaskInstanceQuery.taskDefinitionKey(list.get(0));
                                }
                                historicTaskInstances3 = historicTaskInstanceQuery.list();
                            }
                            historicTaskInstances3.removeIf(historicTaskInstance -> historicTaskInstance.getEndTime() == null);
                            historicTaskInstances3.sort(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed());
                            Map<String, List<HistoricTaskInstance>> historicTaskInstancesMap = WorkflowBpmUtil.getListMap(historicTaskInstances3, TaskInfo::getTaskDefinitionKey, null);
                            ArrayList<HistoricTaskInstance> lastTask = new ArrayList<HistoricTaskInstance>();
                            for (List<HistoricTaskInstance> list2 : historicTaskInstancesMap.values()) {
                                CommonCodeUtil.getLastTaskCompleted(list2, lastTask);
                            }
                            lastTask.sort(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed());
                            lastTask.forEach(e -> lastNodeAssignees.add(e.getOriginalAssignee()));
                        }
                        if (HussarUtils.isNotEmpty(lastNodeAssignees)) {
                            for (String string : lastNodeAssignees) {
                                if (!users.contains(string)) continue;
                                task.setAssignee(string);
                                if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
                                    activityRedisTimer.delTimeOutModel(task.getId());
                                }
                                return true;
                            }
                        }
                    }
                }
            }
        }
        if ((notNeedCheckAssignee = (Boolean)Context.getCommandContext().getAttribute("notNeedCheckAssignee")) != null && !notNeedCheckAssignee.booleanValue() && (users == null || users.isEmpty())) {
            throw new BpmException(BpmExceptionCodeEnum.NULL_ASSIGNEE);
        }
        String delayToAssign = "";
        if (extensionElementsNode.get("delayToAssign") != null) {
            List list = (List)((ExtensionElement)((List)extensionElementsNode.get("delayToAssign")).get(0)).getAttributes().get("delayToAssign");
            String string = delayToAssign = HussarUtils.isNotEmpty((Object)list) ? ((ExtensionAttribute)list.get(0)).getValue() : "false";
        }
        if (users != null && !users.isEmpty()) {
            if (!"true".equals(delayToAssign)) {
                ConfigUser.recursionUser(configUser -> task.addCandidateUser(configUser.getUserId(), configUser.getOwner(), "1"), candidateUserList);
            } else {
                String taskId = task.getId();
                candidateUserService.saveBatch((Collection)ConfigUser.recursionAndCollectUser(ArrayList::new, configUser -> {
                    CandidateUser tmp = new CandidateUser();
                    tmp.setTaskId(Long.valueOf(Long.parseLong(taskId)));
                    tmp.setAssignee(configUser.taskOwner());
                    return tmp;
                }, candidateUserList));
            }
        }
        if (candidateUserExpressions != null && !candidateUserExpressions.isEmpty()) {
            for (Expression userIdExpr : candidateUserExpressions) {
                Object value3 = userIdExpr.getValue((VariableScope)execution);
                if (value3 instanceof String) {
                    List<String> candiates = this.extractCandidates((String)value3);
                    task.addCandidateUsers(candiates);
                    continue;
                }
                if (value3 instanceof Collection) {
                    task.addCandidateUsers((Collection)value3);
                    continue;
                }
                throw new ActivitiException(ERROR_MSG);
            }
        }
        if (!this.taskDefinition.getCustomUserIdentityLinkExpressions().isEmpty()) {
            identityLinks = this.taskDefinition.getCustomUserIdentityLinkExpressions();
            for (Map.Entry identityLink : identityLinks.entrySet()) {
                for (Expression expression : (Set)identityLink.getValue()) {
                    value = expression.getValue((VariableScope)execution);
                    if (value instanceof String) {
                        List<String> userIds = this.extractCandidates((String)value);
                        for (String userId : userIds) {
                            task.addUserIdentityLink(userId, (String)identityLink.getKey());
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator userIdSet = ((Collection)value).iterator();
                        while (userIdSet.hasNext()) {
                            task.addUserIdentityLink((String)userIdSet.next(), (String)identityLink.getKey());
                        }
                        continue;
                    }
                    throw new ActivitiException(ERROR_MSG);
                }
            }
        }
        if (!this.taskDefinition.getCustomGroupIdentityLinkExpressions().isEmpty()) {
            identityLinks = this.taskDefinition.getCustomGroupIdentityLinkExpressions();
            for (Map.Entry identityLink : identityLinks.entrySet()) {
                for (Expression expression : (Set)identityLink.getValue()) {
                    value = expression.getValue((VariableScope)execution);
                    if (value instanceof String) {
                        List<String> groupIds = this.extractCandidates((String)value);
                        for (String groupId : groupIds) {
                            task.addGroupIdentityLink(groupId, (String)identityLink.getKey());
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator groupIdSet = ((Collection)value).iterator();
                        while (groupIdSet.hasNext()) {
                            task.addGroupIdentityLink((String)groupIdSet.next(), (String)identityLink.getKey());
                        }
                        continue;
                    }
                    throw new ActivitiException(ERROR_MSG);
                }
            }
        }
        return false;
    }

    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if (!((ExecutionEntity)execution).getTasks().isEmpty()) {
            throw new ActivitiException("UserTask should not be signalled before complete");
        }
        this.leave(execution);
    }

    public void leave(ActivityExecution execution) {
        if (execution.getActivity() != null && ((ActivityImpl)execution.getActivity()).getActivityBehavior() instanceof ExtendUserTaskActivityBehavior) {
            BpmnModel bm = repositoryService.getBpmnModel(execution.getProcessDefinitionId());
            Map<String, Object> ccUserMap = AnalyticalModelUtil.getCcEndUser(bm, execution);
            List ccUserIds = (List)ccUserMap.get("ccUser");
            String ccSendUser = (String)ccUserMap.get("ccSendUser");
            if (!ccUserIds.isEmpty()) {
                String processInsId = execution.getProcessInstanceId();
                String taskDefKey = execution.getCurrentActivityId();
                String subProcessKey = execution.getSubProcessKey();
                HistoricTaskInstanceEntity historicTaskInstance = Context.getCommandContext().getTaskEntityManager().findLastFinishedTaskFromCache(processInsId, taskDefKey, subProcessKey);
                if (historicTaskInstance == null) {
                    historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().finished().processInstanceId(processInsId)).taskDefinitionKey(taskDefKey)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1).get(0);
                }
                this.ccTask((HistoricTaskInstance)historicTaskInstance, (List<String>)ccUserIds, ccSendUser, execution, bm);
            }
        }
        super.leave(execution);
    }

    private void ccTask(HistoricTaskInstance task, List<String> users, String userId, ActivityExecution execution, BpmnModel bpmnModel) {
        if (users.isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList();
        ProcessInstance processInstance = (ProcessInstance)execution.getProcessInstance();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        if (processInstance != null) {
            List ccFormKeyList;
            Map ccFormKeyMap;
            List ccElement = (List)bpmnModel.getFlowElement(task.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
            String formKey = null;
            if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
            }
            ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
            for (String user : users) {
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(task.getId());
                dataPush.setUserId(user);
                dataPush.setCcMoment("1");
                dataPush.setStartDate((Date)ts);
                dataPush.setProcessInsId(execution.getProcessInstanceId());
                dataPush.setProcessKey(((ProcessInstance)execution.getProcessInstance()).getProcessDefinitionKey());
                dataPushList.add(dataPush);
                CcTaskEntity sysActCcTask = new CcTaskEntity();
                sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
                sysActCcTask.setProcName(((ExecutionEntity)processInstance).getProcessDefinition().getName());
                sysActCcTask.setProcNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)processInstance.getProcessDefinitionId(), null));
                sysActCcTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                sysActCcTask.setTaskName(task.getName());
                sysActCcTask.setTaskNameTranslateKey(task.getNameTranslateKey());
                sysActCcTask.setReceiveUser(user);
                sysActCcTask.setSendUser(userId);
                sysActCcTask.setSendTime(ts);
                sysActCcTask.setFormKey(formKey);
                sysActCcTask.setFormId(task.getFormId());
                sysActCcTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActCcTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActCcTask.setProcDefId(processInstance.getProcessDefinitionId());
                sysActCcTask.setBusinessId(execution.getProcessBusinessKey());
                sysActCcTask.setTaskState("0");
                sysActCcTask.setCcMoment("1");
                sysActCcTask.setText(task.getTodoConfiguration());
                if (sysActCcTask.getReceiveUser().equals(task.getAssignee())) {
                    sysActCcTask.setTaskState("1");
                    if (date.after(task.getEndTime())) {
                        sysActCcTask.setEndTime(sysActCcTask.getSendTime());
                    } else {
                        sysActCcTask.setEndTime(new Timestamp(task.getEndTime().getTime()));
                    }
                    dataPush.setEndDate((Date)sysActCcTask.getEndTime());
                }
                sysActCcTask.insertCcTask();
            }
            if (dataPushService.isDataPush(execution.getProcessDefinitionId())) {
                dataPushService.addCcTask(dataPushList);
            }
        }
    }

    private void ccTask(Task task, List<String> users, String userId, ActivityExecution execution, BpmnModel bpmnModel) {
        if (users.isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList();
        ProcessInstance processInstance = (ProcessInstance)execution.getProcessInstance();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        if (processInstance != null) {
            List ccFormKeyList;
            Map ccFormKeyMap;
            List ccElement = (List)bpmnModel.getFlowElement(task.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
            String formKey = null;
            if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
            }
            for (String user : users) {
                CcTaskEntity ccTaskEntity = new CcTaskEntity();
                ccTaskEntity.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
                ccTaskEntity.setProcName(((ExecutionEntity)processInstance).getProcessDefinition().getName());
                ccTaskEntity.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                ccTaskEntity.setTaskName(task.getName());
                ccTaskEntity.setReceiveUser(user);
                ccTaskEntity.setSendUser(userId);
                ccTaskEntity.setSendTime(ts);
                ccTaskEntity.setFormKey(formKey);
                ccTaskEntity.setFormId(task.getFormId());
                ccTaskEntity.setTaskDefKey(task.getTaskDefinitionKey());
                ccTaskEntity.setProcDefKey(processInstance.getProcessDefinitionKey());
                ccTaskEntity.setProcDefId(processInstance.getProcessDefinitionId());
                ccTaskEntity.setBusinessId(execution.getProcessBusinessKey());
                ccTaskEntity.setTaskState("0");
                ccTaskEntity.setCcMoment("0");
                ccTaskEntity.setText(task.getTodoConfiguration());
                ccTaskEntity.insertCcTask();
            }
        }
    }

    protected List<String> extractCandidates(String str) {
        return Arrays.asList(str.split("[\\s]*,[\\s]*"));
    }

    protected Expression getActiveValue(Expression originalValue, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValueNode;
        Object activeValue = originalValue;
        if (taskElementProperties != null && (overrideValueNode = taskElementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideValueNode.asText());
        }
        return activeValue;
    }

    protected Set<Expression> getActiveValueSet(Set<Expression> originalValues, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValuesNode;
        Set<Expression> activeValues = originalValues;
        if (taskElementProperties != null && (overrideValuesNode = taskElementProperties.get(propertyName)) != null) {
            if (overrideValuesNode.isNull() || !overrideValuesNode.isArray() || overrideValuesNode.isEmpty()) {
                activeValues = null;
            } else {
                ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
                activeValues = new HashSet<Expression>();
                for (JsonNode valueNode : overrideValuesNode) {
                    activeValues.add(expressionManager.createExpression(valueNode.asText()));
                }
            }
        }
        return activeValues;
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }

    private boolean isGetVariable(String processDefinitionId, String taskDefinitionKey) {
        Map extensionElementsNode;
        BpmnModel bm = repositoryService.getBpmnModel(processDefinitionId);
        boolean isGetVariable = false;
        if (HussarUtils.isNotEmpty((Object)taskDefinitionKey) && HussarUtils.isNotEmpty((extensionElementsNode = ((Process)bm.getProcesses().get(0)).getExtensionElements()).get("extentAnnotation"))) {
            for (ExtensionElement extensionElement : (List)extensionElementsNode.get("extentAnnotation")) {
                String content = ((ExtensionAttribute)((List)extensionElement.getAttributes().get("annotationContent")).get(0)).getValue();
                if (!HussarUtils.isNotEmpty((Object)content) || !content.contains("$")) continue;
                isGetVariable = true;
                break;
            }
        }
        return isGetVariable;
    }
}

