/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowBpmUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.engine.impl.HistoricActivityInstanceQueryImpl;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CcTaskEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.VariableScopeImpl;
import org.activiti.engine.task.TaskQuery;

public class UserTaskMultiInstanceBatchDelCmd
implements Command<Integer> {
    private ExecutionEntity multiInstanceExcution;
    private List<String> assignees;
    private String excludeExcutionId;
    private String unDelTaskIds;
    private boolean canDelAllMultiTask;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)BpmSpringContextHolder.getSpringContext().getBean(ActivityRedisTimerService.class);
    private DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getSpringContext().getBean(DataPushService.class);

    public UserTaskMultiInstanceBatchDelCmd(ExecutionEntity multiInstanceExcution, List<String> assignees, String excludeExcutionId, boolean canDelAllMultiTask) {
        this.multiInstanceExcution = multiInstanceExcution;
        this.assignees = assignees;
        this.excludeExcutionId = excludeExcutionId;
        this.canDelAllMultiTask = canDelAllMultiTask;
    }

    public Integer execute(CommandContext commandContext) {
        ArrayList<TaskEntity> delTaskEntityList = new ArrayList<TaskEntity>();
        ArrayList<ExecutionEntity> delExecutionEntityList = new ArrayList<ExecutionEntity>();
        ArrayList<IdentityLinkEntity> delIdentityLinkEntityList = new ArrayList<IdentityLinkEntity>();
        this.resetHandleEntity(commandContext, delTaskEntityList, delExecutionEntityList, delIdentityLinkEntityList);
        if (delTaskEntityList.size() == 0) {
            return 0;
        }
        this.delIdentityLinkEntityList(commandContext, delIdentityLinkEntityList);
        this.delTaskEntity(commandContext, delTaskEntityList, delIdentityLinkEntityList);
        this.delExecutionEntity(commandContext, delExecutionEntityList);
        List delMainTaskEntityList = delTaskEntityList.stream().filter(e -> e.getParentTaskId() == null).collect(Collectors.toList());
        return delMainTaskEntityList.size();
    }

    private void resetHandleEntity(CommandContext commandContext, List<TaskEntity> delTaskEntityList, List<ExecutionEntity> delExecutionEntityList, List<IdentityLinkEntity> delIdentityLinkEntityList) {
        List childExecutionEntityList = this.multiInstanceExcution.getExecutions();
        childExecutionEntityList.forEach(ExecutionEntity::setExecutionsNewArrayList);
        Map<String, ExecutionEntity> childExecutionEntityMap = WorkflowBpmUtil.getMap(childExecutionEntityList, ExecutionEntity::getId, null);
        List taskEntityList = ((TaskQuery)((TaskQuery)commandContext.getProcessEngineConfiguration().getTaskService().createTaskQuery().processInstanceId(this.multiInstanceExcution.getProcessInstanceId())).taskDefinitionKey(this.multiInstanceExcution.getActivityId())).list();
        Map<String, TaskEntity> taskEntityMap = WorkflowBpmUtil.getMap(taskEntityList, VariableScopeImpl::getId, e -> e.getParentTaskId() == null);
        Map<String, List<TaskEntity>> childTaskEntityMap = WorkflowBpmUtil.getListMap(taskEntityList, TaskEntity::getParentTaskId, e -> e.getParentTaskId() != null);
        List taskIds = taskEntityMap.keySet().stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
        List identityLinkEntityList = commandContext.getIdentityLinkEntityManager().findIdentityLinksByTaskIds(taskIds);
        Map<String, List<IdentityLinkEntity>> identityLinkEntityMap = WorkflowBpmUtil.getListMap(identityLinkEntityList, IdentityLinkEntity::getTaskId, null);
        for (IdentityLinkEntity identityLinkEntity : identityLinkEntityList) {
            TaskEntity taskEntity = taskEntityMap.get(identityLinkEntity.getTaskId());
            if (taskEntity.getParentTaskId() == null) {
                if (this.excludeExcutionId != null && !this.excludeExcutionId.equals(taskEntity.getExecutionId()) || this.assignees != null && !this.assignees.contains(identityLinkEntity.getUserId())) continue;
                delIdentityLinkEntityList.add(identityLinkEntity);
                delTaskEntityList.add(taskEntity);
                delExecutionEntityList.add(childExecutionEntityMap.get(taskEntity.getExecutionId()));
                List<TaskEntity> childTaskEntityList = childTaskEntityMap.get(taskEntity.getId());
                if (childTaskEntityList == null) continue;
                delTaskEntityList.addAll(childTaskEntityList);
                for (TaskEntity childTask : childTaskEntityList) {
                    List<IdentityLinkEntity> childIdentityLinkEntityList = identityLinkEntityMap.get(childTask.getId());
                    if (childIdentityLinkEntityList == null) continue;
                    delIdentityLinkEntityList.addAll(childIdentityLinkEntityList);
                }
                continue;
            }
            this.unDelTaskIds = taskEntity.getId();
        }
        if (!this.canDelAllMultiTask && childExecutionEntityList.size() == delExecutionEntityList.size()) {
            throw new BpmException(BpmExceptionCodeEnum.THE_ONLY_ASSIGNEE_IN_MULTI);
        }
    }

    private void delIdentityLinkEntityList(CommandContext commandContext, List<IdentityLinkEntity> delIdentityLinkEntityList) {
        List<List<IdentityLinkEntity>> lists = WorkflowBpmUtil.getSqlIdList(delIdentityLinkEntityList);
        lists.forEach(e -> commandContext.getDbSqlSession().delete("bulkDeleteIdentityLink", e));
    }

    private void delTaskEntity(CommandContext commandContext, List<TaskEntity> delTaskEntityList, List<IdentityLinkEntity> delIdentityLinkEntityList) {
        Set taskIds = delTaskEntityList.stream().map(VariableScopeImpl::getId).collect(Collectors.toSet());
        List<List<TaskEntity>> lists = WorkflowBpmUtil.getSqlIdList(delTaskEntityList);
        lists.forEach(e -> e.forEach(a -> commandContext.getTaskEntityManager().deleteTask(a, null, true)));
        HistoricTaskInstanceQueryImpl historicTaskInstanceQuery = new HistoricTaskInstanceQueryImpl();
        historicTaskInstanceQuery.subProcessKey(this.multiInstanceExcution.getSubProcessKey());
        historicTaskInstanceQuery.processInstanceId(this.multiInstanceExcution.getProcessInstanceId());
        historicTaskInstanceQuery.taskDefinitionKey(this.multiInstanceExcution.getActivityId());
        List historicTaskInstanceEntityList = commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstancesByQueryCriteria(historicTaskInstanceQuery);
        historicTaskInstanceEntityList.forEach(e -> {
            if (taskIds.contains(e.getId())) {
                commandContext.getDbSqlSession().delete((PersistentObject)e);
            }
        });
        List historicVariableInstanceEntityList = commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricVariableInstanceQuery().taskIds(taskIds).list();
        historicVariableInstanceEntityList.forEach(e -> commandContext.getDbSqlSession().delete((PersistentObject)e));
        for (TaskEntity taskEntity : delTaskEntityList) {
            if (taskEntity.getParentTaskId() != null || taskEntity.getDueDate() == null) continue;
            this.activityRedisTimerService.delTimeOutModel(String.join((CharSequence)",", taskIds));
            break;
        }
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(this.multiInstanceExcution.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setProcessKey(this.multiInstanceExcution.getProcessDefinitionKey());
            dataPush.setProcessDefinitionId(this.multiInstanceExcution.getProcessDefinitionId());
            dataPush.setTaskIds(new ArrayList(taskIds));
            dataPush.setProcessInsId(this.multiInstanceExcution.getProcessInstanceId());
            this.dataPushService.deleteMultiTask(dataPush);
        }
        List longTaskIds = taskIds.stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
        List ccTaskEntityList = Context.getCommandContext().getCcTaskEntityManager().getCcTaskByProcessInsIdAndTaskDefKey(this.multiInstanceExcution.getCurrentActivityId(), Long.valueOf(this.multiInstanceExcution.getProcessInstanceId()));
        if (HussarUtils.isNotEmpty((Object)this.unDelTaskIds)) {
            ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
            if (HussarUtils.isNotEmpty((Object)ccTaskEntityList)) {
                for (CcTaskEntity ccTaskEntity : ccTaskEntityList) {
                    if (!longTaskIds.contains(ccTaskEntity.getTaskId())) continue;
                    ccTaskEntity.setTaskId(Long.valueOf(this.unDelTaskIds));
                    ccTaskEntity.setUpdateTaskId(true);
                    ccTaskEntity.updateCcTask();
                    if (!this.dataPushService.isDataPush(processDefinitionIdList)) continue;
                    DataPush dataPush = new DataPush();
                    dataPush.setUserId(ccTaskEntity.getReceiveUser());
                    dataPush.setTaskId(this.unDelTaskIds);
                    dataPush.setStartDate((Date)ccTaskEntity.getSendTime());
                    dataPush.setEndDate((Date)ccTaskEntity.getEndTime());
                    dataPush.setCcMoment(ccTaskEntity.getCcMoment() == null ? "0" : ccTaskEntity.getCcMoment());
                    dataPush.setProcessInsId(String.valueOf(ccTaskEntity.getProcessInsId()));
                    dataPushList.add(dataPush);
                }
            }
            if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                this.dataPushService.addCcTask(dataPushList);
            }
        } else if (HussarUtils.isNotEmpty((Object)ccTaskEntityList)) {
            for (CcTaskEntity ccTaskEntity : ccTaskEntityList) {
                ccTaskEntity.deleteCcTask();
            }
        }
    }

    private void delExecutionEntity(CommandContext commandContext, List<ExecutionEntity> delExecutionEntityList) {
        Set executionIds = delExecutionEntityList.stream().map(ExecutionEntity::getId).collect(Collectors.toSet());
        delExecutionEntityList.forEach(e -> commandContext.getExecutionEntityManager().delete((PersistentObject)e));
        List historicVariableInstanceEntityList = commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricVariableInstanceQuery().executionIds(executionIds).list();
        List<List<List>> hiVariabellists = WorkflowBpmUtil.getSqlIdList(historicVariableInstanceEntityList);
        hiVariabellists.forEach(e -> commandContext.getDbSqlSession().delete("bulkDeleteHistoricVariableInstance", e));
        HistoricActivityInstanceQueryImpl historicActivityInstanceQuery = new HistoricActivityInstanceQueryImpl();
        historicActivityInstanceQuery.processInstanceId(this.multiInstanceExcution.getProcessInstanceId());
        historicActivityInstanceQuery.subProcessKey(this.multiInstanceExcution.getSubProcessKey());
        historicActivityInstanceQuery.activityId(this.multiInstanceExcution.getSubProcessKey());
        List historicActivityInstanceEntityList = commandContext.getHistoricActivityInstanceEntityManager().findHistoricActivityInstancesByQueryCriteria(historicActivityInstanceQuery, null);
        historicActivityInstanceEntityList.forEach(e -> {
            if (executionIds.contains(e.getExecutionId())) {
                e.setEndTime(new Date());
                commandContext.getDbSqlSession().update((PersistentObject)e);
            }
        });
    }
}

