/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ExtendDataDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ExecutionInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.EntrustTaskAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceRevokeTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessEndCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.RevokeAddHistoryTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.SubProcessEndCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extenddata.service.WorkflowExtendDataService;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.UnexpectedException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.engine.constant.BpmHistoryActivity;
import com.jxdinfo.hussar.workflow.engine.constant.BpmHistoryTask;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CcTaskEntity;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;

public class TaskRejectCmd
extends AddAttributeCmd<Void> {
    private HistoryService historyService = (HistoryService)BpmSpringContextHolder.getSpringContext().getBean(HistoryService.class);
    private RuntimeService runtimeService = (RuntimeService)BpmSpringContextHolder.getSpringContext().getBean(RuntimeService.class);
    private RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getSpringContext().getBean(RepositoryService.class);
    private TaskService taskService = (TaskService)BpmSpringContextHolder.getSpringContext().getBean(TaskService.class);
    private ISysActHiLineService iSysActHiLineService = (ISysActHiLineService)BpmSpringContextHolder.getSpringContext().getBean(ISysActHiLineService.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)BpmSpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)BpmSpringContextHolder.getBean(ISysActCcTaskService.class);
    private DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getBean(DataPushService.class);
    private WorkflowExtendDataService workflowExtendDataService = (WorkflowExtendDataService)BpmSpringContextHolder.getBean(WorkflowExtendDataService.class);
    private ITaskEngineService taskEngineService = (ITaskEngineService)SpringContextHolder.getApplicationContext().getBean(ITaskEngineService.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)BpmSpringContextHolder.getBean(BpmConstantProperties.class);
    private TaskRejectModel taskRejectModel;
    private static final List<String> FORBID_REVOKE_TASK_SOURCE_FLAG = new ArrayList<String>();
    private static final List<String> FORBID_REVOKE_TASK_TYPE = new ArrayList<String>();
    private String taskSourceFlag;

    public TaskRejectCmd(TaskRejectModel taskRejectModel) {
        this.taskRejectModel = taskRejectModel;
    }

    public Void execute(CommandContext commandContext) {
        ExecutionEntity processInstance;
        this.addAttribute(commandContext);
        Map map = this.taskRejectModel.getMap();
        if (HussarUtils.isNotEmpty((Object)map)) {
            if (HussarUtils.isNotEmpty((Object)map.containsKey("submitToRejectNode"))) {
                commandContext.addAttribute("submitToRejectNode", map.get("submitToRejectNode"));
            }
            this.taskRejectModel.getMap().remove("submitToRejectNode");
        }
        if (this.taskRejectModel.getTaskId() != null) {
            TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskRejectModel.getTaskId());
            if (task == null) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND);
            }
            processInstance = task.getProcessInstance();
            this.addExecutionAttribute(processInstance);
            this.taskSourceFlag = BpmAttribute.getTaskSourceFlag((ActivityExecution)processInstance);
            if (task.getTaskDefinitionKey().equals(this.taskRejectModel.getTargetIds()) && "reject".equals(this.taskSourceFlag)) {
                throw new BpmException(BpmExceptionCodeEnum.FORBID_REJECT_TO_CURRENT_NODE);
            }
            if (task.getTaskDefinitionKey().equals(this.taskRejectModel.getTargetIds()) && "freejump".equals(this.taskSourceFlag)) {
                throw new BpmException(BpmExceptionCodeEnum.FORBID_FREE_JUMP_TO_CURRENT_NODE);
            }
            this.taskRejectModel.setTask((Task)task);
            BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            this.taskRejectModel.setBm(bm);
            commandContext.addAttribute("taskId", (Object)task.getId());
        } else if (this.taskRejectModel.getHistoryTaskId() != null) {
            this.taskRejectModel.setEndTime(new Date());
            HistoricTaskInstanceEntity historicTaskInstance = commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceById(this.taskRejectModel.getHistoryTaskId());
            if (historicTaskInstance == null) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND);
            }
            if (TaskType.isAssist((String)historicTaskInstance.getTaskType())) {
                throw new BpmException(BpmExceptionCodeEnum.ASSIST_TASK_WITH_ERROR_HANDLE);
            }
            this.taskRejectModel.setProcInsId(historicTaskInstance.getProcessInstanceId());
            this.taskRejectModel.setHistoricTaskInstance(historicTaskInstance);
            if (TaskType.isEntrust((String)historicTaskInstance.getTaskType())) {
                this.entrustRevoke(commandContext, (HistoricTaskInstance)historicTaskInstance);
                return null;
            }
            BpmnModel bm = this.repositoryService.getBpmnModel(historicTaskInstance.getProcessDefinitionId());
            this.taskRejectModel.setBm(bm);
            processInstance = commandContext.getExecutionEntityManager().findExecutionById(historicTaskInstance.getProcessInstanceId());
            this.addExecutionAttribute(processInstance);
            if (this.revokeHandle(commandContext)) {
                return null;
            }
            if (historicTaskInstance.getMultiId() != null) {
                processInstance.addTempVariable("multi_id", (Object)historicTaskInstance.getMultiId());
                processInstance.addTempVariable("addAssigneeOperator", (Object)historicTaskInstance.getAddAssigneeOperator());
            }
        } else {
            throw new PublicClientException(bpmConstantProperties.getMissParam());
        }
        this.taskSourceFlag = BpmAttribute.getTaskSourceFlag((ActivityExecution)processInstance);
        this.setTargetNode();
        this.checkTargetNode();
        if (this.taskRejectModel.getHistoryTaskId() == null) {
            this.taskAssigneeHandle(commandContext);
        }
        this.subProcessReStartHandle(commandContext);
        this.rejectTypeHandle();
        this.rejectCallActivityHandle(commandContext);
        this.rejectNodeSendUserHandle(commandContext);
        this.rejectExecute(this.taskRejectModel.getUserId(), this.taskRejectModel.getMandator(), this.taskRejectModel.getExecution() == null ? (TaskEntity)this.taskRejectModel.getTask() : null, this.taskRejectModel.getExecution(), this.taskRejectModel.getTargetIds(), this.taskRejectModel.getTaskId(), this.taskRejectModel.getComment(), this.taskRejectModel.getParamMap(), this.taskSourceFlag, this.taskRejectModel.getMap(), this.taskRejectModel, commandContext);
        if (TaskSourceFlag.isRevoke((String)this.taskSourceFlag) && this.taskRejectModel.getHistoricTaskInstance() != null) {
            this.taskRejectModel.getHistoricTaskInstance().setTaskType("7");
        }
        return null;
    }

    private void allPrevNodeHandle() {
        if (TaskSourceFlag.isRejectOrRevoke((String)this.taskSourceFlag)) {
            String subProcessKey;
            String processInstId;
            ExecutionEntity execution = this.taskRejectModel.getExecution();
            if (execution != null) {
                processInstId = execution.getProcessInstanceId();
                subProcessKey = execution.getSubProcessKey();
            } else {
                TaskEntity task = (TaskEntity)UnexpectedException.assertNotNull((Object)this.taskRejectModel.getTask());
                processInstId = task.getProcessInstanceId();
                subProcessKey = task.getSubProcessKey();
                execution = task.getProcessInstance();
            }
            Iterator iterator = this.taskRejectModel.getJumpModel().getJumpTo().iterator();
            while (iterator.hasNext()) {
                String jumpTo;
                HistoricTaskInstance lastComplete = BpmHistoryTask.getLastComplete(processInstId, subProcessKey, jumpTo = (String)iterator.next());
                BpmAttribute.addAllPrevNode((ActivityExecution)execution, jumpTo, lastComplete == null ? null : lastComplete.getAllPrevNode());
            }
        }
    }

    private String getErrorMessage() {
        if (TaskSourceFlag.isReject((String)this.taskSourceFlag)) {
            return BpmExceptionCodeEnum.NOT_REJECT_TO_TARGET_NODE.getMessage();
        }
        if (TaskSourceFlag.isRevoke((String)this.taskSourceFlag)) {
            return BpmExceptionCodeEnum.NOT_REVOKE_TO_TARGET_NODE.getMessage();
        }
        return BpmExceptionCodeEnum.NOT_FREE_JUMP_TO_TARGET_NODE.getMessage();
    }

    private void rejectExecute(String userId, String mandator, TaskEntity task, ExecutionEntity execution, String backActivityId, String taskId, String comment, Map<String, Object> paramMap, String type, Map<String, Object> map, TaskRejectModel taskRejectModel, CommandContext commandContext) {
        String executionId;
        ActivityImpl currentActivity;
        String subProcessKey;
        JumpModel jumpModel = taskRejectModel.getJumpModel();
        int backType = jumpModel.getJumpType();
        boolean revoke = TaskSourceFlag.isRevoke((String)type);
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (task != null) {
            if (!revoke) {
                if (StringUtils.isNotEmpty((CharSequence)comment) && (TaskSourceFlag.isReject((String)type) || TaskSourceFlag.isFreeJump((String)type))) {
                    CommentEntity commentEntity = new CommentEntity();
                    commentEntity.setUserId(userId);
                    commentEntity.setType("complete");
                    commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
                    commentEntity.setTaskId(task.getId());
                    commentEntity.setProcessInstanceId(null);
                    commentEntity.setAction("AddComment");
                    String eventMessage = comment.replaceAll("\\s+", " ");
                    if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                        eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
                    }
                    commentEntity.setMessage(eventMessage);
                    commentEntity.setFullMessage(comment);
                    commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
                }
                if (HussarUtils.isNotEmpty(paramMap) && this.workflowExtendDataService != null) {
                    ExtendDataDto extendDataDto = new ExtendDataDto();
                    extendDataDto.setTaskId(task.getId());
                    extendDataDto.setExtendData(paramMap);
                    extendDataDto.setProcessKey(task.getProcessKey());
                    extendDataDto.setProcessInsId(task.getProcessInstanceId());
                    this.workflowExtendDataService.addExtendData(extendDataDto);
                }
            }
            subProcessKey = task.getSubProcessKey();
            currentActivity = task.getExecution().getActivity();
            executionId = task.getExecutionId();
        } else {
            currentActivity = execution.getActivity();
            if (execution.getActivity() == null) {
                currentActivity = ((ExecutionEntity)execution.getExecutions().get(0)).getActivity();
            }
            executionId = execution.getId();
            subProcessKey = execution.getSubProcessKey();
        }
        commandContext.addAttribute("activitiId", (Object)currentActivity.getId());
        switch (backType) {
            case 2: {
                new MultiInstanceJumpTaskCmd(userId, mandator, executionId, jumpModel, task == null ? null : task.getId(), comment, paramMap, newMap, currentActivity, taskRejectModel).execute(commandContext);
                break;
            }
            case 3: {
                if (!revoke && task != null && HussarUtils.isNotEmpty((Object)userId) && HussarUtils.isEmpty((Object)task.getAssignee()) && task.getAssignee() == null) {
                    task.setAssignee(userId, true, true);
                }
                new ParallelJumpTaskCmd(userId, mandator, executionId, jumpModel, comment, paramMap, subProcessKey, newMap, currentActivity, taskRejectModel).execute(commandContext);
                break;
            }
            default: {
                if (!revoke && task != null && StringUtils.isNotEmpty((CharSequence)userId) && task.getAssignee() == null) {
                    task.setAssignee(userId, true, true);
                }
                new CommonJumpTaskCmd(task != null ? task.getId() : null, userId, mandator, executionId, jumpModel, comment, paramMap, type, newMap, currentActivity, taskRejectModel).execute(commandContext);
            }
        }
        if (task != null && HussarUtils.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(task.getId());
        }
    }

    private void entrustRevoke(CommandContext commandContext, HistoricTaskInstance historicTaskInstance) {
        String owner;
        String userId = historicTaskInstance.getReceiver();
        if (Objects.equals(userId, owner = historicTaskInstance.getOwner())) {
            owner = null;
        }
        new EntrustTaskAssigneeCmd(historicTaskInstance.getParentTaskId(), userId, historicTaskInstance.getAssignee(), false, false, owner).execute(commandContext);
        TaskEntity taskEntity = commandContext.getTaskEntityManager().findTaskById(historicTaskInstance.getParentTaskId());
        new RevokeAddHistoryTaskCmd(taskEntity.getExecution(), this.taskRejectModel.getComment(), historicTaskInstance.getEndTime(), new Date(), historicTaskInstance.getAssignee(), historicTaskInstance.getParentTaskId(), historicTaskInstance.getOwner()).execute(commandContext);
        this.taskRejectModel.getHistoricTaskInstance().setTaskType("7");
    }

    private boolean revokeHandle(CommandContext commandContext) {
        HistoricTaskInstance taskInstance;
        HistoricTaskInstanceEntity historicTaskInstance = this.taskRejectModel.getHistoricTaskInstance();
        String subProcessKey = historicTaskInstance.getSubProcessKey();
        if (this.taskRejectModel.getUserId() == null || !this.taskRejectModel.getUserId().equals(historicTaskInstance.getAssignee()) && !this.taskRejectModel.getUserId().equals(historicTaskInstance.getOwner())) {
            throw new BpmException(BpmExceptionCodeEnum.NO_AUTHORITY_COMPLETE.getMessage());
        }
        if (HussarUtils.isEmpty((Object)historicTaskInstance.getEndTime())) {
            throw new BpmException(BpmExceptionCodeEnum.CURRENT_TASK_CANNOT_REVOKE);
        }
        ExecutionEntity processInstanceExecution = commandContext.getExecutionEntityManager().findExecutionById(historicTaskInstance.getProcessInstanceId());
        Map appointAssignee = (Map)BpmAttribute.getExecutionAttribute((ActivityExecution)processInstanceExecution, "appoint_assignee");
        String taskSourceFlag = historicTaskInstance.getTaskSourceFlag();
        boolean revokeReject = false;
        if (TaskSourceFlag.isReject((String)taskSourceFlag)) {
            revokeReject = true;
            this.taskRejectModel.setSubmit(false);
            processInstanceExecution.addTempVariable("taskSourceFlag", (Object)"reject_revoke");
            this.taskSourceFlag = "reject_revoke";
        }
        if (FORBID_REVOKE_TASK_TYPE.contains(historicTaskInstance.getTaskType())) {
            throw new BpmException(BpmExceptionCodeEnum.ASSIST_FINISH_TASK_WITH_ERROR_HANDLE.getMessage());
        }
        if (TaskSourceFlag.isRevoke((String)taskSourceFlag)) {
            throw new PublicClientException(BpmExceptionCodeEnum.WITHDRAW_RECALL_TASK_ERROR.getMessage());
        }
        if ("assist_complete".equals(taskSourceFlag)) {
            throw new PublicClientException(BpmExceptionCodeEnum.ASSIST_FINISH_TASK_WITH_ERROR_HANDLE.getMessage());
        }
        if ("complete_leap".equals(taskSourceFlag)) {
            throw new PublicClientException(BpmExceptionCodeEnum.COMPLETE_LEAP_TASK_ERROR.getMessage());
        }
        if ("ccTask".equals(taskSourceFlag)) {
            throw new PublicClientException(BpmExceptionCodeEnum.CIRCULATED_TASK_ERROR.getMessage());
        }
        if ("addAssignee".equals(taskSourceFlag)) {
            throw new PublicClientException(BpmExceptionCodeEnum.ADD_ASSIGNEE_ERROR.getMessage());
        }
        if ("delAssignee".equals(taskSourceFlag)) {
            throw new PublicClientException(BpmExceptionCodeEnum.DEL_ASSIGNEE_ERROR.getMessage());
        }
        this.taskRejectModel.setTargetIds(historicTaskInstance.getTaskDefinitionKey());
        HistoricTaskInstance historicTaskInstance2 = taskInstance = revokeReject ? BpmHistoryTask.getRandomRunningRejectFollow(historicTaskInstance.getProcessInstanceId(), subProcessKey, historicTaskInstance.getTaskDefinitionKey()) : BpmHistoryTask.getRandomRunningFollow(historicTaskInstance.getProcessInstanceId(), subProcessKey, historicTaskInstance.getTaskDefinitionKey());
        if (HussarUtils.isNotEmpty((Object)taskInstance)) {
            TaskEntity task = commandContext.getTaskEntityManager().findTaskById(taskInstance.getId());
            BpmnModel bm = this.taskRejectModel.getBm();
            String allPrevNode = task.getAllPrevNode();
            if (!revokeReject && historicTaskInstance.getProcessInstanceId().equals(task.getProcessInstanceId()) && HussarUtils.isNotEmpty((Object)allPrevNode) && allPrevNode.contains(",")) {
                String targetGateway = ((SysActHiLine)this.iSysActHiLineService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActHiLine::getProcessInsId, (Object)Long.parseLong(task.getProcessInstanceId()))).eq(SysActHiLine::getInNode, (Object)task.getTaskDefinitionKey())).orderByDesc(SysActHiLine::getCompleteTime)).get(0)).getOutNode();
                while (!(bm.getFlowElement(targetGateway) instanceof ParallelGateway) && !(bm.getFlowElement(targetGateway) instanceof InclusiveGateway)) {
                    List hiLines = this.iSysActHiLineService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActHiLine::getProcessInsId, (Object)Long.parseLong(task.getProcessInstanceId()))).eq(SysActHiLine::getInNode, (Object)targetGateway)).orderByDesc(SysActHiLine::getCompleteTime));
                    if (hiLines.isEmpty()) {
                        if (bm.getFlowElement(targetGateway) instanceof StartEvent) {
                            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                                if (!(flowElement instanceof SubProcess) || ((SubProcess)flowElement).getFlowElement(targetGateway) == null) continue;
                                targetGateway = flowElement.getId();
                            }
                            continue;
                        }
                        throw new UnexpectedException(this.getErrorMessage());
                    }
                    targetGateway = ((SysActHiLine)hiLines.get(0)).getOutNode();
                }
                String jumpToExecutionNode = targetGateway;
                this.taskRejectModel.setJumpToExecution(Arrays.stream(allPrevNode.split(",")).map(prevNode -> new ExecutionInfo(jumpToExecutionNode, prevNode, null)).collect(Collectors.toList()));
            }
            this.taskRejectModel.setTask((Task)task);
            if (!TaskSourceFlag.isComplete((String)taskSourceFlag) && this.canNotRejectPrepare(bm, task.getTaskDefinitionKey(), historicTaskInstance.getTaskDefinitionKey(), true) && this.canNotRejectPrepare(bm, task.getTaskDefinitionKey(), historicTaskInstance.getTaskDefinitionKey(), false)) {
                throw new BpmException(BpmExceptionCodeEnum.NO_COMPLETE_REVOKE_ERROR.getMessage());
            }
        } else {
            List executionList = this.runtimeService.createExecutionQuery().processInstanceId(historicTaskInstance.getProcessInstanceId()).list();
            executionList.removeIf(arg_0 -> TaskRejectCmd.lambda$revokeHandle$1((HistoricTaskInstance)historicTaskInstance, arg_0));
            ExecutionEntity executionEntity = null;
            if (HussarUtils.isEmpty((Object)executionList)) {
                List list = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(historicTaskInstance.getProcessInstanceId()).list();
                if (revokeReject) {
                    list.removeIf(arg_0 -> TaskRejectCmd.lambda$revokeHandle$2((HistoricTaskInstance)historicTaskInstance, arg_0));
                } else {
                    list.removeIf(arg_0 -> TaskRejectCmd.lambda$revokeHandle$3((HistoricTaskInstance)historicTaskInstance, arg_0));
                }
                if (HussarUtils.isEmpty((Object)list)) {
                    throw new UnexpectedException(bpmConstantProperties.getRevokeTargetNotFound());
                }
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)list.get(0);
                ExecutionEntity callExecution = commandContext.getExecutionEntityManager().findExecutionById(historicProcessInstance.getId());
                executionEntity = callExecution.getSuperExecution();
            } else {
                executionEntity = (ExecutionEntity)executionList.get(0);
                for (Execution execution : executionList) {
                    if (execution.getParentId() != null && execution.getActivityId() != null) {
                        executionEntity = (ExecutionEntity)execution;
                    }
                    if (((ExecutionEntity)execution).isScope() || execution.getActivityId() == null) continue;
                    executionEntity = (ExecutionEntity)execution;
                    break;
                }
            }
            UnexpectedException.assertNotNull((Object)executionEntity, (String)"\u672a\u67e5\u8be2\u5230\u88ab\u64a4\u56de\u76ee\u6807\uff01");
            BpmnModel bm = this.taskRejectModel.getBm();
            if (!historicTaskInstance.getTaskDefinitionKey().equals(executionEntity.getActivityId())) {
                String allPrevNode = executionEntity.getAllPrevNode();
                if (HussarUtils.isNotEmpty((Object)allPrevNode) && allPrevNode.contains(",")) {
                    String targetGateway = ((SysActHiLine)this.iSysActHiLineService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActHiLine::getProcessInsId, (Object)Long.parseLong(executionEntity.getProcessInstanceId()))).eq(SysActHiLine::getInNode, (Object)executionEntity.getActivityId())).orderByDesc(SysActHiLine::getCompleteTime)).get(0)).getOutNode();
                    while (!(bm.getFlowElement(targetGateway) instanceof ParallelGateway) && !(bm.getFlowElement(targetGateway) instanceof InclusiveGateway)) {
                        targetGateway = ((SysActHiLine)this.iSysActHiLineService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActHiLine::getProcessInsId, (Object)Long.parseLong(executionEntity.getProcessInstanceId()))).eq(SysActHiLine::getInNode, (Object)targetGateway)).orderByDesc(SysActHiLine::getCompleteTime)).get(0)).getOutNode();
                    }
                    String jumpToExecutionNode = targetGateway;
                    this.taskRejectModel.setJumpToExecution(Arrays.stream(allPrevNode.split(",")).map(prevNode -> new ExecutionInfo(jumpToExecutionNode, prevNode, null)).collect(Collectors.toList()));
                }
                this.taskRejectModel.setExecution(executionEntity);
            } else {
                List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(historicTaskInstance.getProcessInstanceId())).taskDefinitionKey(historicTaskInstance.getTaskDefinitionKey())).listPage(0, 1);
                if (tasks.size() == 1) {
                    new MultiInstanceRevokeTaskCmd((HistoricTaskInstance)historicTaskInstance, this.taskRejectModel.getComment(), this.taskRejectModel.getParamMap(), this.taskRejectModel.getEndTime()).execute(commandContext);
                    this.setRejectAppointAssignee(processInstanceExecution, appointAssignee, Collections.singletonList(historicTaskInstance.getOriginalAssignee()));
                    this.taskRejectModel.getHistoricTaskInstance().setTaskType("7");
                    return true;
                }
            }
        }
        List<HistoricTaskInstance> hisTaskList = BpmHistoryTask.findAllEndTask(historicTaskInstance.getProcessInstanceId(), subProcessKey, historicTaskInstance.getTaskDefinitionKey());
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            List ccTaskEntityList;
            ArrayList<String> stringTaskIds = new ArrayList<String>();
            HistoricTaskInstance historicTask = hisTaskList.get(0);
            Long multiId = historicTask.getMultiId();
            stringTaskIds.add(historicTask.getId());
            if (multiId != null) {
                for (int j = 1; j < hisTaskList.size() && Objects.equals(multiId, (historicTask = hisTaskList.get(j)).getMultiId()); ++j) {
                    stringTaskIds.add(historicTask.getId());
                }
            }
            if ((ccTaskEntityList = Context.getCommandContext().getCcTaskEntityManager().getCcTaskByProcessInsIdAndTaskDefKey(historicTaskInstance.getTaskDefinitionKey(), Long.valueOf(historicTaskInstance.getProcessInstanceId()))) != null && !ccTaskEntityList.isEmpty()) {
                List taskIdList = stringTaskIds.stream().map(Long::valueOf).collect(Collectors.toList());
                for (CcTaskEntity ccTaskEntity : ccTaskEntityList) {
                    if (!ccTaskEntity.getCcMoment().equals("1") || !taskIdList.contains(ccTaskEntity.getTaskId())) continue;
                    ccTaskEntity.deleteCcTask();
                }
            }
            if (this.dataPushService.isDataPush(historicTask.getProcessDefinitionId())) {
                DataPush dataPush = new DataPush();
                dataPush.setTaskIds(stringTaskIds);
                dataPush.setCcMoment("1");
                dataPush.setProcessInsId(historicTask.getProcessInstanceId());
                dataPush.setProcessKey(historicTask.getProcessKey());
                this.dataPushService.deleteCcTask(dataPush);
            }
        }
        if (revokeReject) {
            List<String> lastAppoint = BpmHistoryTask.getLastAppoint(historicTaskInstance.getProcessInstanceId(), subProcessKey, historicTaskInstance.getTaskDefinitionKey());
            this.setRejectAppointAssignee(processInstanceExecution, appointAssignee, lastAppoint);
            HistoricTaskInstance lastComplete = BpmHistoryTask.getLastComplete(historicTaskInstance.getProcessInstanceId(), subProcessKey, historicTaskInstance.getTaskDefinitionKey());
            if (lastComplete != null && lastComplete.getMultiId() != null) {
                List historicVariableInstances = this.historyService.createHistoricVariableInstanceQuery().taskId(lastComplete.getId()).list();
                Object multiType = null;
                Object multiFinishCondition = null;
                if (historicVariableInstances != null) {
                    for (HistoricVariableInstance variableInstance : historicVariableInstances) {
                        if (Objects.equals(variableInstance.getVariableTypeName(), "multi_type")) {
                            multiType = variableInstance.getValue();
                            continue;
                        }
                        if (!Objects.equals(variableInstance.getVariableTypeName(), "multi_finish_condition")) continue;
                        multiFinishCondition = variableInstance.getValue();
                    }
                }
                if (HussarUtils.isNotEmpty(multiType) && HussarUtils.isNotEmpty(multiFinishCondition)) {
                    this.taskRejectModel.getMap().put("multi_type", multiType);
                    this.taskRejectModel.getMap().put("multi_finish_condition", multiFinishCondition);
                }
            }
        } else if (!this.taskRejectModel.isSubmit()) {
            ProcessDefinitionEntity definition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicTaskInstance.getProcessDefinitionId());
            if (definition == null) {
                throw new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_FOUND);
            }
            ActivityImpl currActivity = definition.findActivity(historicTaskInstance.getTaskDefinitionKey());
            if (currActivity == null) {
                throw new BpmException(BpmExceptionCodeEnum.RUNNING_NODE_NOT_FOUND);
            }
            ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
            if (activityBehavior instanceof MultiInstanceActivityBehavior) {
                this.setRejectAppointAssignee(processInstanceExecution, appointAssignee, Collections.singletonList(historicTaskInstance.getOriginalAssignee()));
            } else {
                List<String> lastAppoint = BpmHistoryTask.getLastAppoint(historicTaskInstance.getProcessInstanceId(), subProcessKey, historicTaskInstance.getTaskDefinitionKey());
                this.setRejectAppointAssignee(processInstanceExecution, appointAssignee, lastAppoint);
            }
        } else {
            this.setRejectAppointAssignee(processInstanceExecution, appointAssignee, Collections.singletonList(historicTaskInstance.getOriginalAssignee()));
        }
        return false;
    }

    private void setRejectAppointAssignee(ExecutionEntity processInstanceExecution, Map<String, List<String>> appointAssignee, List<String> oldAppointAssignee) {
        if (HussarUtils.isNotEmpty(oldAppointAssignee)) {
            if (HussarUtils.isEmpty(appointAssignee)) {
                appointAssignee = new HashMap<String, List<String>>();
            }
            appointAssignee.put("static_appoint_assignee", oldAppointAssignee);
            processInstanceExecution.addTempVariable("appoint_assignee", appointAssignee);
        }
    }

    private void setTargetNode() {
        if (this.taskRejectModel.getTargetIds() == null) {
            String targetNodeId = null;
            if (this.taskRejectModel.getHistoricTaskInstance() != null) {
                targetNodeId = this.taskRejectModel.getHistoricTaskInstance().getTaskDefinitionKey();
            } else if (this.taskRejectModel.getSubProcessFirst()) {
                if (this.taskRejectModel.getTask().getSubProcessKey() != null) {
                    String subProcessNodeId = this.taskRejectModel.getTask().getSubProcessKey().split(":")[0];
                    BpmnModel bpmnModel = this.taskRejectModel.getBm();
                    SubProcess subProcess = (SubProcess)bpmnModel.getFlowElement(subProcessNodeId);
                    for (FlowElement flowElement : subProcess.getFlowElements()) {
                        if (!(flowElement instanceof StartEvent)) continue;
                        targetNodeId = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
                        break;
                    }
                } else {
                    ActivityImpl activity = ((TaskEntity)this.taskRejectModel.getTask()).getExecution().getProcessDefinition().getInitial();
                    targetNodeId = ((PvmTransition)activity.getOutgoingTransitions().get(0)).getDestination().getId();
                }
            } else if (this.taskRejectModel.getFirst()) {
                ActivityImpl activity = ((TaskEntity)this.taskRejectModel.getTask()).getExecution().getProcessDefinition().getInitial();
                targetNodeId = ((PvmTransition)activity.getOutgoingTransitions().get(0)).getDestination().getId();
            } else {
                String allPrevNode = this.taskRejectModel.getTask().getAllPrevNode();
                if (allPrevNode == null) {
                    HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(this.taskRejectModel.getTask().getProcessInstanceId());
                    String completeFrom = historicProcessInstance.getCompleteFrom();
                    if (completeFrom != null) {
                        targetNodeId = String.join((CharSequence)",", () -> Arrays.stream(completeFrom.split(",")).map(str -> "main_process_" + str).iterator());
                    }
                } else {
                    targetNodeId = allPrevNode;
                }
                targetNodeId = this.checkRejectActivityId(this.taskRejectModel.getTask(), targetNodeId, this.taskRejectModel.getTask().getTaskDefinitionKey());
            }
            if (HussarUtils.isNotEmpty((Object)targetNodeId)) {
                if (this.taskRejectModel.getTask() != null && this.taskRejectModel.getTask().getTaskDefinitionKey().equals(targetNodeId)) {
                    throw new BpmException(BpmExceptionCodeEnum.FORBID_REJECT_TO_CURRENT_NODE);
                }
                this.taskRejectModel.setTargetIds(targetNodeId);
            } else {
                throw new BpmException(this.getErrorMessage());
            }
        }
    }

    private boolean canNotRejectPrepare(BpmnModel bm, String startNodeId, String nodeId, boolean isPre) {
        Process process = bm.getMainProcess();
        if (process.getFlowElement(nodeId) != null && process.getFlowElement(startNodeId) == null) {
            for (FlowElement flowElement : process.getFlowElements()) {
                if (!(flowElement instanceof SubProcess)) continue;
                for (FlowElement obj : ((SubProcess)flowElement).getFlowElements()) {
                    if (!obj.getId().equals(startNodeId)) continue;
                    startNodeId = flowElement.getId();
                }
            }
        }
        return !this.canReject(bm, startNodeId, nodeId, null, null, isPre);
    }

    private boolean canReject(BpmnModel bm, String startNodeId, String nodeId, List<String> nodes, List<String> freeJumpList, boolean isPre) {
        FlowElement element = bm.getFlowElement(startNodeId);
        ArrayList<String> newNodes = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(nodes)) {
            newNodes.addAll(nodes);
        }
        if (element instanceof ParallelGateway || element instanceof InclusiveGateway) {
            boolean isFreeJump = freeJumpList != null;
            boolean canFreeJump = true;
            for (SequenceFlow sequenceFlow : isPre ? ((Gateway)element).getIncomingFlows() : ((Gateway)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList == null) continue;
                    freeJumpList.add(nodeId);
                    continue;
                }
                newNodes.add(preNode);
                if (this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                if (isFreeJump) {
                    canFreeJump = false;
                    continue;
                }
                return false;
            }
            return canFreeJump;
        }
        if (!(element instanceof StartEvent) && !(element instanceof EndEvent)) {
            for (SequenceFlow sequenceFlow : isPre ? ((FlowNode)element).getIncomingFlows() : ((FlowNode)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList != null) {
                        freeJumpList.add(nodeId);
                    }
                    return true;
                }
                newNodes.add(preNode);
                if (!this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private void checkTargetNode() {
        BpmnModel bm;
        String targetIds = this.taskRejectModel.getTargetIds();
        if (TaskSourceFlag.isReject((String)this.taskSourceFlag)) {
            String[] canRejectNodes = new ArrayList();
            BpmResponseResult result = this.taskEngineService.queryRejectNode(this.taskRejectModel.getTaskId(), this.taskRejectModel.isCanRejectToMainProcess());
            JSONArray json = result.getResult();
            for (Object object : json) {
                if (!(object instanceof JSONObject)) continue;
                String id = ((JSONObject)object).get((Object)"id").toString();
                canRejectNodes.add(id);
            }
            List<String> targetNodeList = Arrays.asList(targetIds.split(","));
            List collect = targetNodeList.stream().filter(arg_0 -> TaskRejectCmd.lambda$checkTargetNode$7((List)canRejectNodes, arg_0)).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(collect)) {
                throw new BpmException(this.getErrorMessage());
            }
        }
        if (targetIds.contains("main_process_")) {
            if (targetIds.contains(",")) {
                for (String targetNodeId : targetIds.split(",")) {
                    if (targetNodeId.contains("main_process_")) continue;
                    throw new BpmException(this.getErrorMessage());
                }
            }
            ExecutionEntity execution = ((TaskEntity)this.taskRejectModel.getTask()).getProcessInstance().getSuperExecution();
            if ("reject".equals(this.taskSourceFlag)) {
                execution.addTempVariable("taskSourceFlag", (Object)"reject");
            } else if ("freejump".equals(this.taskSourceFlag)) {
                execution.addTempVariable("taskSourceFlag", (Object)"freejump");
            } else {
                throw new UnexpectedException("\u672a\u77e5\u7684\u529e\u7406\u7c7b\u578b\uff01");
            }
            this.taskSourceFlag = BpmAttribute.getTaskSourceFlag((ActivityExecution)execution);
            Map appointAssignee = (Map)BpmAttribute.getExecutionAttribute((TaskEntity)this.taskRejectModel.getTask(), "appoint_assignee");
            if (appointAssignee != null) {
                execution.addTempVariable("appoint_assignee", (Object)appointAssignee);
            }
            this.taskRejectModel.setExecution(execution);
            String procDefId = execution.getProcessDefinitionId();
            bm = this.repositoryService.getBpmnModel(procDefId);
            this.taskRejectModel.setTargetIds(targetIds.replace("main_process_", ""));
            this.taskRejectModel.setBm(bm);
        } else {
            bm = this.taskRejectModel.getBm();
            Process process = bm.getMainProcess();
            boolean isAllMainNode = true;
            boolean isAllSubProcessNode = true;
            for (String targetNodeId : targetIds.split(",")) {
                if (process.getFlowElement(targetNodeId) != null) {
                    isAllSubProcessNode = false;
                } else {
                    isAllMainNode = false;
                }
                if (isAllMainNode || isAllSubProcessNode) continue;
                throw new BpmException(this.getErrorMessage());
            }
            if (isAllMainNode && this.taskRejectModel.getExecution() == null && this.taskRejectModel.getTask() != null && this.taskRejectModel.getTask().getSubProcessKey() != null) {
                if (!this.taskRejectModel.isCanRejectToMainProcess() && (TaskSourceFlag.isReject((String)this.taskSourceFlag) || TaskSourceFlag.isFreeJump((String)this.taskSourceFlag))) {
                    throw new BpmException(this.getErrorMessage());
                }
                ExecutionEntity executionEntity = ((TaskEntity)this.taskRejectModel.getTask()).getExecution();
                while (executionEntity.getSubProcessKey() == null) {
                    executionEntity = executionEntity.getParent();
                }
                this.taskRejectModel.setExecution(executionEntity.getParent());
                String jumpStartId = executionEntity.getSubProcessKey().split(":")[0];
                this.taskRejectModel.setJumpStartId(jumpStartId);
            }
        }
        String firstNodeId = null;
        for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
            if (!(flowElement instanceof StartEvent)) continue;
            firstNodeId = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
            break;
        }
        String processInstanceId = null;
        String subProcessKey = null;
        if (this.taskRejectModel.getHistoricTaskInstance() != null) {
            processInstanceId = this.taskRejectModel.getHistoricTaskInstance().getProcessInstanceId();
            subProcessKey = this.taskRejectModel.getHistoricTaskInstance().getSubProcessKey();
        } else if (this.taskRejectModel.getExecution() != null) {
            processInstanceId = this.taskRejectModel.getExecution().getProcessInstanceId();
            subProcessKey = this.taskRejectModel.getExecution().getSubProcessKey();
        } else if (this.taskRejectModel.getTask() != null) {
            processInstanceId = this.taskRejectModel.getTask().getProcessInstanceId();
            subProcessKey = this.taskRejectModel.getTask().getSubProcessKey();
        }
        String startUserId = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInstanceId).getStartUserId();
        this.taskRejectModel.setProcInsId(processInstanceId);
        this.taskRejectModel.setSubProcessKey(subProcessKey);
        this.taskRejectModel.setFirstNodeId(firstNodeId);
        this.taskRejectModel.setFirst(firstNodeId.equals(this.taskRejectModel.getTargetIds()));
        this.taskRejectModel.setStartUserId(startUserId);
        if (targetIds.contains(",")) {
            if (TaskSourceFlag.isReject((String)this.taskSourceFlag)) {
                String taskSubProcessKey;
                String subProcessNode;
                String taskDefinitionKey = this.taskRejectModel.getExecution() != null && this.taskRejectModel.getExecution().getActivityId() != null ? this.taskRejectModel.getExecution().getActivityId() : this.taskRejectModel.getTask().getTaskDefinitionKey();
                boolean isSubProcessReject = false;
                if (bm.getMainProcess().getFlowElement(taskDefinitionKey) == null) {
                    String targetNode = targetIds.split(",")[0];
                    if (bm.getMainProcess().getFlowElement(targetNode) != null) {
                        isSubProcessReject = true;
                    }
                }
                if (isSubProcessReject ? !this.canRejectToAnyNode(bm, subProcessNode = (taskSubProcessKey = this.taskRejectModel.getExecution() != null ? this.taskRejectModel.getExecution().getSubProcessKey() : this.taskRejectModel.getTask().getSubProcessKey()).split(":")[0], targetIds) : !this.canRejectToAnyNode(bm, taskDefinitionKey, targetIds)) {
                    throw new BpmException(this.getErrorMessage());
                }
            } else if (!this.canRejectToAnyNodePlus(bm, targetIds)) {
                throw new BpmException(this.getErrorMessage());
            }
        } else if (bm.getMainProcess().getFlowElement(targetIds) == null) {
            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                if (!(flowElement instanceof SubProcess) || ((SubProcess)flowElement).getFlowElement(targetIds) == null) continue;
                for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                    if (!(element instanceof SequenceFlow) || !((SequenceFlow)element).getTargetRef().equals(targetIds)) continue;
                    if (((SubProcess)flowElement).getFlowElement(((SequenceFlow)element).getSourceRef()) instanceof StartEvent) {
                        this.taskRejectModel.setSubProcessFirst(true);
                    }
                    return;
                }
                return;
            }
        }
    }

    public boolean canRejectToAnyNode(BpmnModel bm, String taskDefinitionKey, String targetNodeIds) {
        if (!targetNodeIds.contains(",")) {
            return true;
        }
        targetNodeIds = targetNodeIds.replace("main_process_", "");
        Process process = bm.getMainProcess();
        boolean isAllMainNode = true;
        boolean isAllSubProcessNode = true;
        for (String targetNodeId : targetNodeIds.split(",")) {
            if (process.getFlowElement(targetNodeId) != null) {
                isAllSubProcessNode = false;
            } else {
                isAllMainNode = false;
            }
            if (isAllMainNode || isAllSubProcessNode) continue;
            return false;
        }
        FlowNode userTask = (FlowNode)bm.getFlowElement(taskDefinitionKey);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(taskDefinitionKey);
        ArrayList<List<String>> lists = new ArrayList<List<String>>();
        this.getAllHisNodeList(bm, userTask.getIncomingFlows(), ids, lists);
        ArrayList<String> targetNodes = new ArrayList<String>(Arrays.asList(targetNodeIds.split(",")));
        for (List list : lists) {
            boolean listContain = false;
            for (String targetNode : targetNodes) {
                if (!list.contains(targetNode)) continue;
                if (listContain) {
                    return false;
                }
                listContain = true;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean canRejectToAnyNodePlus(BpmnModel bm, String targetNodeIds) {
        void var9_16;
        if (!targetNodeIds.contains(",")) {
            return true;
        }
        Process process = bm.getMainProcess();
        boolean isAllMainNode = true;
        boolean isAllSubProcessNode = true;
        for (String string : targetNodeIds.split(",")) {
            if (process.getFlowElement(string) != null) {
                isAllSubProcessNode = false;
            } else {
                isAllMainNode = false;
            }
            if (isAllMainNode || isAllSubProcessNode) continue;
            return false;
        }
        ArrayList<String> targetNodes = new ArrayList<String>(Arrays.asList(targetNodeIds.split(",")));
        ArrayList<Object> targetNodePathList = new ArrayList<Object>();
        for (String string : targetNodes) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(string);
            ArrayList lists = new ArrayList();
            FlowNode userTask = (FlowNode)bm.getFlowElement(string);
            this.getAllHisNodeList(bm, userTask.getIncomingFlows(), ids, lists);
            targetNodePathList.add(lists);
        }
        ArrayList<String> canRejectNodeIds = new ArrayList<String>();
        for (FlowElement flowElement : process.getFlowElements()) {
            if (flowElement instanceof Gateway && !(flowElement instanceof ExclusiveGateway)) {
                canRejectNodeIds.add(flowElement.getId());
                continue;
            }
            if (!(flowElement instanceof SubProcess)) continue;
            for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                if (!(element instanceof Gateway) || element instanceof ExclusiveGateway) continue;
                canRejectNodeIds.add(element.getId());
            }
        }
        boolean bl = false;
        while (var9_16 < targetNodePathList.size()) {
            for (void j = var9_16 + true; j < targetNodePathList.size(); ++j) {
                List nodePathList1 = (List)targetNodePathList.get((int)var9_16);
                List nodePathList2 = (List)targetNodePathList.get((int)j);
                for (List path1 : nodePathList1) {
                    block7: for (List path2 : nodePathList2) {
                        for (String node : path1) {
                            if (!path2.contains(node)) continue;
                            if (canRejectNodeIds.contains(node)) continue block7;
                            return false;
                        }
                    }
                }
            }
            ++var9_16;
        }
        return true;
    }

    private void getAllHisNodeList(BpmnModel bm, List<SequenceFlow> incomingFlows, List<String> goneNode, List<List<String>> allHisNode) {
        for (SequenceFlow sequenceFlow : incomingFlows) {
            FlowElement flowElement = bm.getFlowElement(sequenceFlow.getSourceRef());
            ArrayList<String> goneNodeSave = new ArrayList<String>(goneNode);
            if (flowElement instanceof StartEvent) {
                allHisNode.add(goneNodeSave);
            }
            if (goneNode.contains(flowElement.getId())) continue;
            goneNodeSave.add(flowElement.getId());
            this.getAllHisNodeList(bm, ((FlowNode)flowElement).getIncomingFlows(), goneNodeSave, allHisNode);
        }
    }

    private String checkRejectActivityId(Task task, String backActivityId, String rejectActivityId) {
        if (HussarUtils.isEmpty((Object)backActivityId)) {
            throw new BpmException(this.getErrorMessage());
        }
        if (!backActivityId.contains(",")) {
            return backActivityId;
        }
        HashSet<String> backActivityIdSet = new HashSet<String>(Arrays.asList(backActivityId.split(",")));
        if (backActivityIdSet.size() == 1) {
            return (String)backActivityIdSet.iterator().next();
        }
        if (HussarUtils.isEmpty((Object)rejectActivityId)) {
            rejectActivityId = task.getTaskDefinitionKey();
        }
        if (this.canRejectToAnyNode(this.taskRejectModel.getBm(), rejectActivityId, String.join((CharSequence)",", backActivityIdSet))) {
            return String.join((CharSequence)",", backActivityIdSet);
        }
        FlowNode flowNode = (FlowNode)this.taskRejectModel.getBm().getFlowElement(rejectActivityId);
        if ((flowNode = this.getGateway(flowNode, this.taskRejectModel.getBm())) == null) {
            throw new BpmException(this.getErrorMessage());
        }
        HashSet<String> nodeIdSet = new HashSet<String>();
        this.getAllFlowNodeFromPerGateWay(flowNode, this.taskRejectModel.getBm(), nodeIdSet);
        backActivityIdSet.retainAll(nodeIdSet);
        if (backActivityIdSet.isEmpty()) {
            throw new BpmException(BpmExceptionCodeEnum.FORBID_REJECT);
        }
        if (this.canRejectToAnyNode(this.taskRejectModel.getBm(), rejectActivityId, String.join((CharSequence)",", backActivityIdSet))) {
            return String.join((CharSequence)",", backActivityIdSet);
        }
        throw new BpmException(this.getErrorMessage());
    }

    private FlowNode getGateway(FlowNode node, BpmnModel bm) {
        for (SequenceFlow flow : node.getIncomingFlows()) {
            FlowNode flowNode = (FlowNode)bm.getFlowElement(flow.getSourceRef());
            if (flowNode instanceof ParallelGateway || flowNode instanceof InclusiveGateway) {
                return flowNode;
            }
            if ((flowNode = this.getGateway(flowNode, bm)) == null) continue;
            return flowNode;
        }
        return null;
    }

    private void getAllFlowNodeFromPerGateWay(FlowNode node, BpmnModel bm, Set<String> nodeIdSet) {
        for (SequenceFlow flow : node.getIncomingFlows()) {
            FlowNode flowNode = (FlowNode)bm.getFlowElement(flow.getSourceRef());
            if (flowNode instanceof ParallelGateway || flowNode instanceof InclusiveGateway || flowNode instanceof StartEvent) continue;
            nodeIdSet.add(flowNode.getId());
            this.getAllFlowNodeFromPerGateWay(flowNode, bm, nodeIdSet);
        }
    }

    private void taskAssigneeHandle(CommandContext commandContext) {
        String processInstanceId = this.taskRejectModel.getProcInsId();
        String subProcessKey = this.taskRejectModel.getSubProcessKey();
        HashMap map = this.taskRejectModel.getMap();
        if (map == null) {
            map = new HashMap();
        }
        ExecutionEntity processInstance = commandContext.getExecutionEntityManager().findExecutionById(processInstanceId);
        String assignees = null;
        if (HussarUtils.isNotEmpty((Object)this.taskRejectModel.getAssignees())) {
            assignees = this.taskRejectModel.getAssignees();
        }
        HashMap<String, String> assigneeMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)this.taskRejectModel.getAssigneeMap())) {
            assigneeMap = this.taskRejectModel.getAssigneeMap();
        }
        HashMap<String, List<String>> groupCountersignAppointAssignee = new HashMap();
        if (HussarUtils.isNotEmpty((Object)this.taskRejectModel.getGroupCountersignAppointAssignee())) {
            groupCountersignAppointAssignee = this.taskRejectModel.getGroupCountersignAppointAssignee();
        }
        Map<String, List<String>> appointAssigneeMap = this.getAppointAssignee(assignees, assigneeMap, groupCountersignAppointAssignee);
        for (String targetNodeId : this.taskRejectModel.getTargetIds().split(",")) {
            List<String> lastAppoint;
            if (!HussarUtils.isEmpty(appointAssigneeMap.get(targetNodeId)) || !HussarUtils.isEmpty(appointAssigneeMap.get("static_appoint_assignee")) || this.taskRejectModel.isDefaultAssignee()) continue;
            boolean flag = false;
            if (this.taskRejectModel.isSubmit()) {
                List<String> assignee;
                String subProcessKeyCondition = subProcessKey;
                Process process = this.taskRejectModel.getBm().getMainProcess();
                if (process.getFlowElement(targetNodeId) != null) {
                    subProcessKeyCondition = null;
                }
                if (HussarUtils.isNotEmpty(assignee = this.getTaskCommitUser(processInstanceId, targetNodeId, subProcessKeyCondition))) {
                    appointAssigneeMap.put(targetNodeId, assignee);
                    flag = true;
                }
            }
            if (flag || !HussarUtils.isNotEmpty(lastAppoint = BpmHistoryTask.getLastAppoint(processInstanceId, subProcessKey, targetNodeId))) continue;
            appointAssigneeMap.put(targetNodeId, lastAppoint);
        }
        processInstance.addTempVariable("appoint_assignee", appointAssigneeMap);
        this.taskRejectModel.setMap(map);
    }

    private List<String> getTaskCommitUser(String processInsId, String backActivityId, String subProcessKey) {
        List<HistoricTaskInstance> hisTaskList;
        HashSet assignees = new HashSet();
        if (backActivityId.startsWith("main_process_")) {
            backActivityId = backActivityId.substring("main_process_".length());
        }
        if ((hisTaskList = BpmHistoryTask.findAllEndTask(processInsId, subProcessKey, backActivityId)) != null && !hisTaskList.isEmpty()) {
            CommonCodeUtil.getLastCompleted(hisTaskList, assignees);
            if (assignees.isEmpty()) {
                return BpmHistoryTask.getLastAppoint(processInsId, subProcessKey, backActivityId);
            }
        } else {
            return BpmHistoryTask.getLastAppoint(processInsId, subProcessKey, backActivityId);
        }
        return new ArrayList<String>(assignees);
    }

    private void subProcessReStartHandle(CommandContext commandContext) {
        if (this.taskRejectModel.isSubmit()) {
            ArrayList<String> targetIds = new ArrayList<String>(Arrays.asList(this.taskRejectModel.getTargetIds().split(",")));
            HashMap<String, String> subProcessRejectAppointMsg = new HashMap<String, String>();
            List<HistoricActivityInstance> list = BpmHistoryActivity.getActivityByType(this.taskRejectModel.getProcInsId(), "startEvent");
            HashMap<String, Integer> subProcessKeyMap = new HashMap<String, Integer>();
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (historicActivityInstance.getSubProcessKey() == null) continue;
                subProcessKeyMap.put(historicActivityInstance.getSubProcessKey(), historicActivityInstance.getCycleCount());
            }
            for (String targetId : targetIds) {
                if (!(this.taskRejectModel.getBm().getFlowElement(targetId) instanceof SubProcess)) continue;
                int cycleCount = 0;
                ArrayList<String> subProcessVariableList = new ArrayList<String>();
                for (String subProcessKey : subProcessKeyMap.keySet()) {
                    if (!subProcessKey.startsWith(targetId + ":")) continue;
                    if (cycleCount < (Integer)subProcessKeyMap.get(subProcessKey)) {
                        subProcessVariableList = new ArrayList();
                        cycleCount = (Integer)subProcessKeyMap.get(subProcessKey);
                    }
                    subProcessVariableList.add(subProcessKey.split(":")[1]);
                }
                subProcessRejectAppointMsg.put(targetId, String.join((CharSequence)",", subProcessVariableList));
            }
            commandContext.addAttribute("subProcessRejectAppointMsg", subProcessRejectAppointMsg);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void rejectTypeHandle() {
        String subProcessKey;
        String taskDefinitionKey;
        String processInstanceId;
        Set<Object> affectedTasks = new HashSet<String>();
        Set<Object> affectedUserTasks = new HashSet<String>();
        int newNum = 1;
        ArrayList<String> taskIds = new ArrayList<String>();
        HashSet<String> runningActivityNodeIds = new HashSet<String>();
        if (this.taskRejectModel.getExecution() != null) {
            processInstanceId = this.taskRejectModel.getExecution().getProcessInstanceId();
            taskDefinitionKey = this.taskRejectModel.getExecution().getActivityId();
            if (taskDefinitionKey == null) {
                taskDefinitionKey = ((ExecutionEntity)this.taskRejectModel.getExecution().getExecutions().get(0)).getActivityId();
            }
            if (this.taskRejectModel.getJumpStartId() != null) {
                taskDefinitionKey = this.taskRejectModel.getJumpStartId();
            }
            subProcessKey = this.taskRejectModel.getExecution().getSubProcessKey();
        } else {
            processInstanceId = this.taskRejectModel.getTask().getProcessInstanceId();
            taskDefinitionKey = this.taskRejectModel.getTask().getTaskDefinitionKey();
            subProcessKey = this.taskRejectModel.getTask().getSubProcessKey();
        }
        BpmnModel bm = this.taskRejectModel.getBm();
        List<HistoricActivityInstance> list = BpmHistoryActivity.getRunningActivityByType(processInstanceId, "callActivity");
        for (HistoricActivityInstance historicActivityInstance : list) {
            runningActivityNodeIds.add(historicActivityInstance.getActivityId());
        }
        HashSet<String> runningSubProcessNodeIds = new HashSet<String>();
        list = BpmHistoryActivity.getRunningActivityByType(processInstanceId, "subProcess");
        for (HistoricActivityInstance historicActivityInstance : list) {
            runningSubProcessNodeIds.add(historicActivityInstance.getActivityId());
        }
        List list2 = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        for (Object execution1 : list2) {
            if (((ExecutionEntity)execution1).getExecutions().size() != 0 || execution1.getActivityId() == null || execution1.getSubProcessKey() != null && !Objects.equals(subProcessKey, execution1.getSubProcessKey())) continue;
            taskIds.add(execution1.getActivityId());
        }
        taskIds.addAll(runningActivityNodeIds);
        taskIds.addAll(runningSubProcessNodeIds);
        taskIds = new ArrayList(new HashSet(taskIds));
        if (taskIds.size() > 1) {
            Process process = (Process)bm.getProcesses().get(0);
            if (this.taskRejectModel.getFirst()) {
                newNum = 3;
                for (FlowElement flowElement : process.getFlowElements()) {
                    if (taskIds.contains(flowElement.getId())) {
                        if (flowElement instanceof UserTask) {
                            affectedUserTasks.add(flowElement.getId());
                        }
                        affectedTasks.add(flowElement.getId());
                        continue;
                    }
                    if (!(flowElement instanceof SubProcess)) continue;
                    for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                        if (!taskIds.contains(element.getId())) continue;
                        if (element instanceof UserTask) {
                            affectedUserTasks.add(element.getId());
                        }
                        affectedTasks.add(element.getId());
                    }
                }
            } else {
                if (this.taskRejectModel.getTargetIds().contains(",")) {
                    for (String targetNodeId : this.taskRejectModel.getTargetIds().split(",")) {
                        if (!HussarUtils.isEmpty((Object)bm.getFlowElement(targetNodeId))) continue;
                        throw new BpmException(BpmExceptionCodeEnum.NODE_NOT_FOUND);
                    }
                } else if (HussarUtils.isEmpty((Object)bm.getFlowElement(this.taskRejectModel.getTargetIds()))) {
                    throw new BpmException(BpmExceptionCodeEnum.NODE_NOT_FOUND);
                }
                boolean isFindTask = false;
                if (this.taskRejectModel.getTargetIds().contains(",")) {
                    for (String string : this.taskRejectModel.getTargetIds().split(",")) {
                        Map<String, Set<String>> map = this.findAffectedTask(bm, string, true, taskIds);
                        affectedTasks.addAll((Collection<Object>)map.get("affectedTasks"));
                        affectedUserTasks.addAll((Collection<Object>)map.get("affectedUserTasks"));
                    }
                } else {
                    Map<String, Set<String>> map = this.findAffectedTask(bm, this.taskRejectModel.getTargetIds(), true, taskIds);
                    affectedTasks = map.get("affectedTasks");
                    affectedUserTasks = map.get("affectedUserTasks");
                }
                if (affectedTasks.contains(taskDefinitionKey)) {
                    isFindTask = true;
                    affectedTasks.remove(taskDefinitionKey);
                }
                if (!affectedTasks.isEmpty()) {
                    newNum = 3;
                }
                if (!isFindTask) {
                    void var15_30;
                    HashSet hashSet = new HashSet();
                    if (!affectedTasks.isEmpty()) {
                        Set<Object> set = affectedTasks;
                    }
                    if (this.taskRejectModel.getTargetIds().contains(",")) {
                        void var18_51;
                        String[] stringArray = this.taskRejectModel.getTargetIds().split(",");
                        int targetNodeId = stringArray.length;
                        boolean bl = false;
                        while (var18_51 < targetNodeId) {
                            String targetNodeId2 = stringArray[var18_51];
                            Map<String, Set<String>> map = this.findAffectedTask(bm, targetNodeId2, false, taskIds);
                            affectedTasks.addAll((Collection<Object>)map.get("affectedTasks"));
                            affectedUserTasks.addAll((Collection<Object>)map.get("affectedUserTasks"));
                            ++var18_51;
                        }
                    } else {
                        Map<String, Set<String>> map = this.findAffectedTask(bm, this.taskRejectModel.getTargetIds(), false, taskIds);
                        affectedTasks = map.get("affectedTasks");
                        affectedUserTasks = map.get("affectedUserTasks");
                    }
                    if (affectedTasks.contains(taskDefinitionKey)) {
                        isFindTask = true;
                        affectedTasks.remove(taskDefinitionKey);
                    }
                    if (!affectedTasks.isEmpty()) {
                        newNum = 3;
                    }
                    if (!isFindTask && affectedTasks.size() + var15_30.size() > 0) {
                        throw new BpmException(BpmExceptionCodeEnum.FREE_JUMP_CANNOT_TO_ANOTHER_BRANCH);
                    }
                }
            }
        } else {
            affectedTasks = new HashSet(taskIds);
        }
        if (this.taskRejectModel.getJumpStartId() != null) {
            newNum = 3;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : runningActivityNodeIds) {
            if (!affectedTasks.contains(string)) continue;
            hashSet.add(string);
        }
        HashSet<String> affectedSubProcess = new HashSet<String>();
        for (String activityId : runningSubProcessNodeIds) {
            if (!affectedTasks.contains(activityId)) continue;
            affectedSubProcess.add(activityId);
        }
        affectedUserTasks.addAll(hashSet);
        affectedUserTasks.addAll(affectedSubProcess);
        ArrayList<ExecutionInfo> arrayList = new ArrayList<ExecutionInfo>();
        for (Execution execution : list2) {
            if (((ExecutionEntity)execution).isScope() || execution.getActivityId() == null || affectedUserTasks.contains(execution.getActivityId()) || !affectedTasks.contains(execution.getActivityId())) continue;
            arrayList.add(new ExecutionInfo().setTaskDefKey(execution.getActivityId()).setAllPrevNode(((ExecutionEntity)execution).getAllPrevNode()).setVariable(this.runtimeService.getVariablesLocal(execution.getId())));
        }
        affectedTasks.add(taskDefinitionKey);
        affectedUserTasks.remove(taskDefinitionKey);
        if (newNum == 1) {
            ActivityBehavior activityBehavior;
            ExecutionEntity executionEntity = this.taskRejectModel.getExecution();
            if (executionEntity == null) {
                executionEntity = ((TaskEntity)this.taskRejectModel.getTask()).getExecution();
            }
            if (executionEntity.getActivity() == null) {
                void var18_53;
                ExecutionEntity executionEntity2 = executionEntity;
                while (var18_53.getActivity() == null && var18_53.getExecutions() != null) {
                    ExecutionEntity executionEntity3 = (ExecutionEntity)var18_53.getExecutions().get(0);
                }
                activityBehavior = var18_53.getActivity().getActivityBehavior();
            } else {
                activityBehavior = executionEntity.getActivity().getActivityBehavior();
            }
            if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
                newNum = 2;
            }
        }
        JumpModel jumpModel = new JumpModel(newNum);
        if (newNum != 3) {
            jumpModel.setJumpFrom(Collections.singletonList(taskDefinitionKey));
            for (String string : affectedTasks) {
                if (!runningActivityNodeIds.contains(string) && !runningSubProcessNodeIds.contains(string)) continue;
                jumpModel.setAffectedTasks(affectedTasks).setRunningSubProcessNodeIds(runningSubProcessNodeIds).setRunningActivityNodeIds(runningActivityNodeIds);
                break;
            }
        }
        if (newNum == 3) {
            ArrayList<Object> rejectFrom = new ArrayList<Object>();
            rejectFrom.add(taskDefinitionKey);
            rejectFrom.addAll(affectedUserTasks);
            jumpModel.setAffectedTasks(affectedTasks).setJumpFrom(rejectFrom).setJumpFromExecution(arrayList).setRunningSubProcessNodeIds(runningSubProcessNodeIds).setRunningActivityNodeIds(runningActivityNodeIds);
            if (TaskSourceFlag.isFreeJump((String)this.taskSourceFlag)) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>(affectedTasks);
                for (String string : affectedSubProcess) {
                    SubProcess subProcess = (SubProcess)bm.getMainProcess().getFlowElement(string);
                    for (FlowElement flowElement : subProcess.getFlowElements()) {
                        if (!(flowElement instanceof UserTask)) continue;
                        arrayList2.add(flowElement.getId());
                    }
                }
                String procInsId = this.taskRejectModel.getTask().getProcessInstanceId();
                if (procInsId.equals(this.taskRejectModel.getProcInsId())) {
                    HashSet<Object> hashSet2 = new HashSet<Object>(arrayList2);
                    String affectedTaskIds = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(this.taskRejectModel.getTask().getProcessInstanceId())).list().stream().filter(o -> hashSet2.contains(o.getTaskDefinitionKey())).map(TaskInfo::getId).collect(Collectors.joining(","));
                    this.taskRejectModel.setAllAffectedTaskIds(affectedTaskIds);
                }
            }
        }
        jumpModel.setJumpTo(Arrays.asList(this.taskRejectModel.getTargetIds().split(",")));
        if (this.taskRejectModel.getJumpToExecution() != null) {
            jumpModel.setJumpToExecution(this.taskRejectModel.getJumpToExecution());
        }
        this.taskRejectModel.setJumpModel(jumpModel);
    }

    private Map<String, Set<String>> findAffectedTask(BpmnModel bm, String nodeId, boolean isGoToNext, List<String> taskIds) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        HashSet<String> affectedTasks = new HashSet<String>();
        HashSet<String> affectedUserTasks = new HashSet<String>();
        flowElements.add(bm.getFlowElement(nodeId));
        HashSet<FlowElement> list = new HashSet<FlowElement>();
        for (int i = 0; i < flowElements.size(); ++i) {
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            if (!list.add(flowElement)) continue;
            if (taskIds.contains(flowElement.getId())) {
                affectedTasks.add(flowElement.getId());
                if (flowElement instanceof UserTask) {
                    affectedUserTasks.add(flowElement.getId());
                    continue;
                }
            }
            if (flowElement instanceof EndEvent || flowElement instanceof StartEvent || !(flowElement instanceof FlowNode)) continue;
            if (isGoToNext) {
                for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getOutgoingFlows()) {
                    flowElements.add(bm.getFlowElement(sequenceFlow.getTargetRef()));
                }
                continue;
            }
            for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getIncomingFlows()) {
                flowElements.add(bm.getFlowElement(sequenceFlow.getSourceRef()));
            }
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("affectedTasks", affectedTasks);
        map.put("affectedUserTasks", affectedUserTasks);
        return map;
    }

    private void rejectCallActivityHandle(CommandContext commandContext) {
        String processInsId = null;
        processInsId = this.taskRejectModel.getExecution() != null ? this.taskRejectModel.getExecution().getProcessInstanceId() : this.taskRejectModel.getTask().getProcessInstanceId();
        Collection nodeIds = this.taskRejectModel.getJumpModel().getAffectedTasks();
        if (HussarUtils.isNotEmpty((Object)nodeIds)) {
            Collection callActivitiNodeIds = this.taskRejectModel.getJumpModel().getRunningActivityNodeIds();
            ArrayList<Object> ids = new ArrayList<Object>();
            if (HussarUtils.isNotEmpty((Object)callActivitiNodeIds)) {
                for (Object nodeId : nodeIds) {
                    if (!callActivitiNodeIds.remove(nodeId)) continue;
                    ids.add(nodeId);
                }
            }
            if (HussarUtils.isNotEmpty(ids)) {
                List<HistoricActivityInstance> list = BpmHistoryActivity.getRunningActivityByType(processInsId, "callActivity");
                for (HistoricActivityInstance historicActivityInstance : list) {
                    if (!ids.contains(historicActivityInstance.getActivityId())) continue;
                    TaskEngineServiceImpl.getCallRejectList().add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
                    HistoricProcessInstanceEntity historicProcessInstance = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(historicActivityInstance.getProcessInstanceId());
                    String processDefinitionId = historicActivityInstance.getProcessDefinitionId();
                    String businessId = historicProcessInstance.getBusinessKey();
                    new ProcessEndCmd(this.taskRejectModel.getTaskId(), this.taskRejectModel.getUserId(), this.taskRejectModel.getMandator(), this.taskRejectModel.getComment(), historicActivityInstance.getCalledProcessInstanceId(), businessId, processDefinitionId, this.taskSourceFlag, false).addExecutionAttribute(this.taskSourceFlag, false).execute(commandContext);
                    TaskEngineServiceImpl.getCallRejectList().remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
                }
            }
            Collection subProcessNodeIds = this.taskRejectModel.getJumpModel().getRunningSubProcessNodeIds();
            ids = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)subProcessNodeIds)) {
                for (String nodeId : nodeIds) {
                    if (!subProcessNodeIds.remove(nodeId)) continue;
                    ids.add(nodeId);
                }
            }
            if (HussarUtils.isNotEmpty(ids)) {
                List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInsId).list();
                executions.removeIf(e -> e.getSubProcessKey() == null);
                for (Execution execution : executions) {
                    String subProcessKey = execution.getSubProcessKey();
                    String nodeId = subProcessKey.split(":")[0];
                    if (!ids.contains(nodeId)) continue;
                    TaskEngineServiceImpl.getSubProcessRejectList().add(processInsId + nodeId);
                    new SubProcessEndCmd(this.taskRejectModel.getTaskId(), this.taskRejectModel.getBm(), this.taskRejectModel.getUserId(), this.taskRejectModel.getMandator(), this.taskRejectModel.getComment(), processInsId, subProcessKey, this.taskSourceFlag).execute(commandContext);
                    TaskEngineServiceImpl.getSubProcessRejectList().remove(processInsId + nodeId);
                }
            }
        }
    }

    private void rejectNodeSendUserHandle(CommandContext commandContext) {
        if (TaskSourceFlag.isFreeJump((String)this.taskSourceFlag)) {
            commandContext.addAttribute("sendUser", (Object)(HussarUtils.isEmpty((Object)this.taskRejectModel.getMandator()) ? this.taskRejectModel.getUserId() : this.taskRejectModel.getMandator()));
        } else {
            boolean isInnerSubProcess = this.taskRejectModel.getBm().getMainProcess().getFlowElement(this.taskRejectModel.getTargetIds().split(",")[0]) == null;
            ArrayList<String> targetIds = new ArrayList<String>(Arrays.asList(this.taskRejectModel.getTargetIds().split(",")));
            HashMap completeFromSendUserMap = new HashMap();
            HashMap targetNodeMap = new HashMap();
            ArrayList completeFromIds = new ArrayList();
            HashMap<String, String> sendUserMap = new HashMap<String, String>();
            List list = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(this.taskRejectModel.getProcInsId()).list();
            for (String targetId : targetIds) {
                FlowElement flowElement = this.taskRejectModel.getBm().getFlowElement(targetId);
                if (flowElement instanceof SubProcess) {
                    ((SubProcess)flowElement).getFlowElements().stream().filter(element -> element instanceof StartEvent).findFirst().ifPresent(element -> {
                        String target = ((SequenceFlow)((StartEvent)element).getOutgoingFlows().get(0)).getTargetRef();
                        BpmHistoryTask.findAllTask(this.taskRejectModel.getProcInsId()).stream().filter(task -> Objects.equals(task.getTaskDefinitionKey(), target) && (TaskSourceFlag.NORMAL_COMPLETE.contains(task.getCompleteType()) || "skip".equals(task.getCompleteType()))).reduce((task1, task2) -> {
                            int t2Cycle;
                            int t1Cycle = task1.getCycleCount() == null ? -1 : task1.getCycleCount();
                            int n = t2Cycle = task2.getCycleCount() == null ? -1 : task2.getCycleCount();
                            if (t1Cycle > t2Cycle) {
                                return task1;
                            }
                            if (t1Cycle < t2Cycle) {
                                return task2;
                            }
                            return task1.getCreateTime().before(task2.getCreateTime()) ? task1 : task2;
                        }).ifPresent(historicTaskInstance -> sendUserMap.put(targetId, historicTaskInstance.getSendUser()));
                    });
                    continue;
                }
                if (flowElement instanceof CallActivity) {
                    list.stream().filter(processInstance -> targetId.equals(processInstance.getMainActId())).findFirst().ifPresent(historicProcessInstance -> sendUserMap.put(targetId, historicProcessInstance.getStartUserId()));
                    continue;
                }
                HistoricTaskInstance lastComplete = BpmHistoryTask.getLastComplete(this.taskRejectModel.getProcInsId(), isInnerSubProcess ? this.taskRejectModel.getSubProcessKey() : null, targetId);
                if (lastComplete == null) continue;
                sendUserMap.put(targetId, lastComplete.getSendUser());
            }
            commandContext.addAttribute("sendUserMap", sendUserMap);
        }
    }

    private Map<String, List<String>> getAppointAssignee(String assignee, Map<String, String> appointAssignee, Map<String, List<String>> groupCountersignAppointAssignee) {
        HashMap<String, List<String>> assigneeMap = new HashMap<String, List<String>>();
        if (HussarUtils.isNotEmpty((Object)assignee)) {
            List<String> assigneeList = Arrays.asList(assignee.split(","));
            assigneeMap.put("static_appoint_assignee", assigneeList);
        }
        if (HussarUtils.isNotEmpty(appointAssignee)) {
            for (String key : appointAssignee.keySet()) {
                if (!HussarUtils.isNotEmpty((Object)appointAssignee.get(key))) continue;
                List<String> assigneeList = Arrays.asList(appointAssignee.get(key).split(","));
                assigneeMap.put(key, assigneeList);
            }
        }
        if (HussarUtils.isNotEmpty(groupCountersignAppointAssignee)) {
            for (String key : groupCountersignAppointAssignee.keySet()) {
                List<String> userIds = groupCountersignAppointAssignee.get(key);
                if (!HussarUtils.isNotEmpty(userIds)) continue;
                assigneeMap.put(key, userIds);
            }
        }
        return assigneeMap;
    }

    private static /* synthetic */ boolean lambda$checkTargetNode$7(List canRejectNodes, String rejectNode) {
        return !canRejectNodes.contains(rejectNode);
    }

    private static /* synthetic */ boolean lambda$revokeHandle$3(HistoricTaskInstance historicTaskInstance, HistoricProcessInstance processInstance) {
        return processInstance.getCompleteFrom() == null || !Arrays.asList(processInstance.getCompleteFrom().split(",")).contains(historicTaskInstance.getTaskDefinitionKey());
    }

    private static /* synthetic */ boolean lambda$revokeHandle$2(HistoricTaskInstance historicTaskInstance, HistoricProcessInstance processInstance) {
        return processInstance.getEndTime() != null || !"main_reject".equals(processInstance.getCompleteType()) || !JumpInfo.toJumpInfo((String)processInstance.getJumpInfo()).getJumpFrom().contains(historicTaskInstance.getTaskDefinitionKey());
    }

    private static /* synthetic */ boolean lambda$revokeHandle$1(HistoricTaskInstance historicTaskInstance, Execution execution) {
        ExecutionEntity entity = (ExecutionEntity)execution;
        if (entity.getAllPrevNode() == null) {
            return true;
        }
        return !Arrays.asList(entity.getAllPrevNode().split(",")).contains(historicTaskInstance.getTaskDefinitionKey());
    }

    static {
        FORBID_REVOKE_TASK_SOURCE_FLAG.add("revoke");
        FORBID_REVOKE_TASK_SOURCE_FLAG.add("reject_revoke");
        FORBID_REVOKE_TASK_SOURCE_FLAG.add("assist_complete");
        FORBID_REVOKE_TASK_SOURCE_FLAG.add("complete_leap");
        FORBID_REVOKE_TASK_SOURCE_FLAG.add("ccTask");
        FORBID_REVOKE_TASK_TYPE.add("2");
        FORBID_REVOKE_TASK_TYPE.add("3");
        FORBID_REVOKE_TASK_TYPE.add("4");
    }
}

