/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActGeBytearrayMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActGeBytearray;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowOrganProcessUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.CallActivityElement;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExeListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExtendActivitiListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExtendFieldExtension;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExtendTaskListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequenceXy;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowTodoCondition;
import com.jxdinfo.hussar.workflow.engine.flowmodel.OriginalTaskListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.TimeOutStrategy;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.Bpm2XMLMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.service.Bpm2XMLService;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormObjectVisitorBeanUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.SubProcessVisitor;
import com.jxdinfo.hussar.workflow.manage.bpm.flowchart.FlowChartProcessInfoDto;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.util.ActivitiTranslateUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.util.XmlUtil;
import org.activiti.validation.ProcessValidator;
import org.activiti.validation.ProcessValidatorFactory;
import org.activiti.validation.ValidationError;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@HussarTokenDs
@Service
public class Bpm2XMLServiceImpl
implements Bpm2XMLService {
    private static final Logger logger = LoggerFactory.getLogger(Bpm2XMLServiceImpl.class);
    private BpmActGeBytearrayMapper bpmActGeBytearrayMapper;
    private Bpm2XMLMapper bpm2XMLMapper;
    private final RepositoryService repositoryService;
    private SysActProcessFileService sysActProcessFileService;
    private SysActProcessFileMapper sysActProcessFileMapper;
    private SysActAssigneeService sysActAssigneeService;
    private HistoryService historyService;
    private ProcessEngine processEngine = (ProcessEngine)BpmSpringContextHolder.getSpringContext().getBean(ProcessEngine.class);
    private static final String COMPLETE_STATE = "finish";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;

    @Autowired
    public Bpm2XMLServiceImpl(BpmActGeBytearrayMapper bpmActGeBytearrayMapper, Bpm2XMLMapper bpm2XMLMapper, RepositoryService repositoryService, SysActProcessFileService sysActProcessFileService, SysActProcessFileMapper sysActProcessFileMapper, SysActAssigneeService sysActAssigneeService, HistoryService historyService) {
        this.bpmActGeBytearrayMapper = bpmActGeBytearrayMapper;
        this.bpm2XMLMapper = bpm2XMLMapper;
        this.repositoryService = repositoryService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.sysActProcessFileMapper = sysActProcessFileMapper;
        this.sysActAssigneeService = sysActAssigneeService;
        this.historyService = historyService;
    }

    public Long formDataToXml(WorkFlow workFlow, boolean appointVersion) throws BpmException, IOException, XMLStreamException {
        FlowModel flowModel = this.readModel(workFlow);
        return this.genXMLByFlowModel(flowModel, workFlow, appointVersion);
    }

    public Long formDataToXml(WorkFlow workFlow) throws BpmException, IOException, XMLStreamException {
        return this.genXMLByFlowModel(workFlow);
    }

    public BpmnModel newFormDataToXml(WorkFlow workFlow, boolean isPublish) throws BpmException, IOException, XMLStreamException {
        Model modelData;
        FlowModel flowModel = (FlowModel)JSONObject.parseObject((String)workFlow.getData(), FlowModel.class);
        if (flowModel == null) {
            return null;
        }
        String identityKey = workFlow.getIdentity();
        BpmnModel bpmnModel = this.newGetXmlByFlowModel(flowModel, identityKey, workFlow, true, isPublish);
        String processNameTranslateKey = ActivitiTranslateUtil.getTranslateKey((Map)bpmnModel.getMainProcess().getExtensionElements(), (String)"processNameTranslateId");
        boolean isLowCode = false;
        this.saveAssignee(flowModel, workFlow, bpmnModel, isLowCode, isPublish);
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", workFlow.getName());
        modelObjectNode.put("description", flowModel.getProps().getDesc());
        if (HussarUtils.isEmpty((Object)workFlow.getModelId())) {
            modelData = this.newModel(modelObjectNode, workFlow.getName(), identityKey, workFlow.getAppId(), workFlow.getAppName(), workFlow.getAppCode(), workFlow.getWorkflowStyle(), processNameTranslateKey);
            workFlow.setModelId(Long.valueOf(Long.parseLong(modelData.getId())));
        } else {
            modelData = this.updateModel(modelObjectNode, workFlow.getName(), workFlow.getModelId(), workFlow.getAppId(), workFlow.getAppName(), workFlow.getAppCode(), workFlow.getWorkflowStyle(), processNameTranslateKey);
        }
        ExtendBpmnJsonConverter child = new ExtendBpmnJsonConverter();
        child.updateConvertersToBpmnMap();
        child.updateConvertersToJsonMap();
        ObjectNode editorNode = child.convertToJson(bpmnModel);
        this.repositoryService.addModelEditorSource(modelData.getId(), editorNode.toString().getBytes(StandardCharsets.UTF_8));
        return bpmnModel;
    }

    private BpmnModel getXmlByFlowModel(FlowModel flowModel, String identityKey, WorkFlow workFlow, boolean updateVersion, boolean appointVersion) throws BpmException, IOException, XMLStreamException {
        ExtensionElement extensionElement;
        List taskListeners;
        ExtendTaskListener executionListener;
        OriginalTaskListener originalExecutionListener;
        String isBackfill;
        TimeOutStrategy globalTimeOutStrategy;
        String chosenDay;
        String globalDueDate;
        if (flowModel == null) {
            return null;
        }
        ProcessDefinition latestProcessDefinition = appointVersion ? (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(identityKey).processDefinitionVersion(Integer.valueOf(Integer.parseInt(workFlow.getVersion()))).singleResult() : (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(identityKey).latestVersion().singleResult();
        int processDefinitionVersion = latestProcessDefinition != null ? (updateVersion ? latestProcessDefinition.getVersion() + 1 : latestProcessDefinition.getVersion()) : 1;
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        String processKeyDefault = "key-" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        String processKey = workFlow.getIdentity();
        String modelName = workFlow.getName();
        process.setDocumentation(flowModel.getProps().getDesc());
        process.setName(HussarUtils.isEmpty((Object)modelName) ? "" : modelName);
        process.setId(HussarUtils.isEmpty((Object)processKey) ? processKeyDefault : processKey);
        FlowTodoCondition flowTodoCondition = flowModel.getProps().getTodoConfiguration();
        if (flowTodoCondition != null) {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("todoConfiguration", flowTodoCondition.getModalValue()));
        } else {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("todoConfiguration", ""));
        }
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("version", String.valueOf(processDefinitionVersion)));
        String width = flowModel.getWidth();
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("canvasWidth", width));
        String height = flowModel.getHeight();
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("canvasHeight", height));
        String procNameTranslateKey = flowModel.getProps().getProcessNameTranslateId();
        if (HussarUtils.isNotEmpty((Object)procNameTranslateKey)) {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("processNameTranslateId", procNameTranslateKey));
        }
        if (HussarUtils.isNotEmpty((Object)(globalDueDate = flowModel.getProps().getGlobalDueDate()))) {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("globalDueDate", globalDueDate));
        }
        if (HussarUtils.isNotEmpty((Object)(chosenDay = flowModel.getProps().getChosenDay()))) {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("chosenDay", chosenDay));
        }
        if (HussarUtils.isNotEmpty((Object)(globalTimeOutStrategy = flowModel.getProps().getGlobalTimeOutStrategy())) && HussarUtils.isNotEmpty((Object)globalTimeOutStrategy.getTimeoutStrategyType()) && !"unHandle".equals(globalTimeOutStrategy.getTimeoutStrategyType())) {
            String timeoutStrategyType = globalTimeOutStrategy.getTimeoutStrategyType();
            if ("outInterface".equals(timeoutStrategyType)) {
                String path = globalTimeOutStrategy.getOutInterface();
                process.addExtensionElement(FormBpmnUtil.addExtensionElement("globalTimeOutStrategy", path));
            } else if (!"".equals(timeoutStrategyType)) {
                process.addExtensionElement(FormBpmnUtil.addExtensionElement("globalTimeOutStrategy", timeoutStrategyType));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(isBackfill = flowModel.getProps().getIsBackfill()))) {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("isBackfill", isBackfill));
        }
        if (HussarUtils.isNotEmpty((Object)(originalExecutionListener = flowModel.getProps().getOriginalExecutionListener()))) {
            ArrayList<ActivitiListener> taskListeners2 = new ArrayList<ActivitiListener>();
            List extendActivitiListeners = originalExecutionListener.getFlowListener();
            for (ExtendActivitiListener extendActivitiListener : extendActivitiListeners) {
                ActivitiListener activitiListener = new ActivitiListener();
                activitiListener.setEvent(extendActivitiListener.getEvent());
                activitiListener.setImplementationType(extendActivitiListener.getImplementationType());
                activitiListener.setImplementation(extendActivitiListener.getImplementation());
                ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
                for (ExtendFieldExtension extendFieldExtension : extendActivitiListener.getFieldExtensions()) {
                    FieldExtension fileExtension = new FieldExtension();
                    fileExtension.setStringValue(extendFieldExtension.getStringValue());
                    fileExtension.setFieldName(extendFieldExtension.getFieldName());
                    fileExtension.setExpression(extendFieldExtension.getExpression());
                    fieldExtensionList.add(fileExtension);
                }
                activitiListener.setFieldExtensions(fieldExtensionList);
                activitiListener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
                taskListeners2.add(activitiListener);
            }
            process.setExecutionListeners(taskListeners2);
        }
        if (HussarUtils.isNotEmpty((Object)(executionListener = flowModel.getProps().getExecutionListener())) && HussarUtils.isNotEmpty((Object)(taskListeners = executionListener.getFlowListener()))) {
            for (ExeListener exeListener : taskListeners) {
                extensionElement = new ExtensionElement();
                extensionElement.setName("extendExecutionListener");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute eventAttribute = new ExtensionAttribute();
                eventAttribute.setName("event");
                eventAttribute.setValue(exeListener.getTrigger());
                extensionElement.addAttribute(eventAttribute);
                ExtensionAttribute typeAttribute = new ExtensionAttribute();
                typeAttribute.setName("type");
                typeAttribute.setValue(exeListener.getRequestMode());
                extensionElement.addAttribute(typeAttribute);
                ExtensionAttribute urlAttribute = new ExtensionAttribute();
                urlAttribute.setName("url");
                urlAttribute.setValue(exeListener.getRequestPath());
                extensionElement.addAttribute(urlAttribute);
                process.addExtensionElement(extensionElement);
            }
        }
        for (FlowObject element : flowModel.getSlots().getPathAndElement()) {
            if (!BpmNodeTypeUtil.isAnnotation((String)element.getName())) continue;
            FlowProps flowProps = element.getProps();
            extensionElement = new ExtensionElement();
            extensionElement.setName("extentAnnotation");
            extensionElement.setNamespacePrefix("extend");
            extensionElement.setNamespace("http://activiti.org/bpmn");
            ExtensionAttribute keyAttribute = new ExtensionAttribute();
            keyAttribute.setName("annotationKey");
            keyAttribute.setValue(element.getInstanceKey());
            extensionElement.addAttribute(keyAttribute);
            ExtensionAttribute xAttribute = new ExtensionAttribute();
            xAttribute.setName("annotationX");
            xAttribute.setValue(element.getLeft());
            extensionElement.addAttribute(xAttribute);
            ExtensionAttribute yAttribute = new ExtensionAttribute();
            yAttribute.setName("annotationY");
            yAttribute.setValue(element.getTop());
            extensionElement.addAttribute(yAttribute);
            ExtensionAttribute widthAttribute = new ExtensionAttribute();
            widthAttribute.setName("annotationWidth");
            widthAttribute.setValue(element.getWidth());
            extensionElement.addAttribute(widthAttribute);
            ExtensionAttribute heightAttribute = new ExtensionAttribute();
            heightAttribute.setName("annotationHeight");
            heightAttribute.setValue(element.getHeight());
            extensionElement.addAttribute(heightAttribute);
            ExtensionAttribute contentAttribute = new ExtensionAttribute();
            contentAttribute.setName("annotationContent");
            contentAttribute.setValue(flowProps.getTodoConfiguration().getModalValue());
            extensionElement.addAttribute(contentAttribute);
            process.addExtensionElement(extensionElement);
        }
        this.packageProcess(flowModel, process, processKey, model);
        return this.convertXMLandValidate(model);
    }

    private BpmnModel getXmlByFlowModel(FlowModel flowModel, String identityKey, WorkFlow workFlow, boolean updateVersion) throws BpmException, IOException, XMLStreamException {
        return this.newGetXmlByFlowModel(flowModel, identityKey, workFlow, updateVersion, null);
    }

    private BpmnModel newGetXmlByFlowModel(FlowModel flowModel, String identityKey, WorkFlow workFlow, boolean updateVersion, Boolean isPublish) throws BpmException, IOException, XMLStreamException {
        List taskListeners;
        ExtendTaskListener executionListener;
        OriginalTaskListener originalExecutionListener;
        String isBackfill;
        TimeOutStrategy globalTimeOutStrategy;
        String globalDueDate;
        if (flowModel == null) {
            return null;
        }
        int processDefinitionVersion = Integer.parseInt(workFlow.getVersion());
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        String processKeyDefault = "key-" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        String processKey = workFlow.getIdentity();
        String modelName = workFlow.getName();
        process.setDocumentation(flowModel.getProps().getDesc());
        process.setName(HussarUtils.isEmpty((Object)modelName) ? "" : modelName);
        process.setId(HussarUtils.isEmpty((Object)processKey) ? processKeyDefault : processKey);
        FlowTodoCondition flowTodoCondition = flowModel.getProps().getTodoConfiguration();
        if (flowTodoCondition != null) {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("todoConfiguration", flowTodoCondition.getModalValue()));
        } else {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("todoConfiguration", ""));
        }
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("version", String.valueOf(processDefinitionVersion)));
        String width = flowModel.getWidth();
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("canvasWidth", width));
        String height = flowModel.getHeight();
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("canvasHeight", height));
        String procNameTranslateKey = flowModel.getProps().getProcessNameTranslateId();
        if (HussarUtils.isNotEmpty((Object)procNameTranslateKey)) {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("processNameTranslateId", procNameTranslateKey));
        }
        if (HussarUtils.isNotEmpty((Object)(globalDueDate = flowModel.getProps().getGlobalDueDate()))) {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("globalDueDate", globalDueDate));
        }
        if (HussarUtils.isNotEmpty((Object)(globalTimeOutStrategy = flowModel.getProps().getGlobalTimeOutStrategy())) && HussarUtils.isNotEmpty((Object)globalTimeOutStrategy.getTimeoutStrategyType()) && !"unHandle".equals(globalTimeOutStrategy.getTimeoutStrategyType())) {
            String timeoutStrategyType = globalTimeOutStrategy.getTimeoutStrategyType();
            if ("outInterface".equals(timeoutStrategyType)) {
                String path = globalTimeOutStrategy.getOutInterface();
                process.addExtensionElement(FormBpmnUtil.addExtensionElement("globalTimeOutStrategy", path));
            } else if (!"".equals(timeoutStrategyType)) {
                process.addExtensionElement(FormBpmnUtil.addExtensionElement("globalTimeOutStrategy", timeoutStrategyType));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(isBackfill = flowModel.getProps().getIsBackfill()))) {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("isBackfill", isBackfill));
        }
        if (HussarUtils.isNotEmpty((Object)(originalExecutionListener = flowModel.getProps().getOriginalExecutionListener()))) {
            ArrayList<ActivitiListener> taskListeners2 = new ArrayList<ActivitiListener>();
            List extendActivitiListeners = originalExecutionListener.getFlowListener();
            for (ExtendActivitiListener extendActivitiListener : extendActivitiListeners) {
                ActivitiListener activitiListener = new ActivitiListener();
                activitiListener.setEvent(extendActivitiListener.getEvent());
                activitiListener.setImplementationType(extendActivitiListener.getImplementationType());
                activitiListener.setImplementation(extendActivitiListener.getImplementation());
                ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
                for (ExtendFieldExtension extendFieldExtension : extendActivitiListener.getFieldExtensions()) {
                    FieldExtension fileExtension = new FieldExtension();
                    fileExtension.setStringValue(extendFieldExtension.getStringValue());
                    fileExtension.setFieldName(extendFieldExtension.getFieldName());
                    fileExtension.setExpression(extendFieldExtension.getExpression());
                    fieldExtensionList.add(fileExtension);
                }
                activitiListener.setFieldExtensions(fieldExtensionList);
                activitiListener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
                taskListeners2.add(activitiListener);
            }
            process.setExecutionListeners(taskListeners2);
        }
        if (HussarUtils.isNotEmpty((Object)(executionListener = flowModel.getProps().getExecutionListener())) && HussarUtils.isNotEmpty((Object)(taskListeners = executionListener.getFlowListener()))) {
            for (ExeListener exeListener : taskListeners) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendExecutionListener");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute eventAttribute = new ExtensionAttribute();
                eventAttribute.setName("event");
                eventAttribute.setValue(exeListener.getTrigger());
                extensionElement.addAttribute(eventAttribute);
                ExtensionAttribute typeAttribute = new ExtensionAttribute();
                typeAttribute.setName("type");
                typeAttribute.setValue(exeListener.getRequestMode());
                extensionElement.addAttribute(typeAttribute);
                ExtensionAttribute urlAttribute = new ExtensionAttribute();
                urlAttribute.setName("url");
                urlAttribute.setValue(exeListener.getRequestPath());
                extensionElement.addAttribute(urlAttribute);
                process.addExtensionElement(extensionElement);
            }
        }
        this.packageProcess(flowModel, process, processKey, model);
        return this.convertXMLandValidate(model);
    }

    private Long genXMLByFlowModel(FlowModel flowModel, WorkFlow workFlow, boolean appointVersion) throws BpmException, IOException, XMLStreamException {
        if (flowModel == null) {
            return null;
        }
        BpmnModel bpmnModel = this.getXmlByFlowModel(flowModel, workFlow.getIdentity(), workFlow, true, appointVersion);
        this.saveAssignee(flowModel, workFlow, bpmnModel, true, null);
        return this.completeAndDeployModel(bpmnModel, workFlow.getName(), flowModel.getModelId(), flowModel.getProps().getDesc(), workFlow.getIdentity(), workFlow.getWorkflowStyle(), workFlow.getAppId(), workFlow.getAppCode());
    }

    private Long genXMLByFlowModel(WorkFlow workFlow) throws BpmException, IOException, XMLStreamException {
        FlowModel flowModel = (FlowModel)JSONObject.parseObject((String)workFlow.getData(), FlowModel.class);
        if (flowModel == null) {
            return null;
        }
        String version = workFlow.getVersion();
        String identityKey = workFlow.getIdentity();
        BpmnModel bpmnModel = this.getXmlByFlowModel(flowModel, identityKey, workFlow, true);
        this.saveAssignee(flowModel, workFlow, bpmnModel, true, null);
        return this.completeAndDeployModel(bpmnModel, workFlow.getName(), workFlow.getModelId(), flowModel.getProps().getDesc(), identityKey, workFlow.getAppId(), workFlow.getAppName(), workFlow.getAppCode(), workFlow.getWorkflowStyle());
    }

    private void saveAssignee(FlowModel flowModel, WorkFlow workFlow, BpmnModel bpmnModel, boolean isLowCode, Boolean isPublish) {
        int version;
        String identityKey = workFlow.getIdentity();
        ArrayList<SysActAssignee> list = new ArrayList<SysActAssignee>();
        List elements = flowModel.getSlots().getElement();
        Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
        List flowSequences = flowModel.getSlots().getPath() != null ? flowModel.getSlots().getPath() : new ArrayList();
        String startTaskKey = null;
        block0: for (FlowObject flowObject : elements) {
            if (!BpmNodeTypeUtil.isStart((String)flowObject.getName())) continue;
            String outPath = (String)flowObject.getGoOutPathes().get(0);
            for (FlowSequence flowSequence : flowSequences) {
                if (!outPath.equals(flowSequence.getInstanceKey())) continue;
                startTaskKey = flowSequence.getEnd().getKey();
                break block0;
            }
        }
        int n = version = HussarUtils.isNotEmpty((Object)workFlow.getVersion()) ? Integer.parseInt(workFlow.getVersion()) : 0;
        if (flowModel.getProps().getExceptionReceiver() != null) {
            SysActAssignee exceptionReceiver = new SysActAssignee();
            exceptionReceiver.setProcDefKey(identityKey);
            exceptionReceiver.setContentType("exception_receiver");
            String exceptionCondition = flowModel.getProps().getExceptionReceiver().getDefaultBackCondtion();
            exceptionReceiver.setContent(exceptionCondition == null ? "".getBytes(StandardCharsets.UTF_8) : exceptionCondition.getBytes(StandardCharsets.UTF_8));
            exceptionReceiver.setMessageType(flowModel.getProps().getExceptionMessageType());
            exceptionReceiver.setProcessVersion(Integer.valueOf(version));
            if (isLowCode) {
                list.add(exceptionReceiver);
            }
            SysActAssignee exceptionReceiverModel = new SysActAssignee();
            exceptionReceiverModel.setProcDefKey(identityKey);
            exceptionReceiverModel.setContentType("exception_receiver_model");
            exceptionReceiverModel.setContent(JSON.toJSONString((Object)flowModel.getProps().getExceptionReceiver()).getBytes(StandardCharsets.UTF_8));
            exceptionReceiverModel.setMessageType(flowModel.getProps().getExceptionMessageType());
            exceptionReceiverModel.setProcessVersion(Integer.valueOf(version));
            if (isLowCode) {
                list.add(exceptionReceiverModel);
            }
        }
        ArrayList<String> nodeIds = new ArrayList<String>();
        block2: for (FlowElement flowElement : flowElements) {
            String condAssignee;
            SysActAssignee conditionAssignee;
            String assignee;
            SysActAssignee modelAssignee;
            SysActAssignee startTaskModel;
            if (flowElement instanceof UserTask) {
                nodeIds.add(flowElement.getId());
                if (flowElement.getId().equals(startTaskKey)) {
                    startTaskModel = new SysActAssignee();
                    startTaskModel.setProcDefKey(identityKey);
                    startTaskModel.setContentType("defaultAssign");
                    startTaskModel.setMessageType(this.getMessageType(flowElement));
                    startTaskModel.setProcessVersion(Integer.valueOf(version));
                    list.add(startTaskModel);
                }
                modelAssignee = new SysActAssignee();
                modelAssignee.setProcDefKey(identityKey);
                modelAssignee.setContentType("defaultAssign");
                modelAssignee.setTaskDefKey(flowElement.getId());
                modelAssignee.setMessageType(this.getMessageType(flowElement));
                modelAssignee.setProcessVersion(Integer.valueOf(version));
                assignee = flowElement.getAttributeValue("http://activiti.org/bpmn", "defaultAssign");
                modelAssignee.setContent(assignee == null ? "".getBytes(StandardCharsets.UTF_8) : assignee.getBytes(StandardCharsets.UTF_8));
                modelAssignee.setProcessVersion(Integer.valueOf(version));
                list.add(modelAssignee);
                SysActAssignee conditionAssignee2 = new SysActAssignee();
                conditionAssignee2.setProcDefKey(identityKey);
                conditionAssignee2.setContentType("conditionAssign");
                conditionAssignee2.setTaskDefKey(flowElement.getId());
                conditionAssignee2.setMessageType(this.getMessageType(flowElement));
                conditionAssignee2.setProcessVersion(Integer.valueOf(version));
                String condAssignee2 = flowElement.getAttributeValue("http://activiti.org/bpmn", "conditionAssign");
                conditionAssignee2.setContent(condAssignee2 == null ? "".getBytes(StandardCharsets.UTF_8) : condAssignee2.getBytes(StandardCharsets.UTF_8));
                conditionAssignee2.setProcessVersion(Integer.valueOf(version));
                if (isLowCode) {
                    list.add(conditionAssignee2);
                }
                SysActAssignee ccAssignee = new SysActAssignee();
                ccAssignee.setProcDefKey(identityKey);
                ccAssignee.setContentType("defaultCcAssign");
                ccAssignee.setTaskDefKey(flowElement.getId());
                ccAssignee.setProcessVersion(Integer.valueOf(version));
                String ccAssigneeValue = flowElement.getAttributeValue("http://activiti.org/bpmn", "defaultCcAssign");
                ccAssignee.setContent(ccAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccAssigneeValue.getBytes(StandardCharsets.UTF_8));
                ccAssignee.setProcessVersion(Integer.valueOf(version));
                list.add(ccAssignee);
                SysActAssignee ccConditionAssignee = new SysActAssignee();
                ccConditionAssignee.setProcDefKey(identityKey);
                ccConditionAssignee.setContentType("conditionCcAssign");
                ccConditionAssignee.setTaskDefKey(flowElement.getId());
                String ccConditionAssigneeValue = flowElement.getAttributeValue("http://activiti.org/bpmn", "conditionCcAssign");
                ccConditionAssignee.setContent(ccConditionAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccConditionAssigneeValue.getBytes(StandardCharsets.UTF_8));
                ccConditionAssignee.setProcessVersion(Integer.valueOf(version));
                if (isLowCode) {
                    list.add(ccConditionAssignee);
                }
                SysActAssignee ccEndAssignee = new SysActAssignee();
                ccEndAssignee.setProcDefKey(identityKey);
                ccEndAssignee.setContentType("defaultCcEndAssign");
                ccEndAssignee.setTaskDefKey(flowElement.getId());
                String ccEndAssigneeValue = flowElement.getAttributeValue("http://activiti.org/bpmn", "defaultCcEndAssign");
                ccEndAssignee.setContent(ccEndAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccEndAssigneeValue.getBytes(StandardCharsets.UTF_8));
                ccEndAssignee.setProcessVersion(Integer.valueOf(version));
                if (isLowCode) {
                    list.add(ccEndAssignee);
                }
                SysActAssignee ccEndConditionAssignee = new SysActAssignee();
                ccEndConditionAssignee.setProcDefKey(identityKey);
                ccEndConditionAssignee.setContentType("conditionCcEndAssign");
                ccEndConditionAssignee.setTaskDefKey(flowElement.getId());
                String ccEndConditionAssigneeValue = flowElement.getAttributeValue("http://activiti.org/bpmn", "conditionCcEndAssign");
                ccEndConditionAssignee.setContent(ccEndConditionAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccEndConditionAssigneeValue.getBytes(StandardCharsets.UTF_8));
                ccEndConditionAssignee.setProcessVersion(Integer.valueOf(version));
                if (isLowCode) {
                    list.add(ccEndConditionAssignee);
                }
                for (FlowObject object : elements) {
                    if (!flowElement.getId().equals(object.getId())) continue;
                    SysActAssignee assigneeModel = new SysActAssignee();
                    assigneeModel.setProcDefKey(identityKey);
                    assigneeModel.setContentType("assign_model");
                    assigneeModel.setTaskDefKey(flowElement.getId());
                    assigneeModel.setMessageType(this.getMessageType(flowElement));
                    assigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowAssignment()).getBytes(StandardCharsets.UTF_8));
                    assigneeModel.setProcessVersion(Integer.valueOf(version));
                    list.add(assigneeModel);
                    SysActAssignee ccAssigneeModel = new SysActAssignee();
                    ccAssigneeModel.setProcDefKey(identityKey);
                    ccAssigneeModel.setContentType("cc_assign_model");
                    ccAssigneeModel.setTaskDefKey(flowElement.getId());
                    ccAssigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowRecipients()).getBytes(StandardCharsets.UTF_8));
                    ccAssigneeModel.setProcessVersion(Integer.valueOf(version));
                    list.add(ccAssigneeModel);
                    SysActAssignee ccEndAssigneeModel = new SysActAssignee();
                    ccEndAssigneeModel.setProcDefKey(identityKey);
                    ccEndAssigneeModel.setContentType("cc_end_assign_model");
                    ccEndAssigneeModel.setTaskDefKey(flowElement.getId());
                    ccEndAssigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowEndRecipients()).getBytes(StandardCharsets.UTF_8));
                    ccEndAssigneeModel.setProcessVersion(Integer.valueOf(version));
                    if (!isLowCode) continue block2;
                    list.add(ccEndAssigneeModel);
                    continue block2;
                }
                continue;
            }
            if (flowElement instanceof CallActivity) {
                nodeIds.add(flowElement.getId());
                if (flowElement.getId().equals(startTaskKey)) {
                    startTaskModel = new SysActAssignee();
                    startTaskModel.setProcDefKey(identityKey);
                    startTaskModel.setContentType("defaultAssign");
                    startTaskModel.setMessageType(this.getMessageType(flowElement));
                    startTaskModel.setProcessVersion(Integer.valueOf(version));
                    list.add(startTaskModel);
                }
                Map map = flowElement.getExtensionElements();
                SysActAssignee modelAssignee2 = new SysActAssignee();
                modelAssignee2.setProcDefKey(identityKey);
                modelAssignee2.setContentType("defaultCallAssignee");
                modelAssignee2.setTaskDefKey(flowElement.getId());
                modelAssignee2.setMessageType(this.getMessageType(flowElement));
                modelAssignee2.setProcessVersion(Integer.valueOf(version));
                String assignee2 = null;
                if (map.get("defaultCallAssignee") != null) {
                    assignee2 = ((ExtensionElement)((List)flowElement.getExtensionElements().get("defaultCallAssignee")).get(0)).getAttributeValue(null, "defaultCallAssignee");
                }
                modelAssignee2.setContent(assignee2 == null ? "".getBytes(StandardCharsets.UTF_8) : assignee2.getBytes(StandardCharsets.UTF_8));
                modelAssignee2.setProcessVersion(Integer.valueOf(version));
                list.add(modelAssignee2);
                conditionAssignee = new SysActAssignee();
                conditionAssignee.setProcDefKey(identityKey);
                conditionAssignee.setContentType("conditionCallAssign");
                conditionAssignee.setTaskDefKey(flowElement.getId());
                conditionAssignee.setMessageType(this.getMessageType(flowElement));
                conditionAssignee.setProcessVersion(Integer.valueOf(version));
                condAssignee = null;
                if (map.get("conditionCallAssign") != null) {
                    condAssignee = ((ExtensionElement)((List)flowElement.getExtensionElements().get("conditionCallAssign")).get(0)).getAttributeValue(null, "conditionCallAssign");
                }
                conditionAssignee.setContent(condAssignee == null ? "".getBytes(StandardCharsets.UTF_8) : condAssignee.getBytes(StandardCharsets.UTF_8));
                conditionAssignee.setProcessVersion(Integer.valueOf(version));
                list.add(conditionAssignee);
                SysActAssignee ccAssignee = new SysActAssignee();
                ccAssignee.setProcDefKey(identityKey);
                ccAssignee.setContentType("defaultCallProcessKey");
                ccAssignee.setTaskDefKey(flowElement.getId());
                ccAssignee.setProcessVersion(Integer.valueOf(version));
                String processKey = null;
                if (map.get("defaultCallProcessKey") != null) {
                    processKey = ((ExtensionElement)((List)flowElement.getExtensionElements().get("defaultCallProcessKey")).get(0)).getAttributeValue(null, "defaultCallProcessKey");
                }
                ccAssignee.setContent(processKey == null ? "".getBytes(StandardCharsets.UTF_8) : processKey.getBytes(StandardCharsets.UTF_8));
                ccAssignee.setProcessVersion(Integer.valueOf(version));
                list.add(ccAssignee);
                SysActAssignee ccConditionAssignee = new SysActAssignee();
                ccConditionAssignee.setProcDefKey(identityKey);
                ccConditionAssignee.setContentType("conditionCallProcessKey");
                ccConditionAssignee.setTaskDefKey(flowElement.getId());
                ccConditionAssignee.setProcessVersion(Integer.valueOf(version));
                String ccConditionAssigneeValue = null;
                if (map.get("conditionCallProcessKey") != null) {
                    ccConditionAssigneeValue = ((ExtensionElement)((List)flowElement.getExtensionElements().get("conditionCallProcessKey")).get(0)).getAttributeValue(null, "conditionCallProcessKey");
                }
                ccConditionAssignee.setContent(ccConditionAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccConditionAssigneeValue.getBytes(StandardCharsets.UTF_8));
                ccConditionAssignee.setProcessVersion(Integer.valueOf(version));
                list.add(ccConditionAssignee);
                for (FlowObject object : elements) {
                    if (!flowElement.getId().equals(object.getId())) continue;
                    SysActAssignee assigneeModel = new SysActAssignee();
                    assigneeModel.setProcDefKey(identityKey);
                    assigneeModel.setContentType("assign_model");
                    assigneeModel.setTaskDefKey(flowElement.getId());
                    assigneeModel.setMessageType(this.getMessageType(flowElement));
                    assigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowSelector()).getBytes(StandardCharsets.UTF_8));
                    assigneeModel.setProcessVersion(Integer.valueOf(version));
                    list.add(assigneeModel);
                    continue block2;
                }
                continue;
            }
            if (!(flowElement instanceof SubProcess)) continue;
            nodeIds.add(flowElement.getId());
            block5: for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                if (!(element instanceof UserTask)) continue;
                nodeIds.add(element.getId());
                SysActAssignee modelAssignee3 = new SysActAssignee();
                modelAssignee3.setProcDefKey(identityKey);
                modelAssignee3.setContentType("defaultAssign");
                modelAssignee3.setTaskDefKey(element.getId());
                String assignee3 = element.getAttributeValue("http://activiti.org/bpmn", "defaultAssign");
                modelAssignee3.setContent(assignee3 == null ? "".getBytes(StandardCharsets.UTF_8) : assignee3.getBytes(StandardCharsets.UTF_8));
                modelAssignee3.setProcessVersion(Integer.valueOf(version));
                list.add(modelAssignee3);
                SysActAssignee conditionAssignee3 = new SysActAssignee();
                conditionAssignee3.setProcDefKey(identityKey);
                conditionAssignee3.setContentType("conditionAssign");
                conditionAssignee3.setTaskDefKey(element.getId());
                String condAssignee3 = element.getAttributeValue("http://activiti.org/bpmn", "conditionAssign");
                conditionAssignee3.setContent(condAssignee3 == null ? "".getBytes(StandardCharsets.UTF_8) : condAssignee3.getBytes(StandardCharsets.UTF_8));
                conditionAssignee3.setProcessVersion(Integer.valueOf(version));
                list.add(conditionAssignee3);
                SysActAssignee ccAssignee = new SysActAssignee();
                ccAssignee.setProcDefKey(identityKey);
                ccAssignee.setContentType("defaultCcAssign");
                ccAssignee.setTaskDefKey(element.getId());
                String ccAssigneeValue = element.getAttributeValue("http://activiti.org/bpmn", "defaultCcAssign");
                ccAssignee.setContent(ccAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccAssigneeValue.getBytes(StandardCharsets.UTF_8));
                ccAssignee.setProcessVersion(Integer.valueOf(version));
                list.add(ccAssignee);
                SysActAssignee ccConditionAssignee = new SysActAssignee();
                ccConditionAssignee.setProcDefKey(identityKey);
                ccConditionAssignee.setContentType("conditionCcAssign");
                ccConditionAssignee.setTaskDefKey(element.getId());
                String ccConditionAssigneeValue = element.getAttributeValue("http://activiti.org/bpmn", "conditionCcAssign");
                ccConditionAssignee.setContent(ccConditionAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccConditionAssigneeValue.getBytes(StandardCharsets.UTF_8));
                ccConditionAssignee.setProcessVersion(Integer.valueOf(version));
                list.add(ccConditionAssignee);
                SysActAssignee ccEndAssignee = new SysActAssignee();
                ccEndAssignee.setProcDefKey(identityKey);
                ccEndAssignee.setContentType("defaultCcEndAssign");
                ccEndAssignee.setTaskDefKey(element.getId());
                String ccEndAssigneeValue = element.getAttributeValue("http://activiti.org/bpmn", "defaultCcEndAssign");
                ccEndAssignee.setContent(ccEndAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccEndAssigneeValue.getBytes(StandardCharsets.UTF_8));
                ccEndAssignee.setProcessVersion(Integer.valueOf(version));
                list.add(ccEndAssignee);
                SysActAssignee ccEndConditionAssignee = new SysActAssignee();
                ccEndConditionAssignee.setProcDefKey(identityKey);
                ccEndConditionAssignee.setContentType("conditionCcEndAssign");
                ccEndConditionAssignee.setTaskDefKey(element.getId());
                String ccEndConditionAssigneeValue = element.getAttributeValue("http://activiti.org/bpmn", "conditionCcEndAssign");
                ccEndConditionAssignee.setContent(ccEndConditionAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccEndConditionAssigneeValue.getBytes(StandardCharsets.UTF_8));
                ccEndConditionAssignee.setProcessVersion(Integer.valueOf(version));
                list.add(ccEndConditionAssignee);
                for (FlowObject object : elements) {
                    if (!element.getId().equals(object.getId())) continue;
                    SysActAssignee assigneeModel = new SysActAssignee();
                    assigneeModel.setProcDefKey(identityKey);
                    assigneeModel.setContentType("assign_model");
                    assigneeModel.setTaskDefKey(element.getId());
                    assigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowAssignment()).getBytes(StandardCharsets.UTF_8));
                    assigneeModel.setProcessVersion(Integer.valueOf(version));
                    list.add(assigneeModel);
                    SysActAssignee ccAssigneeModel = new SysActAssignee();
                    ccAssigneeModel.setProcDefKey(identityKey);
                    ccAssigneeModel.setContentType("cc_assign_model");
                    ccAssigneeModel.setTaskDefKey(element.getId());
                    ccAssigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowRecipients()).getBytes(StandardCharsets.UTF_8));
                    ccAssigneeModel.setProcessVersion(Integer.valueOf(version));
                    list.add(ccAssigneeModel);
                    SysActAssignee ccEndAssigneeModel = new SysActAssignee();
                    ccEndAssigneeModel.setProcDefKey(identityKey);
                    ccEndAssigneeModel.setContentType("cc_end_assign_model");
                    ccEndAssigneeModel.setTaskDefKey(element.getId());
                    ccEndAssigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowEndRecipients()).getBytes(StandardCharsets.UTF_8));
                    ccEndAssigneeModel.setProcessVersion(Integer.valueOf(version));
                    list.add(ccEndAssigneeModel);
                    continue block5;
                }
            }
            modelAssignee = new SysActAssignee();
            modelAssignee.setProcDefKey(identityKey);
            modelAssignee.setContentType("defaultAssign");
            modelAssignee.setTaskDefKey(flowElement.getId());
            assignee = null;
            List defaultAssignee = (List)flowElement.getExtensionElements().get("defaultAssign");
            if (defaultAssignee != null) {
                assignee = ((ExtensionElement)defaultAssignee.get(0)).getAttributeValue(null, "defaultAssign");
            }
            modelAssignee.setContent(assignee == null ? "".getBytes(StandardCharsets.UTF_8) : assignee.getBytes(StandardCharsets.UTF_8));
            modelAssignee.setProcessVersion(Integer.valueOf(version));
            list.add(modelAssignee);
            conditionAssignee = new SysActAssignee();
            conditionAssignee.setProcDefKey(identityKey);
            conditionAssignee.setContentType("conditionAssign");
            conditionAssignee.setTaskDefKey(flowElement.getId());
            condAssignee = null;
            List conditionAssigneeElement = (List)flowElement.getExtensionElements().get("conditionAssign");
            if (conditionAssigneeElement != null) {
                condAssignee = ((ExtensionElement)conditionAssigneeElement.get(0)).getAttributeValue(null, "conditionAssign");
            }
            conditionAssignee.setContent(condAssignee == null ? "".getBytes(StandardCharsets.UTF_8) : condAssignee.getBytes(StandardCharsets.UTF_8));
            conditionAssignee.setProcessVersion(Integer.valueOf(version));
            if (isLowCode) {
                list.add(conditionAssignee);
            }
            for (FlowObject object : elements) {
                if (!flowElement.getId().equals(object.getId())) continue;
                SysActAssignee assigneeModel = new SysActAssignee();
                assigneeModel.setProcDefKey(identityKey);
                assigneeModel.setContentType("assign_model");
                assigneeModel.setTaskDefKey(flowElement.getId());
                assigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowAssignment()).getBytes(StandardCharsets.UTF_8));
                assigneeModel.setProcessVersion(Integer.valueOf(version));
                list.add(assigneeModel);
                SysActAssignee ccAssigneeModel = new SysActAssignee();
                ccAssigneeModel.setProcDefKey(identityKey);
                ccAssigneeModel.setContentType("cc_assign_model");
                ccAssigneeModel.setTaskDefKey(flowElement.getId());
                ccAssigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowRecipients()).getBytes(StandardCharsets.UTF_8));
                ccAssigneeModel.setProcessVersion(Integer.valueOf(version));
                list.add(ccAssigneeModel);
                SysActAssignee ccEndAssigneeModel = new SysActAssignee();
                ccEndAssigneeModel.setProcDefKey(identityKey);
                ccEndAssigneeModel.setContentType("cc_end_assign_model");
                ccEndAssigneeModel.setTaskDefKey(flowElement.getId());
                ccEndAssigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowEndRecipients()).getBytes(StandardCharsets.UTF_8));
                ccEndAssigneeModel.setProcessVersion(Integer.valueOf(version));
                if (!isLowCode) continue block2;
                list.add(ccEndAssigneeModel);
                continue block2;
            }
        }
        ArrayList<SysActAssignee> addList = new ArrayList<SysActAssignee>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysActAssignee::getProcDefKey, (Object)identityKey)).eq(SysActAssignee::getProcessVersion, (Object)version)).and(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(SysActAssignee::getTaskDefKey)).or()).in(SysActAssignee::getTaskDefKey, (Collection)nodeIds);
        });
        List sameList = this.sysActAssigneeService.list((Wrapper)queryWrapper);
        ArrayList<SysActAssignee> updateList = new ArrayList<SysActAssignee>();
        for (SysActAssignee sysActAssignee : list) {
            boolean isadd = true;
            for (SysActAssignee actAssignee : sameList) {
                if (HussarUtils.isEmpty((Object)sysActAssignee.getTaskDefKey())) {
                    if (!sysActAssignee.getProcDefKey().equals(actAssignee.getProcDefKey()) || !HussarUtils.isEmpty((Object)actAssignee.getTaskDefKey()) || !sysActAssignee.getContentType().equals(actAssignee.getContentType()) || !sysActAssignee.getProcessVersion().equals(actAssignee.getProcessVersion())) continue;
                    sysActAssignee.setId(actAssignee.getId());
                    updateList.add(sysActAssignee);
                    isadd = false;
                    break;
                }
                if (!sysActAssignee.getProcDefKey().equals(actAssignee.getProcDefKey()) || !sysActAssignee.getTaskDefKey().equals(actAssignee.getTaskDefKey()) || !sysActAssignee.getContentType().equals(actAssignee.getContentType()) || !sysActAssignee.getProcessVersion().equals(actAssignee.getProcessVersion())) continue;
                sysActAssignee.setId(actAssignee.getId());
                updateList.add(sysActAssignee);
                isadd = false;
                break;
            }
            if (!isadd) continue;
            addList.add(sysActAssignee);
        }
        this.sysActAssigneeService.updateBatchById(updateList);
        this.sysActAssigneeService.saveBatch(addList);
    }

    private void packageProcess(FlowModel flowModel, Process process, String processKeyPath, BpmnModel model) throws BpmException {
        FormBpmnUtil.createSequence(flowModel.getSlots().getPath(), flowModel.getSlots().getElement(), processKeyPath, (FlowElementsContainer)process, model);
        for (FlowObject element : flowModel.getSlots().getElement()) {
            element.setProcessKeyPath(processKeyPath);
            if (BpmNodeTypeUtil.isAnnotation((String)element.getName())) continue;
            FormObjectVisitor formObjectVisitor = FormObjectVisitorBeanUtil.getVisitorBean(element.getName());
            if (formObjectVisitor instanceof SubProcessVisitor) {
                ((SubProcessVisitor)formObjectVisitor).setModel(model);
                formObjectVisitor.visit(element, (FlowElementsContainer)process, flowModel, (FlowObject)flowModel);
            } else {
                formObjectVisitor.visit(element, (FlowElementsContainer)process, flowModel, (FlowObject)flowModel);
            }
            GraphicInfo graphicInfo = FormBpmnUtil.createGraphicInfo(element);
            model.addGraphicInfo(element.getId(), graphicInfo);
        }
        List businessRules = flowModel.getProps().getBusinessRules();
        if (HussarUtils.isNotEmpty((Object)businessRules)) {
            FormBpmnUtil.addProcessBusinessExeListener(process, businessRules);
        }
        model.addProcess(process);
    }

    private FlowModel readModel(WorkFlow workFlow) throws BpmException {
        if (HussarUtils.isEmpty((Object)workFlow.getIdentity())) {
            throw new BpmException(BpmExceptionCodeEnum.FILE_NOT_EXITS.format(new Object[]{workFlow.getIdentity()}).getMessage());
        }
        if (HussarUtils.isNotEmpty((Object)workFlow)) {
            String xml = workFlow.getData();
            FlowModel flowModel = (FlowModel)JSON.parseObject((String)xml, FlowModel.class);
            if (HussarUtils.isNotEmpty((Object)flowModel)) {
                flowModel.setModelId(workFlow.getModelId());
            }
            return flowModel;
        }
        return null;
    }

    public boolean updateModel(WorkFlow workFlow, boolean updateVersion, boolean isNocode) {
        return this.newUpdateModel(workFlow, updateVersion, isNocode, null);
    }

    public boolean newUpdateModel(WorkFlow workFlow, boolean updateVersion, boolean isNocode, BpmnModel bpmnModel) {
        HussarCacheUtil.evictKeysRightLike((String)"workflow_file", (String)("workflow_file:" + workFlow.getIdentity() + ":"));
        HussarCacheUtil.evictKeysRightLike((String)"workflow_assignee", (String)("workflow_assignee:" + workFlow.getIdentity() + ":"));
        try {
            String procDefId = null;
            if (bpmnModel != null) {
                procDefId = workFlow.getProcDefId();
            } else {
                procDefId = this.processDefinitionsService.getProcessDefIdByVersion(workFlow.getIdentity(), Integer.valueOf(Integer.parseInt(workFlow.getVersion())));
                bpmnModel = isNocode ? this.getXmlByFlowModel((FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class), workFlow.getIdentity(), workFlow, updateVersion) : this.getXmlByFlowModel((FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class), workFlow.getIdentity(), workFlow, updateVersion, false);
            }
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
            if (HussarUtils.isNotEmpty((Object)workFlow)) {
                BpmActGeBytearray bpmActGeBytearray = new BpmActGeBytearray();
                bpmActGeBytearray.setBytes(bpmnBytes);
                if (updateVersion) {
                    bpmActGeBytearray.setId(this.bpm2XMLMapper.getByteArrayIdByProcDefId(procDefId));
                } else {
                    bpmActGeBytearray.setId(this.bpm2XMLMapper.getUpdateModelId(workFlow.getModelId()));
                }
                this.bpmActGeBytearrayMapper.updateById(bpmActGeBytearray);
                if (isNocode) {
                    SysActProcessFile sysActProcessFile = new SysActProcessFile();
                    sysActProcessFile.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(SysActProcessFile::getProcessId, (Object)procDefId);
                    queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
                    this.sysActProcessFileMapper.update(sysActProcessFile, (Wrapper<SysActProcessFile>)queryWrapper);
                    sysActProcessFile = new SysActProcessFile();
                    String data = workFlow.getData();
                    workFlow.setData(null);
                    sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                    sysActProcessFile.setWorkflowStyle(workFlow.getWorkflowStyle());
                    queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(SysActProcessFile::getProcessId, (Object)procDefId);
                    queryWrapper.eq(SysActProcessFile::getType, (Object)"meta");
                    this.sysActProcessFileMapper.update(sysActProcessFile, (Wrapper<SysActProcessFile>)queryWrapper);
                    workFlow.setData(data);
                } else {
                    int version = Integer.parseInt(procDefId.split(":")[1]);
                    this.sysActProcessFileService.updateFile(workFlow, Integer.valueOf(version));
                }
                this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(procDefId));
                return true;
            }
        }
        catch (BpmException | IOException | XMLStreamException e) {
            logger.error(e.getMessage(), e);
        }
        return false;
    }

    public boolean updateModel(WorkFlow workFlow, BpmnModel bpmnModel, String procDefId) {
        HussarCacheUtil.evictKeysRightLike((String)"workflow_file", (String)("workflow_file:" + workFlow.getIdentity() + ":"));
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
        if (HussarUtils.isNotEmpty((Object)workFlow)) {
            BpmActGeBytearray bpmActGeBytearray = new BpmActGeBytearray();
            bpmActGeBytearray.setBytes(bpmnBytes);
            bpmActGeBytearray.setId(this.bpm2XMLMapper.getUpdateModelByProcDefId(procDefId));
            this.bpmActGeBytearrayMapper.updateById(bpmActGeBytearray);
            SysActProcessFile sysActProcessFile = new SysActProcessFile();
            sysActProcessFile.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysActProcessFile::getProcessId, (Object)procDefId);
            queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
            this.sysActProcessFileMapper.update(sysActProcessFile, (Wrapper<SysActProcessFile>)queryWrapper);
            this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(procDefId));
            return true;
        }
        return false;
    }

    public BpmnModel getBpmnModel(WorkFlow workFlow, String identityKey) {
        try {
            return this.getXmlByFlowModel((FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class), identityKey, workFlow, true, false);
        }
        catch (BpmException | IOException | XMLStreamException e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    private BpmnModel convertXMLandValidate(BpmnModel model) throws XMLStreamException, BpmException {
        BpmnXMLConverter converter = new BpmnXMLConverter();
        byte[] bytes = converter.convertToXML(model, "utf-8");
        XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
        InputStreamReader in = null;
        XMLStreamReader xtr = null;
        try {
            in = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8);
            xtr = xif.createXMLStreamReader(in);
            BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
            ProcessValidatorFactory processValidatorFactory = new ProcessValidatorFactory();
            ProcessValidator defaultProcessValidator = processValidatorFactory.createDefaultProcessValidator();
            List validate = defaultProcessValidator.validate(bpmnModel);
            if (!CollectionUtils.isEmpty((Collection)validate)) {
                StringBuilder errorMsg = new StringBuilder();
                for (int i = 0; i < validate.size(); ++i) {
                    errorMsg.append(((ValidationError)validate.get(i)).getDefaultDescription()).append(',').append(((ValidationError)validate.get(i)).getActivityId());
                    if (i == validate.size() - 1) continue;
                    errorMsg.append(';');
                }
                throw new BpmException(BpmExceptionCodeEnum.BPM_XML_FORMAT_VERIFY_FAIL.format(new Object[]{errorMsg}));
            }
            BpmnModel bpmnModel2 = bpmnModel;
            return bpmnModel2;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (xtr != null) {
                try {
                    xtr.close();
                }
                catch (XMLStreamException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private Model newModel(ObjectNode modelObjectNode, String modelName, String key, String appId, String appName, String appCode, String workflowStyle, String processNameTranslateKey) {
        Model modelData = this.repositoryService.newModel();
        modelObjectNode.put("revision", modelData.getVersion());
        modelData.setMetaInfo(modelObjectNode.toString());
        modelData.setKey(StringUtils.defaultString((String)key));
        modelData.setName(modelName);
        modelData.setNameTranslateKey(processNameTranslateKey);
        if (HussarUtils.isNotEmpty((Object)appId)) {
            modelData.setAppId(Long.valueOf(appId));
        }
        if (HussarUtils.isNotEmpty((Object)appName)) {
            modelData.setAppName(appName);
        }
        if (HussarUtils.isNotEmpty((Object)appCode)) {
            modelData.setAppCode(appCode);
        }
        if (HussarUtils.isNotEmpty((Object)workflowStyle)) {
            modelData.setWorkflowStyle(workflowStyle);
        }
        this.repositoryService.saveModel(modelData);
        return modelData;
    }

    private Model updateModel(ObjectNode modelObjectNode, String modelName, Long modelId, String appId, String appName, String appCode, String workflowStyle, String processNameTranslateKey) {
        Model modelData = this.repositoryService.getModel(String.valueOf(modelId));
        modelObjectNode.put("revision", modelData.getVersion());
        modelData.setMetaInfo(modelObjectNode.toString());
        modelData.setName(modelName);
        modelData.setNameTranslateKey(processNameTranslateKey);
        if (HussarUtils.isNotEmpty((Object)appId)) {
            modelData.setAppId(Long.valueOf(appId));
        }
        if (HussarUtils.isNotEmpty((Object)appName)) {
            modelData.setAppName(appName);
        }
        if (HussarUtils.isNotEmpty((Object)appCode)) {
            modelData.setAppCode(appCode);
        }
        if (HussarUtils.isNotEmpty((Object)workflowStyle)) {
            modelData.setWorkflowStyle(workflowStyle);
        }
        this.repositoryService.saveModel(modelData);
        return modelData;
    }

    private Long deployModel(BpmnModel bpmnModel, Model modelData, Long modelId) {
        ExtendBpmnJsonConverter child = new ExtendBpmnJsonConverter();
        child.updateConvertersToBpmnMap();
        child.updateConvertersToJsonMap();
        ObjectNode editorNode = child.convertToJson(bpmnModel);
        this.repositoryService.addModelEditorSource(modelData.getId(), editorNode.toString().getBytes(StandardCharsets.UTF_8));
        return modelId;
    }

    private Long completeAndDeployModel(BpmnModel bpmnModel, String modelName, Long modelId, String flowDesc, String identityKey, String appId, String appName, String appCode, String workflowStyle) {
        Model modelData;
        Long newModelId = modelId;
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", modelName);
        modelObjectNode.put("description", flowDesc);
        String processNameTranslateKey = ActivitiTranslateUtil.getTranslateKey((Map)bpmnModel.getMainProcess().getExtensionElements(), (String)"processNameTranslateId");
        if (HussarUtils.isEmpty((Object)newModelId) || HussarUtils.isEmpty((Object)this.repositoryService.getModel(String.valueOf(newModelId)))) {
            modelData = this.newModel(modelObjectNode, modelName, identityKey, appId, appName, appCode, workflowStyle, processNameTranslateKey);
            newModelId = Long.parseLong(modelData.getId());
        } else {
            modelData = this.updateModel(modelObjectNode, modelName, newModelId, appId, appName, appCode, workflowStyle, processNameTranslateKey);
        }
        return this.deployModel(bpmnModel, modelData, newModelId);
    }

    private Long completeAndDeployModel(BpmnModel bpmnModel, String modelName, Long modelId, String flowDesc, String identityKey, String workflowStyle, String appId, String appCode) {
        Model modelData;
        Long newModelId = modelId;
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", modelName);
        modelObjectNode.put("description", flowDesc);
        String processNameTranslateKey = ActivitiTranslateUtil.getTranslateKey((Map)bpmnModel.getMainProcess().getExtensionElements(), (String)"processNameTranslateId");
        if (HussarUtils.isEmpty((Object)newModelId) || HussarUtils.isEmpty((Object)this.repositoryService.getModel(String.valueOf(newModelId)))) {
            modelData = this.newModel(modelObjectNode, modelName, identityKey, appId, null, appCode, workflowStyle, processNameTranslateKey);
            newModelId = Long.parseLong(modelData.getId());
        } else {
            modelData = this.updateModel(modelObjectNode, modelName, newModelId, appId, null, appCode, workflowStyle, processNameTranslateKey);
        }
        return this.deployModel(bpmnModel, modelData, newModelId);
    }

    public String getActDefIdByModelId(Long modelId) {
        return this.bpm2XMLMapper.getActDefIdByModelId(modelId);
    }

    public JSONObject getProcessInfoByFile(FlowChartProcessInfoDto flowChartProcessInfoDto) {
        String processKey = flowChartProcessInfoDto.getProcessIdentityKey();
        String processId = flowChartProcessInfoDto.getProcessKey();
        String processVersion = flowChartProcessInfoDto.getProcessVersion();
        boolean isGetMainOrNew = flowChartProcessInfoDto.isGetMainOrNew();
        boolean needGetTempFile = flowChartProcessInfoDto.getNeedGetTempFile();
        String userId = flowChartProcessInfoDto.getUserId();
        String organId = flowChartProcessInfoDto.getOrganId();
        if (HussarUtils.isEmpty((Object)processVersion) && processId != null && processId.equals(processKey) && (HussarUtils.isNotEmpty((Object)userId) || HussarUtils.isNotEmpty((Object)organId))) {
            processId = WorkflowOrganProcessUtil.getStartOrganProcessId(processId, null, userId, organId, true, flowChartProcessInfoDto.isQueryByOrganId() ? null : "1");
        }
        return this.getProcessInfoByFile(processKey, processId, processVersion, isGetMainOrNew, needGetTempFile);
    }

    public JSONObject getProcessInfoByFile(String processKey, String processId, String processVersion, boolean isGetMainOrNew, boolean needGetTempFile) {
        JSONObject object;
        WorkFlow workFlow;
        JSONObject jsonObject = new JSONObject();
        if (HussarUtils.isEmpty((Object)processKey)) {
            return jsonObject;
        }
        if (HussarUtils.isNotEmpty((Object)processVersion)) {
            processId = this.processDefinitionsService.getStartProcessDefinitionId(processKey, processVersion);
        }
        boolean workflowNoPublish = false;
        if (isGetMainOrNew && HussarUtils.equals((Object)processId, (Object)processKey)) {
            try {
                processId = this.processDefinitionsService.getStartProcessDefinitionId(processKey, null);
            }
            catch (BpmException e2) {
                workflowNoPublish = true;
            }
        }
        if (HussarUtils.isEmpty((Object)(workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(processKey, processId, needGetTempFile, workflowNoPublish ? Integer.valueOf(0) : null, false)))) {
            return jsonObject;
        }
        HashMap<String, SysActAssignee> assigneeMap = null;
        JSONArray jsonArray = new JSONArray();
        if (!workflowNoPublish && !workFlow.isTempWorkflow()) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(SysActAssignee::getProcDefKey, (Object)processKey);
            lambdaQueryWrapper.eq(SysActAssignee::getContentType, (Object)"assign_model");
            ArrayList<Integer> list = new ArrayList<Integer>();
            if (workFlow.getVersion() != null) {
                list.add(Integer.valueOf(workFlow.getVersion()));
            }
            list.add(0);
            lambdaQueryWrapper.in(SysActAssignee::getProcessVersion, list);
            List assigneeList = this.sysActAssigneeService.list((Wrapper)lambdaQueryWrapper);
            assigneeMap = new HashMap<String, SysActAssignee>();
            for (SysActAssignee sysActAssignee : assigneeList) {
                assigneeMap.put(sysActAssignee.getTaskDefKey(), sysActAssignee);
            }
        }
        String xml = workFlow.getData();
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)xml, FlowModel.class);
        ArrayList flowSequences = new ArrayList();
        ArrayList element = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)flowModel.getSlots())) {
            flowSequences = flowModel.getSlots().getPath() == null ? new ArrayList() : flowModel.getSlots().getPath();
            element = flowModel.getSlots().getElement() == null ? new ArrayList() : flowModel.getSlots().getElement();
        }
        for (FlowObject flowObject : element) {
            JSONObject assignee;
            SysActAssignee sysActAssignee;
            FlowAssignment flowAssignment;
            String realName;
            if (BpmNodeTypeUtil.isAnnotation((String)flowObject.getName())) continue;
            object = new JSONObject();
            object.put("id", (Object)flowObject.getNodeId());
            object.put("name", (Object)flowObject.getProps().getFlowName());
            object.put("x", (Object)Double.parseDouble(flowObject.getLeft()));
            object.put("y", (Object)Double.parseDouble(flowObject.getTop()));
            object.put(WIDTH, (Object)Double.parseDouble(flowObject.getWidth()));
            object.put(HEIGHT, (Object)Double.parseDouble(flowObject.getHeight()));
            object.put("nodeNameTranslateId", (Object)flowObject.getProps().getNodeNameTranslateId());
            String[] name = flowObject.getName().split("\\.");
            String subName = name[name.length - 1];
            if (HussarUtils.equals((Object)"Start", (Object)subName)) {
                realName = "startEvent";
            } else if (HussarUtils.equals((Object)"Exclusive", (Object)subName)) {
                realName = "exclusiveGateway";
            } else if (HussarUtils.equals((Object)"Parallel", (Object)subName)) {
                realName = "parallelGateway";
            } else if (HussarUtils.equals((Object)"Inclusive", (Object)subName)) {
                realName = "inclusiveGateway";
            } else if (HussarUtils.equals((Object)"End", (Object)subName)) {
                realName = "endEvent";
            } else if (HussarUtils.equals((Object)"ServiceTask", (Object)subName)) {
                realName = "serviceTask";
                object.put("taskConfiguration", (Object)flowObject.getProps().getTaskConfiguration());
            } else if (HussarUtils.equals((Object)"ReceiveTask", (Object)subName)) {
                realName = "receiveTask";
                object.put("listener", (Object)flowObject.getProps().getOriginalActivityListener());
            } else if (HussarUtils.equals((Object)"CallActivity", (Object)subName)) {
                SysActAssignee sysActAssignee2;
                realName = "callActivity";
                List callActivityElements = flowObject.getProps().getFlowSelectorArr();
                JSONArray json = new JSONArray();
                if (HussarUtils.isNotEmpty((Object)callActivityElements)) {
                    for (CallActivityElement callActivityElement : callActivityElements) {
                        JSONObject jo = new JSONObject();
                        jo.put("superProcessKey", (Object)callActivityElement.getProcessDefinitionKey());
                        jo.put("superProcessName", (Object)callActivityElement.getName());
                        json.add((Object)jo);
                    }
                }
                object.put("callActivityElement", (Object)json);
                FlowAssignment flowSelector = flowObject.getProps().getFlowSelector();
                flowSelector.setDefaultBackCondtion(null);
                flowSelector.setJudgeBackCondition(null);
                flowSelector.setDefaultProcessKey(null);
                if (HussarUtils.isNotEmpty((Object)flowSelector.getParticipantConfigs())) {
                    ((JSONObject)((JSONArray)flowSelector.getParticipantConfigs()).get(0)).remove((Object)"configsEvent");
                } else {
                    flowSelector.setParticipantConfigs(new ArrayList());
                }
                object.put("flowSelector", (Object)flowSelector);
                if (assigneeMap != null && (sysActAssignee2 = (SysActAssignee)assigneeMap.get(flowObject.getId())) != null) {
                    JSONObject assignee2 = JSON.parseObject((String)new String(sysActAssignee2.getContent(), StandardCharsets.UTF_8));
                    if (HussarUtils.isNotEmpty((Object)assignee2.getJSONArray("participantConfigs"))) {
                        assignee2.getJSONArray("participantConfigs").getJSONObject(0).remove((Object)"configsEvent");
                    }
                    assignee2.remove((Object)"judgeBackCondition");
                    assignee2.remove((Object)"defaultBackCondtion");
                    assignee2.remove((Object)"defaultProcessKey");
                    object.put("flowSelector", (Object)assignee2);
                }
            } else if (HussarUtils.equals((Object)"SubProcess", (Object)subName)) {
                realName = "subProcess";
                object.put("subProcessElements", (Object)this.getSubProcessMsg(flowObject, assigneeMap));
            } else if (HussarUtils.isNotEmpty((Object)flowObject.getProps().getFlowCountersign()) && flowObject.getProps().getFlowCountersign().isCountersign()) {
                realName = "multiUserTask";
                flowAssignment = flowObject.getProps().getFlowAssignment();
                flowAssignment.setDefaultBackCondtion(null);
                flowAssignment.setJudgeBackCondition(null);
                flowAssignment.setDefaultProcessKey(null);
                flowAssignment.setParticipantConfigs(null);
                object.put("flowAssignment", (Object)flowAssignment);
                if (assigneeMap != null && (sysActAssignee = (SysActAssignee)assigneeMap.get(flowObject.getId())) != null) {
                    assignee = JSON.parseObject((String)new String(sysActAssignee.getContent(), StandardCharsets.UTF_8));
                    assignee.remove((Object)"participantConfigs");
                    assignee.remove((Object)"judgeBackCondition");
                    assignee.remove((Object)"defaultBackCondtion");
                    object.put("flowAssignment", (Object)assignee);
                }
            } else {
                realName = "userTask";
                flowAssignment = flowObject.getProps().getFlowAssignment();
                flowAssignment.setDefaultBackCondtion(null);
                flowAssignment.setJudgeBackCondition(null);
                flowAssignment.setDefaultProcessKey(null);
                flowAssignment.setParticipantConfigs(null);
                object.put("flowAssignment", (Object)flowAssignment);
                if (assigneeMap != null && (sysActAssignee = (SysActAssignee)assigneeMap.get(flowObject.getId())) != null) {
                    assignee = JSON.parseObject((String)new String(sysActAssignee.getContent(), StandardCharsets.UTF_8));
                    assignee.remove((Object)"participantConfigs");
                    assignee.remove((Object)"judgeBackCondition");
                    assignee.remove((Object)"defaultBackCondtion");
                    object.put("flowAssignment", (Object)assignee);
                }
            }
            object.put("type", (Object)realName);
            object.put("state", (Object)COMPLETE_STATE);
            jsonArray.add((Object)object);
        }
        for (FlowObject flowObject : flowSequences) {
            object = new JSONObject();
            object.put("id", (Object)flowObject.getNodeId());
            object.put("name", (Object)flowObject.getProps().getFlowName());
            object.put("rotate", (Object)((FlowSequence)flowObject).getLineConfig().getRotate());
            object.put("dx", (Object)((FlowSequence)flowObject).getLineConfig().getDx());
            object.put("nodeNameTranslateId", (Object)flowObject.getProps().getNodeNameTranslateId());
            if (((FlowSequence)flowObject).getLineConfig().getWidth() != null) {
                object.put(WIDTH, (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getWidth()));
            } else {
                object.put(WIDTH, null);
            }
            if (((FlowSequence)flowObject).getLineConfig().getHeight() != null) {
                object.put(HEIGHT, (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getHeight()));
            } else {
                object.put(HEIGHT, null);
            }
            if (((FlowSequence)flowObject).getLineConfig().getX() != null) {
                object.put("x", (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getX()));
            } else {
                object.put("x", null);
            }
            if (((FlowSequence)flowObject).getLineConfig().getY() != null) {
                object.put("y", (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getY()));
            } else {
                object.put("y", null);
            }
            List xyList = flowObject.getPoints();
            Double[] xPoints = new Double[xyList.size()];
            Double[] yPoints = new Double[xyList.size()];
            for (int i = 0; i < xyList.size(); ++i) {
                xPoints[i] = Double.parseDouble(((FlowSequenceXy)xyList.get(i)).getX());
                yPoints[i] = Double.parseDouble(((FlowSequenceXy)xyList.get(i)).getY());
            }
            object.put("xPoints", (Object)xPoints);
            object.put("yPoints", (Object)yPoints);
            List lineNameList = ((FlowSequence)flowObject).getLineConfig().getLineName();
            if (lineNameList != null) {
                String[] strs = new String[lineNameList.size()];
                for (int i = 0; i < lineNameList.size(); ++i) {
                    strs[i] = (String)lineNameList.get(i);
                }
                object.put("lineName", (Object)strs);
            } else {
                object.put("lineName", null);
            }
            object.put("type", (Object)"sequenceFlow");
            object.put("state", (Object)COMPLETE_STATE);
            jsonArray.add((Object)object);
        }
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)jsonArray, JSONObject.class).translate(o -> o.getString("nodeNameTranslateId"), (o, e) -> o.put("name", e)).translate(o -> "sequenceFlow".equals(o.getString("type")) ? o.getString("nodeNameTranslateId") : null, (o, e) -> {
            String[] lineName = new String[]{e};
            o.put("lineName", (Object)lineName);
            BpmWorkflowTranslateUtil.evaluateWidthAndHeight((JSONObject)o, (String)e);
        }).translateList(o -> {
            if ("subProcess".equals(o.getString("type"))) {
                ArrayList<String> tags = new ArrayList<String>();
                JSONArray array = o.getJSONArray("subProcessElements");
                for (int i = 0; i < array.size(); ++i) {
                    tags.add(array.getJSONObject(i).getString("nodeNameTranslateId"));
                }
                return tags;
            }
            return null;
        }, (o, e) -> {
            if ("subProcess".equals(o.getString("type"))) {
                JSONArray array = o.getJSONArray("subProcessElements");
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject object = array.getJSONObject(i);
                    String value = (String)e.get(object.get((Object)"nodeNameTranslateId"));
                    if (!HussarUtils.isNotEmpty((Object)value)) continue;
                    object.put("name", (Object)value);
                }
            }
        }).translateList(o -> {
            if ("subProcess".equals(o.getString("type"))) {
                ArrayList<String> tags = new ArrayList<String>();
                JSONArray array = o.getJSONArray("subProcessElements");
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject object = array.getJSONObject(i);
                    if (!"sequenceFlow".equals(object.getString("type"))) continue;
                    tags.add(object.getString("nodeNameTranslateId"));
                }
                return tags;
            }
            return null;
        }, (o, e) -> {
            if ("subProcess".equals(o.getString("type"))) {
                JSONArray array = o.getJSONArray("subProcessElements");
                for (int i = 0; i < array.size(); ++i) {
                    String value;
                    JSONObject object = array.getJSONObject(i);
                    if (!"sequenceFlow".equals(object.getString("type")) || !HussarUtils.isNotEmpty((Object)(value = (String)e.get(object.get((Object)"nodeNameTranslateId"))))) continue;
                    String[] lineName = new String[]{value};
                    object.put("lineName", (Object)lineName);
                    BpmWorkflowTranslateUtil.evaluateWidthAndHeight((JSONObject)object, (String)value);
                }
            }
        }).execute();
        jsonObject.put("data", (Object)jsonArray);
        jsonObject.put(WIDTH, (Object)flowModel.getWidth());
        jsonObject.put(HEIGHT, (Object)flowModel.getHeight());
        jsonObject.put("workflowStyle", (Object)workFlow.getWorkflowStyle());
        return jsonObject;
    }

    private JSONArray getSubProcessMsg(FlowObject subProcess, Map<String, SysActAssignee> assigneeMap) {
        JSONArray jsonArray = new JSONArray();
        if (subProcess.getSlots() != null) {
            JSONObject object;
            if (subProcess.getSlots().getElement() != null) {
                for (FlowObject flowObject : subProcess.getSlots().getElement()) {
                    JSONObject assignee;
                    SysActAssignee sysActAssignee;
                    FlowAssignment flowAssignment;
                    String realName;
                    object = new JSONObject();
                    object.put("id", (Object)flowObject.getNodeId());
                    object.put("name", (Object)flowObject.getProps().getFlowName());
                    object.put("x", (Object)Double.parseDouble(flowObject.getLeft()));
                    object.put("y", (Object)Double.parseDouble(flowObject.getTop()));
                    object.put(WIDTH, (Object)Double.parseDouble(flowObject.getWidth()));
                    object.put(HEIGHT, (Object)Double.parseDouble(flowObject.getHeight()));
                    object.put("nodeNameTranslateId", (Object)flowObject.getProps().getNodeNameTranslateId());
                    String[] name = flowObject.getName().split("\\.");
                    String subName = name[name.length - 1];
                    if (HussarUtils.equals((Object)"Start", (Object)subName)) {
                        realName = "startEvent";
                    } else if (HussarUtils.equals((Object)"Exclusive", (Object)subName)) {
                        realName = "exclusiveGateway";
                    } else if (HussarUtils.equals((Object)"Parallel", (Object)subName)) {
                        realName = "parallelGateway";
                    } else if (HussarUtils.equals((Object)"Inclusive", (Object)subName)) {
                        realName = "inclusiveGateway";
                    } else if (HussarUtils.equals((Object)"End", (Object)subName)) {
                        realName = "endEvent";
                    } else if (HussarUtils.equals((Object)"ServiceTask", (Object)subName)) {
                        realName = "serviceTask";
                        object.put("taskConfiguration", (Object)flowObject.getProps().getTaskConfiguration());
                    } else if (HussarUtils.equals((Object)"ReceiveTask", (Object)subName)) {
                        realName = "receiveTask";
                        object.put("listener", (Object)flowObject.getProps().getOriginalActivityListener());
                    } else if (HussarUtils.isNotEmpty((Object)flowObject.getProps().getFlowCountersign()) && flowObject.getProps().getFlowCountersign().isCountersign()) {
                        realName = "multiUserTask";
                        flowAssignment = flowObject.getProps().getFlowAssignment();
                        flowAssignment.setDefaultBackCondtion(null);
                        flowAssignment.setJudgeBackCondition(null);
                        flowAssignment.setDefaultProcessKey(null);
                        flowAssignment.setParticipantConfigs(null);
                        object.put("flowAssignment", (Object)flowAssignment);
                        if (assigneeMap != null && (sysActAssignee = assigneeMap.get(flowObject.getId())) != null) {
                            assignee = JSON.parseObject((String)new String(sysActAssignee.getContent(), StandardCharsets.UTF_8));
                            assignee.remove((Object)"participantConfigs");
                            assignee.remove((Object)"judgeBackCondition");
                            assignee.remove((Object)"defaultBackCondtion");
                            object.put("flowAssignment", (Object)assignee);
                        }
                    } else {
                        realName = "userTask";
                        flowAssignment = flowObject.getProps().getFlowAssignment();
                        flowAssignment.setDefaultBackCondtion(null);
                        flowAssignment.setJudgeBackCondition(null);
                        flowAssignment.setDefaultProcessKey(null);
                        flowAssignment.setParticipantConfigs(null);
                        object.put("flowAssignment", (Object)flowAssignment);
                        if (assigneeMap != null && (sysActAssignee = assigneeMap.get(flowObject.getId())) != null) {
                            assignee = JSON.parseObject((String)new String(sysActAssignee.getContent(), StandardCharsets.UTF_8));
                            assignee.remove((Object)"participantConfigs");
                            assignee.remove((Object)"judgeBackCondition");
                            assignee.remove((Object)"defaultBackCondtion");
                            object.put("flowAssignment", (Object)assignee);
                        }
                    }
                    object.put("type", (Object)realName);
                    object.put("state", (Object)COMPLETE_STATE);
                    jsonArray.add((Object)object);
                }
            }
            if (subProcess.getSlots().getPath() != null) {
                for (FlowObject flowObject : subProcess.getSlots().getPath()) {
                    object = new JSONObject();
                    object.put("id", (Object)flowObject.getNodeId());
                    object.put("name", (Object)flowObject.getProps().getFlowName());
                    object.put("rotate", (Object)((FlowSequence)flowObject).getLineConfig().getRotate());
                    object.put("dx", (Object)((FlowSequence)flowObject).getLineConfig().getDx());
                    object.put("nodeNameTranslateId", (Object)flowObject.getProps().getNodeNameTranslateId());
                    if (((FlowSequence)flowObject).getLineConfig().getWidth() != null) {
                        object.put(WIDTH, (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getWidth()));
                    } else {
                        object.put(WIDTH, null);
                    }
                    if (((FlowSequence)flowObject).getLineConfig().getHeight() != null) {
                        object.put(HEIGHT, (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getHeight()));
                    } else {
                        object.put(HEIGHT, null);
                    }
                    if (((FlowSequence)flowObject).getLineConfig().getX() != null) {
                        object.put("x", (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getX()));
                    } else {
                        object.put("x", null);
                    }
                    if (((FlowSequence)flowObject).getLineConfig().getY() != null) {
                        object.put("y", (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getY()));
                    } else {
                        object.put("y", null);
                    }
                    List xyList = flowObject.getPoints();
                    Double[] xPoints = new Double[xyList.size()];
                    Double[] yPoints = new Double[xyList.size()];
                    for (int i = 0; i < xyList.size(); ++i) {
                        xPoints[i] = Double.parseDouble(((FlowSequenceXy)xyList.get(i)).getX());
                        yPoints[i] = Double.parseDouble(((FlowSequenceXy)xyList.get(i)).getY());
                    }
                    object.put("xPoints", (Object)xPoints);
                    object.put("yPoints", (Object)yPoints);
                    List lineNameList = ((FlowSequence)flowObject).getLineConfig().getLineName();
                    if (lineNameList != null) {
                        String[] strs = new String[lineNameList.size()];
                        for (int i = 0; i < lineNameList.size(); ++i) {
                            strs[i] = (String)lineNameList.get(i);
                        }
                        object.put("lineName", (Object)strs);
                    } else {
                        object.put("lineName", null);
                    }
                    object.put("type", (Object)"sequenceFlow");
                    object.put("state", (Object)COMPLETE_STATE);
                    jsonArray.add((Object)object);
                }
            }
        }
        return jsonArray;
    }

    private String getMessageType(FlowElement flowElement) {
        Map extensionElementsNode = flowElement.getExtensionElements();
        if (extensionElementsNode.get("messageType") != null) {
            List list = (List)((ExtensionElement)((List)extensionElementsNode.get("messageType")).get(0)).getAttributes().get("messageType");
            return HussarUtils.isNotEmpty((Object)list) ? ((ExtensionAttribute)list.get(0)).getValue() : null;
        }
        return null;
    }
}

