/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extenddata.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActHiTaskinst;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActHiTaskinstService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ExtendDataDto;
import com.jxdinfo.hussar.workflow.engine.bpm.extenddata.ExtendDataService;
import com.jxdinfo.hussar.workflow.engine.bpm.extenddata.service.WorkflowExtendDataService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.outside.extenddata.service.ExtendDataOutSideService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowExtendDataServiceImpl
implements WorkflowExtendDataService {
    @Autowired(required=false)
    private ExtendDataService extendDataService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private IBpmActHiTaskinstService bpmActHiTaskinstService;
    private static final LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)BpmSpringContextHolder.getBean(LcdpBpmProperties.class);
    private static Logger logger = LogManager.getLogger(WorkflowExtendDataServiceImpl.class);

    public Integer addExtendData(ExtendDataDto extendDataDto) {
        String deploymentModel;
        switch (deploymentModel = lcdpBpmProperties.getDeploymentModel()) {
            case "micro": {
                try {
                    String serviceName = null;
                    String processKey = extendDataDto.getProcessKey();
                    if (HussarUtils.isEmpty((Object)processKey)) {
                        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                        queryWrapper.eq(BpmActHiTaskinst::getId, (Object)extendDataDto.getTaskId());
                        List list = this.bpmActHiTaskinstService.list((Wrapper)queryWrapper);
                        if (HussarUtils.isNotEmpty((Object)list)) {
                            BpmActHiTaskinst bpmActHiTaskinst = (BpmActHiTaskinst)list.get(0);
                            processKey = bpmActHiTaskinst.getProcessKey();
                        } else {
                            return null;
                        }
                    }
                    serviceName = this.modelService.getServiceName(processKey);
                    ExtendDataOutSideService extendDataOutSideService = (ExtendDataOutSideService)BpmSpringContextHolder.getBean(ExtendDataOutSideService.class);
                    return extendDataOutSideService.addExtendData(extendDataDto, serviceName);
                }
                catch (NoSuchBeanDefinitionException e) {
                    return null;
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            case "single": {
                if (this.extendDataService != null) {
                    return this.extendDataService.addExtendData(extendDataDto);
                }
                return null;
            }
        }
        return null;
    }

    public List<Map<String, Object>> getExtendData(List<Long> taskIdList) {
        String deploymentModel;
        switch (deploymentModel = lcdpBpmProperties.getDeploymentModel()) {
            case "micro": {
                try {
                    String taskId = null;
                    if (HussarUtils.isNotEmpty(taskIdList)) {
                        taskId = String.valueOf(taskIdList.get(0));
                    }
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(BpmActHiTaskinst::getId, (Object)taskId);
                    List list = this.bpmActHiTaskinstService.list((Wrapper)queryWrapper);
                    String serviceName = null;
                    if (!HussarUtils.isNotEmpty((Object)list)) {
                        return new ArrayList<Map<String, Object>>();
                    }
                    BpmActHiTaskinst bpmActHiTaskinst = (BpmActHiTaskinst)list.get(0);
                    String processKey = bpmActHiTaskinst.getProcessKey();
                    serviceName = this.modelService.getServiceName(processKey);
                    ExtendDataOutSideService extendDataOutSideService = (ExtendDataOutSideService)BpmSpringContextHolder.getBean(ExtendDataOutSideService.class);
                    return extendDataOutSideService.getExtendData(taskIdList, serviceName);
                }
                catch (NoSuchBeanDefinitionException e) {
                    return new ArrayList<Map<String, Object>>();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return new ArrayList<Map<String, Object>>();
                }
            }
            case "single": {
                if (this.extendDataService != null) {
                    return this.extendDataService.getExtendData(taskIdList);
                }
                return new ArrayList<Map<String, Object>>();
            }
        }
        return new ArrayList<Map<String, Object>>();
    }

    public void deleteExtendData(List<Long> taskIdList, List<Long> procInstIdList) {
        String deploymentModel;
        switch (deploymentModel = lcdpBpmProperties.getDeploymentModel()) {
            case "micro": {
                try {
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    if (HussarUtils.isNotEmpty(taskIdList)) {
                        queryWrapper.eq(BpmActHiTaskinst::getId, (Object)taskIdList.get(0));
                    }
                    if (HussarUtils.isNotEmpty(procInstIdList)) {
                        queryWrapper.eq(BpmActHiTaskinst::getProcInstId, (Object)procInstIdList.get(0));
                    }
                    List list = this.bpmActHiTaskinstService.list((Wrapper)queryWrapper);
                    String serviceName = null;
                    if (HussarUtils.isNotEmpty((Object)list)) {
                        BpmActHiTaskinst bpmActHiTaskinst = (BpmActHiTaskinst)list.get(0);
                        String processKey = bpmActHiTaskinst.getProcessKey();
                        serviceName = this.modelService.getServiceName(processKey);
                    }
                    ExtendDataOutSideService extendDataOutSideService = (ExtendDataOutSideService)BpmSpringContextHolder.getBean(ExtendDataOutSideService.class);
                }
                catch (NoSuchBeanDefinitionException e) {
                    logger.error("\u672a\u53d1\u73b0\u5220\u9664\u6269\u5c55\u6570\u636e\u5b9e\u73b0\u7c7b");
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            case "single": {
                if (this.extendDataService == null) break;
                try {
                    this.extendDataService.deleteExtendData(taskIdList, procInstIdList);
                    break;
                }
                catch (NoSuchBeanDefinitionException e) {
                    logger.error("\u672a\u53d1\u73b0\u5220\u9664\u6269\u5c55\u6570\u636e\u5b9e\u73b0\u7c7b");
                }
            }
        }
    }
}

