/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendCommonConverterUtil;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.ServiceTaskJsonConverter;
import org.apache.commons.lang3.StringUtils;

public class ExtendServiceTaskJsonConverter
extends ServiceTaskJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        ExtendServiceTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        ExtendServiceTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("ServiceTask", ExtendServiceTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(ServiceTask.class, ExtendServiceTaskJsonConverter.class);
    }

    protected String getStencilId(BaseElement baseElement) {
        return "ServiceTask";
    }

    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        ServiceTask serviceTask = (ServiceTask)baseElement;
        ExtendCommonConverterUtil.commonConvertElementToJson(propertiesNode, baseElement);
        if ("mail".equalsIgnoreCase(serviceTask.getType())) {
            this.setPropertyFieldValue("mailtaskto", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskfrom", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtasksubject", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskcc", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskbcc", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtasktext", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskhtml", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskcharset", serviceTask, propertiesNode);
        } else if ("camel".equalsIgnoreCase(serviceTask.getType())) {
            this.setPropertyFieldValue("cameltaskcamelcontext", "camelContext", serviceTask, propertiesNode);
        } else if ("mule".equalsIgnoreCase(serviceTask.getType())) {
            this.setPropertyFieldValue("muletaskendpointurl", "endpointUrl", serviceTask, propertiesNode);
            this.setPropertyFieldValue("muletasklanguage", "language", serviceTask, propertiesNode);
            this.setPropertyFieldValue("muletaskpayloadexpression", "payloadExpression", serviceTask, propertiesNode);
            this.setPropertyFieldValue("muletaskresultvariable", "resultVariable", serviceTask, propertiesNode);
        } else {
            Map elementsListMap;
            if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskclass", serviceTask.getImplementation());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskexpression", serviceTask.getImplementation());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskdelegateexpression", serviceTask.getImplementation());
            }
            if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName())) {
                propertiesNode.put("servicetaskresultvariable", serviceTask.getResultVariableName());
            }
            if ((elementsListMap = serviceTask.getExtensionElements()) != null) {
                List extendExecutionListenerElement;
                List serviceTaskUrl = (List)elementsListMap.get("service_task_url");
                if (serviceTaskUrl != null && !serviceTaskUrl.isEmpty()) {
                    List serviceTaskUrlList;
                    String url = "";
                    Map serviceTaskUrlMap = ((ExtensionElement)serviceTaskUrl.get(0)).getAttributes();
                    if (serviceTaskUrlMap != null && (serviceTaskUrlList = (List)serviceTaskUrlMap.get("service_task_url")) != null && !serviceTaskUrlList.isEmpty()) {
                        url = ((ExtensionAttribute)serviceTaskUrlList.get(0)).getValue();
                    }
                    propertiesNode.put("service_task_url", url);
                }
                if ((extendExecutionListenerElement = (List)elementsListMap.get("extendExecutionListener")) != null && !extendExecutionListenerElement.isEmpty()) {
                    ArrayNode itemsNode = this.objectMapper.createArrayNode();
                    for (ExtensionElement extensionElement : extendExecutionListenerElement) {
                        ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
                        Map maps = extensionElement.getAttributes();
                        if (HussarUtils.isNotEmpty((Object)maps)) {
                            for (Map.Entry map : maps.entrySet()) {
                                propertyItemNode.put((String)map.getKey(), ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                            }
                        }
                        itemsNode.add((JsonNode)propertyItemNode);
                    }
                    propertiesNode.put("extendExecutionListener", (JsonNode)itemsNode);
                }
            }
        }
        this.addFieldExtensions(serviceTask.getFieldExtensions(), propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        JsonNode itemsArrayNode;
        JsonNode fieldsNode;
        ServiceTask task = new ServiceTask();
        ExtendCommonConverterUtil.commonConvertJsonToElement((FlowElement)task, elementNode);
        if (StringUtils.isNotEmpty((CharSequence)this.getPropertyValueAsString("servicetaskclass", elementNode))) {
            task.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
            task.setImplementation(this.getPropertyValueAsString("servicetaskclass", elementNode));
        } else if (StringUtils.isNotEmpty((CharSequence)this.getPropertyValueAsString("servicetaskexpression", elementNode))) {
            task.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION);
            task.setImplementation(this.getPropertyValueAsString("servicetaskexpression", elementNode));
        } else if (StringUtils.isNotEmpty((CharSequence)this.getPropertyValueAsString("servicetaskdelegateexpression", elementNode))) {
            task.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
            task.setImplementation(this.getPropertyValueAsString("servicetaskdelegateexpression", elementNode));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPropertyValueAsString("servicetaskresultvariable", elementNode))) {
            task.setResultVariableName(this.getPropertyValueAsString("servicetaskresultvariable", elementNode));
        }
        if ((fieldsNode = this.getProperty("servicetaskfields", elementNode)) != null && (itemsArrayNode = fieldsNode.get("fields")) != null) {
            for (JsonNode itemNode : itemsArrayNode) {
                JsonNode nameNode = itemNode.get("name");
                if (nameNode == null || !StringUtils.isNotEmpty((CharSequence)nameNode.asText())) continue;
                FieldExtension field = new FieldExtension();
                field.setFieldName(nameNode.asText());
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("stringValue", itemNode))) {
                    field.setStringValue(this.getValueAsString("stringValue", itemNode));
                } else if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("string", itemNode))) {
                    field.setStringValue(this.getValueAsString("string", itemNode));
                } else if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("expression", itemNode))) {
                    field.setExpression(this.getValueAsString("expression", itemNode));
                }
                task.getFieldExtensions().add(field);
            }
        }
        ExtensionElement urlExtensionElementNode = new ExtensionElement();
        ExtensionAttribute urlExtensionAttributeNode = new ExtensionAttribute();
        String urlConfiguration = this.getPropertyValueAsString("service_task_url", elementNode);
        urlExtensionElementNode.setName("service_task_url");
        urlExtensionElementNode.setNamespacePrefix("extend");
        urlExtensionElementNode.setNamespace("http://activiti.org/bpmn");
        urlExtensionAttributeNode.setName("service_task_url");
        urlExtensionAttributeNode.setValue(urlConfiguration);
        urlExtensionElementNode.addAttribute(urlExtensionAttributeNode);
        task.addExtensionElement(urlExtensionElementNode);
        ArrayNode executionListener = (ArrayNode)this.getProperty("extendExecutionListener", elementNode);
        if (HussarUtils.isNotEmpty((Object)executionListener)) {
            for (JsonNode jsonNode : executionListener) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendExecutionListener");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute eventAttribute = new ExtensionAttribute();
                eventAttribute.setName("event");
                eventAttribute.setValue(jsonNode.get("event").toString().replace("\"", ""));
                extensionElement.addAttribute(eventAttribute);
                ExtensionAttribute typeAttribute = new ExtensionAttribute();
                typeAttribute.setName("type");
                typeAttribute.setValue(jsonNode.get("type").toString().replace("\"", ""));
                extensionElement.addAttribute(typeAttribute);
                ExtensionAttribute urlAttribute = new ExtensionAttribute();
                urlAttribute.setName("url");
                urlAttribute.setValue(jsonNode.get("url").toString().replace("\"", ""));
                extensionElement.addAttribute(urlAttribute);
                task.addExtensionElement(extensionElement);
            }
        }
        return task;
    }

    protected void setPropertyFieldValue(String name, ServiceTask task, ObjectNode propertiesNode) {
        for (FieldExtension extension : task.getFieldExtensions()) {
            if (!name.substring(8).equalsIgnoreCase(extension.getFieldName())) continue;
            if (StringUtils.isNotEmpty((CharSequence)extension.getStringValue())) {
                this.setPropertyValue(name, extension.getStringValue(), propertiesNode);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)extension.getExpression())) continue;
            this.setPropertyValue(name, extension.getExpression(), propertiesNode);
        }
    }

    protected void setPropertyFieldValue(String propertyName, String fieldName, ServiceTask task, ObjectNode propertiesNode) {
        for (FieldExtension extension : task.getFieldExtensions()) {
            if (!fieldName.equalsIgnoreCase(extension.getFieldName())) continue;
            if (StringUtils.isNotEmpty((CharSequence)extension.getStringValue())) {
                this.setPropertyValue(propertyName, extension.getStringValue(), propertiesNode);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)extension.getExpression())) continue;
            this.setPropertyValue(propertyName, extension.getExpression(), propertiesNode);
        }
    }
}

