/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendCommonConverterUtil;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.CancelEventDefinition;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.TerminateEventDefinition;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.activiti.editor.language.json.converter.EndEventJsonConverter;
import org.apache.commons.lang3.StringUtils;

public class ExtendEndEventJsonConverter
extends EndEventJsonConverter {
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        ExtendCommonConverterUtil.commonConvertElementToJson(propertiesNode, baseElement);
        EndEvent endEvent = (EndEvent)baseElement;
        this.addEventProperties((Event)endEvent, propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        EndEvent endEvent = new EndEvent();
        ExtendCommonConverterUtil.commonConvertJsonToElement((FlowElement)endEvent, elementNode);
        String stencilId = BpmnJsonConverterUtil.getStencilId((JsonNode)elementNode);
        if ("EndErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, (Event)endEvent);
        } else if ("EndCancelEvent".equals(stencilId)) {
            CancelEventDefinition eventDefinition = new CancelEventDefinition();
            endEvent.getEventDefinitions().add(eventDefinition);
        } else if ("EndTerminateEvent".equals(stencilId)) {
            TerminateEventDefinition eventDefinition = new TerminateEventDefinition();
            String terminateAllStringValue = this.getPropertyValueAsString("terminateall", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)terminateAllStringValue)) {
                eventDefinition.setTerminateAll("true".equals(terminateAllStringValue));
            }
            endEvent.getEventDefinitions().add(eventDefinition);
        }
        return endEvent;
    }
}

