/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskEndBatchCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.UnexpectedException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;

public class ProcessEndBatchCmd
extends AddAttributeCmd<Void> {
    private DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getSpringContext().getBean(DataPushService.class);
    private HistoryService historyService = (HistoryService)BpmSpringContextHolder.getSpringContext().getBean(HistoryService.class);
    private RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getSpringContext().getBean(RepositoryService.class);
    private RuntimeService runtimeService = (RuntimeService)BpmSpringContextHolder.getSpringContext().getBean(RuntimeService.class);
    private TaskService taskService = (TaskService)BpmSpringContextHolder.getSpringContext().getBean(TaskService.class);
    private String taskId;
    private String userId;
    private String mandator;
    private String comment;
    private String instanceId;
    private String type;
    private boolean isMainEndProcess;
    private String processDefinitionId;
    private String businessId;
    private Map<String, Object> paramMap;

    public ProcessEndBatchCmd(String userId, String mandator, String comment, String instanceId, String businessId, String processDefinitionId, String type) {
        this.userId = userId;
        this.mandator = mandator;
        this.comment = comment;
        this.instanceId = instanceId;
        this.businessId = businessId;
        this.processDefinitionId = processDefinitionId;
        this.type = type;
        this.isMainEndProcess = true;
    }

    public ProcessEndBatchCmd(String userId, String mandator, String comment, Map<String, Object> paramMap, String instanceId, String businessId, String processDefinitionId, String type) {
        this.userId = userId;
        this.mandator = mandator;
        this.comment = comment;
        this.instanceId = instanceId;
        this.businessId = businessId;
        this.processDefinitionId = processDefinitionId;
        this.type = type;
        this.isMainEndProcess = true;
        this.paramMap = paramMap;
    }

    public ProcessEndBatchCmd(String userId, String mandator, String comment, String instanceId, String businessId, String processDefinitionId, String type, boolean isMainEndProcess) {
        this.userId = userId;
        this.mandator = mandator;
        this.comment = comment;
        this.instanceId = instanceId;
        this.businessId = businessId;
        this.processDefinitionId = processDefinitionId;
        this.type = type;
        this.isMainEndProcess = isMainEndProcess;
    }

    public ProcessEndBatchCmd(String taskId, String userId, String mandator, String comment, String instanceId, String businessId, String processDefinitionId, String type, boolean isMainEndProcess) {
        this.taskId = taskId;
        this.userId = userId;
        this.mandator = mandator;
        this.comment = comment;
        this.instanceId = instanceId;
        this.businessId = businessId;
        this.processDefinitionId = processDefinitionId;
        this.type = type;
        this.isMainEndProcess = isMainEndProcess;
    }

    public Void execute(CommandContext commandContext) {
        this.addAttribute(commandContext);
        ExecutionEntity processInstance = commandContext.getExecutionEntityManager().findExecutionById(this.instanceId);
        this.addExecutionAttribute(processInstance);
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(this.processDefinitionId);
        commandContext.addAttribute("endTriggerAction", (Object)"terminate");
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            List taskIds = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(this.instanceId)).list().stream().map(TaskInfo::getId).collect(Collectors.toList());
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.instanceId).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setProcessInsId(this.instanceId);
            dataPush.setUserId(this.userId);
            dataPush.setComment(this.comment);
            dataPush.setConsignor(this.mandator);
            dataPush.setTaskId(this.taskId);
            dataPush.setTaskIds(taskIds);
            dataPush.setProcessDefinitionId(historicProcessInstance.getProcessDefinitionId());
            dataPush.setProcessKey(historicProcessInstance.getProcessDefinitionKey());
            dataPush.setEndDate(new Date());
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            this.dataPushService.endProcess(dataPush);
        }
        List list = commandContext.getDbSqlSession().findAliveEntityInCache(HistoricActivityInstanceEntity.class);
        list.removeIf(e -> !this.instanceId.equals(e.getProcessInstanceId()));
        if (!list.isEmpty()) {
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)list.get(0);
            ActivityImpl destinationActivity = null;
            ActivityImpl currentActivity = null;
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicActivityInstance.getProcessDefinitionId());
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (pvmTransitionList.isEmpty()) {
                    destinationActivity = activityImpl;
                }
                if (!activityImpl.getId().equals(historicActivityInstance.getActivityId())) continue;
                currentActivity = activityImpl;
            }
            if (destinationActivity == null) {
                throw new BpmException(BpmExceptionCodeEnum.END_NODE_NOT_FOUND);
            }
            commandContext.addAttribute("activitiId", (Object)currentActivity.getId());
            List executionEntityList = commandContext.getDbSqlSession().findAliveEntityInCache(ExecutionEntity.class);
            ExecutionEntity executionEntity = (ExecutionEntity)executionEntityList.get(0);
            if (processInstance.getId().equals(executionEntity.getProcessInstanceId())) {
                while (executionEntity.getExecutions() != null && !executionEntity.getExecutions().isEmpty()) {
                    executionEntity = (ExecutionEntity)executionEntity.getExecutions().get(0);
                }
            }
            ParallelJumpTaskEndBatchCmd parallelJumpTaskEndBatchCmd = new ParallelJumpTaskEndBatchCmd(this.taskId, this.userId, this.mandator, executionEntity.getId(), new JumpModel(0).setJumpTo(destinationActivity.getId()), this.comment, this.paramMap, null, new HashMap<String, Object>(), currentActivity);
            if ("endProcess".equals(this.type)) {
                parallelJumpTaskEndBatchCmd.setProcessEventType("process_end");
                if (!this.isMainEndProcess) {
                    parallelJumpTaskEndBatchCmd.addParam("sub_process", "sub_process_end");
                }
            }
            if ("revokeProcess".equals(this.type)) {
                parallelJumpTaskEndBatchCmd.setProcessEventType("process_revoke");
                if (!this.isMainEndProcess) {
                    parallelJumpTaskEndBatchCmd.addParam("sub_process", "sub_process_revoke");
                }
            }
            parallelJumpTaskEndBatchCmd.execute(commandContext);
            if ("revokeProcess".equals(this.type)) {
                HistoricProcessInstanceEntity historicProcessInstance = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(this.instanceId);
                historicProcessInstance.setDeleteReason("revokeProcess");
            } else if ("endProcess".equals(this.type)) {
                HistoricProcessInstanceEntity historicProcessInstance = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(this.instanceId);
                historicProcessInstance.setDeleteReason("endProcess");
            }
            return null;
        }
        return null;
    }

    public ProcessEndBatchCmd addExecutionAttribute(String taskSourceFlag, boolean isMain) {
        this.addExecutionAttribute((ExecutionEntity execution) -> {
            String executionTaskSourceFlag;
            if (TaskSourceFlag.END.contains(taskSourceFlag)) {
                executionTaskSourceFlag = isMain ? taskSourceFlag : "main_end";
            } else if (TaskSourceFlag.isReject((String)taskSourceFlag)) {
                executionTaskSourceFlag = "sub_end_reject";
            } else if (TaskSourceFlag.isRevoke((String)taskSourceFlag)) {
                executionTaskSourceFlag = "sub_end_revoke";
            } else if (TaskSourceFlag.isFreeJump((String)taskSourceFlag)) {
                executionTaskSourceFlag = "sub_end_jump";
            } else if ("revokeProcess".equals(taskSourceFlag)) {
                executionTaskSourceFlag = "revokeProcess";
            } else {
                throw new UnexpectedException("\u672a\u77e5\u7684\u529e\u7406\u65b9\u5f0f\uff01");
            }
            execution.addTempVariable("taskSourceFlag", (Object)executionTaskSourceFlag);
        });
        return this;
    }
}

