/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.CompleteLeapCheckInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmHistoryTask;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;

public class CompleteLeapCheckTaskCmd
extends AddAttributeCmd<CompleteLeapCheckInfo> {
    private TaskEntity task;
    private CommandContext commandContext;

    public CompleteLeapCheckTaskCmd() {
    }

    public CompleteLeapCheckTaskCmd(TaskEntity task) {
        this.task = task;
    }

    public CompleteLeapCheckInfo execute(CommandContext commandContext) {
        this.commandContext = commandContext;
        Object lastRejectTask = TaskSourceFlag.isReject((String)this.task.getCompleteType()) && this.task.getJumpInfo() != null ? this.task : BpmHistoryTask.getLastRejectTask(this.task.getProcessInstanceId(), this.task.getSubProcessKey(), this.task.getTaskDefinitionKey());
        CompleteLeapCheckInfo completeLeapCheckInfo = new CompleteLeapCheckInfo();
        if (lastRejectTask == null) {
            return completeLeapCheckInfo;
        }
        JumpInfo jumpInfo = JumpInfo.toJumpInfo((String)lastRejectTask.getJumpInfo());
        List rejectTo = jumpInfo.getJumpTo();
        List rejectFrom = jumpInfo.getJumpFrom();
        if (HussarUtils.isEmpty((Object)rejectFrom)) {
            return completeLeapCheckInfo;
        }
        if (!rejectTo.contains(this.task.getTaskDefinitionKey())) {
            return completeLeapCheckInfo;
        }
        Map<String, Object> objectMap = this.getBackTypeWithTasks(rejectFrom, (Task)this.task);
        if (objectMap == null) {
            return completeLeapCheckInfo;
        }
        String targetGateway = null;
        if (rejectTo.size() == 1) {
            Set affectedTasks = (Set)objectMap.get("affectedTasks");
            if (affectedTasks.size() != 1 && !affectedTasks.contains(this.task.getTaskDefinitionKey())) {
                return completeLeapCheckInfo;
            }
        } else {
            HashSet rejectToNodes = new HashSet(rejectTo);
            targetGateway = this.recentSharedGateway(new ArrayList<String>(rejectFrom), this.task.getProcessDefinitionId());
            boolean isCompleteLeap = true;
            Set affectedUserTasks = (Set)objectMap.get("affectedUserTasks");
            Map affectedExecution = (Map)objectMap.get("affectedExecution");
            Set affectedCallActicity = (Set)objectMap.get("affectedCallActivity");
            Set affectedSubProcess = (Set)objectMap.get("affectedSubProcess");
            if (HussarUtils.isNotEmpty((Object)affectedCallActicity) || HussarUtils.isNotEmpty((Object)affectedSubProcess)) {
                isCompleteLeap = false;
            } else if (affectedExecution.size() > 1 || affectedExecution.size() == 1 && !affectedExecution.containsKey(targetGateway)) {
                isCompleteLeap = false;
            } else if (rejectToNodes.size() < affectedExecution.size() || rejectToNodes.addAll(affectedUserTasks)) {
                isCompleteLeap = false;
            } else {
                List targetGatewayExecution = affectedExecution.get(targetGateway) != null ? (List)affectedExecution.get(targetGateway) : new ArrayList();
                List runningRejectTasks = commandContext.getTaskEntityManager().findTasksByProcessInstanceId(this.task.getProcessInstanceId()).stream().filter(arg_0 -> CompleteLeapCheckTaskCmd.lambda$execute$0(affectedUserTasks, (TaskInfo)lastRejectTask, arg_0)).collect(Collectors.toList());
                HashSet<String> runningRejectNode = new HashSet<String>();
                for (Task runningRejectTask : runningRejectTasks) {
                    if (runningRejectNode.add(runningRejectTask.getTaskDefinitionKey()) || rejectTo.equals(runningRejectTask.getJumpInfo() == null ? null : JumpInfo.toJumpInfo((String)runningRejectTask.getJumpInfo()).getJumpTo())) continue;
                    isCompleteLeap = false;
                    break;
                }
                if (isCompleteLeap && rejectTo.size() != runningRejectNode.size() + targetGatewayExecution.size()) {
                    isCompleteLeap = false;
                }
            }
            if (!isCompleteLeap) {
                return completeLeapCheckInfo;
            }
        }
        completeLeapCheckInfo.setCompleteLeap(true);
        completeLeapCheckInfo.setJumpInfo(jumpInfo);
        completeLeapCheckInfo.setObjectMap(objectMap);
        completeLeapCheckInfo.setTargetGateway(targetGateway);
        if (jumpInfo.isJumpExecution()) {
            List list = commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricVariableInstanceQuery().taskId(lastRejectTask.getId()).list();
            for (HistoricVariableInstance historicVariableInstance : list) {
                if (!"jump_execution_info".equals(historicVariableInstance.getVariableName())) continue;
                completeLeapCheckInfo.setRejectExecution((List)historicVariableInstance.getValue());
                break;
            }
        }
        return completeLeapCheckInfo;
    }

    private String recentSharedGateway(List<String> nodes, String procDefId) {
        Collections.sort(nodes);
        String node = nodes.get(0);
        BpmnModel bm = this.commandContext.getProcessEngineConfiguration().getDeploymentManager().getBpmnModelById(procDefId);
        FlowElement flowElement = bm.getFlowElement(node);
        while (!(flowElement instanceof Gateway) || flowElement instanceof ExclusiveGateway) {
            SequenceFlow sequenceFlow = (SequenceFlow)((FlowNode)flowElement).getIncomingFlows().get(0);
            if (!((flowElement = bm.getFlowElement(sequenceFlow.getSourceRef())) instanceof StartEvent)) continue;
            throw new BpmException(BpmExceptionCodeEnum.NO_PUBLIC_GATEWAY);
        }
        return flowElement.getId();
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> getBackTypeWithTasks(Collection<String> nodeIds, Task task) {
        if (nodeIds.isEmpty()) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<String> affectedTasks = new HashSet<String>();
        HashSet affectedUserTasks = new HashSet();
        int newNum = 1;
        ArrayList<String> taskIds = new ArrayList<String>();
        HashSet<String> runningActivityNodeIds = new HashSet<String>();
        String processInstanceId = task.getProcessInstanceId();
        String processDefinitionId = task.getProcessDefinitionId();
        String taskDefinitionKey = task.getTaskDefinitionKey();
        String subProcessKey = task.getSubProcessKey();
        BpmnModel bm = this.commandContext.getProcessEngineConfiguration().getDeploymentManager().getBpmnModelById(processDefinitionId);
        if (task.getSubProcessKey() != null) {
            for (String nodeId : nodeIds) {
                if (bm.getMainProcess().getFlowElement(nodeId) == null) continue;
                return null;
            }
        }
        boolean isSubProcessJump = false;
        if (bm.getMainProcess().getFlowElement(nodeIds.iterator().next()) != null) {
            isSubProcessJump = true;
            subProcessKey = null;
        }
        List list = this.commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().activityType("callActivity").list();
        for (Object historicActivityInstance : list) {
            runningActivityNodeIds.add(historicActivityInstance.getActivityId());
        }
        result.put("runningActivitiNodeIds", runningActivityNodeIds);
        HashSet<String> runningSubProcessNodeIds = new HashSet<String>();
        if (!isSubProcessJump) {
            list = this.commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().activityType("subProcess").list();
            for (Object historicActivityInstance : list) {
                runningSubProcessNodeIds.add(historicActivityInstance.getActivityId());
            }
        }
        result.put("runningSubProcessNodeIds", runningSubProcessNodeIds);
        List executions = this.commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(processInstanceId);
        for (ExecutionEntity executionEntity : executions) {
            if (executionEntity.isScope() || executionEntity.getActivityId() == null || executionEntity.getSubProcessKey() != null && !Objects.equals(subProcessKey, executionEntity.getSubProcessKey())) continue;
            taskIds.add(executionEntity.getActivityId());
        }
        taskIds.addAll(runningActivityNodeIds);
        taskIds.addAll(runningSubProcessNodeIds);
        taskIds = new ArrayList(new HashSet(taskIds));
        if (taskIds.size() > 1) {
            for (String string : nodeIds) {
                if (!HussarUtils.isEmpty((Object)bm.getFlowElement(string))) continue;
                throw new BpmException(BpmExceptionCodeEnum.NODE_NOT_FOUND);
            }
            boolean isFindTask = false;
            for (String string : nodeIds) {
                Map<String, Set<String>> map = this.findAffectedTask(bm, string, true, taskIds);
                affectedTasks.addAll((Collection)map.get("affectedTasks"));
                affectedUserTasks.addAll(map.get("affectedUserTasks"));
            }
            if (affectedTasks.contains(taskDefinitionKey)) {
                isFindTask = true;
                affectedTasks.remove(taskDefinitionKey);
            }
            if (!affectedTasks.isEmpty()) {
                newNum = 3;
            }
            if (!isFindTask) {
                void var19_28;
                HashSet hashSet = new HashSet();
                if (!affectedTasks.isEmpty()) {
                    HashSet<String> hashSet2 = affectedTasks;
                }
                for (String nodeId : nodeIds) {
                    Map<String, Set<String>> map = this.findAffectedTask(bm, nodeId, false, taskIds);
                    affectedTasks.addAll((Collection)map.get("affectedTasks"));
                    affectedUserTasks.addAll(map.get("affectedUserTasks"));
                }
                if (affectedTasks.contains(taskDefinitionKey)) {
                    isFindTask = true;
                    affectedTasks.remove(taskDefinitionKey);
                }
                if (!affectedTasks.isEmpty()) {
                    newNum = 3;
                }
                if (!isFindTask && affectedTasks.size() + var19_28.size() > 0) {
                    newNum = -1;
                }
            }
        }
        HashSet<String> affectedCallActivity = new HashSet<String>();
        for (String string : runningActivityNodeIds) {
            if (!affectedTasks.contains(string)) continue;
            affectedCallActivity.add(string);
        }
        affectedUserTasks.addAll(affectedCallActivity);
        HashSet<String> hashSet = new HashSet<String>();
        for (String activityId : runningSubProcessNodeIds) {
            if (!affectedTasks.contains(activityId)) continue;
            hashSet.add(activityId);
        }
        affectedUserTasks.addAll(hashSet);
        HashMap hashMap = new HashMap();
        for (ExecutionEntity execution1 : executions) {
            List<Map> affectedExecutionList;
            if (execution1.isScope() || execution1.getActivityId() == null || affectedUserTasks.contains(execution1.getActivityId()) || !affectedTasks.contains(execution1.getActivityId()) || subProcessKey != null && !subProcessKey.equals(execution1.getSubProcessKey())) continue;
            if (hashMap.get(execution1.getActivityId()) != null) {
                affectedExecutionList = (List)hashMap.get(execution1.getActivityId());
                affectedExecutionList.add(execution1.getVariablesLocal());
                continue;
            }
            affectedExecutionList = new ArrayList<Map>();
            affectedExecutionList.add(execution1.getVariablesLocal());
            hashMap.put(execution1.getActivityId(), affectedExecutionList);
        }
        result.put("affectedExecution", hashMap);
        affectedTasks.add(taskDefinitionKey);
        result.put("affectedTasks", affectedTasks);
        result.put("affectedUserTasks", affectedUserTasks);
        result.put("affectedCallActivity", affectedCallActivity);
        result.put("affectedSubProcess", hashSet);
        result.put("num", newNum);
        return result;
    }

    private Map<String, Set<String>> findAffectedTask(BpmnModel bm, String nodeId, boolean isGoToNext, List<String> taskIds) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        HashSet<String> affectedTasks = new HashSet<String>();
        HashSet<String> affectedUserTasks = new HashSet<String>();
        flowElements.add(bm.getFlowElement(nodeId));
        HashSet<FlowElement> list = new HashSet<FlowElement>();
        for (int i = 0; i < flowElements.size(); ++i) {
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            if (!list.add(flowElement)) continue;
            if (taskIds.contains(flowElement.getId())) {
                affectedTasks.add(flowElement.getId());
                if (flowElement instanceof UserTask) {
                    affectedUserTasks.add(flowElement.getId());
                    continue;
                }
            }
            if (flowElement instanceof EndEvent || flowElement instanceof StartEvent || !(flowElement instanceof FlowNode)) continue;
            if (isGoToNext) {
                for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getOutgoingFlows()) {
                    flowElements.add(bm.getFlowElement(sequenceFlow.getTargetRef()));
                }
                continue;
            }
            for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getIncomingFlows()) {
                flowElements.add(bm.getFlowElement(sequenceFlow.getSourceRef()));
            }
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("affectedTasks", affectedTasks);
        map.put("affectedUserTasks", affectedUserTasks);
        return map;
    }

    private static /* synthetic */ boolean lambda$execute$0(Set affectedUserTasks, TaskInfo lastRejectTask, TaskEntity o) {
        return affectedUserTasks.contains(o.getTaskDefinitionKey()) && Objects.equals(o.getSubProcessKey(), lastRejectTask.getSubProcessKey());
    }
}

