/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ExtendDataDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.StartAndCompleteFinalPushCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extenddata.service.WorkflowExtendDataService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;

public class StartAndCompleteCmd
extends AddAttributeCmd<ProcessInstance> {
    private WorkflowExtendDataService workflowExtendDataService = (WorkflowExtendDataService)BpmSpringContextHolder.getBean(WorkflowExtendDataService.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)BpmSpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)BpmSpringContextHolder.getBean(ISysActCcTaskService.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)BpmSpringContextHolder.getBean(BpmConstantProperties.class);
    private String processDefinitionId;
    private String businessKey;
    private String comment;
    private String userId;
    private String processTitle;
    private String dataDetail;
    private Map<String, Object> variables;
    private Map<String, Object> paramMap;

    public StartAndCompleteCmd(String processDefinitionId, String businessKey, String comment, String userId, String processTitle, String dataDetail, Map<String, Object> variables, Map<String, Object> paramMap) {
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.comment = comment;
        this.userId = userId;
        this.processTitle = processTitle;
        this.dataDetail = dataDetail;
        this.variables = variables;
        this.paramMap = paramMap;
    }

    public ProcessInstance execute(CommandContext commandContext) {
        commandContext.addAttribute("no_data_push_handle_flag", (Object)"true");
        commandContext.addAttribute("ACTIVITI_START_AND_COMPLETE_TAG", (Object)"true");
        this.addAttribute(commandContext);
        commandContext.addAttribute("handleType", (Object)"start");
        ExecutionEntity processInstance = this.start(commandContext);
        List tasks = processInstance.getTasks();
        if (HussarUtils.isEmpty((Object)tasks)) {
            tasks = commandContext.getDbSqlSession().findInCache(TaskEntity.class);
        }
        TaskEntity taskEntity = (TaskEntity)tasks.get(0);
        if (tasks.size() == 1) {
            IdentityLinkEntity identityLinkEntity;
            Iterator iterator = taskEntity.getIdentityLinks().iterator();
            while (iterator.hasNext() && !this.userId.equals((identityLinkEntity = (IdentityLinkEntity)iterator.next()).getUserId()) && !this.userId.equals(identityLinkEntity.getMandator())) {
            }
        } else {
            for (TaskEntity task : tasks) {
                if (this.userId.equals(((IdentityLinkEntity)task.getIdentityLinks().get(0)).getUserId()) && ((IdentityLinkEntity)task.getIdentityLinks().get(0)).getMandator() == null) {
                    taskEntity = task;
                    break;
                }
                if (!this.userId.equals(((IdentityLinkEntity)task.getIdentityLinks().get(0)).getMandator())) continue;
                taskEntity = task;
                break;
            }
        }
        taskEntity.setAssignee(this.userId, true, true);
        if (HussarUtils.isNotEmpty(this.paramMap) && this.workflowExtendDataService != null) {
            ExtendDataDto extendDataDto = new ExtendDataDto();
            extendDataDto.setTaskId(taskEntity.getId());
            extendDataDto.setExtendData(this.paramMap);
            extendDataDto.setProcessKey(taskEntity.getProcessKey());
            this.workflowExtendDataService.addExtendData(extendDataDto);
        }
        this.addExecutionAttribute(processInstance);
        processInstance.addTempVariable("taskSourceFlag", (Object)"complete");
        this.complete(commandContext, taskEntity);
        commandContext.removeAttribute("no_data_push_handle_flag");
        new StartAndCompleteFinalPushCmd(processInstance.getId(), this.userId, this.comment).execute(commandContext);
        return processInstance;
    }

    private ExecutionEntity start(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = commandContext.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("No process definition found for id = '" + this.processDefinitionId + "'", ProcessDefinition.class);
        }
        if (processDefinition.isSuspended()) {
            throw new ActivitiException(processDefinition.getName() + "\u5df2\u6302\u8d77");
        }
        String organId = processDefinition.getProcessTag();
        String processKey = this.processDefinitionId.split(":")[0];
        List list = commandContext.getModelEntityManager().createNewModelQuery().modelKey(processKey).organId(organId).list();
        for (Model model : list) {
            if (!"0".equals(model.getModelStatus())) continue;
            throw new ActivitiException(processDefinition.getName() + "\u5df2\u6302\u8d77");
        }
        processDefinition.setProcessTitle(this.processTitle);
        processDefinition.setDataDetail(this.dataDetail);
        ExecutionEntity processInstance = processDefinition.createEmulationProcessInstance(this.businessKey, null);
        this.addExecutionAttribute(processInstance);
        Object securityLevel = this.variables.remove("security_level");
        if (securityLevel != null) {
            if (securityLevel instanceof Integer) {
                commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInstance.getId()).setSecurityLevel((Integer)securityLevel);
            } else {
                throw new BpmException(bpmConstantProperties.getErrorSecretLevelType());
            }
        }
        this.initializeVariables(processInstance);
        processInstance.fireEventExecution("beforeStart");
        processInstance.start();
        return processInstance;
    }

    private void complete(CommandContext commandContext, TaskEntity taskEntity) {
        Object isPushMobileMessage;
        if (HussarUtils.isNotEmpty(this.paramMap) && HussarUtils.isNotEmpty((Object)(isPushMobileMessage = this.paramMap.get("isPushMobileMessage")))) {
            commandContext.addAttribute("isPushMobileMessage", (Object)Boolean.valueOf(isPushMobileMessage.toString()));
        }
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(this.userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(taskEntity.getId());
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        commandContext.addAttribute("bpm_submit_source", (Object)taskEntity.getTaskDefinitionKey());
        taskEntity.getExecution().setAllPrevNode(taskEntity.getTaskDefinitionKey());
        if (taskEntity.getDelegationState() != null) {
            taskEntity.resolve();
        }
        taskEntity.fireEvent("beforeComplete");
        if (taskEntity.getExecutionId() != null) {
            taskEntity.setExecutionVariables(this.variables);
        } else {
            taskEntity.setVariables(this.variables);
        }
        ParamModel paramModel = this.getParamModel(taskEntity, this.variables);
        Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
        taskEntity.complete(this.variables, false, null);
        if (HussarUtils.isNotEmpty((Object)taskEntity.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(taskEntity.getId());
        }
        LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)ccQueryWrapper.eq(SysActCcTask::getTaskDefKey, (Object)taskEntity.getTaskDefinitionKey())).eq(SysActCcTask::getProcessInsId, (Object)Long.parseLong(taskEntity.getProcessInstanceId()))).in(SysActCcTask::getReceiveUser, new Object[]{this.userId})).eq(SysActCcTask::getTaskState, (Object)"0");
        List ccTaskList = this.iSysActCcTaskService.list((Wrapper)ccQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)ccTaskList)) {
            ArrayList<Long> ccTaskIds = new ArrayList<Long>();
            for (SysActCcTask sysActCcTask : ccTaskList) {
                ccTaskIds.add(sysActCcTask.getId());
            }
            this.iSysActCcTaskService.readBatch(ccTaskIds);
        }
    }

    protected void initializeVariables(ExecutionEntity processInstance) {
        if (this.variables != null) {
            processInstance.setVariables(this.variables);
        }
    }

    public ParamModel getParamModel(TaskEntity task, Map<String, Object> variables) {
        ParamModel paramModel = new ParamModel();
        paramModel.mappingCompleteType(BpmAttribute.getTaskSourceFlag(task));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        paramModel.setHandler(this.userId);
        paramModel.setLastNodeId(task.getTaskDefinitionKey());
        paramModel.setLastTaskId(task.getId());
        paramModel.setLastNodeName(task.getName());
        paramModel.mappingLastCompleteType(BpmAttribute.getTaskSourceFlag(task));
        paramModel.setLastNodeHandler(this.userId);
        paramModel.setSendUser(this.userId);
        paramModel.setCreateReason("completeCreate");
        return paramModel;
    }
}

