/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processtest.service;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.processtest.dao.TestLogDetailMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.translate.util.BpmTranslateUtil;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.SysActTestDetail;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.TestLogDetailService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.TestLogService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestLogDetailServiceImpl
extends HussarServiceImpl<TestLogDetailMapper, SysActTestDetail>
implements TestLogDetailService {
    @Autowired
    private TestLogService testLogService;

    public ApiResponse<?> getAllWorkflowLog(String procInstId, String businessId) {
        List detailList = (List)this.getWorkflowLog(procInstId, businessId).getData();
        if (HussarUtils.isNotEmpty((Object)detailList)) {
            Long parentLogId = ((SysActTestDetail)detailList.get(0)).getLogId();
            List<SysActTestDetail> list = this.getLogByParentId(String.valueOf(parentLogId));
            return ApiResponse.success(list);
        }
        return ApiResponse.success(new ArrayList());
    }

    public ApiResponse<?> getWorkflowLog(String procInstId, String businessId) {
        if (HussarUtils.isNotEmpty((Object)procInstId)) {
            List list = new ArrayList();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysActTestDetail::getProcInstId, (Object)Long.valueOf(procInstId));
            queryWrapper.orderByAsc(SysActTestDetail::getEndTime);
            if (HussarUtils.isNotEmpty((Object)businessId)) {
                queryWrapper.eq(SysActTestDetail::getBusinessId, (Object)businessId);
            }
            list = this.list((Wrapper)queryWrapper);
            return ApiResponse.success(list);
        }
        return ApiResponse.success(new ArrayList());
    }

    public ApiResponse<?> getErrorLog(String procInstId, String businessId) {
        List list = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActTestDetail::getProcInstId, (Object)Long.valueOf(procInstId));
        queryWrapper.eq(SysActTestDetail::getTestResult, (Object)false);
        queryWrapper.orderByAsc(SysActTestDetail::getCreateTime);
        if (HussarUtils.isNotEmpty((Object)businessId)) {
            queryWrapper.eq(SysActTestDetail::getBusinessId, (Object)businessId);
        }
        list = this.list((Wrapper)queryWrapper);
        return ApiResponse.success(list);
    }

    public ApiResponse<?> saveParentLog(JSONArray jsonArray) {
        return new ApiResponse();
    }

    public ApiResponse<?> deleteWorkflowLog(String procInstId, String businessId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActTestDetail::getProcInstId, (Object)Long.valueOf(procInstId));
        if (HussarUtils.isNotEmpty((Object)businessId)) {
            queryWrapper.eq(SysActTestDetail::getBusinessId, (Object)businessId);
        }
        this.remove((Wrapper)queryWrapper);
        return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
    }

    private List<SysActTestDetail> getLogByParentId(String parentId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActTestDetail::getLogId, (Object)Long.valueOf(parentId));
        queryWrapper.orderByAsc(SysActTestDetail::getEndTime);
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }
}

