/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActGeBytearrayMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActGeBytearray;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActReProcdef;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActReProcdefService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.DeleteModelDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.DownloadFilesDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ExportModel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowPageMsg;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.Bpm2XMLMapper;
import com.jxdinfo.hussar.workflow.util.ActivitiTranslateUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.util.XmlUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@HussarTokenDs
public class ModelServiceImpl
extends ServiceImpl<ModelMapper, ModelBuild>
implements ModelService {
    private static Logger logger = LoggerFactory.getLogger(ModelServiceImpl.class);
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    @Resource
    private HussarConfig hussarConfig;
    @Resource
    private ModelMapper modelMapper;
    @Resource
    private ProcessEngine processEngine;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private SysActFormAuthService sysActFormAuthService;
    @Resource
    private Bpm2XMLMapper bpm2XMLMapper;
    @Resource
    private BpmActGeBytearrayMapper bpmActGeBytearrayMapper;
    @Resource
    private IBpmActReProcdefService bpmActReProcdefService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    private static final String SUFFIX = ".bpmn20.xml";

    public String deployModel(WorkFlow workFlow, Long modelId, String workflowStyle, String proDefId, Integer finalVersion, boolean flag) {
        return this.deployModel(workFlow, modelId, workflowStyle, true, proDefId, finalVersion, flag);
    }

    public String newDeployModel(WorkFlow workFlow, Long modelId, String workflowStyle, String proDefId, Integer finalVersion, boolean flag) {
        try {
            Model modelData = this.repositoryService.getModel(String.valueOf(modelId));
            byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
            if (bytes == null) {
                logger.error("\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002");
                return null;
            }
            JsonNode editNode = new ObjectMapper().readTree(bytes);
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            jsonConverter.updateConvertersToBpmnMap();
            jsonConverter.updateConvertersToJsonMap();
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editNode);
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
            String processName = modelData.getName() + SUFFIX;
            Context.getCommandContext().addAttribute("workflow_style", (Object)workflowStyle);
            DeploymentBuilder builder = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8));
            Deployment deployment = null;
            deployment = finalVersion == null ? builder.deploy(true) : builder.deploy(finalVersion);
            modelData.setDeploymentId(deployment.getId());
            String deploymentModel = this.lcdpBpmProperties.getDeploymentModel();
            boolean isExternal = "external".equals(this.lcdpBpmProperties.getTenantType());
            boolean isWorkflow = "workflow-platform".equals(deploymentModel);
            ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionById(deployment.getProcDefId());
            if (HussarUtils.isNotEmpty((Object)proDefId) && flag && (!isWorkflow || !isExternal)) {
                BpmActReProcdef bpmActReProcdef = (BpmActReProcdef)this.bpmActReProcdefService.getById((Serializable)((Object)proDefId));
                Integer realVersion = bpmActReProcdef.getRealVersion();
                if (HussarUtils.isEmpty((Object)realVersion)) {
                    realVersion = bpmActReProcdef.getVersion();
                }
                processDefinition.setRealVersion(realVersion);
            }
            if (workFlow == null) {
                workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(modelData.getKey(), null, false, Integer.valueOf(0), false);
            }
            modelData.setName(workFlow.getName());
            modelData.setCategory(workFlow.getCategory());
            ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
            modelObjectNode.put("name", workFlow.getName());
            modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
            modelObjectNode.put("revision", 1);
            modelData.setMetaInfo(modelObjectNode.toString());
            modelData.setDeploymentId(deployment.getId());
            modelData.setWorkflowStyle(workFlow.getWorkflowStyle());
            if (HussarUtils.isNotEmpty((Object)workFlow.getProcessTag())) {
                modelData.setOrganId(workFlow.getProcessTag());
            }
            String nameTranslateKey = ActivitiTranslateUtil.getTranslateKey((Map)bpmnModel.getMainProcess().getExtensionElements(), (String)"processNameTranslateId");
            modelData.setNameTranslateKey(nameTranslateKey);
            workFlow.setProcDefId(processDefinition.getId());
            workFlow.setVersion(String.valueOf(processDefinition.getVersion()));
            this.sysActProcessFileService.addFile(workFlow, Integer.valueOf(processDefinition.getVersion()));
            if (HussarUtils.isNotEmpty((Object)workFlow.getProcessTag())) {
                processDefinition.setProcessTag(workFlow.getProcessTag());
            }
            processDefinition.setNameTranslateKey(nameTranslateKey);
            if (processDefinition.getVersion() > 1) {
                this.processDefinitionsService.newSetNotMain(processDefinition.getKey(), workFlow.getProcessTag());
            }
            return processDefinition.getId();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public String deployModel(Long modelId) {
        return this.deployModel(null, modelId, null, null, null, false);
    }

    private String deployModel(WorkFlow workFlow, Long modelId, String workflowStyle, boolean deployWithWorkflowStyle, String proDefId, Integer finalVersion, boolean flag) {
        try {
            BpmActReProcdef bpmActReProcdef;
            Model modelData = this.repositoryService.getModel(String.valueOf(modelId));
            byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
            if (bytes == null) {
                logger.error("\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002");
                return null;
            }
            JsonNode editNode = new ObjectMapper().readTree(bytes);
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            jsonConverter.updateConvertersToBpmnMap();
            jsonConverter.updateConvertersToJsonMap();
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editNode);
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
            String processName = modelData.getName() + SUFFIX;
            Deployment deployment = (Deployment)this.processEngine.getManagementService().executeCommand(commandContext -> {
                if (deployWithWorkflowStyle) {
                    commandContext.addAttribute("workflow_style", (Object)workflowStyle);
                } else {
                    commandContext.addAttribute("workflow_style", (Object)modelData.getWorkflowStyle());
                }
                DeploymentBuilder builder = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8));
                if (finalVersion == null) {
                    return builder.deploy(true);
                }
                return builder.deploy(finalVersion);
            });
            String deploymentModel = this.lcdpBpmProperties.getDeploymentModel();
            boolean isExternal = "external".equals(this.lcdpBpmProperties.getTenantType());
            boolean isWorkflow = "workflow-platform".equals(deploymentModel);
            if (!(!HussarUtils.isNotEmpty((Object)proDefId) || !flag || isWorkflow && isExternal || "1".equals((bpmActReProcdef = (BpmActReProcdef)this.bpmActReProcdefService.getById((Serializable)((Object)proDefId))).getMainProcess()) || "5".equals(bpmActReProcdef.getMainProcess()))) {
                Integer realVersion = bpmActReProcdef.getRealVersion();
                if (HussarUtils.isEmpty((Object)realVersion)) {
                    realVersion = bpmActReProcdef.getVersion();
                }
                LambdaUpdateWrapper bpmActReProcdefLambdaUpdateWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)bpmActReProcdefLambdaUpdateWrapper.eq(BpmActReProcdef::getDeploymentId, (Object)Long.valueOf(deployment.getId()))).set(BpmActReProcdef::getRealVersion, (Object)realVersion)).set(BpmActReProcdef::getMainProcess, (Object)bpmActReProcdef.getMainProcess());
                this.bpmActReProcdefService.update((Wrapper)bpmActReProcdefLambdaUpdateWrapper);
            }
            modelData.setDeploymentId(deployment.getId());
            if (workFlow == null) {
                workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(modelData.getKey(), null, false, Integer.valueOf(0), false);
            }
            modelData.setName(workFlow.getName());
            modelData.setCategory(workFlow.getCategory());
            ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
            modelObjectNode.put("name", workFlow.getName());
            modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
            modelObjectNode.put("revision", 1);
            modelData.setMetaInfo(modelObjectNode.toString());
            modelData.setDeploymentId(deployment.getId());
            modelData.setWorkflowStyle(workFlow.getWorkflowStyle());
            if (HussarUtils.isNotEmpty((Object)workFlow.getProcessTag())) {
                modelData.setOrganId(workFlow.getProcessTag());
            }
            String nameTranslateKey = ActivitiTranslateUtil.getTranslateKey((Map)bpmnModel.getMainProcess().getExtensionElements(), (String)"processNameTranslateId");
            modelData.setNameTranslateKey(nameTranslateKey);
            this.repositoryService.saveModel(modelData);
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(modelData.getDeploymentId()).latestVersion().singleResult();
            this.saveModelExtendProperties(bpmnModel, processDefinition);
            workFlow.setProcDefId(processDefinition.getId());
            workFlow.setVersion(String.valueOf(processDefinition.getVersion()));
            this.sysActProcessFileService.addFile(workFlow, null);
            if (HussarUtils.isEmpty((Object)workFlow.getProcessTag())) {
                this.sysActProcessFileService.updateFile(workFlow, Integer.valueOf(0));
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BpmActReProcdef::getId, (Object)workFlow.getProcDefId());
            updateWrapper.set(BpmActReProcdef::getNameTranslateKey, (Object)nameTranslateKey);
            if (HussarUtils.isNotEmpty((Object)workFlow.getProcessTag())) {
                updateWrapper.set(BpmActReProcdef::getOrganId, (Object)workFlow.getProcessTag());
            }
            this.bpmActReProcdefService.update((Wrapper)updateWrapper);
            this.processDefinitionsService.setNotMain(processDefinition.getKey(), workFlow.getProcessTag());
            return processDefinition.getId();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public ModelBuild queryModel(Long modelId) {
        return this.modelMapper.queryModel(modelId);
    }

    public ModelBuild queryModel(String modelId) {
        return this.modelMapper.queryModel(Long.parseLong(modelId));
    }

    public void addNodeSaveModelExtendProperties(BpmnModel bpmnModel, String defId) {
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(defId);
        this.saveModelExtendProperties(bpmnModel, processDefinition);
    }

    public void deployModelByWorkFlowXml(WorkFlow workFlow, BpmnModel bpmnModel, String modelId, String processInsId, String version) {
        Model modelData = this.repositoryService.getModel(modelId);
        String processName = modelData.getName() + SUFFIX;
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
        Deployment deployment = (Deployment)this.processEngine.getManagementService().executeCommand(commandContext -> {
            commandContext.addAttribute("workflow_style", (Object)workFlow.getWorkflowStyle());
            return this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8)).deploy(false);
        });
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        this.saveModelExtendProperties(bpmnModel, processDefinition);
        workFlow.setProcDefId(processDefinition.getId());
        this.sysActProcessFileService.addFile(workFlow, null);
        this.processDefinitionsService.setVersionTemporary(processDefinition.getId());
        this.processDefinitionsService.editTemporaryDefId(processDefinition.getId(), processInsId, version);
        this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processDefinition.getId()));
    }

    public String deployModelAboutOrgan(WorkFlow workFlow, BpmnModel bpmnModel, String modelId, String organId, Integer finalVersion, Integer realVersion) {
        Model modelData = this.repositoryService.getModel(modelId);
        String processName = modelData.getName() + SUFFIX;
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
        Deployment deployment = (Deployment)this.processEngine.getManagementService().executeCommand(commandContext -> {
            commandContext.addAttribute("workflow_style", (Object)workFlow.getWorkflowStyle());
            DeploymentBuilder builder = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8));
            if (finalVersion == null) {
                return builder.deploy(true);
            }
            return builder.deploy(finalVersion);
        });
        modelData.setDeploymentId(deployment.getId());
        this.repositoryService.saveModel(modelData);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        this.saveModelExtendProperties(bpmnModel, processDefinition);
        workFlow.setProcDefId(processDefinition.getId());
        this.sysActProcessFileService.addFile(workFlow, Integer.valueOf(processDefinition.getVersion()));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(BpmActReProcdef::getId, (Object)workFlow.getProcDefId())).set(HussarUtils.isNotEmpty((Object)organId), BpmActReProcdef::getOrganId, (Object)organId)).isNull(HussarUtils.isEmpty((Object)organId), BpmActReProcdef::getOrganId);
        if (realVersion != null && processDefinition.getVersion() != realVersion.intValue()) {
            ((LambdaUpdateWrapper)updateWrapper.set(BpmActReProcdef::getMainProcess, (Object)4)).set(BpmActReProcdef::getRealVersion, (Object)realVersion);
        }
        this.bpmActReProcdefService.update((Wrapper)updateWrapper);
        return processDefinition.getId();
    }

    public void deployModelWithCompatiblePublish(WorkFlow workFlow, BpmnModel bpmnModel, String modelId, String oldDefId, String version) {
        long runningProcessCount = this.processEngine.getRuntimeService().createProcessInstanceQuery().processDefinitionId(oldDefId).count();
        if (runningProcessCount == 0L) {
            return;
        }
        Model modelData = this.repositoryService.getModel(modelId);
        String processName = modelData.getName() + SUFFIX;
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
        Deployment deployment = (Deployment)this.processEngine.getManagementService().executeCommand(commandContext -> {
            commandContext.addAttribute("workflow_style", (Object)modelData.getWorkflowStyle());
            return this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8)).deploy(false);
        });
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        this.saveModelExtendProperties(bpmnModel, processDefinition);
        workFlow.setProcDefId(processDefinition.getId());
        this.sysActProcessFileService.addFile(workFlow, null);
        this.processDefinitionsService.setVersionTemporary(processDefinition.getId());
        this.processDefinitionsService.editTemporaryDefIdByOldDefId(processDefinition.getId(), oldDefId, version);
    }

    private void saveModelExtendProperties(BpmnModel model, ProcessDefinition processDefinition) {
        ArrayList<SysActExtendProperties> sysActExtendProperties = new ArrayList<SysActExtendProperties>();
        String procDefId = processDefinition.getId();
        if (model != null) {
            Collection flowElements = model.getMainProcess().getFlowElements();
            for (FlowElement node : flowElements) {
                if (node instanceof UserTask) {
                    JSONObject jsonObject;
                    JSONObject jsonObject2;
                    JSONObject jsonObject3;
                    UserTask userTask = (UserTask)node;
                    String formDetailKey = this.getFormDetailKey(userTask);
                    String assistFormDetailKey = this.getAssistFormDetailKey(userTask);
                    String ccFormDetailKey = this.getCcFormDetailKey(userTask);
                    String formId = "";
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{formDetailKey, assistFormDetailKey, ccFormDetailKey})) continue;
                    JSONObject formDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)formDetailKey) && (jsonObject3 = JSON.parseObject((String)formDetailKey)) != null) {
                        for (Object key : jsonObject3.keySet()) {
                            formDetailKeyObject.put((String)key, jsonObject3.getJSONObject((String)key).get((Object)"url"));
                            formId = (String)jsonObject3.getJSONObject((String)key).get((Object)"id");
                        }
                    }
                    JSONObject assistFormDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)assistFormDetailKey) && (jsonObject2 = JSON.parseObject((String)assistFormDetailKey)) != null) {
                        Object key;
                        key = jsonObject2.keySet().iterator();
                        while (key.hasNext()) {
                            String key2 = (String)key.next();
                            assistFormDetailKeyObject.put(key2, jsonObject2.getJSONObject(key2).get((Object)"url"));
                        }
                    }
                    JSONObject ccFormDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)ccFormDetailKey) && (jsonObject = JSON.parseObject((String)ccFormDetailKey)) != null) {
                        for (Object key : jsonObject.keySet()) {
                            ccFormDetailKeyObject.put((String)key, jsonObject.getJSONObject((String)key).get((Object)"url"));
                        }
                    }
                    SysActExtendProperties asep = new SysActExtendProperties();
                    asep.setTaskDefKey(userTask.getId());
                    asep.setFormDetailKey(JSON.toJSONString((Object)formDetailKeyObject));
                    asep.setAssistFormDetailKey(JSON.toJSONString((Object)assistFormDetailKeyObject));
                    asep.setCcFormDetailKey(JSON.toJSONString((Object)ccFormDetailKeyObject));
                    asep.setTaskDefName(userTask.getName());
                    asep.setProcDefId(procDefId);
                    asep.setFormId(formId);
                    sysActExtendProperties.add(asep);
                    continue;
                }
                if (!(node instanceof SubProcess)) continue;
                SubProcess subProcess = (SubProcess)node;
                for (FlowElement element : subProcess.getFlowElements()) {
                    JSONObject jsonObject;
                    JSONObject jsonObject4;
                    JSONObject jsonObject5;
                    if (!(element instanceof UserTask)) continue;
                    UserTask userTask = (UserTask)element;
                    String formDetailKey = this.getFormDetailKey(userTask);
                    String assistFormDetailKey = this.getAssistFormDetailKey(userTask);
                    String ccFormDetailKey = this.getCcFormDetailKey(userTask);
                    String formId = "";
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{formDetailKey, assistFormDetailKey, ccFormDetailKey})) continue;
                    JSONObject formDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)formDetailKey) && (jsonObject5 = JSON.parseObject((String)formDetailKey)) != null) {
                        Object key;
                        key = jsonObject5.keySet().iterator();
                        while (key.hasNext()) {
                            String key3 = (String)key.next();
                            formDetailKeyObject.put(key3, jsonObject5.getJSONObject(key3).get((Object)"url"));
                            formId = (String)jsonObject5.getJSONObject(key3).get((Object)"id");
                        }
                    }
                    JSONObject assistFormDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)assistFormDetailKey) && (jsonObject4 = JSON.parseObject((String)assistFormDetailKey)) != null) {
                        for (String key : jsonObject4.keySet()) {
                            assistFormDetailKeyObject.put(key, jsonObject4.getJSONObject(key).get((Object)"url"));
                        }
                    }
                    JSONObject ccFormDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)ccFormDetailKey) && (jsonObject = JSON.parseObject((String)ccFormDetailKey)) != null) {
                        for (String key : jsonObject.keySet()) {
                            ccFormDetailKeyObject.put(key, jsonObject.getJSONObject(key).get((Object)"url"));
                        }
                    }
                    SysActExtendProperties asep = new SysActExtendProperties();
                    asep.setTaskDefKey(userTask.getId());
                    asep.setFormDetailKey(JSON.toJSONString((Object)formDetailKeyObject));
                    asep.setAssistFormDetailKey(JSON.toJSONString((Object)assistFormDetailKeyObject));
                    asep.setCcFormDetailKey(JSON.toJSONString((Object)ccFormDetailKeyObject));
                    asep.setTaskDefName(userTask.getName());
                    asep.setProcDefId(procDefId);
                    asep.setFormId(formId);
                    sysActExtendProperties.add(asep);
                }
            }
        }
        if (!sysActExtendProperties.isEmpty()) {
            ArrayList<SysActExtendProperties> addList = new ArrayList<SysActExtendProperties>();
            ArrayList<SysActExtendProperties> updateList = new ArrayList<SysActExtendProperties>();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            for (SysActExtendProperties sysActExtendProperty : sysActExtendProperties) {
                String getProcDefId = sysActExtendProperty.getProcDefId();
                String taskDefKey = sysActExtendProperty.getTaskDefKey();
                queryWrapper.or();
                ((LambdaQueryWrapper)queryWrapper.eq(SysActExtendProperties::getProcDefId, (Object)getProcDefId)).eq(SysActExtendProperties::getTaskDefKey, (Object)taskDefKey);
            }
            List sameList = this.iSysActExtendPropertiesService.list((Wrapper)queryWrapper);
            for (SysActExtendProperties sysActExtendProperty : sysActExtendProperties) {
                boolean isadd = true;
                for (SysActExtendProperties actExtendProperties : sameList) {
                    if (!sysActExtendProperty.getProcDefId().equals(actExtendProperties.getProcDefId()) || !sysActExtendProperty.getTaskDefKey().equals(actExtendProperties.getTaskDefKey())) continue;
                    sysActExtendProperty.setId(actExtendProperties.getId());
                    updateList.add(sysActExtendProperty);
                    isadd = false;
                    break;
                }
                if (!isadd) continue;
                addList.add(sysActExtendProperty);
            }
            this.iSysActExtendPropertiesService.saveBatch(addList);
            this.iSysActExtendPropertiesService.updateBatchById(updateList);
        }
    }

    private String getFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        if (HussarUtils.isEmpty((Object)extensionElement)) {
            return null;
        }
        List extensionElements = (List)extensionElement.get("flowFormDetailKey");
        if (HussarUtils.isEmpty((Object)extensionElements)) {
            return null;
        }
        ExtensionElement element = (ExtensionElement)extensionElements.get(0);
        if (HussarUtils.isEmpty((Object)element)) {
            return null;
        }
        Map attributes = element.getAttributes();
        if (HussarUtils.isEmpty((Object)attributes)) {
            return null;
        }
        List attributeList = (List)attributes.get("flowFormDetailKey");
        if (HussarUtils.isEmpty((Object)attributeList)) {
            return null;
        }
        ExtensionAttribute extensionAttribute = (ExtensionAttribute)attributeList.get(0);
        if (HussarUtils.isEmpty((Object)extensionAttribute)) {
            return null;
        }
        return extensionAttribute.getValue();
    }

    private String getAssistFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        if (HussarUtils.isEmpty((Object)extensionElement)) {
            return null;
        }
        List extensionElements = (List)extensionElement.get("assistFlowFormDetailKey");
        if (HussarUtils.isEmpty((Object)extensionElements)) {
            return null;
        }
        ExtensionElement element = (ExtensionElement)extensionElements.get(0);
        if (HussarUtils.isEmpty((Object)element)) {
            return null;
        }
        Map attributes = element.getAttributes();
        if (HussarUtils.isEmpty((Object)attributes)) {
            return null;
        }
        List attributeList = (List)attributes.get("assistFlowFormDetailKey");
        if (HussarUtils.isEmpty((Object)attributeList)) {
            return null;
        }
        ExtensionAttribute extensionAttribute = (ExtensionAttribute)attributeList.get(0);
        if (HussarUtils.isEmpty((Object)extensionAttribute)) {
            return null;
        }
        return extensionAttribute.getValue();
    }

    private String getCcFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        if (HussarUtils.isEmpty((Object)extensionElement)) {
            return null;
        }
        List extensionElements = (List)extensionElement.get("ccFlowFormDetailKey");
        if (HussarUtils.isEmpty((Object)extensionElements)) {
            return null;
        }
        ExtensionElement element = (ExtensionElement)extensionElements.get(0);
        if (HussarUtils.isEmpty((Object)element)) {
            return null;
        }
        Map attributes = element.getAttributes();
        if (HussarUtils.isEmpty((Object)attributes)) {
            return null;
        }
        List attributeList = (List)attributes.get("ccFlowFormDetailKey");
        if (HussarUtils.isEmpty((Object)attributeList)) {
            return null;
        }
        ExtensionAttribute extensionAttribute = (ExtensionAttribute)attributeList.get(0);
        if (HussarUtils.isEmpty((Object)extensionAttribute)) {
            return null;
        }
        return extensionAttribute.getValue();
    }

    public IPage<ModelBuild> queryModelList(String modelName, Boolean published, Page<ModelBuild> page) {
        try {
            String strPublished = null;
            if (HussarUtils.isNotEmpty((Object)published)) {
                strPublished = published != false ? "1" : "0";
            }
            List<ModelBuild> modelList = this.modelMapper.queryModelListNoOrganId(page, modelName, strPublished);
            List<String> modelKeys = modelList.stream().map(ModelBuild::getModelKey).distinct().collect(Collectors.toList());
            List<ModelBuild> modelBuilds = this.modelMapper.queryOrganModelList(null, modelKeys);
            this.descModel(modelBuilds);
            Map<String, List<ModelBuild>> listMap = modelBuilds.stream().collect(Collectors.groupingBy(ModelBuild::getModelKey));
            for (ModelBuild modelBuild : modelList) {
                modelBuild.setModelList(listMap.get(modelBuild.getModelKey()));
                String processFormId = this.getProcessFormId(modelBuild.getProcessKey(), null);
                modelBuild.setFormId(processFormId);
            }
            this.descModel(modelList);
            ArrayList<ModelBuild> translateList = new ArrayList<ModelBuild>();
            translateList.addAll(modelList);
            translateList.addAll(modelBuilds);
            BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(translateList, ModelBuild.class).translate(ModelBuild::getNameTranslateKey, ModelBuild::setName).execute();
            page.setRecords(modelList);
            return page;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BpmException(BpmExceptionCodeEnum.MODEL_QUERY_ERROR);
        }
    }

    public void descModel(List<ModelBuild> modelList) {
        List organIds = modelList.stream().map(ModelBuild::getOrganId).distinct().collect(Collectors.toList());
        Map organNameMap = this.assigneeChooseService.getUserListByUserId(organIds);
        for (ModelBuild modelBuild : modelList) {
            JSONObject jsonObject;
            modelBuild.setOrganName((String)organNameMap.get(modelBuild.getOrganId()));
            if ("1".equals(modelBuild.getPublished())) {
                jsonObject = JSON.parseObject((String)modelBuild.getDescription());
                modelBuild.setDescription(jsonObject.getString("description"));
                continue;
            }
            jsonObject = JSON.parseObject((String)new String(modelBuild.getContent(), StandardCharsets.UTF_8));
            modelBuild.setDescription(jsonObject.getString("description"));
        }
    }

    @CacheEvict(value={"workflow_process_def_id", "workflow_organ_process_model", "workflow_process_model_status", "workflow_file", "workflow_assignee", "form_detail_key", "service_name", "form_id"}, allEntries=true)
    public ApiResponse<String> deleteModel(Long modelId, String organId) {
        List<Long> modelIds = new ArrayList<Long>();
        modelIds.add(modelId);
        if (HussarUtils.isEmpty((Object)organId)) {
            modelIds = this.modelMapper.getModelIds(modelId, null);
        }
        if ("0".equals(this.modelMapper.getAllRunningCountWithModelId(modelIds))) {
            String processKey = this.modelMapper.getIdentityById(modelId);
            this.modelMapper.deleteByModelIds(modelIds);
            if (HussarUtils.isNotEmpty((Object)organId)) {
                List<String> defIds = this.modelMapper.getOrganModelDefIds(modelId, organId);
                if (HussarUtils.isNotEmpty(defIds)) {
                    List versions = defIds.stream().map(e -> Integer.valueOf(e.split(":")[1])).collect(Collectors.toList());
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(SysActAssignee::getProcDefKey, (Object)processKey);
                    queryWrapper.in(SysActAssignee::getProcessVersion, versions);
                    this.sysActAssigneeService.remove((Wrapper)queryWrapper);
                    this.modelMapper.deleteModelDef(null, defIds, null);
                }
            } else {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysActAssignee::getProcDefKey, (Object)processKey);
                this.sysActAssigneeService.remove((Wrapper)queryWrapper);
                this.modelMapper.deleteModelDef(processKey, null, organId);
            }
            this.sysActProcessFileService.remove((Wrapper)new LambdaQueryWrapper().in(SysActProcessFile::getModelId, modelIds));
            return ApiResponse.success((String)BpmExceptionCodeEnum.DELETE_SUCCESS.getMessage());
        }
        throw new BpmException(BpmExceptionCodeEnum.DELETE_RUNNING_FAIL);
    }

    @CacheEvict(value={"workflow_process_def_id", "workflow_organ_process_model", "workflow_process_model_status", "workflow_file", "workflow_assignee", "form_detail_key", "service_name", "form_id"}, allEntries=true)
    public ApiResponse<String> deleteModel(String modelId, String organId) {
        return this.deleteModel(Long.parseLong(modelId), organId);
    }

    @CacheEvict(value={"workflow_process_def_id", "workflow_organ_process_model", "workflow_process_model_status", "workflow_file", "workflow_assignee", "form_detail_key", "service_name", "form_id"}, allEntries=true)
    public ApiResponse<String> deleteModel(DeleteModelDto deleteModelDto) {
        if (HussarUtils.isEmpty((Object)deleteModelDto.getModelId()) && HussarUtils.isEmpty((Object)deleteModelDto.getOrganId())) {
            this.sysActProcessFileService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)deleteModelDto.getIdentity()));
            this.sysActAssigneeService.delAssignee(deleteModelDto.getIdentity());
            this.sysActFormAuthService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)deleteModelDto.getIdentity()));
            return ApiResponse.success((String)BpmExceptionCodeEnum.DELETE_SUCCESS.getMessage());
        }
        return this.deleteModel(deleteModelDto.getModelId(), deleteModelDto.getOrganId());
    }

    @CacheEvict(value={"workflow_process_def_id", "workflow_organ_process_model", "workflow_process_model_status", "workflow_file", "workflow_assignee", "form_detail_key", "service_name", "form_id"}, allEntries=true)
    public ApiResponse<String> deleteModelWithVersion(String processDefId, String organId) {
        String procDefKey = processDefId.split(":")[0];
        int version = Integer.parseInt(processDefId.split(":")[1]);
        this.processDefinitionsService.canModelDeleteWithVersion(procDefKey, organId);
        if ("0".equals(this.modelMapper.getRunningCountWithModelId(null, processDefId))) {
            ArrayList<String> processDefIds = new ArrayList<String>();
            processDefIds.add(processDefId);
            this.modelMapper.deleteModelDef(null, processDefIds, organId);
            this.sysActProcessFileService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessId, (Object)processDefId)).ne(SysActProcessFile::getVersion, (Object)0));
            this.sysActAssigneeService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)procDefKey)).eq(SysActAssignee::getProcessVersion, (Object)version));
            this.processDefinitionsService.resetModelMsg(procDefKey, organId);
            if (HussarUtils.isEmpty((Object)organId)) {
                this.sysActProcessFileService.copyFiles(procDefKey, null);
            }
            return ApiResponse.success((String)BpmExceptionCodeEnum.DELETE_SUCCESS.getMessage());
        }
        throw new BpmException(BpmExceptionCodeEnum.DELETE_RUNNING_FAIL);
    }

    public String getIdByIdentity(String identity, String organId) {
        return this.modelMapper.getIdByIdentity(identity, organId);
    }

    public List<Long> getModelIds(Long modelId, String processKey) {
        return this.modelMapper.getModelIds(modelId, processKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> unZipFile(String zipFile, String filePath, HttpServletRequest request) {
        String clientChartSet = request.getCharacterEncoding();
        ArrayList<String> resultList = new ArrayList<String>();
        ZipFile zip = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            File pathFile = new File(filePath);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            long time = System.currentTimeMillis();
            zip = new ZipFile(zipFile, "UTF-8");
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = (ZipEntry)entries.nextElement();
                String zipEntryName = entry.getName();
                in = zip.getInputStream(entry);
                String outPath = (filePath + time + File.separator + new String(zipEntryName.getBytes(clientChartSet))).replaceAll("\\*", File.separator);
                File file = new File(outPath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (new File(outPath).isDirectory()) continue;
                resultList.add(outPath);
                out = new FileOutputStream(outPath);
                byte[] buf1 = new byte[1024];
                while ((len = in.read(buf1)) > 0) {
                    out.write(buf1, 0, len);
                }
                in.close();
                out.close();
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return resultList;
    }

    private List<String> getAllFile(File file) {
        if (file == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        if (!file.exists()) {
            return list;
        }
        for (File f : file.listFiles()) {
            String suffix;
            if (f.isDirectory()) {
                list.addAll(this.getAllFile(f));
                continue;
            }
            if (f.getPath().lastIndexOf(46) <= 0 || !"xml".equals(suffix = f.getPath().substring(f.getPath().lastIndexOf(46) + 1)) && !"lcdpbpm".equals(suffix)) continue;
            list.add(f.getPath());
        }
        return list;
    }

    public List<ModelBuild> getAllModel() {
        return this.modelMapper.getAllModel();
    }

    public ApiResponse<String> importModel(MultipartFile file, HttpServletRequest request) {
        InputStream in = null;
        FileOutputStream out = null;
        XMLStreamReader xtr = null;
        String fileName = System.currentTimeMillis() + ".zip";
        try {
            in = file.getInputStream();
            File files = new File(this.hussarConfig.getFileUploadPath() + File.separator + fileName);
            if (!files.getParentFile().exists()) {
                files.getParentFile().mkdirs();
            }
            try {
                boolean isCreateNewFile = files.createNewFile();
                if (!isCreateNewFile) {
                    logger.error("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
                    throw new BpmException(BpmExceptionCodeEnum.UPLOAD_PATH_ERROR);
                }
            }
            catch (IOException e) {
                throw new BpmException(BpmExceptionCodeEnum.UPLOAD_PATH_ERROR);
            }
            out = new FileOutputStream(files);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.close();
            in.close();
            List<String> fileList = this.unZipFile(this.hussarConfig.getFileUploadPath() + File.separator + fileName, this.hussarConfig.getFileUploadPath(), request);
            for (String s : fileList) {
                if ("xml".equals(s.substring(s.length() - 3))) continue;
                files = new File(s);
                Map map = (Map)JSON.parseObject((String)FileUtils.readFileToString((File)files, (String)"UTF-8"), Map.class);
                if (!HussarUtils.equals((Object)"lcdpbpm", map.get("export_type"))) {
                    logger.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u538b\u7f29\u6587\u4ef6");
                    throw new BpmException(BpmExceptionCodeEnum.ERROR_IMPORT);
                }
                JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString(map.get("file")));
                ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
                ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
                for (Object o : jsonArray) {
                    SysActProcessFile sysActProcessFile = (SysActProcessFile)JSONObject.toJavaObject((JSON)((JSONObject)o), SysActProcessFile.class);
                    SysActProcessFile oldSysActProcessFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)sysActProcessFile.getProcessKey())).eq(SysActProcessFile::getType, (Object)sysActProcessFile.getType()));
                    if (HussarUtils.isNotEmpty((Object)oldSysActProcessFile)) {
                        sysActProcessFile.setId(oldSysActProcessFile.getId());
                    } else {
                        sysActProcessFile.setId(null);
                    }
                    sysActProcessFile.setVersion(Integer.valueOf(0));
                    if ("wfd".equals(sysActProcessFile.getType())) {
                        wfdList.add(sysActProcessFile);
                        continue;
                    }
                    metaList.add(sysActProcessFile);
                }
                ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
                addList.addAll(wfdList);
                addList.addAll(metaList);
                this.sysActProcessFileService.saveOrUpdateBatch(addList);
            }
            for (String s : fileList) {
                if (!"xml".equals(s.substring(s.length() - 3))) continue;
                in = new FileInputStream(s);
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                xtr = xif.createXMLStreamReader(in);
                BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
                String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
                String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
                String identityId = this.modelMapper.getIdByIdentity(modelKey, null);
                Model modelData = null;
                if (HussarUtils.isEmpty((Object)identityId)) {
                    modelData = this.repositoryService.newModel();
                    ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                    modelObjectNode.put("name", impModelName);
                    modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                    modelObjectNode.put("revision", 1);
                    modelData.setMetaInfo(modelObjectNode.toString());
                    modelData.setName(impModelName);
                    modelData.setNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((Map)bpmnModel.getMainProcess().getExtensionElements(), (String)"processNameTranslateId"));
                    modelData.setKey(modelKey);
                    this.repositoryService.saveModel(modelData);
                }
                ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
                jsonConverter.updateConvertersToBpmnMap();
                jsonConverter.updateConvertersToJsonMap();
                ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
                identityId = identityId == null ? modelData.getId() : identityId;
                this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
                WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(modelKey, null, false, Integer.valueOf(0), false);
                workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
                this.sysActProcessFileService.updateFile(workFlow, Integer.valueOf(0));
                this.deployModel(null, Long.parseLong(identityId), workFlow.getWorkflowStyle(), null, null, false);
            }
            ApiResponse apiResponse = ApiResponse.success((String)BpmExceptionCodeEnum.IMPORT_SUCCESS.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_IMPORT);
        }
        finally {
            if (xtr != null) {
                try {
                    xtr.close();
                }
                catch (XMLStreamException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean importModel(File file, List<String> coverList) {
        InputStream in = null;
        XMLStreamReader xtr = null;
        try {
            File f = null;
            List<String> fileList = this.getAllFile(file);
            if (fileList == null) {
                logger.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u6587\u4ef6");
                throw new NullPointerException("\u9519\u8bef\u6587\u4ef6\u5939");
            }
            for (String s : fileList) {
                if ("xml".equals(s.substring(s.length() - 3))) continue;
                f = new File(s);
                Map map = (Map)JSON.parseObject((String)FileUtils.readFileToString((File)f, (String)"UTF-8"), Map.class);
                if (!HussarUtils.equals((Object)"lcdpbpm", map.get("export_type"))) {
                    logger.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u6587\u4ef6");
                    Boolean bl = false;
                    return bl;
                }
                JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString(map.get("file")));
                ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
                ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
                if (!HussarUtils.isNotEmpty((Object)jsonArray)) continue;
                for (Object o : jsonArray) {
                    SysActProcessFile sysActProcessFile = (SysActProcessFile)JSONObject.toJavaObject((JSON)((JSONObject)o), SysActProcessFile.class);
                    SysActProcessFile oldSysActProcessFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)sysActProcessFile.getProcessKey())).eq(SysActProcessFile::getType, (Object)sysActProcessFile.getType()));
                    if (HussarUtils.isNotEmpty((Object)oldSysActProcessFile)) {
                        sysActProcessFile.setId(oldSysActProcessFile.getId());
                    } else {
                        sysActProcessFile.setId(null);
                    }
                    sysActProcessFile.setVersion(Integer.valueOf(0));
                    if ("wfd".equals(sysActProcessFile.getType())) {
                        wfdList.add(sysActProcessFile);
                        continue;
                    }
                    metaList.add(sysActProcessFile);
                }
                ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
                addList.addAll(wfdList);
                addList.addAll(metaList);
                this.sysActProcessFileService.saveOrUpdateBatch(addList);
            }
            for (String s : fileList) {
                if (!"xml".equals(s.substring(s.length() - 3))) continue;
                in = new FileInputStream(s);
                try {
                    XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                    xtr = xif.createXMLStreamReader(in);
                    BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
                    String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
                    String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
                    String identityId = this.modelMapper.getIdByIdentity(modelKey, null);
                    if (HussarUtils.isNotEmpty((Object)identityId)) {
                        if (HussarUtils.isNotEmpty(coverList.stream().filter(modelKey::equals).findFirst().orElse(null))) {
                            BpmActGeBytearray bpmActGeBytearray = new BpmActGeBytearray();
                            bpmActGeBytearray.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
                            bpmActGeBytearray.setId(this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId)));
                            this.bpmActGeBytearrayMapper.updateById(bpmActGeBytearray);
                            continue;
                        }
                    }
                    if (HussarUtils.isEmpty((Object)identityId)) {
                        Model modelData = this.repositoryService.newModel();
                        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                        modelObjectNode.put("name", impModelName);
                        modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                        modelObjectNode.put("revision", 1);
                        modelData.setMetaInfo(modelObjectNode.toString());
                        modelData.setName(impModelName);
                        modelData.setNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((Map)bpmnModel.getMainProcess().getExtensionElements(), (String)"processNameTranslateId"));
                        modelData.setKey(modelKey);
                        this.repositoryService.saveModel(modelData);
                        identityId = modelData.getId();
                    }
                    ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
                    jsonConverter.updateConvertersToBpmnMap();
                    jsonConverter.updateConvertersToJsonMap();
                    ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
                    this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
                    WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(modelKey, null, false, Integer.valueOf(0), false);
                    if (workFlow == null) {
                        logger.error("{} \u6570\u636e\u7f3a\u5931", (Object)modelKey);
                        throw new NullPointerException(modelKey + "\u6570\u636e\u7f3a\u5931");
                    }
                    workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
                    this.sysActProcessFileService.updateFile(workFlow, Integer.valueOf(0));
                    this.deployModel(null, Long.parseLong(identityId), workFlow.getWorkflowStyle(), null, null, false);
                }
                finally {
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Boolean bl = false;
            return bl;
        }
        finally {
            if (xtr != null) {
                try {
                    xtr.close();
                }
                catch (XMLStreamException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public String exportAllFileModel(String keys, File file) {
        ByteArrayInputStream in = null;
        List<ExportModel> models = this.modelMapper.getModelWithKey(Arrays.asList(keys.split(",")));
        if (HussarUtils.isEmpty(models)) {
            return file.getPath();
        }
        try {
            HashMap fileMap = new HashMap();
            for (ExportModel model : models) {
                if (HussarUtils.isEmpty((Object)model.getDeploymentId())) continue;
                ArrayList files = new ArrayList();
                if (HussarUtils.isNotEmpty(fileMap.get(model.getName()))) {
                    files.addAll((Collection)fileMap.get(model.getName()));
                }
                fileMap.put(model.getName(), files);
                in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(model.getDeploymentId(), model.getName() + SUFFIX);
                String filename = model.getName() + "_" + model.getBusinessId() + "/" + model.getName() + "_" + model.getDeploymentId() + SUFFIX;
                File xmlFile = new File(file, filename);
                FileUtils.copyInputStreamToFile((InputStream)in, (File)xmlFile);
                in.close();
            }
            List list = null;
            list = this.sysActProcessFileService.exportFileList(null, Arrays.asList(keys.split(",")), null);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("file", list);
            data.put("export_type", "lcdpbpm");
            File lcdpbpm = new File(file, "workflow_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss_SSS") + ".lcdpbpm");
            if (!lcdpbpm.isFile()) {
                try {
                    FileUtils.write((File)lcdpbpm, (CharSequence)JSON.toJSONString(data), (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BpmException(BpmExceptionCodeEnum.MODEL_EXPERT_ERROR);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return file.getPath();
    }

    public void exportAllFileModel(String modelId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        ZipOutputStream zipOutputStream = null;
        ByteArrayInputStream in = null;
        List<String> str = Arrays.asList(modelId.split(","));
        List<Long> cdids = str.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List<ExportModel> models = this.modelMapper.getModelWithVersion(cdids);
        try {
            response.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
            response.setHeader("Content-Disposition", "attachment; filename=\"model.zip\"");
            HashMap fileMap = new HashMap();
            zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
            for (ExportModel model : models) {
                ArrayList files = new ArrayList();
                if (HussarUtils.isNotEmpty(fileMap.get(model.getName()))) {
                    files.addAll((Collection)fileMap.get(model.getName()));
                }
                fileMap.put(model.getName(), files);
                in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(model.getDeploymentId(), model.getName() + SUFFIX);
                String filename = model.getName() + "_" + model.getBusinessId() + "/" + model.getName() + "_" + model.getDeploymentId() + SUFFIX;
                ZipEntry zipEntry = new ZipEntry(filename);
                zipOutputStream.putNextEntry((java.util.zip.ZipEntry)zipEntry);
                IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
                in.close();
            }
            this.toFileZip(modelId, null, zipOutputStream);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BpmException(BpmExceptionCodeEnum.MODEL_EXPERT_ERROR);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFileZip(String modelId, String procId, ZipOutputStream out) {
        List list;
        ZipOutputStream zipOutputStream = null;
        if (HussarUtils.isNotEmpty((Object)modelId)) {
            List<String> models = Arrays.asList(modelId.split(","));
            list = this.sysActProcessFileService.exportFileList(models, null, null);
        } else {
            list = this.sysActProcessFileService.exportFileList(null, null, procId);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("file", list);
        data.put("export_type", "lcdpbpm");
        zipOutputStream = out;
        ByteArrayInputStream in = null;
        try {
            zipOutputStream.putNextEntry((java.util.zip.ZipEntry)new ZipEntry("workflow_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss") + ".lcdpbpm"));
            in = new ByteArrayInputStream(JSON.toJSONBytes(data, (SerializerFeature[])new SerializerFeature[0]));
            IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
            in.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public ApiResponse<String> validationProcess(String processKey, String businessId, String userId, Map<String, Object> variables) {
        return ApiResponse.success((Object)"", (String)"");
    }

    public ApiResponse<JSONArray> doneList(String businessId) {
        BpmResponseResult bpmResponseResult = this.instanceEngineService.getDoneProcessTrace(businessId);
        if (HussarUtils.equals((Object)bpmResponseResult.getCode(), (Object)"1")) {
            return ApiResponse.success((Object)bpmResponseResult.getResult());
        }
        throw new BpmException(bpmResponseResult.getMsg());
    }

    @Cacheable(value={"workflow_process_real_version"}, key="'workflow_process_real_version'+#processDefId")
    public String getRealVersion(String processDefId) {
        return this.modelMapper.getRealVersion(processDefId);
    }

    @Cacheable(value={"workflow_process_real_version"}, key="'workflow_process_real_version'+#processDefId+':'+#version+':'")
    public String getRealVersion(String processDefKey, String version) {
        return this.modelMapper.getRealVersionByIdPrefix(processDefKey + ":" + version + ":%");
    }

    @Cacheable(value={"service_name"}, key="'service_name:'+#processKey", unless="#result == null")
    public String getServiceName(String processKey) {
        return this.modelMapper.getServiceName(processKey);
    }

    @Cacheable(value={"workflow_app_id"}, key="'workflow_app_id'+#processKey", unless="#result == null")
    public Long getAppId(String processKey) {
        return this.modelMapper.getAppId(processKey);
    }

    public String getAppCode(String processKey) {
        return this.modelMapper.getAppCode(processKey);
    }

    @CacheEvict(value={"service_name"}, allEntries=true)
    public int updateCategory(String identity, String category) {
        return this.modelMapper.updateCategory(identity, category);
    }

    public void downloadFiles(DownloadFilesDto downloadFilesDto, HttpServletResponse response) {
        String deploymentId = downloadFilesDto.getDeploymentId() == null ? "" : downloadFilesDto.getDeploymentId();
        String resourceName = downloadFilesDto.getResourceName() == null ? "" : downloadFilesDto.getResourceName();
        DefinitionModel processDefinitionModel = this.processDefinitionsMapper.getById(null, deploymentId);
        String key = processDefinitionModel.getId();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        response.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
        response.setHeader("Content-Disposition", "attachment; filename=\"model.zip\"");
        HashMap fileMap = new HashMap();
        ArrayList files = new ArrayList();
        fileMap.put(processDefinitionModel.getName(), files);
        String filename = processDefinitionModel.getName() + "_" + key.split(":")[0] + "/" + key.replace(":", "_") + SUFFIX;
        ZipEntry zipEntry = new ZipEntry(filename);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
             ByteArrayInputStream in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(deploymentId, resourceName);){
            zipOutputStream.putNextEntry((java.util.zip.ZipEntry)zipEntry);
            IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
            this.toFileZip(null, key, zipOutputStream);
        }
        catch (IOException e) {
            throw new BpmException(BpmExceptionCodeEnum.FILE_ZIP_ERROR);
        }
    }

    public Map<String, String> selectModelNamesWithDefaultLang(List<String> processKey) {
        List<ExportModel> nameList = this.modelMapper.selectModelNames(processKey);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(nameList, ExportModel.class).translate(ExportModel::getNameTranslateKey, ExportModel::setName).isDefaultLang().execute();
        HashMap<String, String> modelNames = new HashMap<String, String>();
        for (ExportModel exportModel : nameList) {
            modelNames.put(exportModel.getBusinessId(), exportModel.getName());
        }
        return modelNames;
    }

    public Map<String, String> selectModelNames(List<String> processKey) {
        List<ExportModel> nameList = this.modelMapper.selectModelNames(processKey);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(nameList, ExportModel.class).translate(ExportModel::getNameTranslateKey, ExportModel::setName).execute();
        HashMap<String, String> modelNames = new HashMap<String, String>();
        for (ExportModel exportModel : nameList) {
            modelNames.put(exportModel.getBusinessId(), exportModel.getName());
        }
        return modelNames;
    }

    @Cacheable(value={"workflow_organ_process_model"}, key="'workflow_organ_process_model'+#processKey+':'+#modelStatus")
    public List<String> getProcessModelAllOrgan(String processKey, String modelStatus) {
        ArrayList<String> processKeyList = new ArrayList<String>();
        processKeyList.add(processKey);
        List<ModelBuild> list = this.modelMapper.getAllOrganProcessModel(processKeyList);
        Stream<Object> stream = list.stream();
        if ("0".equals(modelStatus)) {
            stream = stream.filter(e -> "0".equals(e.getModelStatus()));
        } else if ("1".equals(modelStatus)) {
            stream = stream.filter(e -> !"0".equals(e.getModelStatus()));
        }
        return stream.map(ModelBuild::getOrganId).collect(Collectors.toList());
    }

    public String getAllRunningCountWithModelId(List<Long> modelIds) {
        return this.modelMapper.getAllRunningCountWithModelId(modelIds);
    }

    @Cacheable(value={"workflow_process_model_status"}, key="'workflow_process_model_status'+#processKey+':'+#organId")
    public boolean getProcessModelStatus(String processKey, String organId) {
        List<String> modelStatusList = this.modelMapper.queryModelStatusList(processKey, organId);
        for (String status : modelStatusList) {
            if (!"0".equals(status)) continue;
            return true;
        }
        return false;
    }

    @Cacheable(value={"workflow_process_model_type"}, key="'workflow_process_model_type'+#processKey", unless="#result == null")
    public String getProcessModelType(String processKey) {
        return this.modelMapper.getModelType(processKey);
    }

    @Cacheable(value={"form_id"}, key="'form_id'+#processKey+':'+#version", unless="#result == null")
    public String getProcessFormId(String processKey, Integer version) {
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(processKey, version);
        if (HussarUtils.isEmpty((Object)workFlow)) {
            throw new PublicClientException(BpmExceptionCodeEnum.ERROR_PROCESS_IDENTITY.getMessage());
        }
        String formId = "";
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List list = flowModel.getSlots().getElement();
        if (HussarUtils.isNotEmpty((Object)list)) {
            for (FlowObject flowObject : list) {
                if (!BpmNodeTypeUtil.isUserTask((String)flowObject.getName()) || !HussarUtils.isNotEmpty((Object)flowObject.getProps().getFormDetailAddress())) continue;
                formId = ((FlowPageMsg)flowObject.getProps().getFormDetailAddress().get("web")).getId();
                break;
            }
        }
        return formId;
    }

    public String deployModelWithType(WorkFlow workFlow, Long modelId, String workflowStyle, String proDefId, Integer finalVersion, boolean flag, String modelType, String appCode) {
        try {
            Model modelData = this.repositoryService.getModel(String.valueOf(modelId));
            byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
            if (bytes == null) {
                logger.error("\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002");
                return null;
            }
            JsonNode editNode = new ObjectMapper().readTree(bytes);
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            jsonConverter.updateConvertersToBpmnMap();
            jsonConverter.updateConvertersToJsonMap();
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editNode);
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
            String processName = modelData.getName() + SUFFIX;
            Deployment deployment = (Deployment)this.processEngine.getManagementService().executeCommand(commandContext -> {
                commandContext.addAttribute("workflow_style", (Object)workflowStyle);
                DeploymentBuilder builder = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8));
                if (finalVersion == null) {
                    return builder.deploy(true);
                }
                return builder.deploy(finalVersion);
            });
            String deploymentModel = this.lcdpBpmProperties.getDeploymentModel();
            boolean isExternal = "external".equals(this.lcdpBpmProperties.getTenantType());
            boolean isWorkflow = "workflow-platform".equals(deploymentModel);
            if (HussarUtils.isNotEmpty((Object)proDefId) && flag && (!isWorkflow || !isExternal)) {
                BpmActReProcdef bpmActReProcdef = (BpmActReProcdef)this.bpmActReProcdefService.getById((Serializable)((Object)proDefId));
                Integer realVersion = bpmActReProcdef.getRealVersion();
                if (HussarUtils.isEmpty((Object)realVersion)) {
                    realVersion = bpmActReProcdef.getVersion();
                }
                LambdaUpdateWrapper bpmActReProcdefLambdaUpdateWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)bpmActReProcdefLambdaUpdateWrapper.eq(BpmActReProcdef::getDeploymentId, (Object)Long.valueOf(deployment.getId()))).set(BpmActReProcdef::getRealVersion, (Object)realVersion)).set(BpmActReProcdef::getMainProcess, (Object)bpmActReProcdef.getMainProcess());
                this.bpmActReProcdefService.update((Wrapper)bpmActReProcdefLambdaUpdateWrapper);
            }
            modelData.setDeploymentId(deployment.getId());
            if (workFlow == null) {
                workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(modelData.getKey(), null, false, Integer.valueOf(0), false);
            }
            modelData.setName(workFlow.getName());
            modelData.setCategory(workFlow.getCategory());
            ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
            modelObjectNode.put("name", workFlow.getName());
            modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
            modelObjectNode.put("revision", 1);
            modelData.setMetaInfo(modelObjectNode.toString());
            modelData.setDeploymentId(deployment.getId());
            modelData.setWorkflowStyle(workFlow.getWorkflowStyle());
            modelData.setModelType(modelType);
            modelData.setAppCode(appCode);
            if (HussarUtils.isNotEmpty((Object)workFlow.getProcessTag())) {
                modelData.setOrganId(workFlow.getProcessTag());
            }
            String nameTranslateKey = ActivitiTranslateUtil.getTranslateKey((Map)bpmnModel.getMainProcess().getExtensionElements(), (String)"processNameTranslateId");
            modelData.setNameTranslateKey(nameTranslateKey);
            this.repositoryService.saveModel(modelData);
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(modelData.getDeploymentId()).latestVersion().singleResult();
            this.saveModelExtendProperties(bpmnModel, processDefinition);
            workFlow.setProcDefId(processDefinition.getId());
            workFlow.setVersion(String.valueOf(processDefinition.getVersion()));
            this.sysActProcessFileService.addFile(workFlow, null);
            if (HussarUtils.isEmpty((Object)workFlow.getProcessTag())) {
                this.sysActProcessFileService.updateFile(workFlow, Integer.valueOf(0));
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BpmActReProcdef::getId, (Object)workFlow.getProcDefId());
            updateWrapper.set(BpmActReProcdef::getNameTranslateKey, (Object)nameTranslateKey);
            if (HussarUtils.isNotEmpty((Object)workFlow.getProcessTag())) {
                updateWrapper.set(BpmActReProcdef::getOrganId, (Object)workFlow.getProcessTag());
            }
            this.bpmActReProcdefService.update((Wrapper)updateWrapper);
            this.processDefinitionsService.setNotMain(processDefinition.getKey(), workFlow.getProcessTag());
            return processDefinition.getId();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }
}

