/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.AddCustomNodeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.translate.util.BpmTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowRecipients;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequenceXy;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowTodoCondition;
import com.jxdinfo.hussar.workflow.engine.flowmodel.LineConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.MultiUser;
import com.jxdinfo.hussar.workflow.engine.flowmodel.SequenceSourceTarget;
import com.jxdinfo.hussar.workflow.engine.flowmodel.enums.BpmNodeTypeEnum;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.service.Bpm2XMLService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AddCustomNodeServiceImpl
implements AddCustomNodeService {
    private static final Logger logger = LoggerFactory.getLogger(AddCustomNodeServiceImpl.class);
    private static final String USER_TASK_WIDTH = "USER_TASK_WIDTH";
    private static final String USER_TASK_HEIGHT = "USER_TASK_HEIGHT";
    private static final String MOVE_WIDTH = "MOVE_WIDTH";
    private static final String MOVE_HEIGHT = "MOVE_HEIGHT";
    private static final String GATE_WAY_MOVE_WIDTH = "GATE_WAY_MOVE_WIDTH";
    private static final String GATE_WAY_MOVE_HEIGHT = "GATE_WAY_MOVE_HEIGHT";
    private static final String LINE_NAME_NUM = "LINE_NAME_NUM";
    private static final String LINE_NAME_HEIGHT = "LINE_NAME_HEIGHT";
    private static final Map<String, Map<String, Integer>> NODE_MESSAGE_MAP = new HashMap<String, Map<String, Integer>>();
    private static final String ADD_CUSTOM_PATH_ID_PREFIX = "jxd_bpm_custom_path";
    private Bpm2XMLService xmlService;
    private SysActProcessFileService sysActProcessFileService;
    private ITaskEngineService taskEngineService;
    private ModelService modelService;
    private BpmConstantProperties bpmConstantProperties;

    @Autowired
    public AddCustomNodeServiceImpl(Bpm2XMLService xmlService, ModelService modelService, SysActProcessFileService sysActProcessFileService, BpmConstantProperties bpmConstantProperties, ITaskEngineService taskEngineService) {
        this.xmlService = xmlService;
        this.modelService = modelService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.taskEngineService = taskEngineService;
        this.bpmConstantProperties = bpmConstantProperties;
    }

    public ApiResponse<String> isAddParallel(String taskId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        Task task = this.taskEngineService.getTask(taskId, "0");
        String identityId = task.getProcessDefinitionId().split(":")[0];
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessDefId(task.getProcessDefinitionId());
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List elements = flowModel.getSlots().getElement();
        List paths = flowModel.getSlots().getPath();
        String nextNodeId = null;
        block0: for (Object path : paths) {
            if (!path.getStart().getKey().equals(task.getTaskDefinitionKey())) continue;
            nextNodeId = path.getEnd().getKey();
            for (FlowObject flowObject : elements) {
                if (!flowObject.getId().equals(nextNodeId)) continue;
                if (BpmNodeTypeUtil.isParallelGateway((String)flowObject.getName()) || BpmNodeTypeUtil.isInclusiveGateway((String)flowObject.getName())) break block0;
                return ApiResponse.fail((String)BpmExceptionCodeEnum.IS_NOT_ADD_PARALLEL.getMessage());
            }
        }
        if (nextNodeId == null) {
            throw new BpmException(BpmExceptionCodeEnum.SUB_PROCESS_CONNOT_ADD_NODE);
        }
        ArrayList<String> gatewayNextNodeId = new ArrayList<String>();
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(nextNodeId)) continue;
            gatewayNextNodeId.add(path.getEnd().getKey());
        }
        String mergeGatewayId = null;
        for (FlowSequence path : paths) {
            if (!gatewayNextNodeId.contains(path.getStart().getKey())) continue;
            if (mergeGatewayId == null) {
                mergeGatewayId = path.getEnd().getKey();
                continue;
            }
            if (path.getEnd().getKey().equals(mergeGatewayId)) continue;
            return ApiResponse.fail((String)BpmExceptionCodeEnum.IS_NOT_CONFLUENCE_PARALLEL.getMessage());
        }
        if (mergeGatewayId == null) {
            return ApiResponse.fail((String)BpmExceptionCodeEnum.IS_NOT_CONFLUENCE_PARALLEL.getMessage());
        }
        for (FlowObject flowObject : elements) {
            if (!flowObject.getId().equals(mergeGatewayId)) continue;
            if (BpmNodeTypeUtil.isParallelGateway((String)flowObject.getName()) || BpmNodeTypeUtil.isInclusiveGateway((String)flowObject.getName())) break;
            return ApiResponse.fail((String)BpmExceptionCodeEnum.IS_NOT_CONFLUENCE_PARALLEL.getMessage());
        }
        return ApiResponse.success((String)BpmExceptionCodeEnum.IS_ADD_PARALLEL.getMessage());
    }

    public ApiResponse<String> isAddCustomNode(String taskId) {
        Task task = this.taskEngineService.getTask(taskId = RealTaskId.getRealTaskId(taskId), "0");
        String subProcessKey = task.getSubProcessKey();
        if (subProcessKey == null) {
            return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
        }
        return ApiResponse.fail((String)BpmExceptionCodeEnum.SUB_PROCESS_CONNOT_ADD_NODE.getMessage());
    }

    public ApiResponse<String> addNode(String taskId, String addList, String parallel) {
        if (HussarUtils.isEmpty((Object)(taskId = RealTaskId.getRealTaskId(taskId)))) {
            throw new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_START);
        }
        List list = (List)JSON.parseObject((String)addList, List.class);
        Task task = this.taskEngineService.getTask(taskId, "0");
        try {
            String identityId = task.getProcessDefinitionId().split(":")[0];
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessDefId(task.getProcessDefinitionId());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("nodeId", task.getTaskDefinitionKey());
            map.put("addList", list);
            map.put("parallel", parallel);
            ArrayList<String> addNodeIds = new ArrayList<String>();
            WorkFlow newWorkFlow = this.getNewWorkFlow(workFlow, addNodeIds, map);
            BpmnModel bpmnModel = this.xmlService.getBpmnModel(newWorkFlow, identityId);
            SysActProcessFile metaInfo = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)identityId)).eq(SysActProcessFile::getType, (Object)"meta")).eq(SysActProcessFile::getVersion, (Object)0));
            Long modelId = metaInfo.getModelId();
            if (Integer.valueOf(task.getProcessDefinitionId().split(":")[1]) <= 0) {
                this.xmlService.updateModel(newWorkFlow, bpmnModel, task.getProcessDefinitionId());
                this.modelService.addNodeSaveModelExtendProperties(bpmnModel, task.getProcessDefinitionId());
            } else {
                String version = task.getProcessDefinitionId().split(":")[1];
                this.modelService.deployModelByWorkFlowXml(newWorkFlow, bpmnModel, String.valueOf(modelId), task.getProcessInstanceId(), version);
            }
            return ApiResponse.success((Object)"1", (String)BpmExceptionCodeEnum.ADD_CUSTOM_NODE_SUCCESS.getMessage());
        }
        catch (BpmException e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)BpmExceptionCodeEnum.ERROR_ADD_CUSTOM_NODE.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private WorkFlow getNewWorkFlow(WorkFlow workFlow, List<String> addNodeIds, Map<String, Object> map) {
        String workflowStyle = workFlow.getWorkflowStyle();
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List elements = flowModel.getSlots().getElement();
        List paths = flowModel.getSlots().getPath();
        FlowProps extendFlowProps = null;
        List addList = (List)map.get("addList");
        String nextNodeId = "";
        boolean isParallel = false;
        boolean isDirection = false;
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(map.get("nodeId"))) continue;
            nextNodeId = path.getEnd().getKey();
            if (!"internet".equals(workflowStyle) || !"B".equals(path.getStart().getPort()) && !"T".equals(path.getStart().getPort())) break;
            isDirection = true;
            break;
        }
        if ("".equals(nextNodeId)) {
            throw new BpmException(BpmExceptionCodeEnum.SUB_PROCESS_CONNOT_ADD_NODE);
        }
        ArrayList<Map<String, String>> addIds = new ArrayList<Map<String, String>>();
        for (int i = 0; i < addList.size(); ++i) {
            addIds.add(this.getNewId());
        }
        String newNodeId = (String)((Map)addIds.get(0)).get("nodeId");
        String newPathId = (String)((Map)addIds.get(0)).get("pathId");
        for (FlowObject flowObject : elements) {
            if (flowObject.getId().equals(map.get("nodeId"))) {
                extendFlowProps = flowObject.getProps();
            }
            if (!flowObject.getId().equals(nextNodeId) || !BpmNodeTypeUtil.isParallelGateway((String)flowObject.getName()) && !BpmNodeTypeUtil.isInclusiveGateway((String)flowObject.getName())) continue;
            isParallel = true;
            List goOutPath = flowObject.getGoOutPathes();
            goOutPath.add(newPathId);
            for (Map map2 : addIds) {
                goOutPath.add(map2.get("pathId"));
            }
            flowObject.setGoOutPathes(goOutPath);
        }
        if (isParallel && "true".equals(map.get("parallel"))) {
            void var20_28;
            String endPointNodeId = this.getNextParallelNodeId(elements, paths, nextNodeId);
            if (HussarUtils.isEmpty((Object)endPointNodeId)) {
                throw new BpmException(BpmExceptionCodeEnum.IS_NOT_CONFLUENCE_PARALLEL);
            }
            ArrayList<String> nodeIds = new ArrayList<String>();
            List<Map<String, List<FlowSequenceXy>>> pointsList = this.getParallelNewPathPoints(paths, nextNodeId, endPointNodeId, addList.size(), nodeIds, elements, addList, workflowStyle, isDirection);
            for (FlowObject fixFlowObject : elements) {
                if (!((String)nodeIds.get(0)).equals(fixFlowObject.getInstanceKey())) continue;
                extendFlowProps = fixFlowObject.getProps();
                break;
            }
            boolean bl = false;
            while (var20_28 < pointsList.size()) {
                String nodeId = (String)((Map)addIds.get((int)var20_28)).get("nodeId") + "parallel_node" + (String)nodeIds.get(0);
                addNodeIds.add(nodeId);
                Map<String, List<FlowSequenceXy>> points = pointsList.get((int)var20_28);
                FlowSequenceXy point = points.get("startPoints").get(points.get("startPoints").size() - 1);
                if (isDirection) {
                    elements.add(this.newNode(nodeId, ((Map)addList.get((int)var20_28)).get("nodeName"), (String)((Map)addIds.get((int)var20_28)).get("endPathId"), ((Map)addList.get((int)var20_28)).get("nodeAssignee"), ((Map)addList.get((int)var20_28)).get("counterSwitch"), ((Map)addList.get((int)var20_28)).get("multiType"), ((Map)addList.get((int)var20_28)).get("multiNumber"), Double.parseDouble(point.getX()) - (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_WIDTH).intValue() / 2.0, Double.parseDouble(point.getY()) + (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_HEIGHT).intValue() / 2.0, extendFlowProps, workflowStyle));
                } else {
                    elements.add(this.newNode(nodeId, ((Map)addList.get((int)var20_28)).get("nodeName"), (String)((Map)addIds.get((int)var20_28)).get("endPathId"), ((Map)addList.get((int)var20_28)).get("nodeAssignee"), ((Map)addList.get((int)var20_28)).get("counterSwitch"), ((Map)addList.get((int)var20_28)).get("multiType"), ((Map)addList.get((int)var20_28)).get("multiNumber"), Double.parseDouble(point.getX()), Double.parseDouble(point.getY()), extendFlowProps, workflowStyle));
                }
                paths.add(this.newPath((String)((Map)addIds.get((int)var20_28)).get("pathId"), nextNodeId, nodeId, 0.0, 0.0, 0, 0, workflowStyle, points.get("startPoints")));
                paths.add(this.newPath((String)((Map)addIds.get((int)var20_28)).get("endPathId"), nodeId, endPointNodeId, 0.0, 0.0, 0, 0, workflowStyle, points.get("endPoints")));
                ++var20_28;
            }
            workFlow.setData(JSON.toJSONString((Object)flowModel));
            return workFlow;
        }
        boolean isInternetAdd = "internet".equals(workflowStyle) && "vertical".equals(flowModel.getProps().getFlowLayoutConfig());
        double x = 0.0;
        double y = 0.0;
        double nodeX = 0.0;
        double nodeY = 0.0;
        String pathId = "";
        Integer moveWidth = NODE_MESSAGE_MAP.get(workflowStyle).get(MOVE_WIDTH);
        int moveHeight = 0;
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(map.get("nodeId"))) continue;
            pathId = path.getId();
            path.getStart().setKey(newNodeId);
            if (isInternetAdd) {
                if ("T".equals(path.getStart().getPort())) {
                    if (!"internet".equals(workflowStyle)) continue;
                    moveWidth = null;
                    moveHeight = -NODE_MESSAGE_MAP.get(workflowStyle).get(MOVE_HEIGHT).intValue();
                    continue;
                }
                if (!"internet".equals(workflowStyle)) continue;
                moveWidth = null;
                moveHeight = NODE_MESSAGE_MAP.get(workflowStyle).get(MOVE_HEIGHT);
                continue;
            }
            if (!"L".equals(path.getStart().getPort())) continue;
            moveWidth = -moveWidth.intValue();
        }
        for (FlowObject flowObject : elements) {
            if (!flowObject.getInstanceKey().equals(map.get("nodeId"))) continue;
            flowObject.getGoOutPathes().set(0, newPathId);
            nodeX = Double.parseDouble(flowObject.getLeft()) + Double.parseDouble(flowObject.getWidth()) / 2.0;
            nodeY = Double.parseDouble(flowObject.getTop()) + Double.parseDouble(flowObject.getHeight()) / 2.0;
            x = Double.parseDouble(flowObject.getLeft());
            y = Double.parseDouble(flowObject.getTop()) + Double.parseDouble(flowObject.getHeight()) / 2.0;
            if (moveWidth == null || moveWidth <= 0) continue;
            x += Double.parseDouble(flowObject.getWidth());
        }
        ArrayList<String> list = new ArrayList<String>();
        for (FlowObject flowObject : elements) {
            if (moveWidth != null) {
                double flowObjectX = Double.parseDouble(flowObject.getLeft()) + Double.parseDouble(flowObject.getWidth()) / 2.0;
                if (moveWidth > 0 && flowObjectX > nodeX || moveWidth < 0 && flowObjectX < nodeX) {
                    flowObject.setLeft(String.valueOf(Double.parseDouble(flowObject.getLeft()) + (double)moveWidth.intValue()));
                    continue;
                }
            } else {
                double flowObjectY = Double.parseDouble(flowObject.getTop()) + Double.parseDouble(flowObject.getHeight()) / 2.0;
                if (moveHeight > 0 && flowObjectY > nodeY || moveHeight < 0 && flowObjectY < nodeY) {
                    flowObject.setTop(String.valueOf(Double.parseDouble(flowObject.getTop()) + (double)moveHeight));
                    continue;
                }
            }
            list.add(flowObject.getId());
        }
        for (FlowSequence path : paths) {
            FlowSequenceXy flowSequenceXy;
            int i;
            boolean isStartNotMove = list.contains(path.getStart().getKey());
            boolean isEndNotMove = list.contains(path.getEnd().getKey());
            if (path.getLineConfig() != null && path.getLineConfig().getX() != null) {
                int moveNum = 2;
                if (isStartNotMove) {
                    --moveNum;
                }
                if (isEndNotMove) {
                    --moveNum;
                }
                if (moveNum > 0) {
                    if (moveWidth != null) {
                        Double lineConfigX = Double.valueOf(path.getLineConfig().getX());
                        lineConfigX = lineConfigX + (double)moveWidth.intValue() / 2.0 * (double)moveNum;
                        path.getLineConfig().setX(String.valueOf(lineConfigX));
                    } else {
                        Double lineConfigY = Double.valueOf(path.getLineConfig().getY());
                        lineConfigY = lineConfigY + (double)moveHeight / 2.0 * (double)moveNum;
                        path.getLineConfig().setY(String.valueOf(lineConfigY));
                    }
                }
            }
            List listXy = path.getPoints();
            for (i = 0; i < listXy.size(); ++i) {
                if (i == 0 && isStartNotMove || i == listXy.size() - 1 && isEndNotMove) continue;
                flowSequenceXy = (FlowSequenceXy)listXy.get(i);
                if (i != 0 && i != listXy.size() - 1 && (isStartNotMove && ((FlowSequenceXy)listXy.get(0)).getX().equals(flowSequenceXy.getX()) || isEndNotMove && ((FlowSequenceXy)listXy.get(listXy.size() - 1)).getX().equals(flowSequenceXy.getX()) || (moveWidth == null ? moveHeight > 0 && Double.parseDouble(flowSequenceXy.getY()) < nodeY || moveHeight < 0 && Double.parseDouble(flowSequenceXy.getY()) > nodeY : moveWidth > 0 && Double.parseDouble(flowSequenceXy.getX()) < nodeX || moveWidth < 0 && Double.parseDouble(flowSequenceXy.getX()) > nodeX))) continue;
                if (moveWidth != null) {
                    flowSequenceXy.setX(String.valueOf(Double.parseDouble(flowSequenceXy.getX()) + (double)moveWidth.intValue()));
                    continue;
                }
                flowSequenceXy.setY(String.valueOf(Double.parseDouble(flowSequenceXy.getY()) + (double)moveHeight));
            }
            for (i = 0; i < listXy.size() - 1; ++i) {
                FlowSequenceXy flowSequenceXyNewPoint2;
                FlowSequenceXy flowSequenceXyNewPoint1;
                flowSequenceXy = (FlowSequenceXy)listXy.get(i);
                FlowSequenceXy flowSequenceXyNext = (FlowSequenceXy)listXy.get(i + 1);
                if (flowSequenceXy.getX().equals(flowSequenceXyNext.getX()) || flowSequenceXy.getY().equals(flowSequenceXyNext.getY())) continue;
                if (moveWidth != null) {
                    flowSequenceXyNewPoint1 = new FlowSequenceXy();
                    flowSequenceXyNewPoint2 = new FlowSequenceXy();
                    flowSequenceXyNewPoint1.setX(flowSequenceXy.getX());
                    flowSequenceXyNewPoint2.setX(flowSequenceXyNext.getX());
                    double newPointY = (Double.parseDouble(flowSequenceXy.getY()) + Double.parseDouble(flowSequenceXyNext.getY())) / 2.0;
                    flowSequenceXyNewPoint1.setY(String.valueOf(newPointY));
                    flowSequenceXyNewPoint2.setY(String.valueOf(newPointY));
                    listXy.add(i + 1, flowSequenceXyNewPoint1);
                    listXy.add(i + 2, flowSequenceXyNewPoint2);
                    continue;
                }
                flowSequenceXyNewPoint1 = new FlowSequenceXy();
                flowSequenceXyNewPoint2 = new FlowSequenceXy();
                flowSequenceXyNewPoint1.setY(flowSequenceXy.getY());
                flowSequenceXyNewPoint2.setY(flowSequenceXyNext.getY());
                double newPointX = (Double.parseDouble(flowSequenceXy.getX()) + Double.parseDouble(flowSequenceXyNext.getX())) / 2.0;
                flowSequenceXyNewPoint1.setX(String.valueOf(newPointX));
                flowSequenceXyNewPoint2.setX(String.valueOf(newPointX));
                listXy.add(i + 1, flowSequenceXyNewPoint1);
                listXy.add(i + 2, flowSequenceXyNewPoint2);
            }
        }
        if (moveWidth != null) {
            paths.add(this.newPath(newPathId, (String)map.get("nodeId"), newNodeId, x, y, moveWidth, moveHeight, workflowStyle, null));
            x = moveWidth < 0 ? (x += (double)moveWidth.intValue()) : x + (double)moveWidth.intValue() - (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_WIDTH).intValue();
        } else {
            if (moveHeight < 0) {
                x += (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_WIDTH).intValue() / 2.0;
                y -= (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_HEIGHT).intValue() / 2.0;
            } else {
                x += (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_WIDTH).intValue() / 2.0;
                y += (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_HEIGHT).intValue() / 2.0;
            }
            paths.add(this.newPath(newPathId, (String)map.get("nodeId"), newNodeId, x, y, moveWidth, moveHeight, workflowStyle, null));
            if (moveHeight < 0) {
                x -= (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_WIDTH).intValue() / 2.0;
                y += (double)moveHeight;
            } else {
                x -= (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_WIDTH).intValue() / 2.0;
                y = y + (double)moveHeight - (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_HEIGHT).intValue() / 2.0;
            }
        }
        addNodeIds.add(newNodeId);
        elements.add(this.newNode(newNodeId, ((Map)addList.get(0)).get("nodeName"), pathId, ((Map)addList.get(0)).get("nodeAssignee"), ((Map)addList.get(0)).get("counterSwitch"), ((Map)addList.get(0)).get("multiType"), ((Map)addList.get(0)).get("multiNumber"), x, y, extendFlowProps, workflowStyle));
        workFlow.setData(JSON.toJSONString((Object)flowModel));
        return workFlow;
    }

    private String getNextParallelNodeId(List<FlowObject> elements, List<FlowSequence> paths, String nodeId) {
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(nodeId)) continue;
            String nextNodeId = path.getEnd().getKey();
            for (FlowObject flowObject : elements) {
                if (!flowObject.getId().equals(nextNodeId)) continue;
                if (BpmNodeTypeUtil.isParallelGateway((String)flowObject.getName()) || BpmNodeTypeUtil.isInclusiveGateway((String)flowObject.getName())) {
                    return nextNodeId;
                }
                return this.getNextParallelNodeId(elements, paths, nextNodeId);
            }
        }
        return null;
    }

    private List<Map<String, List<FlowSequenceXy>>> getParallelNewPathPoints(List<FlowSequence> paths, String nextNodeId, String endPointNodeId, int num, List<String> nodeIds, List<FlowObject> elements, List<Map<String, Object>> addList, String workflowStyle, boolean isDirection) {
        ArrayList<FlowSequenceXy> newEndPoints;
        ArrayList<FlowSequenceXy> endPoints;
        ArrayList<Map<String, List<FlowSequenceXy>>> list = new ArrayList<Map<String, List<FlowSequenceXy>>>();
        HashMap map = new HashMap();
        FlowSequenceXy start1 = null;
        FlowSequenceXy start2 = null;
        FlowSequenceXy startPoint1 = new FlowSequenceXy();
        FlowSequenceXy startPoint2 = new FlowSequenceXy();
        FlowSequenceXy startPoint3 = new FlowSequenceXy();
        FlowSequenceXy startPoint4 = new FlowSequenceXy();
        FlowSequenceXy end1 = null;
        FlowSequenceXy end2 = null;
        FlowSequenceXy endPoint1 = new FlowSequenceXy();
        FlowSequenceXy endPoint2 = new FlowSequenceXy();
        FlowSequenceXy endPoint3 = new FlowSequenceXy();
        FlowSequenceXy endPoint4 = new FlowSequenceXy();
        FlowSequenceXy startNode1 = new FlowSequenceXy();
        FlowSequenceXy startNode2 = new FlowSequenceXy();
        FlowSequenceXy startNode3 = new FlowSequenceXy();
        FlowSequenceXy endNode1 = new FlowSequenceXy();
        FlowSequenceXy endNode2 = new FlowSequenceXy();
        FlowSequenceXy endNode3 = new FlowSequenceXy();
        int lineNum = 0;
        for (FlowSequence path : paths) {
            List point;
            if (nextNodeId.equals(path.getStart().getKey())) {
                point = path.getPoints();
                double yChangeLength = 0.0;
                double xChangeLength = 0.0;
                int nameLineNum = 0;
                for (FlowObject flowObject : elements) {
                    if (!path.getEnd().getKey().equals(flowObject.getId())) continue;
                    yChangeLength = (Double.parseDouble(flowObject.getHeight()) - (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_HEIGHT).intValue()) / 2.0;
                    xChangeLength = (Double.parseDouble(flowObject.getWidth()) - (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_WIDTH).intValue()) / 2.0;
                    nameLineNum = flowObject.getProps().getFlowName().length() % NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_NUM) == 0 ? flowObject.getProps().getFlowName().length() / NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_NUM) : flowObject.getProps().getFlowName().length() / NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_NUM) + 1;
                }
                if (point.size() > 3) {
                    if (isDirection) {
                        double addX = Double.parseDouble(((FlowSequenceXy)point.get(2)).getX()) + (double)NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_WIDTH).intValue() + xChangeLength;
                        if (HussarUtils.isEmpty((Object)startPoint3.getX()) || Double.parseDouble(startPoint3.getX()) < addX) {
                            startPoint1 = (FlowSequenceXy)point.get(0);
                            startPoint2 = (FlowSequenceXy)point.get(1);
                            startPoint3.setY(((FlowSequenceXy)point.get(2)).getY());
                            startPoint3.setX(String.valueOf(addX));
                            startPoint4.setX(String.valueOf(addX));
                        }
                        startPoint4.setY(((FlowSequenceXy)point.get(3)).getY());
                    } else {
                        double addY = Double.parseDouble(((FlowSequenceXy)point.get(2)).getY()) + (double)NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_HEIGHT).intValue() + (double)(nameLineNum * NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_HEIGHT)) + yChangeLength;
                        if (HussarUtils.isEmpty((Object)startPoint3.getY()) || Double.parseDouble(startPoint3.getY()) < addY) {
                            startPoint1 = (FlowSequenceXy)point.get(0);
                            startPoint2 = (FlowSequenceXy)point.get(1);
                            startPoint3.setX(((FlowSequenceXy)point.get(2)).getX());
                            startPoint3.setY(String.valueOf(addY));
                            startPoint4.setY(String.valueOf(addY));
                        }
                        startPoint4.setX(((FlowSequenceXy)point.get(3)).getX());
                    }
                } else if (point.size() == 3) {
                    if (isDirection) {
                        double addX = Double.parseDouble(((FlowSequenceXy)point.get(2)).getX()) + (double)NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_WIDTH).intValue() + xChangeLength;
                        if (HussarUtils.isEmpty((Object)startNode3.getX()) || Double.parseDouble(startNode3.getX()) < addX) {
                            startNode1 = (FlowSequenceXy)point.get(0);
                            startNode2.setY(((FlowSequenceXy)point.get(1)).getY());
                            startNode3.setY(((FlowSequenceXy)point.get(2)).getY());
                            startNode2.setX(String.valueOf(addX));
                            startNode3.setX(String.valueOf(addX));
                        }
                    } else {
                        double addY = Double.parseDouble(((FlowSequenceXy)point.get(2)).getY()) + (double)NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_HEIGHT).intValue() + (double)(nameLineNum * NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_HEIGHT)) + yChangeLength;
                        if (HussarUtils.isEmpty((Object)startNode3.getY()) || Double.parseDouble(startNode3.getY()) < addY) {
                            startNode1 = (FlowSequenceXy)point.get(0);
                            startNode2.setX(((FlowSequenceXy)point.get(1)).getX());
                            startNode3.setX(((FlowSequenceXy)point.get(2)).getX());
                            startNode2.setY(String.valueOf(addY));
                            startNode3.setY(String.valueOf(addY));
                        }
                    }
                } else {
                    lineNum = nameLineNum;
                    start1 = (FlowSequenceXy)point.get(0);
                    start2 = (FlowSequenceXy)point.get(1);
                }
            }
            if (!endPointNodeId.equals(path.getEnd().getKey())) continue;
            if (!path.getStart().getKey().startsWith("jxd_bpm_custom_node")) {
                nodeIds.add(path.getStart().getKey());
            }
            if ((point = path.getPoints()).size() > 3) {
                if (isDirection) {
                    if (endPoint3.getX() != null && !(Double.parseDouble(((FlowSequenceXy)point.get(3)).getX()) > Double.parseDouble(endPoint3.getX()))) continue;
                    endPoint2.setY(((FlowSequenceXy)point.get(2)).getY());
                    endPoint3.setY(((FlowSequenceXy)point.get(2)).getY());
                    endPoint3.setX(((FlowSequenceXy)point.get(3)).getX());
                    endPoint4 = (FlowSequenceXy)point.get(3);
                    continue;
                }
                if (endPoint3.getY() != null && !(Double.parseDouble(((FlowSequenceXy)point.get(3)).getY()) > Double.parseDouble(endPoint3.getY()))) continue;
                endPoint2.setX(((FlowSequenceXy)point.get(2)).getX());
                endPoint3.setX(((FlowSequenceXy)point.get(2)).getX());
                endPoint3.setY(((FlowSequenceXy)point.get(3)).getY());
                endPoint4 = (FlowSequenceXy)point.get(3);
                continue;
            }
            if (point.size() == 3) {
                if (isDirection) {
                    if (endNode3.getX() != null && !(Double.parseDouble(((FlowSequenceXy)point.get(2)).getX()) > Double.parseDouble(endNode3.getX()))) continue;
                    endNode2.setY(((FlowSequenceXy)point.get(1)).getY());
                    endNode3 = (FlowSequenceXy)point.get(2);
                    continue;
                }
                if (endNode3.getY() != null && !(Double.parseDouble(((FlowSequenceXy)point.get(2)).getY()) > Double.parseDouble(endNode3.getY()))) continue;
                endNode2.setX(((FlowSequenceXy)point.get(1)).getX());
                endNode3 = (FlowSequenceXy)point.get(2);
                continue;
            }
            end1 = (FlowSequenceXy)point.get(0);
            end2 = (FlowSequenceXy)point.get(1);
        }
        if (isDirection) {
            if (HussarUtils.isNotEmpty((Object)startNode1.getY())) {
                endNode1.setX(startNode3.getX());
                endNode1.setY(String.valueOf(Double.parseDouble(startNode3.getY()) + (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_HEIGHT).intValue()));
                endNode2.setX(startNode3.getX());
            }
            if (start1 != null && start2 != null && HussarUtils.isEmpty((Object)startPoint3.getY()) && HussarUtils.isNotEmpty((Object)start1.getY())) {
                startPoint1 = start1;
                startPoint2.setX(start1.getX());
                String midY = String.valueOf((Double.parseDouble(start1.getY()) + Double.parseDouble(start2.getY())) / 2.0);
                startPoint2.setY(midY);
                startPoint3.setY(midY);
                startPoint4.setY(start2.getY());
            }
            if (HussarUtils.isNotEmpty(start1)) {
                double addX = Double.parseDouble(start1.getX()) + (double)NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_WIDTH).intValue();
                if (HussarUtils.isEmpty((Object)startPoint3.getX()) || Double.parseDouble(startPoint3.getX()) < addX) {
                    startPoint3.setX(String.valueOf(addX));
                    startPoint4.setX(String.valueOf(addX));
                }
            }
            if (HussarUtils.isNotEmpty((Object)startPoint1.getY())) {
                endPoint1.setX(startPoint4.getX());
                endPoint1.setY(String.valueOf(Double.parseDouble(startPoint4.getY()) + (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_HEIGHT).intValue()));
                endPoint2.setX(startPoint4.getX());
            }
            if (HussarUtils.isEmpty((Object)endPoint3.getY()) && end2 != null) {
                endPoint4 = end2;
                endPoint3.setX(end2.getX());
                String midY = String.valueOf((Double.parseDouble(end1.getY()) + Double.parseDouble(end2.getY())) / 2.0);
                endPoint2.setY(midY);
                endPoint3.setY(midY);
            }
            if (HussarUtils.isNotEmpty((Object)startNode2.getX()) && (startPoint3.getX() == null || Double.parseDouble(startNode2.getX()) > Double.parseDouble(startPoint3.getX()))) {
                ArrayList<FlowSequenceXy> startPoints = new ArrayList<FlowSequenceXy>();
                startPoints.add(startNode1);
                startPoints.add(startNode2);
                startPoints.add(startNode3);
                endPoints = new ArrayList<FlowSequenceXy>();
                endPoints.add(endNode1);
                endPoints.add(endNode2);
                endPoints.add(endNode3);
                map.put("startPoints", startPoints);
                map.put("endPoints", endPoints);
                list.add(map);
                for (int i = 1; i < num; ++i) {
                    String nodeName = (String)addList.get(i - 1).get("nodeName");
                    ArrayList<FlowSequenceXy> newStartPoints = new ArrayList<FlowSequenceXy>();
                    newStartPoints.add(startNode1);
                    FlowSequenceXy newStartNode2 = new FlowSequenceXy();
                    newStartNode2.setY(startNode2.getY());
                    newStartNode2.setX(String.valueOf(Double.parseDouble(startNode2.getX()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_WIDTH) * i)));
                    newStartPoints.add(newStartNode2);
                    FlowSequenceXy newStartNode3 = new FlowSequenceXy();
                    newStartNode3.setY(startNode3.getY());
                    newStartNode3.setX(String.valueOf(Double.parseDouble(startNode3.getX()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_WIDTH) * i)));
                    newStartPoints.add(newStartNode3);
                    ArrayList<FlowSequenceXy> newEndPoints2 = new ArrayList<FlowSequenceXy>();
                    FlowSequenceXy newEndNode1 = new FlowSequenceXy();
                    newEndNode1.setY(endNode1.getY());
                    newEndNode1.setX(String.valueOf(Double.parseDouble(endNode1.getX()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_WIDTH) * i)));
                    newEndPoints2.add(newEndNode1);
                    FlowSequenceXy newEndNode2 = new FlowSequenceXy();
                    newEndNode2.setY(endNode2.getY());
                    newEndNode2.setX(String.valueOf(Double.parseDouble(endNode2.getX()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_WIDTH) * i)));
                    newEndPoints2.add(newEndNode2);
                    newEndPoints2.add(endNode3);
                    HashMap<String, ArrayList<FlowSequenceXy>> newMap = new HashMap<String, ArrayList<FlowSequenceXy>>();
                    newMap.put("startPoints", newStartPoints);
                    newMap.put("endPoints", newEndPoints2);
                    list.add(newMap);
                }
                return list;
            }
        } else {
            if (HussarUtils.isNotEmpty((Object)startNode1.getX())) {
                endNode1.setY(startNode3.getY());
                endNode1.setX(String.valueOf(Double.parseDouble(startNode3.getX()) + (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_WIDTH).intValue()));
                endNode2.setY(startNode3.getY());
            }
            if (start1 != null && start2 != null && HussarUtils.isEmpty((Object)startPoint3.getX()) && HussarUtils.isNotEmpty((Object)start1.getX())) {
                startPoint1 = start1;
                startPoint2.setY(start1.getY());
                String midX = String.valueOf((Double.parseDouble(start1.getX()) + Double.parseDouble(start2.getX())) / 2.0);
                startPoint2.setX(midX);
                startPoint3.setX(midX);
                startPoint4.setX(start2.getX());
            }
            if (HussarUtils.isNotEmpty(start1)) {
                double addY = Double.parseDouble(start1.getY()) + (double)NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_HEIGHT).intValue() + (double)(lineNum * NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_HEIGHT));
                if (HussarUtils.isEmpty((Object)startPoint3.getY()) || Double.parseDouble(startPoint3.getY()) < addY) {
                    startPoint3.setY(String.valueOf(addY));
                    startPoint4.setY(String.valueOf(addY));
                }
            }
            if (HussarUtils.isNotEmpty((Object)startPoint1.getX())) {
                endPoint1.setY(startPoint4.getY());
                endPoint1.setX(String.valueOf(Double.parseDouble(startPoint4.getX()) + (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_WIDTH).intValue()));
                endPoint2.setY(startPoint4.getY());
            }
            if (HussarUtils.isEmpty((Object)endPoint3.getX()) && end2 != null) {
                endPoint4 = end2;
                endPoint3.setY(end2.getY());
                String midX = String.valueOf((Double.parseDouble(end1.getX()) + Double.parseDouble(end2.getX())) / 2.0);
                endPoint2.setX(midX);
                endPoint3.setX(midX);
            }
            if (HussarUtils.isNotEmpty((Object)startNode2.getY()) && (startPoint3.getY() == null || Double.parseDouble(startNode2.getY()) > Double.parseDouble(startPoint3.getY()))) {
                ArrayList<FlowSequenceXy> startPoints = new ArrayList<FlowSequenceXy>();
                startPoints.add(startNode1);
                startPoints.add(startNode2);
                startPoints.add(startNode3);
                endPoints = new ArrayList();
                endPoints.add(endNode1);
                endPoints.add(endNode2);
                endPoints.add(endNode3);
                map.put("startPoints", startPoints);
                map.put("endPoints", endPoints);
                list.add(map);
                int allNameLineNum = 0;
                for (int i = 1; i < num; ++i) {
                    String nodeName = (String)addList.get(i - 1).get("nodeName");
                    int nameLineNum = nodeName.length() % NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_NUM) == 0 ? nodeName.length() / NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_NUM) : nodeName.length() / NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_NUM) + 1;
                    allNameLineNum += nameLineNum;
                    ArrayList<FlowSequenceXy> newStartPoints = new ArrayList<FlowSequenceXy>();
                    newStartPoints.add(startNode1);
                    FlowSequenceXy newStartNode2 = new FlowSequenceXy();
                    newStartNode2.setX(startNode2.getX());
                    newStartNode2.setY(String.valueOf(Double.parseDouble(startNode2.getY()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_HEIGHT) * i) + (double)(allNameLineNum * NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_HEIGHT))));
                    newStartPoints.add(newStartNode2);
                    FlowSequenceXy newStartNode3 = new FlowSequenceXy();
                    newStartNode3.setX(startNode3.getX());
                    newStartNode3.setY(String.valueOf(Double.parseDouble(startNode3.getY()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_HEIGHT) * i) + (double)(allNameLineNum * NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_HEIGHT))));
                    newStartPoints.add(newStartNode3);
                    newEndPoints = new ArrayList<FlowSequenceXy>();
                    FlowSequenceXy newEndNode1 = new FlowSequenceXy();
                    newEndNode1.setX(endNode1.getX());
                    newEndNode1.setY(String.valueOf(Double.parseDouble(endNode1.getY()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_HEIGHT) * i) + (double)(allNameLineNum * NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_HEIGHT))));
                    newEndPoints.add(newEndNode1);
                    FlowSequenceXy newEndNode2 = new FlowSequenceXy();
                    newEndNode2.setX(endNode2.getX());
                    newEndNode2.setY(String.valueOf(Double.parseDouble(endNode2.getY()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_HEIGHT) * i) + (double)(allNameLineNum * NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_HEIGHT))));
                    newEndPoints.add(newEndNode2);
                    newEndPoints.add(endNode3);
                    HashMap<String, ArrayList<FlowSequenceXy>> newMap = new HashMap<String, ArrayList<FlowSequenceXy>>();
                    newMap.put("startPoints", newStartPoints);
                    newMap.put("endPoints", newEndPoints);
                    list.add(newMap);
                }
                return list;
            }
        }
        ArrayList<FlowSequenceXy> startPoints = new ArrayList<FlowSequenceXy>();
        startPoints.add(startPoint1);
        startPoints.add(startPoint2);
        startPoints.add(startPoint3);
        startPoints.add(startPoint4);
        endPoints = new ArrayList();
        endPoints.add(endPoint1);
        endPoints.add(endPoint2);
        endPoints.add(endPoint3);
        endPoints.add(endPoint4);
        map.put("startPoints", startPoints);
        map.put("endPoints", endPoints);
        list.add(map);
        int allNameLineNum = 0;
        if (isDirection) {
            for (int i = 1; i < num; ++i) {
                ArrayList<FlowSequenceXy> newStartPoints = new ArrayList<FlowSequenceXy>();
                newStartPoints.add(startPoint1);
                newStartPoints.add(startPoint2);
                FlowSequenceXy newStartPoint3 = new FlowSequenceXy();
                newStartPoint3.setY(startPoint3.getY());
                newStartPoint3.setX(String.valueOf(Double.parseDouble(startPoint3.getX()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_WIDTH) * i)));
                newStartPoints.add(newStartPoint3);
                FlowSequenceXy newStartPoint4 = new FlowSequenceXy();
                newStartPoint4.setY(startPoint4.getY());
                newStartPoint4.setX(String.valueOf(Double.parseDouble(startPoint4.getX()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_WIDTH) * i)));
                newStartPoints.add(newStartPoint4);
                ArrayList<FlowSequenceXy> newEndPoints3 = new ArrayList<FlowSequenceXy>();
                FlowSequenceXy newEndPoint1 = new FlowSequenceXy();
                newEndPoint1.setY(endPoint1.getY());
                newEndPoint1.setX(String.valueOf(Double.parseDouble(endPoint1.getX()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_WIDTH) * i)));
                newEndPoints3.add(newEndPoint1);
                FlowSequenceXy newEndPoint2 = new FlowSequenceXy();
                newEndPoint2.setY(endPoint2.getY());
                newEndPoint2.setX(String.valueOf(Double.parseDouble(endPoint2.getX()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_WIDTH) * i)));
                newEndPoints3.add(newEndPoint2);
                newEndPoints3.add(endPoint3);
                newEndPoints3.add(endPoint4);
                HashMap<String, ArrayList<FlowSequenceXy>> newMap = new HashMap<String, ArrayList<FlowSequenceXy>>();
                newMap.put("startPoints", newStartPoints);
                newMap.put("endPoints", newEndPoints3);
                list.add(newMap);
            }
        } else {
            for (int i = 1; i < num; ++i) {
                String nodeName = (String)addList.get(i - 1).get("nodeName");
                int nameLineNum = nodeName.length() % NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_NUM) == 0 ? nodeName.length() / NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_NUM) : nodeName.length() / NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_NUM) + 1;
                allNameLineNum += nameLineNum;
                ArrayList<FlowSequenceXy> newStartPoints = new ArrayList<FlowSequenceXy>();
                newStartPoints.add(startPoint1);
                newStartPoints.add(startPoint2);
                FlowSequenceXy newStartPoint3 = new FlowSequenceXy();
                newStartPoint3.setX(startPoint3.getX());
                newStartPoint3.setY(String.valueOf(Double.parseDouble(startPoint3.getY()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_HEIGHT) * i) + (double)(allNameLineNum * NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_HEIGHT))));
                newStartPoints.add(newStartPoint3);
                FlowSequenceXy newStartPoint4 = new FlowSequenceXy();
                newStartPoint4.setX(startPoint4.getX());
                newStartPoint4.setY(String.valueOf(Double.parseDouble(startPoint4.getY()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_HEIGHT) * i) + (double)(allNameLineNum * NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_HEIGHT))));
                newStartPoints.add(newStartPoint4);
                newEndPoints = new ArrayList();
                FlowSequenceXy newEndPoint1 = new FlowSequenceXy();
                newEndPoint1.setX(endPoint1.getX());
                newEndPoint1.setY(String.valueOf(Double.parseDouble(endPoint1.getY()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_HEIGHT) * i) + (double)(allNameLineNum * NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_HEIGHT))));
                newEndPoints.add(newEndPoint1);
                FlowSequenceXy newEndPoint2 = new FlowSequenceXy();
                newEndPoint2.setX(endPoint2.getX());
                newEndPoint2.setY(String.valueOf(Double.parseDouble(endPoint2.getY()) + (double)(NODE_MESSAGE_MAP.get(workflowStyle).get(GATE_WAY_MOVE_HEIGHT) * i) + (double)(allNameLineNum * NODE_MESSAGE_MAP.get(workflowStyle).get(LINE_NAME_HEIGHT))));
                newEndPoints.add(newEndPoint2);
                newEndPoints.add(endPoint3);
                newEndPoints.add(endPoint4);
                HashMap<String, ArrayList<FlowSequenceXy>> newMap = new HashMap<String, ArrayList<FlowSequenceXy>>();
                newMap.put("startPoints", newStartPoints);
                newMap.put("endPoints", newEndPoints);
                list.add(newMap);
            }
        }
        return list;
    }

    private Map<String, String> getNewId() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nodeId", "jxd_bpm_custom_node_" + (int)(1.0E7 + Math.random() * 9.0E7));
        map.put("pathId", "jxd_bpm_custom_path_" + (int)(1.0E7 + Math.random() * 9.0E7));
        map.put("endPathId", "jxd_bpm_custom_path_" + (int)(1.0E7 + Math.random() * 9.0E7));
        return map;
    }

    private FlowObject newNode(String nodeId, Object nodeName, String pathId, Object assignees, Object counterSwitch, Object multiType, Object multiNumber, double x, double y, FlowProps extendFlowProps, String workflowStyle) {
        FlowObject flowObject = new FlowObject();
        flowObject.setInstanceKey(nodeId);
        flowObject.setName(BpmNodeTypeEnum.BPM_USER.getTypeWithWorkflowStyle(workflowStyle));
        flowObject.setAlias("");
        flowObject.setWidth(String.valueOf(NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_WIDTH)));
        flowObject.setHeight(String.valueOf(NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_HEIGHT)));
        flowObject.setLeft(String.valueOf(x));
        flowObject.setTop(String.valueOf(y - (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_HEIGHT).intValue() / 2.0));
        FlowProps flowProps = new FlowProps();
        flowProps.setFormAddress((Map)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getFormAddress()), Map.class));
        flowProps.setFormDetailAddress((Map)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getFormDetailAddress()), Map.class));
        flowProps.setAssistFormAddress((Map)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getAssistFormAddress()), Map.class));
        flowProps.setAssistFormDetailAddress((Map)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getAssistFormDetailAddress()), Map.class));
        flowProps.setCcFormAddress((Map)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getCcFormAddress()), Map.class));
        flowProps.setCcFormDetailAddress((Map)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getCcFormDetailAddress()), Map.class));
        flowProps.setTodoConfiguration((FlowTodoCondition)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getTodoConfiguration()), FlowTodoCondition.class));
        flowProps.setUseVariables((List)JSON.parseObject((String)JSON.toJSONString((Object)extendFlowProps.getUseVariables()), List.class));
        flowProps.setMessageType(extendFlowProps.getMessageType());
        flowProps.setFlowName((String)nodeName);
        FlowAssignment flowAssignment = new FlowAssignment();
        flowAssignment.setJudgeBackCondition(new ArrayList());
        List<String> assigneeIds = Arrays.asList(((String)assignees).split(","));
        StringBuilder condition = new StringBuilder(" and O.ORGAN_ID IN ('" + assigneeIds.get(0) + "')");
        for (int i = 1; i < assigneeIds.size(); ++i) {
            condition.append(" or O.ORGAN_ID IN ('").append(assigneeIds.get(i)).append("')");
        }
        flowAssignment.setDefaultBackCondtion(condition.toString());
        flowProps.setFlowAssignment(flowAssignment);
        flowProps.setFlowRecipients(new FlowRecipients());
        flowProps.setDueDate("");
        flowProps.setFlowSkipRepetition("");
        flowProps.setFlowDefault(false);
        MultiUser multiUser = new MultiUser();
        multiUser.setCountersignNumByRatio(100.0);
        multiUser.setCountersign(false);
        multiUser.setCountersignNumByCount(0);
        multiUser.setCountersignType("radio");
        if (((Boolean)counterSwitch).booleanValue() && HussarUtils.isNotEmpty((Object)multiType) && HussarUtils.isNotEmpty((Object)multiNumber)) {
            multiUser.setCountersign(true);
            multiUser.setCountersignType((String)multiType);
            if ("radio".equals(multiType)) {
                multiUser.setCountersignNumByRatio(Double.parseDouble(String.valueOf(multiNumber)));
            } else {
                multiUser.setCountersignNumByCount(((Integer)multiNumber).intValue());
            }
        }
        flowProps.setFlowCountersign(multiUser);
        flowObject.setProps(flowProps);
        ArrayList<String> newPath = new ArrayList<String>();
        newPath.add(pathId);
        flowObject.setGoOutPathes(newPath);
        return flowObject;
    }

    private FlowSequence newPath(String pathId, String nodeId, String nextNodeId, double x, double y, Integer moveWidth, int moveHeight, String workflowStyle, List<FlowSequenceXy> points) {
        FlowSequence flowSequence = new FlowSequence();
        SequenceSourceTarget start = new SequenceSourceTarget();
        SequenceSourceTarget end = new SequenceSourceTarget();
        start.setKey(nodeId);
        end.setKey(nextNodeId);
        if (moveWidth != null) {
            if (moveWidth < 0) {
                start.setPort("L");
                end.setPort("R");
            } else {
                start.setPort("R");
                end.setPort("L");
            }
        } else if (moveHeight < 0) {
            start.setPort("T");
            end.setPort("B");
        } else {
            start.setPort("B");
            end.setPort("T");
        }
        flowSequence.setStart(start);
        flowSequence.setEnd(end);
        if (HussarUtils.isEmpty(points)) {
            points = new ArrayList<FlowSequenceXy>();
            FlowSequenceXy startXy = new FlowSequenceXy();
            startXy.setX(String.valueOf(x));
            startXy.setY(String.valueOf(y));
            points.add(startXy);
            FlowSequenceXy endXy = new FlowSequenceXy();
            if (moveWidth != null) {
                if (moveWidth > 0) {
                    endXy.setX(String.valueOf(x + (double)moveWidth.intValue() - (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_WIDTH).intValue()));
                } else {
                    endXy.setX(String.valueOf(x + (double)moveWidth.intValue() + (double)NODE_MESSAGE_MAP.get(workflowStyle).get(USER_TASK_WIDTH).intValue()));
                }
                endXy.setY(String.valueOf(y));
            } else {
                endXy.setX(String.valueOf(x));
                endXy.setY(String.valueOf(y + (double)moveHeight / 2.0));
            }
            points.add(endXy);
            flowSequence.setPoints(points);
        } else {
            ArrayList<FlowSequenceXy> pointList = new ArrayList<FlowSequenceXy>();
            for (FlowSequenceXy flowSequenceXy : points) {
                FlowSequenceXy sequenceXy = new FlowSequenceXy();
                sequenceXy.setX(flowSequenceXy.getX());
                sequenceXy.setY(flowSequenceXy.getY());
                pointList.add(sequenceXy);
            }
            flowSequence.setPoints(pointList);
        }
        flowSequence.setFlowDefault(false);
        flowSequence.setLineConfig(new LineConfig());
        flowSequence.setInstanceKey(pathId);
        flowSequence.setName(BpmNodeTypeEnum.BPM_SEQUENCE.getTypeWithWorkflowStyle(workflowStyle));
        flowSequence.setAlias("");
        flowSequence.setWidth("0");
        flowSequence.setHeight("0");
        FlowProps flowProps = new FlowProps();
        flowProps.setFlowName("");
        flowProps.setBackFlowCondition("");
        flowSequence.setProps(flowProps);
        flowSequence.setGoOutPathes(new ArrayList());
        return flowSequence;
    }

    static {
        HashMap<String, Integer> integerMap = new HashMap<String, Integer>();
        integerMap.put(USER_TASK_WIDTH, 184);
        integerMap.put(USER_TASK_HEIGHT, 66);
        integerMap.put(MOVE_WIDTH, (Integer)integerMap.get(USER_TASK_WIDTH) + 56);
        integerMap.put(MOVE_HEIGHT, (Integer)integerMap.get(USER_TASK_HEIGHT) + 56);
        integerMap.put(GATE_WAY_MOVE_WIDTH, (Integer)integerMap.get(USER_TASK_WIDTH) + 56);
        integerMap.put(GATE_WAY_MOVE_HEIGHT, (Integer)integerMap.get(USER_TASK_HEIGHT) + 56);
        integerMap.put(LINE_NAME_NUM, 1);
        integerMap.put(LINE_NAME_HEIGHT, 0);
        NODE_MESSAGE_MAP.put("internet", integerMap);
        HashMap<String, Integer> bpmnMap = new HashMap<String, Integer>();
        bpmnMap.put(USER_TASK_WIDTH, 48);
        bpmnMap.put(USER_TASK_HEIGHT, 48);
        bpmnMap.put(MOVE_WIDTH, 2 * (Integer)bpmnMap.get(USER_TASK_WIDTH));
        bpmnMap.put(GATE_WAY_MOVE_HEIGHT, 75);
        bpmnMap.put(LINE_NAME_NUM, 6);
        bpmnMap.put(LINE_NAME_HEIGHT, 16);
        NODE_MESSAGE_MAP.put("bpmn", bpmnMap);
        NODE_MESSAGE_MAP.put(null, bpmnMap);
        NODE_MESSAGE_MAP.put("", bpmnMap);
    }
}

