/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processtest.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.processtest.dao.TestLogMapper;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.SysActTestDetail;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.SysActTestLog;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.TestLogDetailService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.TestLogService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestLogServiceImpl
extends HussarServiceImpl<TestLogMapper, SysActTestLog>
implements TestLogService {
    @Autowired
    private TestLogDetailService testLogDetailService;
    @Resource
    private HistoryService historyService;

    public ApiResponse<?> getWorkflowLog(String procInstId, String businessId) {
        String superProcInstId = procInstId;
        boolean superflag = true;
        while (superflag) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(superProcInstId).singleResult();
            if (HussarUtils.isEmpty((Object)historicProcessInstance.getSuperProcessInstanceId())) {
                superflag = false;
                continue;
            }
            superProcInstId = historicProcessInstance.getSuperProcessInstanceId();
        }
        List detailList = (List)this.testLogDetailService.getWorkflowLog(superProcInstId, null).getData();
        if (HussarUtils.isNotEmpty((Object)detailList)) {
            Long parentLogId = ((SysActTestDetail)detailList.get(0)).getLogId();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysActTestLog::getLogId, (Object)parentLogId);
            List list = this.list((Wrapper)queryWrapper);
            return ApiResponse.success((Object)list);
        }
        return ApiResponse.success(new ArrayList());
    }

    public ApiResponse<?> deleteWorkflowLog(String procInstId, String businessId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActTestLog::getProcInstId, (Object)Long.valueOf(procInstId));
        if (HussarUtils.isNotEmpty((Object)businessId)) {
            queryWrapper.eq(SysActTestLog::getBusinessId, (Object)businessId);
        }
        this.remove((Wrapper)queryWrapper);
        return ApiResponse.success();
    }

    public ApiResponse<?> updateState(SysActTestLog sysActTestLog) {
        SysActTestLog updateTestLog = (SysActTestLog)this.getById(sysActTestLog.getLogId());
        updateTestLog.setTestResult(sysActTestLog.getTestResult());
        updateTestLog.setConfigDetail(sysActTestLog.getConfigDetail());
        updateTestLog.setParentNodeId(sysActTestLog.getParentNodeId());
        updateTestLog.setProcInstId(sysActTestLog.getProcInstId());
        updateTestLog.setTaskDefId(sysActTestLog.getTaskDefId());
        this.updateById((BaseEntity)sysActTestLog);
        return ApiResponse.success();
    }
}

