/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.interfaces.Func;
import com.baomidou.mybatisplus.core.conditions.interfaces.Join;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuIdentitylink;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuTask;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuIdentitylinkService;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuTaskService;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.config.WorkflowSnowflakeIDGenerator;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskAssigneeSecurityLevelDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddHistoryTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.dao.ProcessTransferMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.dto.TransferDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.service.impl.AsyncTransferTask;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.vo.TransferProgressInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import com.jxdinfo.hussar.workflow.engine.processtransfer.IProcessTransferService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskStateType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@HussarTokenDs
public class ProcessTransferServiceImpl
implements IProcessTransferService {
    @Autowired
    private IBpmActRuIdentitylinkService identityLinkService;
    @Resource
    private IBpmActRuTaskService taskService;
    @Resource
    private ProcessTransferMapper processTransferMapper;
    @Resource
    private ProcessEngine processEngine;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService sysActUrgeTaskService;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;
    private AsyncTransferTask asyncTransferTask;
    @Value(value="${hussar.bpm.use-security-level}")
    Boolean isUseSecurityLevel;
    private static final int MAX_IN_LIST_SIZE = 1000;
    private static final int MAX_SERIAL_SIZE = 1;
    @Autowired
    private WorkflowSnowflakeIDGenerator idGenerator;
    @Autowired
    private IBpmActRuTaskService bpmActRuTaskService;

    @Autowired
    public void setAsyncTransferTask(AsyncTransferTask asyncTransferTask) {
        this.asyncTransferTask = asyncTransferTask;
    }

    public BpmResponseResult transferTask(TransferDto transferDto) {
        if (transferDto == null || HussarUtils.hasEmpty((Object[])new Object[]{transferDto.getMandatary(), transferDto.getUserId()}) || HussarUtils.isAllEmpty((Object[])new Object[]{transferDto.getTaskIds(), transferDto.getProcessKeys()})) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL.getMessage());
        }
        if (!"1".equals(transferDto.getTransferType()) && Objects.equals(transferDto.getMandatary(), transferDto.getUserId())) {
            throw new BpmException(BpmExceptionCodeEnum.NO_MULTI_TRANSFER_TASK_ONESELF.getMessage());
        }
        Set<Object> identityLinkIdSet = new HashSet();
        Set<Long> taskIdLongSet = new HashSet();
        if (!"1".equals(transferDto.getTransferType())) {
            identityLinkIdSet = this.getIdentityLinkIdList(transferDto);
            taskIdLongSet = transferDto.getTaskIdLongSet();
        } else {
            HashMap taskUserMap = new HashMap();
            if (transferDto.getTaskIds().size() == transferDto.getIdentityLinkIds().size()) {
                for (int i = 0; i < transferDto.getTaskIds().size(); ++i) {
                    taskUserMap.put(transferDto.getTaskIds().get(i), transferDto.getIdentityLinkIds().get(i));
                }
                for (String taskId2 : transferDto.getTaskIds()) {
                    if (!HussarUtils.isEmpty(taskUserMap.get(taskId2))) continue;
                    taskIdLongSet.add(Long.valueOf(taskId2));
                }
            }
            identityLinkIdSet.addAll(transferDto.getIdentityLinkIds().stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        int allTaskNum = identityLinkIdSet.size() + taskIdLongSet.size();
        if (allTaskNum <= 1) {
            boolean[] array = new boolean[]{true};
            if (this.isUseSecurityLevel.booleanValue()) {
                identityLinkIdSet.forEach(identityLinkId -> this.transferSingleTaskSecurityLevel((Long)identityLinkId, transferDto.getMandatary(), transferDto.getUserId(), array));
                taskIdLongSet.forEach(taskId -> this.transferSingleTaskByTaskIdSecurityLevel((Long)taskId, transferDto.getMandatary(), transferDto.getUserId(), array));
            } else {
                identityLinkIdSet.forEach(identityLinkId -> this.transferSingleTask((Long)identityLinkId, transferDto.getMandatary(), transferDto.getUserId(), transferDto.getTransferType()));
                taskIdLongSet.forEach(taskId -> this.transferSingleTaskByTaskId((Long)taskId, transferDto.getMandatary(), transferDto.getUserId()));
            }
            if (!array[0]) {
                return InstallResult.fail((String)"\u88ab\u79fb\u4ea4\u4eba\u5bc6\u96c6\u8fc7\u4f4e");
            }
            return InstallResult.success();
        }
        long transferId = this.idGenerator.getSequence().nextValue();
        String tcode = HussarContextHolder.getHussarTenant().getTenantCode();
        String dataSourceName = this.dynamicDatasourceService.getCurrentDatasourceName();
        ServletRequestAttributes newServletRequestAttributes = HussarContextHolder.getNewServletRequestAttributes((String)tcode);
        int totalNum = identityLinkIdSet.size() + taskIdLongSet.size();
        this.asyncTransferTask.start(transferId, totalNum);
        this.asyncTransferTask.asyncTransferTask(identityLinkIdSet, taskIdLongSet, transferDto.getMandatary(), transferDto.getUserId(), transferId, tcode, dataSourceName, newServletRequestAttributes, transferDto.getTaskIds(), transferDto.getTransferType());
        return InstallResult.success((Object)transferId);
    }

    private <QW extends Func<QW, R> & Join<QW>, T, R> QW buildOverSizeListWrapper(Collection<T> collection, QW qw, R column) {
        if (collection.size() <= 1000) {
            qw.in(column, collection);
        } else {
            ArrayList<T> list = collection instanceof ArrayList ? (ArrayList<T>)collection : new ArrayList<T>(collection);
            ArrayList<List<T>> queryList = new ArrayList<List<T>>();
            int size = list.size();
            for (int i = 0; i < size; i += 1000) {
                queryList.add(list.subList(i, Math.min(size, i + 1000)));
            }
            for (List list2 : queryList) {
                ((Func)((Join<QW>)qw).or()).in(column, (Collection)list2);
            }
        }
        return qw;
    }

    private Set<Long> getIdentityLinkIdList(TransferDto transferDto) {
        HashSet<Long> identityLinkIdSet = new HashSet<Long>();
        ArrayList<Long> allTaskId = new ArrayList<Long>();
        HashSet<Long> taskIdLongSet = new HashSet<Long>();
        transferDto.setTaskIdLongSet(taskIdLongSet);
        String userId = transferDto.getUserId();
        if (HussarUtils.isNotEmpty((Object)transferDto.getTaskIds())) {
            HashMap<String, List> ownerTaskMap = new HashMap<String, List>();
            for (String taskId : transferDto.getTaskIds()) {
                int i = taskId.indexOf(58);
                if (i != -1 && i != taskId.length() - 1) {
                    String owner = taskId.substring(i + 1);
                    taskId = taskId.substring(0, i);
                    ownerTaskMap.computeIfAbsent(owner, key -> new ArrayList()).add(Long.valueOf(taskId));
                } else {
                    ownerTaskMap.computeIfAbsent(null, key -> new ArrayList()).add(Long.valueOf(taskId));
                }
                allTaskId.add(Long.valueOf(taskId));
            }
            LambdaQueryWrapper lambdaQuery = new LambdaQueryWrapper();
            lambdaQuery.nested(queryWrapper -> {
                for (Map.Entry entry : ownerTaskMap.entrySet()) {
                    String owner = (String)entry.getKey();
                    List taskIdList = (List)entry.getValue();
                    queryWrapper.or();
                    if (owner == null) {
                        queryWrapper.isNull(BpmActRuIdentitylink::getMandator);
                    } else {
                        queryWrapper.eq(BpmActRuIdentitylink::getMandator, (Object)owner);
                    }
                    if (taskIdList.size() == 1) {
                        queryWrapper.eq(BpmActRuIdentitylink::getTaskId, taskIdList.get(0));
                        continue;
                    }
                    queryWrapper.and(qw -> this.buildOverSizeListWrapper(taskIdList, qw, BpmActRuIdentitylink::getTaskId));
                }
            });
            ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQuery.eq(BpmActRuIdentitylink::getType, (Object)"candidate")).eq(BpmActRuIdentitylink::getUserId, (Object)userId)).select(new SFunction[]{BpmActRuIdentitylink::getId});
            List identitylinkList = this.identityLinkService.list((Wrapper)lambdaQuery);
            for (BpmActRuIdentitylink bpmActRuIdentitylink : identitylinkList) {
                identityLinkIdSet.add(bpmActRuIdentitylink.getId());
            }
            List taskList = this.taskService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().and(qw -> this.buildOverSizeListWrapper(allTaskId, qw, BpmActRuTask::getId))).eq(BpmActRuTask::getAssignee, (Object)userId));
            taskList.forEach(task -> taskIdLongSet.add(task.getId()));
        }
        if (HussarUtils.isNotEmpty((Object)transferDto.getProcessKeys())) {
            List<Long> taskIdList;
            List<Long> identityLinkIdList = this.processTransferMapper.getIdentityLinkIdListByCondition(userId, transferDto.getProcessKeys());
            if (!identityLinkIdList.isEmpty()) {
                identityLinkIdSet.addAll(identityLinkIdList);
            }
            if (!(taskIdList = this.processTransferMapper.getTaskIdListByCondition(userId, transferDto.getProcessKeys())).isEmpty()) {
                taskIdLongSet.addAll(taskIdList);
            }
        }
        return identityLinkIdSet;
    }

    @HussarTransactional
    public void transferSingleTask(Long identityLinkId, String mandatary, String userId, String transferType) {
        if (HussarUtils.isNotEmpty((Object)identityLinkId)) {
            this.processEngine.getManagementService().executeCommand(commandContext -> {
                IdentityLinkEntity identityLink = (IdentityLinkEntity)commandContext.getDbSqlSession().selectById(IdentityLinkEntity.class, identityLinkId.toString());
                if (identityLink == null) {
                    throw new BpmException(BpmExceptionCodeEnum.NOT_AUTHORITY_PROCESS_TASK.getMessage());
                }
                if (!"1".equals(transferType) && !Objects.equals(identityLink.getUserId(), userId)) {
                    throw new BpmException(BpmExceptionCodeEnum.NOT_AUTHORITY_HANDLE_TASK.getMessage());
                }
                TaskEntity task = commandContext.getTaskEntityManager().findTaskById(identityLink.getTaskId());
                if (task == null) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND.getMessage());
                }
                if (TaskType.isAssist((String)task.getTaskType())) {
                    throw new BpmException(BpmExceptionCodeEnum.ASSIST_TASK_WITH_ERROR_HANDLE.getMessage());
                }
                Iterator iterator = task.getIdentityLinks().iterator();
                while (iterator.hasNext()) {
                    IdentityLinkEntity next = (IdentityLinkEntity)iterator.next();
                    if (!next.getId().equals(identityLink.getId())) continue;
                    iterator.remove();
                    commandContext.getIdentityLinkEntityManager().deleteIdentityLink(next, true);
                    break;
                }
                String owner = identityLink.getMandator() == null ? userId : identityLink.getMandator();
                task.addCandidateUser(mandatary, Objects.equals(owner, mandatary) ? null : owner, "3");
                this.subsequent(mandatary, userId, commandContext, task, owner);
                return null;
            });
        }
    }

    private void subsequent(final String mandatary, String userId, CommandContext commandContext, TaskEntity task, final String owner) {
        String taskId = task.getId();
        new AddHistoryTaskCmd(task, null, userId, "transfer"){
            {
                super(task, comment, userId, taskSourceFlag);
                this.endTime = this.startTime;
            }

            @Override
            protected TaskEntity initTask(CommandContext commandContext, TaskEntity task, ExecutionEntity execution) {
                TaskEntity taskEntity = super.initTask(commandContext, task, execution);
                taskEntity.setTaskType("5");
                taskEntity.setParentTaskId(task.getId());
                taskEntity.setOwner(owner);
                taskEntity.setReceiver(mandatary);
                return taskEntity;
            }
        }.execute(commandContext);
        this.activityRedisTimerService.updateTimeOutModel(taskId, mandatary, userId, 0);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sysActUrgeTaskService.lambdaUpdate().eq(SysActUrgeTask::getTaskId, (Object)Long.parseLong(taskId))).eq(SysActUrgeTask::getReceiveUser, (Object)userId)).set(SysActUrgeTask::getReceiveUser, (Object)mandatary);
        BpmActRuTask bpmActRuTask = new BpmActRuTask();
        bpmActRuTask.setRev(Integer.valueOf(task.getRevision() + 1));
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BpmActRuTask::getId, (Object)Long.parseLong(task.getId()));
        lambdaQueryWrapper.eq(BpmActRuTask::getRev, (Object)task.getRevision());
        boolean updateSuccess = this.bpmActRuTaskService.update(bpmActRuTask, (Wrapper)lambdaQueryWrapper);
        if (!updateSuccess) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND.getMessage());
        }
        List<Map<String, String>> userMapList = this.getAssigneeMapByTaskId(task, userId, owner);
        this.dataPushService.entrustDataPush((Task)task, userId, mandatary, userMapList, owner);
    }

    @HussarTransactional
    public void transferSingleTaskByTaskId(Long taskId, String mandatary, String userId) {
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            TaskEntity task = commandContext.getTaskEntityManager().findTaskById(String.valueOf(taskId));
            if (task == null) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND.getMessage());
            }
            task.setAssignee(null);
            task.addCandidateUser(HussarUtils.isNotEmpty((Object)mandatary) ? mandatary : userId, userId, "3");
            this.subsequent(mandatary, userId, commandContext, task, userId);
            return null;
        });
    }

    @HussarTransactional
    public void transferSingleTaskSecurityLevel(Long identityLinkId, String mandatary, String userId, boolean[] array) {
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            IdentityLinkEntity identityLink = (IdentityLinkEntity)commandContext.getDbSqlSession().selectById(IdentityLinkEntity.class, identityLinkId.toString());
            if (identityLink == null) {
                throw new BpmException(BpmExceptionCodeEnum.NOT_AUTHORITY_PROCESS_TASK.getMessage());
            }
            if (!Objects.equals(identityLink.getUserId(), userId)) {
                throw new BpmException(BpmExceptionCodeEnum.NOT_AUTHORITY_HANDLE_TASK.getMessage());
            }
            TaskEntity task = commandContext.getTaskEntityManager().findTaskById(identityLink.getTaskId());
            if (task == null) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND.getMessage());
            }
            if (TaskType.isAssist((String)task.getTaskType())) {
                throw new BpmException(BpmExceptionCodeEnum.ASSIST_TASK_WITH_ERROR_HANDLE.getMessage());
            }
            String processInstanceId = task.getProcessInstanceId();
            HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            Integer securityLevel = historicProcessInstance.getSecurityLevel();
            ArrayList<String> users = new ArrayList<String>();
            users.add(mandatary);
            TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);
            List<TaskAssigneeSecurityLevelDto> taskAssigneeSecurityLevelDtos = taskEngineMapper.getUserSecurityLevel(users);
            for (int i = 0; i < taskAssigneeSecurityLevelDtos.size(); ++i) {
                if (taskAssigneeSecurityLevelDtos.get(i).getSecurityLevel() >= securityLevel) continue;
                array[0] = false;
                users.remove(taskAssigneeSecurityLevelDtos.get(i).getUserId());
            }
            if (HussarUtils.isEmpty(users)) {
                return null;
            }
            Iterator iterator = task.getIdentityLinks().iterator();
            while (iterator.hasNext()) {
                IdentityLinkEntity next = (IdentityLinkEntity)iterator.next();
                if (!next.getId().equals(identityLink.getId())) continue;
                iterator.remove();
                commandContext.getIdentityLinkEntityManager().deleteIdentityLink(next, true);
                break;
            }
            String owner = identityLink.getMandator() == null ? userId : identityLink.getMandator();
            task.addCandidateUser(mandatary, Objects.equals(owner, mandatary) ? null : owner, "3");
            this.subsequent(mandatary, userId, commandContext, task, owner);
            return null;
        });
    }

    @HussarTransactional
    public void transferSingleTaskByTaskIdSecurityLevel(Long taskId, String mandatary, String userId, boolean[] array) {
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            TaskEntity task = commandContext.getTaskEntityManager().findTaskById(String.valueOf(taskId));
            if (task == null) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND.getMessage());
            }
            String processInstanceId = task.getProcessInstanceId();
            HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            Integer securityLevel = historicProcessInstance.getSecurityLevel();
            ArrayList<String> users = new ArrayList<String>();
            users.add(mandatary);
            TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);
            List<TaskAssigneeSecurityLevelDto> taskAssigneeSecurityLevelDtos = taskEngineMapper.getUserSecurityLevel(users);
            for (int i = 0; i < taskAssigneeSecurityLevelDtos.size(); ++i) {
                if (taskAssigneeSecurityLevelDtos.get(i).getSecurityLevel() >= securityLevel) continue;
                array[0] = false;
                users.remove(taskAssigneeSecurityLevelDtos.get(i).getUserId());
            }
            if (HussarUtils.isEmpty(users)) {
                return null;
            }
            task.setAssignee(null);
            task.addCandidateUser(userId, userId, "3");
            this.subsequent(userId, mandatary, commandContext, task, userId);
            return null;
        });
    }

    public String queryIdentityLink(Long identityId, String taskId) {
        return this.processTransferMapper.queryIdentityLink(identityId, taskId);
    }

    public BpmResponseResult getTransferProgressInfo(Long transferId) {
        TransferProgressInfo transferProgressInfo = (TransferProgressInfo)HussarCacheUtil.get((String)"transferProgressInfo", (Object)transferId);
        if (transferProgressInfo == null) {
            return InstallResult.success();
        }
        return InstallResult.success((Object)transferProgressInfo);
    }

    private List<Map<String, String>> getAssigneeMapByTaskId(TaskEntity taskEntity, String userId, String owner) {
        List identityLinkList = taskEntity.getCandidates();
        if (HussarUtils.isNotEmpty((Object)userId) && HussarUtils.isNotEmpty((Object)owner)) {
            identityLinkList.removeIf(identityLink -> userId.equals(identityLink.getUserId()) && owner.equals(identityLink.getMandator()));
        } else if (HussarUtils.isNotEmpty((Object)userId)) {
            identityLinkList.removeIf(identityLink -> userId.equals(identityLink.getUserId()));
        }
        ArrayList<Map<String, String>> userMaps = new ArrayList<Map<String, String>>();
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink2 : identityLinkList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", identityLink2.getUserId());
                if (TaskStateType.isEntrust((IdentityLink)identityLink2)) {
                    map.put("mandator", identityLink2.getMandator());
                    map.put("taskState", identityLink2.getTaskState());
                }
                userMaps.add(map);
            }
        }
        return userMaps;
    }
}

