/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.service.impl;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskAssigneeSecurityLevelDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.vo.TransferProgressInfo;
import com.jxdinfo.hussar.workflow.engine.processtransfer.IProcessTransferService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class AsyncTransferTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncTransferTask.class);
    public static final String TRANSFER_PROGRESS_INFO_CACHE = "transferProgressInfo";
    private static final long OVER_TIME = 86400L;
    @Autowired
    private IProcessTransferService processTransferService;
    @Resource
    private ProcessEngine processEngine;
    @Value(value="${hussar.bpm.use-security-level}")
    Boolean isUseSecurityLevel;

    @Async
    public void asyncTransferTask(Set<Long> identityLinkIdSet, Set<Long> taskIdLongSet, String mandatary, String userId, long transferId, String tcode, String dataSourceName, ServletRequestAttributes servletRequestAttributes, List<String> taskIds, String transferType) {
        RequestContextHolder.setRequestAttributes((RequestAttributes)servletRequestAttributes);
        HussarContextHolder.setTenant((String)dataSourceName, (String)tcode);
        int totalNum = identityLinkIdSet.size() + taskIdLongSet.size();
        ArrayList<String> errorTaskIds = new ArrayList<String>();
        for (String string : taskIds) {
            if (!this.isUseSecurityLevel.booleanValue()) continue;
            TaskService taskService = (TaskService)SpringContextHolder.getBean(TaskService.class);
            Task task = (Task)((TaskQuery)((TaskQuery)taskService.createTaskQuery().taskId(String.valueOf(string))).queryChildTask()).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            Integer securityLevel = historicProcessInstance.getSecurityLevel();
            TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(mandatary);
            List<TaskAssigneeSecurityLevelDto> taskAssigneeSecurityLevelDtos = taskEngineMapper.getUserSecurityLevel(arrayList);
            for (int i = 0; i < taskAssigneeSecurityLevelDtos.size(); ++i) {
                if (taskAssigneeSecurityLevelDtos.get(i).getSecurityLevel() >= securityLevel) continue;
                errorTaskIds.add(string);
            }
        }
        for (Long l : taskIdLongSet) {
            try {
                if (this.isUseSecurityLevel.booleanValue()) {
                    boolean flag = false;
                    if (HussarUtils.isNotEmpty(errorTaskIds)) {
                        for (int i = 0; i < errorTaskIds.size(); ++i) {
                            if (!String.valueOf(l).equals(errorTaskIds.get(i))) continue;
                            this.fail(transferId, totalNum);
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                    }
                }
                this.processTransferService.transferSingleTaskByTaskId(l, mandatary, userId);
                this.success(transferId, totalNum);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.fail(transferId, totalNum);
            }
        }
        for (Long l : identityLinkIdSet) {
            try {
                if (this.isUseSecurityLevel.booleanValue()) {
                    String count = null;
                    if (HussarUtils.isNotEmpty(errorTaskIds)) {
                        for (int i = 0; i < errorTaskIds.size(); ++i) {
                            count = this.processTransferService.queryIdentityLink(l, (String)errorTaskIds.get(i));
                            if (count.equals("0")) continue;
                            this.fail(transferId, totalNum);
                            break;
                        }
                        if (count != null && !count.equals("0")) continue;
                    }
                }
                this.processTransferService.transferSingleTask(l, mandatary, userId, transferType);
                this.success(transferId, totalNum);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.fail(transferId, totalNum);
            }
        }
        this.end(transferId, totalNum);
    }

    public void start(long transferId, int totalNum) {
        HussarCacheUtil.put((String)TRANSFER_PROGRESS_INFO_CACHE, (Object)transferId, (Object)new TransferProgressInfo().setTotalNum((long)totalNum), (long)86400L);
    }

    private void success(long transferId, int totalNum) {
        TransferProgressInfo transferProgressInfo = (TransferProgressInfo)HussarCacheUtil.get((String)TRANSFER_PROGRESS_INFO_CACHE, (Object)transferId);
        if (transferProgressInfo == null) {
            transferProgressInfo = new TransferProgressInfo().setTotalNum((long)totalNum);
        }
        transferProgressInfo.setSuccessNum(transferProgressInfo.getSuccessNum() + 1L);
        if (transferProgressInfo.getSuccessNum() + transferProgressInfo.getFailNum() >= (long)totalNum) {
            transferProgressInfo.setEnd(true);
        }
        HussarCacheUtil.put((String)TRANSFER_PROGRESS_INFO_CACHE, (Object)transferId, (Object)transferProgressInfo, (long)86400L);
    }

    private void fail(long transferId, int totalNum) {
        TransferProgressInfo transferProgressInfo = (TransferProgressInfo)HussarCacheUtil.get((String)TRANSFER_PROGRESS_INFO_CACHE, (Object)transferId);
        if (transferProgressInfo == null) {
            transferProgressInfo = new TransferProgressInfo().setTotalNum((long)totalNum);
        }
        transferProgressInfo.setFailNum(transferProgressInfo.getFailNum() + 1L);
        if (transferProgressInfo.getSuccessNum() + transferProgressInfo.getFailNum() >= (long)totalNum) {
            transferProgressInfo.setEnd(true);
        }
        HussarCacheUtil.put((String)TRANSFER_PROGRESS_INFO_CACHE, (Object)transferId, (Object)transferProgressInfo, (long)86400L);
    }

    private void end(long transferId, int totalNum) {
        TransferProgressInfo transferProgressInfo = (TransferProgressInfo)HussarCacheUtil.get((String)TRANSFER_PROGRESS_INFO_CACHE, (Object)transferId);
        if (transferProgressInfo == null) {
            transferProgressInfo = new TransferProgressInfo().setTotalNum((long)totalNum);
        }
        transferProgressInfo.setEnd(true);
        HussarCacheUtil.put((String)TRANSFER_PROGRESS_INFO_CACHE, (Object)transferId, (Object)transferProgressInfo, (long)86400L);
    }
}

