/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dto.SysActCcTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dto.SysActCcTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.vo.SysActCcTaskVo;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskAssigneeSecurityLevelDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CcAddHistoryTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class SysActCcTaskServiceImpl
extends HussarServiceImpl<SysActCcTaskMapper, SysActCcTask>
implements ISysActCcTaskService {
    @Resource
    private SysActCcTaskMapper sysActCcTaskMapper;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private DataPushService dataPushService;
    @Lazy
    @Resource
    private HistoryService historyService;
    @Lazy
    @Resource
    private TaskService taskService;
    @Lazy
    @Resource
    private RuntimeService runtimeService;
    @Lazy
    @Resource
    private RepositoryService repositoryService;
    @Lazy
    @Resource
    private ProcessEngine processEngine;
    @Autowired
    private ISysActExtendPropertiesService sysActExtendPropertiesService;
    @Resource
    private FlowTaskMapper flowTaskMapper;
    private static Logger logger = LoggerFactory.getLogger(SysActCcTaskServiceImpl.class);
    private static final List<String> COMPLETE_HISTORY = new ArrayList<String>();
    @Value(value="${hussar.bpm.use-security-level}")
    Boolean isUseSecurityLevel;

    public ApiResponse<Page<SysActCcTaskVo>> query(Page<SysActCcTaskVo> pages, SysActCcTaskQueryDto sysActCcTaskQueryDto) {
        if (HussarUtils.isEmpty((Object)sysActCcTaskQueryDto.getUserId())) {
            return ApiResponse.fail((String)"\u63a5\u6536\u4eba\u4e3a\u7a7a");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)sysActCcTaskQueryDto.getStartTime()) ? formatter.parse(sysActCcTaskQueryDto.getStartTime()) : null;
            end = HussarUtils.isNotEmpty((Object)sysActCcTaskQueryDto.getEndTime()) ? formatter.parse(sysActCcTaskQueryDto.getEndTime()) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        long todoTotal = this.sysActCcTaskMapper.countCcTotal(start, end, sysActCcTaskQueryDto);
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<SysActCcTaskVo> sysActCcTasks = this.sysActCcTaskMapper.queryOutside(pages, start, end, sysActCcTaskQueryDto);
        if (sysActCcTasks != null && !sysActCcTasks.isEmpty()) {
            List users = sysActCcTasks.stream().map(SysActCcTaskVo::getSendUser).collect(Collectors.toList());
            HashMap map = this.iAssigneeChooseService.getUserListByUserId(users);
            if (map == null) {
                map = new HashMap();
            }
            HashSet<String> procDefIds = new HashSet<String>();
            for (SysActCcTaskVo sysActCcTask : sysActCcTasks) {
                if (!"1".equals(sysActCcTask.getTaskState())) continue;
                procDefIds.add(sysActCcTask.getProcDefId());
            }
            HashMap<String, String> ccFormDetailKeyMap = new HashMap<String, String>();
            if (!procDefIds.isEmpty()) {
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.in(SysActExtendProperties::getProcDefId, new Object[0]);
                List list = this.sysActExtendPropertiesService.list();
                for (SysActExtendProperties sysActExtendProperties : list) {
                    ccFormDetailKeyMap.put(sysActExtendProperties.getProcDefId() + ":" + sysActExtendProperties.getTaskDefKey(), sysActExtendProperties.getCcFormDetailKey());
                }
            }
            for (SysActCcTaskVo sysActCcTask : sysActCcTasks) {
                String appId;
                JSONObject object;
                String formDetailKey;
                String userName = (String)map.get(sysActCcTask.getSendUser());
                sysActCcTask.setSendUserName(userName);
                if ("0".equals(sysActCcTask.getTaskState())) {
                    formDetailKey = sysActCcTask.getFormKey();
                } else {
                    formDetailKey = ccFormDetailKeyMap.containsKey(sysActCcTask.getProcDefId() + ":" + sysActCcTask.getTaskDefKey()) ? (String)ccFormDetailKeyMap.get(sysActCcTask.getProcDefId() + ":" + sysActCcTask.getTaskDefKey()) : sysActCcTask.getFormKey();
                    sysActCcTask.setFormDetailKey(formDetailKey);
                }
                if (HussarUtils.isNotEmpty((Object)formDetailKey) && HussarUtils.isNotEmpty((Object)(object = JSON.parseObject((String)formDetailKey)))) {
                    sysActCcTask.setWebFormDetailKey(object.getString("web"));
                    sysActCcTask.setMobileFormDetailKey(object.getString("mobile"));
                }
                if (HussarUtils.isNotEmpty((Object)(appId = this.flowTaskMapper.getProcessAppId(sysActCcTask.getProcDefKey())))) {
                    sysActCcTask.setProcessType("0");
                    sysActCcTask.setAppId(appId);
                    continue;
                }
                sysActCcTask.setProcessType("1");
            }
        }
        pages.setRecords(sysActCcTasks);
        return ApiResponse.success(pages);
    }

    public ApiResponse<String> ccTask(SysActCcTaskDto sysActCcTaskDto) {
        List ccFormKeyList;
        Object ccFormKeyMap;
        String taskId = sysActCcTaskDto.getTaskId();
        if (HussarUtils.isEmpty((Object)taskId)) {
            return ApiResponse.fail((String)BpmExceptionCodeEnum.TASK_ID_NULL.getMessage());
        }
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId, sysActCcTaskDto.getUserId());
        String assignee = sysActCcTaskDto.getAssignee();
        String userId = sysActCcTaskDto.getUserId();
        if (HussarUtils.isEmpty((Object)assignee)) {
            return ApiResponse.fail((String)"\u63a5\u6536\u4eba\u4e3a\u7a7a");
        }
        ArrayList<String> receiverList = new ArrayList<String>(Arrays.asList(sysActCcTaskDto.getAssignee().split(",")));
        if (receiverList.contains(userId)) {
            return ApiResponse.fail((String)"\u4e0d\u53ef\u4f20\u9605\u7ed9\u81ea\u5df1");
        }
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().queryChildTask()).taskId(realTaskId.getTaskId())).singleResult();
        if (task == null) {
            return ApiResponse.fail((String)BpmExceptionCodeEnum.TASK_NOT_FOUND.getMessage());
        }
        if (TaskType.isAssist((String)task.getTaskType())) {
            return ApiResponse.fail((String)BpmExceptionCodeEnum.ASSIST_TASK_WITH_ERROR_HANDLE.getMessage());
        }
        if (this.isUseSecurityLevel.booleanValue()) {
            ArrayList<String> removeAssignees = new ArrayList<String>();
            String procInstanceId = task.getProcessInstanceId();
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(procInstanceId).singleResult();
            Integer securityLevel = historicProcessInstance.getSecurityLevel();
            ArrayList assigneeList = new ArrayList();
            assigneeList.add(assignee);
            TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);
            List<TaskAssigneeSecurityLevelDto> taskAssigneeSecurityLevelDtos = taskEngineMapper.getUserSecurityLevel(assigneeList);
            for (int i = 0; i < taskAssigneeSecurityLevelDtos.size(); ++i) {
                if (taskAssigneeSecurityLevelDtos.get(i).getSecurityLevel() >= securityLevel) continue;
                assigneeList.remove(taskAssigneeSecurityLevelDtos.get(i).getUserId());
                removeAssignees.add(taskAssigneeSecurityLevelDtos.get(i).getUserId());
            }
            if (HussarUtils.isEmpty((Object)assigneeList)) {
                String users = this.iAssigneeChooseService.getUserNames(removeAssignees);
                return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), null, (String)(users + "\u5bc6\u7ea7\u8fc7\u4f4e\uff0c\u4f20\u9605\u5931\u8d25"));
            }
        }
        HashSet users = new HashSet();
        List<HistoricTaskInstance> hisTaskList = this.getHisTask(task.getProcessInstanceId(), task.getTaskDefinitionKey());
        ArrayList<String> errorUserIds = new ArrayList<String>();
        ArrayList<String> hisTaskIds = new ArrayList<String>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            hisTaskIds.add(historicTaskInstance.getId());
            if (historicTaskInstance.getEndTime() == null) {
                List identityLinkList = this.taskService.getIdentityLinksType(historicTaskInstance.getId());
                for (IdentityLink identityLink : identityLinkList) {
                    if (!receiverList.contains(identityLink.getUserId())) continue;
                    errorUserIds.add(identityLink.getUserId());
                }
                continue;
            }
            if (!receiverList.contains(historicTaskInstance.getAssignee())) continue;
            errorUserIds.add(historicTaskInstance.getAssignee());
        }
        List<SysActCcTask> ccTaskList = this.getCcTaskList(Long.valueOf(task.getProcessInstanceId()), task.getTaskDefinitionKey(), task.getSubProcessKey());
        for (SysActCcTask sysActCcTask : ccTaskList) {
            if (!receiverList.contains(sysActCcTask.getReceiveUser())) continue;
            errorUserIds.add(sysActCcTask.getReceiveUser());
        }
        if (HussarUtils.isNotEmpty(errorUserIds)) {
            String string = this.iAssigneeChooseService.getUserNames(errorUserIds);
            return ApiResponse.fail((String)(string + "\u5df2\u5b58\u5728\u8be5\u8282\u70b9\u7684\u4efb\u52a1\u6216\u4f20\u9605\uff0c\u65e0\u6cd5\u6dfb\u52a0\u4e3a\u4f20\u9605\u4eba"));
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        List ccElement = (List)bpmnModel.getFlowElement(task.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
        String formKey = null;
        if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
            formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
        }
        for (String user : receiverList) {
            SysActCcTask sysActCcTask = new SysActCcTask();
            sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
            sysActCcTask.setProcName(historicProcessInstance.getProcessDefinitionName());
            sysActCcTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
            sysActCcTask.setTaskName(task.getName());
            sysActCcTask.setReceiveUser(user);
            sysActCcTask.setSendUser(sysActCcTaskDto.getUserId());
            sysActCcTask.setSendTime(ts);
            sysActCcTask.setFormKey(formKey);
            sysActCcTask.setTaskDefKey(task.getTaskDefinitionKey());
            sysActCcTask.setProcDefKey(historicProcessInstance.getProcessDefinitionKey());
            sysActCcTask.setProcDefId(historicProcessInstance.getProcessDefinitionId());
            sysActCcTask.setBusinessId(historicProcessInstance.getBusinessKey());
            sysActCcTask.setTaskState("0");
            sysActCcTask.setCcMoment("2");
            sysActCcTask.setToDoConfig(task.getTodoConfiguration());
            list.add(sysActCcTask);
        }
        this.saveBatch(list);
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(realTaskId.getTaskId());
        dataPush.setUserId(String.join((CharSequence)",", receiverList));
        dataPush.setCcMoment("2");
        dataPush.setStartDate((Date)ts);
        dataPush.setProcessInsId(execution.getProcessInstanceId());
        this.dataPushService.addCcTask(dataPush);
        this.processEngine.getManagementService().executeCommand((Command)new CcAddHistoryTaskCmd(execution, sysActCcTaskDto.getComment(), new Date(), sysActCcTaskDto.getUserId()));
        return ApiResponse.success();
    }

    public ApiResponse<String> read(Long ccTaskId) {
        if (ccTaskId == null) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        SysActCcTask sysActCcTask = (SysActCcTask)this.sysActCcTaskMapper.selectById(ccTaskId);
        if (HussarUtils.isEmpty((Object)sysActCcTask)) {
            return ApiResponse.fail((String)"\u6284\u9001\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        sysActCcTask.setTaskState("1");
        Date date = new Date();
        Timestamp endTime = new Timestamp(date.getTime());
        sysActCcTask.setEndTime(endTime);
        this.sysActCcTaskMapper.updateById(sysActCcTask);
        DataPush dataPush = new DataPush();
        dataPush.setUserId(sysActCcTask.getReceiveUser());
        dataPush.setTaskId(String.valueOf(sysActCcTask.getTaskId()));
        dataPush.setEndDate((Date)sysActCcTask.getEndTime());
        dataPush.setCcMoment(sysActCcTask.getCcMoment() == null ? "0" : sysActCcTask.getCcMoment());
        dataPush.setProcessInsId(String.valueOf(sysActCcTask.getProcessInsId()));
        this.dataPushService.readCcTask(dataPush);
        return ApiResponse.success();
    }

    public ApiResponse<String> readByTaskId(Long taskId, String ccMoment, String userId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysActCcTask::getTaskId, (Object)taskId);
        lambdaQueryWrapper.eq(HussarUtils.isNotEmpty((Object)ccMoment), SysActCcTask::getCcMoment, (Object)ccMoment);
        lambdaQueryWrapper.eq(SysActCcTask::getReceiveUser, (Object)userId);
        SysActCcTask sysActCcTask = (SysActCcTask)this.sysActCcTaskMapper.selectOne((Wrapper)lambdaQueryWrapper);
        if (sysActCcTask == null) {
            return ApiResponse.success();
        }
        sysActCcTask.setTaskState("1");
        Date date = new Date();
        Timestamp endTime = new Timestamp(date.getTime());
        sysActCcTask.setEndTime(endTime);
        this.sysActCcTaskMapper.updateById(sysActCcTask);
        DataPush dataPush = new DataPush();
        dataPush.setUserId(sysActCcTask.getReceiveUser());
        dataPush.setTaskId(String.valueOf(sysActCcTask.getTaskId()));
        dataPush.setEndDate((Date)sysActCcTask.getEndTime());
        dataPush.setCcMoment(sysActCcTask.getCcMoment() == null ? "0" : sysActCcTask.getCcMoment());
        dataPush.setProcessInsId(String.valueOf(sysActCcTask.getProcessInsId()));
        this.dataPushService.readCcTask(dataPush);
        return ApiResponse.success();
    }

    public ApiResponse<String> readBatch(List<Long> ccTaskIds) {
        if (ccTaskIds == null) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        Date date = new Date();
        Timestamp endTime = new Timestamp(date.getTime());
        List sysActCcTasks = this.sysActCcTaskMapper.selectBatchIds(ccTaskIds);
        for (SysActCcTask sysActCcTask : sysActCcTasks) {
            sysActCcTask.setEndTime(endTime);
            sysActCcTask.setTaskState("1");
            DataPush dataPush = new DataPush();
            dataPush.setUserId(sysActCcTask.getReceiveUser());
            dataPush.setTaskId(String.valueOf(sysActCcTask.getTaskId()));
            dataPush.setEndDate((Date)sysActCcTask.getEndTime());
            dataPush.setCcMoment(sysActCcTask.getCcMoment() == null ? "0" : sysActCcTask.getCcMoment());
            dataPush.setProcessInsId(String.valueOf(sysActCcTask.getProcessInsId()));
            this.dataPushService.readCcTask(dataPush);
        }
        this.updateBatchById(sysActCcTasks);
        return ApiResponse.success();
    }

    private List<HistoricTaskInstance> getHisTask(String processInsId, String activityId) {
        ArrayList<HistoricTaskInstance> hisTasks = new ArrayList<HistoricTaskInstance>();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(activityId)).queryChildTask()).list();
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            hisTaskList.sort((o1, o2) -> {
                if (o2.getEndTime() == null) {
                    return 1;
                }
                if (o1.getEndTime() == null) {
                    return -1;
                }
                return o2.getEndTime().compareTo(o1.getEndTime());
            });
            CommonCodeUtil.getLastCompleted(hisTaskList, hisTasks, task -> !TaskSourceFlag.NORMAL_COMPLETE.contains(task.getTaskSourceFlag()) && task.getEndTime() != null || TaskType.isRevoked((String)task.getTaskType()) || task.getParentTaskId() != null, Function.identity());
            Set parentIdSet = hisTasks.stream().map(TaskInfo::getId).collect(Collectors.toSet());
            for (HistoricTaskInstance taskInstance : hisTaskList) {
                if (!TaskType.isAssist((String)taskInstance.getTaskType()) || !parentIdSet.contains(taskInstance.getParentTaskId())) continue;
                hisTasks.add(taskInstance);
            }
        }
        return hisTasks;
    }

    public List<SysActCcTask> getCcTaskList(Long processInsId, String taskDefinitionKey, String subProcessKey) {
        return this.sysActCcTaskMapper.getCcTaskList(processInsId, taskDefinitionKey, subProcessKey);
    }

    static {
        COMPLETE_HISTORY.add("CcTaskHistory");
        COMPLETE_HISTORY.add("AssistHistory");
        COMPLETE_HISTORY.add("TransferHistory");
    }
}

