/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.assigneemode.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.workflow.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.assignee.dto.QueryAssigneeDto;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.OrganUserTree;
import com.jxdinfo.hussar.workflow.assignee.model.QueryWithUsersModel;
import com.jxdinfo.hussar.workflow.assignee.service.IWorkflowAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assigneemode.service.IAssigneeDSChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assigneemode.service.IAssigneeModeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssignModeChooseServiceImpl
implements IAssigneeModeChooseService {
    @Autowired
    private IWorkflowAssigneeChooseService workflowAssigneeChooseService;
    @Autowired
    private IAssigneeDSChooseService assigneeDSChooseService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    public static final String IMPORT = "import";
    public static final String REMOTE_INTERFACE = "remote-interface";
    public static final String REMOTE_DATA_SOURCE = "remote-datasource";

    private String connName() {
        return this.lcdpBpmProperties.getRemoteDBName();
    }

    private String getAssigneeMode() {
        return this.lcdpBpmProperties.getAssigneeMode();
    }

    private boolean getIdType() {
        String assigneeModel = this.getAssigneeMode();
        if (IMPORT.equals(assigneeModel)) {
            return !"workflow-platform".equals(this.lcdpBpmProperties.getDeploymentModel());
        }
        return this.lcdpBpmProperties.getTenantDBPrimaryKeyIsLong();
    }

    public String dealPath(String path) {
        return this.lcdpBpmProperties.getTenantCallAddress() + path;
    }

    public List<BpmTreeModel> userTree(String id, boolean isMainPost, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.userTree(id, isMainPost, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/userTree";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", id);
                params.put("isMainPost", JSON.toJSONString((Object)isMainPost));
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                String result2 = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result2, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.userTree(id, isMainPost, this.connName(), this.getIdType(), tablePrefix);
    }

    public List<OrganUserTree> userTreeForUserChoose(String id, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.userTreeForUserChoose(id, tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/userTreeForUserChoose";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", id);
                params.put("tablePrefix", tablePrefix);
                String result2 = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<OrganUserTree>();
                }
                return JSONArray.parseArray((String)result2, OrganUserTree.class);
            }
        }
        return this.assigneeDSChooseService.userTreeForUserChoose(id, this.connName(), tablePrefix);
    }

    public Page<BpmTreeModel> queryUserTreeForUserChoose(QueryAssigneeDto queryAssigneeDto, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryUserTreeForUserChoose(queryAssigneeDto, tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryUserTreeForUserChoose";
                url = this.dealPath(url);
                QueryWithUsersModel queryWithUsersModel = new QueryWithUsersModel();
                queryWithUsersModel.setPage(queryAssigneeDto.getPage());
                queryWithUsersModel.setOrganName(queryAssigneeDto.getOrganName());
                queryWithUsersModel.setType(queryWithUsersModel.getType());
                queryWithUsersModel.setUserIds(queryAssigneeDto.getUserIds());
                queryWithUsersModel.setTablePrefix(tablePrefix);
                String result = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)queryWithUsersModel));
                if (StringUtil.isEmpty((String)result)) {
                    return new Page();
                }
                return (Page)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryUserTreeForUserChoose(queryAssigneeDto, this.connName(), tablePrefix);
    }

    public List<BpmTreeModel> queryDeptUserForUserChoose(List<String> organIds, List<String> userIds, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryDeptUserForUserChoose(organIds, userIds, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryDeptUserForUserChoose";
                url = this.dealPath(url);
                QueryWithUsersModel queryWithUsersModel = new QueryWithUsersModel();
                queryWithUsersModel.setUserIds(userIds);
                queryWithUsersModel.setOrganIdList(organIds);
                queryWithUsersModel.setLongIdType(this.getIdType());
                queryWithUsersModel.setTablePrefix(tablePrefix);
                String result = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)queryWithUsersModel));
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryDeptUserForUserChoose(organIds, userIds, this.connName(), this.getIdType(), tablePrefix);
    }

    public List<BpmTreeModel> postTree(String id, String postId, boolean isMainPost, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.postTree(id, postId, isMainPost, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/postTree";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", id);
                params.put("isMainPost", JSON.toJSONString((Object)isMainPost));
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                String result2 = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result2, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.postTree(id, postId, isMainPost, this.connName(), this.getIdType(), tablePrefix);
    }

    public List<BpmTreeModel> deptTree(String id, String organId, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.deptTree(id, organId, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/deptTree";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", id);
                params.put("organId", organId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                String result2 = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result2, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.deptTree(id, organId, this.connName(), this.getIdType(), tablePrefix);
    }

    public List<BpmTreeModel> roleTree(String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.roleTree(tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/roleTreeWithOutId";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("tablePrefix", tablePrefix);
                String result2 = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result2, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.roleTree(this.connName(), tablePrefix);
    }

    public List<BpmTreeModel> roleTree(String id, String roleId, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.roleTree(id, roleId, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/roleTree";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", id);
                params.put("roleId", roleId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                String result2 = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result2, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.roleTree(id, roleId, this.connName(), this.getIdType(), tablePrefix);
    }

    public List<BpmTreeModel> userDeptDetail(String userId, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.userDeptDetail(userId, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/userDeptDetail";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.userDeptDetail(userId, this.connName(), this.getIdType(), tablePrefix);
    }

    public List<String> getCandidateUsers(String condition, Integer securityLevel, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getCandidateUser(condition, securityLevel, tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getCandidateUser";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("condition", condition);
                params.put("securityLevel", securityLevel == null ? null : securityLevel.toString());
                params.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<String>();
                }
                return JSONArray.parseArray((String)result, String.class);
            }
        }
        return this.assigneeDSChooseService.getCandidateUser(condition, securityLevel, this.connName(), tablePrefix);
    }

    public List<BpmTreeModel> getCandidateUsersWithParent(String condition, Integer securityLevel, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getCandidateUserWithParent(condition, securityLevel, tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getCandidateUserWithParent";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("condition", condition);
                params.put("securityLevel", securityLevel == null ? null : securityLevel.toString());
                params.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.getCandidateUserWithParent(condition, securityLevel, this.connName(), tablePrefix);
    }

    public String getParentDeptIdByUserId(String userId, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getParentDeptIdByUserId(userId, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getParentDeptIdByUserId";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getParentDeptIdByUserId(userId, this.connName(), this.getIdType(), tablePrefix);
    }

    public List<BpmTreeModel> userDetail(List<String> userIds, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.userDetail(userIds, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/userDetail";
                url = this.dealPath(url);
                QueryWithUsersModel queryWithUsersModel = new QueryWithUsersModel();
                queryWithUsersModel.setUserIds(userIds);
                queryWithUsersModel.setLongIdType(this.getIdType());
                queryWithUsersModel.setTablePrefix(tablePrefix);
                String result = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)queryWithUsersModel));
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.userDetail(userIds, this.connName(), this.getIdType(), tablePrefix);
    }

    public String getSameLevelDeptIdByUserId(String userId, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserId(userId, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getSameLevelDeptIdByUserId";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getSameLevelDeptIdByUserId(userId, this.connName(), this.getIdType(), tablePrefix);
    }

    public String getSameLevelDeptIdByOrganId(String organId, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getSameLevelDeptIdByOrganId(organId, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getSameLevelDeptIdByOrganId";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("organId", organId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getSameLevelDeptIdByOrganId(organId, this.connName(), this.getIdType(), tablePrefix);
    }

    public Page<BpmTreeModel> queryNodeAssigneeListByPageIncludeFuzzyQueryByName(Page<BpmTreeModel> pages, Long organId, List<List<Long>> users, String userName, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return pages.setRecords(this.workflowAssigneeChooseService.queryNodeAssigneeListByPageIncludeFuzzyQueryByName(pages, organId, users, userName, tablePrefix));
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getSameLevelDeptIdByUserId";
                url = this.dealPath(url);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("pages", pages);
                map.put("organId", organId);
                map.put("users", users);
                map.put("userName", userName);
                map.put("tablePrefix", tablePrefix);
                String params = JSONObject.toJSONString(map);
                return pages.setRecords((List)JSONObject.parseObject((String)HttpClient.doPost((String)url, (String)params), List.class));
            }
        }
        return pages.setRecords(this.assigneeDSChooseService.queryNodeAssigneeListByPageIncludeFuzzyQueryByName(pages, organId, users, userName, tablePrefix, this.connName()));
    }

    public String getDeptIdByUserIds(String userId, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getDeptIdByUserIds(userId, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getDeptIdByUserIds";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getDeptIdByUserIds(userId, this.connName(), this.getIdType(), tablePrefix);
    }

    public String getSameLevelDeptIdByUserIds(String userId, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserIds(userId, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getSameLevelDeptIdByUserIds";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getSameLevelDeptIdByUserIds(userId, this.connName(), this.getIdType(), tablePrefix);
    }

    public String getParentDeptIdByUserIds(String userId, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getParentDeptIdByUserIds(userId, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getParentDeptIdByUserIds";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getParentDeptIdByUserIds(userId, this.connName(), this.getIdType(), tablePrefix);
    }

    public Integer getSecurityLevel(String userId, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getSecurityLevel(userId, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getSecurityLevel";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, params);
                return Integer.parseInt(result);
            }
        }
        return this.assigneeDSChooseService.getSecurityLevel(userId, this.connName(), this.getIdType(), tablePrefix);
    }

    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryDeptTreeByDeptName(organName, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryDeptTreeByDeptName";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("organName", organName);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryDeptTreeByDeptName(organName, this.connName(), this.getIdType(), tablePrefix);
    }

    public List<BpmTreeModel> queryUserTreeByUserName(String organName, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryUserTreeByUserName(organName, tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryUserTreeByUserName";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("organName", organName);
                params.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryUserTreeByUserName(organName, this.connName(), tablePrefix);
    }

    public List<BpmTreeModel> queryPostTreeByPostName(String postName, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryPostTreeByPostName(postName, tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryPostTreeByPostName";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("postName", postName);
                params.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryPostTreeByPostName(postName, this.connName(), tablePrefix);
    }

    public List<BpmTreeModel> queryUserListByUserName(String organName, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryUserListByUserName(organName, tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryUserListByUserName";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("organName", organName);
                params.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryUserListByUserName(organName, this.connName(), tablePrefix);
    }

    public List<BpmTreeModel> queryRoleTreeByRoleName(String roleName, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryRoleTreeByRoleName(roleName, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryRoleTreeByRoleName";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("roleName", roleName);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryRoleTreeByRoleName(roleName, this.connName(), this.getIdType(), tablePrefix);
    }

    public List<BpmTreeModel> queryUserTree(String organName, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryUserTree(organName, tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryUserTree";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("organName", organName);
                params.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryUserTree(organName, this.connName(), tablePrefix);
    }

    public Page<BpmTreeModel> queryUserTreeByPage(Page<BpmTreeModel> pages, String organName, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryUserTreeByPage(pages, organName, tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryUserTreeByPage";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("size", String.valueOf(pages.getSize()));
                params.put("current", String.valueOf(pages.getCurrent()));
                params.put("organName", organName);
                params.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return pages;
                }
                return (Page)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryUserTreeByPage(pages, organName, this.connName(), tablePrefix);
    }

    public Page<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> pages, String organId, String type, String tablePrefix, String processInstanceId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryUserListByPage(pages, organId, type, this.getIdType(), tablePrefix, processInstanceId);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryUserListByPage";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("size", String.valueOf(pages.getSize()));
                params.put("current", String.valueOf(pages.getCurrent()));
                params.put("organId", organId);
                params.put("type", type);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                params.put("processInstanceId", String.valueOf(processInstanceId));
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return pages;
                }
                return (Page)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryUserListByPage(pages, organId, type, this.connName(), this.getIdType(), tablePrefix, processInstanceId);
    }

    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryDeptTreeByChildren(bpmTreeModel, tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryDeptTreeByChildren";
                url = this.dealPath(url);
                Map<String, String> params = new HashMap();
                params = (Map)JSON.parseObject((String)JSON.toJSONString((Object)bpmTreeModel), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                params.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, params);
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryDeptTreeByChildren(bpmTreeModel, this.connName(), tablePrefix);
    }

    public List<BpmTreeModel> queryAssigneeAndDept(List<String> users, String organName, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryAssigneeAndDept(users, organName, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryAssigneeAndDept";
                url = this.dealPath(url);
                QueryWithUsersModel queryWithUsersModel = new QueryWithUsersModel();
                queryWithUsersModel.setUserIds(users);
                queryWithUsersModel.setLongIdType(this.getIdType());
                queryWithUsersModel.setOrganName(organName);
                queryWithUsersModel.setTablePrefix(tablePrefix);
                String result = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)queryWithUsersModel));
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryAssigneeAndDept(users, organName, this.connName(), this.getIdType(), tablePrefix);
    }

    public Page<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> pages, List<String> userIds, String organId, String type, String tablePrefix, Integer securityLevel) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryNodeAssigneeListWithPage(pages, userIds, organId, null, type, this.getIdType(), tablePrefix, securityLevel);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryNodeAssigneeListByPage";
                url = this.dealPath(url);
                QueryWithUsersModel queryWithUsersModel = new QueryWithUsersModel();
                queryWithUsersModel.setPage(pages);
                queryWithUsersModel.setUserIds(userIds);
                queryWithUsersModel.setOrganId(organId);
                queryWithUsersModel.setType(type);
                queryWithUsersModel.setLongIdType(this.getIdType());
                queryWithUsersModel.setTablePrefix(tablePrefix);
                queryWithUsersModel.setSecurityLevel(securityLevel);
                String result = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)queryWithUsersModel));
                return (Page)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryNodeAssigneeListByPage(pages, userIds, type, organId, this.connName(), this.getIdType(), tablePrefix, securityLevel);
    }

    public Page<BpmTreeModel> queryNodeAssigneeListWithParentByPage(Page<BpmTreeModel> pages, List<BpmTreeModel> userIds, String organId, String type, String organName, String tablePrefix, Integer securityLevel) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryNodeAssigneeListWithParentByPage(pages, userIds, organId, type, this.getIdType(), organName, tablePrefix, securityLevel);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryNodeAssigneeListWithParentByPage";
                url = this.dealPath(url);
                QueryWithUsersModel queryWithUsersModel = new QueryWithUsersModel();
                queryWithUsersModel.setPage(pages);
                queryWithUsersModel.setUsers(userIds);
                queryWithUsersModel.setOrganId(organId);
                queryWithUsersModel.setLongIdType(this.getIdType());
                queryWithUsersModel.setType(type);
                queryWithUsersModel.setOrganName(organName);
                queryWithUsersModel.setTablePrefix(tablePrefix);
                queryWithUsersModel.setSecurityLevel(securityLevel);
                String result = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)queryWithUsersModel));
                return (Page)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryNodeAssigneeListWithParentByPage(pages, userIds, type, organId, this.connName(), this.getIdType(), organName, tablePrefix, securityLevel);
    }

    public IPage<BpmTreeModel> queryNodeAssigneeListWithPage(Page<BpmTreeModel> page, List<String> users, String organId, String organName, String type, String tablePrefix, Integer securityLevel) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryNodeAssigneeListWithPage(page, users, organId, organName, type, this.getIdType(), tablePrefix, securityLevel);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryNodeAssigneeListWithPage";
                url = this.dealPath(url);
                QueryWithUsersModel queryWithUsersModel = new QueryWithUsersModel();
                queryWithUsersModel.setOrganName(organName);
                queryWithUsersModel.setPage(page);
                queryWithUsersModel.setType(type);
                queryWithUsersModel.setOrganId(organId);
                queryWithUsersModel.setLongIdType(this.getIdType());
                queryWithUsersModel.setUserIds(users);
                queryWithUsersModel.setTablePrefix(tablePrefix);
                queryWithUsersModel.setSecurityLevel(securityLevel);
                String result = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)queryWithUsersModel));
                return (IPage)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryNodeAssigneeListWithPage(page, users, organId, organName, type, this.connName(), this.getIdType(), tablePrefix, securityLevel);
    }

    public List<AssigneeChooseDto> getUserAndAccountListByUserId(List<String> userIds, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserAndAccountListByUserId(userIds, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getUserAndAccountListByUserId";
                url = this.dealPath(url);
                QueryWithUsersModel queryWithUsersModel = new QueryWithUsersModel();
                queryWithUsersModel.setUserIds(userIds);
                queryWithUsersModel.setLongIdType(this.getIdType());
                queryWithUsersModel.setTablePrefix(tablePrefix);
                String result = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)queryWithUsersModel));
                return JSONArray.parseArray((String)result, AssigneeChooseDto.class);
            }
        }
        return this.assigneeDSChooseService.getUserAndAccountListByUserId(userIds, this.connName(), this.getIdType(), tablePrefix);
    }

    public List<BpmUserInfoVo> getUserMsgByUserIds(List<String> userIds, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserMsgByUserIds(userIds, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getUserMsgByUserIds";
                url = this.dealPath(url);
                QueryWithUsersModel queryWithUsersModel = new QueryWithUsersModel();
                queryWithUsersModel.setUserIds(userIds);
                queryWithUsersModel.setLongIdType(this.getIdType());
                queryWithUsersModel.setTablePrefix(tablePrefix);
                String result = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)queryWithUsersModel));
                return JSONArray.parseArray((String)result, BpmUserInfoVo.class);
            }
        }
        return this.assigneeDSChooseService.getUserMsgByUserIds(userIds, this.connName(), this.getIdType(), tablePrefix);
    }

    public Page<BpmUserInfoVo> queryList(Page<BpmUserInfoVo> page, GetListInfoVo getListDto, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryList(page, getListDto, this.getIdType(), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/list";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                String userName = getListDto.getUserName();
                String deptId = getListDto.getDeptId();
                String roleId = getListDto.getRoleId();
                String deptName = getListDto.getDeptName();
                String roleName = getListDto.getRoleName();
                String postId = getListDto.getPostId();
                params.put("size", String.valueOf(page.getSize()));
                params.put("current", String.valueOf(page.getCurrent()));
                params.put("userName", userName);
                params.put("deptId", deptId);
                params.put("roleId", roleId);
                params.put("deptName", deptName);
                params.put("roleName", roleName);
                params.put("postId", postId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, params);
                return (Page)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryList(page, getListDto, this.connName(), this.getIdType(), tablePrefix);
    }

    public List<AssigneeManageInfoVo> queryDept(String name, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryDept(name, tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryDept";
                url = this.dealPath(url);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("name", name);
                param.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, param);
                return JSONArray.parseArray((String)result, AssigneeManageInfoVo.class);
            }
        }
        return this.assigneeDSChooseService.queryDept(name, this.connName(), tablePrefix);
    }

    public List<AssigneeManageInfoVo> queryRole(String name, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryRole(name, tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryRole";
                url = this.dealPath(url);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("name", name);
                param.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, param);
                return JSONArray.parseArray((String)result, AssigneeManageInfoVo.class);
            }
        }
        return this.assigneeDSChooseService.queryRole(name, this.connName(), tablePrefix);
    }

    public List<AssigneeManageInfoVo> queryPost(String name, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryPost(name, tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryPost";
                url = this.dealPath(url);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("name", name);
                param.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, param);
                return JSONArray.parseArray((String)result, AssigneeManageInfoVo.class);
            }
        }
        return this.assigneeDSChooseService.queryRole(name, this.connName(), tablePrefix);
    }

    public List<String> getAllParentOrganId(String userId, String organId, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getAllParentOrganId(userId, organId, Boolean.valueOf(this.getIdType()), tablePrefix);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getAllParentOrganId";
                url = this.dealPath(url);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("userId", userId);
                param.put("organId", organId);
                param.put("longIdType", String.valueOf(this.getIdType()));
                param.put("tablePrefix", tablePrefix);
                String result = HttpClient.doGet((String)url, param);
                return JSONArray.parseArray((String)result, String.class);
            }
        }
        return this.assigneeDSChooseService.getAllParentOrganId(userId, organId, this.connName(), this.getIdType(), tablePrefix);
    }
}

