/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ExtendDataDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.extenddata.service.WorkflowExtendDataService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class MultiDelAssigneeHistoryTaskCmd
implements Command<TaskEntity> {
    private final Map<String, String> HISTORY_MAP = new HashMap<String, String>();
    private ExecutionEntity executionEntity;
    protected String comment;
    protected Date startTime;
    protected String userId;
    protected List<String> assigneeList;
    protected Map<String, Object> paramMap;
    protected TaskEntity task;
    protected DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private WorkflowExtendDataService workflowExtendDataService = (WorkflowExtendDataService)SpringContextHolder.getApplicationContext().getBean(WorkflowExtendDataService.class);

    public MultiDelAssigneeHistoryTaskCmd(ExecutionEntity executionEntity, String userId, List<String> assigneeList, String comment, Map<String, Object> paramMap) {
        this.executionEntity = executionEntity;
        this.comment = comment;
        this.startTime = new Date();
        this.userId = userId;
        this.assigneeList = assigneeList;
        this.paramMap = paramMap;
    }

    public TaskEntity execute(CommandContext commandContext) {
        TaskEntity task = this.getTask();
        ExecutionEntity execution = task.getExecution();
        TaskEntity taskEntity = this.initTask(commandContext, task, execution);
        taskEntity.insert(taskEntity.getExecution());
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)taskEntity));
        }
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(this.userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(taskEntity.getId());
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        if (HussarUtils.isNotEmpty(this.paramMap)) {
            ExtendDataDto extendDataDto = new ExtendDataDto();
            extendDataDto.setTaskId(taskEntity.getId());
            extendDataDto.setExtendData(this.paramMap);
            this.workflowExtendDataService.addExtendData(extendDataDto);
        }
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(taskEntity.getId());
        dataPush.setTaskDefinitionName(taskEntity.getName());
        dataPush.setUserId(this.userId);
        dataPush.setBusinessKey(taskEntity.getProcessInstance().getBusinessKey());
        dataPush.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
        dataPush.setProcessKey(taskEntity.getProcessDefinitionId().split(":")[0]);
        dataPush.setStartDate(this.startTime);
        dataPush.setEndDate(new Date());
        dataPush.setUrl(taskEntity.getFormKey());
        dataPush.setDescription(taskEntity.getTodoConfiguration());
        dataPush.setTaskSourceFlag("delAssignee");
        dataPush.setProcessName(execution.getProcessDefinitionName());
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            dataPush.setComment(this.comment);
        }
        dataPush.setProcessInsId(taskEntity.getProcessInstanceId());
        dataPush.setTaskType("9");
        this.dataPush(dataPush);
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
        ParamModel paramModel = this.getParamModel(task, execution);
        Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
        task.fireEvent("complete");
        Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "delAssigneeHistory", false, this.startTime);
        return taskEntity;
    }

    protected TaskEntity getTask() {
        List taskEntities = this.executionEntity.getTasks();
        List entityList = this.executionEntity.getExecutions();
        if (entityList != null && !entityList.isEmpty()) {
            this.executionEntity = (ExecutionEntity)entityList.get(0);
            entityList = this.executionEntity.getExecutions();
            if (entityList != null && !entityList.isEmpty()) {
                taskEntities = ((ExecutionEntity)this.executionEntity.getExecutions().get(0)).getTasks();
            }
            this.executionEntity = this.executionEntity.createExecution();
            this.executionEntity.setScope(false);
            this.executionEntity.setConcurrent(true);
            this.executionEntity.setActive(false);
        }
        TaskEntity task = (TaskEntity)taskEntities.get(0);
        for (int i = 1; i < taskEntities.size(); ++i) {
            if (!((TaskEntity)taskEntities.get(i)).getCreateTime().after(task.getCreateTime())) continue;
            task = (TaskEntity)taskEntities.get(i);
        }
        if (this.executionEntity.getSubProcessKey() != null && task.getSubProcessKey() == null) {
            task.setSubProcessKey(this.executionEntity.getSubProcessKey());
        }
        if (this.executionEntity.getCycleCount() != null && task.getCycleCount() == null) {
            task.setCycleCount(this.executionEntity.getCycleCount());
        }
        if (this.executionEntity.getProcessCycleCount() != null && task.getProcessCycleCount() == null) {
            task.setProcessCycleCount(this.executionEntity.getProcessCycleCount());
        }
        this.task = task;
        return task;
    }

    protected TaskEntity initTask(CommandContext commandContext, TaskEntity task, ExecutionEntity execution) {
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        IdGenerator idGenerator = pec.getIdGenerator();
        TaskEntity taskEntity = new TaskEntity();
        taskEntity.setCreateTime(this.startTime);
        taskEntity.setTaskDefinition(task.getTaskDefinition());
        taskEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        taskEntity.setTaskDefinitionKey(task.getTaskDefinitionKey());
        taskEntity.setProcessInstanceId(execution.getProcessInstanceId());
        taskEntity.setExecutionId(execution.getId());
        taskEntity.setName(task.getName());
        taskEntity.setNameTranslateKey(task.getNameTranslateKey());
        String taskId = idGenerator.getNextId();
        taskEntity.setId(taskId);
        taskEntity.setExecution(execution);
        taskEntity.setAssignee(this.userId);
        taskEntity.setAddDelAssignees(String.join((CharSequence)",", this.assigneeList));
        taskEntity.setTaskType("9");
        taskEntity.setFormKey(task.getFormKey());
        taskEntity.setCompleteType("delAssignee");
        taskEntity.setTaskSourceFlag("delAssignee");
        taskEntity.setTodoConfiguration(task.getTodoConfiguration());
        taskEntity.setSubProcessKey(task.getSubProcessKey());
        taskEntity.setCycleCount(task.getCycleCount());
        taskEntity.setProcessCycleCount(task.getProcessCycleCount());
        return taskEntity;
    }

    protected void dataPush(DataPush dataPush) {
        this.dataPushService.completeDataPush(dataPush);
    }

    private ParamModel getParamModel(TaskEntity task, ExecutionEntity execution) {
        ParamModel paramModel = new ParamModel();
        paramModel.setCompleteType("delAssignee");
        String sendUser = task.getSendUser();
        paramModel.setSendUser(sendUser);
        paramModel.setLastNodeId(task.getAllPrevNode());
        paramModel.setActivityType("userTask");
        return paramModel;
    }
}

