/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.listener.BusinessExecutionListener;
import com.jxdinfo.hussar.workflow.engine.bpm.listener.WorkflowListenerUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.BpmExceptionPushUtil;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionMessageParam;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.util.ActivitiTranslateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FireEvent {
    private static ModelService modelService = (ModelService)BpmSpringContextHolder.getBean(ModelService.class);
    private static final Logger logger = LoggerFactory.getLogger(FireEvent.class);
    private static final String PROCESS_RESTART_EVENT = "\u6d41\u7a0b\u91cd\u542f\u65f6";
    private static final String PROCESS_END_EVENT = "\u6d41\u7a0b\u7ec8\u6b62\u65f6";
    private static final String PROCESS_REVOKE_EVENT = "\u6d41\u7a0b\u64a4\u529e\u65f6";

    public void fireEvent(ExecutionEntity executionEntity, String processEventType, String eventType) {
        BpmnModel bpmnModel;
        if (processEventType != null && (bpmnModel = Context.getProcessEngineConfiguration().getRepositoryService().getBpmnModel(executionEntity.getProcessDefinitionId())) != null) {
            Process process = bpmnModel.getMainProcess();
            List executionListeners = process.getExecutionListeners();
            for (ActivitiListener activitiListener : executionListeners) {
                String event = activitiListener.getEvent();
                if (!processEventType.equals(event)) continue;
                String beanId = activitiListener.getImplementation();
                boolean isAsyn = false;
                String listenerModel = "";
                String requestMethod = "";
                List fieldExtensions = activitiListener.getFieldExtensions();
                for (FieldExtension fieldExtension : fieldExtensions) {
                    if ("isAsyn".equals(fieldExtension.getFieldName())) {
                        isAsyn = Boolean.parseBoolean(fieldExtension.getStringValue());
                    }
                    if ("listenerModel".equals(fieldExtension.getFieldName())) {
                        listenerModel = String.valueOf(fieldExtension.getStringValue());
                    }
                    if (!"requestMethod".equals(fieldExtension.getFieldName())) continue;
                    requestMethod = String.valueOf(fieldExtension.getStringValue());
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("businessId", executionEntity.getProcessBusinessKey());
                map.put("processInsId", executionEntity.getProcessInstanceId());
                map.put("processDefinitionId", executionEntity.getProcessDefinitionId());
                map.put("processKey", executionEntity.getProcessDefinition().getKey());
                HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(executionEntity.getProcessInstanceId());
                if (historicProcessInstance != null) {
                    map.put("starter", historicProcessInstance.getStartUserId());
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                map.put("createTime", simpleDateFormat.format(new Date()));
                map.put("processName", executionEntity.getProcessDefinition().getName());
                map.put("eventType", eventType);
                if (beanId == null) continue;
                try {
                    String serviceName = String.valueOf(modelService.getServiceName(executionEntity.getProcessDefinitionId().split(":")[0]));
                    if ("com.jxdinfo.hussar.workflow.engine.bpm.listener.BusinessExecutionListener".equals(beanId)) {
                        new BusinessExecutionListener().notify((DelegateExecution)executionEntity);
                        continue;
                    }
                    WorkflowListenerUtils.executionListener(listenerModel, requestMethod, beanId, map, serviceName);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    if (isAsyn) continue;
                    BpmExceptionMessageParam bpmExceptionMessageParam = new BpmExceptionMessageParam();
                    bpmExceptionMessageParam.setProcessKey(executionEntity.getProcessDefinitionKey());
                    bpmExceptionMessageParam.setProcessName(executionEntity.getProcessDefinition().getName());
                    bpmExceptionMessageParam.setProcessNameTranslateKey(executionEntity.getProcessDefinition().getNameTranslateKey());
                    bpmExceptionMessageParam.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
                    bpmExceptionMessageParam.setTaskDefinitionKey(HussarUtils.isNotEmpty((Object)executionEntity.getActivityId()) ? executionEntity.getActivityId() : " ");
                    bpmExceptionMessageParam.setTaskDefinitionName(HussarUtils.isNotEmpty((Object)executionEntity.getActivity()) ? (String)executionEntity.getActivity().getProperties().get("name") : " ");
                    bpmExceptionMessageParam.setTaskDefinitionName(" ".equals(bpmExceptionMessageParam.getTaskDefinitionName()) ? " " : ActivitiTranslateUtil.getTranslateKey((String)bpmExceptionMessageParam.getProcessDefinitionId(), (String)bpmExceptionMessageParam.getTaskDefinitionKey()));
                    bpmExceptionMessageParam.setStartUserId(historicProcessInstance.getStartUserId());
                    switch (processEventType) {
                        case "process_restart": {
                            BpmException restartBpmException = new BpmException(BpmExceptionCodeEnum.ERROR_ACCESS_EXECUTION_LISTENER_WHEN_EVENT.format(new Object[]{PROCESS_RESTART_EVENT}), bpmExceptionMessageParam);
                            BpmExceptionPushUtil.pushExceptionMessage(restartBpmException);
                            throw restartBpmException;
                        }
                        case "process_end": {
                            BpmException endBpmException = new BpmException(BpmExceptionCodeEnum.ERROR_ACCESS_EXECUTION_LISTENER_WHEN_EVENT.format(new Object[]{PROCESS_END_EVENT}), bpmExceptionMessageParam);
                            BpmExceptionPushUtil.pushExceptionMessage(endBpmException);
                            throw endBpmException;
                        }
                        case "process_revoke": {
                            BpmException revokeBpmException = new BpmException(BpmExceptionCodeEnum.ERROR_ACCESS_EXECUTION_LISTENER_WHEN_EVENT.format(new Object[]{PROCESS_REVOKE_EVENT}), bpmExceptionMessageParam);
                            BpmExceptionPushUtil.pushExceptionMessage(revokeBpmException);
                            throw revokeBpmException;
                        }
                    }
                    throw new BpmException(BpmExceptionCodeEnum.ERROR_ACCESS_TASK_LISTENER);
                }
            }
        }
    }
}

