/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processtest.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.vo.TaskCommentVO;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dao.ProcessInstMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.vo.ProcessInstVo;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.NodeService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.ProcessDiagramTestService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.SysActProcessFileService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.engine.task.TaskStateType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessDiagramTestTestServiceImpl
implements ProcessDiagramTestService {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDiagramTestTestServiceImpl.class);
    @Autowired
    private HistoryService historyService;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Resource
    private ProcessInstMapper processInstMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private SysActProcessFileService processFileService;
    private static final String FINISH_STATE = "finish";
    private static final String COMPLETE_STATE = "complete";
    private static final String NEXT_STATE = "next";
    private static final String SUSPENDED_STATE = "suspend";
    private static final String OVER_TIME_STATE = "overtime";
    private static final String LINE_NAME = "lineName";
    private static final String COUNT = "count";

    public JSONObject getProcessInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        List<String> idList;
        HistoricProcessInstance processInstance;
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return new JSONObject();
            }
        }
        if (HussarUtils.isEmpty((Object)(processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult()))) {
            return new JSONObject();
        }
        String processDefinitonId = processInstance.getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitonId);
        this.prepareBpmnModel(bpmnModel);
        boolean suspended = false;
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).includeTaskLocalVariables()).includeProcessVariables()).subProcessKey(subProcessKey)).cycleCount(cycleCount)).list();
        List<Object> lineList = new ArrayList();
        if (taskList.isEmpty()) {
            idList = this.queryPreActivitiesByTaskIdFinished(processInsId, subProcessKey, cycleCount, false);
        } else {
            ProcessInstance instance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            suspended = instance.isSuspended();
            idList = this.queryFinishNode(processInsId, bpmnModel, subProcessKey, cycleCount, false);
        }
        ArrayList<Object> runningNode = new ArrayList<Object>();
        HashMap nodeState = new HashMap();
        List mapList = this.instanceEngineService.getCallNodeType(processInsId);
        for (Map map : mapList) {
            runningNode.add(map.get("node"));
            nodeState.put(map.get("node"), HussarUtils.isEmpty(map.get("type")) ? COMPLETE_STATE : (String)map.get("type"));
        }
        for (Object task : taskList) {
            String completeType;
            runningNode.add(task.getTaskDefinitionKey());
            if (HussarUtils.isNotEmpty((Object)task.getDueDate()) && task.getDueDate().getTime() < System.currentTimeMillis()) {
                nodeState.put(task.getTaskDefinitionKey(), OVER_TIME_STATE);
                continue;
            }
            String string = completeType = task.getTaskLocalVariables().get("complete_type") == null ? COMPLETE_STATE : task.getTaskLocalVariables().get("complete_type").toString();
            if ("reject_revoke".equals(completeType) || "end_process".equals(completeType)) {
                completeType = COMPLETE_STATE;
            }
            nodeState.put(task.getTaskDefinitionKey(), completeType);
        }
        List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).unfinished().subProcessKey(subProcessKey).cycleCount(cycleCount).activityType("receiveTask").list();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            runningNode.add(historicActivityInstance.getActivityId());
        }
        List sysActHiLines = this.iSysActHiLineService.getSysActHiLineByProcessinsId(processInsId, subProcessKey, false);
        if (sysActHiLines != null && !sysActHiLines.isEmpty()) {
            lineList = sysActHiLines.stream().map(SysActHiLine::getLineId).collect(Collectors.toList());
        }
        Process process = bpmnModel.getMainProcess();
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        Map extensionElementsNode = process.getExtensionElements();
        String width = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasWidth")).get(0)).getAttributes().get("canvasWidth")).get(0)).getValue();
        String height = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasHeight")).get(0)).getAttributes().get("canvasHeight")).get(0)).getValue();
        for (FlowElement flowElement : process.getFlowElements()) {
            if (!(flowElement instanceof FlowNode)) continue;
            FlowNode flowNode = (FlowNode)flowElement;
            JSONObject object = new JSONObject();
            String flowNodeId = flowNode.getId();
            object.put("id", (Object)flowNodeId);
            object.put("name", (Object)flowNode.getName());
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            object.put("x", (Object)graphicInfo.getX());
            if (graphicInfo.getX() > Double.parseDouble(width)) {
                width = String.valueOf(graphicInfo.getX());
            }
            object.put("y", (Object)graphicInfo.getY());
            if (graphicInfo.getY() + 100.0 > Double.parseDouble(height)) {
                height = String.valueOf(graphicInfo.getY() + 100.0);
            }
            object.put("width", (Object)graphicInfo.getWidth());
            object.put("height", (Object)graphicInfo.getHeight());
            object.put("type", (Object)this.getNodeType(flowNode));
            object.put("processInsId", (Object)processInstance.getId());
            if (runningNode.contains(flowNodeId)) {
                if (suspended) {
                    object.put("state", (Object)SUSPENDED_STATE);
                } else {
                    object.put("state", (Object)nodeState.getOrDefault(flowNodeId, COMPLETE_STATE));
                }
            } else if (idList.contains(flowNodeId)) {
                object.put("state", (Object)FINISH_STATE);
            } else {
                object.put("state", (Object)NEXT_STATE);
            }
            if (flowElement instanceof SubProcess) {
                object.put("subProcessElements", (Object)this.getSubProcessMsg((SubProcess)flowElement, bpmnModel, processInsId));
            }
            jsonArray.add((Object)object);
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                List graphicInfoList;
                Map maps;
                List extendFlowNameElement;
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)sequenceFlow.getId());
                obj.put("name", (Object)sequenceFlow.getName());
                obj.put("type", (Object)"sequenceFlow");
                obj.put("dx", null);
                obj.put("rotate", null);
                obj.put(LINE_NAME, null);
                obj.put("x", null);
                obj.put("y", null);
                obj.put("height", null);
                obj.put("width", null);
                Map stringListMap = sequenceFlow.getExtensionElements();
                if (stringListMap != null && !stringListMap.isEmpty() && (extendFlowNameElement = (List)stringListMap.get("extendSequenceflow")) != null && !extendFlowNameElement.isEmpty() && HussarUtils.isNotEmpty((Object)(maps = ((ExtensionElement)extendFlowNameElement.get(0)).getAttributes()))) {
                    for (Map.Entry map : maps.entrySet()) {
                        if (LINE_NAME.equals(map.getKey())) {
                            String lineNamesStr = ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue();
                            String[] lineNames = lineNamesStr.split("/n");
                            obj.put(LINE_NAME, (Object)lineNames);
                            continue;
                        }
                        if ("x".equals(map.getKey()) || "y".equals(map.getKey()) || "width".equals(map.getKey()) || "height".equals(map.getKey())) {
                            obj.put((String)map.getKey(), (Object)Double.parseDouble(((ExtensionAttribute)((List)map.getValue()).get(0)).getValue()));
                            continue;
                        }
                        obj.put((String)map.getKey(), (Object)((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                    }
                }
                if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId())) != null && !graphicInfoList.isEmpty()) {
                    int[] xPoints = new int[graphicInfoList.size()];
                    int[] yPoints = new int[graphicInfoList.size()];
                    for (int i = 1; i < graphicInfoList.size(); ++i) {
                        GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                        GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                        if (i == 1) {
                            xPoints[0] = (int)previousGraphicInfo.getX();
                            yPoints[0] = (int)previousGraphicInfo.getY();
                        }
                        xPoints[i] = (int)gi.getX();
                        yPoints[i] = (int)gi.getY();
                    }
                    obj.put("xPoints", (Object)xPoints);
                    obj.put("yPoints", (Object)yPoints);
                }
                if (lineList.contains(sequenceFlow.getId())) {
                    obj.put("state", (Object)FINISH_STATE);
                } else {
                    obj.put("state", (Object)NEXT_STATE);
                }
                jsonArray.add((Object)obj);
            }
        }
        jsonObject.put("width", (Object)width);
        jsonObject.put("height", (Object)height);
        jsonObject.put("data", (Object)jsonArray);
        return jsonObject;
    }

    private JSONArray getSubProcessMsg(SubProcess subProcess, BpmnModel bpmnModel, String processInsId) {
        JSONArray jsonArray = new JSONArray();
        for (FlowElement flowElement : subProcess.getFlowElements()) {
            if (!(flowElement instanceof FlowNode)) continue;
            FlowNode flowNode = (FlowNode)flowElement;
            JSONObject object = new JSONObject();
            String flowNodeId = flowNode.getId();
            object.put("id", (Object)flowNodeId);
            object.put("name", (Object)flowNode.getName());
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            object.put("x", (Object)graphicInfo.getX());
            object.put("y", (Object)graphicInfo.getY());
            object.put("width", (Object)graphicInfo.getWidth());
            object.put("height", (Object)graphicInfo.getHeight());
            object.put("type", (Object)this.getNodeType(flowNode));
            object.put("processInsId", (Object)processInsId);
            object.put("state", (Object)NEXT_STATE);
            jsonArray.add((Object)object);
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                List graphicInfoList;
                Map maps;
                List extendFlowNameElement;
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)sequenceFlow.getId());
                obj.put("name", (Object)sequenceFlow.getName());
                obj.put("type", (Object)"sequenceFlow");
                obj.put("dx", null);
                obj.put("rotate", null);
                obj.put(LINE_NAME, null);
                obj.put("x", null);
                obj.put("y", null);
                obj.put("height", null);
                obj.put("width", null);
                Map stringListMap = sequenceFlow.getExtensionElements();
                if (stringListMap != null && !stringListMap.isEmpty() && (extendFlowNameElement = (List)stringListMap.get("extendSequenceflow")) != null && !extendFlowNameElement.isEmpty() && HussarUtils.isNotEmpty((Object)(maps = ((ExtensionElement)extendFlowNameElement.get(0)).getAttributes()))) {
                    for (Map.Entry map : maps.entrySet()) {
                        if (LINE_NAME.equals(map.getKey())) {
                            String lineNamesStr = ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue();
                            String[] lineNames = lineNamesStr.split("/n");
                            obj.put(LINE_NAME, (Object)lineNames);
                            continue;
                        }
                        if ("x".equals(map.getKey()) || "y".equals(map.getKey()) || "width".equals(map.getKey()) || "height".equals(map.getKey())) {
                            obj.put((String)map.getKey(), (Object)Double.parseDouble(((ExtensionAttribute)((List)map.getValue()).get(0)).getValue()));
                            continue;
                        }
                        obj.put((String)map.getKey(), (Object)((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                    }
                }
                if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId())) != null && !graphicInfoList.isEmpty()) {
                    int[] xPoints = new int[graphicInfoList.size()];
                    int[] yPoints = new int[graphicInfoList.size()];
                    for (int i = 1; i < graphicInfoList.size(); ++i) {
                        GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                        GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                        if (i == 1) {
                            xPoints[0] = (int)previousGraphicInfo.getX();
                            yPoints[0] = (int)previousGraphicInfo.getY();
                        }
                        xPoints[i] = (int)gi.getX();
                        yPoints[i] = (int)gi.getY();
                    }
                    obj.put("xPoints", (Object)xPoints);
                    obj.put("yPoints", (Object)yPoints);
                }
                obj.put("state", (Object)NEXT_STATE);
                jsonArray.add((Object)obj);
            }
        }
        return jsonArray;
    }

    public JSONObject getSubProcessRunningInfo(String processInsId, String businessId) {
        HistoricProcessInstance processInstance;
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return new JSONObject();
            }
        }
        if (HussarUtils.isEmpty((Object)(processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult()))) {
            return new JSONObject();
        }
        String processDefinitonId = processInstance.getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitonId);
        this.prepareBpmnModel(bpmnModel);
        List<String> subProcessKeys = this.taskEngineMapper.getAllSubProcessKey(Long.parseLong(processInsId));
        boolean suspended = false;
        ProcessInstance instance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (instance != null) {
            suspended = instance.isSuspended();
        }
        List allTasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().queryChildTask()).processInstanceId(processInsId)).queryChildTask()).includeTaskLocalVariables()).includeProcessVariables()).list();
        HashMap<Object, List> taskListMap = new HashMap<Object, List>();
        for (Task task : allTasks) {
            String subProcessKey = task.getSubProcessKey();
            if (subProcessKey == null) continue;
            List taskList = taskListMap.getOrDefault(subProcessKey, new ArrayList());
            taskList.add(task);
            taskListMap.put(subProcessKey, taskList);
        }
        List allHistoricActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).unfinished().activityType("receiveTask").list();
        HashMap<String, List> historicActivityInstancesMap = new HashMap<String, List>();
        for (HistoricActivityInstance historicActivityInstance : allHistoricActivityInstances) {
            String subProcessKey = historicActivityInstance.getSubProcessKey();
            if (subProcessKey == null) continue;
            List historicActivityInstances = historicActivityInstancesMap.getOrDefault(subProcessKey, new ArrayList());
            historicActivityInstances.add(historicActivityInstance);
            historicActivityInstancesMap.put(subProcessKey, historicActivityInstances);
        }
        ArrayList<String> userList = new ArrayList<String>();
        List hisLists = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
        HashMap<String, List> hisListMap = new HashMap<String, List>();
        for (HistoricTaskInstance historicTaskInstance : hisLists) {
            String subProcessKey;
            if (TaskStateType.isEntrust((HistoricTaskInstance)historicTaskInstance) && HussarUtils.isNotEmpty((Object)historicTaskInstance.getOwner())) {
                userList.add(historicTaskInstance.getOwner());
            }
            if (HussarUtils.isNotEmpty((Object)historicTaskInstance.getAssignee())) {
                userList.add(historicTaskInstance.getAssignee());
            }
            if ((subProcessKey = historicTaskInstance.getSubProcessKey()) == null) continue;
            List hisList = hisListMap.getOrDefault(subProcessKey, new ArrayList());
            hisList.add(historicTaskInstance);
            hisListMap.put(subProcessKey, hisList);
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        JSONObject result = new JSONObject(true);
        for (String subProcessKey : subProcessKeys) {
            Object task22;
            if (HussarUtils.isEmpty((Object)subProcessKey)) continue;
            JSONObject jsonObject = new JSONObject();
            String taskDefinitionKey = subProcessKey.split(":")[0];
            SubProcess subProcess = (SubProcess)bpmnModel.getFlowElement(taskDefinitionKey);
            List tasks = taskListMap.getOrDefault(subProcessKey, new ArrayList());
            List<Object> lineList = new ArrayList();
            List<String> idList = tasks.isEmpty() ? this.queryPreActivitiesByTaskIdFinished(processInsId, subProcessKey, null, true) : this.queryFinishNode(processInsId, bpmnModel, subProcessKey, null, true);
            ArrayList<String> runningNode = new ArrayList<String>();
            HashMap<String, String> nodeState = new HashMap<String, String>();
            for (Object task22 : tasks) {
                String completeType;
                runningNode.add(task22.getTaskDefinitionKey());
                if (HussarUtils.isNotEmpty((Object)task22.getDueDate()) && task22.getDueDate().getTime() < System.currentTimeMillis()) {
                    nodeState.put(task22.getTaskDefinitionKey(), OVER_TIME_STATE);
                    continue;
                }
                String string = completeType = task22.getTaskLocalVariables().get("complete_type") == null ? COMPLETE_STATE : task22.getTaskLocalVariables().get("complete_type").toString();
                if ("reject_revoke".equals(completeType)) {
                    completeType = COMPLETE_STATE;
                }
                nodeState.put(task22.getTaskDefinitionKey(), completeType);
            }
            List historicActivityInstances = historicActivityInstancesMap.getOrDefault(subProcessKey, new ArrayList());
            task22 = historicActivityInstances.iterator();
            while (task22.hasNext()) {
                HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)task22.next();
                runningNode.add(historicActivityInstance.getActivityId());
            }
            List sysActHiLines = this.iSysActHiLineService.getSysActHiLineByProcessinsId(processInsId, subProcessKey, true);
            if (sysActHiLines != null && !sysActHiLines.isEmpty()) {
                lineList = sysActHiLines.stream().map(SysActHiLine::getLineId).collect(Collectors.toList());
            }
            JSONArray subProcessInfo = new JSONArray();
            for (FlowElement flowElement : subProcess.getFlowElements()) {
                if (!(flowElement instanceof FlowNode)) continue;
                FlowNode flowNode = (FlowNode)flowElement;
                JSONObject object = new JSONObject();
                String flowNodeId = flowNode.getId();
                object.put("id", (Object)flowNodeId);
                object.put("name", (Object)flowNode.getName());
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                object.put("x", (Object)graphicInfo.getX());
                object.put("y", (Object)graphicInfo.getY());
                object.put("width", (Object)graphicInfo.getWidth());
                object.put("height", (Object)graphicInfo.getHeight());
                object.put("type", (Object)this.getNodeType(flowNode));
                object.put("processInsId", (Object)processInsId);
                if (runningNode.contains(flowNodeId)) {
                    if (suspended) {
                        object.put("state", (Object)SUSPENDED_STATE);
                    } else {
                        object.put("state", (Object)nodeState.getOrDefault(flowNodeId, COMPLETE_STATE));
                    }
                } else if (idList.contains(flowNodeId)) {
                    object.put("state", (Object)FINISH_STATE);
                } else {
                    object.put("state", (Object)NEXT_STATE);
                }
                subProcessInfo.add((Object)object);
                for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                    List graphicInfoList;
                    Map maps;
                    List extendFlowNameElement;
                    JSONObject obj = new JSONObject();
                    obj.put("id", (Object)sequenceFlow.getId());
                    obj.put("name", (Object)sequenceFlow.getName());
                    obj.put("type", (Object)"sequenceFlow");
                    obj.put("dx", null);
                    obj.put("rotate", null);
                    obj.put(LINE_NAME, null);
                    obj.put("x", null);
                    obj.put("y", null);
                    obj.put("height", null);
                    obj.put("width", null);
                    Map stringListMap = sequenceFlow.getExtensionElements();
                    if (stringListMap != null && !stringListMap.isEmpty() && (extendFlowNameElement = (List)stringListMap.get("extendSequenceflow")) != null && !extendFlowNameElement.isEmpty() && HussarUtils.isNotEmpty((Object)(maps = ((ExtensionElement)extendFlowNameElement.get(0)).getAttributes()))) {
                        for (Map.Entry map : maps.entrySet()) {
                            if (LINE_NAME.equals(map.getKey())) {
                                String lineNamesStr = ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue();
                                String[] lineNames = lineNamesStr.split("/n");
                                obj.put(LINE_NAME, (Object)lineNames);
                                continue;
                            }
                            if ("x".equals(map.getKey()) || "y".equals(map.getKey()) || "width".equals(map.getKey()) || "height".equals(map.getKey())) {
                                obj.put((String)map.getKey(), (Object)Double.parseDouble(((ExtensionAttribute)((List)map.getValue()).get(0)).getValue()));
                                continue;
                            }
                            obj.put((String)map.getKey(), (Object)((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                        }
                    }
                    if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId())) != null && !graphicInfoList.isEmpty()) {
                        int[] xPoints = new int[graphicInfoList.size()];
                        Object yPoints = new int[graphicInfoList.size()];
                        for (int i = 1; i < graphicInfoList.size(); ++i) {
                            GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                            GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                            if (i == 1) {
                                xPoints[0] = (int)previousGraphicInfo.getX();
                                yPoints[0] = (int)previousGraphicInfo.getY();
                            }
                            xPoints[i] = (int)gi.getX();
                            yPoints[i] = (int)gi.getY();
                        }
                        obj.put("xPoints", (Object)xPoints);
                        obj.put("yPoints", yPoints);
                    }
                    if (lineList.contains(sequenceFlow.getId())) {
                        obj.put("state", (Object)FINISH_STATE);
                    } else {
                        obj.put("state", (Object)NEXT_STATE);
                    }
                    subProcessInfo.add((Object)obj);
                }
            }
            jsonObject.put("subProcessInfo", (Object)subProcessInfo);
            JSONArray subProcessCompleteInfo = new JSONArray();
            Collection flowElements = ((SubProcess)bpmnModel.getFlowElement(taskDefinitionKey)).getFlowElements();
            List hisList = hisListMap.getOrDefault(subProcessKey, new ArrayList());
            ArrayList<Long> hisTaskIds = new ArrayList<Long>();
            for (HistoricTaskInstance hisTask : hisList) {
                if (hisTask.getEndTime() == null) continue;
                hisTaskIds.add(Long.valueOf(hisTask.getId()));
            }
            List<Object> commentsMap = new ArrayList();
            if (HussarUtils.isNotEmpty(hisTaskIds)) {
                commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
            }
            HashMap<String, String> taskComment = new HashMap<String, String>();
            for (TaskCommentVO taskCommentVO : commentsMap) {
                taskComment.put(String.valueOf(taskCommentVO.getTaskId()), taskCommentVO.getMessage());
            }
            for (FlowElement flowElement : flowElements) {
                if (flowElement instanceof SequenceFlow) continue;
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowElement.getId());
                JSONObject object = new JSONObject();
                object.put("width", (Object)graphicInfo.getWidth());
                object.put("height", (Object)graphicInfo.getHeight());
                object.put("x", (Object)graphicInfo.getX());
                object.put("y", (Object)graphicInfo.getY());
                object.put("id", (Object)flowElement.getId());
                List taskList = null;
                if (tasks != null && !tasks.isEmpty()) {
                    taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                }
                if (taskList != null && !taskList.isEmpty()) {
                    ArrayList<String> taskIds = new ArrayList<String>();
                    for (Task task3 : taskList) {
                        taskIds.add(String.valueOf(task3.getId()));
                    }
                    List nowHisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                    List<IdentityLink> user = this.getIdentityLinkByTaskId(taskIds);
                    List ts = taskList.stream().filter(t -> t.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                    object.put("startTime", (Object)((Task)ts.get(0)).getCreateTime());
                    Map map = ((Task)ts.get(0)).getTaskLocalVariables();
                    if (map != null) {
                        object.put("rejectFrom", (Object)(map.get("reject_name") == null ? "" : map.get("reject_name").toString()));
                        object.put("completeType", (Object)(map.get("complete_type") == null ? "" : map.get("complete_type").toString()));
                    } else {
                        object.put("rejectFrom", (Object)"");
                        object.put("completeType", (Object)"");
                    }
                    if (!user.isEmpty()) {
                        String assignee = String.join((CharSequence)",", this.iAssigneeChooseService.getEntrustUserNames(user));
                        object.put("assignee", (Object)assignee);
                    } else {
                        object.put("assignee", (Object)this.bpmConstantProperties.getNullAssignee());
                    }
                    object.put("state", (Object)COMPLETE_STATE);
                    if (!nowHisActivitList.isEmpty()) {
                        nowHisActivitList.sort((o1, o2) -> {
                            if (!o1.getStartTime().equals(o2.getStartTime())) {
                                return o1.getStartTime().compareTo(o2.getStartTime());
                            }
                            if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                                return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                            }
                            if (o1.getEndTime() == null && o2.getEndTime() != null) {
                                return o2.getEndTime().compareTo(new Date(0L));
                            }
                            if (o1.getEndTime() != null && o2.getEndTime() == null) {
                                return new Date(0L).compareTo(o1.getEndTime());
                            }
                            if (o1.getEndTime().equals(o2.getEndTime())) {
                                return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                            }
                            return o1.getEndTime().compareTo(o2.getEndTime());
                        });
                        JSONArray json = new JSONArray();
                        for (HistoricTaskInstance historicActivityInstance : nowHisActivitList) {
                            JSONObject o = new JSONObject();
                            String nowUser = historicActivityInstance.getAssignee() != null ? (TaskStateType.isEntrust((HistoricTaskInstance)historicActivityInstance) && HussarUtils.isNotEmpty((Object)historicActivityInstance.getOwner()) ? (String)finalUsersMap.get(historicActivityInstance.getAssignee()) + "(" + (String)finalUsersMap.get(historicActivityInstance.getOwner()) + ")" : (String)finalUsersMap.get(historicActivityInstance.getAssignee())) : this.bpmConstantProperties.getNullComplete();
                            String comment = (String)taskComment.get(historicActivityInstance.getId());
                            o.put("comments", (Object)(comment == null ? this.bpmConstantProperties.getNullComment() : comment));
                            o.put("assignee", (Object)nowUser);
                            o.put("endTime", (Object)historicActivityInstance.getEndTime());
                            o.put("startTime", (Object)historicActivityInstance.getStartTime());
                            o.put("taskType", (Object)historicActivityInstance.getTaskType());
                            json.add((Object)o);
                        }
                        object.put("completeInfo", (Object)json);
                    }
                } else {
                    object.put("state", (Object)FINISH_STATE);
                    List hisActivitList = null;
                    if (HussarUtils.isNotEmpty((Object)hisList)) {
                        hisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                    }
                    if (hisActivitList == null || hisActivitList.isEmpty()) continue;
                    hisActivitList.sort((m1, m2) -> m1.getStartTime().compareTo(m2.getStartTime()));
                    JSONArray json = new JSONArray();
                    for (HistoricTaskInstance historicActivityInstance : hisActivitList) {
                        String comment;
                        JSONObject o = new JSONObject();
                        String user = "";
                        if (historicActivityInstance.getAssignee() != null) {
                            user = TaskStateType.isEntrust((HistoricTaskInstance)historicActivityInstance) ? (String)finalUsersMap.get(historicActivityInstance.getAssignee()) + "(" + (String)finalUsersMap.get(historicActivityInstance.getOwner()) + ")" : (String)finalUsersMap.get(historicActivityInstance.getAssignee());
                        }
                        if (StringUtils.isEmpty((CharSequence)user)) {
                            user = this.bpmConstantProperties.getNullComplete();
                        }
                        o.put("comments", (Object)((comment = (String)taskComment.get(historicActivityInstance.getId())) == null ? this.bpmConstantProperties.getNullComment() : comment));
                        o.put("assignee", (Object)user);
                        o.put("endTime", (Object)historicActivityInstance.getEndTime());
                        o.put("startTime", (Object)historicActivityInstance.getStartTime());
                        o.put("taskType", (Object)historicActivityInstance.getTaskType());
                        json.add((Object)o);
                    }
                    object.put("completeInfo", (Object)json);
                }
                subProcessCompleteInfo.add((Object)object);
            }
            jsonObject.put("subProcessInfo", (Object)subProcessInfo);
            jsonObject.put("subProcessCompleteInfo", (Object)subProcessCompleteInfo);
            result.put(subProcessKey, (Object)jsonObject);
        }
        return result;
    }

    public JSONArray getProcessCompleteInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return new JSONArray();
            }
        }
        JSONArray jsonArray = new JSONArray();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (HussarUtils.isEmpty((Object)processInstance)) {
            return new JSONArray();
        }
        String processDefinitionId = processInstance.getProcessDefinitionId();
        int version = Integer.parseInt(processDefinitionId.split(":")[1]);
        if (version <= 0) {
            this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processDefinitionId));
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        List hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).subProcessKey(subProcessKey)).cycleCount(cycleCount)).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
        ArrayList userList = new ArrayList();
        if (hisList != null && !hisList.isEmpty()) {
            hisList.stream().forEach(o -> {
                if (TaskStateType.isEntrust((HistoricTaskInstance)o) && HussarUtils.isNotEmpty((Object)o.getOwner())) {
                    userList.add(o.getOwner());
                }
                if (HussarUtils.isNotEmpty((Object)o.getAssignee())) {
                    userList.add(o.getAssignee());
                }
            });
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().queryChildTask()).processInstanceId(processInsId)).subProcessKey(subProcessKey)).cycleCount(cycleCount)).includeTaskLocalVariables()).list();
        ArrayList<Long> hisTaskIds = new ArrayList<Long>();
        for (HistoricTaskInstance hisTask : hisList) {
            if (hisTask.getEndTime() == null) continue;
            hisTaskIds.add(Long.valueOf(hisTask.getId()));
        }
        List<Object> commentsMap = new ArrayList();
        if (HussarUtils.isNotEmpty(hisTaskIds)) {
            commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
        }
        HashMap<String, String> taskComment = new HashMap<String, String>();
        for (TaskCommentVO taskCommentVO : commentsMap) {
            taskComment.put(String.valueOf(taskCommentVO.getTaskId()), taskCommentVO.getMessage());
        }
        for (ActivityImpl activityImpl : activitiList) {
            JSONObject object = new JSONObject();
            object.put("width", (Object)activityImpl.getWidth());
            object.put("height", (Object)activityImpl.getHeight());
            object.put("x", (Object)activityImpl.getX());
            object.put("y", (Object)activityImpl.getY());
            object.put("id", (Object)activityImpl.getId());
            List taskList = null;
            if (tasks != null && !tasks.isEmpty()) {
                taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
            }
            if (taskList != null && !taskList.isEmpty()) {
                ArrayList<String> taskIds = new ArrayList<String>();
                for (Task task : taskList) {
                    taskIds.add(String.valueOf(task.getId()));
                }
                List nowHisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
                List<IdentityLink> user = this.getIdentityLinkByTaskId(taskIds);
                List ts = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
                object.put("startTime", (Object)((Task)ts.get(0)).getCreateTime());
                Map map = ((Task)ts.get(0)).getTaskLocalVariables();
                if (map != null) {
                    object.put("rejectFrom", (Object)(map.get("reject_name") == null ? "" : map.get("reject_name").toString()));
                    object.put("completeType", (Object)(map.get("complete_type") == null ? "" : map.get("complete_type").toString()));
                } else {
                    object.put("rejectFrom", (Object)"");
                    object.put("completeType", (Object)"");
                }
                if (!user.isEmpty()) {
                    String assignee = String.join((CharSequence)",", this.iAssigneeChooseService.getEntrustUserNames(user));
                    object.put("assignee", (Object)assignee);
                } else {
                    object.put("assignee", (Object)this.bpmConstantProperties.getNullAssignee());
                }
                object.put("state", (Object)COMPLETE_STATE);
                if (!nowHisActivitList.isEmpty()) {
                    nowHisActivitList.sort((o1, o2) -> {
                        if (!o1.getStartTime().equals(o2.getStartTime())) {
                            return o1.getStartTime().compareTo(o2.getStartTime());
                        }
                        if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                            return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                        }
                        if (o1.getEndTime() == null && o2.getEndTime() != null) {
                            return o2.getEndTime().compareTo(new Date(0L));
                        }
                        if (o1.getEndTime() != null && o2.getEndTime() == null) {
                            return new Date(0L).compareTo(o1.getEndTime());
                        }
                        if (o1.getEndTime().equals(o2.getEndTime())) {
                            return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                        }
                        return o1.getEndTime().compareTo(o2.getEndTime());
                    });
                    JSONArray json = new JSONArray();
                    for (HistoricTaskInstance historicActivityInstance : nowHisActivitList) {
                        JSONObject o3 = new JSONObject();
                        String nowUser = historicActivityInstance.getAssignee() != null ? (TaskStateType.isEntrust((HistoricTaskInstance)historicActivityInstance) && HussarUtils.isNotEmpty((Object)historicActivityInstance.getOwner()) ? (String)finalUsersMap.get(historicActivityInstance.getAssignee()) + "(" + (String)finalUsersMap.get(historicActivityInstance.getOwner()) + ")" : (String)finalUsersMap.get(historicActivityInstance.getAssignee())) : this.bpmConstantProperties.getNullComplete();
                        String comment = (String)taskComment.get(historicActivityInstance.getId());
                        o3.put("comments", (Object)(comment == null ? this.bpmConstantProperties.getNullComment() : comment));
                        o3.put("assignee", (Object)nowUser);
                        o3.put("endTime", (Object)historicActivityInstance.getEndTime());
                        o3.put("startTime", (Object)historicActivityInstance.getStartTime());
                        o3.put("taskType", (Object)historicActivityInstance.getTaskType());
                        json.add((Object)o3);
                    }
                    object.put("completeInfo", (Object)json);
                }
            } else {
                object.put("state", (Object)FINISH_STATE);
                List hisActivitList = null;
                if (hisList != null && !hisList.isEmpty()) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
                }
                if (hisActivitList == null || hisActivitList.isEmpty()) continue;
                hisActivitList.sort((m1, m2) -> m1.getStartTime().compareTo(m2.getStartTime()));
                JSONArray json = new JSONArray();
                for (HistoricTaskInstance historicActivityInstance : hisActivitList) {
                    String comment;
                    JSONObject o4 = new JSONObject();
                    String user = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = TaskStateType.isEntrust((HistoricTaskInstance)historicActivityInstance) ? (String)finalUsersMap.get(historicActivityInstance.getAssignee()) + "(" + (String)finalUsersMap.get(historicActivityInstance.getOwner()) + ")" : (String)finalUsersMap.get(historicActivityInstance.getAssignee());
                    }
                    if (StringUtils.isEmpty((CharSequence)user)) {
                        user = this.bpmConstantProperties.getNullComplete();
                    }
                    o4.put("comments", (Object)((comment = (String)taskComment.get(historicActivityInstance.getId())) == null ? this.bpmConstantProperties.getNullComment() : comment));
                    o4.put("assignee", (Object)user);
                    o4.put("endTime", (Object)historicActivityInstance.getEndTime());
                    o4.put("startTime", (Object)historicActivityInstance.getStartTime());
                    o4.put("taskType", (Object)historicActivityInstance.getTaskType());
                    json.add((Object)o4);
                }
                object.put("completeInfo", (Object)json);
            }
            jsonArray.add((Object)object);
        }
        return jsonArray;
    }

    public Map<String, Object> list(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return result;
            }
        }
        BpmResponseResult obj = this.instanceEngineService.getAllProcessTrace(processInsId, subProcessKey, cycleCount);
        result.put(COUNT, obj.getResult().size());
        result.put("data", obj.getResult());
        return result;
    }

    public Map<String, Object> microAppList(String processInsId, String businessId) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return result;
            }
        }
        BpmResponseResult obj = this.instanceEngineService.getAllProcessTraceByMicroApp(processInsId);
        result.put(COUNT, obj.getResult().size());
        result.put("data", obj.getResult());
        return result;
    }

    public Map<String, Object> subProcessList(String supProcessInsId, String businessId, String taskDefinitionKey, Integer page, Integer size) {
        List<ProcessInst> instList;
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        if (HussarUtils.isEmpty((Object)supProcessInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                supProcessInsId = instance.getId();
            } else {
                return new HashMap<String, Object>();
            }
        }
        if (!(instList = this.processInstMapper.getCallActivityProcessInstList((Page<ProcessInst>)pages, Long.parseLong(supProcessInsId), taskDefinitionKey)).isEmpty()) {
            HashSet<Long> procInstIds = new HashSet<Long>();
            for (ProcessInst processInst : instList) {
                procInstIds.add(Long.parseLong(processInst.getProcessInsId()));
            }
            List<ProcessInstVo> nodeList = this.processInstMapper.getNodeNames(procInstIds);
            HashMap<Long, Set> nodeMap = new HashMap<Long, Set>();
            for (ProcessInstVo node : nodeList) {
                Long procInstId = node.getProcessInsId();
                Set set = (Set)nodeMap.get(procInstId);
                set = set == null ? new HashSet() : set;
                set.add(node.getActName());
                nodeMap.put(procInstId, set);
            }
            for (ProcessInst processInst : instList) {
                Set nodeNames = (Set)nodeMap.get(Long.valueOf(processInst.getProcessInsId()));
                if (nodeNames == null || nodeNames.isEmpty()) continue;
                processInst.setNames(String.join((CharSequence)",", nodeNames));
            }
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(COUNT, pages.getTotal());
        dataMap.put("data", instList);
        return dataMap;
    }

    private void prepareBpmnModel(BpmnModel bpmnModel) {
        ArrayList allGraphicInfos = new ArrayList();
        if (bpmnModel.getLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLocationMap().values());
        }
        if (bpmnModel.getLabelLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLabelLocationMap().values());
        }
        if (bpmnModel.getFlowLocationMap() != null) {
            for (List flowGraphicInfos : bpmnModel.getFlowLocationMap().values()) {
                allGraphicInfos.addAll(flowGraphicInfos);
            }
        }
        if (!allGraphicInfos.isEmpty()) {
            boolean needsTranslationX = false;
            boolean needsTranslationY = false;
            double lowestX = 0.0;
            double lowestY = 0.0;
            for (GraphicInfo graphicInfo : allGraphicInfos) {
                double x = graphicInfo.getX();
                double y = graphicInfo.getY();
                if (x < lowestX) {
                    needsTranslationX = true;
                    lowestX = x;
                }
                if (!(y < lowestY)) continue;
                needsTranslationY = true;
                lowestY = y;
            }
            if (needsTranslationX || needsTranslationY) {
                double translationX = Math.abs(lowestX);
                double translationY = Math.abs(lowestY);
                for (GraphicInfo graphicInfo : allGraphicInfos) {
                    if (needsTranslationX) {
                        graphicInfo.setX(graphicInfo.getX() + translationX);
                    }
                    if (!needsTranslationY) continue;
                    graphicInfo.setY(graphicInfo.getY() + translationY);
                }
            }
        }
    }

    private String getNodeType(FlowNode flowNode) {
        String type = "";
        if (flowNode instanceof UserTask) {
            type = HussarUtils.isNotEmpty((Object)((UserTask)flowNode).getLoopCharacteristics()) ? "multiUserTask" : "userTask";
        } else if (flowNode instanceof ServiceTask) {
            type = "serviceTask";
        } else if (flowNode instanceof ReceiveTask) {
            type = "receiveTask";
        } else if (flowNode instanceof StartEvent) {
            EventDefinition eventDefinition;
            StartEvent startEvent = (StartEvent)flowNode;
            type = startEvent.getEventDefinitions() != null && !startEvent.getEventDefinitions().isEmpty() ? ((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof TimerEventDefinition ? "startTimerEvent" : (eventDefinition instanceof ErrorEventDefinition ? "errorEvent" : (eventDefinition instanceof SignalEventDefinition ? "signalEvent" : (eventDefinition instanceof MessageEventDefinition ? "messageEvent" : "noneEvent")))) : "startEvent";
        } else if (flowNode instanceof EndEvent) {
            type = "endEvent";
        } else if (flowNode instanceof ParallelGateway) {
            type = "parallelGateway";
        } else if (flowNode instanceof InclusiveGateway) {
            type = "inclusiveGateway";
        } else if (flowNode instanceof ExclusiveGateway) {
            type = "exclusiveGateway";
        } else if (flowNode instanceof SubProcess) {
            type = "subProcess";
        } else if (flowNode instanceof BoundaryEvent) {
            type = "boundaryEvent";
        } else if (flowNode instanceof CallActivity) {
            type = "callActivity";
        }
        return type;
    }

    private List<String> queryPreActivitiesByTaskIdFinished(String processInsId, String subProcessKey, Integer cycleCount, boolean needWithOutMain) {
        ArrayList<String> idList = new ArrayList<String>();
        HistoricActivityInstanceQuery historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery();
        if (HussarUtils.isNotEmpty((Object)subProcessKey)) {
            if (needWithOutMain) {
                historicActivityInstanceQuery.subProcessKeyWithOutMain(subProcessKey);
            } else {
                historicActivityInstanceQuery.subProcessKey(subProcessKey);
            }
        }
        List list = ((HistoricActivityInstanceQuery)historicActivityInstanceQuery.processInstanceId(processInsId).finished().cycleCount(cycleCount).orderByHistoricActivityInstanceEndTime().asc()).list();
        for (HistoricActivityInstance his : list) {
            idList.add(his.getActivityId());
        }
        return idList;
    }

    private List<String> queryFinishNode(String processInsId, BpmnModel bpmnModel, String subProcessKey, Integer cycleCount, boolean needWithOutMain) {
        ArrayList<String> idList = new ArrayList<String>();
        HistoricActivityInstanceQuery historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery();
        if (HussarUtils.isNotEmpty((Object)subProcessKey)) {
            if (needWithOutMain) {
                historicActivityInstanceQuery.subProcessKeyWithOutMain(subProcessKey);
            } else {
                historicActivityInstanceQuery.subProcessKey(subProcessKey);
            }
        }
        List historicActivityInstances = historicActivityInstanceQuery.processInstanceId(processInsId).finished().cycleCount(cycleCount).list();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            if (bpmnModel.getFlowElement(historicActivityInstance.getActivityId()) == null) continue;
            idList.add(historicActivityInstance.getActivityId());
        }
        return idList;
    }

    private List<IdentityLink> getIdentityLinkByTaskId(List<String> taskIds) {
        ArrayList<IdentityLink> result = new ArrayList<IdentityLink>();
        for (String taskId : taskIds) {
            List identityLinkList = this.taskService.getIdentityLinksType(taskId);
            result.addAll(identityLinkList);
        }
        return result;
    }

    public ApiResponse<JSONObject> getProcessInfoForProcessTesting(String processInstId, String businessId, String subProcessKey, Integer cycleCount) {
        if (HussarUtils.isEmpty((Object)processInstId) && HussarUtils.isEmpty((Object)businessId)) {
            return ApiResponse.fail((String)"\u6d41\u7a0b\u542f\u52a8\u5931\u8d25");
        }
        JSONObject processInfoReturnObject = this.getProcessInfo(processInstId, businessId, subProcessKey, cycleCount);
        JSONArray processInfo = (JSONArray)processInfoReturnObject.get((Object)"data");
        try {
            if (processInfo != null) {
                FlowModel flowModel = this.getTestFlowModel(processInstId);
                JSONArray newProcessInfo = this.neatenProcessInfoSequenceAndSetFinishStateAndNextNode(processInfo, flowModel, processInstId);
                processInfoReturnObject.put("data", (Object)newProcessInfo);
            }
        }
        catch (BpmException e) {
            logger.error(e.getMessage());
            return ApiResponse.fail((String)e.getMessage());
        }
        this.setHistoricRecords(processInfoReturnObject, processInstId, businessId);
        this.setSubProcessInfo(processInfoReturnObject, processInstId, businessId);
        return ApiResponse.success((Object)processInfoReturnObject);
    }

    private FlowModel getTestFlowModel(String processInstId) throws BpmException {
        String processKey = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstId).singleResult()).getProcessDefinitionKey();
        WorkFlow workFlow = this.processFileService.getLatestTestProcessFile(processKey);
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        flowModel.setFlowIdentity(workFlow.getIdentity());
        return flowModel;
    }

    private JSONArray neatenProcessInfoSequenceAndSetFinishStateAndNextNode(JSONArray processInfo, FlowModel flowModel, String processInstId) {
        this.setFinishState(processInfo);
        return this.neatenProcessInfoSequenceAndSetNextNode(processInfo, flowModel, processInstId);
    }

    private JSONArray neatenProcessInfoSequenceAndSetFinishStateAndNextNode(JSONArray processInfo, FlowModel flowModel, String processInstId, String groupName) {
        this.setFinishState(processInfo);
        return this.neatenProcessInfoSequenceAndSetNextNode(processInfo, flowModel, processInstId, groupName);
    }

    private JSONArray neatenProcessInfoSequenceAndSetNextNode(JSONArray processInfo, FlowModel flowModel, String processInstId) {
        List elements = flowModel.getSlots().getElement();
        List paths = flowModel.getSlots().getPath();
        JSONArray newProcessInfo = this.neatenProcessInfoSequenceAndSetNextNode(processInfo, elements, paths, processInstId);
        this.neatenSubProcessInfoSequenceAndSetNextNode(newProcessInfo, elements, paths, processInstId);
        return newProcessInfo;
    }

    private JSONArray neatenProcessInfoSequenceAndSetNextNode(JSONArray processInfo, FlowModel flowModel, String processInstId, String groupName) {
        List elements = flowModel.getSlots().getElement();
        List subElements = null;
        List subPaths = null;
        String subNodeKey = groupName.split(":")[0];
        for (FlowObject element : elements) {
            if (!subNodeKey.equals(element.getInstanceKey())) continue;
            subElements = element.getSlots().getElement();
            subPaths = element.getSlots().getPath();
        }
        JSONArray newProcessInfo = this.neatenProcessInfoSequenceAndSetNextNode(processInfo, subElements, subPaths, processInstId, groupName);
        this.neatenSubProcessInfoSequenceAndSetNextNode(newProcessInfo, subElements, subPaths, processInstId);
        return newProcessInfo;
    }

    private JSONArray neatenProcessInfoSequenceAndSetNextNode(JSONArray processInfo, List<FlowObject> elements, List<FlowSequence> paths, String processInstId) {
        List<String> activityKeys = this.getHistoricActivityInstanceKeyBy(processInstId);
        Map<String, JSONObject> mappingFromIdToObject = this.groupMainAndSubProcessInfoById(processInfo);
        String startNodeKey = this.nodeService.findStartNodeKey(elements);
        Map mappingFromStartNodeKeyToEndNodeKeys = this.nodeService.groupEndNodeKeysByStartNodeKey(paths);
        Map mappingFromStartNodeKeyToPathKeys = this.nodeService.groupPathKeysByStartNodeKey(paths);
        Map mappingFromPathKeyToPaths = this.nodeService.groupPathsByPathKey(paths);
        JSONArray newProcessInfo = new JSONArray();
        ArrayDeque<String> nodeKeyQueue = new ArrayDeque<String>();
        ArrayList visitedNodeKeys = new ArrayList();
        nodeKeyQueue.add(startNodeKey);
        while (!nodeKeyQueue.isEmpty()) {
            String currentNodeKey = (String)nodeKeyQueue.poll();
            JSONArray nextNodeInfos = new JSONArray();
            JSONObject currentNodeInfo = mappingFromIdToObject.get(currentNodeKey);
            List nextNodeKeys = (List)mappingFromStartNodeKeyToEndNodeKeys.get(currentNodeKey);
            if (nextNodeKeys != null) {
                nextNodeKeys.forEach(nextNodeKey -> {
                    JSONObject nextNodeInfo = (JSONObject)mappingFromIdToObject.get(nextNodeKey);
                    if (nextNodeInfo != null && activityKeys.contains(nextNodeKey)) {
                        nextNodeInfos.add(nextNodeKey);
                    }
                    if (!visitedNodeKeys.contains(nextNodeKey)) {
                        nodeKeyQueue.add((String)nextNodeKey);
                        visitedNodeKeys.add(nextNodeKey);
                    }
                });
            }
            currentNodeInfo.put("nextNodeInfos", (Object)nextNodeInfos);
            newProcessInfo.add((Object)currentNodeInfo);
            List pathKeys = (List)mappingFromStartNodeKeyToPathKeys.get(currentNodeKey);
            if (pathKeys == null) continue;
            pathKeys.forEach(pathKey -> {
                JSONObject pathInfo = (JSONObject)mappingFromIdToObject.get(pathKey);
                FlowSequence path = (FlowSequence)((List)mappingFromPathKeyToPaths.get(pathKey)).get(0);
                String endNodeKey = path.getEnd().getKey();
                if (activityKeys.contains(endNodeKey)) {
                    pathInfo.put("isRunTimePath", (Object)true);
                } else {
                    pathInfo.put("isRunTimePath", (Object)false);
                }
                newProcessInfo.add((Object)pathInfo);
            });
        }
        HashSet<String> forRemoveDuplicate = new HashSet<String>();
        for (int i = newProcessInfo.size() - 1; i >= 0; --i) {
            JSONObject newNodeOrPathInfos = (JSONObject)newProcessInfo.get(i);
            if (forRemoveDuplicate.add((String)newNodeOrPathInfos.get((Object)"id"))) continue;
            newProcessInfo.remove(i);
        }
        return newProcessInfo;
    }

    private JSONArray neatenProcessInfoSequenceAndSetNextNode(JSONArray processInfo, List<FlowObject> elements, List<FlowSequence> paths, String processInstId, String groupName) {
        Map<String, List<String>> mappingFromSubProcessKeyToActivityId = this.groupHistoricActivityInstanceKeyBySubProcessKey(processInstId);
        Map<String, JSONObject> mappingFromIdToObject = this.groupMainAndSubProcessInfoById(processInfo);
        String startNodeKey = this.nodeService.findStartNodeKey(elements);
        Map mappingFromStartNodeKeyToEndNodeKeys = this.nodeService.groupEndNodeKeysByStartNodeKey(paths);
        Map mappingFromStartNodeKeyToPathKeys = this.nodeService.groupPathKeysByStartNodeKey(paths);
        Map mappingFromPathKeyToPaths = this.nodeService.groupPathsByPathKey(paths);
        JSONArray newProcessInfo = new JSONArray();
        ArrayDeque<String> nodeKeyQueue = new ArrayDeque<String>();
        nodeKeyQueue.add(startNodeKey);
        while (!nodeKeyQueue.isEmpty()) {
            String currentNodeKey = (String)nodeKeyQueue.poll();
            JSONArray nextNodeInfos = new JSONArray();
            JSONObject currentNodeInfo = mappingFromIdToObject.get(currentNodeKey);
            List nextNodeKeys = (List)mappingFromStartNodeKeyToEndNodeKeys.get(currentNodeKey);
            if (nextNodeKeys != null) {
                nextNodeKeys.forEach(nextNodeKey -> {
                    JSONObject nextNodeInfo = (JSONObject)mappingFromIdToObject.get(nextNodeKey);
                    if (nextNodeInfo != null && ((List)mappingFromSubProcessKeyToActivityId.get(groupName)).contains(nextNodeKey)) {
                        nextNodeInfos.add(nextNodeKey);
                    }
                });
                nodeKeyQueue.addAll(nextNodeKeys);
            }
            currentNodeInfo.put("nextNodeInfos", (Object)nextNodeInfos);
            newProcessInfo.add((Object)currentNodeInfo);
            List pathKeys = (List)mappingFromStartNodeKeyToPathKeys.get(currentNodeKey);
            if (pathKeys == null) continue;
            pathKeys.forEach(pathKey -> {
                JSONObject pathInfo = (JSONObject)mappingFromIdToObject.get(pathKey);
                FlowSequence path = (FlowSequence)((List)mappingFromPathKeyToPaths.get(pathKey)).get(0);
                String endNodeKey = path.getEnd().getKey();
                if (((List)mappingFromSubProcessKeyToActivityId.get(groupName)).contains(endNodeKey)) {
                    pathInfo.put("isRunTimePath", (Object)true);
                } else {
                    pathInfo.put("isRunTimePath", (Object)false);
                }
                newProcessInfo.add((Object)pathInfo);
            });
        }
        return newProcessInfo;
    }

    private void neatenSubProcessInfoSequenceAndSetNextNode(JSONArray processInfo, List<FlowObject> elements, List<FlowSequence> paths, String processInstId) {
        Map<String, JSONObject> mappingFromIdToObject = this.groupMainAndSubProcessInfoById(processInfo);
        for (FlowObject element : elements) {
            String type = element.getName();
            if (!"com.jxdinfo.workflow.SubProcess".equals(type)) continue;
            List subProcessElements = element.getSlots().getElement();
            List subProcessPaths = element.getSlots().getPath();
            JSONObject nodeInfo = mappingFromIdToObject.get(element.getInstanceKey());
            JSONArray subNodeInfos = (JSONArray)nodeInfo.get((Object)"subProcessElements");
            if (subNodeInfos == null) continue;
            JSONArray newSubProcessInfo = this.neatenProcessInfoSequenceAndSetNextNode(subNodeInfos, subProcessElements, subProcessPaths, processInstId);
            nodeInfo.put("subProcessElements", (Object)newSubProcessInfo);
        }
    }

    private List<String> getHistoricActivityInstanceKeyBy(String processInstId) {
        HashSet activityKeys = new HashSet();
        List activityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstId).list();
        if (activityInstances != null) {
            activityInstances.forEach(activityInstance -> activityKeys.add(activityInstance.getActivityId()));
        }
        return new ArrayList<String>(activityKeys);
    }

    private Map<String, List<String>> groupHistoricActivityInstanceKeyBySubProcessKey(String processInstId) {
        List activityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstId).list();
        return activityInstances.stream().collect(Collectors.groupingBy(activityInstance -> {
            if (activityInstance.getSubProcessKey() == null) {
                return "";
            }
            return activityInstance.getSubProcessKey();
        }, Collectors.mapping(activityInstance -> activityInstance.getActivityId(), Collectors.toList())));
    }

    private Map<String, JSONObject> groupMainAndSubProcessInfoById(JSONArray processInfo) {
        Map<String, JSONObject> mappingFromIdToObject = this.groupProcessById(processInfo);
        mappingFromIdToObject.putAll(this.groupSubProcessById(processInfo));
        return mappingFromIdToObject;
    }

    private Map<String, JSONObject> groupProcessById(JSONArray processInfo) {
        HashMap<String, JSONObject> mappingFromIdToObject = new HashMap<String, JSONObject>();
        for (Object nodeOrPathInfo : processInfo) {
            String id = (String)((JSONObject)nodeOrPathInfo).get((Object)"id");
            mappingFromIdToObject.put(id, (JSONObject)nodeOrPathInfo);
        }
        return mappingFromIdToObject;
    }

    private Map<String, JSONObject> groupSubProcessById(JSONArray processInfo) {
        Map<String, JSONObject> mappingFromIdToObject = new HashMap<String, JSONObject>();
        for (Object nodeOrPathInfo : processInfo) {
            JSONArray subProcessInfo = (JSONArray)((JSONObject)nodeOrPathInfo).get((Object)"subProcessElements");
            if (subProcessInfo == null) continue;
            mappingFromIdToObject = this.groupProcessById(subProcessInfo);
        }
        return mappingFromIdToObject;
    }

    private void setFinishState(JSONArray processInfo) {
        for (Object nodeOrPathInfo : processInfo) {
            ((JSONObject)nodeOrPathInfo).put("isFinish", (Object)FINISH_STATE.equals(((JSONObject)nodeOrPathInfo).get((Object)"state")));
        }
    }

    private void setHistoricRecords(JSONObject processInfoReturnObject, String processInstId, String businessId) {
        Map<String, Object> result = this.list(processInstId, businessId, null, null);
        JSONArray jsonArray = (JSONArray)result.get("data");
        for (Object json : jsonArray) {
            JSONArray nodeArray = (JSONArray)((JSONObject)json).get((Object)"subProcessTask");
            String activityId = (String)((JSONObject)json).get((Object)"activityId");
            String subProcessKey = (String)((JSONObject)json).get((Object)"sub_process_key");
            if (nodeArray == null) continue;
            JSONObject instanceObject = new JSONObject();
            JSONArray newInstanceArray = new JSONArray();
            instanceObject.put("activityId", (Object)activityId);
            instanceObject.put("sub_process_key", (Object)subProcessKey);
            instanceObject.put("activityName", (Object)"\u5b9e\u4f8b1");
            instanceObject.put("subProcessTask", (Object)nodeArray);
            newInstanceArray.add((Object)instanceObject);
            ((JSONObject)json).remove((Object)"subProcessTask");
            ((JSONObject)json).put("subProcess", (Object)newInstanceArray);
        }
        processInfoReturnObject.put("historicRecords", result);
    }

    private void setSubProcessInfo(JSONObject processInfoReturnObject, String processInstId, String businessId) {
        processInfoReturnObject.put("subProcessInfo", this.getSubProcessRunningInfoForProcessTesting(processInstId, businessId));
    }

    public ApiResponse<JSONObject> getSubProcessRunningInfoForProcessTesting(String processInstId, String businessId) {
        JSONObject groupInfo = this.getSubProcessRunningInfo(processInstId, businessId);
        JSONObject newGroupInfo = new JSONObject();
        try {
            for (Map.Entry group : groupInfo.entrySet()) {
                String groupName = (String)group.getKey();
                JSONArray processInfo = (JSONArray)((JSONObject)group.getValue()).get((Object)"subProcessInfo");
                if (processInfo == null) continue;
                FlowModel flowModel = this.getTestFlowModel(processInstId);
                JSONArray newProcessInfo = this.neatenProcessInfoSequenceAndSetFinishStateAndNextNode(processInfo, flowModel, processInstId, groupName);
                HashSet forRemoveDuplicate = new HashSet();
                newProcessInfo.removeIf(o -> !forRemoveDuplicate.add((String)((JSONObject)o).get((Object)"id")));
                newGroupInfo.put(groupName, (Object)newProcessInfo);
            }
        }
        catch (BpmException e) {
            logger.error(e.getMessage());
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success((Object)newGroupInfo);
    }
}

