/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;

public class UnPreemptTaskCmd
extends CommonPrepareCmd {
    protected static DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getBean(DataPushService.class);
    protected static TaskEngineMapper taskEngineMapper = (TaskEngineMapper)BpmSpringContextHolder.getBean(TaskEngineMapper.class);
    private HistoryService historyService = (HistoryService)BpmSpringContextHolder.getBean(HistoryService.class);

    @Override
    protected void follow(CommandContext commandContext, TaskEntity task) {
        task.setPreempted(null);
        List identityLinkEntityList = task.getIdentityLinks();
        Set users = identityLinkEntityList.stream().filter(identityLink -> !TaskStateType.isEntrust((IdentityLink)identityLink) && "candidate".equals(identityLink.getType())).map(IdentityLinkEntity::getUserId).collect(Collectors.toSet());
        if (!users.isEmpty()) {
            taskEngineMapper.unPreemptDeduplication(users, Long.parseLong(this.taskId));
        }
        if (identityLinkEntityList.size() > 1) {
            HashSet<String> addUsers = new HashSet<String>();
            ArrayList<Map<String, String>> addUserMaps = new ArrayList<Map<String, String>>();
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntityList) {
                if (!"preempted".equals(identityLinkEntity.getType()) || !TaskStateType.isEntrust((IdentityLink)identityLinkEntity) && (TaskStateType.isEntrust((IdentityLink)identityLinkEntity) || users.contains(identityLinkEntity.getUserId()))) continue;
                if (!identityLinkEntity.getUserId().equals(this.userId)) {
                    addUsers.add(identityLinkEntity.getUserId());
                }
                HashMap<String, String> addUserMap = new HashMap<String, String>();
                addUserMap.put("userId", identityLinkEntity.getUserId());
                if (TaskStateType.isEntrust((IdentityLink)identityLinkEntity)) {
                    addUserMap.put("mandator", identityLinkEntity.getMandator());
                    addUserMap.put("taskState", identityLinkEntity.getTaskState());
                }
                addUserMaps.add(addUserMap);
            }
            HashSet<String> processDefinitionIdList = new HashSet<String>();
            processDefinitionIdList.add(task.getProcessDefinitionId());
            if (dataPushService.isDataPush(processDefinitionIdList)) {
                dataPushService.entrustDataPush(this.unPreemptDataPush(task, addUsers, addUserMaps));
            }
        }
        taskEngineMapper.unPreemptTask(Long.parseLong(this.taskId));
        new ProcessActionCmd(task.getProcessInstanceId(), task.getProcessDefinitionId()).execute(commandContext);
        new ProcessNodeCmd(task.getProcessInstanceId()).execute(commandContext);
    }

    @Override
    protected void taskAuthentication(TaskEntity task) {
        super.taskAuthentication(task);
        if (!task.typeOfPreempted()) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_PREEMPT);
        }
    }

    public UnPreemptTaskCmd(String taskId, String userId) {
        super(taskId, userId);
    }

    public UnPreemptTaskCmd(String taskId, String userId, String mandator) {
        super(taskId, userId, mandator);
    }

    public UnPreemptTaskCmd(String taskId, String userId, String mandator, boolean isAuditAuthority) {
        super(taskId, userId, mandator, isAuditAuthority);
    }

    private DataPush unPreemptDataPush(TaskEntity task, Set<String> addUsers, List<Map<String, String>> addUserMaps) {
        DataPush dataPush = new DataPush();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        String addUser = String.join((CharSequence)",", addUsers);
        dataPush.setUserId(addUser.length() != 0 ? addUser : null);
        dataPush.setUserMaps(addUserMaps);
        dataPush.setTaskId(task.getId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessInsId(historicProcessInstance.getId());
        dataPush.setBusinessKey(task.getProcessInstance().getBusinessKey());
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setTaskDefinitionNameTranslateKey(task.getNameTranslateKey());
        dataPush.setUrl(task.getFormKey());
        dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
        dataPush.setTaskType(task.getTaskType());
        List<Map<String, String>> userMapList = this.getAssigneeMapByTaskId(task, null);
        dataPush.setUserMapList(userMapList);
        return dataPush;
    }

    private List<Map<String, String>> getAssigneeMapByTaskId(TaskEntity taskEntity, List<String> users) {
        List identityLinkList = taskEntity.getCandidates();
        if (HussarUtils.isNotEmpty(users)) {
            identityLinkList.removeIf(identityLink -> users.contains(identityLink.getUserId()));
        }
        ArrayList<Map<String, String>> userMaps = new ArrayList<Map<String, String>>();
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink2 : identityLinkList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", identityLink2.getUserId());
                if (TaskStateType.isEntrust((IdentityLink)identityLink2)) {
                    map.put("mandator", identityLink2.getMandator());
                    map.put("taskState", identityLink2.getTaskState());
                }
                userMaps.add(map);
            }
        }
        return userMaps;
    }
}

