/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.runtime.Execution;

public class SignalCmd
extends AddAttributeCmd<Map<String, Object>> {
    protected String executionId;
    private static final long serialVersionUID = 1L;
    protected final Map<String, Object> processVariables;

    public SignalCmd(String executionId, Map<String, Object> processVariables) {
        this.executionId = executionId;
        this.processVariables = processVariables;
    }

    private void getAttributeFromExecution(ExecutionEntity executionEntity, CommandContext commandContext) {
        Map oldAppointAssignee;
        Object nextNode;
        Object sendUser = executionEntity.getVariableLocal("sendUser");
        if (HussarUtils.isNotEmpty((Object)sendUser)) {
            executionEntity.removeVariableLocal("sendUser");
            commandContext.addAttribute("sendUser", sendUser);
        }
        if (HussarUtils.isNotEmpty((Object)(nextNode = executionEntity.getVariableLocal("bpm_next_node")))) {
            executionEntity.removeVariableLocal("bpm_next_node");
            commandContext.addAttribute("bpm_next_node", nextNode);
        }
        if (HussarUtils.isNotEmpty((Object)(oldAppointAssignee = (Map)executionEntity.getVariableLocal("appoint_assignee")))) {
            executionEntity.removeVariableLocal("appoint_assignee");
            Map appointAssignee = (Map)BpmAttribute.getExecutionAttribute((ActivityExecution)executionEntity, "appoint_assignee");
            if (appointAssignee != null) {
                for (Map.Entry entry : oldAppointAssignee.entrySet()) {
                    if (appointAssignee.containsKey(entry.getKey())) continue;
                    appointAssignee.put(entry.getKey(), entry.getValue());
                }
            } else {
                executionEntity.addTempVariable("appoint_assignee", (Object)oldAppointAssignee);
            }
        }
    }

    public Map<String, Object> execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ActivitiIllegalArgumentException("executionId is null");
        }
        ExecutionEntity execution = commandContext.getExecutionEntityManager().findExecutionById(this.executionId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("execution " + this.executionId + " doesn't exist", Execution.class);
        }
        if (execution.isSuspended()) {
            throw new ActivitiException(this.getSuspendedExceptionMessage());
        }
        if (this.processVariables != null) {
            execution.setVariables(this.processVariables);
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("processDefinitionId", execution.getProcessDefinitionId());
        res.put("processInsId", execution.getProcessInstanceId());
        this.getAttributeFromExecution(execution, commandContext);
        this.addAttribute(commandContext);
        this.addExecutionAttribute(execution);
        execution.signal(null, null);
        return res;
    }

    protected String getSuspendedExceptionMessage() {
        return "Cannot signal an execution that is suspended";
    }
}

