/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.HttpRequestUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRejectDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.CompleteTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.dao.ActivityRedisTimerMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util.TimeOutHandleUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.TimeoutStrategyType;
import com.jxdinfo.hussar.workflow.engine.core.util.BpmTenantInfoUtils;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.repository.Model;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class TimeOutSetListUtil {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ITaskEngineService taskEngineService;
    @Autowired
    private BpmTenantInfoUtils bpmTenantInfoUtils;
    @Resource
    private TaskService taskService;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private RepositoryService repositoryService;
    @Resource
    private ProcessEngine processEngine;
    @Autowired
    private BpmMsgPushService bpmMsgPushService;
    private static HistoryService historyService = (HistoryService)BpmSpringContextHolder.getSpringContext().getBean(HistoryService.class);
    private static final LcdpBpmProperties LCDP_BPM_PROPERTIES = (LcdpBpmProperties)BpmSpringContextHolder.getBean(LcdpBpmProperties.class);
    private static final Pattern REGEX = Pattern.compile("^(http|https):");
    private static Logger logger = LogManager.getLogger(TimeOutSetListUtil.class);
    @Resource
    private ActivityRedisTimerMapper activityRedisTimerMapper;

    private String tenantRequestAddress() {
        return LCDP_BPM_PROPERTIES.getTenantCallAddress();
    }

    @HussarDs(value="#connName")
    public void setList(String connName, String tcode) {
        try {
            if (TimeOutHandleUtil.useRedis) {
                try {
                    List timeOutModels = this.activityRedisTimerMapper.selectList(null);
                    for (TimeOutModel timeOutModel : timeOutModels) {
                        timeOutModel.setDataSourceName(connName);
                        timeOutModel.setTcode(tcode);
                        String id = String.valueOf(timeOutModel.getTaskId());
                        if ("1".equals(timeOutModel.getMessageType())) {
                            id = "global-" + id;
                        }
                        this.redisTemplate.opsForValue().set((Object)("bpm_activity:timer:task_Message:" + id), (Object)JSON.toJSONString((Object)timeOutModel));
                        Set oldTask = this.redisTemplate.opsForZSet().rangeByScore((Object)"bpm_activity:timer:score_list", (double)timeOutModel.getDueTime().getTime(), (double)timeOutModel.getDueTime().getTime());
                        if (HussarUtils.isEmpty((Object)oldTask)) {
                            this.redisTemplate.opsForZSet().add((Object)"bpm_activity:timer:score_list", (Object)id, (double)timeOutModel.getDueTime().getTime());
                            continue;
                        }
                        this.redisTemplate.opsForZSet().add((Object)"bpm_activity:timer:score_list", (Object)((String)new ArrayList(oldTask).get(0) + "," + id), (double)timeOutModel.getDueTime().getTime());
                    }
                    this.activityRedisTimerMapper.delete(null);
                }
                catch (Exception e) {
                    logger.error("redis\u50a8\u5b58\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25{}", (Object)e.toString());
                }
                return;
            }
            List timeOutModels = this.activityRedisTimerMapper.selectList(null);
            for (TimeOutModel timeOutModel : timeOutModels) {
                timeOutModel.setDataSourceName(connName);
                timeOutModel.setTcode(tcode);
                String id = String.valueOf(timeOutModel.getTaskId());
                if ("1".equals(timeOutModel.getMessageType())) {
                    id = "global-" + id;
                }
                HussarCacheUtil.put((String)"bpm_timer_activity", (Object)id, (Object)timeOutModel);
                Long time = timeOutModel.getDueTime().getTime();
                TimeOutHandleUtil.timeOutList.add(time);
                TimeOutHandleUtil.timeOutMap.put(time, TimeOutHandleUtil.timeOutMap.get(time) == null ? id : TimeOutHandleUtil.timeOutMap.get(time) + "," + id);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8d85\u65f6\u4fe1\u606f\u51fa\u9519\uff1a{}", new Object[]{e.getMessage()});
        }
    }

    @HussarDs(value="#connName")
    public void timeOutTaskHandler(TimeOutModel timeOutModel, boolean isDelTimeOutTableMessage, String connName) {
        if (!this.bpmTenantInfoUtils.isMultiTenant()) {
            if (isDelTimeOutTableMessage) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(TimeOutModel::getTaskId, (Object)timeOutModel.getTaskId());
                queryWrapper.eq(TimeOutModel::getMessageType, (Object)timeOutModel.getMessageType());
                this.activityRedisTimerMapper.delete((Wrapper)queryWrapper);
            }
            this.handleTimeOutModel(timeOutModel);
        } else {
            try {
                if (isDelTimeOutTableMessage) {
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(TimeOutModel::getTaskId, (Object)timeOutModel.getTaskId());
                    queryWrapper.eq(TimeOutModel::getMessageType, (Object)timeOutModel.getMessageType());
                    this.activityRedisTimerMapper.delete((Wrapper)queryWrapper);
                }
                this.handleTimeOutModel(timeOutModel);
            }
            catch (Exception e) {
                logger.error("\u8fde\u63a5\u5207\u6362\u81f3\u8d85\u65f6\u4efb\u52a1\u6240\u5728\u79df\u6237\u5e93\u5931\u8d25{}", (Object)e.getMessage());
            }
        }
    }

    private void handleTimeOutModel(TimeOutModel timeOutModel) {
        String timeOutType;
        String errorMsg;
        block44: {
            HussarContextHolder.setTenant((String)timeOutModel.getDataSourceName(), (String)timeOutModel.getTcode());
            ServletRequestAttributes servletRequestAttributes = HussarContextHolder.getNewServletRequestAttributes((String)timeOutModel.getTcode());
            RequestContextHolder.setRequestAttributes((RequestAttributes)servletRequestAttributes);
            errorMsg = null;
            timeOutType = timeOutModel.getTimeOutType();
            if (!"2".equals(timeOutModel.getMessageType()) && !"unHandle".equals(timeOutModel.getTimeOutType())) {
                String processInsId;
                if ("autoHandle".equals(timeOutModel.getTimeOutType())) {
                    try {
                        CompleteTaskDto completeTaskDto = new CompleteTaskDto(String.valueOf(timeOutModel.getTaskId()), null, null, null, null, false, false, null);
                        completeTaskDto.setTaskSourceFlag("overtime_auto_complete");
                        this.taskEngineService.completeTask(completeTaskDto);
                    }
                    catch (Exception e) {
                        logger.error("\u8d85\u65f6\u4efb\u52a1\u81ea\u52a8\u529e\u7406\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                        errorMsg = "\u8d85\u65f6\u4efb\u52a1\u81ea\u52a8\u529e\u7406\u5931\u8d25\uff1a" + e.getMessage();
                    }
                } else if ("autoRejectToFirst".equals(timeOutModel.getTimeOutType()) || "autoRejectToLast".equals(timeOutModel.getTimeOutType())) {
                    try {
                        TaskRejectDto taskRejectDto = new TaskRejectDto();
                        taskRejectDto.setTaskId(String.valueOf(timeOutModel.getTaskId())).setAuditAuthority(false).setIsSubmit(true).setIsSubProcessFirst(true).setAssignees(null);
                        taskRejectDto.setTaskSourceFlag("overtime_auto_reject");
                        if ("autoRejectToFirst".equals(timeOutModel.getTimeOutType())) {
                            this.taskEngineService.rejectToFirstTask(taskRejectDto);
                            break block44;
                        }
                        this.taskEngineService.rejectToLastTask(taskRejectDto);
                    }
                    catch (Exception e) {
                        logger.error("\u8d85\u65f6\u4efb\u52a1\u81ea\u52a8\u9a73\u56de\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                        errorMsg = "\u8d85\u65f6\u4efb\u52a1\u81ea\u52a8\u9a73\u56de\u5931\u8d25\uff1a" + e.getMessage();
                    }
                } else if ("urging".equals(timeOutModel.getTimeOutType())) {
                    String userId = null;
                    if (HussarUtils.isNotEmpty((Object)timeOutModel.getMap())) {
                        Map map = (Map)JSON.toJavaObject((JSON)JSON.parseObject((String)timeOutModel.getMap()), Map.class);
                        userId = (String)map.get("sendUser");
                    }
                    try {
                        this.iSysActUrgeTaskService.urgeTaskByTaskId(String.valueOf(timeOutModel.getTaskId()), userId);
                    }
                    catch (Exception e) {
                        logger.error("\u8d85\u65f6\u4efb\u52a1\u50ac\u529e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    }
                } else if ("global-urging".equals(timeOutModel.getTimeOutType())) {
                    timeOutType = "urging";
                    try {
                        processInsId = String.valueOf(timeOutModel.getTaskId());
                        String assignee = timeOutModel.getAssignee();
                        this.iSysActUrgeTaskService.urgeTask(processInsId, null, null, assignee);
                    }
                    catch (Exception e) {
                        logger.error("\u8d85\u65f6\u6d41\u7a0b\u50ac\u529e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    }
                } else if ("global-terminate".equals(timeOutModel.getTimeOutType())) {
                    timeOutType = "terminate";
                    try {
                        String assignee;
                        Task runningTask;
                        String taskId;
                        Set<String> userSet;
                        processInsId = String.valueOf(timeOutModel.getTaskId());
                        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).list();
                        if (!tasks.isEmpty() && !(userSet = this.getAssigneeByTaskId(taskId = (runningTask = (Task)tasks.get(0)).getId())).isEmpty() && HussarUtils.isNotEmpty((Object)(assignee = userSet.iterator().next()))) {
                            this.instanceEngineService.endProcess(taskId, assignee, "");
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u8d85\u65f6\u6d41\u7a0b\u7ec8\u7ed3\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    }
                } else if ("receiveTask-autoHandle".equals(timeOutModel.getTimeOutType())) {
                    timeOutType = "autoHandle";
                    try {
                        String executionId = String.valueOf(timeOutModel.getTaskId());
                        this.taskEngineService.receiveTaskSignal(executionId, null);
                    }
                    catch (Exception e) {
                        logger.error("\u8d85\u65f6\u4efb\u52a1\u81ea\u52a8\u529e\u7406\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    }
                } else {
                    Matcher matcher;
                    timeOutType = "outInterface";
                    String outInterface = timeOutModel.getTimeOutType();
                    if (HussarUtils.isEmpty((Object)outInterface)) {
                        throw new BaseException(BpmExceptionCodeEnum.TIMEOUT_WITHOUT_INTERFACE_CONTENT.getMessage());
                    }
                    boolean isProcessTimeOut = false;
                    if (outInterface.startsWith("global-")) {
                        isProcessTimeOut = true;
                        outInterface = outInterface.replace("global-", "");
                    }
                    if (outInterface.startsWith("receiveTask-")) {
                        isProcessTimeOut = true;
                        outInterface = outInterface.replace("receiveTask-", "");
                    }
                    if (!(matcher = REGEX.matcher(outInterface.toLowerCase())).find()) {
                        outInterface = outInterface.startsWith("/") ? this.tenantRequestAddress() + outInterface : this.tenantRequestAddress() + "/" + outInterface;
                    }
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    if (!isProcessTimeOut) {
                        map.put("taskId", timeOutModel.getTaskId());
                        map.put("assignee", timeOutModel.getAssignee());
                        map.put("startTime", sdf.format(timeOutModel.getCreateTime()));
                    }
                    map.put("dueTime", sdf.format(timeOutModel.getDueTime()));
                    if (HussarUtils.isNotEmpty((Object)timeOutModel.getMap())) {
                        map.putAll((Map)JSON.toJavaObject((JSON)JSON.parseObject((String)timeOutModel.getMap()), Map.class));
                    }
                    try {
                        HttpRequestUtil.getRequestResult(outInterface, map);
                    }
                    catch (Exception e) {
                        logger.error("\u8d85\u65f6\u4efb\u52a1\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    }
                }
            }
        }
        if (HussarUtils.isNotEmpty(errorMsg)) {
            String finalErrorMsg = errorMsg;
            this.processEngine.getManagementService().executeCommand(commandContext -> {
                TaskEntity task = commandContext.getTaskEntityManager().findTaskById(String.valueOf(timeOutModel.getTaskId()));
                task.setErrorMsg(finalErrorMsg);
                return null;
            });
        }
        String chanalTypes = null;
        if (HussarUtils.isNotEmpty((Object)timeOutModel.getTimeOutChanalType())) {
            chanalTypes = String.join((CharSequence)",", new ArrayList(JSONArray.parseArray((String)timeOutModel.getTimeOutChanalType(), String.class)));
        }
        if (HussarUtils.isNotEmpty(chanalTypes)) {
            HistoricTaskInstance historicTaskInstance;
            logger.info("\u5c1d\u8bd5\u53d1\u9001\u6d88\u606f");
            Map map = (Map)JSON.toJavaObject((JSON)JSON.parseObject((String)timeOutModel.getMap()), Map.class);
            BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
            String processDefinitionId = (String)map.get("processDefinitionId");
            bpmActMsgDetail.setProcessKey(processDefinitionId != null ? processDefinitionId.split(":")[0] : null);
            bpmActMsgDetail.setProcessName((String)map.get("processName"));
            bpmActMsgDetail.setProcessDefinitionId(processDefinitionId);
            bpmActMsgDetail.setTaskDefKey((String)map.get("taskDefinitionKey"));
            bpmActMsgDetail.setTaskDefName((String)map.get("name"));
            bpmActMsgDetail.setSendUserId((String)map.get("sendUser"));
            bpmActMsgDetail.setTodoConfiguration((String)map.get("todoConfiguration"));
            ArrayList<String> userIdList = new ArrayList<String>();
            userIdList.add(bpmActMsgDetail.getSendUserId());
            Map userNameMap = this.iAssigneeChooseService.getUserListByUserId(userIdList);
            bpmActMsgDetail.setSendUserName((String)userNameMap.get(bpmActMsgDetail.getSendUserId()));
            if (HussarUtils.isNotEmpty(map.get("formKey"))) {
                String formKey = (String)map.get("formKey");
                String webFormKey = String.valueOf(((Map)JSON.parseObject((String)formKey, Map.class)).get("web"));
                String mobileFormKey = String.valueOf(((Map)JSON.parseObject((String)formKey, Map.class)).get("mobile"));
                bpmActMsgDetail.setWebFormAddress(webFormKey);
                bpmActMsgDetail.setWebFinalUrl(webFormKey);
                bpmActMsgDetail.setMobileFormAddress(mobileFormKey);
                bpmActMsgDetail.setMobileFinalUrl(mobileFormKey);
            }
            bpmActMsgDetail.setBusinessId((String)map.get("businessId"));
            String taskId = timeOutModel.getTaskId() != null ? timeOutModel.getTaskId().toString() : null;
            bpmActMsgDetail.setTaskId(taskId);
            Model model = (Model)this.repositoryService.createModelQuery().modelKey(bpmActMsgDetail.getProcessKey()).singleResult();
            if (model != null) {
                bpmActMsgDetail.setPortalAppId(String.valueOf(model.getAppId()));
            }
            logger.info("\u5de5\u4f5c\u6d41\u8d85\u65f6\u53d1\u9001\u6d88\u606f\u83b7\u53d6\u5230\u7684taskId\u4e3a\uff1a{}", (Object)taskId);
            if (HussarUtils.isNotEmpty((Object)taskId) && HussarUtils.isNotEmpty((Object)(historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult()))) {
                logger.info("\u5de5\u4f5c\u6d41\u8d85\u65f6\u53d1\u9001\u6d88\u606f\u83b7\u53d6\u5230\u7684formId\u4e3a\uff1a{}", (Object)historicTaskInstance.getFormId());
                bpmActMsgDetail.setFormId(historicTaskInstance.getFormId());
            }
            bpmActMsgDetail.setProcessInstanceId((String)map.get("processInsId"));
            bpmActMsgDetail.setTabType("2");
            bpmActMsgDetail.setReceive(Arrays.asList(timeOutModel.getAssignee().split(",")));
            bpmActMsgDetail.setSceneCode("2".equals(timeOutModel.getMessageType()) ? "timeout_warning" : "timeout");
            bpmActMsgDetail.setChannelType(chanalTypes);
            bpmActMsgDetail.setTimeOutType(TimeoutStrategyType.mapToType((String)timeOutType));
            if (!"2".equals(timeOutModel.getMessageType())) {
                bpmActMsgDetail.setTimeOutMessage(TimeoutStrategyType.mapToMsg((String)timeOutType));
            }
            bpmActMsgDetail.setDueDate((String)map.get("dueDate"));
            Object historicProcessInstance = Context.getCommandContext() != null ? Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance((String)map.get("processInsId")) : (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId((String)map.get("processInsId")).singleResult();
            if (HussarUtils.isNotEmpty((Object)historicProcessInstance)) {
                bpmActMsgDetail.setProcessTitle(historicProcessInstance.getProcessTitle());
                bpmActMsgDetail.setDataDetail(historicProcessInstance.getDataDetail());
            }
            this.bpmMsgPushService.pushMessage(Collections.singletonList(bpmActMsgDetail));
        }
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksType(taskId);
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }
}

