/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowOrganProcessUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.form.WorkflowAuthConfigQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActFormAuthMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.organ.dto.OrganProcessModelQueryDto;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysActFormAuthService")
@HussarTokenDs
public class SysActFormAuthServiceImpl
extends ServiceImpl<SysActFormAuthMapper, SysActFormAuth>
implements SysActFormAuthService {
    @Resource
    private SysActFormAuthMapper sysActFormAuthMapper;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    private HistoryService historyService;
    @Resource
    private TaskService taskService;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ModelService modelService;

    private List<SysActFormAuth> getListByTaskId(String formId, String formName, String formType, String formState, String taskId) {
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).queryChildTask()).singleResult();
        if (historicTaskInstance == null) {
            return new ArrayList<SysActFormAuth>();
        }
        String procDefId = historicTaskInstance.getProcessDefinitionId();
        Integer version = Integer.valueOf(procDefId.split(":")[1]);
        if (version <= 0) {
            version = Integer.valueOf(this.modelService.getRealVersion(historicTaskInstance.getProcessDefinitionId()));
        }
        Integer conditionVersion = version;
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicTaskInstance.getProcessDefinitionId());
        String nodeId = CommonCodeUtil.getVisitorNodeId(historicTaskInstance.getTaskDefinitionKey(), bpmnModel);
        String processKey = historicTaskInstance.getProcessDefinitionId().split(":")[0];
        if (HussarUtils.isNotEmpty((Object)historicTaskInstance.getEndTime())) {
            switch (formType) {
                case "2": {
                    formType = "1";
                    break;
                }
                case "4": {
                    formType = "5";
                    break;
                }
            }
        }
        LambdaQueryWrapper flowAuthWrapper = new LambdaQueryWrapper();
        flowAuthWrapper.eq(SysActFormAuth::getProcessKey, (Object)processKey);
        flowAuthWrapper.eq(SysActFormAuth::getTaskDefinitionKey, (Object)nodeId);
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)formId), SysActFormAuth::getFormId, (Object)formId);
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)formName), SysActFormAuth::getFormName, (Object)formName);
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)formType), SysActFormAuth::getFormType, (Object)formType);
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)formState), SysActFormAuth::getFormState, (Object)formState);
        flowAuthWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(SysActFormAuth::getProcessVersion)).or()).eq(SysActFormAuth::getProcessVersion, (Object)conditionVersion);
        });
        List list = this.sysActFormAuthMapper.selectList((Wrapper)flowAuthWrapper);
        ArrayList<SysActFormAuth> result = new ArrayList<SysActFormAuth>();
        for (SysActFormAuth sysActFormAuth : list) {
            if (sysActFormAuth.getProcessVersion() == null) continue;
            result.add(sysActFormAuth);
        }
        if (result.isEmpty()) {
            result.addAll(result);
        }
        for (SysActFormAuth sysActFormAuth : result) {
            sysActFormAuth.setTaskDefinitionKey(historicTaskInstance.getTaskDefinitionKey());
        }
        return result;
    }

    public JSONArray queryFormAuthConfig(WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto) {
        LambdaQueryWrapper flowAuthWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getProcessKey())) {
            flowAuthWrapper.eq(SysActFormAuth::getProcessKey, (Object)workflowAuthConfigQueryDto.getProcessKey());
            Integer version = workflowAuthConfigQueryDto.getVersion();
            if (version == null) {
                Integer conditionVersion = null;
                if (HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getTaskId())) {
                    List<SysActFormAuth> list = this.getListByTaskId(null, workflowAuthConfigQueryDto.getFormName(), workflowAuthConfigQueryDto.getFormType(), workflowAuthConfigQueryDto.getFormState(), workflowAuthConfigQueryDto.getTaskId().split(":")[0]);
                    JSONArray result = new JSONArray();
                    result.addAll(list);
                    return result;
                }
                OrganProcessModelQueryDto organProcessModelQueryDto = new OrganProcessModelQueryDto(workflowAuthConfigQueryDto.getProcessKey(), workflowAuthConfigQueryDto.getUserId(), workflowAuthConfigQueryDto.getOrganId());
                organProcessModelQueryDto.setGetMainOrNew(!workflowAuthConfigQueryDto.isGetLastVersion());
                try {
                    conditionVersion = Integer.valueOf(WorkflowOrganProcessUtil.getStartOrganProcessModelMessage(organProcessModelQueryDto).getVersion());
                }
                catch (BpmException result) {
                    // empty catch block
                }
                if (HussarUtils.isNotEmpty(conditionVersion)) {
                    Integer eqVersion = conditionVersion;
                    flowAuthWrapper.and(wrapper -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(SysActFormAuth::getProcessVersion)).or()).eq(SysActFormAuth::getProcessVersion, (Object)eqVersion);
                    });
                }
            } else {
                flowAuthWrapper.and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(SysActFormAuth::getProcessVersion)).or()).eq(SysActFormAuth::getProcessVersion, (Object)version);
                });
            }
        }
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getFormName()), SysActFormAuth::getFormName, (Object)workflowAuthConfigQueryDto.getFormName());
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getFormType()), SysActFormAuth::getFormType, (Object)workflowAuthConfigQueryDto.getFormType());
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getTaskDefinitionKey()), SysActFormAuth::getTaskDefinitionKey, (Object)workflowAuthConfigQueryDto.getTaskDefinitionKey());
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getFormState()), SysActFormAuth::getFormState, (Object)workflowAuthConfigQueryDto.getFormState());
        List result = this.list((Wrapper)flowAuthWrapper);
        JSONArray jsonArray = new JSONArray();
        for (SysActFormAuth sysActFormAuth : result) {
            if (sysActFormAuth.getProcessVersion() == null) continue;
            jsonArray.add((Object)sysActFormAuth);
        }
        if (jsonArray.isEmpty()) {
            jsonArray.addAll((Collection)result);
        }
        return jsonArray;
    }

    public JSONArray initList(String formName, String processKey, String formType, String taskDefinitionKey, String formState) {
        LambdaQueryWrapper flowAuthWrapper = new LambdaQueryWrapper();
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)formName), SysActFormAuth::getFormName, (Object)formName);
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)processKey), SysActFormAuth::getProcessKey, (Object)processKey);
        flowAuthWrapper.eq(SysActFormAuth::getFormType, (Object)formType);
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)taskDefinitionKey), SysActFormAuth::getTaskDefinitionKey, (Object)taskDefinitionKey);
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)formState), SysActFormAuth::getFormState, (Object)formState);
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            flowAuthWrapper.eq(SysActFormAuth::getProcessKey, (Object)processKey);
            String version = this.getProcessVersion(processKey);
            if (version == null) {
                return JSON.parseArray((String)JSON.toJSONString((Object)this.list((Wrapper)flowAuthWrapper)));
            }
            flowAuthWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysActFormAuth::getProcessVersion, (Object)Integer.valueOf(version))).or()).isNull(SysActFormAuth::getProcessVersion);
            });
            List result = this.list((Wrapper)flowAuthWrapper);
            JSONArray jsonArray = new JSONArray();
            for (SysActFormAuth sysActFormAuth : result) {
                if (sysActFormAuth.getProcessVersion() == null) continue;
                jsonArray.add((Object)sysActFormAuth);
            }
            if (jsonArray.isEmpty()) {
                jsonArray.addAll((Collection)result);
            }
            return JSON.parseArray((String)JSON.toJSONString((Object)jsonArray));
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)this.list((Wrapper)flowAuthWrapper)));
    }

    public boolean saveOrUpdateAuth(JSONArray insertAuth) {
        List list = JSONObject.parseArray((String)insertAuth.toJSONString(), SysActFormAuth.class);
        String version = this.getProcessVersion(((SysActFormAuth)list.get(0)).getProcessKey());
        for (SysActFormAuth formAuth : list) {
            formAuth.setProcessVersion(version != null ? Integer.valueOf(version) : null);
        }
        return this.saveOrUpdateBatch(list);
    }

    public boolean removeAuth(String formName, String formType, String processKey, String formState) {
        LambdaQueryWrapper flowAuthWrapper = new LambdaQueryWrapper();
        flowAuthWrapper.eq(SysActFormAuth::getFormName, (Object)formName);
        flowAuthWrapper.eq(SysActFormAuth::getFormType, (Object)formType);
        flowAuthWrapper.eq(SysActFormAuth::getProcessKey, (Object)processKey);
        String version = this.getProcessVersion(processKey);
        if (version == null) {
            flowAuthWrapper.isNull(SysActFormAuth::getProcessVersion);
        } else {
            flowAuthWrapper.eq(SysActFormAuth::getProcessVersion, (Object)Integer.valueOf(version));
        }
        flowAuthWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysActFormAuth::getFormState, (Object)formState)).or()).isNull(SysActFormAuth::getFormState);
        });
        return this.remove((Wrapper)flowAuthWrapper);
    }

    private String getProcessVersion(String processKey) {
        try {
            String processDefinitionId = this.processDefinitionsService.getLastProcessDefinitionId(processKey);
            return processDefinitionId.split(":")[1];
        }
        catch (BpmException e) {
            return null;
        }
    }

    public boolean copyAuth(String processKey, String oldProcessKey) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)oldProcessKey));
        for (SysActFormAuth sysActFormAuth : list) {
            sysActFormAuth.setId(null);
            sysActFormAuth.setProcessKey(processKey);
        }
        return this.saveBatch(list);
    }

    public BpmResponseResult queryFormAuthConfigs(String formId, String taskId, String formType, String processKey) {
        List<Object> list = new ArrayList();
        JSONObject jsonObject = new JSONObject();
        if (HussarUtils.isEmpty((Object)taskId)) {
            String processVersion = this.processDefinitionsService.getStartProcessDefinitionId(processKey, null, null).split(":")[1];
            list = this.sysActFormAuthMapper.queryFormAuthWithoutTask(formId, formType, processKey, processVersion, null);
            jsonObject.put("isFirst", (Object)true);
        } else {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (HussarUtils.isEmpty((Object)task)) {
                formType = "1";
                jsonObject.put("isFirst", (Object)false);
            } else {
                jsonObject.put("isFirst", (Object)false);
                String taskDefinitionKey = task.getTaskDefinitionKey();
                BpmnModel bpmnModel = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
                Process process = bpmnModel.getMainProcess();
                Collection flowElements = process.getFlowElements();
                for (FlowElement flowElement : flowElements) {
                    List startOut;
                    String firstUserTask;
                    if (!(flowElement instanceof StartEvent) || !taskDefinitionKey.equals(firstUserTask = ((SequenceFlow)(startOut = ((StartEvent)flowElement).getOutgoingFlows()).get(0)).getTargetRef())) continue;
                    jsonObject.put("isFirst", (Object)true);
                    break;
                }
            }
            list = this.getListByTaskId(formId, null, formType, null, taskId);
        }
        jsonObject.put("data", (Object)JSONArray.parseArray((String)JSON.toJSONString(list)));
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)jsonObject);
        return InstallResult.success((JSONArray)jsonArray);
    }

    public String dealPath(String path) {
        return this.lcdpBpmProperties.getTenantCallAddress() + path;
    }

    public BpmResponseResult queryFormAuthConfigs(String taskId, String formType, String processKey) {
        List<Object> list = new ArrayList();
        if (HussarUtils.isEmpty((Object)taskId)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey, null);
            String processVersion = definitionModel.getVersion();
            list = this.sysActFormAuthMapper.queryFormAuthWithoutTask(null, formType, processKey, processVersion, null);
        } else {
            list = this.getListByTaskId(null, null, formType, null, taskId);
        }
        return InstallResult.success((JSONArray)JSONArray.parseArray((String)JSON.toJSONString(list)));
    }

    public BpmResponseResult queryFormAuthConfigsByDto(WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto) {
        return InstallResult.success((JSONArray)this.queryFormAuthConfig(workflowAuthConfigQueryDto));
    }

    public BpmResponseResult queryFormAuthConfigsByDtoForNoCode(WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto) {
        List<Object> list = new ArrayList();
        JSONObject jsonObject = new JSONObject();
        String taskId = workflowAuthConfigQueryDto.getTaskId();
        String processKey = workflowAuthConfigQueryDto.getProcessKey();
        String taskDefinitionKey = workflowAuthConfigQueryDto.getTaskDefinitionKey();
        String formId = workflowAuthConfigQueryDto.getFormId();
        String formType = workflowAuthConfigQueryDto.getFormType();
        String processDefinitionId = null;
        jsonObject.put("isFirst", (Object)false);
        if (HussarUtils.isEmpty((Object)taskId)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey, null);
            String processVersion = definitionModel.getVersion();
            processDefinitionId = definitionModel.getId();
            list = this.sysActFormAuthMapper.queryFormAuthWithoutTask(formId, formType, processKey, processVersion, taskDefinitionKey);
        } else {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (HussarUtils.isEmpty((Object)task)) {
                formType = "1";
                jsonObject.put("isFirst", (Object)false);
            } else {
                processDefinitionId = task.getProcessDefinitionId();
            }
            list = this.getListByTaskId(formId, null, formType, null, taskId);
        }
        if (HussarUtils.isNotEmpty((Object)processDefinitionId)) {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            for (FlowElement flowElement : flowElements) {
                List startOut;
                String firstUserTask;
                if (!(flowElement instanceof StartEvent) || !taskDefinitionKey.equals(firstUserTask = ((SequenceFlow)(startOut = ((StartEvent)flowElement).getOutgoingFlows()).get(0)).getTargetRef())) continue;
                jsonObject.put("isFirst", (Object)true);
                break;
            }
        }
        jsonObject.put("data", (Object)JSONArray.parseArray((String)JSON.toJSONString(list)));
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)jsonObject);
        return InstallResult.success((JSONArray)jsonArray);
    }

    public Map<String, List<String>> queryFormRequiredAuth(WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto) {
        HashMap<String, List<String>> taskNodeFormAuthMap = new HashMap<String, List<String>>();
        JSONArray jsonArray = this.queryFormAuthConfig(workflowAuthConfigQueryDto);
        for (Object formAuth : jsonArray) {
            if (!(formAuth instanceof SysActFormAuth) || HussarUtils.isEmpty((Object)((SysActFormAuth)formAuth).getTaskDefinitionKey())) continue;
            List<Object> requiredList = new ArrayList();
            String insRequired = ((SysActFormAuth)formAuth).getInsRequired();
            if (HussarUtils.isNotEmpty((Object)insRequired) && HussarUtils.isNotEmpty((Object)(insRequired = insRequired.substring(1, insRequired.length() - 1)))) {
                insRequired = insRequired.replaceAll("\"", "");
                requiredList = Arrays.asList(insRequired.split(","));
            }
            taskNodeFormAuthMap.put(((SysActFormAuth)formAuth).getTaskDefinitionKey(), requiredList);
        }
        return taskNodeFormAuthMap;
    }
}

