/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiProcessStartedEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessCreateListener
implements ActivitiEventListener {
    private static Logger logger = LogManager.getLogger(ProcessCreateListener.class);
    @Autowired
    private IFlowTaskService flowTaskService;
    private DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getSpringContext().getBean(DataPushService.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        DataPush dataPush;
        String startUserId;
        String taskSourceFlag;
        List chosenDayElement;
        List globalTimeOutStrategyElement;
        ExecutionEntity entity = (ExecutionEntity)((ActivitiProcessStartedEventImpl)activitiEvent).getEntity();
        BpmnModel bm = Context.getCommandContext().getProcessEngineConfiguration().getRepositoryService().getBpmnModel(entity.getProcessDefinitionId());
        Map extensionElementList = ((Process)bm.getProcesses().get(0)).getExtensionElements();
        List globalDueDateElement = (List)extensionElementList.get("globalDueDate");
        String globalDueDate = "";
        String globalTimeOutStrategy = "";
        String chosenDay = "";
        if (HussarUtils.isNotEmpty((Object)globalDueDateElement) && HussarUtils.isNotEmpty(((ExtensionElement)globalDueDateElement.get(0)).getAttributes().get("globalDueDate"))) {
            globalDueDate = ((ExtensionAttribute)((List)((ExtensionElement)globalDueDateElement.get(0)).getAttributes().get("globalDueDate")).get(0)).getValue();
        }
        if (HussarUtils.isNotEmpty((Object)(globalTimeOutStrategyElement = (List)extensionElementList.get("globalTimeOutStrategy"))) && HussarUtils.isNotEmpty(((ExtensionElement)globalTimeOutStrategyElement.get(0)).getAttributes().get("globalTimeOutStrategy"))) {
            globalTimeOutStrategy = ((ExtensionAttribute)((List)((ExtensionElement)globalTimeOutStrategyElement.get(0)).getAttributes().get("globalTimeOutStrategy")).get(0)).getValue();
        }
        if (HussarUtils.isNotEmpty((Object)(chosenDayElement = (List)extensionElementList.get("chosenDay"))) && HussarUtils.isNotEmpty(((ExtensionElement)chosenDayElement.get(0)).getAttributes().get("chosenDay"))) {
            chosenDay = ((ExtensionAttribute)((List)((ExtensionElement)chosenDayElement.get(0)).getAttributes().get("chosenDay")).get(0)).getValue();
        }
        if (TaskSourceFlag.SUB_PROCESS_START.contains(taskSourceFlag = BpmAttribute.getTaskSourceFlag((ActivityExecution)entity)) && entity.getSuperExecution() != null && !"main_reject".equals(taskSourceFlag)) {
            HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(entity.getProcessInstanceId());
            historicProcessInstance.setCompleteFrom(entity.getSuperExecution().getAllPrevNode());
        }
        String string = startUserId = entity.getVariable("startUser") == null ? "" : entity.getVariable("startUser").toString();
        if (HussarUtils.isEmpty((Object)startUserId)) {
            startUserId = (String)BpmAttribute.getContextAttribute("sendUser");
        }
        if (HussarUtils.isNotEmpty((Object)globalDueDate) || HussarUtils.isNotEmpty((Object)globalTimeOutStrategy) || HussarUtils.isNotEmpty((Object)chosenDay)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", "processCreateEnd");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            map.put("createTime", simpleDateFormat.format(new Date()));
            map.put("businessId", entity.getBusinessKey());
            map.put("processInsId", entity.getProcessInstanceId());
            map.put("processDefinitionId", entity.getProcessDefinitionId());
            map.put("processDefinitionName", entity.getProcessDefinition().getName());
            map.put("starter", startUserId);
            CommonCodeUtil.triggerEventHandleClass(map);
        }
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(entity.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            dataPush = new DataPush();
            dataPush.setBusinessKey(entity.getBusinessKey());
            dataPush.setProcessKey(entity.getProcessDefinitionKey());
            dataPush.setProcessInsId(entity.getProcessInstanceId());
            dataPush.setProcessStartTime(new Date());
            dataPush.setProcessState("startProcess");
            dataPush.setProcessDefinitionId(entity.getProcessDefinitionId());
            dataPush.setStartUserId(startUserId);
            dataPush.setStartOrganId(entity.getOrganId());
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            dataPush = new DataPush();
            dataPush.setBusinessKey(entity.getBusinessKey());
            dataPush.setProcessKey(entity.getProcessDefinitionKey());
            dataPush.setProcessInsId(entity.getProcessInstanceId());
            dataPush.setProcessName(entity.getProcessDefinition().getName());
            dataPush.setProcessDefinitionId(entity.getProcessDefinitionId());
            dataPush.setProcessStartTime(new Date());
            dataPush.setStartUserId(startUserId);
            dataPush.setStartOrganId(entity.getOrganId());
            dataPush.setDescription((String)entity.getVariableLocal("todoConfiguration"));
            String processTitle = entity.getProcessTitle();
            String dataDetail = entity.getDataDetail();
            dataPush.setProcessTitle(processTitle);
            dataPush.setDataDetail(dataDetail);
            Process process = (Process)bm.getProcesses().get(0);
            Collection flowElements = process.getFlowElements();
            String targetNodeId = null;
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof StartEvent)) continue;
                targetNodeId = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
                break;
            }
            dataPush.setTaskDefinitionKey(targetNodeId);
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask) || !targetNodeId.equals(flowElement.getId())) continue;
                String formKey = ((UserTask)flowElement).getFormKey();
                dataPush.setUrl(formKey);
                break;
            }
            dataPush.setAppId(this.flowTaskService.getProcessAppId(entity.getProcessDefinitionKey()));
            this.dataPushService.addStartProcess(dataPush);
        }
    }

    public boolean isFailOnException() {
        logger.error("\u6d41\u7a0b\u542f\u52a8\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }
}

