/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ProcessNode;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.ProcessDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;

public class StartAndCompleteFinalPushCmd
extends AddAttributeCmd<Void> {
    private DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getBean(DataPushService.class);
    private IFlowTaskService flowTaskService = (IFlowTaskService)BpmSpringContextHolder.getBean(IFlowTaskService.class);
    private ISysActCcTaskService sysActCcTaskService = (ISysActCcTaskService)BpmSpringContextHolder.getBean(ISysActCcTaskService.class);
    private String processInsId;
    private String userId;
    private String comment;

    public StartAndCompleteFinalPushCmd(String processInsId, String userId, String comment) {
        this.processInsId = processInsId;
        this.userId = userId;
        this.comment = comment;
    }

    public Void execute(CommandContext commandContext) {
        Object processNodes;
        ExecutionEntity executionEntity = commandContext.getExecutionEntityManager().findExecutionById(this.processInsId);
        if (!this.dataPushService.isDataPush(executionEntity.getProcessDefinitionId())) {
            return null;
        }
        HistoricProcessInstanceEntity historicProcessInstanceEntity = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(this.processInsId);
        DataPush dataPush = new DataPush();
        dataPush.setBusinessKey(executionEntity.getBusinessKey());
        dataPush.setProcessKey(executionEntity.getProcessDefinitionKey());
        dataPush.setProcessInsId(executionEntity.getProcessInstanceId());
        dataPush.setProcessName(executionEntity.getProcessDefinition().getName());
        dataPush.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
        dataPush.setProcessStartTime(historicProcessInstanceEntity.getStartTime());
        dataPush.setProcessState("startProcess");
        dataPush.setStartUserId(this.userId);
        dataPush.setStartOrganId(executionEntity.getOrganId());
        dataPush.setDescription((String)executionEntity.getVariableLocal("todoConfiguration"));
        String processTitle = executionEntity.getProcessTitle();
        String dataDetail = executionEntity.getDataDetail();
        dataPush.setProcessTitle(processTitle);
        dataPush.setDataDetail(dataDetail);
        BpmnModel bpmnModel = Context.getCommandContext().getProcessEngineConfiguration().getRepositoryService().getBpmnModel(executionEntity.getProcessDefinitionId());
        Process process = (Process)bpmnModel.getProcesses().get(0);
        Collection flowElements = process.getFlowElements();
        String targetNodeId = null;
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            targetNodeId = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
            break;
        }
        dataPush.setTaskDefinitionKey(targetNodeId);
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof UserTask) || !targetNodeId.equals(flowElement.getId())) continue;
            String formKey = ((UserTask)flowElement).getFormKey();
            dataPush.setUrl(formKey);
            break;
        }
        dataPush.setAppId(this.flowTaskService.getProcessAppId(executionEntity.getProcessDefinitionKey()));
        List list = commandContext.getDbSqlSession().findInCache(HistoricTaskInstanceEntity.class);
        list.removeIf(e -> !this.processInsId.equals(e.getProcessInstanceId()));
        if (historicProcessInstanceEntity.getEndTime() != null) {
            String endActId = historicProcessInstanceEntity.getEndActivityId();
            String endName = bpmnModel.getFlowElement(endActId).getName();
            processNodes = new ArrayList<ProcessNode>();
            ProcessNode end = new ProcessNode();
            end.setTaskDefinitionName(endName);
            end.setTaskDefinitionKey(endActId);
            processNodes.add(end);
            dataPush.setProcessNodeList(processNodes);
            dataPush.setProcessEndTime(historicProcessInstanceEntity.getEndTime());
            dataPush.setProcessNode(endName);
            dataPush.setProcessState("completeProcess");
        } else {
            ProcessNode processNode;
            HashMap processNodeMap = new HashMap();
            List activityInstanceEntities = commandContext.getDbSqlSession().findInCache(HistoricActivityInstanceEntity.class);
            activityInstanceEntities.removeIf(e -> !this.processInsId.equals(e.getProcessInstanceId()));
            processNodes = new ArrayList();
            HashSet<String> runningNodeIdList = new HashSet<String>();
            HashMap subRunningNodeIdListMap = new HashMap();
            for (HistoricActivityInstanceEntity activityInstanceEntity : activityInstanceEntities) {
                String activityType;
                if (activityInstanceEntity.getEndTime() != null || !"receiveTask".equals(activityType = activityInstanceEntity.getActivityType()) && !"callActivity".equals(activityType)) continue;
                String subProcessKey = activityInstanceEntity.getSubProcessKey();
                if (subProcessKey != null) {
                    ProcessNode subProcessNode = null;
                    if (processNodeMap.containsKey(subProcessKey)) {
                        subProcessNode = (ProcessNode)processNodeMap.get(subProcessKey);
                    } else {
                        String nodeId = subProcessKey.split(":")[0];
                        subProcessNode = new ProcessNode();
                        subProcessNode.setTaskDefinitionKey(nodeId);
                        subProcessNode.setTaskDefinitionName(bpmnModel.getFlowElement(nodeId).getName());
                        subProcessNode.setChildrenList(new ArrayList());
                        processNodes.add(subProcessNode);
                        subRunningNodeIdListMap.put(subProcessKey, new HashSet());
                    }
                    if (!((Set)subRunningNodeIdListMap.get(subProcessKey)).add(activityInstanceEntity.getActivityId())) continue;
                    ProcessNode processNode2 = new ProcessNode();
                    processNode2.setTaskDefinitionKey(activityInstanceEntity.getActivityId());
                    processNode2.setTaskDefinitionName(activityInstanceEntity.getActivityName());
                    subProcessNode.getChildrenList().add(processNode2);
                    continue;
                }
                if (!runningNodeIdList.add(activityInstanceEntity.getActivityId())) continue;
                processNode = new ProcessNode();
                processNode.setTaskDefinitionKey(activityInstanceEntity.getActivityId());
                processNode.setTaskDefinitionName(activityInstanceEntity.getActivityName());
                processNodes.add(processNode);
            }
            for (HistoricTaskInstanceEntity historicTask : list) {
                if (historicTask.getEndTime() != null) continue;
                String subProcessKey = historicTask.getSubProcessKey();
                if (subProcessKey != null) {
                    ProcessNode subProcessNode = null;
                    if (processNodeMap.containsKey(subProcessKey)) {
                        subProcessNode = (ProcessNode)processNodeMap.get(subProcessKey);
                    } else {
                        String nodeId = subProcessKey.split(":")[0];
                        subProcessNode = new ProcessNode();
                        subProcessNode.setTaskDefinitionKey(nodeId);
                        subProcessNode.setTaskDefinitionName(bpmnModel.getFlowElement(nodeId).getName());
                        subProcessNode.setChildrenList(new ArrayList());
                        processNodes.add(subProcessNode);
                        subRunningNodeIdListMap.put(subProcessKey, new HashSet());
                    }
                    if (!((Set)subRunningNodeIdListMap.get(subProcessKey)).add(historicTask.getTaskDefinitionKey())) continue;
                    processNode = new ProcessNode();
                    processNode.setTaskDefinitionKey(historicTask.getTaskDefinitionKey());
                    processNode.setTaskDefinitionName(historicTask.getName());
                    subProcessNode.getChildrenList().add(processNode);
                    continue;
                }
                if (!runningNodeIdList.add(historicTask.getTaskDefinitionKey())) continue;
                ProcessNode processNode3 = new ProcessNode();
                processNode3.setTaskDefinitionKey(historicTask.getTaskDefinitionKey());
                processNode3.setTaskDefinitionName(historicTask.getName());
                processNodes.add(processNode3);
            }
            dataPush.setProcessNodeList(processNodes);
            dataPush.setProcessNode(String.join((CharSequence)",", processNodes.stream().map(ProcessNode::getTaskDefinitionName).collect(Collectors.toSet())));
        }
        List ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActCcTask::getProcessInsId, (Object)this.processInsId));
        HashMap<String, List> ccMap = new HashMap<String, List>();
        for (Object sysActCcTask : ccTasks) {
            ccMap.computeIfAbsent(String.valueOf(sysActCcTask.getTaskId()), e -> new ArrayList()).add(sysActCcTask);
        }
        ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
        for (HistoricTaskInstanceEntity historicTaskInstanceEntity : list) {
            DataPush ccDataPush;
            List ccList = (List)ccMap.get(historicTaskInstanceEntity.getId());
            String ccUrl = null;
            if (HussarUtils.isNotEmpty((Object)ccTasks)) {
                ccUrl = ((SysActCcTask)ccTasks.get(0)).getFormKey();
            } else {
                List ccFormKeyList;
                Map ccFormKeyMap;
                List ccElement = (List)bpmnModel.getFlowElement(historicTaskInstanceEntity.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
                String formKey = null;
                if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                    formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
                }
                ccUrl = formKey;
            }
            DataPush taskDataPush = this.dataPush(historicTaskInstanceEntity, executionEntity, (HistoricProcessInstance)historicProcessInstanceEntity, ccUrl);
            if (historicTaskInstanceEntity.getEndTime() != null) {
                taskDataPush.setType("addComplete");
                taskDataPush.setUserId(historicTaskInstanceEntity.getAssignee());
                taskDataPush.setComment(this.comment);
            } else {
                taskDataPush.setType("add");
            }
            dataPushList.add(taskDataPush);
            if (ccList == null) continue;
            List ccUsers = ccList.stream().filter(e -> "0".equals(e.getCcMoment())).map(SysActCcTask::getReceiveUser).collect(Collectors.toList());
            if (ccUsers.contains(this.userId)) {
                ccUsers.remove(this.userId);
                ccDataPush = this.dataPush(historicTaskInstanceEntity, executionEntity, (HistoricProcessInstance)historicProcessInstanceEntity, ccUrl);
                ccDataPush.setCcMoment("0");
                ccDataPush.setUserId(this.userId);
                ccDataPush.setStartDate((Date)((SysActCcTask)ccList.get(0)).getSendTime());
                ccDataPush.setTaskState("1");
                ccDataPush.setType("ccAdd");
                dataPushList.add(ccDataPush);
            }
            if (!ccUsers.isEmpty()) {
                ccDataPush = this.dataPush(historicTaskInstanceEntity, executionEntity, (HistoricProcessInstance)historicProcessInstanceEntity, ccUrl);
                ccDataPush.setCcMoment("0");
                ccDataPush.setUserId(String.join((CharSequence)",", ccUsers));
                ccDataPush.setStartDate((Date)((SysActCcTask)ccList.get(0)).getSendTime());
                ccDataPush.setType("ccAdd");
                dataPushList.add(ccDataPush);
            }
            if ((ccUsers = ccList.stream().filter(e -> "1".equals(e.getCcMoment())).map(SysActCcTask::getReceiveUser).collect(Collectors.toList())).isEmpty()) continue;
            ccDataPush = this.dataPush(historicTaskInstanceEntity, executionEntity, (HistoricProcessInstance)historicProcessInstanceEntity, ccUrl);
            ccDataPush.setCcMoment("1");
            ccDataPush.setUserId(String.join((CharSequence)",", ccUsers));
            ccDataPush.setStartDate((Date)((SysActCcTask)ccList.get(0)).getSendTime());
            ccDataPush.setType("ccAdd");
            dataPushList.add(ccDataPush);
        }
        ProcessDataPush processDataPush = new ProcessDataPush();
        processDataPush.setDataPush(dataPush);
        processDataPush.setTaskDataPush(dataPushList);
        this.dataPushService.processChange(processDataPush);
        return null;
    }

    private DataPush dataPush(HistoricTaskInstanceEntity task, ExecutionEntity processInstance, HistoricProcessInstance historicProcessInstance, String ccUrl) {
        String processInstanceId = task.getProcessInstanceId();
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        if (historicProcessInstance != null) {
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
            dataPush.setStartOrganId(historicProcessInstance.getOrganId());
        } else {
            dataPush.setBusinessKey(processInstance.getBusinessKey());
            dataPush.setStartUserId(task.getSendUser());
        }
        String processDefinitionId = task.getProcessDefinitionId();
        String processKey = processDefinitionId.split(":")[0];
        String processVersion = processDefinitionId.split(":")[1];
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(processDefinitionId);
        dataPush.setProcessKey(processKey);
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setSendUser(task.getSendUser());
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(task.getEndTime());
        dataPush.setTaskDueTime(task.getDueDate());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription(task.getTodoConfiguration());
        String processTitle = null;
        processTitle = HussarUtils.isEmpty((Object)historicProcessInstance) ? processInstance.getProcessTitle() : historicProcessInstance.getProcessTitle();
        String dataDetail = null;
        dataDetail = HussarUtils.isEmpty((Object)historicProcessInstance) ? processInstance.getDataDetail() : historicProcessInstance.getDataDetail();
        dataPush.setProcessTitle(processTitle);
        dataPush.setDataDetail(dataDetail);
        dataPush.setProcessName(processInstance.getProcessDefinition().getName());
        dataPush.setProcessInsId(processInstanceId);
        dataPush.setTaskType(task.getTaskType());
        dataPush.setProcessVersion(processVersion);
        String processDefKey = null;
        processDefKey = HussarUtils.isEmpty((Object)historicProcessInstance) ? processInstance.getProcessDefinitionKey() : historicProcessInstance.getProcessDefinitionKey();
        dataPush.setAppId(this.flowTaskService.getProcessAppId(processDefKey));
        dataPush.setFormId(task.getFormId());
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(task.getId());
        List<Map<String, String>> taskAssigneeMap = this.getAssigneeMapByTaskId(taskEntity);
        if (taskAssigneeMap.isEmpty()) {
            if (task.getTaskDefinitionKey().equals(historicProcessInstance.getFirstUserTaskActivityId()) && historicProcessInstance.getSuperProcessInstanceId() == null) {
                HashMap<String, String> assigneeMap = new HashMap<String, String>();
                assigneeMap.put("userId", this.userId);
                taskAssigneeMap.add(assigneeMap);
            } else if (taskEntity.getAssignee() != null) {
                HashMap<String, String> assigneeMap = new HashMap<String, String>();
                assigneeMap.put("userId", taskEntity.getAssignee());
                taskAssigneeMap.add(assigneeMap);
            }
        }
        dataPush.setUserMaps(taskAssigneeMap);
        dataPush.setTaskType(task.getTaskType());
        dataPush.setCcUrl(ccUrl);
        return dataPush;
    }

    private String getAssigneeByTaskId(TaskEntity taskEntity) {
        HashSet<String> users = new HashSet<String>();
        List identityLinks = taskEntity.getCandidates();
        if (identityLinks != null && !identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                users.add(identityLink.getUserId());
            }
        }
        if (taskEntity.getAssignee() != null) {
            users.add(taskEntity.getAssignee());
        }
        return String.join((CharSequence)",", users);
    }

    private List<Map<String, String>> getAssigneeMapByTaskId(TaskEntity taskEntity) {
        ArrayList<Map<String, String>> userMaps = new ArrayList<Map<String, String>>();
        List identityLinks = taskEntity.getCandidates();
        if (identityLinks != null && !identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", identityLink.getUserId());
                if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                    map.put("mandator", identityLink.getMandator());
                    map.put("taskState", identityLink.getTaskState());
                }
                userMaps.add(map);
            }
        }
        return userMaps;
    }
}

