/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;

public class CommonPrepareCmd
extends NeedsActiveTaskCmd<PrepareReturn> {
    protected IAssigneeChooseService assigneeChooseService = (IAssigneeChooseService)BpmSpringContextHolder.getBean(IAssigneeChooseService.class);
    protected SysActCcTaskMapper sysActCcTaskMapper = (SysActCcTaskMapper)BpmSpringContextHolder.getBean(SysActCcTaskMapper.class);
    protected String userId;
    protected String mandator;
    protected String taskState;
    protected TaskEntity taskEntity;
    protected boolean isAuditAuthority = true;

    public CommonPrepareCmd(String taskId, String userId, String mandator, boolean isAuditAuthority) {
        super(taskId);
        this.userId = userId;
        this.mandator = mandator;
        this.isAuditAuthority = isAuditAuthority;
    }

    public PrepareReturn execute(CommandContext commandContext, TaskEntity task) {
        block8: {
            boolean mandataryFlag;
            boolean mandatorFlag;
            ArrayList<IdentityLinkEntity> userTasks;
            block13: {
                block10: {
                    block11: {
                        block12: {
                            block9: {
                                this.taskAuthentication(task);
                                if (!this.isAuditAuthority) break block8;
                                if (!HussarUtils.isNotEmpty((Object)task.getAssignee()) || !task.getAssignee().equals(this.userId)) break block9;
                                this.mandator = null;
                                this.taskState = null;
                                break block8;
                            }
                            List identityLinks = task.getCandidates();
                            userTasks = new ArrayList<IdentityLinkEntity>();
                            mandatorFlag = HussarUtils.isEmpty((Object)this.mandator);
                            mandataryFlag = HussarUtils.isNotEmpty((Object)this.mandator);
                            for (IdentityLinkEntity identityLink : identityLinks) {
                                if (!this.userId.equals(identityLink.getUserId())) continue;
                                userTasks.add(identityLink);
                            }
                            if (userTasks.isEmpty()) {
                                for (IdentityLinkEntity identityLink : identityLinks) {
                                    if (!HussarUtils.isNotEmpty((Object)identityLink.getTaskState()) || !identityLink.getMandator().equals(this.userId)) continue;
                                    if (Context.getCommandContext().getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceCountByQueryCriteria(new HistoricTaskInstanceQueryImpl().processInstanceId(task.getProcessInstanceId())) == 1L) {
                                        return new PrepareReturn(this, BpmExceptionCodeEnum.TASK_ALREADY_ENTRUST.format(new Object[]{this.assigneeChooseService.getUserListByUserId(Collections.singletonList(identityLink.getUserId())).get(identityLink.getUserId())}).getMessage());
                                    }
                                    throw new BpmException(BpmExceptionCodeEnum.TASK_ALREADY_ENTRUST.format(new Object[]{this.assigneeChooseService.getUserListByUserId(Collections.singletonList(identityLink.getUserId())).get(identityLink.getUserId())}).getMessage());
                                }
                                throw new BpmException(BpmExceptionCodeEnum.NO_AUTHORITY_COMPLETE.getMessage());
                            }
                            if (userTasks.size() != 1) break block10;
                            if (!TaskStateType.isEntrust((IdentityLink)((IdentityLink)userTasks.get(0)))) break block11;
                            String taskMandator = ((IdentityLinkEntity)userTasks.get(0)).getMandator();
                            if (!HussarUtils.isNotEmpty((Object)this.mandator) || !this.mandator.equals(taskMandator)) break block12;
                            this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
                            mandatorFlag = true;
                            break block13;
                        }
                        if (!HussarUtils.isEmpty((Object)this.mandator)) break block13;
                        this.mandator = ((IdentityLinkEntity)userTasks.get(0)).getMandator();
                        this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
                        mandataryFlag = true;
                        break block13;
                    }
                    if (!HussarUtils.isEmpty((Object)this.mandator)) break block13;
                    mandataryFlag = true;
                    break block13;
                }
                for (IdentityLinkEntity identityLink : userTasks) {
                    if (HussarUtils.isEmpty((Object)this.mandator) && HussarUtils.isEmpty((Object)identityLink.getMandator())) {
                        mandataryFlag = true;
                        break;
                    }
                    if (!HussarUtils.isNotEmpty((Object)this.mandator) || !this.mandator.equals(identityLink.getMandator())) continue;
                    mandatorFlag = true;
                    this.taskState = identityLink.getTaskState();
                    break;
                }
            }
            if (!mandatorFlag) {
                throw new BpmException(BpmExceptionCodeEnum.NOT_ENTRUSTER.format(new Object[]{this.assigneeChooseService.getUserListByUserId(Collections.singletonList(this.mandator)).get(this.mandator)}).getMessage());
            }
            if (!mandataryFlag) {
                this.mandator = ((IdentityLinkEntity)userTasks.get(0)).getMandator();
                this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
            }
        }
        this.follow(commandContext, task);
        return new PrepareReturn(this);
    }

    protected void taskAuthentication(TaskEntity task) {
        if (task == null) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND);
        }
        if (task.isSuspended()) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_IS_SUSPENDED);
        }
        if (task.getParentTaskId() != null) {
            throw new BpmException(BpmExceptionCodeEnum.ASSIST_TASK_WITH_ERROR_HANDLE);
        }
    }

    public CommonPrepareCmd(String taskId, String userId) {
        super(taskId);
        this.userId = userId;
    }

    public CommonPrepareCmd(String taskId, String userId, String mandator) {
        super(taskId);
        this.userId = userId;
        this.mandator = mandator;
    }

    protected void follow(CommandContext commandContext, TaskEntity task) {
    }

    public CommonPrepareCmd notAuditAuthority() {
        this.isAuditAuthority = false;
        return this;
    }

    public CommonPrepareCmd isAuditAuthority(boolean isAuditAuthority) {
        this.isAuditAuthority = isAuditAuthority;
        return this;
    }

    public static class PrepareReturn {
        private final String mandator;
        private final String taskState;
        private final boolean isSuccess;
        private final String message;
        private final TaskEntity taskEntity;

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public String getMessage() {
            return this.message;
        }

        public String getMandator() {
            return this.mandator;
        }

        public String getTaskState() {
            return this.taskState;
        }

        public TaskEntity getTaskEntity() {
            return this.taskEntity;
        }

        private PrepareReturn(CommonPrepareCmd commonPrepareCmd) {
            this.mandator = commonPrepareCmd.mandator;
            this.taskState = commonPrepareCmd.taskState;
            this.taskEntity = commonPrepareCmd.taskEntity;
            this.isSuccess = true;
            this.message = null;
        }

        private PrepareReturn(CommonPrepareCmd commonPrepareCmd, String message) {
            this.mandator = commonPrepareCmd.mandator;
            this.taskState = commonPrepareCmd.taskState;
            this.taskEntity = commonPrepareCmd.taskEntity;
            this.isSuccess = false;
            this.message = message;
        }
    }
}

