/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.util.BpmMsgDetailBuildUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ProcessCompleteListener
implements ActivitiEventListener {
    @Autowired
    private IFlowTaskService flowTaskService;
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Autowired
    private BpmMsgPushService msgPushService;
    private static Logger logger = LogManager.getLogger(ProcessCompleteListener.class);
    @Lazy
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ISysActExtendPropertiesService sysActExtendPropertiesService;
    private DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getSpringContext().getBean(DataPushService.class);
    @Lazy
    @Resource
    private HistoryService historyService;

    public void onEvent(ActivitiEvent activitiEvent) {
        HistoricTaskInstance historicTaskInstance;
        Iterator iterator;
        HistoricProcessInstanceEntity historicProcessInstance;
        boolean isStartAndComplete;
        ExecutionEntity entity = (ExecutionEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        BpmnModel bm = Context.getCommandContext().getProcessEngineConfiguration().getRepositoryService().getBpmnModel(entity.getProcessDefinitionId());
        String formId = null;
        boolean bl = isStartAndComplete = Context.getCommandContext().getAttribute("ACTIVITI_START_AND_COMPLETE_TAG") != null;
        if (isStartAndComplete) {
            historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(entity.getId());
            List historicTaskInstances = Context.getCommandContext().getDbSqlSession().findAliveEntityInCache(HistoricTaskInstanceEntity.class);
            iterator = historicTaskInstances.iterator();
            if (iterator.hasNext()) {
                historicTaskInstance = (HistoricTaskInstance)iterator.next();
                formId = historicTaskInstance.getFormId();
            }
        } else {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(entity.getId()).singleResult();
            List historicTaskInstanceList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(entity.getId())).list();
            iterator = historicTaskInstanceList.iterator();
            if (iterator.hasNext()) {
                historicTaskInstance = (HistoricTaskInstance)iterator.next();
                formId = historicTaskInstance.getFormId();
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCompleteEnd");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("completeTime", simpleDateFormat.format(new Date()));
        map.put("tenantId", entity.getTenantId());
        map.put("processInsId", entity.getId());
        map.put("processDefinitionId", entity.getProcessDefinitionId());
        map.put("processDefinitionName", entity.getProcessDefinition().getName());
        map.put("businessId", entity.getBusinessKey());
        map.put("processTitle", historicProcessInstance.getProcessTitle());
        map.put("dataDetail", historicProcessInstance.getDataDetail());
        map.put("taskName", entity.getCurrentActivityName());
        map.put("starter", historicProcessInstance.getStartUserId());
        map.put("formId", formId);
        Process process = (Process)bm.getProcesses().get(0);
        Collection flowElements = process.getFlowElements();
        String targetNodeId = null;
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            targetNodeId = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
            break;
        }
        LambdaQueryWrapper extendPropertiesWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)extendPropertiesWrapper.eq(SysActExtendProperties::getProcDefId, (Object)entity.getProcessDefinitionId())).eq(SysActExtendProperties::getTaskDefKey, targetNodeId);
        SysActExtendProperties extendProperties = (SysActExtendProperties)this.sysActExtendPropertiesService.getOne((Wrapper)extendPropertiesWrapper);
        String formDetailKey = null;
        if (extendProperties != null) {
            formDetailKey = extendProperties.getFormDetailKey();
        }
        map.put("formDetailKey", formDetailKey);
        List linkEntityList = entity.getIdentityLinks();
        CommonCodeUtil.triggerEventHandleClass(map);
        if (entity.getProcessInstance().getSuperExecution() == null) {
            String sceneCode = "endProcess".equals(BpmAttribute.getTaskSourceFlag((ActivityExecution)entity)) ? "terminated" : "complete";
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            BpmActMsgDetail bpmActMsgDetail = BpmMsgDetailBuildUtil.executionMsgDetail((ExecutionEntity)entity, (String)sceneCode);
            bpmActMsgDetailList.add(bpmActMsgDetail);
            this.msgPushService.pushMessage(bpmActMsgDetailList);
        }
        new ProcessActionCmd(entity.getId(), entity.getProcessDefinitionId(), 1).execute(Context.getCommandContext());
        new ProcessNodeCmd(entity.getId(), entity.getProcessDefinitionId(), 1).execute(Context.getCommandContext());
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(entity.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setProcessInsId(entity.getId());
            dataPush.setBusinessKey(entity.getBusinessKey());
            dataPush.setProcessKey(entity.getProcessDefinitionKey());
            dataPush.setProcessEndTime(new Date());
            if ("endProcess".equals(BpmAttribute.getTaskSourceFlag((ActivityExecution)entity))) {
                dataPush.setProcessState("endProcess");
            } else if ("revokeProcess".equals(BpmAttribute.getTaskSourceFlag((ActivityExecution)entity))) {
                dataPush.setProcessState("revokeProcess");
            } else {
                dataPush.setProcessState("completeProcess");
            }
            dataPush.setProcessDefinitionId(entity.getProcessDefinitionId());
            dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
            dataPush.setDueDate(historicProcessInstance.getDueDate());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setStartOrganId(historicProcessInstance.getOrganId());
            for (IdentityLinkEntity identityLinkEntity : linkEntityList) {
                if (!"participant".equals(identityLinkEntity.getType())) continue;
                dataPush.setUserId(identityLinkEntity.getUserId());
            }
            this.dataPushService.changeProcessStateDataPush(dataPush);
            DataPush otherDataPush = new DataPush();
            otherDataPush.setBusinessKey(entity.getBusinessKey());
            otherDataPush.setProcessInsId(entity.getId());
            otherDataPush.setProcessEndTime(new Date());
            this.dataPushService.updateStartProcess(dataPush);
        }
    }

    public boolean isFailOnException() {
        logger.error("\u6d41\u7a0b\u5b8c\u6210\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }
}

