/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.function.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.function.dao.SysActFunctionMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.function.dto.AddFunctionDto;
import com.jxdinfo.hussar.workflow.engine.bpm.function.dto.EditFunctionDto;
import com.jxdinfo.hussar.workflow.engine.bpm.function.model.SysActFunction;
import com.jxdinfo.hussar.workflow.engine.bpm.function.model.SysActFunctionParm;
import com.jxdinfo.hussar.workflow.engine.bpm.function.service.ISysActFunctionParmService;
import com.jxdinfo.hussar.workflow.engine.bpm.function.service.ISysActFunctionService;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.FunctionDumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.FunctionDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.FunctionLoadVo;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@HussarTokenDs
public class SysActFunctionServiceImpl
extends HussarServiceImpl<SysActFunctionMapper, SysActFunction>
implements ISysActFunctionService {
    @Resource
    private SysActFunctionMapper sysActFunctionMapper;
    @Autowired
    private ISysActFunctionParmService sysActFunctionParmService;
    private static final Logger logger = LoggerFactory.getLogger(SysActFunctionServiceImpl.class);
    private static final String PARM_KEY = "parmKey";
    private static final String PARM_NAME = "parmName";
    private static final String FUNCTION = "function";
    private static final String FUNCTION_PARM = "functionParm";
    private static final String FUNCTION_IMPORT_REPEAT_NAME = "1";
    private static final String FUNCTION_IMPORT_REPEAT_BEAN = "2";
    private static final String FUNCTION_IMPORT_REPEAT_NAME_AND_BEAN = "3";

    public ApiResponse<String> add(AddFunctionDto addFunctionDto) {
        Date currTime = Date.from(LocalDateTime.now().atZone(ZoneOffset.ofHours(8)).toInstant());
        SysActFunction sysActFunction = new SysActFunction();
        sysActFunction.setFunctionName(addFunctionDto.getFunctionName());
        sysActFunction.setFunctionType(addFunctionDto.getFunctionType());
        sysActFunction.setRequestMethod(addFunctionDto.getRequestMethod());
        sysActFunction.setCreateTime(currTime);
        String beanId = addFunctionDto.getFunctionBean();
        if ("remote".equals(addFunctionDto.getFunctionType()) && HussarUtils.isNotEmpty((Object)beanId) && !beanId.startsWith("/")) {
            beanId = "/" + beanId;
        }
        sysActFunction.setFunctionBean(beanId);
        Long functionNum = this.count((Wrapper)new LambdaQueryWrapper().eq(SysActFunction::getFunctionBean, (Object)beanId));
        if (functionNum != 0L) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_EXIST_FUNCTION_BEAN_ID);
        }
        functionNum = this.count((Wrapper)new LambdaQueryWrapper().eq(SysActFunction::getFunctionName, (Object)addFunctionDto.getFunctionName()));
        if (functionNum != 0L) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_EXIST_FUNCTION_BEAN_NAME);
        }
        int insertResult = this.sysActFunctionMapper.insert(sysActFunction);
        if (insertResult != 1) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_INSERT);
        }
        if (HussarUtils.isNotEmpty((Object)addFunctionDto.getFunctionParm())) {
            ArrayList<SysActFunctionParm> parmList = new ArrayList<SysActFunctionParm>();
            JSONArray jsonArray = JSON.parseArray((String)addFunctionDto.getFunctionParm());
            for (int i = 0; i < jsonArray.size(); ++i) {
                SysActFunctionParm sysActFunctionParm = new SysActFunctionParm();
                sysActFunctionParm.setFunctionId(sysActFunction.getId());
                sysActFunctionParm.setParmKey(jsonArray.getJSONObject(i).getString(PARM_KEY));
                sysActFunctionParm.setParmName(jsonArray.getJSONObject(i).getString(PARM_NAME));
                sysActFunctionParm.setCreateTime(currTime);
                parmList.add(sysActFunctionParm);
            }
            boolean saveResult = this.sysActFunctionParmService.saveBatch(parmList);
            if (!saveResult) {
                throw new BpmException(BpmExceptionCodeEnum.ERROR_INSERT);
            }
        }
        return ApiResponse.success((String)BpmExceptionCodeEnum.SUCCESS_INSERT.getMessage());
    }

    public ApiResponse<String> update(EditFunctionDto editFunctionDto) {
        Date currTime = Date.from(LocalDateTime.now().atZone(ZoneOffset.ofHours(8)).toInstant());
        if (Boolean.parseBoolean(editFunctionDto.getChange())) {
            Long functionNum = this.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFunction::getFunctionName, (Object)editFunctionDto.getFunctionName())).ne(SysActFunction::getId, (Object)Long.valueOf(editFunctionDto.getId())));
            if (functionNum != 0L) {
                throw new BpmException(BpmExceptionCodeEnum.ERROR_EXIST_FUNCTION_BEAN_NAME);
            }
            SysActFunction sysActFunction = new SysActFunction();
            sysActFunction.setId(Long.valueOf(editFunctionDto.getId()));
            sysActFunction.setFunctionBean(editFunctionDto.getFunctionBean());
            sysActFunction.setFunctionName(editFunctionDto.getFunctionName());
            sysActFunction.setFunctionType(editFunctionDto.getFunctionType());
            sysActFunction.setRequestMethod(editFunctionDto.getRequestMethod());
            sysActFunction.setUpdateTime(currTime);
            int updateResult = this.sysActFunctionMapper.updateById(sysActFunction);
            if (updateResult != 1) {
                throw new BpmException(BpmExceptionCodeEnum.ERROR_UPDATE);
            }
        }
        if (HussarUtils.isNotEmpty((Object)editFunctionDto.getFunctionParm())) {
            JSONArray jsonArray = JSON.parseArray((String)editFunctionDto.getFunctionParm());
            ArrayList<SysActFunctionParm> addList = new ArrayList<SysActFunctionParm>();
            ArrayList<SysActFunctionParm> updateList = new ArrayList<SysActFunctionParm>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                SysActFunctionParm sysActFunctionParm = new SysActFunctionParm();
                Long parmId = jsonArray.getJSONObject(i).getLong("id");
                if (HussarUtils.isNotEmpty((Object)parmId)) {
                    sysActFunctionParm.setId(parmId);
                    sysActFunctionParm.setParmName(jsonArray.getJSONObject(i).getString(PARM_NAME));
                    sysActFunctionParm.setParmKey(jsonArray.getJSONObject(i).getString(PARM_KEY));
                    sysActFunctionParm.setUpdateTime(currTime);
                    updateList.add(sysActFunctionParm);
                    continue;
                }
                sysActFunctionParm.setFunctionId(Long.valueOf(editFunctionDto.getId()));
                sysActFunctionParm.setParmName(jsonArray.getJSONObject(i).getString(PARM_NAME));
                sysActFunctionParm.setParmKey(jsonArray.getJSONObject(i).getString(PARM_KEY));
                sysActFunctionParm.setCreateTime(currTime);
                addList.add(sysActFunctionParm);
            }
            boolean insertResult = true;
            boolean updateResult = true;
            if (!addList.isEmpty()) {
                insertResult = this.sysActFunctionParmService.saveBatch(addList);
            }
            if (!updateList.isEmpty()) {
                updateResult = this.sysActFunctionParmService.updateBatchById(updateList);
            }
            if (!insertResult || !updateResult) {
                throw new BpmException(BpmExceptionCodeEnum.ERROR_UPDATE);
            }
        }
        if (HussarUtils.isNotEmpty((Object)editFunctionDto.getDelIds())) {
            List<String> delList = Arrays.asList(editFunctionDto.getDelIds().split(","));
            ArrayList<Long> newDelList = new ArrayList<Long>();
            for (int i = 0; i < delList.size(); ++i) {
                newDelList.add(Long.parseLong(delList.get(i)));
            }
            boolean delResult = this.sysActFunctionParmService.removeByIds(newDelList);
            if (!delResult) {
                throw new BpmException(BpmExceptionCodeEnum.ERROR_UPDATE);
            }
        }
        return ApiResponse.success((String)BpmExceptionCodeEnum.SUCCESS_UPDATE.getMessage());
    }

    public ApiResponse<IPage<SysActFunction>> queryFunctionList(Page page, String functionName) {
        if (HussarUtils.isNotEmpty((Object)functionName)) {
            functionName = functionName.replace("%", "\\%").replace("_", "\\_");
        }
        List<SysActFunction> list = this.sysActFunctionMapper.queryFunctionList(page, functionName);
        for (SysActFunction sysActFunction : list) {
            if (!HussarUtils.isEmpty((Object)sysActFunction.getFunctionType())) continue;
            sysActFunction.setFunctionType("local");
        }
        page.setRecords(list);
        return ApiResponse.success((Object)page);
    }

    public BpmResponseResult selectByName(Page page, String functionName) {
        if (functionName != null) {
            functionName = functionName.replace("%", "\\%").replace("_", "\\_");
        }
        List<SysActFunction> list = this.sysActFunctionMapper.queryFunctionList(page, functionName);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)page.setRecords(list));
        return InstallResult.getResult((String)FUNCTION_IMPORT_REPEAT_NAME, (String)"success", (JSONArray)jsonArray);
    }

    public ApiResponse<String> delete(Long functionId) {
        this.sysActFunctionParmService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActFunctionParm::getFunctionId, (Object)functionId));
        int removeNum = this.sysActFunctionMapper.deleteById(functionId);
        if (removeNum == 0) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_DELETE);
        }
        return ApiResponse.success((String)BpmExceptionCodeEnum.DELETE_SUCCESS.getMessage());
    }

    public ApiResponse<String> importFunction(MultipartFile file) {
        try {
            byte[] function = file.getBytes();
            String data = new String(function);
            Map map = (Map)JSON.parseObject((String)data, HashMap.class);
            if (!"lcdpBpmFunction".equals(map.get("export_type"))) {
                throw new BpmException(BpmExceptionCodeEnum.ERROR_IMPORT_FUNCTION_TYPE);
            }
            if (HussarUtils.isNotEmpty(map.get(FUNCTION))) {
                int i;
                JSONArray functions = (JSONArray)JSON.parseObject((String)String.valueOf(map.get(FUNCTION)), JSONArray.class);
                List functionList = JSONObject.parseArray((String)functions.toJSONString(), SysActFunction.class);
                Set functionNameSet = functionList.stream().map(SysActFunction::getFunctionName).collect(Collectors.toSet());
                Set functionBeanSet = functionList.stream().map(SysActFunction::getFunctionBean).collect(Collectors.toSet());
                List exist = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysActFunction::getFunctionName, functionNameSet)).or()).in(SysActFunction::getFunctionBean, functionBeanSet));
                Set existBean = exist.stream().map(SysActFunction::getFunctionBean).collect(Collectors.toSet());
                Set existName = exist.stream().map(SysActFunction::getFunctionName).collect(Collectors.toSet());
                int importFunctionNum = functionList.size();
                List functionParmList = new ArrayList();
                HashSet<Long> existFunctionId = new HashSet<Long>();
                if (HussarUtils.isNotEmpty(map.get(FUNCTION_PARM))) {
                    JSONArray functionParms = (JSONArray)JSON.parseObject((String)String.valueOf(map.get(FUNCTION_PARM)), JSONArray.class);
                    functionParmList = JSON.parseArray((String)functionParms.toJSONString(), SysActFunctionParm.class);
                }
                for (i = functionList.size() - 1; i >= 0; --i) {
                    if (!existBean.contains(((SysActFunction)functionList.get(i)).getFunctionBean()) && !existName.contains(((SysActFunction)functionList.get(i)).getFunctionName())) continue;
                    existFunctionId.add(((SysActFunction)functionList.get(i)).getId());
                    functionList.remove(i);
                }
                for (i = functionParmList.size() - 1; i >= 0; --i) {
                    if (!existFunctionId.contains(((SysActFunctionParm)functionParmList.get(i)).getFunctionId())) continue;
                    functionParmList.remove(i);
                }
                this.saveOrUpdateBatch(functionList);
                if (!functionParmList.isEmpty()) {
                    this.sysActFunctionParmService.saveOrUpdateBatch(functionParmList);
                }
                if (importFunctionNum != functionList.size()) {
                    throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_IMPORT.format(new Object[]{functionList.size(), importFunctionNum - functionList.size()}));
                }
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_IMPORT);
        }
        return ApiResponse.success((String)BpmExceptionCodeEnum.IMPORT_SUCCESS.getMessage());
    }

    public void exportFunction(String functionId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        List functionIds = Arrays.asList(functionId.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List functionList = this.sysActFunctionMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysActFunction::getId, functionIds));
        List functionParmIds = Arrays.asList(functionId.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List functionParmList = this.sysActFunctionParmService.list((Wrapper)new LambdaQueryWrapper().in(SysActFunctionParm::getFunctionId, functionParmIds));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(FUNCTION, functionList);
        data.put(FUNCTION_PARM, functionParmList);
        data.put("export_type", "lcdpBpmFunction");
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            outputStream.write(JSONObject.toJSONBytes(data, (SerializerFeature[])new SerializerFeature[0]));
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_EXPERT_FUNCTION);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public SysActFunction getFunctionByBeanId(String beanId) {
        return (SysActFunction)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysActFunction::getFunctionBean, (Object)beanId));
    }

    public List<FunctionDumpVo> dump(FunctionDumpDto functionDumpDto) {
        List longFunctionIds = functionDumpDto.getFunctionId().stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
        List functionList = this.sysActFunctionMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysActFunction::getId, longFunctionIds));
        List functionParmList = this.sysActFunctionParmService.list((Wrapper)new LambdaQueryWrapper().in(SysActFunctionParm::getFunctionId, longFunctionIds));
        Map<Long, List<SysActFunctionParm>> functionToParmMap = functionParmList.stream().collect(Collectors.groupingBy(SysActFunctionParm::getFunctionId));
        List<FunctionDumpVo> functionDumpVoList = functionList.stream().map(function -> {
            List parms = functionToParmMap.getOrDefault(function.getId(), Collections.emptyList());
            FunctionDumpVo functionDumpVo = new FunctionDumpVo();
            functionDumpVo.setFunctionInfo(function);
            functionDumpVo.setFunctionParmList(parms);
            return functionDumpVo;
        }).collect(Collectors.toList());
        return functionDumpVoList;
    }

    public List<FunctionLoadVo> load(List<FunctionLoadVo> functionDumpVos) {
        ArrayList<SysActFunction> functionList = new ArrayList<SysActFunction>();
        ArrayList functionParmList = new ArrayList();
        for (FunctionLoadVo functionLoadVo : functionDumpVos) {
            if (!HussarUtils.isEmpty((Object)functionLoadVo.getImportType())) continue;
            if (HussarUtils.isNotEmpty((Object)functionLoadVo.getFunctionDumpVo().getFunctionInfo())) {
                functionList.add(functionLoadVo.getFunctionDumpVo().getFunctionInfo());
            }
            if (!HussarUtils.isNotEmpty((Object)functionLoadVo.getFunctionDumpVo().getFunctionParmList())) continue;
            functionParmList.addAll(functionLoadVo.getFunctionDumpVo().getFunctionParmList());
        }
        if (HussarUtils.isNotEmpty(functionList)) {
            this.saveOrUpdateBatch(functionList);
        }
        if (HussarUtils.isNotEmpty(functionParmList)) {
            ((LambdaUpdateChainWrapper)this.sysActFunctionParmService.lambdaUpdate().in(SysActFunctionParm::getFunctionId, (Collection)functionParmList.stream().map(SysActFunctionParm::getFunctionId).collect(Collectors.toSet()))).remove();
            this.sysActFunctionParmService.saveBatch(functionParmList);
        }
        return functionDumpVos;
    }

    public List<FunctionLoadVo> preload(List<FunctionDumpVo> functionDumpVos) {
        ArrayList repeatFunctionNames = new ArrayList();
        ArrayList repeatBeanIds = new ArrayList();
        HashMap sysActFunctionMap = new HashMap();
        if (HussarUtils.isNotEmpty(functionDumpVos)) {
            List<SysActFunction> sysActFunctions = functionDumpVos.stream().map(FunctionDumpVo::getFunctionInfo).collect(Collectors.toList());
            ArrayList functionNames = new ArrayList();
            ArrayList beanIds = new ArrayList();
            sysActFunctions.forEach(e -> {
                functionNames.add(e.getFunctionName());
                beanIds.add(e.getFunctionBean());
            });
            List sysActFunctionList = this.sysActFunctionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysActFunction::getFunctionName, functionNames)).or()).in(SysActFunction::getFunctionBean, beanIds));
            sysActFunctionList.forEach(e -> {
                repeatFunctionNames.add(e.getFunctionName());
                repeatBeanIds.add(e.getFunctionBean());
                sysActFunctionMap.put(e.getId(), e);
            });
        }
        ArrayList<FunctionLoadVo> functionLoadVoList = new ArrayList<FunctionLoadVo>();
        for (FunctionDumpVo functionDumpVo : functionDumpVos) {
            boolean repeatBeanId;
            SysActFunction sysActFunction = functionDumpVo.getFunctionInfo();
            FunctionLoadVo functionLoadVo = new FunctionLoadVo(sysActFunction.getId(), sysActFunction.getFunctionName(), sysActFunction.getFunctionType(), sysActFunction.getRequestMethod(), sysActFunction.getFunctionBean());
            boolean repeatFunctionName = repeatFunctionNames.contains(sysActFunction.getFunctionName()) && (sysActFunctionMap.get(sysActFunction.getId()) == null || !sysActFunction.getFunctionName().equals(((SysActFunction)sysActFunctionMap.get(sysActFunction.getId())).getFunctionName()));
            boolean bl = repeatBeanId = repeatBeanIds.contains(sysActFunction.getFunctionBean()) && (sysActFunctionMap.get(sysActFunction.getId()) == null || !sysActFunction.getFunctionBean().equals(((SysActFunction)sysActFunctionMap.get(sysActFunction.getId())).getFunctionBean()));
            if (repeatFunctionName) {
                if (repeatBeanId) {
                    functionLoadVo.setImportType(FUNCTION_IMPORT_REPEAT_NAME_AND_BEAN);
                } else {
                    functionLoadVo.setImportType(FUNCTION_IMPORT_REPEAT_NAME);
                }
            } else if (repeatBeanId) {
                functionLoadVo.setImportType(FUNCTION_IMPORT_REPEAT_BEAN);
            }
            functionLoadVoList.add(functionLoadVo);
        }
        return functionLoadVoList;
    }
}

