/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ExtendDataDto;
import com.jxdinfo.hussar.workflow.engine.bpm.extenddata.service.ExtendDataService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.task.TaskInfo;

public class RevokeAddHistoryTaskCmd
implements Command<Void> {
    protected String comment;
    protected Date startTime;
    protected String userId;
    protected Date endTime;
    protected TaskEntity task;
    protected DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getSpringContext().getBean(DataPushService.class);
    private ExtendDataService extendDataService = (ExtendDataService)BpmSpringContextHolder.getBean(ExtendDataService.class);
    private ExecutionEntity executionEntity;
    private String parentTaskId;
    private String owner;
    private Map<String, Object> paramMap;

    public RevokeAddHistoryTaskCmd(ExecutionEntity executionEntity, String comment, Date startTime, String userId) {
        this.comment = comment;
        this.startTime = startTime;
        this.userId = userId;
        this.executionEntity = executionEntity;
    }

    public RevokeAddHistoryTaskCmd(ExecutionEntity executionEntity, String comment, Map<String, Object> paramMap, Date startTime, String userId) {
        this.comment = comment;
        this.startTime = startTime;
        this.userId = userId;
        this.executionEntity = executionEntity;
        this.paramMap = paramMap;
    }

    public RevokeAddHistoryTaskCmd(ExecutionEntity executionEntity, String comment, Date startTime, Date endTime, String userId, String parentTaskId, String owner) {
        this.comment = comment;
        this.startTime = startTime;
        this.endTime = endTime;
        this.userId = userId;
        this.executionEntity = executionEntity;
        this.parentTaskId = parentTaskId;
        this.owner = owner;
    }

    public Void execute(CommandContext commandContext) {
        ExecutionEntity execution;
        TaskEntity task = this.getTask();
        if (this.endTime == null) {
            this.endTime = task.getCreateTime();
        }
        if (BpmAttribute.getTaskSourceFlag((ActivityExecution)(execution = task.getExecution())) == null) {
            execution.addTempVariable("taskSourceFlag", (Object)"revoke");
        }
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        IdGenerator idGenerator = pec.getIdGenerator();
        TaskEntity taskEntity = new TaskEntity();
        taskEntity.setNewTask(true);
        taskEntity.copyTaskPropertyAsHistory((TaskInfo)task);
        taskEntity.setTaskDefinition(task.getTaskDefinition());
        taskEntity.setCreateTime(this.startTime);
        taskEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        taskEntity.setTaskDefinitionKey(task.getTaskDefinitionKey());
        taskEntity.setProcessInstanceId(execution.getProcessInstanceId());
        taskEntity.setExecutionId(this.executionEntity.getId());
        taskEntity.setName(task.getName());
        String taskId = idGenerator.getNextId();
        taskEntity.setId(taskId);
        taskEntity.setExecution(this.executionEntity);
        taskEntity.setFormKey(task.getFormKey());
        taskEntity.setParentTaskId(this.parentTaskId);
        taskEntity.setOwner(this.owner);
        taskEntity.setSendUser(this.userId);
        taskEntity.setCompleteType("revoke");
        taskEntity.setTaskSourceFlag("revoke");
        taskEntity.setTodoConfiguration(task.getTodoConfiguration());
        taskEntity.setSubProcessKey(task.getSubProcessKey());
        taskEntity.setFormId(task.getFormId());
        taskEntity.setCycleCount(task.getCycleCount());
        taskEntity.setProcessCycleCount(task.getProcessCycleCount());
        taskEntity.insert(taskEntity.getExecution());
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)taskEntity));
        }
        taskEntity.setAssignee(this.userId);
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(this.userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(taskEntity.getId());
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        if (HussarUtils.isNotEmpty(this.paramMap) && this.extendDataService != null) {
            ExtendDataDto extendDataDto = new ExtendDataDto();
            extendDataDto.setTaskId(taskEntity.getId());
            extendDataDto.setExtendData(this.paramMap);
            this.extendDataService.addExtendData(extendDataDto);
        }
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(taskEntity.getId());
        dataPush.setTaskDefinitionName(taskEntity.getName());
        dataPush.setUserId(this.userId);
        dataPush.setBusinessKey(taskEntity.getProcessInstance().getBusinessKey());
        dataPush.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
        dataPush.setProcessKey(taskEntity.getProcessDefinitionId().split(":")[0]);
        dataPush.setSendUser(this.userId);
        dataPush.setStartDate(this.startTime);
        dataPush.setEndDate(this.endTime);
        dataPush.setUrl(taskEntity.getFormKey());
        dataPush.setDescription(task.getTodoConfiguration());
        dataPush.setProcessName(execution.getProcessDefinitionName());
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            dataPush.setComment(this.comment);
        }
        dataPush.setProcessInsId(taskEntity.getProcessInstanceId());
        dataPush.setFormId(taskEntity.getFormId());
        dataPush.setTaskSourceFlag("revoke");
        this.dataPushService.revokeDataPush(dataPush);
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
        Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "RevokeHistory", false, this.endTime);
        return null;
    }

    protected TaskEntity getTask() {
        List taskEntities = this.executionEntity.getTasks();
        List entityList = this.executionEntity.getExecutions();
        if (entityList != null && !entityList.isEmpty()) {
            this.executionEntity = (ExecutionEntity)entityList.get(0);
            entityList = this.executionEntity.getExecutions();
            if (entityList != null && !entityList.isEmpty()) {
                taskEntities = ((ExecutionEntity)this.executionEntity.getExecutions().get(0)).getTasks();
            }
            this.executionEntity = this.executionEntity.createExecution();
            this.executionEntity.setScope(false);
            this.executionEntity.setConcurrent(true);
            this.executionEntity.setActive(false);
        }
        TaskEntity task = (TaskEntity)taskEntities.get(0);
        for (int i = 1; i < taskEntities.size(); ++i) {
            if (!((TaskEntity)taskEntities.get(i)).getCreateTime().after(task.getCreateTime())) continue;
            task = (TaskEntity)taskEntities.get(i);
        }
        if (this.executionEntity.getSubProcessKey() != null && task.getSubProcessKey() == null) {
            task.setSubProcessKey(this.executionEntity.getSubProcessKey());
        }
        if (this.executionEntity.getCycleCount() != null && task.getCycleCount() == null) {
            task.setCycleCount(this.executionEntity.getCycleCount());
        }
        if (this.executionEntity.getProcessCycleCount() != null && task.getProcessCycleCount() == null) {
            task.setProcessCycleCount(this.executionEntity.getProcessCycleCount());
        }
        this.task = task;
        return task;
    }
}

