/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActRuIdentitylinkMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuIdentitylink;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.vo.TaskCommentVO;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowOrganProcessUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.InstanceEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CountersignNodesDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ExtendDataDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessInstAllQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessQueryByStarterDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.UpdateProcessSecurityLevelDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ProcessNode;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessEndCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.StartAndCompleteCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.StartProcessInstanceCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.StartProcessReturnValueCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.vo.ActInstVo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.vo.HistoricProcessInstanceVo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.vo.ProcessInstVo;
import com.jxdinfo.hussar.workflow.engine.bpm.extenddata.service.ExtendDataService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActHandleAuthMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActHandleAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.organ.dto.OrganProcessModelQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.organ.vo.OrganProcessModelQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.BusinessInfoDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstEndDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessStartDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessStatusCheckDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartAndCompleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.enums.BpmNodeTypeEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.manage.bpm.flowchart.FlowChartCommonDto;
import com.jxdinfo.hussar.workflow.manage.engine.DefinitionEngineService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.PropertyNotFoundException;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.activiti.engine.task.TaskStateType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
@HussarTokenDs
public class InstanceEngineServiceImpl
implements IInstanceEngineService,
InitializingBean {
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Resource
    private ProcessEngine processEngine;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    @Resource
    private BpmActRuIdentitylinkMapper bpmActRuIdentitylinkMapper;
    @Resource
    private ITaskEngineService taskEngineService;
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Resource
    private IdentityService identityService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ISysActCcTaskService iSysActCcTaskService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Resource
    private InstanceEngineMapper instanceEngineMapper;
    @Resource
    private SysActHandleAuthMapper sysActHandleAuthMapper;
    @Autowired
    private ExtendDataService extendDataService;
    private static final Map<String, String> TASK_SOURCE_FLAG = new HashMap<String, String>();
    public static final String SUB_PROCINST_NAME = "\u5b9e\u4f8b";
    private static final String FINISH_STATE = "finish";
    private static final String NOW_STATE = "complete";
    public static final String EXTERNAL_USER = "8934723032766293738";
    private static final Pattern BPM_NEXT_NODE_REGEX = Pattern.compile("bpm_next_node [!=]= '([^'])*'");
    private static final String PLAN_ = "plan_";
    private static final Pattern REGEX = Pattern.compile("\\$\\{([^}])*\\}");
    private static final List<String> CHECK_VARIABLE_NODE_TYPE_LIST = new ArrayList<String>();

    public void afterPropertiesSet() {
        TASK_SOURCE_FLAG.put(NOW_STATE, "\u529e\u7406");
        TASK_SOURCE_FLAG.put("revoke", "\u64a4\u56de");
        TASK_SOURCE_FLAG.put("reject_revoke", "\u64a4\u56de");
        TASK_SOURCE_FLAG.put("skip", "\u8df3\u8fc7");
        TASK_SOURCE_FLAG.put("reject", "\u9a73\u56de");
        TASK_SOURCE_FLAG.put("freejump", "\u81ea\u7531\u8df3\u8f6c");
        TASK_SOURCE_FLAG.put("endProcess", "\u7ec8\u6b62");
        TASK_SOURCE_FLAG.put("complete_leap", "\u529e\u7406");
        TASK_SOURCE_FLAG.put("revokeProcess", "\u6d41\u7a0b\u64a4\u529e");
        TASK_SOURCE_FLAG.put("transfer", "\u8f6c\u529e");
        TASK_SOURCE_FLAG.put("multiTransfer", "\u79fb\u4ea4");
        TASK_SOURCE_FLAG.put("assist_complete", "\u529e\u7406\u534f\u529e");
        TASK_SOURCE_FLAG.put("assist_add", "\u53d1\u8d77\u534f\u529e");
        TASK_SOURCE_FLAG.put("assist", "\u53d1\u8d77\u534f\u529e");
        TASK_SOURCE_FLAG.put("ccTask", "\u4f20\u9605");
        TASK_SOURCE_FLAG.put("overtime_auto_complete", "\u8d85\u65f6\u81ea\u52a8\u529e\u7406");
        TASK_SOURCE_FLAG.put("overtime_auto_reject", "\u8d85\u65f6\u81ea\u52a8\u9a73\u56de");
        TASK_SOURCE_FLAG.put("addAssignee", "\u52a0\u7b7e");
        TASK_SOURCE_FLAG.put("delAssignee", "\u51cf\u7b7e");
        TASK_SOURCE_FLAG.put("CcTask", "\u4f20\u9605");
        if (this.bpmConstantProperties != null && HussarUtils.isNotEmpty((Object)this.bpmConstantProperties.getTaskSourceFlag())) {
            TASK_SOURCE_FLAG.putAll(this.bpmConstantProperties.getTaskSourceFlag());
        }
    }

    private static String getStrTaskSourceFlag(String taskSourceFlag) {
        if (taskSourceFlag == null) {
            return "";
        }
        String s = TASK_SOURCE_FLAG.get(TaskSourceFlag.mappingToSimple((String)taskSourceFlag));
        return s == null ? "" : s;
    }

    public BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessId, Map<String, Object> variables) {
        ProcessInstance processInstance;
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.BUSINESS_ALREADY_START_PROCESS.getMessage(), null);
        }
        boolean flag = this.validateAuthority(userId, processDefinitionId, businessId, variables = variables == null ? new HashMap<String, Object>() : new HashMap<String, Object>(variables));
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NO_AUTHORITY_START_PROCESS.getMessage(), null);
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCreateStart");
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("businessId", businessId);
        CommonCodeUtil.triggerEventHandleClass(map);
        variables.put("startUser", userId);
        if (HussarUtils.isNotEmpty((Object)variables.get("isEmulation")) && "1".equals(String.valueOf(variables.get("isEmulation")))) {
            variables.remove("isEmulation");
            processInstance = this.startProcessInstance(userId, businessId, processDefinitionId, variables, "1");
        } else {
            processInstance = this.startProcessInstance(userId, businessId, processDefinitionId, variables);
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new StartProcessReturnValueCmd(processInstance.getProcessInstanceId(), userId, variables));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult startProcessInstanceByKey(String processKey, String userId, String businessId, String version, Map<String, Object> variables) {
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.BUSINESS_ALREADY_START_PROCESS.getMessage(), null);
        }
        variables = variables == null ? new HashMap<String, Object>() : new HashMap<String, Object>(variables);
        OrganProcessModelQueryDto organProcessModelQueryDto = new OrganProcessModelQueryDto(processKey, userId, null);
        organProcessModelQueryDto.setVersion(version);
        OrganProcessModelQueryVo organProcessModelQueryVo = WorkflowOrganProcessUtil.getStartOrganProcessModelMessage(organProcessModelQueryDto);
        String processDefinitionId = organProcessModelQueryVo.getProcessDefId();
        variables.put("BPM_WORKFLOW_PROCESS_ORGAN_ID", organProcessModelQueryVo.getOrganId());
        boolean flag = this.validateAuthority(userId, processDefinitionId, businessId, variables);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NO_AUTHORITY_START_PROCESS.getMessage(), null);
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCreateStart");
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("businessId", businessId);
        CommonCodeUtil.triggerEventHandleClass(map);
        ProcessInstance processInstance = this.startProcessInstance(userId, businessId, processDefinitionId, variables);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new StartProcessReturnValueCmd(processInstance.getProcessInstanceId(), userId, variables));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult startProcessInstanceByKey(StartProcessDto startProcessDto) {
        String processKey = startProcessDto.getProcessKey();
        String userId = startProcessDto.getUserId();
        String businessId = startProcessDto.getBusinessId();
        HashMap<String, String> variables = startProcessDto.getVariables() == null ? new HashMap<String, String>() : new HashMap(startProcessDto.getVariables());
        String dataDetail = startProcessDto.getDataDetail();
        String processTitle = startProcessDto.getProcessTitle();
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.BUSINESS_ALREADY_START_PROCESS.getMessage(), null);
        }
        HashMap<String, Object> newVariables = new HashMap<String, Object>();
        if (variables != null) {
            newVariables.putAll(variables);
        }
        OrganProcessModelQueryDto organProcessModelQueryDto = new OrganProcessModelQueryDto(processKey, userId, null);
        OrganProcessModelQueryVo organProcessModelQueryVo = WorkflowOrganProcessUtil.getStartOrganProcessModelMessage(organProcessModelQueryDto);
        String processDefinitionId = organProcessModelQueryVo.getProcessDefId();
        variables.put("BPM_WORKFLOW_PROCESS_ORGAN_ID", organProcessModelQueryVo.getOrganId());
        if (startProcessDto.getExternal() == null || !startProcessDto.getExternal().booleanValue()) {
            boolean flag = this.validateAuthority(userId, processDefinitionId, businessId, newVariables);
            if (!flag) {
                return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NO_AUTHORITY_START_PROCESS.getMessage(), null);
            }
        } else {
            userId = EXTERNAL_USER;
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCreateStart");
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("businessId", businessId);
        CommonCodeUtil.triggerEventHandleClass(map);
        newVariables.put("startUser", userId);
        ProcessInstance processInstance = this.startProcessInstance(userId, businessId, processDefinitionId, newVariables, processTitle, dataDetail);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new StartProcessReturnValueCmd(processInstance.getProcessInstanceId(), userId, newVariables));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult startAndComplete(StartAndCompleteDto startAndCompleteDto) {
        String comment = startAndCompleteDto.getComment();
        Map paramMap = startAndCompleteDto.getParamMap();
        String processKey = startAndCompleteDto.getProcessKey();
        String userId = startAndCompleteDto.getUserId();
        String businessId = startAndCompleteDto.getBusinessId();
        HashMap<String, String> variables = startAndCompleteDto.getVariables() == null ? new HashMap<String, String>() : new HashMap(startAndCompleteDto.getVariables());
        String dataDetail = startAndCompleteDto.getDataDetail();
        String processTitle = startAndCompleteDto.getProcessTitle();
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.BUSINESS_ALREADY_START_PROCESS.getMessage(), null);
        }
        HashMap<String, Object> newVariables = new HashMap<String, Object>();
        if (variables != null) {
            newVariables.putAll(variables);
        }
        if (HussarUtils.isNotEmpty((Object)startAndCompleteDto.getAppointAssignee())) {
            newVariables.put("appoint_assignee", startAndCompleteDto.getAppointAssignee());
        }
        OrganProcessModelQueryDto organProcessModelQueryDto = new OrganProcessModelQueryDto(processKey, userId, null);
        OrganProcessModelQueryVo organProcessModelQueryVo = WorkflowOrganProcessUtil.getStartOrganProcessModelMessage(organProcessModelQueryDto);
        String processDefinitionId = organProcessModelQueryVo.getProcessDefId();
        variables.put("BPM_WORKFLOW_PROCESS_ORGAN_ID", organProcessModelQueryVo.getOrganId());
        if (startAndCompleteDto.getExternal() == null || !startAndCompleteDto.getExternal().booleanValue()) {
            boolean flag = this.validateAuthority(userId, processDefinitionId, businessId, newVariables);
            if (!flag) {
                return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NO_AUTHORITY_START_PROCESS.getMessage(), null);
            }
        } else {
            userId = EXTERNAL_USER;
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCreateStart");
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("businessId", businessId);
        CommonCodeUtil.triggerEventHandleClass(map);
        newVariables.put("startUser", userId);
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getManagementService().executeCommand(new StartAndCompleteCmd(processDefinitionId, businessId, comment, userId, processTitle, dataDetail, newVariables, paramMap).addSendUser(userId).addAttribute(newVariables).addExecutionAttribute(newVariables, "main_process_start").addAttribute(newVariables, "is_start_process_appoint_assignee").addAttribute(newVariables, "BPM_WORKFLOW_PROCESS_ORGAN_ID"));
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand(commandContext -> {
            commandContext.addAttribute("no_data_push_handle_flag", (Object)"true");
            JSONArray jsonArray = new StartProcessReturnValueCmd(processInstance.getProcessInstanceId(), null, null).execute(commandContext);
            return jsonArray;
        });
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult startProcessInstance(ProcessStartDto processStartDto) {
        String processKey = processStartDto.getProcessKey();
        String userId = processStartDto.getUserId();
        String businessId = processStartDto.getBusinessId();
        String version = processStartDto.getVersion();
        HashMap<String, Object> variables = processStartDto.getVariables();
        if (HussarUtils.isEmpty((Object)variables)) {
            variables = (Map)JSONObject.parseObject((String)processStartDto.getVariablesJson(), Map.class);
        }
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.BUSINESS_ALREADY_START_PROCESS.getMessage(), null);
        }
        variables = variables == null ? new HashMap<String, Object>() : new HashMap(variables);
        OrganProcessModelQueryDto organProcessModelQueryDto = new OrganProcessModelQueryDto(processKey, userId, processStartDto.getOrganId());
        organProcessModelQueryDto.setVersion(version);
        OrganProcessModelQueryVo organProcessModelQueryVo = WorkflowOrganProcessUtil.getStartOrganProcessModelMessage(organProcessModelQueryDto);
        String processDefinitionId = organProcessModelQueryVo.getProcessDefId();
        variables.put("BPM_WORKFLOW_PROCESS_ORGAN_ID", organProcessModelQueryVo.getOrganId());
        boolean flag = this.validateAuthority(userId, processDefinitionId, businessId, variables);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NO_AUTHORITY_START_PROCESS.getMessage(), null);
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCreateStart");
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("businessId", businessId);
        CommonCodeUtil.triggerEventHandleClass(map);
        ProcessInstance processInstance = this.startProcessInstance(userId, businessId, processDefinitionId, variables);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new StartProcessReturnValueCmd(processInstance.getProcessInstanceId(), userId, variables));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult updateBusinessInfo(BusinessInfoDto businessInfoDto) {
        String processTitle = businessInfoDto.getProcessTitle();
        String dataDetail = businessInfoDto.getDataDetail();
        String procInstId = businessInfoDto.getProcessInstId();
        String businessId = businessInfoDto.getBusinessId();
        boolean updateFlag = false;
        if (HussarUtils.isNotEmpty((Object)procInstId)) {
            updateFlag = this.instanceEngineMapper.updateBusinessInfoByInstId(procInstId, processTitle, dataDetail);
        } else if (HussarUtils.isNotEmpty((Object)businessId)) {
            updateFlag = this.instanceEngineMapper.updateBusinessInfoByBusinessKey(businessId, processTitle, dataDetail);
        } else {
            return InstallResult.fail((String)"\u6d41\u7a0b\u5b9e\u4f8bID\u548c\u4e1a\u52a1\u4e3b\u952e\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a");
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(procInstId).singleResult();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(historicProcessInstance.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(businessId);
            dataPush.setProcessInsId(procInstId);
            dataPush.setProcessTitle(processTitle);
            dataPush.setDataDetail(dataDetail);
            this.dataPushService.updateStartProcess(dataPush);
            this.dataPushService.updateBusinessInfo(dataPush);
        }
        if (updateFlag) {
            return InstallResult.success((String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
        }
        return InstallResult.fail((String)BpmExceptionCodeEnum.ERROR_UPDATE.getMessage());
    }

    private ProcessInstance startProcessInstance(String userId, String businessId, String processDefinitionId, Map<String, Object> newVariables) {
        return this.startProcessInstance(userId, businessId, processDefinitionId, newVariables, null, null);
    }

    private ProcessInstance startProcessInstance(String userId, String businessId, String processDefinitionId, Map<String, Object> newVariables, String isEmulation) {
        return this.startProcessInstance(userId, businessId, processDefinitionId, newVariables, null, null, isEmulation);
    }

    private ProcessInstance startProcessInstance(String userId, String businessId, String processDefinitionId, Map<String, Object> newVariables, String processTitle, String dataDetail) {
        return (ProcessInstance)this.processEngine.getManagementService().executeCommand(new StartProcessInstanceCmd(null, processDefinitionId, businessId, newVariables, processTitle, dataDetail).addSendUser(userId).addAttribute(newVariables).addExecutionAttribute(newVariables, "main_process_start").addAttribute(newVariables, "is_start_process_appoint_assignee").addAttribute(newVariables, "BPM_WORKFLOW_PROCESS_ORGAN_ID"));
    }

    private ProcessInstance startProcessInstance(String userId, String businessId, String processDefinitionId, Map<String, Object> newVariables, String processTitle, String dataDetail, String isEmulation) {
        return (ProcessInstance)this.processEngine.getManagementService().executeCommand(new StartProcessInstanceCmd(null, processDefinitionId, businessId, isEmulation, newVariables, processTitle, dataDetail).addSendUser(userId).addAttribute(newVariables).addExecutionAttribute(newVariables, "main_process_start").addAttribute(newVariables, "is_start_process_appoint_assignee").addAttribute(newVariables, "BPM_WORKFLOW_PROCESS_ORGAN_ID"));
    }

    public BpmResponseResult checkProcessInstByBusinessId(String businessId) {
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.BUSINESS_ALREADY_START_PROCESS.getMessage(), null);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult checkProcessStatus(ProcessStatusCheckDto processStatusCheckDto) {
        List tasks = Lists.newArrayList();
        if (HussarUtils.isNotEmpty((Object)processStatusCheckDto.getProcessInsId())) {
            tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processStatusCheckDto.getProcessInsId())).list();
        } else if (HussarUtils.isNotEmpty((Object)processStatusCheckDto.getBusinessId())) {
            tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(processStatusCheckDto.getBusinessId())).list();
        }
        JSONArray jsonArray = new JSONArray();
        if (HussarUtils.isNotEmpty((Object)tasks)) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                jsonArray.add((Object)"1");
                return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
            }
            jsonArray.add((Object)"2");
            return InstallResult.getResult((String)"1", (String)BpmExceptionCodeEnum.BUSINESS_ALREADY_START_PROCESS.getMessage(), (JSONArray)jsonArray);
        }
        if (HussarUtils.isNotEmpty((Object)processStatusCheckDto.getProcessInsId())) {
            List instanceList = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processStatusCheckDto.getProcessInsId()).list();
            if (HussarUtils.isNotEmpty((Object)instanceList)) {
                jsonArray.add((Object)"3");
                return InstallResult.getResult((String)"1", (String)BpmExceptionCodeEnum.BUSINESS_ALREADY_START_PROCESS.getMessage(), (JSONArray)jsonArray);
            }
        } else if (HussarUtils.isNotEmpty((Object)processStatusCheckDto.getBusinessId()) && this.instanceEngineMapper.getProcessInstCountByBusinessId(processStatusCheckDto.getBusinessId()) > 0L) {
            jsonArray.add((Object)"3");
            return InstallResult.getResult((String)"1", (String)BpmExceptionCodeEnum.BUSINESS_ALREADY_START_PROCESS.getMessage(), (JSONArray)jsonArray);
        }
        jsonArray.add((Object)"0");
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public ApiResponse<JSONObject> validateEditAuthority(String businessId) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        JSONObject object = new JSONObject();
        if (tasks != null && !tasks.isEmpty()) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                object.put("processKey", (Object)task.getProcessDefinitionId().split(":")[0]);
                object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                object.put("businessId", (Object)businessId);
                object.put("taskId", (Object)task.getId());
                return ApiResponse.success((Object)object);
            }
            return ApiResponse.fail((String)BpmExceptionCodeEnum.BUSINESS_ALREADY_START_PROCESS.getMessage());
        }
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return ApiResponse.fail((String)BpmExceptionCodeEnum.PROCESS_END.getMessage());
        }
        return ApiResponse.success((Object)object);
    }

    public BpmResponseResult validateDeleteByBusinessId(String businessId) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        JSONArray jsonArray = new JSONArray();
        if (tasks != null && !tasks.isEmpty()) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                jsonArray.add((Object)"1");
                return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
            }
            jsonArray.add((Object)"2");
            return InstallResult.getResult((String)"1", (String)BpmExceptionCodeEnum.BUSINESS_ALREADY_START_PROCESS.getMessage(), (JSONArray)jsonArray);
        }
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            jsonArray.add((Object)"2");
            return InstallResult.getResult((String)"1", (String)BpmExceptionCodeEnum.BUSINESS_ALREADY_START_PROCESS.getMessage(), (JSONArray)jsonArray);
        }
        jsonArray.add((Object)"0");
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryAllCommentByBusinessId(String businessId) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL.getMessage(), null);
        }
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (instance == null) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_NOT_START.getMessage(), null);
        }
        String processInsId = instance.getId();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().finished().asc()).list();
        return this.getResult(hisTaskList, true, true);
    }

    private boolean validateAuthority(String userId, String processDefinitionId, String businessId, Map<String, Object> variables) {
        boolean flag;
        ArrayList<String> firstNodeIds = new ArrayList<String>();
        String sql = AnalyticalModelUtil.queryFirstNodeAssigneeConfig(userId, processDefinitionId, businessId, new HashMap<String, Object>(variables), firstNodeIds);
        if (HussarUtils.isEmpty((Object)sql)) {
            ArrayList<String> users = new ArrayList<String>();
            users.add(userId);
            HashMap<String, ArrayList<String>> appointAssignee = new HashMap<String, ArrayList<String>>();
            appointAssignee.put(!firstNodeIds.isEmpty() ? (String)firstNodeIds.get(0) : "static_appoint_assignee", users);
            variables.putIfAbsent("appoint_assignee", appointAssignee);
            return true;
        }
        String processDefinitionKey = processDefinitionId.split(":")[0];
        HashMap<String, String> processInfo = new HashMap<String, String>();
        processInfo.put("workflowStarterUserId", userId);
        processInfo.put("workflowProcessDefinitionId", processDefinitionId);
        processInfo.put("workflowProcessKey", processDefinitionId.split(":")[0]);
        processInfo.put("workflowBusinessId", businessId);
        ArrayList<String> users = this.iAssigneeChooseService.getCandidateUser(sql, processDefinitionKey, (Integer)variables.get("security_level"), processInfo);
        boolean isStartProcessAppointAssignee = false;
        if (users == null) {
            users = new ArrayList<String>();
        }
        if (!users.isEmpty()) {
            flag = users.contains(userId);
        } else {
            users.add(userId);
            isStartProcessAppointAssignee = true;
            flag = true;
        }
        if (!variables.containsKey("appoint_assignee")) {
            HashMap<String, ArrayList<String>> appointAssignee = new HashMap<String, ArrayList<String>>();
            appointAssignee.put(!firstNodeIds.isEmpty() ? (String)firstNodeIds.get(0) : "static_appoint_assignee", users);
            variables.put("appoint_assignee", appointAssignee);
            variables.put("is_start_process_appoint_assignee", isStartProcessAppointAssignee);
        }
        return flag;
    }

    public BpmResponseResult suspendProcessInstanceById(String processInsId) {
        this.runtimeService.suspendProcessInstanceById(processInsId);
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(processInstance.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(processInstance.getBusinessKey());
            dataPush.setProcessKey(processInstance.getProcessDefinitionKey());
            dataPush.setProcessDefinitionId(processInstance.getProcessDefinitionId());
            dataPush.setProcessState("suspendProcess");
            dataPush.setProcessInsId(processInsId);
            dataPush.setProcessStartTime(processInstance.getStartTime());
            dataPush.setStartUserId(processInstance.getStartUserId());
            dataPush.setStartOrganId(processInstance.getOrganId());
            dataPush.setDueDate(processInstance.getDueDate());
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult suspendProcessInstanceByBusinessId(String businessId) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (HussarUtils.isEmpty((Object)processInstance)) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_NOT_START.getMessage(), null);
        }
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "suspendEnd");
        map.put("processInsId", processInstance.getId());
        map.put("processDefinitionId", processInstance.getProcessDefinitionId());
        map.put("processDefinitionName", processInstance.getProcessDefinitionName());
        map.put("businessId", processInstance.getBusinessKey());
        map.put("starter", processInstance.getStartUserId());
        map.put("startTime", processInstance.getStartTime());
        CommonCodeUtil.triggerEventHandleClass(map);
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(processInstance.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(processInstance.getBusinessKey());
            dataPush.setProcessKey(processInstance.getProcessDefinitionKey());
            dataPush.setProcessState("suspendProcess");
            dataPush.setProcessDefinitionId(processInstance.getProcessDefinitionId());
            dataPush.setProcessInsId(processInstance.getId());
            dataPush.setProcessStartTime(processInstance.getStartTime());
            dataPush.setStartUserId(processInstance.getStartUserId());
            dataPush.setStartOrganId(processInstance.getOrganId());
            dataPush.setDueDate(processInstance.getDueDate());
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult activateProcessInstanceById(String processInsId) {
        this.runtimeService.activateProcessInstanceById(processInsId);
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(processInstance.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(processInstance.getBusinessKey());
            dataPush.setProcessKey(processInstance.getProcessDefinitionKey());
            dataPush.setProcessDefinitionId(processInstance.getProcessDefinitionId());
            dataPush.setProcessState("activateProcess");
            dataPush.setProcessInsId(processInsId);
            dataPush.setProcessStartTime(processInstance.getStartTime());
            dataPush.setStartUserId(processInstance.getStartUserId());
            dataPush.setStartOrganId(processInstance.getOrganId());
            dataPush.setDueDate(processInstance.getDueDate());
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult activateProcessInstanceByBusinessId(String businessId) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (HussarUtils.isEmpty((Object)processInstance)) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_NOT_START.getMessage(), null);
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "activateEnd");
        map.put("processInsId", processInstance.getId());
        map.put("processDefinitionId", processInstance.getProcessDefinitionId());
        map.put("processDefinitionName", processInstance.getProcessDefinitionName());
        map.put("businessId", processInstance.getBusinessKey());
        map.put("starter", processInstance.getStartUserId());
        map.put("startTime", processInstance.getStartTime());
        CommonCodeUtil.triggerEventHandleClass(map);
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(processInstance.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(processInstance.getBusinessKey());
            dataPush.setProcessKey(processInstance.getProcessDefinitionKey());
            dataPush.setProcessState("activateProcess");
            dataPush.setProcessDefinitionId(processInstance.getProcessDefinitionId());
            dataPush.setProcessInsId(processInstance.getId());
            dataPush.setProcessStartTime(processInstance.getStartTime());
            dataPush.setStartUserId(processInstance.getStartUserId());
            dataPush.setStartOrganId(processInstance.getOrganId());
            dataPush.setDueDate(processInstance.getDueDate());
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstance(String processInsId, String reason) {
        List<Long> procIdList = new ArrayList<Long>();
        procIdList.add(Long.valueOf(processInsId));
        ArrayList<Long> allProcId = new ArrayList<Long>();
        do {
            allProcId.addAll(procIdList);
        } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
        List stringProcIds = allProcId.stream().map(s -> s.toString()).collect(Collectors.toList());
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(stringProcIds)).list();
        List emulationProcess = historicProcessInstances.stream().filter(e -> "1".equals(e.getIsEmulation())).collect(Collectors.toList());
        List emulationProcessInsIds = emulationProcess.stream().map(HistoricProcessInstance::getId).collect(Collectors.toList());
        List emulationBusinessKey = emulationProcess.stream().map(HistoricProcessInstance::getBusinessKey).collect(Collectors.toList());
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(stringProcIds)).list();
        StringBuilder taskIds = new StringBuilder();
        for (Task task : tasks) {
            if (!HussarUtils.isNotEmpty((Object)task.getDueDate())) continue;
            taskIds.append(",").append(task.getId());
        }
        if (HussarUtils.isNotEmpty((Object)taskIds.toString())) {
            this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
        }
        this.runtimeService.deleteProcessInstance(processInsId, reason);
        this.historyService.deleteHistoricProcessInstance(processInsId);
        HashMap<String, String> businessKeyMap = new HashMap<String, String>();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            String businessIds = (String)businessKeyMap.get(historicProcessInstance.getProcessDefinitionId());
            businessIds = businessIds == null ? historicProcessInstance.getBusinessKey() : businessIds + "," + historicProcessInstance.getBusinessKey();
            businessKeyMap.put(historicProcessInstance.getProcessDefinitionId(), businessIds);
            processDefinitionIdList.add(historicProcessInstance.getProcessDefinitionId());
        }
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessMap(businessKeyMap);
            dataPush.setComment(reason);
            dataPush.setProcessInsId(StringUtils.join((Object[])stringProcIds.toArray(), (String)","));
            dataPush.setProcessState("deleteProcess");
            dataPush.setProcessInsId(StringUtils.join(stringProcIds, (String)","));
            dataPush.setEmulationBusinessKey(emulationBusinessKey);
            dataPush.setEmulationProcessInsIds(emulationProcessInsIds);
            this.dataPushService.deleteDataPush(dataPush);
            this.dataPushService.changeProcessStateDataPush(dataPush);
            DataPush dataPushTemp = new DataPush();
            dataPushTemp.setProcessInsId(processInsId);
            this.dataPushService.deleteStartProcess(dataPushTemp);
        }
        LambdaQueryWrapper urgeQueryWrapper = new LambdaQueryWrapper();
        urgeQueryWrapper.in(SysActUrgeTask::getProcessInsId, allProcId);
        this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
        LambdaQueryWrapper lineQueryWrapper = new LambdaQueryWrapper();
        lineQueryWrapper.in(SysActHiLine::getProcessInsId, allProcId);
        this.iSysActHiLineService.remove((Wrapper)lineQueryWrapper);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteFinishedProcessInstance(String processInsId) {
        List<Long> procIdList = new ArrayList<Long>();
        procIdList.add(Long.valueOf(processInsId));
        ArrayList<Long> allProcId = new ArrayList<Long>();
        do {
            allProcId.addAll(procIdList);
        } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
        List stringProcIds = allProcId.stream().map(s -> s.toString()).collect(Collectors.toList());
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(stringProcIds)).list();
        List emulationProcess = historicProcessInstances.stream().filter(e -> "1".equals(e.getIsEmulation())).collect(Collectors.toList());
        List emulationProcessInsIds = emulationProcess.stream().map(HistoricProcessInstance::getId).collect(Collectors.toList());
        List emulationBusinessKey = emulationProcess.stream().map(HistoricProcessInstance::getBusinessKey).collect(Collectors.toList());
        this.historyService.deleteHistoricProcessInstance(processInsId);
        LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
        ccQueryWrapper.in(SysActCcTask::getProcessInsId, allProcId);
        this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
        HashMap<String, String> businessKeyMap = new HashMap<String, String>();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            String businessIds = (String)businessKeyMap.get(historicProcessInstance.getProcessDefinitionId());
            businessIds = businessIds == null ? historicProcessInstance.getBusinessKey() : businessIds + "," + historicProcessInstance.getBusinessKey();
            businessKeyMap.put(historicProcessInstance.getProcessDefinitionId(), businessIds);
            processDefinitionIdList.add(historicProcessInstance.getProcessDefinitionId());
        }
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessMap(businessKeyMap);
            dataPush.setProcessState("deleteProcess");
            dataPush.setProcessInsId(StringUtils.join(stringProcIds, (String)","));
            dataPush.setEmulationBusinessKey(emulationBusinessKey);
            dataPush.setEmulationProcessInsIds(emulationProcessInsIds);
            this.dataPushService.deleteDataPush(dataPush);
            this.dataPushService.changeProcessStateDataPush(dataPush);
            DataPush dataPushTemp = new DataPush();
            dataPushTemp.setProcessInsId(processInsId);
            this.dataPushService.deleteStartProcess(dataPushTemp);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteFinishProcessInstanceByBusinessId(String businessId) {
        ArrayList<String> businessKeys = new ArrayList<String>();
        businessKeys.add(businessId);
        List<Long> procIdList = this.instanceEngineMapper.selectProcIdByBusinessIdList(businessKeys);
        if (procIdList.size() == 0) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_NOT_START.getMessage(), null);
        }
        Long processInstanceId = procIdList.get(0);
        ArrayList<Long> allProcId = new ArrayList<Long>();
        do {
            allProcId.addAll(procIdList);
        } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
        List stringProcIds = allProcId.stream().map(s -> s.toString()).collect(Collectors.toList());
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(stringProcIds)).list();
        List emulationProcess = historicProcessInstances.stream().filter(e -> "1".equals(e.getIsEmulation())).collect(Collectors.toList());
        List emulationProcessInsIds = emulationProcess.stream().map(HistoricProcessInstance::getId).collect(Collectors.toList());
        List emulationBusinessKey = emulationProcess.stream().map(HistoricProcessInstance::getBusinessKey).collect(Collectors.toList());
        for (int i = 0; i < historicProcessInstances.size(); ++i) {
            if (!HussarUtils.isEmpty((Object)((HistoricProcessInstance)historicProcessInstances.get(i)).getEndTime())) continue;
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_INSTANCE_IS_NOT_END.getMessage(), null);
        }
        this.historyService.deleteHistoricProcessInstance(String.valueOf(processInstanceId));
        LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
        ccQueryWrapper.in(SysActCcTask::getProcessInsId, allProcId);
        this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
        HashMap<String, String> businessKeyMap = new HashMap<String, String>();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            String businessIds = (String)businessKeyMap.get(historicProcessInstance.getProcessDefinitionKey());
            businessIds = businessIds == null ? historicProcessInstance.getBusinessKey() : businessIds + "," + historicProcessInstance.getBusinessKey();
            businessKeyMap.put(historicProcessInstance.getProcessDefinitionKey(), businessIds);
            processDefinitionIdList.add(historicProcessInstance.getProcessDefinitionId());
        }
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessMap(businessKeyMap);
            dataPush.setDescription("deleteProcess");
            dataPush.setProcessInsId(StringUtils.join(stringProcIds, (String)","));
            dataPush.setEmulationBusinessKey(emulationBusinessKey);
            dataPush.setEmulationProcessInsIds(emulationProcessInsIds);
            this.dataPushService.deleteDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessId(String businessId) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL.getMessage(), null);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (historicProcessInstance != null) {
            List<Long> procIdList = new ArrayList<Long>();
            procIdList.add(Long.valueOf(historicProcessInstance.getId()));
            ArrayList<Long> allProcId = new ArrayList<Long>();
            do {
                allProcId.addAll(procIdList);
            } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
            List stringProcIds = allProcId.stream().map(s -> s.toString()).collect(Collectors.toList());
            List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(stringProcIds)).list();
            List emulationProcess = historicProcessInstances.stream().filter(e -> "1".equals(e.getIsEmulation())).collect(Collectors.toList());
            List emulationProcessInsIds = emulationProcess.stream().map(HistoricProcessInstance::getId).collect(Collectors.toList());
            List emulationBusinessKey = emulationProcess.stream().map(HistoricProcessInstance::getBusinessKey).collect(Collectors.toList());
            if (historicProcessInstance.getEndTime() != null) {
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            } else {
                List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(stringProcIds)).list();
                StringBuilder taskIds = new StringBuilder();
                for (Task task : tasks) {
                    if (!HussarUtils.isNotEmpty((Object)task.getDueDate())) continue;
                    taskIds.append(",").append(task.getId());
                }
                if (HussarUtils.isNotEmpty((Object)taskIds.toString())) {
                    this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
                }
                this.runtimeService.deleteProcessInstance(historicProcessInstance.getId(), "");
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            }
            LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
            ccQueryWrapper.in(SysActCcTask::getProcessInsId, allProcId);
            this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
            LambdaQueryWrapper urgeQueryWrapper = new LambdaQueryWrapper();
            urgeQueryWrapper.in(SysActUrgeTask::getProcessInsId, allProcId);
            this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
            LambdaQueryWrapper lineQueryWrapper = new LambdaQueryWrapper();
            lineQueryWrapper.in(SysActHiLine::getProcessInsId, allProcId);
            this.iSysActHiLineService.remove((Wrapper)lineQueryWrapper);
            HashMap<String, String> businessKeyMap = new HashMap<String, String>();
            HashSet<String> processDefinitionIdList = new HashSet<String>();
            for (HistoricProcessInstance processInstance : historicProcessInstances) {
                String businessIds = (String)businessKeyMap.get(processInstance.getProcessDefinitionId());
                businessIds = businessIds == null ? processInstance.getBusinessKey() : businessIds + "," + processInstance.getBusinessKey();
                businessKeyMap.put(processInstance.getProcessDefinitionId(), businessIds);
                processDefinitionIdList.add(historicProcessInstance.getProcessDefinitionId());
            }
            if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                DataPush dataPush = new DataPush();
                dataPush.setBusinessMap(businessKeyMap);
                dataPush.setProcessState("deleteProcess");
                dataPush.setProcessInsId(StringUtils.join(stringProcIds, (String)","));
                dataPush.setEmulationBusinessKey(emulationBusinessKey);
                dataPush.setEmulationProcessInsIds(emulationProcessInsIds);
                this.dataPushService.deleteDataPush(dataPush);
                this.dataPushService.changeProcessStateDataPush(dataPush);
                DataPush dataPushTemp = new DataPush();
                dataPushTemp.setBusinessKey(businessId);
                dataPushTemp.setProcessInsId(historicProcessInstance.getId());
                this.dataPushService.deleteStartProcess(dataPushTemp);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessIdList(String businessId, boolean isValidate) {
        try {
            List<String> businessIdList;
            if (HussarUtils.isNotEmpty((Object)businessId) && HussarUtils.isNotEmpty(businessIdList = Arrays.asList(businessId.split(",")))) {
                if (isValidate) {
                    for (String s : businessIdList) {
                        BpmResponseResult validateResult;
                        if (s.isEmpty() || (validateResult = this.validateDeleteByBusinessId(s)).getResult().get(0) != null && "1".equals(validateResult.getResult().get(0).toString())) continue;
                        return InstallResult.getResult((String)"0", (String)validateResult.getMsg(), null);
                    }
                }
                List<Long> procIdList = this.instanceEngineMapper.selectProcIdByBusinessIdList(businessIdList);
                List<ProcessInstVo> businessProcKeyList = this.instanceEngineMapper.selectProcKeyByBusinessIdList(businessIdList);
                HashMap<String, String> businessMap = new HashMap<String, String>();
                HashSet<String> processDefinitionIdList = new HashSet<String>();
                if (HussarUtils.isNotEmpty(businessProcKeyList)) {
                    for (ProcessInstVo processInstVo : businessProcKeyList) {
                        if (businessMap.containsKey(processInstVo.getProcessDefinitionId())) {
                            String businessIds = (String)businessMap.get(processInstVo.getProcessDefinitionId());
                            businessIds = businessIds + "," + processInstVo.getBusinessId();
                            businessMap.put(processInstVo.getProcessDefinitionId(), businessIds);
                        } else {
                            businessMap.put(processInstVo.getProcessDefinitionId(), processInstVo.getBusinessId());
                        }
                        processDefinitionIdList.add(processInstVo.getProcessDefinitionId());
                    }
                }
                if (!procIdList.isEmpty()) {
                    ArrayList<Long> allProcId = new ArrayList<Long>();
                    do {
                        allProcId.addAll(procIdList);
                    } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
                    this.multiDeleteByProcIdList(allProcId, businessMap, processDefinitionIdList);
                }
            }
        }
        catch (Exception e) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult queryFinishedProcessInstance(String processKey, String businessId, int page, int rows) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        HistoricProcessInstanceQuery countQuery = this.historyService.createHistoricProcessInstanceQuery().finished();
        HistoricProcessInstanceQuery listQuery = (HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().finished().orderByProcessInstanceEndTime().desc();
        if (HussarUtils.isNotEmpty((Object)businessId)) {
            countQuery.processInstanceBusinessKey(businessId);
            listQuery.processInstanceBusinessKey(businessId);
        }
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            countQuery.processDefinitionKey(processKey);
            listQuery.processDefinitionKey(processKey);
        }
        Long count = countQuery.count();
        List insts = listQuery.listPage((page - 1) * rows, rows);
        object.put("data", (Object)insts);
        object.put("count", (Object)count);
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryAllProcessInstance(ProcessInstAllQueryDto processInstAllQueryDto) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        long current = processInstAllQueryDto.getCurrent() == null ? 1L : processInstAllQueryDto.getCurrent();
        long size = processInstAllQueryDto.getSize() == null ? 10L : processInstAllQueryDto.getSize();
        Page page = new Page(current, size);
        List<HistoricProcessInstanceVo> list = this.instanceEngineMapper.selectProcessInstList((Page<HistoricProcessInstanceVo>)page, processInstAllQueryDto);
        List processInstIds = list.stream().map(historicProcessInstanceVo -> Long.toString(historicProcessInstanceVo.getProcessInsId())).collect(Collectors.toList());
        TaskService taskService = this.processEngine.getTaskService();
        List tasks = new ArrayList();
        if (!list.isEmpty()) {
            tasks = ((TaskQuery)taskService.createTaskQuery().active().processInstanceIdIn(processInstIds)).list();
        }
        for (HistoricProcessInstanceVo historicProcessInstanceVo2 : list) {
            ArrayList<JSONObject> currentTasks = new ArrayList<JSONObject>();
            for (Task task : tasks) {
                if (!String.valueOf(historicProcessInstanceVo2.getProcessInsId()).equals(task.getProcessInstanceId())) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("taskId", (Object)task.getId());
                jsonObject.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                jsonObject.put("name", (Object)task.getName());
                currentTasks.add(jsonObject);
            }
            historicProcessInstanceVo2.setCurrentTasks(currentTasks);
        }
        object.put("data", list);
        object.put("count", (Object)page.getTotal());
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessInstanceCompleteState(String processInsId) {
        JSONArray json = new JSONArray();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        Boolean isEnded = historicProcessInstance == null ? null : Boolean.valueOf(historicProcessInstance.getEndTime() != null);
        json.add(isEnded);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessInstanceCompleteStateByBusinessId(String businessId) {
        JSONArray json = new JSONArray();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        Boolean isEnded = historicProcessInstance == null ? null : Boolean.valueOf(historicProcessInstance.getEndTime() != null);
        json.add(isEnded);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getProcessTrace(String processInsId) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL.getMessage(), null);
        }
        JSONArray jsonArray = new JSONArray();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_NOT_FOUND.getMessage(), null);
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        List hisList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).activityType("userTask").orderByHistoricActivityInstanceStartTime().desc()).finished().list();
        List<Object> userList = new ArrayList();
        if (hisList != null && !hisList.isEmpty()) {
            userList = hisList.stream().map(HistoricActivityInstance::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).list();
        for (ActivityImpl activity : activitiList) {
            JSONObject object = new JSONObject();
            object.put("width", (Object)activity.getWidth());
            object.put("height", (Object)activity.getHeight());
            object.put("x", (Object)activity.getX());
            object.put("y", (Object)activity.getY());
            object.put("id", (Object)activity.getId());
            List taskList = null;
            if (tasks != null && !tasks.isEmpty()) {
                taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
            }
            if (taskList != null && !taskList.isEmpty()) {
                List<String> user = this.getAssigneeByTaskId(((Task)taskList.get(0)).getId());
                if (!user.isEmpty()) {
                    String assignee = this.iAssigneeChooseService.getUserNames(user);
                    object.put("assignee", (Object)assignee);
                } else {
                    object.put("assignee", (Object)BpmExceptionCodeEnum.NULL_ASSIGNEE.getMessage());
                }
                object.put("state", (Object)NOW_STATE);
            } else {
                object.put("state", (Object)FINISH_STATE);
                List hisActivitList = null;
                if (hisList != null && !hisList.isEmpty()) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getActivityId().equals(activity.getId())).collect(Collectors.toList());
                }
                if (hisActivitList == null || hisActivitList.isEmpty()) continue;
                hisActivitList.sort(Comparator.comparing(HistoricActivityInstance::getStartTime));
                JSONArray json = new JSONArray();
                for (HistoricActivityInstance historicActivityInstance : hisActivitList) {
                    List comments;
                    JSONObject o = new JSONObject();
                    String user = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = (String)finalUsersMap.get(historicActivityInstance.getAssignee());
                    }
                    if ((comments = this.taskService.getTaskComments(historicActivityInstance.getTaskId(), NOW_STATE)) != null && !comments.isEmpty()) {
                        o.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? BpmExceptionCodeEnum.NULL_COMMENT.getMessage() : ((Comment)comments.get(0)).getFullMessage()));
                    } else {
                        o.put("comments", (Object)BpmExceptionCodeEnum.NULL_COMMENT.getMessage());
                    }
                    o.put("assignee", (Object)user);
                    o.put("endTime", (Object)historicActivityInstance.getEndTime());
                    o.put("startTime", (Object)historicActivityInstance.getStartTime());
                    json.add((Object)o);
                }
                object.put("completeInfo", (Object)json);
            }
            jsonArray.add((Object)object);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult getAllProcessTrace(String processInsId, String subProcessKey, Integer cycleCount) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL.getMessage(), null);
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).subProcessKey(subProcessKey)).cycleCount(cycleCount)).list();
        return this.getResult(hisTaskList, true, true);
    }

    public JSONObject getProcessHistoryMsg(String processInsId, String businessId, Integer processCycleCount, boolean isFirstQuery, String initialProcessInsId, String initialBusinessId, boolean needGetCallActivity) {
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        if (HussarUtils.isEmpty((Object)processInsId)) {
            if (HussarUtils.isEmpty((Object)businessId)) {
                return new JSONObject();
            }
            historicProcessInstanceQuery.processInstanceBusinessKey(businessId);
        } else {
            historicProcessInstanceQuery.processInstanceId(processInsId);
        }
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historicProcessInstanceQuery.singleResult();
        if (processInstance == null) {
            return new JSONObject();
        }
        processInsId = processInstance.getId();
        JSONObject result = new JSONObject();
        JSONObject json = this.getProcessHistory(processInsId, processInstance.getProcessDefinitionName(), processCycleCount, isFirstQuery, true, null, needGetCallActivity);
        if (isFirstQuery) {
            result.put("processHistory", json.get((Object)"processHistory"));
            result.put("processHistoryCount", (Object)json.getJSONArray("processHistory").size());
            if (processInstance.getSuperProcessInstanceId() != null) {
                HistoricProcessInstance superProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getSuperProcessInstanceId()).singleResult();
                String processInsIdCondition = null;
                if (HussarUtils.isNotEmpty((Object)businessId) && businessId.equals(initialBusinessId) || HussarUtils.isNotEmpty((Object)processInsId) && processInsId.equals(initialProcessInsId)) {
                    processInsIdCondition = processInsId;
                }
                JSONObject mainProcess = this.getProcessHistory(superProcessInstance.getId(), superProcessInstance.getProcessDefinitionName(), processCycleCount, isFirstQuery, true, processInsIdCondition, needGetCallActivity);
                result.put("superProcessHistoryWithCallActivity", mainProcess.get((Object)"processHistoryWithCallActivity"));
                result.put("superProcessHistoryWithCallActivityCount", (Object)mainProcess.getJSONArray("processHistoryWithCallActivity").size());
                result.put("superProcessHistory", mainProcess.get((Object)"processHistoryWithCallActivity"));
                result.put("superProcessHistoryCount", (Object)mainProcess.getJSONArray("processHistoryWithCallActivity").size());
            }
            if (json.containsKey((Object)"processHistoryWithCallActivity")) {
                result.put("processHistoryWithCallActivity", json.get((Object)"processHistoryWithCallActivity"));
                result.put("processHistoryWithCallActivityCount", (Object)json.getJSONArray("processHistoryWithCallActivity").size());
            }
        } else {
            result.put("processHistory", json.get((Object)"processHistory"));
            result.put("processHistoryCount", (Object)json.getJSONArray("processHistory").size());
        }
        return result;
    }

    private JSONObject getProcessHistory(String processInsId, String modelName, Integer processCycleCount, boolean isFirstQuery, boolean getWithCallActivity, String callActivityProcessInsId, boolean needGetCallActivity) {
        JSONObject json = new JSONObject();
        JSONArray result = new JSONArray();
        JSONArray resultWithCallProcess = new JSONArray();
        boolean containsCallActivity = false;
        json.put("processHistory", (Object)result);
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).processCycleCount(processCycleCount)).list();
        if (!hisTaskList.isEmpty()) {
            HashSet<String> userList = new HashSet<String>();
            ArrayList<Long> hisTaskIds = new ArrayList<Long>();
            ArrayList runningTaskIds = new ArrayList();
            hisTaskList.forEach(o -> {
                if (isFirstQuery || processCycleCount != null || o.getProcessCycleCount() == null) {
                    if (o.getEndTime() != null) {
                        hisTaskIds.add(Long.parseLong(o.getId()));
                        if (TaskStateType.isEntrust((HistoricTaskInstance)o) && HussarUtils.isNotEmpty((Object)o.getOwner())) {
                            userList.add(o.getOwner());
                        }
                        if (HussarUtils.isNotEmpty((Object)o.getAssignee())) {
                            userList.add(o.getAssignee());
                        }
                    } else {
                        runningTaskIds.add(Long.parseLong(o.getId()));
                    }
                }
            });
            List users = new ArrayList();
            if (!runningTaskIds.isEmpty()) {
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.in(BpmActRuIdentitylink::getTaskId, runningTaskIds);
                lambdaQueryWrapper.eq(BpmActRuIdentitylink::getType, (Object)"candidate");
                users = this.bpmActRuIdentitylinkMapper.selectList((Wrapper)lambdaQueryWrapper);
            }
            HashMap<String, List> todoUserMap = new HashMap<String, List>();
            for (BpmActRuIdentitylink identityLink : users) {
                if (HussarUtils.isNotEmpty((Object)identityLink.getMandator())) {
                    userList.add(identityLink.getMandator());
                }
                if (HussarUtils.isNotEmpty((Object)identityLink.getAddAssigneeOperator())) {
                    userList.add(identityLink.getAddAssigneeOperator());
                }
                userList.add(identityLink.getUserId());
                todoUserMap.computeIfAbsent(String.valueOf(identityLink.getTaskId()), k -> new ArrayList()).add(identityLink);
            }
            Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userList));
            List<Object> commentsMap = new ArrayList();
            if (!hisTaskIds.isEmpty()) {
                commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
            }
            HashMap<String, String> taskComment = new HashMap<String, String>();
            for (TaskCommentVO taskCommentVO : commentsMap) {
                taskComment.put(String.valueOf(taskCommentVO.getTaskId()), taskCommentVO.getFullMessage() == null ? taskCommentVO.getMessage() : taskCommentVO.getFullMessage());
            }
            HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (HistoricTaskInstance hsi : hisTaskList) {
                if (!isFirstQuery && processCycleCount == null && hsi.getProcessCycleCount() != null) continue;
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? BpmExceptionCodeEnum.NULL_COMPLETE.getMessage() : (TaskStateType.isEntrust((HistoricTaskInstance)hsi) ? (String)finalUsersMap.get(hsi.getAssignee()) + "(" + (String)finalUsersMap.get(hsi.getOwner()) + ")" : (String)finalUsersMap.get(hsi.getAssignee()))) : BpmExceptionCodeEnum.NULL_COMPLETE.getMessage();
                String nullCommont = BpmExceptionCodeEnum.NULL_COMMENT.getMessage();
                String comment = (String)taskComment.get(hsi.getId());
                object.put("comments", (Object)(comment == null ? nullCommont : comment));
                object.put("startTime", (Object)simpleDateFormat.format(hsi.getStartTime()));
                object.put("start", (Object)hsi.getStartTime());
                object.put("assigneeId", (Object)hsi.getAssignee());
                object.put("end", (Object)hsi.getEndTime());
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)simpleDateFormat.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List todoUser = (List)todoUserMap.get(hsi.getId());
                    if (HussarUtils.isNotEmpty((Object)todoUser)) {
                        ArrayList<String> todoUserName = new ArrayList<String>();
                        for (BpmActRuIdentitylink identityLink : todoUser) {
                            if (finalUsersMap.get(identityLink.getUserId()) == null) continue;
                            if (TaskStateType.isEntrust((String)identityLink.getTaskState()) && finalUsersMap.get(identityLink.getMandator()) != null) {
                                todoUserName.add((String)finalUsersMap.get(identityLink.getUserId()) + "(" + (String)finalUsersMap.get(identityLink.getMandator()) + TASK_SOURCE_FLAG.get("transfer") + ")");
                                continue;
                            }
                            if (HussarUtils.isNotEmpty((Object)identityLink.getAddAssigneeOperator()) && finalUsersMap.get(identityLink.getAddAssigneeOperator()) != null) {
                                todoUserName.add((String)finalUsersMap.get(identityLink.getUserId()) + "(" + (String)finalUsersMap.get(identityLink.getAddAssigneeOperator()) + TASK_SOURCE_FLAG.get("addAssignee") + ")");
                                continue;
                            }
                            todoUserName.add((String)finalUsersMap.get(identityLink.getUserId()));
                        }
                        String assignee = String.join((CharSequence)",", todoUserName);
                        object.put("assigneeId", (Object)((BpmActRuIdentitylink)users.get(0)).getUserId());
                        if (HussarUtils.isNotEmpty((Object)assignee)) {
                            object.put("assignee", (Object)assignee);
                        } else {
                            object.put("assignee", (Object)BpmExceptionCodeEnum.NULL_COMPLETE.getMessage());
                        }
                    } else {
                        object.put("assignee", (Object)BpmExceptionCodeEnum.NULL_COMPLETE.getMessage());
                    }
                    object.put("comments", (Object)"");
                }
                object.put("modelName", (Object)modelName);
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processKey", (Object)hsi.getProcessDefinitionId().split(":")[0]);
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = hsi.getTaskSourceFlag();
                object.put("sub_process_key", (Object)hsi.getSubProcessKey());
                object.put("taskSourceFlag", (Object)InstanceEngineServiceImpl.getStrTaskSourceFlag(taskSourceFlag));
                object.put("taskType", (Object)hsi.getTaskType());
                if (hsi.getSubProcessKey() != null) {
                    String subProcessKey = hsi.getSubProcessKey();
                    Integer cycleCount = hsi.getCycleCount();
                    map.computeIfAbsent(subProcessKey + ":" + cycleCount, k -> new JSONArray()).add((Object)object);
                    continue;
                }
                result.add((Object)object);
                resultWithCallProcess.add((Object)object);
            }
            List activityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).processCycleCount(processCycleCount).list();
            HashMap<String, List> subProcessMap = new HashMap<String, List>();
            HashMap<String, List> callActivityMap = new HashMap<String, List>();
            for (HistoricActivityInstance historicActivityInstance : activityInstances) {
                Integer cycleCount;
                String taskDefKey;
                if (!isFirstQuery && processCycleCount == null && historicActivityInstance.getProcessCycleCount() != null) continue;
                if ("subProcess".equals(historicActivityInstance.getActivityType())) {
                    taskDefKey = historicActivityInstance.getActivityId();
                    cycleCount = historicActivityInstance.getCycleCount();
                    subProcessMap.computeIfAbsent(taskDefKey + ":" + cycleCount, k -> new ArrayList()).add(historicActivityInstance);
                    continue;
                }
                if (!"callActivity".equals(historicActivityInstance.getActivityType()) || callActivityProcessInsId != null && !callActivityProcessInsId.equals(historicActivityInstance.getCalledProcessInstanceId())) continue;
                taskDefKey = historicActivityInstance.getActivityId();
                cycleCount = historicActivityInstance.getCycleCount();
                callActivityMap.computeIfAbsent(taskDefKey + ":" + cycleCount, k -> new ArrayList()).add(historicActivityInstance);
            }
            for (List list : subProcessMap.values()) {
                Date start = ((HistoricActivityInstance)list.get(0)).getStartTime();
                Date end = ((HistoricActivityInstance)list.get(0)).getEndTime();
                JSONArray jsonArray = new JSONArray();
                for (HistoricActivityInstance subProcess : list) {
                    JSONObject subProcessMsg = new JSONObject();
                    JSONArray subProcessTask = (JSONArray)map.get(subProcess.getSubProcessKey() + ":" + subProcess.getCycleCount());
                    if (HussarUtils.isEmpty((Object)subProcessTask)) continue;
                    this.processHistoryMsgSort(subProcessTask);
                    subProcessMsg.put("subProcessTask", (Object)subProcessTask);
                    subProcessMsg.put("taskDefinitionName", (Object)subProcess.getActivityName());
                    subProcessMsg.put("activityId", (Object)subProcess.getId());
                    subProcessMsg.put("taskDefinitionKey", (Object)subProcess.getActivityId());
                    subProcessMsg.put("startTime", (Object)simpleDateFormat.format(subProcess.getStartTime()));
                    subProcessMsg.put("start", (Object)subProcess.getStartTime());
                    if (start.after(subProcess.getStartTime())) {
                        start = subProcess.getStartTime();
                    }
                    subProcessMsg.put("taskSourceFlag", (Object)"");
                    subProcessMsg.put("sub_process_key", (Object)subProcess.getSubProcessKey());
                    subProcessMsg.put("type", (Object)"subProcess");
                    if (subProcess.getEndTime() != null) {
                        subProcessMsg.put("endTime", (Object)simpleDateFormat.format(subProcess.getEndTime()));
                        if (end != null && end.before(subProcess.getEndTime())) {
                            end = subProcess.getEndTime();
                        }
                        subProcessMsg.put("end", (Object)subProcess.getEndTime());
                    }
                    int loopCounter = Integer.parseInt(subProcess.getSubProcessKey().split(":")[2]);
                    subProcessMsg.put("activityName", (Object)subProcess.getSubProcessName());
                    while (jsonArray.size() < loopCounter + 1) {
                        jsonArray.add((Object)"");
                    }
                    jsonArray.set(loopCounter, (Object)subProcessMsg);
                }
                ArrayList<String> removeList = new ArrayList<String>();
                removeList.add("");
                jsonArray.removeAll(removeList);
                if (jsonArray.isEmpty()) continue;
                for (int m = 0; m < jsonArray.size(); ++m) {
                    if (!HussarUtils.isEmpty((Object)jsonArray.getJSONObject(m).get((Object)"activityName"))) continue;
                    jsonArray.getJSONObject(m).put("activityName", (Object)(SUB_PROCINST_NAME + (m + 1)));
                }
                JSONObject object = jsonArray.getJSONObject(0);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("activityName", object.get((Object)"taskDefinitionName"));
                jsonObject.put("activityId", object.get((Object)"activityId"));
                jsonObject.put("taskDefinitionKey", object.get((Object)"taskDefinitionKey"));
                jsonObject.put("start", (Object)start);
                jsonObject.put("end", (Object)end);
                jsonObject.put("taskSourceFlag", (Object)"");
                jsonObject.put("subProcess", (Object)jsonArray);
                jsonObject.put("type", (Object)"multiSubProcess");
                result.add((Object)jsonObject);
                resultWithCallProcess.add((Object)jsonObject);
            }
            if (getWithCallActivity) {
                for (List list : callActivityMap.values()) {
                    containsCallActivity = true;
                    int loopCounter = 0;
                    HashSet<String> processInstIds = new HashSet<String>();
                    boolean isNotSegmentation = ((HistoricActivityInstance)list.get(0)).getCycleCount() == null;
                    Date start = ((HistoricActivityInstance)list.get(0)).getStartTime();
                    Date end = ((HistoricActivityInstance)list.get(0)).getEndTime();
                    JSONArray jsonArray = new JSONArray();
                    for (HistoricActivityInstance subProcess : list) {
                        if (isNotSegmentation && !processInstIds.add(subProcess.getCalledProcessInstanceId())) continue;
                        JSONObject callActivityMsg = new JSONObject();
                        callActivityMsg.put("processInsId", (Object)subProcess.getCalledProcessInstanceId());
                        callActivityMsg.put("process_cycle_count", (Object)subProcess.getCycleCount());
                        if (subProcess.getCalledProcessInstanceId() == null || ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(subProcess.getCalledProcessInstanceId())).processCycleCount(subProcess.getCycleCount())).count() == 0L) continue;
                        callActivityMsg.put("taskDefinitionName", (Object)subProcess.getActivityName());
                        callActivityMsg.put("activityId", (Object)subProcess.getId());
                        callActivityMsg.put("taskDefinitionKey", (Object)subProcess.getActivityId());
                        callActivityMsg.put("startTime", (Object)simpleDateFormat.format(subProcess.getStartTime()));
                        callActivityMsg.put("start", (Object)subProcess.getStartTime());
                        if (start.after(subProcess.getStartTime())) {
                            start = subProcess.getStartTime();
                        }
                        callActivityMsg.put("taskSourceFlag", (Object)"");
                        callActivityMsg.put("type", (Object)"callActivity");
                        if (subProcess.getEndTime() != null) {
                            callActivityMsg.put("endTime", (Object)simpleDateFormat.format(subProcess.getEndTime()));
                            if (end != null && end.before(subProcess.getEndTime())) {
                                end = subProcess.getEndTime();
                            }
                            callActivityMsg.put("end", (Object)subProcess.getEndTime());
                        }
                        callActivityMsg.put("activityName", (Object)(SUB_PROCINST_NAME + (loopCounter + 1)));
                        jsonArray.set(loopCounter, (Object)callActivityMsg);
                        ++loopCounter;
                    }
                    if (jsonArray.isEmpty()) continue;
                    JSONObject object = jsonArray.getJSONObject(0);
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("activityName", object.get((Object)"taskDefinitionName"));
                    jsonObject.put("activityId", object.get((Object)"activityId"));
                    jsonObject.put("taskDefinitionKey", object.get((Object)"taskDefinitionKey"));
                    jsonObject.put("start", (Object)start);
                    jsonObject.put("end", (Object)end);
                    jsonObject.put("taskSourceFlag", (Object)"");
                    jsonObject.put("subProcess", (Object)jsonArray);
                    jsonObject.put("type", (Object)"multiCallActivity");
                    resultWithCallProcess.add((Object)jsonObject);
                }
            }
        }
        if (isFirstQuery) {
            this.processHistoryMsgSort(result);
            if (containsCallActivity) {
                this.processHistoryMsgSort(resultWithCallProcess);
                json.put("processHistoryWithCallActivity", (Object)resultWithCallProcess);
            }
        } else if (needGetCallActivity) {
            this.processHistoryMsgSort(resultWithCallProcess);
            json.put("processHistory", (Object)resultWithCallProcess);
        } else {
            this.processHistoryMsgSort(result);
        }
        return json;
    }

    private void processHistoryMsgSort(JSONArray json) {
        String completeHistoryOrderingRule;
        JSONArray list = json;
        switch (completeHistoryOrderingRule = this.lcdpBpmProperties.getCompleteHistoryOrderingRule()) {
            case "create-time-asc": {
                list.sort((o1, o2) -> {
                    if (!o1.getDate("start").equals(o2.getDate("start"))) {
                        return o1.getDate("start").compareTo(o2.getDate("start"));
                    }
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getDate("end"), o2.getDate("end")})) {
                        return o1.getString("taskDefinitionKey").compareTo(o2.getString("taskDefinitionKey"));
                    }
                    if (o1.getDate("end") == null && o2.getDate("end") != null) {
                        return new Date(0L).compareTo(o2.getDate("end"));
                    }
                    if (o1.getDate("end") != null && o2.getDate("end") == null) {
                        return o1.getDate("end").compareTo(new Date());
                    }
                    if (Objects.equals(o1.getDate("end"), o2.getDate("end"))) {
                        return o1.getString("taskDefinitionKey").compareTo(o2.getString("taskDefinitionKey"));
                    }
                    return o1.getDate("end").compareTo(o2.getDate("end"));
                });
                break;
            }
            case "create-time-desc": {
                list.sort((o1, o2) -> {
                    if (!o1.getDate("start").equals(o2.getDate("start"))) {
                        return o2.getDate("start").compareTo(o1.getDate("start"));
                    }
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getDate("end"), o2.getDate("end")})) {
                        return o2.getString("taskDefinitionKey").compareTo(o1.getString("taskDefinitionKey"));
                    }
                    if (o1.getDate("end") == null && o2.getDate("end") != null) {
                        return o2.getDate("end").compareTo(new Date());
                    }
                    if (o1.getDate("end") != null && o2.getDate("end") == null) {
                        return new Date(0L).compareTo(o1.getDate("end"));
                    }
                    if (Objects.equals(o1.getDate("end"), o2.getDate("end"))) {
                        return o2.getString("taskDefinitionKey").compareTo(o1.getString("taskDefinitionKey"));
                    }
                    return o2.getDate("end").compareTo(o1.getDate("end"));
                });
                break;
            }
            case "todo-in-front-desc": {
                list.sort((o1, o2) -> {
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getDate("end"), o2.getDate("end")})) {
                        return o1.getString("taskDefinitionKey").compareTo(o2.getString("taskDefinitionKey"));
                    }
                    if (o1.getDate("end") == null && o2.getDate("end") != null) {
                        return new Date(0L).compareTo(o2.getDate("end"));
                    }
                    if (o1.getDate("end") != null && o2.getDate("end") == null) {
                        return o1.getDate("end").compareTo(new Date(0L));
                    }
                    if (Objects.equals(o1.getDate("end"), o2.getDate("end"))) {
                        return o2.getString("taskDefinitionKey").compareTo(o1.getString("taskDefinitionKey"));
                    }
                    return o2.getDate("end").compareTo(o1.getDate("end"));
                });
                break;
            }
            default: {
                list.sort((o1, o2) -> {
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getDate("end"), o2.getDate("end")})) {
                        return o1.getString("taskDefinitionKey").compareTo(o2.getString("taskDefinitionKey"));
                    }
                    if (o1.getDate("end") == null && o2.getDate("end") != null) {
                        return new Date(0L).compareTo(o2.getDate("end"));
                    }
                    if (o1.getDate("end") != null && o2.getDate("end") == null) {
                        return o1.getDate("end").compareTo(new Date(0L));
                    }
                    if (Objects.equals(o1.getDate("end"), o2.getDate("end"))) {
                        return o2.getString("taskDefinitionKey").compareTo(o1.getString("taskDefinitionKey"));
                    }
                    return o1.getDate("end").compareTo(o2.getDate("end"));
                });
            }
        }
    }

    public JSONArray getAllProcessTraceForComment(String processInsId) {
        String completeHistoryOrderingRule;
        if (processInsId == null) {
            return new JSONArray();
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).finished().list();
        ArrayList userList = new ArrayList();
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            hisTaskList.forEach(o -> {
                if (TaskStateType.isEntrust((HistoricTaskInstance)o) && HussarUtils.isNotEmpty((Object)o.getOwner())) {
                    userList.add(o.getOwner());
                }
                if (HussarUtils.isNotEmpty((Object)o.getAssignee())) {
                    userList.add(o.getAssignee());
                }
            });
        }
        switch (completeHistoryOrderingRule = this.lcdpBpmProperties.getCompleteHistoryOrderingRule()) {
            case "create-time-asc": {
                hisTaskList.sort((o1, o2) -> {
                    if (!o1.getStartTime().equals(o2.getStartTime())) {
                        return o1.getStartTime().compareTo(o2.getStartTime());
                    }
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    if (o1.getEndTime() == null && o2.getEndTime() != null) {
                        return new Date(0L).compareTo(o2.getEndTime());
                    }
                    if (o1.getEndTime() != null && o2.getEndTime() == null) {
                        return o1.getEndTime().compareTo(new Date());
                    }
                    if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    return o1.getEndTime().compareTo(o2.getEndTime());
                });
                break;
            }
            case "create-time-desc": {
                hisTaskList.sort((o1, o2) -> {
                    if (!o1.getStartTime().equals(o2.getStartTime())) {
                        return o2.getStartTime().compareTo(o1.getStartTime());
                    }
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                        return o2.getTaskDefinitionKey().compareTo(o1.getTaskDefinitionKey());
                    }
                    if (o1.getEndTime() == null && o2.getEndTime() != null) {
                        return o2.getEndTime().compareTo(new Date());
                    }
                    if (o1.getEndTime() != null && o2.getEndTime() == null) {
                        return new Date(0L).compareTo(o1.getEndTime());
                    }
                    if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                        return o2.getTaskDefinitionKey().compareTo(o1.getTaskDefinitionKey());
                    }
                    return o2.getEndTime().compareTo(o1.getEndTime());
                });
                break;
            }
            case "todo-in-front-desc": {
                hisTaskList.sort((o1, o2) -> {
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    if (o1.getEndTime() == null && o2.getEndTime() != null) {
                        return new Date(0L).compareTo(o2.getEndTime());
                    }
                    if (o1.getEndTime() != null && o2.getEndTime() == null) {
                        return o1.getEndTime().compareTo(new Date(0L));
                    }
                    if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    return o2.getEndTime().compareTo(o1.getEndTime());
                });
                break;
            }
            default: {
                hisTaskList.sort((o1, o2) -> {
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    if (o1.getEndTime() == null && o2.getEndTime() != null) {
                        return new Date(0L).compareTo(o2.getEndTime());
                    }
                    if (o1.getEndTime() != null && o2.getEndTime() == null) {
                        return o1.getEndTime().compareTo(new Date(0L));
                    }
                    if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    return o1.getEndTime().compareTo(o2.getEndTime());
                });
            }
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        JSONArray jsonArray = new JSONArray();
        for (HistoricTaskInstance hsi : hisTaskList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("taskId", (Object)hsi.getId());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            jsonObject.put("endTime", (Object)sdf.format(hsi.getEndTime()));
            jsonObject.put("activityName", (Object)hsi.getName());
            jsonObject.put("sub_process_key", (Object)hsi.getSubProcessKey());
            jsonObject.put("start", (Object)hsi.getStartTime());
            String user = null;
            user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? BpmExceptionCodeEnum.NULL_COMPLETE.getMessage() : (TaskStateType.isEntrust((HistoricTaskInstance)hsi) ? (String)finalUsersMap.get(hsi.getAssignee()) + "(" + (String)finalUsersMap.get(hsi.getOwner()) + ")" : (String)finalUsersMap.get(hsi.getAssignee()))) : BpmExceptionCodeEnum.NULL_COMPLETE.getMessage();
            jsonObject.put("assignee", (Object)user);
            jsonObject.put("taskType", (Object)hsi.getTaskType());
            String taskSourceFlag = hsi.getTaskSourceFlag();
            jsonObject.put("taskSourceFlag", (Object)InstanceEngineServiceImpl.getStrTaskSourceFlag(taskSourceFlag));
            jsonArray.add((Object)jsonObject);
        }
        this.handleSubProcessMessage(jsonArray, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), processInsId);
        return jsonArray;
    }

    public BpmResponseResult queryCallActivityTask(String businessId, String processInsId, int type) {
        HistoricProcessInstance historicProcessInstance;
        if (HussarUtils.isAllEmpty((Object[])new Object[]{processInsId, businessId})) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL.getMessage(), null);
        }
        List<Object> processInsIds = new ArrayList();
        if (type == 0) {
            if (HussarUtils.isEmpty((Object)processInsId)) {
                historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
                if (historicProcessInstance == null) {
                    return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_NOT_FOUND.getMessage(), null);
                }
                processInsId = historicProcessInstance.getId();
            }
            if ((processInsIds = this.taskEngineMapper.getCallActivityInstId(Long.parseLong(processInsId))).isEmpty()) {
                return InstallResult.getResult((String)"1", (String)"success", null);
            }
        } else {
            historicProcessInstance = HussarUtils.isEmpty((Object)processInsId) ? (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult() : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            if (historicProcessInstance == null) {
                return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_NOT_FOUND.getMessage(), null);
            }
            if (HussarUtils.isEmpty((Object)historicProcessInstance.getSuperProcessInstanceId())) {
                return InstallResult.getResult((String)"1", (String)"success", null);
            }
            processInsIds.add(historicProcessInstance.getSuperProcessInstanceId());
        }
        List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceIdIn(processInsIds)).list();
        return this.getResult(historicTaskInstances, true, true);
    }

    public BpmResponseResult getAllProcessTraceByBusinessId(String businessId, int page, int size) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL.getMessage(), null);
        }
        Long count = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).count();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).orderByHistoricTaskInstanceEndTime().asc()).listPage((page - 1) * size, size);
        BpmResponseResult bpmResponseResult = this.getResult(hisTaskList, true, true);
        bpmResponseResult.setMsg(String.valueOf(count));
        return bpmResponseResult;
    }

    private BpmResponseResult getResult(List<HistoricTaskInstance> hisTaskList, boolean flag, boolean handleSubProcessMessage) {
        String completeHistoryOrderingRule;
        JSONArray json = new JSONArray();
        ArrayList userList = new ArrayList();
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            hisTaskList.forEach(o -> {
                if (TaskStateType.isEntrust((HistoricTaskInstance)o) && HussarUtils.isNotEmpty((Object)o.getOwner())) {
                    userList.add(o.getOwner());
                }
                if (HussarUtils.isNotEmpty((Object)o.getAssignee())) {
                    userList.add(o.getAssignee());
                }
            });
        }
        switch (completeHistoryOrderingRule = this.lcdpBpmProperties.getCompleteHistoryOrderingRule()) {
            case "create-time-asc": {
                hisTaskList.sort((o1, o2) -> {
                    if (!o1.getStartTime().equals(o2.getStartTime())) {
                        return o1.getStartTime().compareTo(o2.getStartTime());
                    }
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    if (o1.getEndTime() == null && o2.getEndTime() != null) {
                        return new Date(0L).compareTo(o2.getEndTime());
                    }
                    if (o1.getEndTime() != null && o2.getEndTime() == null) {
                        return o1.getEndTime().compareTo(new Date());
                    }
                    if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    return o1.getEndTime().compareTo(o2.getEndTime());
                });
                break;
            }
            case "create-time-desc": {
                hisTaskList.sort((o1, o2) -> {
                    if (!o1.getStartTime().equals(o2.getStartTime())) {
                        return o2.getStartTime().compareTo(o1.getStartTime());
                    }
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                        return o2.getTaskDefinitionKey().compareTo(o1.getTaskDefinitionKey());
                    }
                    if (o1.getEndTime() == null && o2.getEndTime() != null) {
                        return o2.getEndTime().compareTo(new Date());
                    }
                    if (o1.getEndTime() != null && o2.getEndTime() == null) {
                        return new Date(0L).compareTo(o1.getEndTime());
                    }
                    if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                        return o2.getTaskDefinitionKey().compareTo(o1.getTaskDefinitionKey());
                    }
                    return o2.getEndTime().compareTo(o1.getEndTime());
                });
                break;
            }
            case "todo-in-front-desc": {
                hisTaskList.sort((o1, o2) -> {
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    if (o1.getEndTime() == null && o2.getEndTime() != null) {
                        return new Date(0L).compareTo(o2.getEndTime());
                    }
                    if (o1.getEndTime() != null && o2.getEndTime() == null) {
                        return o1.getEndTime().compareTo(new Date(0L));
                    }
                    if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    return o2.getEndTime().compareTo(o1.getEndTime());
                });
                break;
            }
            default: {
                hisTaskList.sort((o1, o2) -> {
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    if (o1.getEndTime() == null && o2.getEndTime() != null) {
                        return new Date(0L).compareTo(o2.getEndTime());
                    }
                    if (o1.getEndTime() != null && o2.getEndTime() == null) {
                        return o1.getEndTime().compareTo(new Date(0L));
                    }
                    if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    return o1.getEndTime().compareTo(o2.getEndTime());
                });
            }
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            ArrayList<Long> hisTaskIds = new ArrayList<Long>();
            for (HistoricTaskInstance hisTask : hisTaskList) {
                if (hisTask.getEndTime() == null) continue;
                hisTaskIds.add(Long.parseLong(hisTask.getId()));
            }
            List<Object> commentsMap = new ArrayList();
            if (HussarUtils.isNotEmpty(hisTaskIds)) {
                commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
            }
            HashMap<String, String> taskComment = new HashMap<String, String>();
            for (TaskCommentVO taskCommentVO : commentsMap) {
                taskComment.put(String.valueOf(taskCommentVO.getTaskId()), taskCommentVO.getFullMessage() == null ? taskCommentVO.getMessage() : taskCommentVO.getFullMessage());
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String string = hisTaskList.get(0).getProcessDefinitionId().split(":")[0];
            ArrayList<String> processKeys = new ArrayList<String>();
            processKeys.add(string);
            Map modelNames = this.modelService.selectModelNames(processKeys);
            String value = (String)modelNames.get(string);
            for (HistoricTaskInstance hsi : hisTaskList) {
                String comment;
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? BpmExceptionCodeEnum.NULL_COMPLETE.getMessage() : (TaskStateType.isEntrust((HistoricTaskInstance)hsi) ? (String)finalUsersMap.get(hsi.getAssignee()) + "(" + (String)finalUsersMap.get(hsi.getOwner()) + ")" : (String)finalUsersMap.get(hsi.getAssignee()))) : BpmExceptionCodeEnum.NULL_COMPLETE.getMessage();
                String nullCommont = "";
                if (flag) {
                    nullCommont = BpmExceptionCodeEnum.NULL_COMMENT.getMessage();
                }
                object.put("comments", (Object)((comment = (String)taskComment.get(hsi.getId())) == null ? nullCommont : comment));
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                object.put("start", (Object)hsi.getStartTime());
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List<IdentityLink> users = this.getIdentityLinkByTaskId(hsi.getId());
                    if (user != null && !users.isEmpty()) {
                        String assignee = String.join((CharSequence)",", this.iAssigneeChooseService.getEntrustUserNames(users));
                        if (HussarUtils.isNotEmpty((Object)assignee)) {
                            object.put("assignee", (Object)assignee);
                        } else {
                            object.put("assignee", (Object)BpmExceptionCodeEnum.NULL_COMPLETE.getMessage());
                        }
                    }
                    object.put("comments", (Object)"");
                }
                object.put("modelName", (Object)value);
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processKey", (Object)hsi.getProcessDefinitionId().split(":")[0]);
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                object.put("assigneeId", (Object)hsi.getAssignee());
                String taskSourceFlag = hsi.getTaskSourceFlag();
                object.put("sub_process_key", (Object)hsi.getSubProcessKey());
                object.put("taskSourceFlag", (Object)InstanceEngineServiceImpl.getStrTaskSourceFlag(taskSourceFlag));
                object.put("taskType", (Object)hsi.getTaskType());
                json.add((Object)object);
            }
            if (handleSubProcessMessage) {
                this.handleSubProcessMessage(json, sdf, hisTaskList.get(0).getProcessInstanceId());
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private void handleSubProcessMessage(JSONArray json, SimpleDateFormat sdf, String procInstId) {
        List activityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(procInstId).activityType("subProcess").orderByHistoricActivityInstanceStartTime().desc()).list();
        for (int i = 0; i < json.size(); ++i) {
            JSONObject object = json.getJSONObject(i);
            if (!HussarUtils.isNotEmpty((Object)object.get((Object)"sub_process_key"))) continue;
            String taskSubProcessKey = (String)object.get((Object)"sub_process_key");
            HistoricActivityInstance activity = null;
            for (int j = 0; j < activityInstances.size(); ++j) {
                activity = (HistoricActivityInstance)activityInstances.get(j);
                if (!activity.getSubProcessKey().equals(taskSubProcessKey) || !object.getDate("start").after(activity.getStartTime()) || activity.getEndTime() != null && !object.getDate("start").before(activity.getEndTime())) continue;
                activityInstances.remove(j);
                break;
            }
            if (activity == null) continue;
            JSONObject subProcessMsg = new JSONObject();
            subProcessMsg.put("activityName", (Object)activity.getActivityName());
            subProcessMsg.put("subProcessName", (Object)activity.getSubProcessName());
            subProcessMsg.put("activityId", (Object)activity.getId());
            subProcessMsg.put("taskDefinitionKey", (Object)activity.getActivityId());
            subProcessMsg.put("startTime", (Object)sdf.format(activity.getStartTime()));
            subProcessMsg.put("start", (Object)activity.getStartTime());
            subProcessMsg.put("taskSourceFlag", (Object)"");
            subProcessMsg.put("sub_process_key", (Object)taskSubProcessKey);
            if (taskSubProcessKey.equals(activity.getActivityId() + "::0")) {
                subProcessMsg.put("type", (Object)"subProcess");
            } else {
                subProcessMsg.put("type", (Object)"multiSubProcess");
            }
            if (activity.getEndTime() != null) {
                subProcessMsg.put("endTime", (Object)sdf.format(activity.getEndTime()));
                subProcessMsg.put("end", (Object)activity.getEndTime());
            }
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)object);
            subProcessMsg.put("subProcessTask", (Object)jsonArray);
            json.set(i, (Object)subProcessMsg);
            for (int j = i + 1; j < json.size(); ++j) {
                JSONObject subObject = json.getJSONObject(j);
                if (!taskSubProcessKey.equals(subObject.get((Object)"sub_process_key")) || subObject.getDate("start").before(activity.getStartTime()) || activity.getEndTime() != null && !subObject.getDate("start").before(activity.getEndTime())) continue;
                jsonArray.add((Object)subObject);
                json.remove(j--);
            }
        }
        HashMap<String, JSONObject> message = new HashMap<String, JSONObject>();
        for (int i = 0; i < json.size(); ++i) {
            JSONObject object = json.getJSONObject(i);
            if (!HussarUtils.isNotEmpty((Object)object.get((Object)"sub_process_key")) || !"multiSubProcess".equals(object.get((Object)"type"))) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("activityName", object.get((Object)"activityName"));
            jsonObject.put("activityId", object.get((Object)"activityId"));
            jsonObject.put("taskDefinitionKey", object.get((Object)"taskDefinitionKey"));
            Date start = object.getDate("start");
            Date end = object.getDate("end");
            jsonObject.put("taskSourceFlag", (Object)"");
            String subProcessKey = object.getString("sub_process_key");
            if (message.get(subProcessKey) != null) {
                ((JSONObject)message.get(subProcessKey)).put("type", (Object)"reStart");
            }
            if (end == null) {
                object.put("type", (Object)"start");
                message.put(subProcessKey, object);
            }
            int loopCounter = Integer.parseInt(subProcessKey.split(":")[2]);
            String subProcessName = (String)object.get((Object)"subProcessName");
            object.put("activityName", (Object)subProcessName);
            JSONArray jsonArray = new JSONArray();
            while (jsonArray.size() < loopCounter + 1) {
                jsonArray.add((Object)"");
            }
            jsonArray.set(loopCounter, (Object)object);
            jsonObject.put("subProcess", (Object)jsonArray);
            jsonObject.put("type", (Object)"multiSubProcess");
            json.set(i, (Object)jsonObject);
            for (int j = i + 1; j < json.size(); ++j) {
                boolean isSameMulti;
                JSONObject subObject = json.getJSONObject(j);
                if (subObject.get((Object)"sub_process_key") == null || !"multiSubProcess".equals(subObject.get((Object)"type"))) continue;
                if (object.get((Object)"end") == null) {
                    isSameMulti = subObject.get((Object)"end") == null ? true : subObject.getDate("end").after(object.getDate("start"));
                } else if (subObject.get((Object)"end") == null) {
                    isSameMulti = object.getDate("end").after(subObject.getDate("start"));
                } else {
                    boolean bl = isSameMulti = subObject.getDate("end").after(object.getDate("start")) && subObject.getDate("start").before(object.getDate("end"));
                }
                if (!isSameMulti) continue;
                subProcessKey = subObject.getString("sub_process_key");
                loopCounter = Integer.parseInt(subProcessKey.split(":")[2]);
                subProcessName = (String)subObject.get((Object)"subProcessName");
                subObject.put("activityName", (Object)subProcessName);
                Date date = start = start.after(subObject.getDate("start")) ? subObject.getDate("start") : start;
                if (end != null) {
                    Date newEnd = subObject.getDate("end");
                    if (newEnd == null) {
                        end = null;
                    } else {
                        Date date2 = end = end.before(newEnd) ? newEnd : end;
                    }
                }
                if (message.get(subProcessKey) != null) {
                    ((JSONObject)message.get(subProcessKey)).put("type", (Object)"reStart");
                }
                if (subObject.getDate("end") == null) {
                    subObject.put("type", (Object)"start");
                    message.put(subProcessKey, subObject);
                }
                while (jsonArray.size() < loopCounter + 1) {
                    jsonArray.add((Object)"");
                }
                jsonArray.set(loopCounter, (Object)subObject);
                json.remove(j--);
            }
            while (jsonArray.remove((Object)"")) {
            }
            for (int m = 0; m < jsonArray.size(); ++m) {
                String activityName = (String)jsonArray.getJSONObject(m).get((Object)"activityName");
                if (!HussarUtils.isEmpty((Object)activityName)) continue;
                jsonArray.getJSONObject(m).put("activityName", (Object)(SUB_PROCINST_NAME + (m + 1)));
            }
            jsonObject.put("startTime", (Object)sdf.format(start));
            if (end == null) continue;
            jsonObject.put("endTime", (Object)sdf.format(end));
        }
    }

    public BpmResponseResult getAllProcessTraceByMicroApp(String processInsId) {
        JSONArray json = new JSONArray();
        List<Object> userList = new ArrayList();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().asc()).list();
        ArrayList<HistoricTaskInstance> nullList = new ArrayList<HistoricTaskInstance>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getEndTime() != null) continue;
            nullList.add(historicTaskInstance);
        }
        hisTaskList.removeAll(nullList);
        for (HistoricTaskInstance hsi : nullList) {
            hisTaskList.add(hsi);
        }
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? BpmExceptionCodeEnum.NULL_COMPLETE.getMessage() : (String)finalUsersMap.get(hsi.getAssignee())) : BpmExceptionCodeEnum.NULL_COMPLETE.getMessage();
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && !comments.isEmpty()) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? BpmExceptionCodeEnum.NULL_COMMENT.getMessage() : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)BpmExceptionCodeEnum.NULL_COMMENT.getMessage());
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List<String> users = this.getAssigneeByTaskId(hsi.getId());
                    if (user != null && !users.isEmpty()) {
                        String assignee = this.iAssigneeChooseService.getUserNames(users);
                        object.put("assignee", (Object)assignee);
                    }
                    object.put("comments", (Object)"");
                }
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = hsi.getTaskSourceFlag();
                object.put("taskSourceFlag", (Object)InstanceEngineServiceImpl.getStrTaskSourceFlag(taskSourceFlag));
                object.put("taskType", (Object)hsi.getTaskType());
                json.add((Object)object);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getDoneProcessTrace(String businessId) {
        JSONArray json = new JSONArray();
        List<Object> userList = new ArrayList();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).orderByHistoricTaskInstanceEndTime().asc()).list();
        ArrayList<HistoricTaskInstance> nullList = new ArrayList<HistoricTaskInstance>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getEndTime() != null) continue;
            nullList.add(historicTaskInstance);
        }
        hisTaskList.removeAll(nullList);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? BpmExceptionCodeEnum.NULL_COMPLETE.getMessage() : (String)finalUsersMap.get(hsi.getAssignee())) : BpmExceptionCodeEnum.NULL_COMPLETE.getMessage();
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && !comments.isEmpty()) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? BpmExceptionCodeEnum.NULL_COMMENT.getMessage() : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)BpmExceptionCodeEnum.NULL_COMMENT.getMessage());
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                object.put("assignee", (Object)user);
                object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                object.put("time", (Object)(hsi.getEndTime().getTime() - hsi.getStartTime().getTime()));
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                object.put("taskSourceFlag", (Object)InstanceEngineServiceImpl.getStrTaskSourceFlag(hsi.getTaskSourceFlag()));
                object.put("taskType", (Object)hsi.getTaskType());
                json.add((Object)object);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessDefinitionByInstanceId(String processInsId) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL.getMessage(), null);
        }
        JSONArray json = new JSONArray();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_NOT_FOUND.getMessage(), null);
        }
        ProcessDefinitionModel processDefinitionModel = new ProcessDefinitionModel();
        processDefinitionModel = this.processDefinitionsService.getProcessDefitionById(processInstance.getProcessDefinitionId());
        json.add((Object)processDefinitionModel);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessDefinitionByBusinessId(String businessId) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL.getMessage(), null);
        }
        JSONArray json = new JSONArray();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_NOT_FOUND.getMessage(), null);
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        ProcessDefinitionModel processDefinitionModel = new ProcessDefinitionModel();
        processDefinitionModel.setKey(processDefinition.getKey());
        processDefinitionModel.setDescription(processDefinition.getDescription());
        processDefinitionModel.setVersion(String.valueOf(processDefinition.getVersion()));
        processDefinitionModel.setResourceName(processDefinition.getResourceName());
        processDefinitionModel.setDeploymentId(processDefinition.getDeploymentId());
        processDefinitionModel.setDiagramResourceName(processDefinition.getDiagramResourceName());
        processDefinitionModel.setHasStartFormKey(String.valueOf(processDefinition.hasStartFormKey()));
        processDefinitionModel.setHasGraphicalNotation(String.valueOf(processDefinition.hasGraphicalNotation()));
        processDefinitionModel.setIsSuspended(String.valueOf(processDefinition.isSuspended()));
        processDefinitionModel.setProcessName(processDefinition.getName());
        processDefinitionModel.setId(processDefinition.getId());
        json.add((Object)processDefinitionModel);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult endProcess(String taskId, String userId, String reason) {
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId, userId);
        if (HussarUtils.isEmpty((Object)(taskId = realTaskId.getTaskId()))) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.TASK_ID_NULL.getMessage(), null);
        }
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, mandator));
        mandator = prepareReturn.getMandator();
        if (HussarUtils.isEmpty((Object)taskId)) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.TASK_ID_NULL.getMessage(), null);
        }
        Task task = this.taskEngineService.getTask(taskId, "0");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        String businessId = historicProcessInstance.getBusinessKey();
        String processDefinitionId = task.getProcessDefinitionId();
        this.processEngine.getManagementService().executeCommand(new ProcessEndCmd(taskId, userId, mandator, reason, task.getProcessInstanceId(), businessId, processDefinitionId, "endProcess", true).addExecutionAttribute("endProcess", true).addSendUser(userId));
        this.handleMainProcessTask(userId, task.getProcessInstanceId());
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult endProcessByBusinessIdOrProcessInsId(String businessId, String processInsId, String userId, String comment) {
        String processInstanceId = null;
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            processInstanceId = processInsId;
        } else if (HussarUtils.isNotEmpty((Object)businessId)) {
            ArrayList<String> businessIds = new ArrayList<String>();
            businessIds.add(businessId);
            List<Long> processInstanceIds = this.instanceEngineMapper.selectProcIdByBusinessIdList(businessIds);
            if (processInstanceIds.size() == 0) {
                return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_NOT_START.getMessage(), null);
            }
            processInstanceId = String.valueOf(processInstanceIds.get(0));
        } else {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL.getMessage(), null);
        }
        ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (process.isSuspended()) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_IS_SUSPENDED);
        }
        String busienssId = process.getBusinessKey();
        String processDefinitionId = process.getProcessDefinitionId();
        this.processEngine.getManagementService().executeCommand(new ProcessEndCmd(userId, null, comment, processInstanceId, businessId, processDefinitionId, "endProcess").addExecutionAttribute("endProcess", true).addSendUser(userId));
        this.handleMainProcessTask(userId, processInstanceId);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private void handleMainProcessTask(String userId, String processInstanceId) {
        HistoricProcessInstance processInstance;
        String superProcessInstanceId = processInstanceId;
        while ((processInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(superProcessInstanceId).singleResult()).getSuperProcessInstanceId() != null) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            if (((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).list().isEmpty()) continue;
        }
        if (processInstance.getSuperProcessInstanceId() != null) {
            this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(processInstance.getSuperProcessInstanceId()));
            this.processEngine.getManagementService().executeCommand((Command)new ProcessNodeCmd(processInstance.getSuperProcessInstanceId()));
        }
    }

    public BpmResponseResult endProcessByProcessInsId(String processInstanceId, String userId, String reason) {
        if (HussarUtils.isEmpty((Object)processInstanceId)) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_INS_ID_NULL.getMessage(), null);
        }
        ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (process == null) {
            throw new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_FOUND.getMessage());
        }
        if (process.isSuspended()) {
            throw new BpmException(BpmExceptionCodeEnum.PROCESS_INS_IS_SUSPENDED.getMessage());
        }
        String businessId = process.getBusinessKey();
        String processDefinitionId = process.getProcessDefinitionId();
        this.processEngine.getManagementService().executeCommand(new ProcessEndCmd(userId, null, reason, processInstanceId, businessId, processDefinitionId, "endProcess").addExecutionAttribute("endProcess", true).addSendUser(userId));
        this.handleMainProcessTask(userId, processInstanceId);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult endProcess(ProcessInstEndDto processInstEndDto) {
        HistoricProcessInstance processInstance;
        String taskId = processInstEndDto.getTaskId();
        String userId = processInstEndDto.getUserId();
        String reason = processInstEndDto.getReason();
        String processInsId = processInstEndDto.getProcessInsId();
        String businessId = processInstEndDto.getBusinessId();
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId, userId);
        taskId = realTaskId.getTaskId();
        String superProcessInstanceId = null;
        String processInstanceId = null;
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            String mandator = realTaskId.getMandatary();
            CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, mandator));
            mandator = prepareReturn.getMandator();
            Task task = this.taskEngineService.getTask(taskId, "0");
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            businessId = historicProcessInstance.getBusinessKey();
            String processDefinitionId = task.getProcessDefinitionId();
            if (HussarUtils.isNotEmpty((Object)processInstEndDto.getParamMap()) && this.extendDataService != null) {
                ExtendDataDto extendDataDto = new ExtendDataDto();
                extendDataDto.setTaskId(processInstEndDto.getTaskId());
                extendDataDto.setExtendData(processInstEndDto.getParamMap());
                this.extendDataService.addExtendData(extendDataDto);
            }
            this.processEngine.getManagementService().executeCommand(new ProcessEndCmd(taskId, userId, mandator, reason, task.getProcessInstanceId(), businessId, processDefinitionId, "endProcess", true).addExecutionAttribute("endProcess", true).addSendUser(userId));
            superProcessInstanceId = task.getProcessInstanceId();
        } else {
            if (HussarUtils.isNotEmpty((Object)processInsId)) {
                processInstanceId = processInsId;
            } else if (HussarUtils.isNotEmpty((Object)businessId)) {
                ArrayList<String> businessIds = new ArrayList<String>();
                businessIds.add(businessId);
                List<Long> processInstanceIds = this.instanceEngineMapper.selectProcIdByBusinessIdList(businessIds);
                if (processInstanceIds.size() == 0) {
                    return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_NOT_START.getMessage(), null);
                }
                processInstanceId = String.valueOf(processInstanceIds.get(0));
            } else {
                return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL.getMessage(), null);
            }
            superProcessInstanceId = processInstanceId;
            ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (process.isSuspended()) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_IS_SUSPENDED);
            }
            businessId = process.getBusinessKey();
            String processDefinitionId = process.getProcessDefinitionId();
            this.processEngine.getManagementService().executeCommand(new ProcessEndCmd(userId, null, reason, processInstEndDto.getParamMap(), processInstanceId, businessId, processDefinitionId, "endProcess").addExecutionAttribute("endProcess", true).addSendUser(userId));
        }
        while ((processInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(superProcessInstanceId).singleResult()).getSuperProcessInstanceId() != null) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            if (((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).list().isEmpty()) continue;
        }
        if (processInstance.getSuperProcessInstanceId() != null) {
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).includeTaskLocalVariables()).list();
            for (TaskEntity taskEntity : tasks) {
                if (taskEntity.getTaskLocalVariables().containsKey("complete_type")) continue;
                this.processEngine.getManagementService().executeCommand(commandContext -> {
                    taskEntity.setVariableLocalWithOutQuery("complete_type", (Object)"end_process", true);
                    taskEntity.setVariableLocalWithOutQuery("sendUser", (Object)userId, true);
                    return null;
                });
            }
            this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(processInstance.getSuperProcessInstanceId()));
            this.processEngine.getManagementService().executeCommand((Command)new ProcessNodeCmd(processInstance.getSuperProcessInstanceId()));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private List<String> getAssigneeByTaskId(String taskId) {
        ArrayList<String> users = new ArrayList<String>();
        List identityLinkList = this.taskService.getIdentityLinksType(taskId);
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    private List<IdentityLink> getIdentityLinkByTaskId(String taskId) {
        return this.taskService.getIdentityLinksType(taskId);
    }

    public List<Map<String, String>> getCallNodeType(String processInsId) {
        List<FlowTask> callNodeType = this.taskEngineMapper.getCallNodeType(Long.parseLong(processInsId));
        ArrayList<Map<String, String>> callNodeTypeList = new ArrayList<Map<String, String>>();
        for (FlowTask flowTask : callNodeType) {
            if (!"main_reject".equals(flowTask.getCompleteType())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("node", flowTask.getTaskDefinitionKey());
            map.put("type", "reject");
            callNodeTypeList.add(map);
        }
        return callNodeTypeList;
    }

    public BpmResponseResult queryProcessByStarter(Page page, ProcessQueryByStarterDto processQueryByStarterDto) {
        Page processPage = new Page();
        if (page == null) {
            processPage.setCurrent(1L).setSize(Integer.MAX_VALUE);
        } else {
            processPage.setCurrent(page.getCurrent()).setSize(page.getSize());
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        if (HussarUtils.isNotEmpty((Object)processQueryByStarterDto.getStarter())) {
            if (HussarUtils.isEmpty((Object)processQueryByStarterDto.getProcessKeyList()) && HussarUtils.isNotEmpty((Object)processQueryByStarterDto.getProcessKey()) && processQueryByStarterDto.getProcessKey().contains(",")) {
                processQueryByStarterDto.setProcessKeyList(Arrays.asList(processQueryByStarterDto.getProcessKey().split(",")));
                processQueryByStarterDto.setProcessKey(null);
            }
            if (HussarUtils.isEmpty((Object)processQueryByStarterDto.getBusinessIdList()) && HussarUtils.isNotEmpty((Object)processQueryByStarterDto.getBusinessId()) && processQueryByStarterDto.getBusinessId().contains(",")) {
                processQueryByStarterDto.setBusinessIdList(Arrays.asList(processQueryByStarterDto.getBusinessId().split(",")));
                processQueryByStarterDto.setBusinessId(null);
            }
            if (HussarUtils.isNotEmpty((Object)processQueryByStarterDto.getEndTime())) {
                long endTime = processQueryByStarterDto.getEndTime().getTime() + 999L;
                Date endTimeDate = new Date(endTime);
                processQueryByStarterDto.setEndTime(endTimeDate);
            }
            List<ProcessInstVo> list = this.instanceEngineMapper.queryProcessByStarter((Page<ProcessInstVo>)processPage, processQueryByStarterDto);
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).setStarter(processQueryByStarterDto.getStarter());
            }
            jsonObject.put("data", list);
            jsonObject.put("count", (Object)processPage.getTotal());
            jsonArray.add((Object)jsonObject);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryCompletecomment(String businessId, String processInsId) {
        BpmResponseResult bpmResponseResult = new BpmResponseResult();
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return bpmResponseResult;
            }
        }
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL.getMessage(), null);
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().finished().asc()).list();
        return this.getResult(hisTaskList, true, false);
    }

    public BpmResponseResult revokeProcess(ProcessRevokeDto processRevokeDto) {
        if (HussarUtils.isEmpty((Object)processRevokeDto.getStartUserId())) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        HistoricProcessInstance processInstance = this.getProcessInst(processRevokeDto.getProcessInsId(), processRevokeDto.getBusinessId(), processRevokeDto.getTaskId(), true);
        if (HussarUtils.isNotEmpty((Object)processInstance.getSuperProcessInstanceId())) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_CALL_ACTIVITY_REVOKE);
        }
        if (!processInstance.getStartUserId().equals(processRevokeDto.getStartUserId())) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_START_USER);
        }
        if (!processRevokeDto.getIsForce()) {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId())).list();
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                throw new BpmException(BpmExceptionCodeEnum.FORBID_PROCESS_REVOKE);
            }
        }
        String businessId = processInstance.getBusinessKey();
        String processDefinitionId = processInstance.getProcessDefinitionId();
        String userId = processRevokeDto.getStartUserId();
        this.processEngine.getManagementService().executeCommand(new ProcessEndCmd(processRevokeDto.getStartUserId(), null, processRevokeDto.getReason(), processInstance.getId(), businessId, processDefinitionId, "revokeProcess", true).addExecutionAttribute("revokeProcess", true).addSendUser(userId));
        this.handleMainProcessTask(userId, processInstance.getId());
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private void multiDeleteByProcIdList(List<Long> allProcId, Map<String, String> businessMap, Set<String> processDefinitionIdList) {
        List allStringProcId = allProcId.stream().map(e -> String.valueOf(e)).collect(Collectors.toList());
        List list = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(allStringProcId)).list();
        List emulationProcess = list.stream().filter(e -> "1".equals(e.getIsEmulation())).collect(Collectors.toList());
        List emulationProcessInsIds = emulationProcess.stream().map(HistoricProcessInstance::getId).collect(Collectors.toList());
        List emulationBusinessKey = emulationProcess.stream().map(HistoricProcessInstance::getBusinessKey).collect(Collectors.toList());
        List<Long> taskIdList = this.instanceEngineMapper.selectTaskIdByProcInstIdList(allProcId);
        this.instanceEngineMapper.deleteHiComment(allProcId, taskIdList);
        this.instanceEngineMapper.deleteHiDetail(allProcId);
        this.instanceEngineMapper.deleteHiActinst(allProcId);
        this.instanceEngineMapper.deleteHiIdentityLink(allProcId, taskIdList);
        this.instanceEngineMapper.deleteHiTaskinst(allProcId);
        this.instanceEngineMapper.deleteHiVarinst(allProcId);
        this.instanceEngineMapper.deleteRuIdentityLink(allProcId, taskIdList);
        this.instanceEngineMapper.deleteRuTask(allProcId);
        this.instanceEngineMapper.deleteRuVariable(allProcId);
        this.instanceEngineMapper.deleteRuExecution(allProcId);
        this.instanceEngineMapper.deleteCcTask(allProcId);
        this.instanceEngineMapper.deleteHiLine(allProcId);
        this.instanceEngineMapper.deleteUrgeTask(allProcId);
        this.instanceEngineMapper.deleteHiProcinst(allProcId);
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessMap(businessMap);
            dataPush.setProcessInsId(StringUtils.join((Object[])allProcId.toArray(), (String)","));
            dataPush.setProcessState("deleteProcess");
            dataPush.setEmulationBusinessKey(emulationBusinessKey);
            dataPush.setEmulationProcessInsIds(emulationProcessInsIds);
            this.dataPushService.deleteDataPush(dataPush);
            this.dataPushService.changeProcessStateDataPush(dataPush);
            DataPush dataPushTemp = new DataPush();
            dataPushTemp.setProcessInsId(StringUtils.join((Object[])allProcId.toArray(), (String)","));
            this.dataPushService.deleteStartProcess(dataPushTemp);
        }
    }

    public BpmResponseResult queryProcessInstance(ProcessDto processDto) {
        String processInstId = processDto.getProcessInsId();
        String businessId = processDto.getBusinessId();
        String taskId = processDto.getTaskId();
        HistoricProcessInstance historicProcessInstance = this.getProcessInst(processInstId, businessId, taskId, null);
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        resMap.put("processInsId", historicProcessInstance.getId());
        resMap.put("businessId", historicProcessInstance.getBusinessKey());
        resMap.put("startTime", historicProcessInstance.getStartTime());
        resMap.put("endTime", historicProcessInstance.getEndTime());
        resMap.put("startUser", historicProcessInstance.getStartUserId());
        resMap.put("processDefinitionId", historicProcessInstance.getProcessDefinitionId());
        resMap.put("processDefinitionName", historicProcessInstance.getProcessDefinitionName());
        resMap.put("processKey", historicProcessInstance.getProcessDefinitionKey());
        List taskList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(historicProcessInstance.getId())).list();
        if (!taskList.isEmpty()) {
            ArrayList taskUser;
            ArrayList<Map<String, String>> todo = new ArrayList<Map<String, String>>();
            ArrayList<Map<String, String>> done = new ArrayList<Map<String, String>>();
            HashSet<String> userId = new HashSet<String>();
            for (HistoricTaskInstance task : taskList) {
                Map<String, String> taskMap = new HashMap<String, String>();
                taskMap.put("taskId", task.getId());
                taskMap.put("taskDefinitionKey", task.getTaskDefinitionKey());
                taskMap.put("startTime", (String)((Object)task.getCreateTime()));
                taskMap.put("sendUser", task.getSendUser());
                userId.add(task.getSendUser());
                taskMap.put("todoConfiguration", task.getTodoConfiguration());
                taskMap.put("taskType", task.getTaskType());
                if (task.getEndTime() != null) {
                    userId.add(task.getAssignee());
                    taskUser = new ArrayList();
                    HashMap<String, String> taskUserMap = new HashMap<String, String>();
                    taskUserMap.put("userId", task.getAssignee());
                    taskUser.add(taskUserMap);
                    taskMap.put("assignee", (String)((Object)taskUser));
                    taskMap.put("endTime", (String)((Object)task.getEndTime()));
                    done.add(taskMap);
                    continue;
                }
                Set userSet = this.taskService.getIdentityLinksType(task.getId()).stream().map(IdentityLink::getUserId).collect(Collectors.toSet());
                if (!userSet.isEmpty()) {
                    userId.addAll(userSet);
                    ArrayList taskUser2 = new ArrayList();
                    for (String taskUserId : userSet) {
                        HashMap<String, String> taskUserMap = new HashMap<String, String>();
                        taskUserMap.put("userId", taskUserId);
                        taskUser2.add(taskUserMap);
                    }
                    taskMap.put("assignee", (String)((Object)taskUser2));
                }
                todo.add(taskMap);
            }
            Map finalUsers = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userId));
            for (Map<String, String> taskMap : todo) {
                if (taskMap.get("assignee") != null) {
                    taskUser = (ArrayList)taskMap.get("assignee");
                    for (Map map : taskUser) {
                        map.put("userName", finalUsers.get(map.get("userId")));
                    }
                }
                if (taskMap.get("sendUser") == null) continue;
                taskMap.put("sendUserName", (String)finalUsers.get(taskMap.get("sendUser")));
            }
            for (Map<String, String> taskMap : done) {
                if (taskMap.get("assignee") == null) continue;
                taskUser = (List)taskMap.get("assignee");
                for (Map map : taskUser) {
                    map.put("userName", finalUsers.get(map.get("userId")));
                }
            }
            resMap.put("todo", todo);
            resMap.put("done", done);
        }
        if (historicProcessInstance.getStartUserId() != null) {
            resMap.put("startUserName", this.iAssigneeChooseService.getUserNames(Collections.singletonList(historicProcessInstance.getStartUserId())));
        }
        return InstallResult.success(resMap);
    }

    public BpmResponseResult queryAllCountersignNodes(CountersignNodesDto countersignNodesBean) {
        HistoricProcessInstance processInstance;
        String taskId = countersignNodesBean.getTaskId();
        String processInsId = countersignNodesBean.getProcessInsId();
        String businessId = countersignNodesBean.getBusinessId();
        String processKey = countersignNodesBean.getProcessKey();
        String version = countersignNodesBean.getVersion();
        String processDefinitionId = null;
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            taskId = RealTaskId.getRealTaskId(taskId);
            Task task = this.taskEngineService.getTask(taskId, "0");
            processDefinitionId = task.getProcessDefinitionId();
        } else if (HussarUtils.isNotEmpty((Object)processInsId)) {
            processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            processDefinitionId = processInstance.getProcessDefinitionId();
        } else if (HussarUtils.isNotEmpty((Object)businessId)) {
            processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            processDefinitionId = processInstance.getProcessDefinitionId();
        }
        Integer versionInt = HussarUtils.isNotEmpty((Object)version) ? Integer.valueOf(Integer.parseInt(version)) : null;
        if (processDefinitionId == null && versionInt == null) {
            processDefinitionId = WorkflowOrganProcessUtil.getStartOrganProcessId(processKey, null, countersignNodesBean.getUserId(), countersignNodesBean.getOrganId(), true);
        }
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(processKey, processDefinitionId, false, versionInt, false);
        if (HussarUtils.isNotEmpty((Object)version) && workFlow == null) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_VERSION_NOT_FOUND.getMessage(), null);
        }
        if (workFlow == null) {
            return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.PROCESS_NOT_FOUND.getMessage(), null);
        }
        FlowModel w = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class, (Feature[])new Feature[0]);
        List elements = w.getSlots().getElement();
        JSONArray json = new JSONArray();
        for (int i = 0; i < elements.size(); ++i) {
            JSONObject object = new JSONObject();
            if (BpmNodeTypeUtil.isSubProcess((String)((FlowObject)elements.get(i)).getName())) {
                JSONObject o = new JSONObject();
                if (((FlowObject)elements.get(i)).getProps().getFlowCountersign() != null && ((FlowObject)elements.get(i)).getProps().getFlowCountersign().isCountersign()) {
                    o.put("multi_type", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignType());
                    o.put("taskDefinitionKey", (Object)((FlowObject)elements.get(i)).getInstanceKey());
                    o.put("taskDefinitionName", (Object)((FlowObject)elements.get(i)).getProps().getFlowName());
                    o.put("taskDefinitionType", (Object)"SubProcess");
                    if ("radio".equals(o.get((Object)"multi_type"))) {
                        o.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByRatio());
                    } else {
                        o.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByCount());
                    }
                    json.add((Object)o);
                }
                List elements2 = ((FlowObject)elements.get(i)).getSlots().getElement();
                for (int j = 0; j < elements2.size(); ++j) {
                    if (((FlowObject)elements2.get(j)).getProps().getFlowCountersign() == null || !((FlowObject)elements2.get(j)).getProps().getFlowCountersign().isCountersign()) continue;
                    object.put("multi_type", (Object)((FlowObject)elements2.get(j)).getProps().getFlowCountersign().getCountersignType());
                    object.put("taskDefinitionKey", (Object)((FlowObject)elements2.get(j)).getInstanceKey());
                    object.put("taskDefinitionName", (Object)((FlowObject)elements2.get(j)).getProps().getFlowName());
                    object.put("subProcessDefId", (Object)((FlowObject)elements.get(i)).getInstanceKey());
                    object.put("subProcessDefName", (Object)((FlowObject)elements.get(i)).getProps().getFlowName());
                    object.put("taskDefinitionType", (Object)"UserTask");
                    if ("radio".equals(object.get((Object)"multi_type"))) {
                        object.put("multi_finish_condition", (Object)((FlowObject)elements2.get(j)).getProps().getFlowCountersign().getCountersignNumByRatio());
                    } else {
                        object.put("multi_finish_condition", (Object)((FlowObject)elements2.get(j)).getProps().getFlowCountersign().getCountersignNumByCount());
                    }
                    json.add((Object)object);
                }
                continue;
            }
            if (BpmNodeTypeUtil.isCallActivity((String)((FlowObject)elements.get(i)).getName())) {
                if (((FlowObject)elements.get(i)).getProps().getFlowCountersign() == null || !((FlowObject)elements.get(i)).getProps().getFlowCountersign().isCountersign()) continue;
                object.put("multi_type", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignType());
                object.put("taskDefinitionKey", (Object)((FlowObject)elements.get(i)).getInstanceKey());
                object.put("taskDefinitionName", (Object)((FlowObject)elements.get(i)).getProps().getFlowName());
                object.put("taskDefinitionType", (Object)"CallActivity");
                if ("radio".equals(object.get((Object)"multi_type"))) {
                    object.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByRatio());
                } else {
                    object.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByCount());
                }
                json.add((Object)object);
                continue;
            }
            if (((FlowObject)elements.get(i)).getProps().getFlowCountersign() == null || !((FlowObject)elements.get(i)).getProps().getFlowCountersign().isCountersign()) continue;
            object.put("multi_type", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignType());
            object.put("taskDefinitionKey", (Object)((FlowObject)elements.get(i)).getInstanceKey());
            object.put("taskDefinitionName", (Object)((FlowObject)elements.get(i)).getProps().getFlowName());
            object.put("taskDefinitionType", (Object)"UserTask");
            if ("radio".equals(object.get((Object)"multi_type"))) {
                object.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByRatio());
            } else {
                object.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByCount());
            }
            json.add((Object)object);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryAllCountersignNodes(String taskId, String processInsId, String businessId, String processKey, String version) {
        CountersignNodesDto countersignNodesBean = new CountersignNodesDto();
        countersignNodesBean.setTaskId(taskId);
        countersignNodesBean.setProcessInsId(processInsId);
        countersignNodesBean.setBusinessId(businessId);
        countersignNodesBean.setProcessKey(processKey);
        countersignNodesBean.setVersion(version);
        return this.queryAllCountersignNodes(countersignNodesBean);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BpmResponseResult queryCurrentNodes(String processInstanceId, String businessId) {
        if (HussarUtils.isEmpty((Object)processInstanceId)) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (historicProcessInstance == null) return InstallResult.success((JSONArray)new JSONArray());
            processInstanceId = historicProcessInstance.getId();
        } else {
            void var3_6;
            if (Context.getCommandContext() != null) {
                HistoricProcessInstanceEntity historicProcessInstanceEntity = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInstanceId);
            } else {
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            }
            if (HussarUtils.isEmpty((Object)var3_6)) {
                return InstallResult.success((JSONArray)new JSONArray());
            }
        }
        List<ActInstVo> actInstVoList = this.instanceEngineMapper.queryCurrentNodes(Long.valueOf(processInstanceId));
        ArrayList<ProcessNode> processNodeList = new ArrayList<ProcessNode>();
        HashSet<String> actIdSet = new HashSet<String>();
        for (ActInstVo actInstVo : actInstVoList) {
            ProcessNode processNode = new ProcessNode();
            if ("subProcess".equals(actInstVo.getActType())) {
                processNode.setTaskDefinitionKey(actInstVo.getActId());
                processNode.setTaskDefinitionName(actInstVo.getActName());
                ArrayList<ProcessNode> childrenList = new ArrayList<ProcessNode>();
                List<ActInstVo> subProcessActInstVoList = this.instanceEngineMapper.querySubProcessCurrentNodes(Long.valueOf(processInstanceId), actInstVo.getSubProcessKey());
                for (ActInstVo subActInstVo : subProcessActInstVoList) {
                    ProcessNode subProcessNode = new ProcessNode();
                    subProcessNode.setTaskDefinitionKey(subActInstVo.getActId());
                    subProcessNode.setTaskDefinitionName(subActInstVo.getActName());
                    childrenList.add(subProcessNode);
                }
                processNode.setChildrenList(childrenList);
            } else {
                if (actIdSet.contains(actInstVo.getActId())) continue;
                processNode.setTaskDefinitionKey(actInstVo.getActId());
                processNode.setTaskDefinitionName(actInstVo.getActName());
                actIdSet.add(actInstVo.getActId());
            }
            processNodeList.add(processNode);
        }
        JSONObject object = new JSONObject();
        object.put("currentNodes", processNodeList);
        JSONArray json = new JSONArray();
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BpmResponseResult queryFlowHistoryInfo(String businessId, String processInstId) {
        void var18_26;
        HistoricProcessInstance historicProcessInstance;
        if (HussarUtils.isEmpty((Object)processInstId)) {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (historicProcessInstance == null) return InstallResult.success((JSONArray)new JSONArray());
            processInstId = historicProcessInstance.getId();
        } else {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstId).singleResult();
            if (HussarUtils.isEmpty((Object)historicProcessInstance)) {
                return InstallResult.success((JSONArray)new JSONArray());
            }
        }
        List<HistoricTaskInstance> hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstId)).queryChildTask()).list();
        hisTaskList = hisTaskList.stream().filter(historicTaskInstance -> !"2".equals(historicTaskInstance.getTaskType())).collect(Collectors.toList());
        hisTaskList.sort((o1, o2) -> {
            if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
            }
            if (o1.getEndTime() == null && o2.getEndTime() != null) {
                return o2.getEndTime().compareTo(new Date(0L));
            }
            if (o1.getEndTime() != null && o2.getEndTime() == null) {
                return new Date(0L).compareTo(o1.getEndTime());
            }
            if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
            }
            return o1.getEndTime().compareTo(o2.getEndTime());
        });
        Date startTime = historicProcessInstance.getStartTime();
        JSONArray json = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        JSONArray completeList = new JSONArray();
        HashSet<String> userSet = new HashSet<String>();
        if (hisTaskList == null || hisTaskList.isEmpty()) return InstallResult.success((JSONArray)json);
        ArrayList<Long> hisTaskIds = new ArrayList<Long>();
        for (HistoricTaskInstance hisTask : hisTaskList) {
            if (hisTask.getEndTime() == null) continue;
            hisTaskIds.add(Long.parseLong(hisTask.getId()));
        }
        List<Object> commentsMap = new ArrayList();
        List extendDataMap = new ArrayList();
        if (HussarUtils.isNotEmpty(hisTaskIds)) {
            commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
            extendDataMap = this.extendDataService.getExtendData(hisTaskIds);
        }
        HashMap<String, String> taskComment = new HashMap<String, String>();
        HashMap extendData = new HashMap();
        for (TaskCommentVO taskCommentVO : commentsMap) {
            taskComment.put(String.valueOf(taskCommentVO.getTaskId()), taskCommentVO.getFullMessage() == null ? taskCommentVO.getMessage() : taskCommentVO.getFullMessage());
        }
        for (Map map : extendDataMap) {
            HashMap item = new HashMap();
            for (String key : map.keySet()) {
                if ("taskId".equals(key)) continue;
                item.put(key, map.get(key));
            }
            extendData.put(String.valueOf(map.get("taskId")), item);
        }
        LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
        ccQueryWrapper.in(SysActCcTask::getProcessInsId, new Object[]{historicProcessInstance.getId()});
        ccQueryWrapper.select(new SFunction[]{SysActCcTask::getReceiveUser, SysActCcTask::getTaskState, SysActCcTask::getEndTime, SysActCcTask::getTaskId});
        List list = this.iSysActCcTaskService.list((Wrapper)ccQueryWrapper);
        for (SysActCcTask sysActCcTask2 : list) {
            userSet.add(sysActCcTask2.getReceiveUser());
        }
        ArrayList runningTaskIds = new ArrayList();
        hisTaskList.forEach(o -> {
            if (TaskStateType.isEntrust((HistoricTaskInstance)o) && HussarUtils.isNotEmpty((Object)o.getOwner())) {
                userSet.add(o.getOwner());
            }
            if (HussarUtils.isNotEmpty((Object)o.getAssignee())) {
                userSet.add(o.getAssignee());
            }
            if (HussarUtils.isEmpty((Object)o.getEndTime())) {
                runningTaskIds.add(Long.valueOf(o.getId()));
            }
            if (HussarUtils.isNotEmpty((Object)o.getReceiver())) {
                userSet.add(o.getReceiver());
            }
            if (HussarUtils.isNotEmpty((Object)o.getAddAssigneeOperator())) {
                userSet.add(o.getAddAssigneeOperator());
            }
            if (HussarUtils.isNotEmpty((Object)o.getAddDelAssignees())) {
                userSet.addAll(Arrays.asList(o.getAddDelAssignees().split(",")));
            }
        });
        ArrayList arrayList = new ArrayList();
        if (!runningTaskIds.isEmpty()) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(BpmActRuIdentitylink::getTaskId, runningTaskIds);
            lambdaQueryWrapper.eq(BpmActRuIdentitylink::getType, (Object)"candidate");
            lambdaQueryWrapper.select(new SFunction[]{BpmActRuIdentitylink::getUserId, BpmActRuIdentitylink::getTaskId, BpmActRuIdentitylink::getMandator});
            List list2 = this.bpmActRuIdentitylinkMapper.selectList((Wrapper)lambdaQueryWrapper);
        }
        HashMap<String, List> todoUserMap = new HashMap<String, List>();
        for (BpmActRuIdentitylink identityLink : var18_26) {
            if (HussarUtils.isNotEmpty((Object)identityLink.getMandator())) {
                userSet.add(identityLink.getMandator());
            }
            userSet.add(identityLink.getUserId());
            todoUserMap.computeIfAbsent(String.valueOf(identityLink.getTaskId()), k -> new ArrayList()).add(identityLink);
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userSet));
        Date current = new Date();
        boolean isEndProcess = false;
        Date latestTime = startTime;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (HistoricTaskInstance hsi : hisTaskList) {
            JSONObject object = new JSONObject();
            if (hsi.getEndTime() != null) {
                String owner;
                String user;
                String userId;
                if (hsi.getAssignee() != null) {
                    userId = hsi.getAssignee() == null ? "" : hsi.getAssignee();
                    user = finalUsersMap.get(hsi.getAssignee()) == null ? BpmExceptionCodeEnum.NULL_COMPLETE.getMessage() : (String)finalUsersMap.get(hsi.getAssignee());
                } else {
                    userId = "";
                    user = BpmExceptionCodeEnum.NULL_COMPLETE.getMessage();
                }
                object.put("userId", (Object)userId);
                object.put("userName", (Object)user);
                String taskSourceFlag = hsi.getTaskSourceFlag();
                if ("reject_revoke".equals(taskSourceFlag)) {
                    taskSourceFlag = "revoke";
                }
                object.put("completeType", (Object)(taskSourceFlag == null ? "" : taskSourceFlag));
                object.put("completeTypeName", (Object)InstanceEngineServiceImpl.getStrTaskSourceFlag(taskSourceFlag));
                if (HussarUtils.isNotEmpty((Object)hsi.getReceiver())) {
                    String receiverId = hsi.getReceiver();
                    object.put("receiverId", (Object)receiverId);
                    object.put("receiverName", finalUsersMap.get(receiverId));
                }
                if (TaskStateType.isEntrust((HistoricTaskInstance)hsi) && HussarUtils.isNotEmpty((Object)(owner = hsi.getOwner()))) {
                    String ownerName = (String)finalUsersMap.get(owner);
                    object.put("owner", (Object)owner);
                    object.put("ownerName", (Object)ownerName);
                }
                if (HussarUtils.isNotEmpty((Object)hsi.getAddDelAssignees())) {
                    String addDelAssignees = hsi.getAddDelAssignees();
                    List<String> addDelAssigneeList = Arrays.asList(addDelAssignees.split(","));
                    List addDelAssigneeNameList = addDelAssigneeList.stream().map(assignee -> (String)finalUsersMap.get(assignee)).collect(Collectors.toList());
                    object.put("addDelAssignees", addDelAssigneeList);
                    object.put("addDelAssigneesName", addDelAssigneeNameList);
                }
                object.put("completeTime", (Object)sdf.format(hsi.getEndTime()));
                object.put("duration", (Object)hsi.getDurationInMillis());
                String nullCommont = BpmExceptionCodeEnum.NULL_COMMENT.getMessage();
                String comment = (String)taskComment.get(hsi.getId());
                object.put("comment", comment == null ? nullCommont : comment);
                if (HussarUtils.isNotEmpty(extendData.get(hsi.getId()))) {
                    for (String key : ((Map)extendData.get(hsi.getId())).keySet()) {
                        object.put(key, ((Map)extendData.get(hsi.getId())).get(key));
                    }
                }
                object.put("nodeType", (Object)"userTask");
                object.put("taskType", (Object)"done");
                if (hsi.getEndTime().getTime() >= latestTime.getTime()) {
                    isEndProcess = "endProcess".equals(taskSourceFlag);
                    latestTime = hsi.getEndTime();
                }
            } else {
                String errorMsg;
                String userIds;
                List identityLinks = (List)todoUserMap.get(hsi.getId());
                ArrayList<String> userIdList = new ArrayList<String>();
                ArrayList<String> userNameList = new ArrayList<String>();
                JSONArray entrustInfo = new JSONArray();
                if (HussarUtils.isNotEmpty((Object)identityLinks)) {
                    for (BpmActRuIdentitylink identityLink : identityLinks) {
                        String userId = identityLink.getUserId();
                        String userName = (String)finalUsersMap.get(userId);
                        userIdList.add(userId);
                        userNameList.add(userName);
                        if (!TaskStateType.isEntrust((String)identityLink.getTaskState())) continue;
                        JSONObject obj = new JSONObject();
                        String mandator = identityLink.getMandator();
                        String mandatorName = (String)finalUsersMap.get(mandator);
                        obj.put("mandator", (Object)mandator);
                        obj.put("mandatorName", (Object)mandatorName);
                        obj.put("mandatary", (Object)userId);
                        obj.put("mandataryName", (Object)userName);
                        entrustInfo.add((Object)obj);
                    }
                } else if (HussarUtils.isNotEmpty((Object)hsi.getAssignee())) {
                    userIdList.add(hsi.getAssignee());
                    userNameList.add((String)finalUsersMap.get(hsi.getAssignee()));
                }
                object.put("userId", (Object)(HussarUtils.isEmpty((Object)(userIds = String.join((CharSequence)",", userIdList))) ? "" : userIds));
                String userNames = String.join((CharSequence)",", userNameList);
                object.put("userName", (Object)(HussarUtils.isEmpty((Object)userNames) ? BpmExceptionCodeEnum.NULL_COMPLETE.getMessage() : userNames));
                if (HussarUtils.isNotEmpty((Object)entrustInfo)) {
                    object.put("entrustInfo", (Object)entrustInfo);
                }
                object.put("nodeType", (Object)"userTask");
                object.put("taskType", (Object)"todo");
                Map<String, Map<String, Long>> timeOutMsg = InstanceEngineServiceImpl.getTimeOutMsg(current, hsi.getWarningDate(), hsi.getDueDate());
                if (HussarUtils.isNotEmpty(timeOutMsg)) {
                    object.put("timeOutMsg", timeOutMsg);
                }
                if (HussarUtils.isNotEmpty((Object)(errorMsg = hsi.getErrorMsg()))) {
                    object.put("errorMsg", (Object)errorMsg);
                }
            }
            object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
            object.put("taskDefinitionName", (Object)hsi.getName());
            object.put("createTime", (Object)sdf.format(hsi.getStartTime()));
            List ccTasks = list.stream().filter(sysActCcTask -> hsi.getId().equals(String.valueOf(sysActCcTask.getTaskId()))).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(ccTasks)) {
                JSONObject ccObject = new JSONObject();
                JSONArray userInfo = new JSONArray();
                for (SysActCcTask sysActCcTask3 : ccTasks) {
                    JSONObject obj = new JSONObject();
                    obj.put("userId", (Object)sysActCcTask3.getReceiveUser());
                    obj.put("userName", finalUsersMap.get(sysActCcTask3.getReceiveUser()));
                    obj.put("readState", (Object)sysActCcTask3.getTaskState());
                    obj.put("readTime", (Object)sysActCcTask3.getEndTime());
                    userInfo.add((Object)obj);
                }
                ccObject.put("userInfo", (Object)userInfo);
                ccObject.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                ccObject.put("taskDefinitionName", (Object)hsi.getName());
                ccObject.put("createTime", (Object)sdf.format(hsi.getStartTime()));
                ccObject.put("nodeType", (Object)"ccTask");
                completeList.add((Object)ccObject);
            }
            completeList.add((Object)object);
        }
        jsonObject.put("completeList", (Object)completeList);
        Date finishTime = historicProcessInstance.getEndTime();
        if (HussarUtils.isNotEmpty((Object)finishTime)) {
            jsonObject.put("finishTime", (Object)sdf.format(finishTime));
            if (isEndProcess) {
                jsonObject.put("processState", (Object)"\u5ba1\u6279\u7ec8\u6b62");
            } else {
                jsonObject.put("processState", (Object)"\u5ba1\u6279\u901a\u8fc7");
            }
        }
        jsonObject.put("startTime", (Object)sdf.format(startTime));
        json.add((Object)jsonObject);
        return InstallResult.success((JSONArray)json);
    }

    private static Map<String, Map<String, Long>> getTimeOutMsg(Date currentTime, Date warningTime, Date dueTime) {
        HashMap<String, Map<String, Long>> timeOutMsg = new HashMap<String, Map<String, Long>>();
        HashMap<String, Long> timeMsg = new HashMap<String, Long>();
        timeMsg.put("years", 0L);
        timeMsg.put("months", 0L);
        timeMsg.put("days", 0L);
        timeMsg.put("hours", 0L);
        timeMsg.put("minutes", 0L);
        if (dueTime == null) {
            return null;
        }
        if (warningTime != null && currentTime.after(warningTime) && currentTime.before(dueTime)) {
            long leave = dueTime.getTime() - currentTime.getTime();
            long years = leave / 1000L / 60L / 60L / 24L / 30L / 12L;
            long months = leave / 1000L / 60L / 60L / 24L / 30L % 12L;
            long days = leave / 1000L / 60L / 60L / 24L % 30L;
            long hours = leave / 1000L / 60L / 60L % 24L;
            long minutes = leave / 1000L / 60L % 60L;
            if (years > 0L) {
                timeMsg.put("years", years);
            }
            if (months > 0L) {
                timeMsg.put("months", months);
            }
            if (days > 0L) {
                timeMsg.put("days", days);
            }
            if (hours > 0L) {
                timeMsg.put("hours", hours);
            }
            if (minutes > 0L) {
                timeMsg.put("minutes", minutes);
            }
            timeOutMsg.put("warning", timeMsg);
            return timeOutMsg;
        }
        if (currentTime.after(dueTime)) {
            long leave = currentTime.getTime() - dueTime.getTime();
            long years = leave / 1000L / 60L / 60L / 24L / 30L / 12L;
            long months = leave / 1000L / 60L / 60L / 24L / 30L % 12L;
            long days = leave / 1000L / 60L / 60L / 24L % 30L;
            long hours = leave / 1000L / 60L / 60L % 24L;
            long minutes = leave / 1000L / 60L % 60L;
            if (years > 0L) {
                timeMsg.put("years", years);
            }
            if (months > 0L) {
                timeMsg.put("months", months);
            }
            if (days > 0L) {
                timeMsg.put("days", days);
            }
            if (hours > 0L) {
                timeMsg.put("hours", hours);
            }
            if (minutes > 0L) {
                timeMsg.put("minutes", minutes);
            }
            timeOutMsg.put("outTime", timeMsg);
            return timeOutMsg;
        }
        return null;
    }

    private HistoricProcessInstance getProcessInst(String processInstId, String businessKey, String taskId, Boolean isUnFinish) {
        HistoricProcessInstance processInstance;
        if (HussarUtils.isAllEmpty((Object[])new Object[]{processInstId, businessKey, taskId})) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        if (HussarUtils.isEmpty((Object)processInstId)) {
            if (HussarUtils.isNotEmpty((Object)businessKey)) {
                processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
            } else {
                HistoricTaskInstance taskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
                if (taskInstance == null) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND);
                }
                processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(taskInstance.getProcessInstanceId()).singleResult();
            }
        } else {
            processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstId).singleResult();
        }
        if (processInstance == null) {
            throw new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_START);
        }
        if (isUnFinish != null) {
            if (isUnFinish.booleanValue()) {
                if (processInstance.getEndTime() != null) {
                    throw new BpmException(BpmExceptionCodeEnum.PROCESS_END);
                }
            } else if (processInstance.getEndTime() == null) {
                throw new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_END);
            }
        }
        return processInstance;
    }

    public JSONObject getProcessShowMsg(String processInsId, String businessId, boolean isFirstQuery) {
        ProcessInstance instance;
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        if (HussarUtils.isEmpty((Object)processInsId)) {
            if (HussarUtils.isEmpty((Object)businessId)) {
                return new JSONObject();
            }
            historicProcessInstanceQuery.processInstanceBusinessKey(businessId);
        } else {
            historicProcessInstanceQuery.processInstanceId(processInsId);
        }
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historicProcessInstanceQuery.singleResult();
        if (processInstance == null) {
            return new JSONObject();
        }
        processInsId = processInstance.getId();
        JSONObject result = new JSONObject();
        boolean suspended = false;
        if (processInstance.getEndTime() == null && (instance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInsId).singleResult()) != null) {
            suspended = instance.isSuspended();
        }
        JSONArray allProcessMsg = new JSONArray();
        result.put("allProcessMsg", (Object)allProcessMsg);
        JSONObject processMsg = new JSONObject();
        processMsg.put("processDefinitionName", (Object)processInstance.getProcessDefinitionName());
        processMsg.put("processInsId", (Object)processInstance.getId());
        processMsg.put("businessId", (Object)processInstance.getBusinessKey());
        if (processInstance.getEndTime() == null) {
            if (processInstance.getDueDate() != null) {
                processMsg.put("dueTime", (Object)processInstance.getDueDate());
            }
            if (processInstance.getDueDate() != null && processInstance.getDueDate().getTime() < System.currentTimeMillis()) {
                processMsg.put("state", (Object)"overtime");
            } else if (suspended) {
                processMsg.put("state", (Object)"suspend");
            } else {
                processMsg.put("state", (Object)NOW_STATE);
            }
        } else {
            processMsg.put("state", (Object)FINISH_STATE);
        }
        allProcessMsg.add((Object)processMsg);
        List callProcessInstances = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).list();
        List allActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).list();
        JSONObject callProcessMsg = new JSONObject();
        result.put("callProcessMsg", (Object)callProcessMsg);
        if (!callProcessInstances.isEmpty()) {
            block0: for (HistoricProcessInstance callProcessInstance : callProcessInstances) {
                JSONObject callProcessMessage = new JSONObject();
                callProcessMessage.put("businessId", (Object)callProcessInstance.getBusinessKey());
                callProcessMessage.put("processDefinitionName", (Object)callProcessInstance.getProcessDefinitionName());
                callProcessMessage.put("startTime", (Object)callProcessInstance.getStartTime());
                callProcessMessage.put("endTime", (Object)callProcessInstance.getEndTime());
                callProcessMessage.put("processDefinitionId", (Object)callProcessInstance.getProcessDefinitionId());
                callProcessMessage.put("processInsId", (Object)callProcessInstance.getId());
                for (HistoricActivityInstance historicActivityInstance : allActivityInstances) {
                    if (!callProcessInstance.getId().equals(historicActivityInstance.getCalledProcessInstanceId())) continue;
                    JSONArray jsonArray = callProcessMsg.getJSONArray(historicActivityInstance.getActivityId());
                    if (jsonArray == null) {
                        jsonArray = new JSONArray();
                        callProcessMsg.put(historicActivityInstance.getActivityId(), (Object)jsonArray);
                    }
                    jsonArray.add((Object)callProcessMessage);
                    continue block0;
                }
            }
        }
        HashMap<String, List> taskListMap = new HashMap<String, List>();
        HashMap<String, List<BpmActRuIdentitylink>> taskUserMap = new HashMap<String, List<BpmActRuIdentitylink>>();
        HashMap<String, List> hisListMap = new HashMap<String, List>();
        HashMap<String, String> commentMap = new HashMap<String, String>();
        HashMap<String, List> runningNodeMap = new HashMap<String, List>();
        HashMap<String, List> finishedNodeMap = new HashMap<String, List>();
        HashMap<String, List> hiLineIdMap = new HashMap<String, List>();
        HashMap<String, String> subProcessInfoMap = new HashMap<String, String>();
        String processDefinitonId = processInstance.getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitonId);
        this.prepareBpmnModel(bpmnModel);
        List allTasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().queryChildTask()).processInstanceId(processInsId)).list();
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (Task task : allTasks) {
            String subProcessKey = task.getSubProcessKey();
            List taskList = taskListMap.computeIfAbsent(subProcessKey, k -> new ArrayList());
            taskList.add(task);
            taskIds.add(Long.valueOf(task.getId()));
        }
        HashSet<String> userList = new HashSet<String>();
        List users = new ArrayList();
        if (!taskIds.isEmpty()) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(BpmActRuIdentitylink::getTaskId, taskIds);
            lambdaQueryWrapper.eq(BpmActRuIdentitylink::getType, (Object)"candidate");
            users = this.bpmActRuIdentitylinkMapper.selectList((Wrapper)lambdaQueryWrapper);
        }
        for (BpmActRuIdentitylink identityLink : users) {
            List list = taskUserMap.computeIfAbsent(String.valueOf(identityLink.getTaskId()), k -> new ArrayList());
            list.add(identityLink);
            if (TaskStateType.isEntrust((String)identityLink.getTaskState())) {
                userList.add(identityLink.getMandator());
            }
            if (HussarUtils.isNotEmpty((Object)identityLink.getAddAssigneeOperator())) {
                userList.add(identityLink.getAddAssigneeOperator());
            }
            userList.add(identityLink.getUserId());
        }
        List hisLists = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
        ArrayList<Long> hisTaskIds = new ArrayList<Long>();
        for (Object historicTaskInstance : hisLists) {
            hisTaskIds.add(Long.valueOf(historicTaskInstance.getId()));
            if (TaskStateType.isEntrust((HistoricTaskInstance)historicTaskInstance) && HussarUtils.isNotEmpty((Object)historicTaskInstance.getOwner())) {
                userList.add(historicTaskInstance.getOwner());
            }
            if (HussarUtils.isNotEmpty((Object)historicTaskInstance.getAssignee())) {
                userList.add(historicTaskInstance.getAssignee());
            }
            String subProcessKey = historicTaskInstance.getSubProcessKey();
            List hisList = hisListMap.computeIfAbsent(subProcessKey, k -> new ArrayList());
            hisList.add(historicTaskInstance);
        }
        List<Object> comments = new ArrayList();
        if (HussarUtils.isNotEmpty(hisTaskIds)) {
            comments = this.taskEngineMapper.getTaskComments(hisTaskIds);
        }
        for (TaskCommentVO taskCommentVO : comments) {
            commentMap.put(taskCommentVO.getTaskId(), taskCommentVO.getFullMessage() == null ? taskCommentVO.getMessage() : taskCommentVO.getFullMessage());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userList));
        HashMap<String, String> nodeState = new HashMap<String, String>();
        HashMap<String, Map> subProcessNodeState = new HashMap<String, Map>();
        boolean containsRunningCallActivity = false;
        for (Object historicActivityInstance : allActivityInstances) {
            List nodeList;
            if (historicActivityInstance.getEndTime() == null) {
                if ("callActivity".equals(historicActivityInstance.getActivityType())) {
                    containsRunningCallActivity = true;
                    nodeList = runningNodeMap.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new ArrayList());
                    nodeList.add(historicActivityInstance.getActivityId());
                    continue;
                }
                if ("subProcess".equals(historicActivityInstance.getActivityType())) {
                    nodeList = runningNodeMap.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new ArrayList());
                    nodeList.add(historicActivityInstance.getActivityId());
                    subProcessInfoMap.computeIfAbsent(historicActivityInstance.getSubProcessKey(), arg_0 -> InstanceEngineServiceImpl.lambda$getProcessShowMsg$45((HistoricActivityInstance)historicActivityInstance, arg_0));
                    continue;
                }
                if (!"receiveTask".equals(historicActivityInstance.getActivityType())) continue;
                nodeList = runningNodeMap.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new ArrayList());
                nodeList.add(historicActivityInstance.getActivityId());
                if (historicActivityInstance.getEndTime() != null || historicActivityInstance.getDueDate() == null || historicActivityInstance.getDueDate().getTime() >= System.currentTimeMillis()) continue;
                if (historicActivityInstance.getSubProcessKey() == null) {
                    nodeState.put(historicActivityInstance.getActivityId(), "overtime");
                    continue;
                }
                subProcessNodeState.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new HashMap()).put(historicActivityInstance.getActivityId(), "overtime");
                continue;
            }
            if ("subProcess".equals(historicActivityInstance.getActivityType())) {
                subProcessInfoMap.computeIfAbsent(historicActivityInstance.getSubProcessKey(), arg_0 -> InstanceEngineServiceImpl.lambda$getProcessShowMsg$48((HistoricActivityInstance)historicActivityInstance, arg_0));
            }
            nodeList = finishedNodeMap.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new ArrayList());
            nodeList.add(historicActivityInstance.getActivityId());
        }
        List sysActHiLines = this.iSysActHiLineService.getSysActHiLineByProcessinsId(processInsId, null, false);
        for (Object sysActHiLine : sysActHiLines) {
            List list = hiLineIdMap.computeIfAbsent(sysActHiLine.getSubProcessKey(), k -> new ArrayList());
            list.add(sysActHiLine.getLineId());
        }
        if (containsRunningCallActivity) {
            List<Map<String, String>> mapList = this.getCallNodeType(processInsId);
            for (Map map : mapList) {
                nodeState.put((String)map.get("node"), HussarUtils.isEmpty(map.get("type")) ? NOW_STATE : (String)map.get("type"));
            }
        }
        Map extensionElementsNode = bpmnModel.getMainProcess().getExtensionElements();
        String width = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasWidth")).get(0)).getAttributes().get("canvasWidth")).get(0)).getValue();
        String string = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasHeight")).get(0)).getAttributes().get("canvasHeight")).get(0)).getValue();
        JSONObject processInfo = new JSONObject();
        processInfo.put("width", (Object)width);
        processInfo.put("height", (Object)string);
        DefinitionModel definitionModel = this.processDefinitionsService.getByVersion(processInstance.getProcessDefinitionId(), null, null);
        processInfo.put("workflowStyle", (Object)definitionModel.getWorkflowStyle());
        processInfo.put("data", (Object)this.getMergeProcessInfo(processInsId, suspended, bpmnModel, bpmnModel.getMainProcess().getFlowElements(), taskListMap.getOrDefault(null, new ArrayList()), runningNodeMap.getOrDefault(null, new ArrayList()), finishedNodeMap.getOrDefault(null, new ArrayList()), nodeState, hiLineIdMap.getOrDefault(null, new ArrayList())));
        result.put("processInfo", (Object)processInfo);
        result.put("processCompleteInfo", (Object)this.getMergeProcessCompleteInfo(taskUserMap, commentMap, finalUsersMap, taskListMap.getOrDefault(null, new ArrayList()), bpmnModel, bpmnModel.getMainProcess().getFlowElements(), hisListMap.getOrDefault(null, new ArrayList())));
        ArrayList subProcessKeys = new ArrayList(finishedNodeMap.keySet());
        subProcessKeys.remove(null);
        JSONObject subProcessMsg = new JSONObject();
        for (String subProcessKey : subProcessKeys) {
            if (HussarUtils.isEmpty((Object)subProcessKey)) continue;
            JSONObject jsonObject = new JSONObject();
            String taskDefinitionKey = subProcessKey.split(":")[0];
            SubProcess subProcess = (SubProcess)bpmnModel.getFlowElement(taskDefinitionKey);
            String subProcessName = (String)subProcessInfoMap.get(subProcessKey);
            jsonObject.put("activityName", (Object)subProcessName);
            jsonObject.put("subProcessInfo", (Object)this.getMergeProcessInfo(processInsId, suspended, bpmnModel, subProcess.getFlowElements(), taskListMap.getOrDefault(subProcessKey, new ArrayList()), runningNodeMap.getOrDefault(subProcessKey, new ArrayList()), finishedNodeMap.getOrDefault(subProcessKey, new ArrayList()), subProcessNodeState.getOrDefault(subProcessKey, new HashMap()), hiLineIdMap.getOrDefault(subProcessKey, new ArrayList())));
            jsonObject.put("subProcessCompleteInfo", (Object)this.getMergeProcessCompleteInfo(taskUserMap, commentMap, finalUsersMap, taskListMap.getOrDefault(subProcessKey, new ArrayList()), bpmnModel, subProcess.getFlowElements(), hisListMap.getOrDefault(subProcessKey, new ArrayList())));
            subProcessMsg.put(subProcessKey, (Object)jsonObject);
        }
        result.put("subProcessMsg", (Object)subProcessMsg);
        return result;
    }

    public JSONObject predictProcessDiagram(String processKey, String processInsId, String businessId, String userId, Map<String, Object> map) {
        if (HussarUtils.isNotEmpty((Object)processInsId) || HussarUtils.isNotEmpty((Object)businessId)) {
            return this.predictRunningProcessShowMsg(processInsId, businessId, userId, map);
        }
        return this.predictUnStartProcessShowMsg(processKey, userId, map);
    }

    private JSONObject predictUnStartProcessShowMsg(String processKey, String userId, Map<String, Object> visitorMap) {
        BpmResponseResult result;
        Map map = null;
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            result = DefinitionEngineService.getProcessMainOrNew((String)processKey);
            map = (Map)result.getResult().get(0);
            if (HussarUtils.isEmpty((Object)map)) {
                throw new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_FOUND);
            }
        } else {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        result = new JSONObject();
        JSONArray allProcessMsg = new JSONArray();
        result.put("allProcessMsg", (Object)allProcessMsg);
        JSONObject processMsg = new JSONObject();
        processMsg.put("processDefinitionName", map.get("processDefinitionName"));
        processMsg.put("processInsId", null);
        processMsg.put("businessId", null);
        processMsg.put("state", (Object)"next");
        allProcessMsg.add((Object)processMsg);
        JSONObject callProcessMsg = new JSONObject();
        result.put("callProcessMsg", (Object)callProcessMsg);
        String processDefinitonId = (String)map.get("processDefinitionId");
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitonId);
        this.prepareBpmnModel(bpmnModel);
        HashMap taskListMap = new HashMap();
        HashMap<String, List<BpmActRuIdentitylink>> taskUserMap = new HashMap<String, List<BpmActRuIdentitylink>>();
        HashMap hisListMap = new HashMap();
        HashMap<String, String> commentMap = new HashMap<String, String>();
        HashMap runningNodeMap = new HashMap();
        HashMap finishedNodeMap = new HashMap();
        HashMap hiLineIdMap = new HashMap();
        HashMap<String, List<String>> predictNodeMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> predictLineIdMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> predictNodeUserMap = new HashMap<String, List<String>>();
        Process process = bpmnModel.getMainProcess();
        Collection flowElements = process.getFlowElements();
        StartEvent startEvent = new StartEvent();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            startEvent = (StartEvent)flowElement;
            break;
        }
        List sequenceFlowList = startEvent.getOutgoingFlows();
        String planNum = "plan_0";
        this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitonId, null, userId, sequenceFlowList, bpmnModel, planNum, visitorMap);
        HashSet userList = new HashSet();
        ArrayList users = new ArrayList();
        if (HussarUtils.isNotEmpty(predictNodeUserMap)) {
            for (Map.Entry entry : predictNodeUserMap.entrySet()) {
                Object value = entry.getValue();
                if (!HussarUtils.isNotEmpty(value) || !(value instanceof List)) continue;
                userList.addAll((List)value);
            }
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userList));
        HashMap<String, String> nodeState = new HashMap<String, String>();
        Map extensionElementsNode = bpmnModel.getMainProcess().getExtensionElements();
        String width = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasWidth")).get(0)).getAttributes().get("canvasWidth")).get(0)).getValue();
        String height = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasHeight")).get(0)).getAttributes().get("canvasHeight")).get(0)).getValue();
        JSONObject processInfo = new JSONObject();
        processInfo.put("width", (Object)width);
        processInfo.put("height", (Object)height);
        DefinitionModel definitionModel = this.processDefinitionsService.getByVersion(processDefinitonId, null, null);
        processInfo.put("workflowStyle", (Object)definitionModel.getWorkflowStyle());
        processInfo.put("data", (Object)this.getMergePredictProcessInfo(null, false, bpmnModel, bpmnModel.getMainProcess().getFlowElements(), taskListMap.getOrDefault(null, new ArrayList()), runningNodeMap.getOrDefault(null, new ArrayList()), finishedNodeMap.getOrDefault(null, new ArrayList()), nodeState, hiLineIdMap.getOrDefault(null, new ArrayList()), predictNodeMap, predictLineIdMap));
        result.put("processInfo", (Object)processInfo);
        result.put("processCompleteInfo", (Object)this.getMergePredictProcessCompleteInfo(taskUserMap, commentMap, finalUsersMap, taskListMap.getOrDefault(null, new ArrayList()), bpmnModel, bpmnModel.getMainProcess().getFlowElements(), hisListMap.getOrDefault(null, new ArrayList()), predictNodeMap, predictNodeUserMap));
        HashMap subProcessNodeState = new HashMap();
        ArrayList subProcessKeys = new ArrayList(finishedNodeMap.keySet());
        subProcessKeys.remove(null);
        JSONObject subProcessMsg = new JSONObject();
        for (String subProcessKey : subProcessKeys) {
            if (HussarUtils.isEmpty((Object)subProcessKey)) continue;
            JSONObject jsonObject = new JSONObject();
            String taskDefinitionKey = subProcessKey.split(":")[0];
            SubProcess subProcess = (SubProcess)bpmnModel.getFlowElement(taskDefinitionKey);
            jsonObject.put("subProcessInfo", (Object)this.getMergePredictProcessInfo(null, false, bpmnModel, subProcess.getFlowElements(), taskListMap.getOrDefault(subProcessKey, new ArrayList()), runningNodeMap.getOrDefault(subProcessKey, new ArrayList()), finishedNodeMap.getOrDefault(subProcessKey, new ArrayList()), subProcessNodeState.getOrDefault(subProcessKey, new HashMap()), hiLineIdMap.getOrDefault(subProcessKey, new ArrayList()), predictNodeMap, predictLineIdMap));
            jsonObject.put("subProcessCompleteInfo", (Object)this.getMergePredictProcessCompleteInfo(taskUserMap, commentMap, finalUsersMap, taskListMap.getOrDefault(subProcessKey, new ArrayList()), bpmnModel, subProcess.getFlowElements(), hisListMap.getOrDefault(subProcessKey, new ArrayList()), predictNodeMap, predictNodeUserMap));
            subProcessMsg.put(subProcessKey, (Object)jsonObject);
        }
        result.put("subProcessMsg", (Object)subProcessMsg);
        return result;
    }

    public JSONObject predictRunningProcessShowMsg(String processInsId, String businessId, String userId, Map<String, Object> visitorMap) {
        ProcessInstance instance;
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        if (HussarUtils.isEmpty((Object)processInsId)) {
            if (HussarUtils.isEmpty((Object)businessId)) {
                return new JSONObject();
            }
            historicProcessInstanceQuery.processInstanceBusinessKey(businessId);
        } else {
            historicProcessInstanceQuery.processInstanceId(processInsId);
        }
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historicProcessInstanceQuery.singleResult();
        if (processInstance == null) {
            return new JSONObject();
        }
        processInsId = processInstance.getId();
        JSONObject result = new JSONObject();
        boolean suspended = false;
        if (processInstance.getEndTime() == null && (instance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInsId).singleResult()) != null) {
            suspended = instance.isSuspended();
        }
        JSONArray allProcessMsg = new JSONArray();
        result.put("allProcessMsg", (Object)allProcessMsg);
        JSONObject processMsg = new JSONObject();
        processMsg.put("processDefinitionName", (Object)processInstance.getProcessDefinitionName());
        processMsg.put("processInsId", (Object)processInstance.getId());
        processMsg.put("businessId", (Object)processInstance.getBusinessKey());
        if (processInstance.getEndTime() == null) {
            if (processInstance.getDueDate() != null && processInstance.getDueDate().getTime() < System.currentTimeMillis()) {
                processMsg.put("state", (Object)"overtime");
            } else if (suspended) {
                processMsg.put("state", (Object)"suspend");
            } else {
                processMsg.put("state", (Object)NOW_STATE);
            }
        } else {
            processMsg.put("state", (Object)FINISH_STATE);
        }
        allProcessMsg.add((Object)processMsg);
        List callProcessInstances = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).list();
        List allActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).list();
        JSONObject callProcessMsg = new JSONObject();
        result.put("callProcessMsg", (Object)callProcessMsg);
        if (!callProcessInstances.isEmpty()) {
            block0: for (HistoricProcessInstance callProcessInstance : callProcessInstances) {
                JSONObject callProcessMessage = new JSONObject();
                callProcessMessage.put("businessId", (Object)callProcessInstance.getBusinessKey());
                callProcessMessage.put("processDefinitionName", (Object)callProcessInstance.getProcessDefinitionName());
                callProcessMessage.put("startTime", (Object)callProcessInstance.getStartTime());
                callProcessMessage.put("endTime", (Object)callProcessInstance.getEndTime());
                callProcessMessage.put("processDefinitionId", (Object)callProcessInstance.getProcessDefinitionId());
                callProcessMessage.put("processInsId", (Object)callProcessInstance.getId());
                for (HistoricActivityInstance historicActivityInstance : allActivityInstances) {
                    if (!callProcessInstance.getId().equals(historicActivityInstance.getCalledProcessInstanceId())) continue;
                    JSONArray jsonArray = callProcessMsg.getJSONArray(historicActivityInstance.getActivityId());
                    if (jsonArray == null) {
                        jsonArray = new JSONArray();
                        callProcessMsg.put(historicActivityInstance.getActivityId(), (Object)jsonArray);
                    }
                    jsonArray.add((Object)callProcessMessage);
                    continue block0;
                }
            }
        }
        HashMap<String, List> taskListMap = new HashMap<String, List>();
        HashMap<String, List<BpmActRuIdentitylink>> taskUserMap = new HashMap<String, List<BpmActRuIdentitylink>>();
        HashMap<String, List> hisListMap = new HashMap<String, List>();
        HashMap<String, String> commentMap = new HashMap<String, String>();
        HashMap<String, List> runningNodeMap = new HashMap<String, List>();
        HashMap<String, List> finishedNodeMap = new HashMap<String, List>();
        HashMap<String, List> hiLineIdMap = new HashMap<String, List>();
        HashMap<String, List<String>> predictNodeMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> predictLineIdMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> predictNodeUserMap = new HashMap<String, List<String>>();
        String processDefinitonId = processInstance.getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitonId);
        this.prepareBpmnModel(bpmnModel);
        List allTasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().queryChildTask()).processInstanceId(processInsId)).list();
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (Task task : allTasks) {
            String subProcessKey = task.getSubProcessKey();
            List list = taskListMap.computeIfAbsent(subProcessKey, k -> new ArrayList());
            list.add(task);
            taskIds.add(Long.valueOf(task.getId()));
        }
        if (!suspended && HussarUtils.isNotEmpty((Object)allTasks)) {
            for (Task task : allTasks) {
                String submitToRejectNode = task.getSubmitToRejectNode();
                if ("1".equals(submitToRejectNode)) {
                    JumpInfo jumpInfo = JumpInfo.toJumpInfo((String)task.getJumpInfo());
                    List jumpFrom = jumpInfo.getJumpFrom();
                    if (!HussarUtils.isNotEmpty((Object)jumpFrom)) continue;
                    for (String id : jumpFrom) {
                        String planNum = "plan_0";
                        this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitonId, id, userId, null, bpmnModel, planNum, visitorMap);
                    }
                    continue;
                }
                UserTask userTask = (UserTask)bpmnModel.getFlowElement(task.getTaskDefinitionKey());
                List sequenceFlows = userTask.getOutgoingFlows();
                String planNum = "plan_0";
                this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitonId, null, userId, sequenceFlows, bpmnModel, planNum, visitorMap);
            }
        }
        HashSet<String> userList = new HashSet<String>();
        List users = new ArrayList();
        if (!taskIds.isEmpty()) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(BpmActRuIdentitylink::getTaskId, taskIds);
            lambdaQueryWrapper.eq(BpmActRuIdentitylink::getType, (Object)"candidate");
            users = this.bpmActRuIdentitylinkMapper.selectList((Wrapper)lambdaQueryWrapper);
        }
        for (BpmActRuIdentitylink bpmActRuIdentitylink : users) {
            List list = taskUserMap.computeIfAbsent(String.valueOf(bpmActRuIdentitylink.getTaskId()), k -> new ArrayList());
            list.add(bpmActRuIdentitylink);
            if (TaskStateType.isEntrust((String)bpmActRuIdentitylink.getTaskState())) {
                userList.add(bpmActRuIdentitylink.getMandator());
            }
            userList.add(bpmActRuIdentitylink.getUserId());
        }
        if (HussarUtils.isNotEmpty(predictNodeUserMap)) {
            for (Map.Entry entry : predictNodeUserMap.entrySet()) {
                Object value = entry.getValue();
                if (!HussarUtils.isNotEmpty(value) || !(value instanceof List)) continue;
                userList.addAll((List)value);
            }
        }
        List hisLists = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Object historicTaskInstance : hisLists) {
            arrayList.add(Long.valueOf(historicTaskInstance.getId()));
            if (TaskStateType.isEntrust((HistoricTaskInstance)historicTaskInstance) && HussarUtils.isNotEmpty((Object)historicTaskInstance.getOwner())) {
                userList.add(historicTaskInstance.getOwner());
            }
            if (HussarUtils.isNotEmpty((Object)historicTaskInstance.getAssignee())) {
                userList.add(historicTaskInstance.getAssignee());
            }
            String subProcessKey = historicTaskInstance.getSubProcessKey();
            List hisList = hisListMap.computeIfAbsent(subProcessKey, k -> new ArrayList());
            hisList.add(historicTaskInstance);
        }
        List<Object> comments = new ArrayList();
        if (HussarUtils.isNotEmpty(arrayList)) {
            comments = this.taskEngineMapper.getTaskComments(arrayList);
        }
        for (TaskCommentVO taskCommentVO : comments) {
            commentMap.put(taskCommentVO.getTaskId(), taskCommentVO.getFullMessage() == null ? taskCommentVO.getMessage() : taskCommentVO.getFullMessage());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userList));
        HashMap<String, String> nodeState = new HashMap<String, String>();
        HashMap<String, Map> subProcessNodeState = new HashMap<String, Map>();
        boolean containsRunningCallActivity = false;
        for (Object historicActivityInstance : allActivityInstances) {
            List nodeList;
            if (historicActivityInstance.getEndTime() == null) {
                if ("callActivity".equals(historicActivityInstance.getActivityType())) {
                    containsRunningCallActivity = true;
                    nodeList = runningNodeMap.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new ArrayList());
                    nodeList.add(historicActivityInstance.getActivityId());
                    continue;
                }
                if ("subProcess".equals(historicActivityInstance.getActivityType())) {
                    nodeList = runningNodeMap.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new ArrayList());
                    nodeList.add(historicActivityInstance.getActivityId());
                    continue;
                }
                if (!"receiveTask".equals(historicActivityInstance.getActivityType())) continue;
                nodeList = runningNodeMap.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new ArrayList());
                nodeList.add(historicActivityInstance.getActivityId());
                if (historicActivityInstance.getEndTime() != null || historicActivityInstance.getDueDate() == null || historicActivityInstance.getDueDate().getTime() >= System.currentTimeMillis()) continue;
                if (historicActivityInstance.getSubProcessKey() == null) {
                    nodeState.put(historicActivityInstance.getActivityId(), "overtime");
                    continue;
                }
                subProcessNodeState.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new HashMap()).put(historicActivityInstance.getActivityId(), "overtime");
                continue;
            }
            nodeList = finishedNodeMap.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new ArrayList());
            nodeList.add(historicActivityInstance.getActivityId());
        }
        List sysActHiLines = this.iSysActHiLineService.getSysActHiLineByProcessinsId(processInsId, null, false);
        for (Object sysActHiLine : sysActHiLines) {
            List list = hiLineIdMap.computeIfAbsent(sysActHiLine.getSubProcessKey(), k -> new ArrayList());
            list.add(sysActHiLine.getLineId());
        }
        if (containsRunningCallActivity) {
            List<Map<String, String>> mapList = this.getCallNodeType(processInsId);
            for (Map map : mapList) {
                nodeState.put((String)map.get("node"), HussarUtils.isEmpty(map.get("type")) ? NOW_STATE : (String)map.get("type"));
            }
        }
        Map extensionElementsNode = bpmnModel.getMainProcess().getExtensionElements();
        String width = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasWidth")).get(0)).getAttributes().get("canvasWidth")).get(0)).getValue();
        String string = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasHeight")).get(0)).getAttributes().get("canvasHeight")).get(0)).getValue();
        JSONObject processInfo = new JSONObject();
        processInfo.put("width", (Object)width);
        processInfo.put("height", (Object)string);
        DefinitionModel definitionModel = this.processDefinitionsService.getByVersion(processInstance.getProcessDefinitionId(), null, null);
        processInfo.put("workflowStyle", (Object)definitionModel.getWorkflowStyle());
        processInfo.put("data", (Object)this.getMergePredictProcessInfo(processInsId, suspended, bpmnModel, bpmnModel.getMainProcess().getFlowElements(), taskListMap.getOrDefault(null, new ArrayList()), runningNodeMap.getOrDefault(null, new ArrayList()), finishedNodeMap.getOrDefault(null, new ArrayList()), nodeState, hiLineIdMap.getOrDefault(null, new ArrayList()), predictNodeMap, predictLineIdMap));
        result.put("processInfo", (Object)processInfo);
        result.put("processCompleteInfo", (Object)this.getMergePredictProcessCompleteInfo(taskUserMap, commentMap, finalUsersMap, taskListMap.getOrDefault(null, new ArrayList()), bpmnModel, bpmnModel.getMainProcess().getFlowElements(), hisListMap.getOrDefault(null, new ArrayList()), predictNodeMap, predictNodeUserMap));
        ArrayList subProcessKeys = new ArrayList(finishedNodeMap.keySet());
        subProcessKeys.remove(null);
        JSONObject subProcessMsg = new JSONObject();
        for (String subProcessKey : subProcessKeys) {
            if (HussarUtils.isEmpty((Object)subProcessKey)) continue;
            JSONObject jsonObject = new JSONObject();
            String taskDefinitionKey = subProcessKey.split(":")[0];
            SubProcess subProcess = (SubProcess)bpmnModel.getFlowElement(taskDefinitionKey);
            jsonObject.put("subProcessInfo", (Object)this.getMergePredictProcessInfo(processInsId, suspended, bpmnModel, subProcess.getFlowElements(), taskListMap.getOrDefault(subProcessKey, new ArrayList()), runningNodeMap.getOrDefault(subProcessKey, new ArrayList()), finishedNodeMap.getOrDefault(subProcessKey, new ArrayList()), subProcessNodeState.getOrDefault(subProcessKey, new HashMap()), hiLineIdMap.getOrDefault(subProcessKey, new ArrayList()), predictNodeMap, predictLineIdMap));
            jsonObject.put("subProcessCompleteInfo", (Object)this.getMergeProcessCompleteInfo(taskUserMap, commentMap, finalUsersMap, taskListMap.getOrDefault(subProcessKey, new ArrayList()), bpmnModel, subProcess.getFlowElements(), hisListMap.getOrDefault(subProcessKey, new ArrayList())));
            subProcessMsg.put(subProcessKey, (Object)jsonObject);
        }
        result.put("subProcessMsg", (Object)subProcessMsg);
        return result;
    }

    private void predictProcess(Map<String, List<String>> predictNodeMap, Map<String, List<String>> predictLineIdMap, Map<String, List<String>> predictNodeUserMap, String processDefinitionId, String nodeId, String userId, List<SequenceFlow> sfs, BpmnModel bpmnModel, String planNum, Map<String, Object> map) {
        FlowElement flowElement;
        if (HussarUtils.isNotEmpty((Object)nodeId)) {
            predictNodeMap.computeIfAbsent(planNum, k -> new ArrayList()).add(nodeId);
        }
        if (HussarUtils.isEmpty(sfs) && (flowElement = bpmnModel.getFlowElement(nodeId)) instanceof UserTask) {
            sfs = ((UserTask)flowElement).getOutgoingFlows();
        }
        if (HussarUtils.isNotEmpty(sfs)) {
            for (SequenceFlow sequenceFlow : sfs) {
                predictLineIdMap.computeIfAbsent(planNum, k -> new ArrayList()).add(sequenceFlow.getId());
                FlowElement flowElement2 = bpmnModel.getFlowElement(sequenceFlow.getTargetRef());
                List<String> nodeList = predictNodeMap.get(planNum);
                if (HussarUtils.isNotEmpty(nodeList) && nodeList.contains(flowElement2.getId())) continue;
                if (flowElement2 instanceof Gateway) {
                    Gateway gateway = (Gateway)flowElement2;
                    if (gateway instanceof ParallelGateway) {
                        this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitionId, gateway.getId(), userId, gateway.getOutgoingFlows(), bpmnModel, planNum, map);
                        continue;
                    }
                    ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
                    SimpleContext context = new SimpleContext();
                    if (map != null && !map.isEmpty()) {
                        for (String k2 : map.keySet()) {
                            if (map.get(k2.toString()) != null) {
                                context.setVariable(k2.toString(), factory.createValueExpression(map.get(k2.toString()), map.get(k2.toString()).getClass()));
                                continue;
                            }
                            context.setVariable(k2.toString(), factory.createValueExpression(map.get(k2.toString()), Object.class));
                        }
                    }
                    ArrayList<SequenceFlow> defaultList = new ArrayList<SequenceFlow>();
                    ArrayList<Object> allList = new ArrayList<SequenceFlow>();
                    ArrayList<SequenceFlow> mustNeedList = new ArrayList<SequenceFlow>();
                    ArrayList<SequenceFlow> nextNodeVariableList = new ArrayList<SequenceFlow>();
                    List sequenceFlowsList = gateway.getOutgoingFlows();
                    for (SequenceFlow sequenceFlows : sequenceFlowsList) {
                        if (sequenceFlows.getConditionExpression() != null) {
                            boolean isConditionWithNextNode = sequenceFlows.getConditionExpression().contains("bpm_next_node");
                            if (isConditionWithNextNode) {
                                nextNodeVariableList.add(sequenceFlows);
                                continue;
                            }
                            ValueExpression valueExpression = factory.createValueExpression((ELContext)context, sequenceFlows.getConditionExpression(), Boolean.TYPE, map);
                            try {
                                if (!((Boolean)valueExpression.getValue((ELContext)context)).booleanValue()) continue;
                                mustNeedList.add(sequenceFlows);
                            }
                            catch (PropertyNotFoundException e) {
                                mustNeedList.add(sequenceFlows);
                            }
                            continue;
                        }
                        defaultList.add(sequenceFlows);
                    }
                    if (gateway instanceof ExclusiveGateway) {
                        if (HussarUtils.isNotEmpty(mustNeedList)) {
                            this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitionId, gateway.getId(), userId, mustNeedList, bpmnModel, planNum, map);
                            continue;
                        }
                        if (HussarUtils.isNotEmpty(nextNodeVariableList) || HussarUtils.isNotEmpty(defaultList)) {
                            ArrayList<SequenceFlow> possibleList = new ArrayList<SequenceFlow>();
                            if (HussarUtils.isNotEmpty(nextNodeVariableList)) {
                                possibleList.addAll(nextNodeVariableList);
                            }
                            if (HussarUtils.isNotEmpty(defaultList)) {
                                possibleList.addAll(defaultList);
                            }
                            if (!HussarUtils.isNotEmpty(possibleList)) continue;
                            if (possibleList.size() == 1) {
                                this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitionId, gateway.getId(), userId, possibleList, bpmnModel, planNum, map);
                                continue;
                            }
                            SequenceFlow seqFlow = (SequenceFlow)possibleList.get(0);
                            this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitionId, gateway.getId(), userId, Arrays.asList(seqFlow), bpmnModel, planNum, map);
                            for (int i = 1; i < possibleList.size(); ++i) {
                                String planSize = String.valueOf(predictNodeMap.keySet().size());
                                predictNodeMap.computeIfAbsent(planSize, k -> new ArrayList()).addAll((Collection)predictNodeMap.get(planNum));
                                seqFlow = (SequenceFlow)possibleList.get(i);
                                this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitionId, gateway.getId(), userId, Arrays.asList(seqFlow), bpmnModel, PLAN_ + planSize, map);
                            }
                            continue;
                        }
                        predictNodeMap.computeIfAbsent(planNum, k -> new ArrayList()).add(gateway.getId());
                        continue;
                    }
                    if (!(gateway instanceof InclusiveGateway)) continue;
                    if (HussarUtils.isNotEmpty(defaultList)) {
                        mustNeedList.addAll(defaultList);
                    }
                    if (HussarUtils.isEmpty(nextNodeVariableList)) {
                        if (HussarUtils.isNotEmpty(mustNeedList)) {
                            this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitionId, gateway.getId(), userId, mustNeedList, bpmnModel, planNum, map);
                            continue;
                        }
                        predictNodeMap.computeIfAbsent(planNum, k -> new ArrayList()).add(gateway.getId());
                        continue;
                    }
                    ArrayList<List<SequenceFlow>> combinations = new ArrayList<List<SequenceFlow>>();
                    for (int k3 = 0; k3 <= nextNodeVariableList.size(); ++k3) {
                        this.combine(nextNodeVariableList, k3, new ArrayList<SequenceFlow>(), combinations);
                    }
                    if (!HussarUtils.isNotEmpty(combinations)) continue;
                    if (HussarUtils.isNotEmpty(mustNeedList)) {
                        allList.addAll(mustNeedList);
                    }
                    allList.addAll((Collection)combinations.get(0));
                    this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitionId, gateway.getId(), userId, allList, bpmnModel, planNum, map);
                    for (int i = 1; i < combinations.size(); ++i) {
                        allList = new ArrayList();
                        if (HussarUtils.isNotEmpty(mustNeedList)) {
                            allList.addAll(mustNeedList);
                        }
                        allList.addAll((Collection)combinations.get(i));
                        String planSize = String.valueOf(predictNodeMap.keySet().size());
                        predictNodeMap.computeIfAbsent(planSize, k -> new ArrayList()).addAll((Collection)predictNodeMap.get(planNum));
                        this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitionId, gateway.getId(), userId, allList, bpmnModel, PLAN_ + planSize, map);
                    }
                    continue;
                }
                if (flowElement2 instanceof UserTask) {
                    if (HussarUtils.isEmpty(predictNodeUserMap) || HussarUtils.isNotEmpty(predictNodeUserMap) && !predictNodeUserMap.containsKey(flowElement2.getId())) {
                        map.put("userId", userId);
                        List<String> candidateUser = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bpmnModel, flowElement2.getId(), null, map, null);
                        predictNodeUserMap.put(flowElement2.getId(), candidateUser);
                    }
                    this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitionId, flowElement2.getId(), userId, ((UserTask)flowElement2).getOutgoingFlows(), bpmnModel, planNum, map);
                    continue;
                }
                if (flowElement2 instanceof EndEvent) {
                    predictNodeMap.computeIfAbsent(planNum, k -> new ArrayList()).add(flowElement2.getId());
                    continue;
                }
                if (flowElement2 instanceof CallActivity) {
                    this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitionId, flowElement2.getId(), userId, ((CallActivity)flowElement2).getOutgoingFlows(), bpmnModel, planNum, map);
                    continue;
                }
                if (flowElement2 instanceof ServiceTask) {
                    this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitionId, flowElement2.getId(), userId, ((ServiceTask)flowElement2).getOutgoingFlows(), bpmnModel, planNum, map);
                    continue;
                }
                if (flowElement2 instanceof ReceiveTask) {
                    this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitionId, flowElement2.getId(), userId, ((ReceiveTask)flowElement2).getOutgoingFlows(), bpmnModel, planNum, map);
                    continue;
                }
                if (!(flowElement2 instanceof SubProcess)) continue;
                this.predictProcess(predictNodeMap, predictLineIdMap, predictNodeUserMap, processDefinitionId, flowElement2.getId(), userId, ((SubProcess)flowElement2).getOutgoingFlows(), bpmnModel, planNum, map);
            }
        }
    }

    private void combine(List<SequenceFlow> set, int k, List<SequenceFlow> prefix, List<List<SequenceFlow>> combinations) {
        if (k == 0) {
            combinations.add(new ArrayList<SequenceFlow>(prefix));
            return;
        }
        for (int i = 0; i < set.size(); ++i) {
            prefix.add(set.get(i));
            this.combine(set, k - 1, prefix, combinations);
            prefix.remove(prefix.size() - 1);
        }
    }

    private void prepareBpmnModel(BpmnModel bpmnModel) {
        ArrayList allGraphicInfos = new ArrayList();
        if (bpmnModel.getLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLocationMap().values());
        }
        if (bpmnModel.getLabelLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLabelLocationMap().values());
        }
        if (bpmnModel.getFlowLocationMap() != null) {
            for (List flowGraphicInfos : bpmnModel.getFlowLocationMap().values()) {
                allGraphicInfos.addAll(flowGraphicInfos);
            }
        }
        if (!allGraphicInfos.isEmpty()) {
            boolean needsTranslationX = false;
            boolean needsTranslationY = false;
            double lowestX = 0.0;
            double lowestY = 0.0;
            for (GraphicInfo graphicInfo : allGraphicInfos) {
                double x = graphicInfo.getX();
                double y = graphicInfo.getY();
                if (x < lowestX) {
                    needsTranslationX = true;
                    lowestX = x;
                }
                if (!(y < lowestY)) continue;
                needsTranslationY = true;
                lowestY = y;
            }
            if (needsTranslationX || needsTranslationY) {
                double translationX = Math.abs(lowestX);
                double translationY = Math.abs(lowestY);
                for (GraphicInfo graphicInfo : allGraphicInfos) {
                    if (needsTranslationX) {
                        graphicInfo.setX(graphicInfo.getX() + translationX);
                    }
                    if (!needsTranslationY) continue;
                    graphicInfo.setY(graphicInfo.getY() + translationY);
                }
            }
        }
    }

    private JSONArray getMergeProcessInfo(String processInsId, boolean suspended, BpmnModel bpmnModel, Collection<FlowElement> flowElements, List<Task> tasks, List<String> runningNodeList, List<String> finishedNodeList, Map<String, String> nodeState, List<String> lineList) {
        for (Task task : tasks) {
            if (task.getParentTaskId() != null) continue;
            runningNodeList.add(task.getTaskDefinitionKey());
            if (HussarUtils.isNotEmpty((Object)task.getDueDate()) && task.getDueDate().getTime() < System.currentTimeMillis()) {
                nodeState.put(task.getTaskDefinitionKey(), "overtime");
                continue;
            }
            String completeType = task.getCompleteType();
            completeType = TaskSourceFlag.isReject((String)completeType) ? "reject" : NOW_STATE;
            nodeState.put(task.getTaskDefinitionKey(), completeType);
        }
        JSONArray nodeMessage = new JSONArray();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof FlowNode)) continue;
            FlowNode flowNode = (FlowNode)flowElement;
            JSONObject object = new JSONObject();
            String flowNodeId = flowNode.getId();
            object.put("id", (Object)flowNodeId);
            object.put("name", (Object)flowNode.getName());
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            object.put("x", (Object)graphicInfo.getX());
            object.put("y", (Object)graphicInfo.getY());
            object.put("width", (Object)graphicInfo.getWidth());
            object.put("height", (Object)graphicInfo.getHeight());
            object.put("type", (Object)this.getNodeType(flowNode));
            if (flowElement instanceof SubProcess) {
                object.put("subProcessElements", (Object)this.getSubProcessMsg((SubProcess)flowElement, bpmnModel, processInsId));
            }
            object.put("processInsId", (Object)processInsId);
            if (runningNodeList.contains(flowNodeId)) {
                if (suspended) {
                    object.put("state", (Object)"suspend");
                } else {
                    object.put("state", (Object)nodeState.getOrDefault(flowNodeId, NOW_STATE));
                }
            } else if (finishedNodeList.contains(flowNodeId)) {
                object.put("state", (Object)FINISH_STATE);
            } else {
                object.put("state", (Object)"next");
            }
            nodeMessage.add((Object)object);
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                List graphicInfoList;
                Map maps;
                List extendFlowNameElement;
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)sequenceFlow.getId());
                obj.put("name", (Object)sequenceFlow.getName());
                obj.put("type", (Object)"sequenceFlow");
                obj.put("dx", null);
                obj.put("rotate", null);
                obj.put("lineName", null);
                obj.put("x", null);
                obj.put("y", null);
                obj.put("height", null);
                obj.put("width", null);
                Map stringListMap = sequenceFlow.getExtensionElements();
                if (stringListMap != null && !stringListMap.isEmpty() && (extendFlowNameElement = (List)stringListMap.get("extendSequenceflow")) != null && !extendFlowNameElement.isEmpty() && HussarUtils.isNotEmpty((Object)(maps = ((ExtensionElement)extendFlowNameElement.get(0)).getAttributes()))) {
                    for (Map.Entry map : maps.entrySet()) {
                        if ("lineName".equals(map.getKey())) {
                            String lineNamesStr = ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue();
                            String[] lineNames = lineNamesStr.split("/n");
                            obj.put("lineName", (Object)lineNames);
                            continue;
                        }
                        if ("x".equals(map.getKey()) || "y".equals(map.getKey()) || "width".equals(map.getKey()) || "height".equals(map.getKey())) {
                            obj.put((String)map.getKey(), (Object)Double.parseDouble(((ExtensionAttribute)((List)map.getValue()).get(0)).getValue()));
                            continue;
                        }
                        obj.put((String)map.getKey(), (Object)((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                    }
                }
                if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId())) != null && !graphicInfoList.isEmpty()) {
                    int[] xPoints = new int[graphicInfoList.size()];
                    int[] yPoints = new int[graphicInfoList.size()];
                    for (int i = 1; i < graphicInfoList.size(); ++i) {
                        GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                        GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                        if (i == 1) {
                            xPoints[0] = (int)previousGraphicInfo.getX();
                            yPoints[0] = (int)previousGraphicInfo.getY();
                        }
                        xPoints[i] = (int)gi.getX();
                        yPoints[i] = (int)gi.getY();
                    }
                    obj.put("xPoints", (Object)xPoints);
                    obj.put("yPoints", (Object)yPoints);
                }
                if (lineList.contains(sequenceFlow.getId())) {
                    obj.put("state", (Object)FINISH_STATE);
                } else {
                    obj.put("state", (Object)"next");
                }
                nodeMessage.add((Object)obj);
            }
        }
        return nodeMessage;
    }

    private JSONObject getMergePredictProcessInfo(String processInsId, boolean suspended, BpmnModel bpmnModel, Collection<FlowElement> flowElements, List<Task> tasks, List<String> runningNodeList, List<String> finishedNodeList, Map<String, String> nodeState, List<String> lineList, Map<String, List<String>> predictNodeMap, Map<String, List<String>> predictLineIdMap) {
        for (Task task : tasks) {
            if (task.getParentTaskId() != null) continue;
            runningNodeList.add(task.getTaskDefinitionKey());
            if (HussarUtils.isNotEmpty((Object)task.getDueDate()) && task.getDueDate().getTime() < System.currentTimeMillis()) {
                nodeState.put(task.getTaskDefinitionKey(), "overtime");
                continue;
            }
            String completeType = task.getCompleteType();
            completeType = TaskSourceFlag.isReject((String)completeType) ? "reject" : NOW_STATE;
            nodeState.put(task.getTaskDefinitionKey(), completeType);
        }
        JSONObject allPlan = new JSONObject();
        if (HussarUtils.isEmpty(predictNodeMap)) {
            predictNodeMap.put("plan_0", new ArrayList());
        }
        for (Map.Entry<String, List<String>> entry : predictNodeMap.entrySet()) {
            String planNum = entry.getKey().toString();
            List<String> value = entry.getValue();
            List<Object> predictNodeList = new ArrayList();
            if (HussarUtils.isNotEmpty(value) && value instanceof List) {
                predictNodeList = value;
            }
            List<Object> predictLineList = new ArrayList();
            if (HussarUtils.isNotEmpty(predictLineIdMap)) {
                predictLineList = predictLineIdMap.get(planNum);
            }
            JSONArray nodeMessage = new JSONArray();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof FlowNode)) continue;
                FlowNode flowNode = (FlowNode)flowElement;
                JSONObject object = new JSONObject();
                String flowNodeId = flowNode.getId();
                object.put("id", (Object)flowNodeId);
                object.put("name", (Object)flowNode.getName());
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                object.put("x", (Object)graphicInfo.getX());
                object.put("y", (Object)graphicInfo.getY());
                object.put("width", (Object)graphicInfo.getWidth());
                object.put("height", (Object)graphicInfo.getHeight());
                object.put("type", (Object)this.getNodeType(flowNode));
                if (flowElement instanceof SubProcess) {
                    object.put("subProcessElements", (Object)this.getSubProcessMsg((SubProcess)flowElement, bpmnModel, processInsId));
                }
                object.put("processInsId", (Object)processInsId);
                if (runningNodeList.contains(flowNodeId)) {
                    if (suspended) {
                        object.put("state", (Object)"suspend");
                    } else {
                        object.put("state", (Object)nodeState.getOrDefault(flowNodeId, NOW_STATE));
                    }
                } else if (HussarUtils.isNotEmpty(predictNodeList) && predictNodeList.contains(flowNodeId)) {
                    object.put("state", (Object)"predict");
                } else if (finishedNodeList.contains(flowNodeId)) {
                    object.put("state", (Object)FINISH_STATE);
                } else {
                    object.put("state", (Object)"next");
                }
                nodeMessage.add((Object)object);
                for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                    List graphicInfoList;
                    Map maps;
                    List extendFlowNameElement;
                    JSONObject obj = new JSONObject();
                    obj.put("id", (Object)sequenceFlow.getId());
                    obj.put("name", (Object)sequenceFlow.getName());
                    obj.put("type", (Object)"sequenceFlow");
                    obj.put("dx", null);
                    obj.put("rotate", null);
                    obj.put("lineName", null);
                    obj.put("x", null);
                    obj.put("y", null);
                    obj.put("height", null);
                    obj.put("width", null);
                    Map stringListMap = sequenceFlow.getExtensionElements();
                    if (stringListMap != null && !stringListMap.isEmpty() && (extendFlowNameElement = (List)stringListMap.get("extendSequenceflow")) != null && !extendFlowNameElement.isEmpty() && HussarUtils.isNotEmpty((Object)(maps = ((ExtensionElement)extendFlowNameElement.get(0)).getAttributes()))) {
                        for (Map.Entry map : maps.entrySet()) {
                            if ("lineName".equals(map.getKey())) {
                                String lineNamesStr = ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue();
                                String[] lineNames = lineNamesStr.split("/n");
                                obj.put("lineName", (Object)lineNames);
                                continue;
                            }
                            if ("x".equals(map.getKey()) || "y".equals(map.getKey()) || "width".equals(map.getKey()) || "height".equals(map.getKey())) {
                                obj.put((String)map.getKey(), (Object)Double.parseDouble(((ExtensionAttribute)((List)map.getValue()).get(0)).getValue()));
                                continue;
                            }
                            obj.put((String)map.getKey(), (Object)((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                        }
                    }
                    if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId())) != null && !graphicInfoList.isEmpty()) {
                        int[] xPoints = new int[graphicInfoList.size()];
                        int[] yPoints = new int[graphicInfoList.size()];
                        for (int i = 1; i < graphicInfoList.size(); ++i) {
                            GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                            GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                            if (i == 1) {
                                xPoints[0] = (int)previousGraphicInfo.getX();
                                yPoints[0] = (int)previousGraphicInfo.getY();
                            }
                            xPoints[i] = (int)gi.getX();
                            yPoints[i] = (int)gi.getY();
                        }
                        obj.put("xPoints", (Object)xPoints);
                        obj.put("yPoints", (Object)yPoints);
                    }
                    if (HussarUtils.isNotEmpty(predictLineList) && predictLineList.contains(sequenceFlow.getId())) {
                        obj.put("state", (Object)"predict");
                    } else if (lineList.contains(sequenceFlow.getId())) {
                        obj.put("state", (Object)FINISH_STATE);
                    } else {
                        obj.put("state", (Object)"next");
                    }
                    nodeMessage.add((Object)obj);
                }
            }
            allPlan.put(planNum, (Object)nodeMessage);
        }
        return allPlan;
    }

    private JSONObject getMergePredictProcessCompleteInfo(Map<String, List<BpmActRuIdentitylink>> taskUserMap, Map<String, String> commentMap, Map<String, String> finalUsersMap, List<Task> tasks, BpmnModel bpmnModel, Collection<FlowElement> flowElements, List<HistoricTaskInstance> hisList, Map<String, List<String>> predictNodeMap, Map<String, List<String>> predictNodeUserMap) {
        JSONObject allPlan = new JSONObject();
        if (HussarUtils.isEmpty(predictNodeMap)) {
            predictNodeMap.put("plan_0", new ArrayList());
        }
        for (Map.Entry<String, List<String>> entry : predictNodeMap.entrySet()) {
            String planNum = entry.getKey().toString();
            List<String> value = entry.getValue();
            List<Object> predictNodeList = new ArrayList();
            if (HussarUtils.isNotEmpty(value) && value instanceof List) {
                predictNodeList = value;
            }
            JSONArray subProcessCompleteInfo = new JSONArray();
            for (FlowElement flowElement : flowElements) {
                String comment;
                JSONObject o;
                JSONArray json;
                if (!(flowElement instanceof UserTask)) continue;
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowElement.getId());
                JSONObject object = new JSONObject();
                object.put("width", (Object)graphicInfo.getWidth());
                object.put("height", (Object)graphicInfo.getHeight());
                object.put("x", (Object)graphicInfo.getX());
                object.put("y", (Object)graphicInfo.getY());
                object.put("id", (Object)flowElement.getId());
                List taskList = null;
                if (tasks != null && !tasks.isEmpty()) {
                    taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                }
                boolean isPredict = false;
                if (HussarUtils.isNotEmpty(predictNodeList) && predictNodeList.contains(flowElement.getId())) {
                    isPredict = true;
                }
                if (taskList != null && !taskList.isEmpty() || isPredict) {
                    if (taskList != null && !taskList.isEmpty()) {
                        ArrayList<BpmActRuIdentitylink> user = new ArrayList<BpmActRuIdentitylink>();
                        for (Task task : taskList) {
                            List<BpmActRuIdentitylink> list = taskUserMap.get(task.getId());
                            if (list == null) continue;
                            user.addAll(list);
                        }
                        List ts = taskList.stream().filter(t -> t.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                        object.put("startTime", (Object)((Task)ts.get(0)).getCreateTime());
                        object.put("complete_type", (Object)TaskSourceFlag.mappingToSimple((String)((Task)ts.get(0)).getCompleteType()));
                        if (!user.isEmpty()) {
                            ArrayList result = new ArrayList();
                            for (BpmActRuIdentitylink identityLink : user) {
                                if (finalUsersMap.get(identityLink.getUserId()) == null) continue;
                                if (TaskStateType.isEntrust((String)identityLink.getTaskState()) && finalUsersMap.get(identityLink.getMandator()) != null) {
                                    result.add(finalUsersMap.get(identityLink.getUserId()) + "(" + finalUsersMap.get(identityLink.getMandator()) + TASK_SOURCE_FLAG.get("transfer") + ")");
                                    continue;
                                }
                                if (HussarUtils.isNotEmpty((Object)identityLink.getAddAssigneeOperator()) && finalUsersMap.get(identityLink.getAddAssigneeOperator()) != null) {
                                    result.add(finalUsersMap.get(identityLink.getUserId()) + "(" + finalUsersMap.get(identityLink.getAddAssigneeOperator()) + TASK_SOURCE_FLAG.get("addAssignee") + ")");
                                    continue;
                                }
                                result.add(finalUsersMap.get(identityLink.getUserId()));
                            }
                            if (result.isEmpty()) {
                                object.put("assignee", (Object)BpmExceptionCodeEnum.NULL_ASSIGNEE.getMessage());
                            } else {
                                String string = String.join((CharSequence)",", result);
                                object.put("assignee", (Object)string);
                            }
                        } else {
                            object.put("assignee", (Object)BpmExceptionCodeEnum.NULL_ASSIGNEE.getMessage());
                        }
                        object.put("state", (Object)NOW_STATE);
                    } else if (isPredict) {
                        String assignee;
                        object.put("state", (Object)"predict");
                        List<Object> userList = new ArrayList();
                        userList = predictNodeUserMap.get(flowElement.getId());
                        ArrayList<String> result = new ArrayList<String>();
                        if (HussarUtils.isNotEmpty(userList)) {
                            for (String string : userList) {
                                if (finalUsersMap.get(string) == null) continue;
                                result.add(finalUsersMap.get(string));
                            }
                        }
                        if (HussarUtils.isNotEmpty((Object)(assignee = String.join((CharSequence)",", result)))) {
                            object.put("assignee", (Object)assignee);
                        } else {
                            object.put("assignee", (Object)BpmExceptionCodeEnum.NULL_ASSIGNEE.getMessage());
                        }
                    }
                    List nowHisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                    if (!nowHisActivitList.isEmpty()) {
                        nowHisActivitList.sort((o1, o2) -> {
                            if (!o1.getStartTime().equals(o2.getStartTime())) {
                                return o1.getStartTime().compareTo(o2.getStartTime());
                            }
                            if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                                return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                            }
                            if (o1.getEndTime() == null && o2.getEndTime() != null) {
                                return o2.getEndTime().compareTo(new Date(0L));
                            }
                            if (o1.getEndTime() != null && o2.getEndTime() == null) {
                                return new Date(0L).compareTo(o1.getEndTime());
                            }
                            if (o1.getEndTime().equals(o2.getEndTime())) {
                                return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                            }
                            return o1.getEndTime().compareTo(o2.getEndTime());
                        });
                        json = new JSONArray();
                        for (HistoricTaskInstance historicTaskInstance : nowHisActivitList) {
                            o = new JSONObject();
                            String nowUser = BpmExceptionCodeEnum.NULL_COMPLETE.getMessage();
                            if (historicTaskInstance.getAssignee() != null && finalUsersMap.get(historicTaskInstance.getAssignee()) != null) {
                                nowUser = TaskStateType.isEntrust((HistoricTaskInstance)historicTaskInstance) && HussarUtils.isNotEmpty((Object)historicTaskInstance.getOwner()) && finalUsersMap.get(historicTaskInstance.getOwner()) != null ? finalUsersMap.get(historicTaskInstance.getAssignee()) + "(" + finalUsersMap.get(historicTaskInstance.getOwner()) + ")" : finalUsersMap.get(historicTaskInstance.getAssignee());
                            }
                            o.put("comments", (Object)((comment = commentMap.get(historicTaskInstance.getId())) == null ? BpmExceptionCodeEnum.NULL_COMMENT.getMessage() : comment));
                            o.put("assignee", (Object)nowUser);
                            o.put("endTime", (Object)historicTaskInstance.getEndTime());
                            o.put("startTime", (Object)historicTaskInstance.getStartTime());
                            o.put("taskType", (Object)historicTaskInstance.getTaskType());
                            json.add((Object)o);
                        }
                        object.put("completeInfo", (Object)json);
                    }
                } else {
                    object.put("state", (Object)FINISH_STATE);
                    List hisActivitList = null;
                    if (HussarUtils.isNotEmpty(hisList)) {
                        hisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                    }
                    if (hisActivitList == null || hisActivitList.isEmpty()) continue;
                    hisActivitList.sort((m1, m2) -> m1.getStartTime().compareTo(m2.getStartTime()));
                    json = new JSONArray();
                    for (HistoricTaskInstance historicTaskInstance : hisActivitList) {
                        o = new JSONObject();
                        String user = "";
                        if (historicTaskInstance.getAssignee() != null) {
                            user = TaskStateType.isEntrust((HistoricTaskInstance)historicTaskInstance) ? finalUsersMap.get(historicTaskInstance.getAssignee()) + "(" + finalUsersMap.get(historicTaskInstance.getOwner()) + ")" : finalUsersMap.get(historicTaskInstance.getAssignee());
                        }
                        if (StringUtils.isEmpty((CharSequence)user)) {
                            user = BpmExceptionCodeEnum.NULL_COMPLETE.getMessage();
                        }
                        o.put("comments", (Object)((comment = commentMap.get(historicTaskInstance.getId())) == null ? BpmExceptionCodeEnum.NULL_COMMENT.getMessage() : comment));
                        o.put("assignee", (Object)user);
                        o.put("endTime", (Object)historicTaskInstance.getEndTime());
                        o.put("startTime", (Object)historicTaskInstance.getStartTime());
                        o.put("taskType", (Object)historicTaskInstance.getTaskType());
                        json.add((Object)o);
                    }
                    object.put("completeInfo", (Object)json);
                }
                subProcessCompleteInfo.add((Object)object);
            }
            allPlan.put(planNum, (Object)subProcessCompleteInfo);
        }
        return allPlan;
    }

    private String getNodeType(FlowNode flowNode) {
        String type = "";
        if (flowNode instanceof UserTask) {
            type = HussarUtils.isNotEmpty((Object)((UserTask)flowNode).getLoopCharacteristics()) ? "multiUserTask" : "userTask";
        } else if (flowNode instanceof ServiceTask) {
            type = "serviceTask";
        } else if (flowNode instanceof ReceiveTask) {
            type = "receiveTask";
        } else if (flowNode instanceof StartEvent) {
            EventDefinition eventDefinition;
            StartEvent startEvent = (StartEvent)flowNode;
            type = startEvent.getEventDefinitions() != null && !startEvent.getEventDefinitions().isEmpty() ? ((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof TimerEventDefinition ? "startTimerEvent" : (eventDefinition instanceof ErrorEventDefinition ? "errorEvent" : (eventDefinition instanceof SignalEventDefinition ? "signalEvent" : (eventDefinition instanceof MessageEventDefinition ? "messageEvent" : "noneEvent")))) : "startEvent";
        } else if (flowNode instanceof EndEvent) {
            type = "endEvent";
        } else if (flowNode instanceof ParallelGateway) {
            type = "parallelGateway";
        } else if (flowNode instanceof InclusiveGateway) {
            type = "inclusiveGateway";
        } else if (flowNode instanceof ExclusiveGateway) {
            type = "exclusiveGateway";
        } else if (flowNode instanceof SubProcess) {
            type = "subProcess";
        } else if (flowNode instanceof BoundaryEvent) {
            type = "boundaryEvent";
        } else if (flowNode instanceof CallActivity) {
            type = "callActivity";
        }
        return type;
    }

    private JSONArray getMergeProcessCompleteInfo(Map<String, List<BpmActRuIdentitylink>> taskUserMap, Map<String, String> commentMap, Map<String, String> finalUsersMap, List<Task> tasks, BpmnModel bpmnModel, Collection<FlowElement> flowElements, List<HistoricTaskInstance> hisList) {
        JSONArray subProcessCompleteInfo = new JSONArray();
        for (FlowElement flowElement : flowElements) {
            if (flowElement instanceof SequenceFlow) continue;
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowElement.getId());
            JSONObject object = new JSONObject();
            object.put("width", (Object)graphicInfo.getWidth());
            object.put("height", (Object)graphicInfo.getHeight());
            object.put("x", (Object)graphicInfo.getX());
            object.put("y", (Object)graphicInfo.getY());
            object.put("id", (Object)flowElement.getId());
            List taskList = null;
            if (tasks != null && !tasks.isEmpty()) {
                taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
            }
            if (taskList != null && !taskList.isEmpty()) {
                ArrayList<BpmActRuIdentitylink> user = new ArrayList<BpmActRuIdentitylink>();
                for (Task task : taskList) {
                    List<BpmActRuIdentitylink> taskUser = taskUserMap.get(task.getId());
                    if (taskUser == null) continue;
                    user.addAll(taskUser);
                }
                List nowHisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                List ts = taskList.stream().filter(t -> t.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                object.put("startTime", (Object)((Task)ts.get(0)).getCreateTime());
                object.put("complete_type", (Object)TaskSourceFlag.mappingToSimple((String)((Task)ts.get(0)).getCompleteType()));
                if (!user.isEmpty()) {
                    ArrayList<String> result = new ArrayList<String>();
                    for (BpmActRuIdentitylink identityLink : user) {
                        if (finalUsersMap.get(identityLink.getUserId()) == null) continue;
                        if (TaskStateType.isEntrust((String)identityLink.getTaskState()) && finalUsersMap.get(identityLink.getMandator()) != null) {
                            result.add(finalUsersMap.get(identityLink.getUserId()) + "(" + finalUsersMap.get(identityLink.getMandator()) + TASK_SOURCE_FLAG.get("transfer") + ")");
                            continue;
                        }
                        if (HussarUtils.isNotEmpty((Object)identityLink.getAddAssigneeOperator()) && finalUsersMap.get(identityLink.getAddAssigneeOperator()) != null) {
                            result.add(finalUsersMap.get(identityLink.getUserId()) + "(" + finalUsersMap.get(identityLink.getAddAssigneeOperator()) + TASK_SOURCE_FLAG.get("addAssignee") + ")");
                            continue;
                        }
                        result.add(finalUsersMap.get(identityLink.getUserId()));
                    }
                    if (result.isEmpty()) {
                        object.put("assignee", (Object)BpmExceptionCodeEnum.NULL_ASSIGNEE.getMessage());
                    } else {
                        String assignee = String.join((CharSequence)",", result);
                        object.put("assignee", (Object)assignee);
                    }
                } else {
                    object.put("assignee", (Object)BpmExceptionCodeEnum.NULL_ASSIGNEE.getMessage());
                }
                object.put("state", (Object)NOW_STATE);
                if (!nowHisActivitList.isEmpty()) {
                    nowHisActivitList.sort((o1, o2) -> {
                        if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                            return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                        }
                        if (o1.getEndTime() == null && o2.getEndTime() != null) {
                            return o2.getEndTime().compareTo(new Date(0L));
                        }
                        if (o1.getEndTime() != null && o2.getEndTime() == null) {
                            return new Date(0L).compareTo(o1.getEndTime());
                        }
                        if (o1.getEndTime().equals(o2.getEndTime())) {
                            return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                        }
                        return o2.getEndTime().compareTo(o1.getEndTime());
                    });
                    JSONArray json = new JSONArray();
                    for (HistoricTaskInstance historicActivityInstance : nowHisActivitList) {
                        String comment;
                        JSONObject o = new JSONObject();
                        String nowUser = BpmExceptionCodeEnum.NULL_COMPLETE.getMessage();
                        if (historicActivityInstance.getAssignee() != null && finalUsersMap.get(historicActivityInstance.getAssignee()) != null) {
                            nowUser = TaskStateType.isEntrust((HistoricTaskInstance)historicActivityInstance) && HussarUtils.isNotEmpty((Object)historicActivityInstance.getOwner()) && finalUsersMap.get(historicActivityInstance.getOwner()) != null ? finalUsersMap.get(historicActivityInstance.getAssignee()) + "(" + finalUsersMap.get(historicActivityInstance.getOwner()) + ")" : finalUsersMap.get(historicActivityInstance.getAssignee());
                        }
                        o.put("comments", (Object)((comment = commentMap.get(historicActivityInstance.getId())) == null ? BpmExceptionCodeEnum.NULL_COMMENT.getMessage() : comment));
                        o.put("assignee", (Object)nowUser);
                        o.put("endTime", (Object)historicActivityInstance.getEndTime());
                        o.put("startTime", (Object)historicActivityInstance.getStartTime());
                        o.put("taskType", (Object)historicActivityInstance.getTaskType());
                        o.put("taskSourceFlag", (Object)InstanceEngineServiceImpl.getStrTaskSourceFlag(historicActivityInstance.getTaskSourceFlag()));
                        json.add((Object)o);
                    }
                    object.put("completeInfo", (Object)json);
                }
            } else {
                object.put("state", (Object)FINISH_STATE);
                List hisActivitList = null;
                if (HussarUtils.isNotEmpty(hisList)) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                }
                if (hisActivitList == null || hisActivitList.isEmpty()) continue;
                hisActivitList.sort((m1, m2) -> m2.getEndTime().compareTo(m1.getEndTime()));
                JSONArray json = new JSONArray();
                for (HistoricTaskInstance historicActivityInstance : hisActivitList) {
                    String comment;
                    JSONObject o = new JSONObject();
                    String user = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = TaskStateType.isEntrust((HistoricTaskInstance)historicActivityInstance) ? finalUsersMap.get(historicActivityInstance.getAssignee()) + "(" + finalUsersMap.get(historicActivityInstance.getOwner()) + ")" : finalUsersMap.get(historicActivityInstance.getAssignee());
                    }
                    if (StringUtils.isEmpty((CharSequence)user)) {
                        user = BpmExceptionCodeEnum.NULL_COMPLETE.getMessage();
                    }
                    o.put("comments", (Object)((comment = commentMap.get(historicActivityInstance.getId())) == null ? BpmExceptionCodeEnum.NULL_COMMENT.getMessage() : comment));
                    o.put("assignee", (Object)user);
                    o.put("endTime", (Object)historicActivityInstance.getEndTime());
                    o.put("startTime", (Object)historicActivityInstance.getStartTime());
                    o.put("taskType", (Object)historicActivityInstance.getTaskType());
                    o.put("taskSourceFlag", (Object)InstanceEngineServiceImpl.getStrTaskSourceFlag(historicActivityInstance.getTaskSourceFlag()));
                    json.add((Object)o);
                }
                object.put("completeInfo", (Object)json);
            }
            subProcessCompleteInfo.add((Object)object);
        }
        return subProcessCompleteInfo;
    }

    private JSONArray getSubProcessMsg(SubProcess subProcess, BpmnModel bpmnModel, String processInsId) {
        JSONArray jsonArray = new JSONArray();
        for (FlowElement flowElement : subProcess.getFlowElements()) {
            if (!(flowElement instanceof FlowNode)) continue;
            FlowNode flowNode = (FlowNode)flowElement;
            JSONObject object = new JSONObject();
            String flowNodeId = flowNode.getId();
            object.put("id", (Object)flowNodeId);
            object.put("name", (Object)flowNode.getName());
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            object.put("x", (Object)graphicInfo.getX());
            object.put("y", (Object)graphicInfo.getY());
            object.put("width", (Object)graphicInfo.getWidth());
            object.put("height", (Object)graphicInfo.getHeight());
            object.put("type", (Object)this.getNodeType(flowNode));
            object.put("processInsId", (Object)processInsId);
            object.put("state", (Object)"next");
            jsonArray.add((Object)object);
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                List graphicInfoList;
                Map maps;
                List extendFlowNameElement;
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)sequenceFlow.getId());
                obj.put("name", (Object)sequenceFlow.getName());
                obj.put("type", (Object)"sequenceFlow");
                obj.put("dx", null);
                obj.put("rotate", null);
                obj.put("lineName", null);
                obj.put("x", null);
                obj.put("y", null);
                obj.put("height", null);
                obj.put("width", null);
                Map stringListMap = sequenceFlow.getExtensionElements();
                if (stringListMap != null && !stringListMap.isEmpty() && (extendFlowNameElement = (List)stringListMap.get("extendSequenceflow")) != null && !extendFlowNameElement.isEmpty() && HussarUtils.isNotEmpty((Object)(maps = ((ExtensionElement)extendFlowNameElement.get(0)).getAttributes()))) {
                    for (Map.Entry map : maps.entrySet()) {
                        if ("lineName".equals(map.getKey())) {
                            String lineNamesStr = ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue();
                            String[] lineNames = lineNamesStr.split("/n");
                            obj.put("lineName", (Object)lineNames);
                            continue;
                        }
                        if ("x".equals(map.getKey()) || "y".equals(map.getKey()) || "width".equals(map.getKey()) || "height".equals(map.getKey())) {
                            obj.put((String)map.getKey(), (Object)Double.parseDouble(((ExtensionAttribute)((List)map.getValue()).get(0)).getValue()));
                            continue;
                        }
                        obj.put((String)map.getKey(), (Object)((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                    }
                }
                if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId())) != null && !graphicInfoList.isEmpty()) {
                    int[] xPoints = new int[graphicInfoList.size()];
                    int[] yPoints = new int[graphicInfoList.size()];
                    for (int i = 1; i < graphicInfoList.size(); ++i) {
                        GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                        GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                        if (i == 1) {
                            xPoints[0] = (int)previousGraphicInfo.getX();
                            yPoints[0] = (int)previousGraphicInfo.getY();
                        }
                        xPoints[i] = (int)gi.getX();
                        yPoints[i] = (int)gi.getY();
                    }
                    obj.put("xPoints", (Object)xPoints);
                    obj.put("yPoints", (Object)yPoints);
                }
                obj.put("state", (Object)"next");
                jsonArray.add((Object)obj);
            }
        }
        return jsonArray;
    }

    public BpmResponseResult getProcessShowMsg(FlowChartCommonDto flowChartCommonDto) {
        JSONObject jsonObject = this.getProcessShowMsg(flowChartCommonDto.getProcessInsId(), flowChartCommonDto.getBusinessId(), flowChartCommonDto.getFirstQuery());
        return InstallResult.success((Object)jsonObject);
    }

    public BpmResponseResult getProcessHistoryMsg(FlowChartCommonDto flowChartCommonDto) {
        JSONObject jsonObject = this.getProcessHistoryMsg(flowChartCommonDto.getProcessInsId(), flowChartCommonDto.getBusinessId(), flowChartCommonDto.getProcessCycleCount(), flowChartCommonDto.getFirstQuery(), flowChartCommonDto.getInitialProcessInsId(), flowChartCommonDto.getInitialBusinessId(), flowChartCommonDto.getNeedGetCallActivity());
        return InstallResult.success((Object)jsonObject);
    }

    public BpmResponseResult updateProcessSecurityLevel(UpdateProcessSecurityLevelDto param) {
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            HistoricProcessInstance processInst = this.getProcessInst(param.getProcInstId(), param.getBusinessId(), param.getTaskId(), null);
            ((HistoricProcessInstanceEntity)processInst).setSecurityLevel(param.getSecurityLevel());
            if (param.getCascade()) {
                // empty if block
            }
            return processInst;
        });
        return InstallResult.success();
    }

    public BpmResponseResult getOrganProcessModelMessage(OrganProcessModelQueryDto organProcessModelQueryDto) {
        return InstallResult.success((Object)WorkflowOrganProcessUtil.getStartOrganProcessModelMessage(organProcessModelQueryDto));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject queryFormField(String processKey, String version, String processInstanceId, String taskId, String taskDefinitionKey) {
        void var11_12;
        DefinitionModel definitionModel;
        HistoricTaskInstance historicTaskInstance;
        WorkFlow workFlow = null;
        if (HussarUtils.isNotEmpty((Object)processInstanceId)) {
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (!HussarUtils.isNotEmpty((Object)processInstance)) return new JSONObject();
            workFlow = this.sysActProcessFileService.getFileByProcessDefId(processInstance.getProcessDefinitionId());
        } else {
            if (!HussarUtils.isNotEmpty((Object)processKey)) throw new BpmException(BpmExceptionCodeEnum.PARAM_IS_NULL);
            String procDefId = this.processDefinitionsService.getStartProcessDefinitionId(processKey, version);
            workFlow = this.sysActProcessFileService.getFileByProcessDefId(procDefId);
        }
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        if (HussarUtils.isNotEmpty((Object)taskId) && HussarUtils.isNotEmpty((Object)(historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).queryChildTask()).singleResult()))) {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicTaskInstance.getProcessDefinitionId());
            taskDefinitionKey = CommonCodeUtil.getVisitorNodeId(historicTaskInstance.getTaskDefinitionKey(), bpmnModel);
        }
        HashSet<String> nodeVariableNames = new HashSet<String>();
        List elements = flowModel.getSlots().getElement();
        JSONObject jsonObject = new JSONObject();
        ArrayList arrayList = new ArrayList();
        JSONArray commentSettings = new JSONArray();
        List paths = flowModel.getSlots().getPath();
        String startPath = null;
        for (FlowObject flowObject : elements) {
            if (CHECK_VARIABLE_NODE_TYPE_LIST.contains(flowObject.getName())) {
                ArrayList<FlowVariables> functionUserVariables = new ArrayList<FlowVariables>();
                FormBpmnUtil.getFunctionMessage(flowObject.getProps(), new HashMap<String, String>(), functionUserVariables);
                ArrayList<FlowVariables> nodeVariables = flowObject.getProps().getUseVariables();
                if (nodeVariables == null) {
                    nodeVariables = new ArrayList<FlowVariables>();
                }
                nodeVariables.addAll(functionUserVariables);
                for (FlowVariables flowVariables : nodeVariables) {
                    nodeVariableNames.add(flowVariables.getVariable());
                }
                if (!HussarUtils.isNotEmpty((Object)taskDefinitionKey) || !taskDefinitionKey.equals(flowObject.getInstanceKey())) continue;
                List list = flowObject.getProps().getNodeCheckRuleList();
                continue;
            }
            if (!HussarUtils.isEmpty((Object)taskDefinitionKey) || !BpmNodeTypeUtil.isStart((String)flowObject.getName())) continue;
            List list = flowObject.getProps().getNodeCheckRuleList();
            startPath = (String)flowObject.getGoOutPathes().get(0);
        }
        if (HussarUtils.isEmpty((Object)version) && HussarUtils.isNotEmpty((Object)(definitionModel = this.processDefinitionsService.getMainOrNew(processKey, null))) && HussarUtils.isEmpty((Object)version)) {
            version = definitionModel.getVersion();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysActHandleAuth::getProcessKey, (Object)processKey)).eq(SysActHandleAuth::getProcessVersion, (Object)version)).isNotNull(SysActHandleAuth::getExtendConfiguration);
        if (HussarUtils.isNotEmpty((Object)taskDefinitionKey)) {
            queryWrapper.eq(SysActHandleAuth::getTaskDefinitionKey, (Object)taskDefinitionKey);
        } else {
            queryWrapper.isNull(SysActHandleAuth::getTaskDefinitionKey);
        }
        List sysActHandleAuthList = this.sysActHandleAuthMapper.selectList((Wrapper)queryWrapper);
        String rejectExtendConfiguration = null;
        for (SysActHandleAuth sysActHandleAuth : sysActHandleAuthList) {
            if (sysActHandleAuth.getHandleType().contains("Reject")) {
                rejectExtendConfiguration = sysActHandleAuth.getExtendConfiguration();
                continue;
            }
            commentSettings.add((Object)JSON.parseObject((String)sysActHandleAuth.getExtendConfiguration()));
        }
        if (HussarUtils.isNotEmpty(rejectExtendConfiguration)) {
            commentSettings.add((Object)JSON.parseObject(rejectExtendConfiguration));
        }
        if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
            for (FlowSequence flowSequence : paths) {
                if (!flowSequence.getInstanceKey().equals(startPath)) continue;
                taskDefinitionKey = flowSequence.getEnd().getKey();
                break;
            }
        }
        jsonObject.put("field", nodeVariableNames);
        jsonObject.put("nodeCheckRuleList", (Object)var11_12);
        jsonObject.put("commentSettings", (Object)commentSettings);
        jsonObject.put("nodeId", (Object)taskDefinitionKey);
        return jsonObject;
    }

    public JSONObject queryFormField(String processKey, String version, String processInstanceId, String taskId) {
        return this.queryFormField(processKey, version, processInstanceId, taskId, null);
    }

    private static /* synthetic */ String lambda$getProcessShowMsg$48(HistoricActivityInstance historicActivityInstance, String k) {
        return historicActivityInstance.getSubProcessName();
    }

    private static /* synthetic */ String lambda$getProcessShowMsg$45(HistoricActivityInstance historicActivityInstance, String k) {
        return historicActivityInstance.getSubProcessName();
    }

    static {
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_USER.getType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_CALL_ACTIVITY.getType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_SUB_PROCESS.getType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_USER.getVisitType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_CALL_ACTIVITY.getVisitType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_SUB_PROCESS.getVisitType());
    }
}

