/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.util.BpmMsgDetailBuildUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskStateType;

public class EntrustAssigneeCmd
implements Command<Void> {
    private DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getSpringContext().getBean(DataPushService.class);
    private HistoryService historyService = (HistoryService)BpmSpringContextHolder.getSpringContext().getBean(HistoryService.class);
    private BpmMsgPushService msgPushService = (BpmMsgPushService)BpmSpringContextHolder.getSpringContext().getBean(BpmMsgPushService.class);
    private RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getSpringContext().getBean(RepositoryService.class);
    private IFlowTaskService flowTaskService = (IFlowTaskService)BpmSpringContextHolder.getBean(IFlowTaskService.class);
    protected String taskId;
    protected String userId;
    protected String mandatary;
    protected boolean isAdd;
    protected boolean isSame;

    public EntrustAssigneeCmd(String taskId, String userId, String mandatary, boolean isAdd, boolean isSame) {
        this.taskId = taskId;
        this.userId = userId;
        this.mandatary = mandatary;
        this.isAdd = isAdd;
        this.isSame = isSame;
    }

    public Void execute(CommandContext commandContext) {
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        if (taskEntity.getAssignee() != null) {
            taskEntity.addCandidateUser(this.mandatary);
            List<Map<String, String>> userMapList = this.getAssigneeMapByTaskId(taskEntity, null);
            this.dataPushService.entrustDataPush((Task)taskEntity, this.userId, this.mandatary, userMapList);
        } else {
            if (this.isSame) {
                taskEntity.deleteCandidateUser(this.userId);
                List<Map<String, String>> userMapList = this.getAssigneeMapByTaskId(taskEntity, Arrays.asList(this.userId));
                this.dataPushService.entrustDataPush((Task)taskEntity, this.userId, null, userMapList);
                return null;
            }
            List identityLinks = taskEntity.getCandidates();
            if (HussarUtils.isNotEmpty((Object)this.userId)) {
                taskEntity.deleteCandidateUser(this.userId);
                taskEntity.addCandidateUsers(Arrays.asList(this.mandatary.split(",")));
                List<Map<String, String>> userMapList = this.getAssigneeMapByTaskId(taskEntity, Arrays.asList(this.userId));
                this.dataPushService.entrustDataPush((Task)taskEntity, this.userId, this.mandatary, userMapList);
            } else {
                ArrayList<String> users = new ArrayList<String>(Arrays.asList(this.mandatary.split(",")));
                ArrayList<String> currentUsers = new ArrayList<String>();
                for (IdentityLink identityLink : identityLinks) {
                    if (this.isAdd) {
                        users.remove(identityLink.getUserId());
                        continue;
                    }
                    taskEntity.deleteCandidateUser(identityLink.getUserId());
                    currentUsers.add(identityLink.getUserId());
                }
                if (!users.isEmpty()) {
                    ArrayList<Map<String, String>> userMapList;
                    taskEntity.addCandidateUsers(users);
                    if (this.isAdd) {
                        userMapList = this.getAssigneeMapByTaskId(taskEntity, null);
                        this.dataPushService.addUserDataPush(this.dataPush((Task)taskEntity, String.join((CharSequence)",", users), userMapList));
                        this.messagePush(taskEntity, users);
                    } else {
                        userMapList = new ArrayList();
                        for (String userId : users) {
                            HashMap<String, String> userMap = new HashMap<String, String>();
                            userMap.put("userId", userId);
                            userMapList.add(userMap);
                        }
                        this.entrustDataPush((Task)taskEntity, String.join((CharSequence)",", currentUsers), String.join((CharSequence)",", users), userMapList, taskEntity.getCreateTime(), new Date());
                    }
                }
            }
        }
        return null;
    }

    private DataPush dataPush(Task task, String userId, List<Map<String, String>> userMapList) {
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setUserId(userId);
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        dataPush.setSendUser(task.getSendUser());
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription(task.getTodoConfiguration());
        dataPush.setProcessInsId(task.getProcessInstanceId());
        dataPush.setBusinessKey(((TaskEntity)task).getProcessInstance().getBusinessKey());
        dataPush.setUserMapList(userMapList);
        return dataPush;
    }

    public void entrustDataPush(Task task, String userId, String consignee, List<Map<String, String>> userMapList, Date startTime, Date endTime) {
        this.messagePush((TaskEntity)task, new ArrayList<String>(Arrays.asList(consignee.split(","))));
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(task.getProcessInstanceId());
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setUserId(consignee);
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setStartOrganId(historicProcessInstance.getOrganId());
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            dataPush.setStartDate(startTime);
            dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
            dataPush.setTaskType(task.getTaskType());
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription(task.getTodoConfiguration());
            dataPush.setSendUser(task.getSendUser());
            dataPush.setProcessName(historicProcessInstance.getProcessDefinitionName());
            dataPush.setProcessInsId(task.getProcessInstanceId());
            dataPush.setUserMapList(userMapList);
            if (userId != null) {
                dataPush.setConsignor(userId);
                dataPush.setEndDate(endTime);
            }
            this.dataPushService.entrustDataPush(dataPush);
        }
    }

    private void messagePush(TaskEntity taskEntity, List<String> users) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = BpmMsgDetailBuildUtil.taskMsgDetail((TaskEntity)taskEntity, users, (String)"todo");
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }

    private List<Map<String, String>> getAssigneeMapByTaskId(TaskEntity taskEntity, List<String> users) {
        List identityLinkList = taskEntity.getCandidates();
        if (HussarUtils.isNotEmpty(users)) {
            identityLinkList.removeIf(identityLink -> users.contains(identityLink.getUserId()));
        }
        ArrayList<Map<String, String>> userMaps = new ArrayList<Map<String, String>>();
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink2 : identityLinkList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", identityLink2.getUserId());
                if (TaskStateType.isEntrust((IdentityLink)identityLink2)) {
                    map.put("mandator", identityLink2.getMandator());
                    map.put("taskState", identityLink2.getTaskState());
                }
                userMaps.add(map);
            }
        }
        return userMaps;
    }
}

