/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.todomanager.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskManageQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.dto.TransferDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5f85\u529e\u7ba1\u7406"})
@RequestMapping(value={"/bpm/todoManager"})
public class TodoManagerController {
    private final Logger logger = LoggerFactory.getLogger(TodoManagerController.class);

    @GetMapping(value={"/todoList"})
    @ApiOperation(value="\u5f85\u529e\u67e5\u8be2", notes="\u5f85\u529e\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u5f85\u529e\u7ba1\u7406", eventDesc="\u5f85\u529e\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<?>> list(Page<?> pages, TaskManageQueryDto taskManageQueryDto) {
        String userId = taskManageQueryDto.getUserId();
        String processKey = taskManageQueryDto.getProcessKey();
        String sendUserId = taskManageQueryDto.getSendUserId();
        String message = taskManageQueryDto.getMessage();
        String startTime = taskManageQueryDto.getStartTime();
        String endTime = taskManageQueryDto.getEndTime();
        String taskType = taskManageQueryDto.getTaskType();
        String processTitle = taskManageQueryDto.getProcessTitle();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskDto flowTaskDto = new FlowTaskDto();
        flowTaskDto.setUserId(userId);
        flowTaskDto.setProcessKey(processKey);
        flowTaskDto.setTodoConfiguration(message);
        flowTaskDto.setSendUserId(sendUserId);
        flowTaskDto.setStartTime(start);
        flowTaskDto.setEndTime(end);
        flowTaskDto.setTaskType(taskType);
        flowTaskDto.setPage(Long.valueOf(pages.getCurrent()));
        flowTaskDto.setSize(Long.valueOf(pages.getSize()));
        flowTaskDto.setProcessTitle(processTitle);
        BpmResponseResult bpmResponseResult = TaskEngineService.queryToDoList((FlowTaskDto)flowTaskDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @PostMapping(value={"/transferTask"})
    public ApiResponse<Long> transferTask(@RequestBody TransferDto transferDto) {
        if (HussarUtils.isEmpty((Object)transferDto.getUserId())) {
            transferDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        transferDto.setTransferType("1");
        return this.transferTaskReturn(TaskEngineService.transferTask((TransferDto)transferDto));
    }

    private <T> ApiResponse<T> transferTaskReturn(BpmResponseResult bpmResponseResult) {
        if (bpmResponseResult.isSuccess()) {
            Object t = HussarUtils.isNotEmpty((Object)bpmResponseResult.getResult()) ? bpmResponseResult.getResult().get(0) : null;
            return ApiResponse.success((Object)t);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }
}

