/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.listener.WorkflowListenerUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="DefaultCloudTaskListener")
public class DefaultTaskListener
implements TaskListener {
    private Logger logger = LogManager.getLogger(DefaultTaskListener.class);
    private static RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getBean(RepositoryService.class);
    private static ModelService modelService = (ModelService)BpmSpringContextHolder.getBean(ModelService.class);

    private <T> T getTempVar(DelegateTask delegateTask, String varName) {
        return (T)((ExecutionEntity)delegateTask.getExecution()).getLocalTempVariable(varName);
    }

    public void notify(DelegateTask delegateTask) {
        BpmnModel bm = repositoryService.getBpmnModel(delegateTask.getProcessDefinitionId());
        FlowElement flowElement = bm.getFlowElement(delegateTask.getTaskDefinitionKey());
        String beanId = (String)this.getTempVar(delegateTask, "beanId");
        String listenerModel = (String)this.getTempVar(delegateTask, "listenerModel");
        String requestMethod = (String)this.getTempVar(delegateTask, "requestMethod");
        String processDefinitionId = delegateTask.getProcessDefinitionId();
        String processDefinitionKey = processDefinitionId.split(":")[0];
        String businessId = ((TaskEntity)delegateTask).getProcessInstance().getBusinessKey();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nodeId", delegateTask.getTaskDefinitionKey());
        map.put("nodeName", flowElement.getName());
        map.put("businessId", businessId);
        map.put("processInsId", delegateTask.getProcessInstanceId());
        map.put("processDefinitionId", delegateTask.getProcessDefinitionId());
        map.put("processKey", delegateTask.getProcessDefinitionId().split(":")[0]);
        map.put("appId", modelService.getAppId(delegateTask.getProcessDefinitionId().split(":")[0]));
        HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(delegateTask.getProcessInstanceId());
        if (historicProcessInstance != null) {
            map.put("starter", historicProcessInstance.getStartUserId());
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("processName", ((ExecutionEntity)delegateTask.getExecution()).getProcessDefinition().getName());
        map.put("taskId", delegateTask.getId());
        Object info = Context.getCommandContext().getAttribute("listenerParam");
        ParamModel paramModel = (ParamModel)info;
        if ("complete".equals(delegateTask.getEventName())) {
            String tasksourceFlag = BpmAttribute.getTaskSourceFlag((ActivityExecution)((TaskEntity)delegateTask).getExecution());
            if (HussarUtils.isNotEmpty((Object)paramModel)) {
                map.put("completeType", paramModel.getCompleteType());
                map.put("deleteType", paramModel.getDeleteType());
                map.put("createTime", simpleDateFormat.format(delegateTask.getCreateTime()));
                map.put("endTime", paramModel.getEndTime());
                map.put("sourcesTaskDefinitionIds", paramModel.getFrom());
                map.put("targetIds", paramModel.getTo());
                map.put("targetNodeAssignee", paramModel.getTargetAssignee());
                map.put("affectedNodeId", paramModel.getAffectedNodeId());
                map.put("assignee", paramModel.getHandler());
            } else {
                map.put("completeType", tasksourceFlag == null ? null : tasksourceFlag.toString());
                map.put("assignee", delegateTask.getAssignee());
            }
        } else if ("create".equals(delegateTask.getEventName())) {
            List identityLinks = ((TaskEntity)delegateTask).getIdentityLinks();
            StringBuilder assignee = new StringBuilder();
            for (IdentityLinkEntity identity : identityLinks) {
                assignee.append(",").append(identity.getUserId());
            }
            if (HussarUtils.isNotEmpty((Object)assignee.toString())) {
                assignee = new StringBuilder(assignee.substring(1));
            }
            map.put("assignee", assignee.toString());
            String tasksourceFlag = BpmAttribute.getTaskSourceFlag((ActivityExecution)((TaskEntity)delegateTask).getExecution());
            if (HussarUtils.isNotEmpty((Object)paramModel)) {
                if (!map.containsKey("starter")) {
                    map.put("starter", paramModel.getStarter());
                }
                map.put("sendUser", paramModel.getSendUser());
                map.put("createReason", paramModel.getCreateReason());
                map.put("lastNodeId", paramModel.getLastNodeId());
                map.put("lastTaskId", paramModel.getLastTaskId());
                map.put("lastNodeName", paramModel.getLastNodeName());
                map.put("lastCompleteType", paramModel.getLastCompleteType());
                map.put("lastNodeAssignee", paramModel.getLastNodeHandler());
            } else {
                map.put("createReason", tasksourceFlag != null ? tasksourceFlag.toString() : null);
            }
            map.put("createTime", simpleDateFormat.format(new Date()));
        }
        if (beanId != null) {
            String serviceName = String.valueOf(modelService.getServiceName(processDefinitionKey));
            try {
                WorkflowListenerUtils.executionListener(listenerModel, requestMethod, beanId, map, serviceName);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                throw new BpmException(BpmExceptionCodeEnum.ERROR_ACCESS_TASK_LISTENER);
            }
        }
    }
}

