/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.general.calendar.service.ISysCalendarRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAssigneeSaveTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstancePercentUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.RevokeAddHistoryTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;

public class MultiInstanceRevokeTaskCmd
implements Command<Void> {
    private HistoricTaskInstance currTask;
    private String comment;
    private Date endTime;
    private ProcessEngine processEngine = (ProcessEngine)BpmSpringContextHolder.getSpringContext().getBean(ProcessEngine.class);
    private Map<String, Object> paramMap;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)BpmSpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ISysActEntrustService entrustService = (ISysActEntrustService)BpmSpringContextHolder.getBean(ISysActEntrustService.class);
    private static ISysCalendarRefService sysCalendarRefService = (ISysCalendarRefService)BpmSpringContextHolder.getSpringContext().getBean(ISysCalendarRefService.class);

    public MultiInstanceRevokeTaskCmd(HistoricTaskInstance currTask, String comment, Date endTime) {
        this.currTask = currTask;
        this.comment = comment;
        this.endTime = endTime;
    }

    public MultiInstanceRevokeTaskCmd(HistoricTaskInstance currTask, String comment, Map<String, Object> paramMap, Date endTime) {
        this.currTask = currTask;
        this.comment = comment;
        this.endTime = endTime;
        this.paramMap = paramMap;
    }

    public Void execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        RuntimeService runtimeService = pec.getRuntimeService();
        RepositoryService repositoryService = pec.getRepositoryService();
        ExecutionEntity execution = (ExecutionEntity)runtimeService.createExecutionQuery().processInstanceId(this.currTask.getProcessInstanceId()).activityId(this.currTask.getTaskDefinitionKey()).list().get(0);
        TaskDefinition taskDefinition = null;
        for (ExecutionEntity executionEntity : execution.getParent().getExecutions()) {
            if (!HussarUtils.isNotEmpty((Object)executionEntity.getTasks())) continue;
            taskDefinition = ((TaskEntity)executionEntity.getTasks().get(0)).getTaskDefinition();
        }
        IdGenerator idGenerator = pec.getIdGenerator();
        execution = execution.getParent().createExecution();
        execution.setActive(true);
        execution.setConcurrent(true);
        execution.setScope(false);
        TaskEntity taskEntity = new TaskEntity();
        taskEntity.setNewTask(true);
        taskEntity.copyTaskProperty((TaskInfo)this.currTask);
        taskEntity.setNameTranslateKey(this.currTask.getNameTranslateKey());
        taskEntity.setVariableInstances();
        taskEntity.setCreateTime(new Date());
        taskEntity.setTaskDefinition(taskDefinition);
        taskEntity.setFormId(this.currTask.getFormId());
        taskEntity.setExecutionId(execution.getId());
        taskEntity.setCompleteType(BpmAttribute.getTaskSourceFlag((ActivityExecution)execution));
        String taskId = idGenerator.getNextId();
        taskEntity.setId(taskId);
        taskEntity.setExecution(execution);
        Map entrustMap = this.entrustService.queryByUsers(Collections.singletonList(this.currTask.getOriginalAssignee()), this.currTask.getProcessDefinitionId().split(":")[0], this.currTask.getTaskDefinitionKey(), 0);
        if (HussarUtils.isEmpty((Object)entrustMap)) {
            taskEntity.addCandidateUser(this.currTask.getOriginalAssignee(), null, null, null, this.currTask.getAddAssigneeOperator());
        } else {
            taskEntity.addEntrustAssistAddAssigneeCandidateUser(entrustMap, null, this.currTask.getAddAssigneeOperator());
        }
        BpmnModel bm = commandContext.getProcessEngineConfiguration().getDeploymentManager().getBpmnModelById(this.currTask.getProcessDefinitionId());
        FlowElement element = bm.getFlowElement(this.currTask.getTaskDefinitionKey());
        TimeOutConfig timeOutConfig = TimeOutConfig.build(element);
        MultiInstanceRevokeTaskCmd.setDueDate(taskEntity, timeOutConfig, execution, (TaskInfo)this.currTask);
        MultiInstanceRevokeTaskCmd.setWarningDate(taskEntity, timeOutConfig, execution, (TaskInfo)this.currTask);
        List<TimeOutModel> timeOutModels = timeOutConfig.buildTimeOutModel(taskEntity, Collections.singleton(this.currTask.getAssignee()), null);
        this.activityRedisTimerService.addTimeOutModels(timeOutModels);
        this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeSaveTaskCmd((Task)taskEntity, (Execution)taskEntity.getExecution()));
        int nrOfCompletedInstances = MultiInstancePercentUtils.getLoopVariable(execution, "nrOfCompletedInstances");
        int nrOfActiveInstances = MultiInstancePercentUtils.getLoopVariable(execution, "nrOfActiveInstances");
        MultiInstancePercentUtils.setLoopVariable(execution, "nrOfCompletedInstances", nrOfCompletedInstances - 1);
        MultiInstancePercentUtils.setLoopVariable(execution, "nrOfActiveInstances", nrOfActiveInstances + 1);
        this.processEngine.getManagementService().executeCommand((Command)new RevokeAddHistoryTaskCmd(execution, this.comment, this.paramMap, this.currTask.getEndTime(), this.currTask.getAssignee()));
        return null;
    }

    private static void setWarningDate(TaskEntity taskEntity, TimeOutConfig timeOutConfig, ExecutionEntity ee, TaskInfo copy) {
        String warningDateConfig = timeOutConfig.getWarningDate();
        if (HussarUtils.isNotEmpty((Object)warningDateConfig) && HussarUtils.isNotEmpty((Object)taskEntity.getDueDate())) {
            String warningDateType = timeOutConfig.getWarningDateType();
            if ("workingDay".equals(warningDateType)) {
                Date date = taskEntity.getDueDate();
                Instant instant = date.toInstant();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                LocalDateTime dueTime = sysCalendarRefService.getBeginDateDefult(localDateTime, warningDateConfig, true);
                ZonedDateTime zonedDateTime = dueTime.atZone(ZoneId.systemDefault());
                Instant instant2 = zonedDateTime.toInstant();
                Date warningDate = Date.from(instant2);
                taskEntity.setWarningDate(warningDate);
            } else {
                Date warningDate = TimeOutConfig.getWarningDate((ActivityExecution)ee, warningDateConfig, taskEntity.getDueDate());
                taskEntity.setWarningDate(warningDate);
            }
        }
    }

    private static void setDueDate(TaskEntity taskEntity, TimeOutConfig timeOutConfig, ExecutionEntity ee, TaskInfo copy) {
        Expression activeDueDateExpression = taskEntity.getTaskDefinition().getDueDateExpression();
        if (activeDueDateExpression != null) {
            String chosenDay = timeOutConfig.getChosenDay();
            if ("workingDay".equals(chosenDay)) {
                Date date = new Date();
                Instant instant = date.toInstant();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                LocalDateTime dueTime = sysCalendarRefService.getDueDateDefult(localDateTime, String.valueOf(activeDueDateExpression), true);
                ZonedDateTime zonedDateTime = dueTime.atZone(ZoneId.systemDefault());
                Instant instant2 = zonedDateTime.toInstant();
                Date dueDate = Date.from(instant2);
                taskEntity.setDueDate(dueDate);
            } else {
                Object dueDate = activeDueDateExpression.getValue((VariableScope)ee);
                if (dueDate != null) {
                    if (dueDate instanceof Date) {
                        taskEntity.setDueDate((Date)dueDate);
                    } else if (dueDate instanceof String) {
                        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(taskEntity.getTaskDefinition().getBusinessCalendarNameExpression().getValue((VariableScope)ee).toString());
                        taskEntity.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
                    } else {
                        throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeDueDateExpression.getExpressionText());
                    }
                }
            }
        }
    }
}

